---
title: GitHubトレードマークポリシー
redirect_from:
  - /articles/github-trademark-policy
versions:
  free-pro-team: '*'
---

### 何をすると GitHub トレードマークポリシーの違反になるのですか？

会社や事業の名前、ロゴ、または他の商標で保護された素材を、そのブランドや会社の所属に関して他者を誤解させたり混乱させたりする方法で使用することは、トレードマークポリシーの違反と見なされる場合があります。

### GitHub トレードマークポリシーの違反にならないことは？

商標が付与された製品やサービスとは関係のない方法で他人の商標を使用しても、トレードマークポリシーの違反にはなりません。 GitHub のユーザ名は先着順で提供され、予約することはできません。 GitHub アカウントのユーザ名が登録商標と偶然同じになった場合、それ自体がトレードマークポリシーの違反になるわけではありません。

### トレードマークポリシーの違反の報告があった場合、GitHub はどのように対応しますか？

連邦または国際商標登録の所有者からトレードマークポリシー違反の報告を受け取った場合、当社はアカウントを確認し、次の措置を講じることがあります。

* 商標の不正使用によって他者を欺く意図が明確である場合、GitHub はアカウントをサスペンドし、アカウント所有者に通知します。
* アカウントがユーザを混乱させているように見えても、商標登録された商品やサービスを意図的に偽装しているわけではないと判断した場合、当社はアカウント所有者に混乱の恐れを解消する機会を与えます。 また、商標権者が使用できるように当社はユーザ名を解放する場合があります。

### トレードマークポリシーの違反を報告するには？

トレードマークポリシー違反の可能性がある場合、登録商標の所有者は[連絡フォーム](https://support.github.com/contact)から GitHub に報告できます。 商標関連のリクエストを送信する場合は、商標を所有する会社のメールアドレスをお使いください。また、当社が迅速に対応できるよう、以下の情報をすべて記載してください。 また、アカウントが商標と混同される理由や、アカウントによって商標が毀損される理由を明確に説明してください。

### トレードマークポリシーの違反を報告する際に必要な情報は？

トレードマークポリシーの違反を調査する際に必要になる、次のすべての情報を提供してください。

* 対象アカウントのユーザ名
* あなたの会社名
* あなたの会社の GitHub アカウント（お持ちの場合）
* 会社のウェブサイト
* 商標登録された単語や記号など
* 商標登録番号
* 商標登録局（USPTO など）
* 混同についての説明（あなたの会社になりすましている、など。コンテンツや行動の具体的な説明を含めてください）
* 要求する措置（違反アカウントの削除や、商標登録されたユーザ名の既存の会社アカウントへの移譲など）
* "I have a good faith belief that use of the trademark described above is not authorized by the trademark owner, or its agent, or the law. I have taken nominative and other fair uses into consideration."（私は、商標権者、その代理人、または法律により、上記の商標の使用が許可されていないことを確信しています。ノミネート使用などのフェアユースの可能性も検討しましたが、フェアユースには該当しません。） という文言を含めてください。
* "I swear, under penalty of perjury, that the information in this notification is accurate and that I am the copyright owner, or am authorized to act on behalf of the owner, of an exclusive right that is allegedly infringed."（私は、偽証罪の罰則に基づき、この通知の情報は正確であり、私が侵害が申し立てられる排他的権利の商標権者であるか、商標権者に代わって行動することが認められている者であることを誓います。）という文言も含めてください。
* 物理的または電子的な署名を含めてください。

* 注：連邦または国際商標登録番号が必要です。 報告する名前が登録商標では**ない**場合（政府機関や非営利団体など）は、以下をお知らせください。
    * あなたの氏名
    * 職名
    * 住所
    * Phone
    * メールアドレス（会社のドメインのものである必要があります）
