---
title: GitHubのマイクロソフトボリュームライセンスに関する規約
redirect_from:
  - /articles/GitHub-Supplemental-Terms-for-Microsoft-Volume-Licensing/
  - /articles/github-supplemental-terms-for-microsoft-volume-licensing
versions:
  free-pro-team: '*'
---

Version Effective Date: July 20, 2020

The following GitHub Supplemental Terms (including any applicable Order Forms) supplement Customer's Microsoft volume licensing agreement ("**Microsoft Customer Agreement**") and, together with the Microsoft Customer Agreement, govern Customer's use of the Products (as defined below). The Microsoft Customer Agreement is incorporated herein by this reference.  Capitalized terms used but not defined in these supplemental terms have the meanings assigned to them in the Microsoft Customer Agreement.

These Supplemental Terms apply to the following GitHub Offerings, as further defined below (collectively, the "**Products**"):

-   GitHub Enterprise (comprised of GitHub Enterprise Server, which may include Add-on Software, and GitHub Enterprise Cloud) and GitHub One;

-   関連するすべての「サポート」、

-   関連するすべての「プロフェッショナルサービス」。

These GitHub Supplemental Terms include the following Sections and Exhibits, each of which is incorporated by reference herein:

* セクション 1: GitHub Enterprise Server ライセンス規約

* セクション 2: GitHub Enterprise Cloud 利用規約

* SECTION 3: General Provisions; and

* EXHIBIT A: Definitions.



## セクション 1: GitHub Enterprise Server ライセンス規約

セクション 1 は、お客様による「ソフトウェア」の利用に適用される規約を詳述しています。

### 1.1 ライセンスの付与

GitHub は、お客様の内部業務目的のために「ソフトウェア」をインストールし利用するため、該当する「プラン契約期間」中、「ドキュメンテーション」に従い、お客様の「注文書」に記載された数の「プランライセンス」のみ、お客様の内部業務目的のために「ソフトウェア」をインストールし利用するための非独占的、譲渡不可、世界的規模、使用料無料の期間限定ライセンスをお客様に付与します。 「ソフトウェア」には、第三者によって GitHub にライセンスを付与されたコンポーネントが含まれており、そうしたソフトウエアの中には、GitHub に対して、それらのコンポーネントのソースコードを入手可能にすることを要求するソフトウェアも含まれています。 これらのコンポーネントのソースコードは、要請に応じて提供いたします。 Without limiting the foregoing, this license permits Customer to download and run Microsoft SQL Server Standard Edition container image for Linux files (“**SQL Server Images**”), which may be used only with the Software as documented. Customer’s right to use the SQL Server Images ends when Customer no longer has rights to use the Software, and Customer must uninstall the SQL Server Images when its right to use them ends. Microsoft Corporation may disable SQL Server Images at any time.

### 1.2 Restrictions.

Except as expressly permitted by law or by applicable third-party license, Customer and its Affiliates must not and must not allow any third party to: (i) sublicense, sell, rent, lease, transfer, assign, or redistribute the Software; (ii) host the Software for the benefit of third parties; (iii) disclose or permit any third party to access the Software, except as expressly permitted in this Section 1; (iv) hack or modify the License Key, or avoid or change any license registration process; (v) except for Customer Modifications, modify or create derivative works of the Software, or merge the Software with other software; (vi) disassemble, decompile, bypass any code obfuscation, or otherwise reverse engineer the Software or attempt to derive any of its source code, in whole or in part; (vii) modify, obscure, or delete any proprietary rights notices included in or on the Software or Documentation; or (viii) otherwise use or copy the Software or Documentation in a manner not expressly permitted by these GitHub Supplemental Terms.

### 1.3 Delivery.

GitHub は、安全で、パスワードで保護されたウェブサイトから、お客様が「ライセンスキー」をダウンロードで入手できるようにするものとします。 All deliveries under this Section 1 will be electronic. 疑義を避けるため、お客様はソフトウェアのインストールに責任を負い、「ライセンスキー」の交付後は、GitHub がその「ソフトウェア」についてそれ以上のデリバリを行う義務を負わないことを認めます。 「アップデート」が入手可能になった際、GitHub はその「アップデート」を同一のウェブサイトからダウンロードできるようにするものとします。 お客様は、最低限 1 年に 1 回以上、商業的に合理的な頻度で「ソフトウェア」を「アップデート」する必要があります。 お客様は、お客様のユーザ名とパスワードの機密性を維持する責任を負います。

### 1.4 Verification.

At GitHub's request, Customer will promptly provide GitHub with a Software-generated report verifying that Customer is using the Software in accordance with these GitHub Supplemental Terms. GitHub will invoice Customer for any additional use, effective from the date its use first exceeded the terms of these GitHub Supplemental Terms.

### 1.5 Support

GitHub will provide technical support for the Software as further described in the Microsoft Customer Agreement. GitHub may provide enhanced Support offerings for the Software and Service (including the Premium, Premium Plus, and Engineering Direct Support offerings) in accordance with the [Support terms](/enterprise/admin/enterprise-support/about-github-premium-support-for-github-enterprise), and at the Support level, Fees, and Subscription Term specified in an Order Form or SOW. Notwithstanding anything to the contrary in the Microsoft Customer Agreement, (i) GitHub will use reasonable efforts to correct any material, reproducible errors in the Software upon Customer's notification of an error but will not be responsible for providing Support where (a) someone (other than GitHub) modifies the Software; (b) Customer changes its operating system or environment in a way that adversely affects the Software or its performance; (c) Customer uses the Software in a manner other than as authorized under the Microsoft Customer Agreement, this Section 1 or the Documentation; or (d) there is a Customer accident or negligence, or misuse of the Software; and (ii) GitHub will only Support a given Release for one (1) year from the original Release date, or six (6) months from the last Update of the Release, whichever is longer.

### 1.6 Updates; Releases.

#### 1.6.1 Generally.

GitHub は、「ソフトウェア」に対する「アップデート」および「リリース」を、お客様が「ソフトウェア」および「ライセンスキー」をダウンロードした場所と同一の安全なウェブサイトにおいてお客様が入手できるようにするものとします。

#### 1.6.2 Supported Releases.

GitHub は、「ソフトウェア」の特定の「リリース」について、元の「リリース」日から 1 年間、または直近の「リリース」の「アップデート」から 6 か月のうち長い方の期間のみ「サポート」します。 GitHub は、「ソフトウェア」の特定の「リリース」について、元の「リリース」日から 1 年間、または直近の「リリース」の「アップデート」から 6 か月のうち長い方の期間のみ「サポート」します。

### 1.7 Add-On Software.

「アドオンソフトウェア」のライセンスは、「ユーザ」ごとに付与されます。 For the avoidance of doubt, and unless otherwise set forth in an Order Form, the number of Subscription Licenses Customer has at any given time for Add-On Software must equal the number of Subscription Licenses Customer has for the Products under this Agreement. For example, if Customer wishes to purchase a subscription to Insights and already holds Subscription Licenses for 100 Users for the Products, it must purchase Subscription Licenses for 100 Users for Insights.

### 1.8 Data Protection Considerations for Use of GitHub Insights and Learning Lab for Enterprise Server.

If Customer’s planned use of GitHub Insights or Learning Lab for Enterprise Server involves processing personal data, Customer is solely responsible for determining whether or not to complete a data protection impact assessment or otherwise secure formal legal analysis of Customer’s planned use. It is in Customer’s sole discretion whether to use GitHub Insights or Learning Lab for Enterprise Server to process Customer’s employees’ and/or users’ data, and if Customer does so, Customer is solely responsible for conducting such processing in compliance with applicable law.

### 1.9 Limited Software Warranty.

GitHub warrants that, for ninety (90) days from the date it is made available for initial download, the unmodified Software will substantially conform to its Documentation. GitHub does not warrant that Customer's use of the Software will be uninterrupted, or that the operation of the Software will be error-free. This warranty will not apply if Customer modifies or uses the Software in any way that is not expressly permitted by this Section 1 and the Documentation. GitHub's only obligation, and Customer's only remedy, for any breach of this limited warranty will be as set forth in the Microsoft Customer Agreement.

## SECTION 2: GITHUB ENTERPRISE CLOUD TERMS OF SERVICE

Upon creation of a Corporate Account and/or an Organization on the Service by Customer or by GitHub on Customer’s behalf, this Section 2 details terms applicable to Customer’s use of the Service.

### 2.1 Account Terms.

#### 2.1.1 Account Controls.

  **(i) ユーザ。**お客様は、「ユーザ」が各自のアカウントおよびアカウント内の「コンテンツ」に対する最終的な管理権限を保持することに同意するものとします。 [GitHub's Standard Terms of Service](/github/site-policy/github-terms-of-service) govern Users' use of the Service, except with respect to Users' activities under this Section 2.

  **(ii) Organizations.** Customer retains ultimate administrative control over any Organization created on Customer’s behalf and User-Generated Content posted to the repositories within its Organization(s), subject to this Section 2. This Section 2 will govern the use of Customer’s Organization(s).

#### 2.1.2 Account Requirements.

お客様がアカウントを作成するには、以下を遵守する必要があります:

**(i)** お客様は、13歳未満が利用するためのアカウントを作成してはなりません。 GitHub が 13歳未満の「ユーザ」を知った場合には、その「ユーザ」のアカウントを直ちに削除します。 お客様またはその「ユーザ」が米国外に居住する場合には、その国に適用される最低年齢が 13 歳以上である場合があります。かかる場合、お客様はその国の法律に従う責任を負います。

**(ii)** 「ユーザ」は、ログインを複数人で共有することはできません。

**(iii)** Customer must not use the Service (a) in violation of export control or sanctions laws of the United States or any other applicable jurisdiction, (b) if it is located in or ordinarily resident in a country or territory subject to comprehensive sanctions administered by the U.S. Office of Foreign Assets Control (OFAC), or (c) if Customer is or is working on behalf of a [Specially Designated National (SDN)](https://www.treasury.gov/resource-center/sanctions/SDN-List/Pages/default.aspx) or a person subject to similar blocking or denied party prohibitions. For more information, please see [GitHub’s Trade Controls policy](/github/site-policy/github-and-trade-controls).

#### 2.1.3 Account Security.

お客様は、以下に対して責任を負います。(i) お客様の「企業アカウント」における、投稿された「コンテンツ」およびアクティビティの全て、(ii) お客様のアカウントのログイン認証情報に関するセキュリティの維持、(iii) お客様のアカウントを通じた、「サービス」のあらゆる不正利用や不正アクセスを認識した際には、速やかに[GitHub に通知](https://support.github.com/contact)すること。  GitHub will not be liable for any loss or damage from Customer’s failure to comply with this Section 2.1.3.

#### 2.1.4 Additional Terms.

場合によっては、お客様による「サービス」の利用について、第三者による条項が適用されることがあります。 たとえば、お客様が独自の条項またはライセンス契約を持つ Organization の成員である場合、お客様が「サービス」に統合するアプリケーションをダウンロードしている場合、お客様が他のサービスに認証するために「サービス」を利用している場合などです。 While the Microsoft Customer Agreement, including these GitHub Supplemental Terms, are GitHub's full agreement with Customer, other parties' terms govern their relationships with Customer.

#### 2.1.5 米国連邦政府の条項 米国連邦政府の条項.

If Customer is a U.S. federal government agency or otherwise accessing or using any portion of the Service in a government capacity, the [U.S. Federal Government Amendment](/github/site-policy/amendment-to-github-terms-of-service-applicable-to-us-federal-government-users) applies, and Customer agrees to its provisions.

### 2.2 Compliance with Laws; Acceptable Use; Privacy.

#### 2.2.1 Compliance with Laws and Regulations.

お客様が「サービス」を使用する際には、著作権法、商標法、輸出規制法、または管轄における規制を含むいかなる適用法にも違反してはなりません。

#### 2.2.2 Acceptable Use.

Customer’s use of the Service must comply with [GitHub's Acceptable Use Policies](/github/site-policy/github-acceptable-use-policies) and [GitHub’s Community Guidelines](/github/site-policy/github-community-guidelines). お客様は、いかなる管轄区域内でも、違法、わいせつ、不快、または詐欺的なコンテンツまたは活動 (損害を与えたりそう標榜したりする、ネットワークまたはシステムの完全性またはセキュリティを妨害または侵害する、フィルタを回避する、迷惑・虐待的・虚偽的なメッセージ、ウイルスまたは有害なコードを送信する、あるいは第三者の権利を侵害するなど) の目的で「サービス」を使用してはなりません。

#### 2.2.3 Privacy.
[The GitHub Privacy Statement](/github/site-policy/github-privacy-statement) and the [GitHub Data Protection Addendum](/github/site-policy/github-data-protection-addendum) provide detailed notice of GitHub's privacy and data use practices as well as GitHub's processing and security obligations with respect to Customer Personal Data. Any person, entity, or service collecting data from the Service must comply with the [GitHub Privacy Statement](/github/site-policy/github-privacy-statement), particularly in regards to the collection of Users' Personal Information (as defined in the GitHub Privacy Statement). お客様がGitHubから「ユーザ個人情報」を収集した場合、お客様は「外部ユーザ」が承認した目的にのみその個人情報を使用するものとします。 お客様は、かかる個人情報を合理的に保護するものとし、GitHubはGitHubまたは「外部ユーザ」からの苦情、削除要請、および連絡拒否の要請に速やかに対応するものとします。

### 2.3 Content Responsibility; Ownership; License Rights.

#### 2.3.1 Responsibility for User-Generated Content.
「サービス」の利用中に、お客様は「ユーザ生成コンテンツ」を作成またはアップロードすることができます。 投稿、アップロード、リンク、その他の方法でお客様が「サービス」を介して利用できるようにした「ユーザ生成コンテンツ」については、その「ユーザ生成コンテンツ」の形式にかかわらず、お客様が全責任を負うものとします。 GitHubは、「ユーザ生成コンテンツ」のいかなる公開表示または悪用に対しても責任を負いません。

#### 2.3.2 Ownership of Content, Right to Post, and License Grants.

**(i)** お客様が作成または所有する「お客様のコンテンツ」の所有権は、お客様が保持します。 お客様は、 (a)「お客様のコンテンツ」に責任を負うこと、 (b) お客様が投稿する権利を有する「お客様のコンテンツ」(サードパーティまたはユーザーが生成したコンテンツを含む) に限って送信すること、(c) お客様が投稿する「お客様のコンテンツ」に関サードパーティのライセンスに完全に従うことに同意するものとします。

**(ii)** Customer grants the rights set forth in Sections 2.3.3 through 2.3.6, free of charge and for the purposes identified in those sections until such time as Customer removes Customer Content from GitHub servers, except for Content Customer has posted publicly and that External Users have Forked, in which case the license is perpetual until such time as all Forks of Customer Content have been removed from GitHub servers. お客様が、「サービス」を実行するために必要な権限をGitHubに付与するライセンスをあらかじめ伴うような「お客様のコンテンツ」をアップロードする場合、追加のライセンスは必要ありません。

#### 2.3.3 License Grant to GitHub.
お客様は、「お客様のコンテンツ」を保存、解析、表示し、「サービス」の提供に必要な限りにおいて付随的な複製を作成する権利をGitHubに付与します。 これには、「お客様のコンテンツ」をGitHubのデータベースにコピーし、バックアップを作成する権利、お客様およびお客様が閲覧者として選択した相手に「お客様のコンテンツ」を表示する権利、「お客様のコンテンツ」を解析して検索インデックスを作成するなどの形でGitHubのサーバ上で分析する権利、お客様がコンテンツの共有相手として選択した外部ユーザーと「お客様のコンテンツ」を共有する権利、および音楽や動画のような場合に「お客様のコンテンツ」を実演する権利が含まれます。 これらの権利は、パブリックリポジトリとプライベートリポジトリの両方に適用されます。 このライセンスは、「お客様のコンテンツ」を販売またはその他の方法で配布する、あるいは「サービス」以外で使用する権利をGitHubに付与するものではありません。 お客様は、帰属先を明示せず、また「サービス」の提供に必要な限りにおいて「お客様のコンテンツ」を合理的に適応させる目的で、「お客様のコンテンツ」に必要な権利をGitHubに付与します。

#### 2.3.4 License Grant to External Users.
**(i)** Issue、コメント、外部ユーザのリポジトリへのコントリビューションなど、お客様が公に投稿するコンテンツは、他のユーザーが閲覧することができます。 リポジトリを公開表示に設定することで、お客様は外部ユーザがお客様のリポジトリを閲覧しフォークすることを許可するものとします。

**(ii)** お客様がそのページおよびリポジトリを一般に公開表示に設定する場合、お客様は「サービス」を通じて「お客様のコンテンツ」を使用、表示、および実演し、またGitHub が提供する機能を通じて許可される限りにおいて (フォークなど) のみ「サービス」上でお客様のコンテンツを複製する、非独占的かつ世界的ライセンスを外部ユーザーに付与します。 Customer may grant further rights to Customer Content if Customer [adopts a license](/github/building-a-strong-community/adding-a-license-to-a-repository#including-an-open-source-license-in-your-repository). お客様が作成または所有していない「お客様のコンテンツ」をアップロードする場合には、アップロードする「お客様のコンテンツ」が、これらの権限を外部ユーザーに付与する条項に基づいて必ずライセンスされるよう図る責任をお客様は負います。

#### 2.3.5 Contributions Under Repository License.
お客様がライセンスの通知を含むリポジトリに対してコントリビューションを行う際、お客様は必ず同じ条件のもとでそのコントリビューションをライセンスし、それらの条件下でかかるコントリビューションをライセンスする権利を有することに同意するものとします。 お客様が、コントリビューターライセンス契約など、異なる条件のもとでコントリビューションのライセンスを別途締結している場合は、その契約が優先されます。

#### 2.3.6 Moral Rights.
お客様は、完全性と帰属の権利も含めて、「サービス」の任意の部分に対してアップロード、公開、またはサブミットする「お客様のコンテンツ」について、すべての人格権を保持します。 However, Customer waives these rights and agrees not to assert them against GitHub, solely to enable GitHub to reasonably exercise the rights granted in Section 2.3, but not otherwise.

### 2.4 Private Repositories.

#### 2.4.1 Control.

お客様は、招待、OrganizationおよびTeamの管理制御、アクセスの終了など、プライベートリポジトリへのアクセスを管理する責任を負います。

#### 2.4.2 Confidentiality.

GitHubは、お客様のプライベートリポジトリにある「お客様のコンテンツ」をお客様の機密情報と見なします。 GitHub will protect and keep strictly confidential the Customer Content of Private Repositories in accordance with the applicable confidentiality provision in the Microsoft Customer Agreement.

#### 2.4.3 Access.

GitHubがお客様のプライベートリポジトリにアクセスするのは、(i) サポート上の理由からお客様の同意と承認を得ている、または (ii) セキュリティ上の理由からアクセスが必須となっている場合だけです。  お客様は、プライベートリポジトリへのアクセスを追加することもできます。 たとえば、プライベートリポジトリにある「お客様のコンテンツ」への追加の権利を必要とするGitHubの各種サービスまたは機能を有効にするなどが考えられます。 これらの権利はサービスまたは機能によって異なりますが、GitHubは引き続き、お客様のプライベートリポジトリにある「お客様のコンテンツ」をお客様の機密情報として扱います。 これらのサービスが、「サービス」の提供に必要な以上の権利を追加で必要とする場合、GitHubはその件について説明を行います。

#### 2.4.4 Exclusions.

If GitHub has reason to believe the Content of a Private Repository is in violation of the law or of these GitHub Supplemental Terms, GitHub has the right to access, review, and remove that Content. また、GitHubはお客様のプライベートリポジトリのコンテンツを開示するよう法律で強制される場合があります。 法律に基づく要件で別段拘束されていない限り、またはセキュリティ上の脅威などセキュリティに対するリスクに対応する目的で、GitHubはかかる行動について通知します。

### 2.5. 知的財産に関する通知

#### 2.5.1 GitHub's Rights to Content.

「サービス」の見た目は、copyright © GitHub, Inc. All rights reserved で保護されています。 お客様は、GitHubからの書面による許可なく、HTML/CSS、Javascript、またはビジュアルデザイン要素またはコンセプトのいかなる部分も複製、コピー、再利用することはできません。

#### 2.5.2 Copyright Infringement and DMCA Policy.

お客様が著作権所有者であり、「サービス」上のコンテンツがお客様の著作権を侵害していると考えられる場合、お客様は[GitHubのデジタルミレニアム著作権法 (DMCA) ポリシー](https://github.com/contact/dmca)に従って、[DMCAの様式](https://github.com/contact/dmca-notice)でGitHubに通知するか、またはcopyright@github.com.に電子メールを送信すして、GitHubに連絡することができます。

#### 2.5.3 GitHub Trademarks and Logos.

お客様がGitHubのトレードマークを使用したい場合は、[GitHubのロゴと使い方のページ](https://github.com/logos)の内容も含めて、トレードマークに関するGitHubのすべてのガイドラインに従う必要があります。

### 2.6 Suspension.

GitHub has the right to suspend access to all or any part of the Service, including removing Content, at any time for violation of the Microsoft Customer Agreement, including these GitHub Supplemental Terms, or to protect the integrity, operability, and security of the Service, effective immediately, with or without notice. かかる通知が法律または法的手続きによって禁止されている、または「サービス」または第三者への差し迫った損害の防止に妨げとなる場合を除き、GitHub は、通常、かかる一時停止の時点またその前に、バナーまたは email で通知します。 GitHubは、「サービス」の完全性、操作性、およびセキュリティを保全する必要に応じ、その裁量により、かつ誠意をもって任意の一時停止を調整します。

### 2.7 Communications with GitHub.

契約上の目的で、お客様は (1) 提出したメールアドレスまたは「サービス」を介して、電子形式で通信を受信すること、並びに (2) GitHub がお客様に電子的に提供するすべての「利用規約」、契約、通知、開示、およびその他の通信が、かかる通信が紙面である場合に満たす法的要件を満たすことに同意するものとします。 本セクションは、お客様の放棄不能な権利には影響しません。

### 2.8 Service Level Agreement.

GitHub’s quarterly uptime commitment for the Service is provided in the [Enterprise Service Level Agreement](/github/site-policy/github-enterprise-service-level-agreement). Customer will be entitled to a service credit if GitHub does not meet its service level.

### 2.9 Service Changes.

GitHub は、「アップデート」および新機能の追加により、サービスを変更します。 Subject to Section 2.8, GitHub reserves the right at any time to modify or discontinue, temporarily or permanently, the Service (or any part of it) with or without notice.

### 2.10 Additional Service Features.

「サービス」の一部機能については、[GitHub 追加製品の利用規約](/github/site-policy/github-additional-product-terms)に記載されている規約も適用される場合があります。 これらの機能にアクセスまたはこれらを利用することにより、お客様は GitHub 追加製品の利用規約にも同意することになります。

## SECTION 3: GENERAL PROVISIONS.

This Section 3 sets forth the terms and conditions applicable to Customer’s purchase and use of any of the Products.

### 3.1 Term; Termination; Effect of Termination.

#### 3.1.1 Term.
These GitHub Supplemental Terms will continue in effect until terminated by a Party in accordance with this Section 3.1.

#### 3.1.2 Termination for Convenience; Account Cancellation.
Either Party may terminate an Order Form or these GitHub Supplemental Terms, without cause, upon at least thirty (30) days' prior written notice before the end of the then-current Subscription Term. If Customer elects to terminate an Order Form or these GitHub Supplemental Terms, it is Customer's responsibility to properly cancel its account with GitHub by going into Settings in the global navigation bar at the top of the screen. GitHub は、メールや電話での要請に対応してアカウントをキャンセルすることはできません。

#### 3.1.3 Termination for Material Breach.
Either Party may terminate these GitHub Supplemental Terms immediately upon notice if the other Party breaches a material obligation under these GitHub Supplemental Terms and fails to cure the breach within thirty (30) days from the date it receives notification.  GitHub may terminate these GitHub Supplemental Terms if Customer's Account has been suspended for more than 90 days.

#### 3.1.4 Effect of Termination.
Upon termination of these GitHub Supplemental Terms, Customer may not execute additional Order Forms; however, these GitHub Supplemental Terms will remain in effect for the remainder of any active Order Forms. When an Order Form terminates or expires, as to that Order Form: (i) the Subscription Term will immediately end; (ii) any Subscription Licenses in the Order Form will automatically terminate, and Customer will no longer have the right to use the Products; (iii) if any Fees were owed prior to termination, Customer must pay those Fees immediately; (iv) Customer must destroy all copies of the Software in Customer’s possession or control, and certify in writing to GitHub that Customer has done so; (v) each Party will promptly return (or, if the other party requests it, destroy) all Confidential Information belonging to the other to the extent permitted by the Service. 上記にかかわらず、お客様は、本契約または「注文書」の解約または失効後最大 90 日間、お客様のデータを移行するために引き続き「ソフトウェア」にアクセスすることができ、データをそのリポジトリに移行するよう要請できます。ただし、この期間中、お客様は「ソフトウェア」や「サービス」を実稼働ベースで利用することはできないものとします。 本契約または「注文書」の解約または失効により、その性質上合理的に存続すべきあらゆる規定は存続するものとします。

### 3.2 フィードバック
お客様は、「製品」に関する「フィードバック」を GitHub に対して行うことができます。 「フィードバック」は自発的なものであり、「お客様の機密情報」と指定している場合であっても、「お客様の機密情報」としては取り扱われません。 GitHubは、かかるフィードバックを以下の目的で十分に活用できます。(i) GitHubの既存および将来的な製品提供、およびかかる提供品の商品化において、操作、機能性、利用性を向上させるため。(ii) 「製品」の品質についての集計した統計値を公開するため。ただし、公開されるデータは、お客様、お客様の従業員、およびお客様の所有するソフトウェアのコードを明確に特定するために用いられることはありません。

### 3.3 法令・規定の遵守
お客様は、「製品」の利用において、データ保護法および労働法規を含むがこれらに限定されない、適用されるすべての法律および規制を遵守するものとします。

### 3.4 Order of Precedence
In the event of a conflict between the Supplemental Terms, on one hand, and an Order Form, on the other, the Order Form will govern with respect to that order only. In the event of a conflict between the Supplemental Terms (including any Order Form) and the Microsoft Customer Agreement, the Supplemental Terms will govern with respect to the subject matter only.

## EXHIBIT A: DEFINITIONS

「**アクティブユーザ**」とは、「停止」時に「サービス」へのアクセスを試みる「ユーザ」を意味します。

**”Add-On Software”** means Advanced Security, Insights, Learning Lab for Enterprise Server, and other additional Software add-on products that GitHub may offer from time to time.

「**Advanced Security**」とは、カスタマイズ可能で、自動化されたセマンティックコードを通じて、お客様がセキュリティの脆弱性を特定できるソフトウェア機能を意味します。

「**関係会社**」とは、直接的または間接的に支配している、支配されている、あるいは当事者と共通の支配下にある、あらゆる法人を意味します。本定義において「支配」とは、所有権のうち 50% 超を持つか、当該法人の経営管理を指揮する権限を有することを意味します。

「**全ユーザ**」とは、「サービス」を利用する、「お客様」の「ユーザ」および「外部ユーザ」を総称的に意味します。

「**Connect**」または「**GitHub Connect**」とは、お客様が「ソフトウェア」で「サービス」に接続できるようにする、「ソフトウェア」に含まれる機能を意味します。 「GitHub Connect」の利用については、[GitHub 追加製品の利用規約](/github/site-policy/github-additional-product-terms)に記載されている「GitHub Connect」の規約も適用されます。

「**コンテンツ**」とは、機能、表示、その他 「サービス」を通じて利用できる、テキスト、データ、記事、画像、写真、図表、ソフトウェア、アプリケーション、設計、機能、その他それらに制約されないあらゆる素材を意味します。

「**企業アカウント**」とは、法人を代表して「ユーザ」により作成されたアカウントを意味します。

**"Customer"** means, collectively, the company or organization that has entered into these GitHub Supplemental Terms with GitHub by clicking on the "I AGREE" or similar button or by accessing the Products, and Customer's Affiliates and Representatives.

「**お客様のコンテンツ**」とは、お客様が作成、所有するか、お客様が権利を所有する 「コンテンツ」 を意味します。

「**お客様による改善**」とは、「ソフトウェア」に含めるまたは「ソフトウェア」からリンクすることができる、オープンソースライセンスの下にライセンスを受けたあらゆるライブラリのバグ修正、カスタマイズ、または追加機能を開発する目的のためにのみお客様が行うことができる「ソフトウェア」の改善を意味します。

「**ドキュメンテーション**」とは、GitHub が提供するか、お客様に利用できるようにする、「ソフトウェア」または「サービス」に関連したあらゆるマニュアル、ドキュメンテーション、その他補助資料を意味します。

**"Effective Date"** is the earlier of the date on which Customer (i) agrees to the terms and conditions of these GitHub Supplemental Terms as described above, or (ii) first places an order for the Products.

「**不可欠なサービス**」 とは、リポジトリの作成、「フォーク」、およびクローン、ブランチの作成、コミット、およびマージ、プルリクエストの作成、レビュー、およびマージ、ならびに中核となる Git ワークフローへのウェブ、API、および Git クライアントサービスを含む、GitHub の中核となるバージョン管理機能にとって不可欠なサービスを意味します。 これに含まれない周辺的な機能およびサービスの例としては、webhook、Gist、Pages、およびメール通知が挙げられます。

「**外部ユーザ**」とは、「サービス」にアクセスまたは「サービス」を利用する、「お客様」以外の「ユーザ」である個人を意味します。

**"Fees"** means the fees Customer is required to pay GitHub to (i) use the Products during the applicable Subscription Term or (ii) receive Professional Services, as such fees are reflected on an Order Form or SOW.

**“Feedback”** means any ideas, know-how, algorithms, code contributions, suggestions, enhancement requests, recommendations or any other feedback on GitHub products or services.

「**フォーク**」とは、1 つのリポジトリの「コンテンツ」を別のリポジトリにコピーすることを意味します。

「**GitHub**」とは、GitHub, Inc、その「関係会社」および「担当者」を総称的に意味します。

「**GitHub のコンテンツ**」とは、GitHub が作成、所有、またはその権利を所有する「コンテンツ」を意味します。

「**GitHub Insights**」または「**Insights**」とは、「ソフトウェア」の利用に関するメトリクス、分析、および推奨事項をお客様に提供するソフトウェア機能を意味します。 GitHub Insights does not include legacy features of GitHub including organization insights and repository insights.

**“GitHub One”** means the Product bundle which includes GitHub Enterprise, Advanced Security, Insights, Learning Lab for Enterprise Server, and Premium Plus or Engineering Direct Support.

**"Learning Lab for Enterprise Server"** means the Software feature that enables Users to learn about GitHub functionality, including associated Documentation.

「**ライセンスキー**」とは、お客様に「ソフトウェア」のインストール、操作、および利用ができるようにするための、「ソフトウェア」のアクセス管理機構により用いられるデータファイルを意味します。

「**コンピュータアカウント**」とは、「コンピュータアカウント」のために該当する利用規約を受け入れ、有効なメールアドレスを提供し、その動作について責任を負う人間個人により登録されたアカウントを意味します。 「コンピュータアカウント」は、自動化されたタスクを実行するためにのみ用いられます。 「コンピュータアカウント」の動作は、複数の「ユーザ」が指示できますが、コンピュータの動作について究極的な責任を負うのは、アカウントの所有者です。

「**注文書**」とは、「当事者」が「製品」を注文するために用いる、書面または電子的なドキュメント (見積書を含む) を意味します。

「**Organization**」とは、複数の「ユーザ」が、一度に多くのプロジェクトをまたいでコラボレートするために、 単一のエンティティあるいは 1 つまたは複数の「ユーザ」に関連付けることができる共有のワークスペースを意味します。 「ユーザ」は複数の「Organization」のメンバーになることができます。

「**停止**」とは、50% を超える「アクティブユーザ」に影響する、「不可欠なサービス」の中断を意味します。

「**プライベートリポジトリ**」とは、「ユーザ」が「コンテンツ」へのアクセスを制御できるリポジトリを意味します。

「**プロフェッショナルサービス**」とは、相互に締結した「SOW」に従い、GitHub が提供するトレーニング、コンサルティング、または実装サービスを意味します。 「プロフェッショナルサービス」には、「サポート」は含まれません。

「**パブリックリポジトリ**」とは、「コンテンツ」が「全ユーザ」に表示できるリポジトリを意味します。

「**リリース**」とは、GitHub がそのお客様に対して一般的に入手できるようにする「ソフトウェア」のリリースと、それに対応する「ドキュメンテーション」のあらゆる変更を意味し、機能拡張、新機能、新機能性が含まれ、一般的に左から 1 つ目の点の右側にある数字の変更 (例: x.x.x から x.y.x)、または左側の数字の変更 (例: x.x.x から y.x.x) により示されます。

「**担当者**」とは、「当事者」の従業員、代理人、独立契約者、コンサルタント、および財務顧問を意味します。

「**スクレイピング**」とは、ボットやウェブクローラーなどの自動的な処理により、「サービス」からデータを抽出することを意味します。GitHub の API を通して情報を収集することはこれに含まれません。

「**サービス**」とは、ホストされた GitHub Enterprise Cloud サービスを意味します。 「サービス」には、「Organization」アカウント、SAML シングルサインオン、アクセスのプロビジョニング、および該当するあらゆる「ドキュメンテーション」が含まれます。 ここに挙げた機能やサービスは網羅的なものではなく、随時アップデートされる可能性があります。

「**サービスクレジット**」とは、以下に定める計算により、GitHub が適格なアカウントに払い戻す、ドルのクレジットを意味します。

「**ソフトウェア**」とは、GitHub Enterprise Server のオンプレミスのソフトウェアを意味します。 Software includes the GitHub Connect feature, any applicable Documentation, any Updates to the Software that GitHub provides to Customer or that it can access under these GitHub Supplemental Terms, and, if included in Customer’s subscription, Add-On Software.

「**SOW**」とは、GitHub が実施する「プロフェッショナルサービス」の作業詳細、それに関するあらゆる「料金」、およびそれに関する各「当事者」の義務について、相互に締結した声明書を意味します。

「**プランライセンス**」とは、お客様を代表して「製品」をインストール、操作、アクセス、および利用するために各「ユーザ」に割り当てられるライセンスを意味します。 お客様は、GitHub Enterprise Server のインスタンスおよび GitHub Enterprise Cloud Organization にわたって、「ユーザ」ごとに「プランライセンス」を 1 つのみ割り当てることができます。 各「ユーザ」は、お客様の Enterprise Server インスタンスまたは Enterprise Cloud Organization に、お客様が許可する範囲でアクセスできます。 ただし、明確にするために記すと、お客様が「プランライセンス」を「ユーザ」にいったん割り当ててから、1 人の「ユーザ」が Enterprise Server の「プランライセンス」を利用しながら、別の「ユーザ」が同一の「プランライセンス」で GitHub Enterprise Server の別のインスタンスまたは GitHub Enterprise Cloud の Organization を利用できるようにお客様が「プランライセンス」を分けることは認められないものとします。 「プランライセンス」は、「ユーザ」ごとに付与され、複数の「ユーザ」が同一の「プランライセンス」を利用することはできません。 お客様は、「プランライセンス」を最後に再割り当てしてから 90 日間が経過しなければ、新しい「ユーザ」に同一の「プランライセンス」を再割り当てすることはできません。ただし、再割り当てが以下の理由による場合を除きます。(i) ハードウェアの永久的な故障または喪失、(ii) 「ユーザ」の雇用または契約の終了、または (iii) 「ユーザ」の欠勤を代替するための、「プランライセンス」の一時的な再割り当て。 お客様がある「ユーザ」から別の「ユーザ」に「プランライセンス」を割り当てる際は、前の「ユーザ」の「プランライセンス」 およびお客様の「Organization」へのアクセスをお客様がブロックする必要があります。

「**プラン契約期間**」とは、注文に適用される発効日か、「注文書」に記載されている発効日から 1 年間の期間を意味します。

「**サポート**」とは、GitHub が提供する場合がある、「ソフトウェア」または「サービス」への技術サポートを意味します。

「**アップデート**」とは、GitHub がそのお客様に対して一般的に入手できるようにする「ソフトウェア」のリリースと、それに対応する「ドキュメンテーション」のあらゆる変更を意味し、エラーの修正やバグの修正が含まれ、一般的に左から 2 つ目の点の右側にある数字の変更 (例: x.x.x から x.x.y) により示されます。

**“Uptime”** means the percentage of time in a given quarter where GitHub's Essential Services will not be interrupted by an Outage affecting more than 50% of Active Users

「**ユーザ**」とは、(i) 「ソフトウェア」に関しては、「ソフトウェア」の機能を実行するにあたり、「ソフトウェア」の実行を開始するか、「ソフトウェア」と対話するか、「ソフトウェア」に命令する、1 人の人または「コンピュータアカウント」を意味します。(ii) 「サービス」に関しては、「お客様」を代表して、(a) 「サービス」にアクセスまたはそれを利用する、(b) 「お客様」のアカウントの一部にアクセスまたはそれを利用する、あるいは (c) 機能を実行するにあたり「お客様」のアカウントの利用を命令する、個人または「コンピュータアカウント」を意味します。 「ユーザ」の数は、「お客様」が購入した「プランライセンス」の数を超過してはなりません。

「**ユーザ生成コンテンツ**」とは、第三者または「外部ユーザ」が作成または所有する「コンテンツ」を意味します。
