---
title: GitHub Sponsors に関する追加条項
redirect_from:
  - /articles/github-sponsors-additional-terms
versions:
  free-pro-team: '*'
---

「GitHub Sponsors プログラム」 (以下「プログラム」) への参加にあたっては、[GitHub 利用規約](/github/site-policy/github-terms-of-service) (以下「契約」) および以下の追加条項 (以下「追加条項」) に従うものとします。 本契約に違反する GitHub Sponsors プログラムの使用は、本追加条項の違反にもなります。 かぎ括弧に括られた用語のうち、以下に定義されていないものについては、本契約に記された意味を持つものとします。 「GitHub Sponsors」プログラムの「追加条項」は、GitHub と、本プログラムにおいて「スポンサード開発者」となるあなたとの関係について記述しています。 追加条項は、あなたがこれに同意した日 (「発効日」) から発効します。

### 1. 定義

「**GitHub ポリシー**」とは、本プログラムに述べられている通りに「スポンサード開発者」が従う必要がある、「[GitHub コミュニティガイドライン](/github/site-policy/github-community-guidelines)」を含む GitHub の当時のポリシーおよび手続きのすべてを意味します。

「**スポンサー**」とは、あなたの「スポンサード開発者アカウント」を通じて、あなたから「プラン」を購入したか、あなたに「スポンサーシップ」を支払った「ユーザ」を意味します。

「**スポンサード開発者アカウント**」とは、「スポンサー」から支払いを受けるため、本プログラムを通じて開設したアカウントを意味します。

「**スポンサード開発者コンテンツ**」とは、「ユーザ生成コンテンツおよびあなたのコンテンツ」、あなたのブランド名、商標、サービスマーク、商号、ロゴ、および原作者のしるし (「**スポンサード開発者マーク**」)、ならびにあなたの「スポンサード開発者アカウント」に関連するデータを含め、本プログラムに関して GitHub に送信されるあらゆるコンテンツを意味します。

「**スポンサーシップ**」とは、本プログラムおよびサービスを通じて支払われる金額を意味します。

「**プラン**」とは、商品、サービス、その他スポンサーに対して提供するものと引き換えに毎月受け取るスポンサーシップを意味します。

"**Sponsored Developer Payment**" means the net of one hundred percent (100%) of GitHub's gross monthly payments received from Sponsorships and Subscriptions to Sponsored Developer Accounts, plus any applicable Matching Funds, and other proceeds from monetization options that the Sponsored Developer elects to use, as applicable, less any discounts, taxes, fees, amounts that GitHub did not collect or which were refunded or charged back, amounts owed to any third-party in connection with the Program with respect to a Sponsored Developer Account, and other Exclusions as outlined in Section 4.

"**USD**" means United States Dollar.

### 2. 利用規定

#### 2.1. GitHub Sponsors Program

In order to participate in the Program, you must comply with your country's minimum age laws (for example, you must be at least 13 years of age if you live in the United States), have a valid GitHub account, and have agreed to the [Acceptable Use section](/github/site-policy/github-terms-of-service#c-acceptable-use) in the Agreement and applicable GitHub Policies, and these GitHub Sponsors Additional Terms.

If you are over the age of 13 but are under 18, you can give and receive Sponsor funds, provided that Stripe, our payment processor, can collect verification information from your legal guardian.

You will not under any circumstances allow payments or raise funds involving:

* 詐欺、ランサムウェア、知的財産の侵害、その他違法な目的

* 資金獲得やスポンサーシップの要請を行う理由に関する、不実または虚偽

* ICO、ユーティリティトークン、その他暗号通貨の売買

* 証券、エクイティ、その他投資商品の売買

* 個人情報の販売、または法律を侵害するような個人情報の処理

* 抽選、宝くじ、ギャンブル、ねずみ講、自己取引、儲け話、詐欺的なマーケティングの仕組み、「寄付のための寄付」、その他 GitHub または第三者のシステムやサービスを悪用するあらゆる試み、

* activities with, in, or involving countries, regions, governments, persons, or entities that are not permitted under U.S. and other economic sanctions under applicable law.

#### 2.2. GitHub Sponsors Matching Fund
The GitHub Sponsors Matching Fund aims to encourage the community that participates in the Open Source Software (OSS) ecosystem to contribute sustainable funding to qualifying individuals with Sponsored Developer Accounts. All individuals who applied to the Program before January 1, 2020, will be reviewed for eligibility for the Matching Fund, but not all eligible individual Sponsored Developer Accounts will receive matching. Organizations cannot participate in the GitHub Sponsors Matching Fund, and Sponsorship from an organization to a qualifying Sponsored Developer Account will not be matched. See below for additional rules.

##### 2.2.1. Matching Fund Terms.
Eligibility for the GitHub Sponsors Matching Fund is evaluated on a case-by-case basis and is subject to the following limitations:

* You must have a GitHub account, be accepted into the Program as an individual, and be actively contributing to OSS. Please note, GitHub does not allow operating more than one free user account. そのため、マッチングを利用できるのは個別単位であり、複数のアカウントにまたがって承認されることはありません。

* Your use of GitHub and your Sponsored Developer Account must be, based on our determination, in our sole discretion, in accordance with the GitHub Sponsors mission to expand the opportunities to contribute to open source that upholds the [GitHub Community Guidelines](/github/site-policy/github-community-guidelines).

* You cannot receive matching for any sponsorship that originates from a user or organization account with a published GitHub Sponsors profile.

* GitHub reserves the right to withhold or rescind Matching Fund money and block any user from participation in the GitHub Sponsors Matching Fund for any reason, including but not limited to posting content or projects that GitHub determines are offensive or otherwise objectionable.

##### 2.2.2. Matching Period.
The matching period begins after GitHub accepts an individual Sponsored Developer Account into GitHub Sponsors and publishes the sponsorship profile for the account. For each individual Sponsored Developer Account eligible for the GitHub Sponsors Matching Fund, GitHub can match community sponsorship up to $5,000 USD total during the Sponsored Developer Account's first 12 months in the Program. マッチングの期間は、いかなる理由によっても拡大できません。 During the matching period, GitHub will not charge any fees, so 100% of sponsorships will go to the sponsored developer. 将来的には、わずかな手続き費用を課金することがあります。

* If a Sponsorship or Sponsoring Subscription stops for any reason, the associated matching will stop as well. Funds that are charged back to the Sponsor before the Sponsored Developer Payment date are not eligible for matching.

* If you leave GitHub Sponsors and rejoin later, the gap between your participation periods may count toward your matching period or your matching period may expire.


* If GitHub discovers a potential policy violation, prior to payment of any matching funds granted during the matching period, GitHub may disable payouts until an investigation has been completed, and matched funds contributed to the sponsored developer may be revoked if they are found to be in violation of this policy.

* {% data reusables.sponsors.github-contact-applicants %}

### 3. スポンサード開発者の義務

#### 3.1. 一般的.
あなたは次の項目を行うものとします。(A) 「スポンサードアカウント」を作成すること、(B) 「スポンサード開発者コンテンツ」を本プログラムおよびサービスを通じて利用可能にすること、(C) GitHub ポリシーのすべてに従うこと。 「スポンサード開発者アカウント」および「スポンサード開発者コンテンツ」のサポート、開発、保守、およびそれらに関する苦情については、あなたが全責任を負うものとします。

#### 3.2. 登録
本プログラムへの参加は、あなたが登録プロセスを完了させ、GitHub により本プログラムへの参加を認められることをその条件とします。 さらに、本プログラムの特定の機能にアクセスして利用するためには、GitHub が選定する決済サービスプロバイダー (Stripe など) への登録が必要な場合があります。 あなたを特定する正確な情報を登録すること、および本プログラムの登録フォームが求める情報について、真実、正確、最新、完全な情報を提供し、維持することに同意する必要があります。 Registration data and certain other information about you are governed by our [Privacy Statement](/github/site-policy/github-privacy-statement), as well as any privacy statement provided by our payment processor. GitHub は、本プログラムへの受け入れを拒否する権利を留保するものとします。

#### 3.3. コンテンツの収益化
本プログラムおよびサービスを通じて、GitHub は「スポンサード開発者コンテンツ」を収益化できるさまざまな選択肢を提供できます。 選択肢によっては、「スポンサード開発者アカウント」の設定を一部更新することが必要な場合もあります。 また、本プログラムが収益化の各選択肢をサポートする方法はさまざまです。 そうした選択肢の 1 つ以上を利用するため、該当する設定を変更する場合は、その選択肢に適用される条項に同意することになります。 収益化の選択肢によっては、GitHub やそのサービスプロバイダーに追加情報を提供したり、追加的な GitHub の条項またはサードパーティの条項に同意しなければならない場合があります。

##### 3.3.1. Subscriptions.
The Program provides you with the capability to offer Subscriptions. 「プラン」を提供する場合、セクション 4 の記載に従い、GitHub はあなたに「プランスポンサーシップ」を支払います。 You are responsible for determining the nature, content, and capabilities of your Subscription offer, subject to these Additional Terms and applicable GitHub Policies.

##### 3.3.2. Other Sponsorships.
The Program or Service may provide you with the ability to accept a donation or other type of direct Sponsorship from another User without a Subscription offer. However, because GitHub does not fulfill those types of Sponsorships, you must establish a merchant account with a third-party payment service provider (such as Stripe) and be subject to that service provider's merchant account terms, conditions, and privacy policies. Any amounts contributed to you, donation or otherwise, will be paid directly to your merchant account and not included in any Sponsored Developer Payments. あなたは寄付に関して GitHub に対して請求や賠償を全く求めないことに同意し、寄付に関するあらゆる紛争については、あなたとサードパーティー決済プロバイダーとの間のみで行うものとします。 You are responsible for compliance with any third-party payment service provider's agreements, policies, and laws or regulations that may apply. GitHub は、あなたの利便を図るため、あなたへの寄付金についての情報やレポートを提供するよう選択することができます。

##### 3.3.3. Advertising.
While we understand that you may want to promote your Sponsors by posting their names or logos in your account, the primary focus of your Sponsored Developer Content should not be advertising or promotional marketing. In addition, you may not enter into any advertising agreement to promote any product or brand if doing so would be prohibited by the [Agreement](/github/site-policy/github-terms-of-service) or GitHub's Community Guidelines. If you decide to host any advertising or promotional materials in your Sponsored Developer Content, you are solely responsible for complying with all applicable laws and regulations, including the U.S. この法令には、「推奨・証言に関する米国連邦取引委員会のガイドライン」が含まれますが、それに限定されません。

### 4. 金銭的条件

#### 4.1. 支払い.
GitHub will pay you the Sponsored Developer Payment in accordance with this Section 4, so long as you meet the Sponsored Developer Obligations in Section 3 and are not in violation of these Additional Terms. あなたが特定の月においてこれらの義務を果たさない場合、当社は自らの裁量により、該当する月の「スポンサード開発者への支払い」を保留することがあります。 「期間」中に「スポンサード開発者の義務」を 2 か月間 (連続または非連続で) 果たさないか満たさない場合、セクション 6 に記載の通り、GitHub は本「追加条項」を終了することができます。

#### 4.2. Sponsored Developer Payment Exclusions.
以下の金額は「スポンサード開発者への支払い」に含まれず、該当する場合は GitHub が差し引くことがあります。

##### 4.2.1. Sponsored Developer Expenses.
You will bear all expenses you incur in connection with your performance under these Additional Terms. 当社では、費用の払い戻しや前払いを一切いたしません。

##### 4.2.2. Taxes.
GitHub intends to comply with all applicable tax information reporting and tax withholding laws that GitHub reasonably determines in its judgment apply to these payments. GitHub があなたに支払うべき金額、または準拠法により税金情報の報告対象となる金額から税金を源泉徴収する必要がある場合、GitHub はかかる税金を支払額から控除して適切な税務当局に支払い、必要な場合は、準拠法に基づいて、かかる源泉徴収税の正式な領収書を取得してあなたに送付するものとします。 GitHub は、準拠法により許容される範囲において、かかる税額を最小化するために合理的な努力を払います。また各当事者は、準拠する所得税法または条約に従って、かかる税金の税率を最低限に抑えるまたは免除を受けるために、相手方当事者に合理的な範囲で協力するものとします。 かかる協力には、源泉徴収の免除を受けるために必要な、IRS フォーム W-8、W-9 その他の情報など、準拠法の要請に従って適切な情報を GitHub に提供することが含まれます。 また、該当する場合、あなたは源泉徴収および報告に関する、あらゆる第三者の支払い処理業者の契約条件に従う責任を負うものとします。 さらに、GitHub が本「追加条項」または「契約」による支払いに対して適用される源泉徴収税または報告の義務について判断するため、GitHub に対して準拠法の要請に基づく適切な文書または情報をあなたが提供するまで、GitHub はあなたのアカウントに対する支払いを停止する権利を留保します

##### 4.2.3. Withholding of Sponsored Developer Payment for Breach.
In the event of a Sponsored Developer's breach, or suspected breach, of these Additional Terms or the Agreement, GitHub reserves the right to withhold payment to the Sponsored Developer under these Additional Terms or otherwise, pending GitHub's reasonable investigation of the same. If GitHub determines, in its sole discretion, that a Sponsored Developer is in breach of these Additional Terms or the Agreement, GitHub may permanently withhold any amounts due to the Sponsored Developer.

#### 4.3. Payment Timing.
During the term, GitHub will remit to you all Sponsored Developer Payments received in a given month within 30 days after the close of that month, subject to the variables below. Payouts are sent through Stripe Connect, ACH transfer, or wire transfer to the bank account you provided when you applied for GitHub Sponsors. あなたまたは銀行により提供された情報の誤りや不十分による、「スポンサード開発者への支払い」の一切の遅延や誤適用、また銀行があなたの口座に振り込めなかったことについて、当社は責任を負いません。

- For newly created Sponsored Developer Accounts, GitHub will remit to you all Sponsored Developer Payments received in a given month within 90 days of the creation of your Sponsored Developer Account, subject to the variables below. Payments thereafter will be remitted within 30 days of the close of that month, in accordance with this section.

- If you are paid through Stripe Connect, you will receive payouts on the 22nd of the month for your balance at the end of the previous month, regardless of the amount of the balance.

- ACH 送金または電信送金の場合、第 3 木曜日に支払われます。 GitHub will issue a payout to you for any month that your balance reaches $100 USD. Contributions from the GitHub Sponsors Matching Fund do not count towards this threshold. 月末時点で残高が 100 USD を下回る場合には、月末時点の残高が 100 USD に達するまで、残高が翌月分に繰り越されます。 If you leave GitHub Sponsors, GitHub will issue a payout for your remaining balance even if the balance is below $100.

- After termination, we will remit to you all Sponsored Developer Payments received and unpaid within approximately 90 days after the end of the calendar month in which we recognize that these Additional Terms have been terminated.

#### 4.4. Payment Method.
当社は、「スポンサード開発者への支払い」をACH/SEPA または電信で、あなたの指定した口座に支払います。支払いの閾値、方法、および期間は、その時の当社の支払い方針により規定されます。この方針については、随時更新される場合があります。 支払い方法および閾値は、あなたが提供する国および口座情報により異なる場合があります。 当社は独自の裁量により、「スポンサード開発者への支払い」をあなたに支払うべきその他の金額と一緒に支払うことができます。

#### 4.5. 通貨
通貨の表記はすべて USD です。 あなたの住所が米国外である場合は、その時の換算レートを用いて、USD をあなたの居住する地域の通貨に替えて支払う場合があります。

#### 4.6. 返金要件
あなたは、「スポンサー」への返金に関する条件を指定する責任を負います。 いかなる場合においても、GitHub は返金についてサポートを提供する義務や、返金の支払いについて責任を負う義務を負いません。

#### 4.7. 必要な支払い情報
あなたに支払いを行うためには、当社が要求する財務、税金、および銀行情報を (アカウントの作成や設定、その他の手段において) 完全かつ正確に当社に対して提供する必要があります。 当社は、あらゆる連絡手段を用いて、必要な情報の変更についてあなたに通知するものとします。 かかる情報をあなたが正確に提供 (または正確に維持) しなかった場合、(a) 当社はあなたへの「ポンサード開発者への支払い」から関連する銀行手数料を差し引くことができます。(b) 当社は「追加条項」を解約することができます。この場合、あなたは GitHub が支払うべき金額を受け取る権利を喪失する可能性があります。

### 5.  表明および保証、責任の制限、賠償

#### 5.1. スポンサード開発者
スポンサード開発者は、以下を表明および保証するものとします。

* これらの「追加条項」を契約し、完全に履行する権限を持つこと。

* 「追加条項」の締結および履行が、あなたと第三者とのその他の契約や義務に違反しないこと。

* 「スポンサード開発者コンテンツ」が、著作権、商標、特許、企業秘密、人格権、プライバシー権、 パブリシティー権 、その他あらゆる他の知的財産権を含む第三者の権利を侵害、侵害、または不当に使用するものではないこと。

* すべての法令に従うこと、および「スポンサード開発者コンテンツ」が違法ではなく、いかなる法令も侵害しないこと。

#### 5.2. 保証免責、責任の制限、賠償
あなたは、本契約の O (保証の免責)、P (責任制限)、Q (免責・補償) がこれらの「追加条項」に適用されることに明示的に同意するものとします。

### 6. 契約期間および解約

#### 6.1. 契約期間.
この「追加条項」は「発効日」から有効となり、本プログラムに参加している限り有効です。

#### 6.2. 一時停止。
あなたか何らかの形で「追加条項」または「契約」に違反した場合、 取引制限リストに掲載されている場合、あるいは米国財務省外国資産管理局 (OFAC) が管轄する包括的な制裁下にある国または地域に定住するか常時居住している場合、GitHub は、あなたの「スポンサード開発者アカウント」を直ちに停止することができます。 Office of Foreign Assets Control (OFAC). 停止の原因を修正または是正できない場合、「スポンサード開発者アカウント」の終了に至る可能性があります。

#### 6.3. 解約
いずれの当事者も、理由の有無を問わず、また事前予告の有無を問わず、「追加条項」および「スポンサード開発者アカウント」をいつでも解約することができます。 あなたが「追加条項」または「契約」に違反した場合、当社はその違反を是正するための期間を提供することができますが、かかる期間を提供する義務は負いません。

#### 6.4. 解約の効果.
いずれかの「当事者」がセクション 6.3 基づいて解約した場合、解約日までに発生した「スポンサード開発者」への支払い額を「スポンサード開発者」に支払うことのみが、GitHub の唯一の義務であることとします。ただし、このような支払いが法律により禁止されている場合を除きます。

### 7. 雑則

#### 7.1. 完全なる合意。
「追加条項」は、「契約」、「GitHub ポリシー」、「GitHub のプライバシーについての声明」、およびその他の収益化手段についての条項と共に、あなたと GitHub との間の完全なる合意を表わします。

#### 7.2. 条項の変更
当社は、当社単独の裁量により、「追加条項」をいつでも変更する権利を留保します。価格変更など、「追加条項」の重要な変更については、変更が効力を生じる少なくとも30日前に、当社ウェブサイトに掲示することによりあなたに通知します。 本プログラムに継続的に参加することにより、あなたは「追加条項」の改訂に同意したものとみなされます。 これらの「条項」におけるすべての変更は、[サイトポリシー](https://github.com/github/site-policy)リポジトリで確認できます。

#### 7.3. 第三者への利益供与
明示的に述べられている場合を除き、当事者以外のいかなる個人、企業、グループ、または法人も、「追加条項」に含まれるいかなる理由によっても、「追加条項」に含まれるいずれの権利も取得しているものとはみなされないものとします。

#### 7.4. 独立契約者.
両当事者は独立契約者です。 いずれの当事者も、相手方当事者の使用者、従業員、代理人、パートナーまたは法定代理人ではなく、また相手方当事者を代表して義務または責任を発生させるいかなる権利、権力、権限も有しません。

#### 7.5. 広報.
当社は、本プログラムにあなたが参加することについて、プレスリリースその他の広報を発行できるものとします。
