---
title: GitHubセンシティブデータリムーバルポリシー
redirect_from:
  - /articles/github-sensitive-data-removal-policy
versions:
  free-pro-team: '*'
---

GitHub のコンテンツがあなたが所有する有効な著作権を侵害していると思われる場合は、[DMCA テイクダウンポリシー](/articles/dmca-takedown-policy/)および [DMCA テイクダウン通知提出ガイド](/articles/guide-to-submitting-a-dmca-takedown-notice/)をご覧ください。 当社では、削除措置の大半は、DMCA 通知とテイクダウンプロセスを通じて行われています。

ただし、機密性の高いセキュリティ関連のコンテンツが、故意や過失により、時折 GitHub で公開されてしまうことを当社は理解しています。 DMCA プロセスが適用されない特定の例外的状況（パスワードが公開されてセキュリティが危険にさらされている場合、削除が必要な特定のコンテンツの著作権を所有していない場合、コンテンツが著作権で保護されていない場合など）でもこうした機密データを削除できるように、当社は機密データの削除プロセスを提供しています。 このガイドでは、リポジトリから機密データを削除するリクエストを GitHub が処理するために必要な情報について説明します。

### 機密データ（センシティブデータ）とは？

本書では、「機密データ（センシティブデータ）」とは、(i) 秘密にしておく必要があり、*かつ* (ii) 公開されることで特定のまたは標的を絞ったセキュリティリスクをあなたまたはあなたの組織にもたらすコンテンツを指します。

#### 機密データの削除リクエストは次の場合に適しています。
- 組織のサーバー、ネットワーク、またはドメインにアクセスするための、ユーザ名とパスワード、アクセストークン、またはその他の機密情報の組み合わせなどの、アクセス認証情報。
- あなたに代わって第三者にアクセスを許可する AWS トークンおよびその他同様のアクセス認証情報。 トークンが自分のものであることを示すことができなければなりません。
- 組織に特定のセキュリティリスクをもたらす文書（ネットワーク図など）。 内部サーバー名や IP アドレス、URL だけでは機密データとして扱われません。特定のファイルまたはコードで内部サーバー名が使用されることがセキュリティ上の脅威をもたらすことを示すことができなければなりません。

#### 機密データの削除リクエストは次の場合には適して_いません_。
-  あなたまたはあなたの組織の著作権を侵害している可能性のあるコンテンツを削除するリクエスト。 著作権関連の問題に対する GitHub の対応方法について質問がある場合や、著作権侵害の可能性があるコンテンツを報告したい場合は、[DMCA テイクダウンポリシー](/articles/dmca-takedown-policy/)をご確認ください。 機密データの削除プロセスは、通常、ファイルまたはリポジトリ全体の削除を目的としておらず、ファイル内の特定の機密データのみが対象となります。 ファイルの内容がすべて機密情報であるケースもありますが、こうしたファイルを削除するためにはセキュリティリスクがあることを証明する必要があり、このような場合、リクエストの処理にかかる時間が長くなる可能性があります。
- 商標に関する紛争。 商標関連の問題に対する GitHub の対応方法について質問がある場合や、組織の商標やサービスマークを含んでいるコンテンツを報告したい場合は、[トレードマークポリシー](/articles/github-trademark-policy/)をご確認ください。
- 会社のアイデンティティ、名前、ブランド、ドメイン名など、GitHub 上のファイル内で単に会社に言及しているだけの場合。 当社がこのポリシーに基づいて措置を講じる前に、あなたは会社のアイデンティティの使用が会社のセキュリティ体制に対する脅威となる理由を明確にする必要があります。
- プライバシーに関する苦情。 自身のプライバシーについて懸念がある場合や、プライバシーの懸念について従業員に代わってお問い合わせいただく場合（たとえば、プライベートなメールアドレスやその他の個人情報が投稿されている場合）は、[プライバシー連絡フォーム](https://github.com/contact/privacy)からご連絡ください。
- 特定のセキュリティリスクをもたらすことはないが、それ以外の理由で好ましくないと考えられるファイルやリポジトリ全体。
- マルウェアや汎用ツールなど、[コミュニティガイドライン](/articles/github-community-guidelines/)で管理されているコンテンツ。 If you have questions about our Community Guidelines or believe that content on GitHub might violate our guidelines, you can use {% data variables.contact.report_content %} to contact us.

### 知っておくべきこと

**まずは丁寧にお願いしてください。**当社にデータ削除のリクエストを送信する前に、まずはユーザに直接連絡することが重要です。 連絡先情報は公開プロフィールページやリポジトリの README または Support ファイルに記載されている場合があります。または、Issue を作成したり、リポジトリでプルリクエストを送信して連絡を取ることもできます。 これは厳密には義務ではありませんが、その方が印象の良いやり方と言えるでしょう。

**ボットを使わないでください。**熟練の専門家に、あなたが送信するすべてのリクエストの事実を評価してもらうべきです。 取り組みを第三者に外部委託している場合は、その活動内容を把握し、第三者が自動化されたボットを使用して苦情を一括送信していないことを確認してください。 こうした苦情には、セキュリティ上の脅威をもたらさないデータが含まれていることが少なくありません。また、十分な説明が含まれていないために、正当な苦情であっても何度も確認が必要となり、結果として遅延が生じる場合もあります。

**リクエストは正しく送信してください。**この機密データの削除プロセスは、リスクの高いコンテンツに限定した例外的なサービスとして提供されます。 このプロセスを使用して、著作権侵害の可能性のあるコンテンツなど、他の種類のコンテンツを削除することはできません。また、機密性の高い削除リクエストを処理している間、他の種類の削除リクエストを同時に処理することはできません。 より迅速なサポートが可能になるよう、機密データの削除リクエストは、著作権侵害の可能性のあるコンテンツを削除するリクエストとは別に送信してください。 リクエストが機密データにのみ関係するのか、他の法的問題にも関係するのかわからない場合は、弁護士にご相談ください。

**処理にかかる時間について。**機密データの削除リクエストはできるだけ速やかに処理しますが、処理するリクエストの量が多いため、リクエストの審査には時間がかかる場合があります。 リクエストを追加で送信したり、複数の連絡先からの複数のリクエストを送信したりすると、遅延が発生する場合があります。

### 具体的なプロセスは？

1. **申立人が調査します。**要請者は、自身で調査を実施し、[当社が求める詳細情報](#your-request-must-include)を提供する必要があります。最も重要なのは、データがどのようにセキュリティリスクをもたらすのかを説明することです。 GitHub は、個人または組織に代わって機密データを検索したり、最初の決定を下す立場にはありません。

2. **申立人が機密データの削除リクエストを送信します。**調査を実施した後、申立人は機密データの削除リクエストを準備し、GitHub に[送信](#sending-a-sensitive-data-removal-request)します。 リクエストがセキュリティリスクを立証するほど詳細でない場合や GitHub がデータを特定できない場合は、当社は返信して追加情報を求めます。

3. **GitHub がユーザに変更を要求します。**ほとんどの場合、当社はリポジトリを作成したユーザに連絡し、リクエストで指定された機密データを削除または変更したり、クレームに異議を唱えたりする機会を与えます。

4. **ユーザが GitHub に変更を通知します。**ユーザは、指定された変更を行うことを決定した場合、指定された時間内にその旨を当社に通知する必要があります。 そうしなかった場合は、当社はリポジトリを無効にします。 ユーザが変更を行ったことを当社に通知した場合、当社は変更が行われたことを確認してから申立人に通知します。

  または

5. **User May Dispute the Request.** If a user believes the content in question is not sensitive data subject to this Policy, they may dispute it. この場合、通常は申立人に対して、任意でユーザに連絡し、ユーザとの間で、問題を合理的な範囲内で直接解決していただくことになります。

6. **申立人が変更を確認します。**ユーザが変更を加えた場合、申立人はそれを確認する必要があります。 変更が不十分な場合、申立人は GitHub にその理由を説明する詳細を提供する必要があります。 GitHub はリポジトリを無効にする場合もあれば、もう一度ユーザに変更を加える機会を与える場合もあります。

7. **User May Request an Additional Window to Make Changes.** If the user missed their opportunity to remove the sensitive data specified in the notice, we may allow them an additional window of approximately 1 business day, upon request, to make those changes. その場合、GitHub は申立人に通知します。

#### フォークの場合は？ （またはフォークとは？）
GitHub の最も優れた機能の 1 つに、ユーザが互いのリポジトリを「フォーク」できることがあります。 どういうことかと言うと、 基本的に、ユーザは GitHub のプロジェクトのコピーを自分のリポジトリに作成できます。 ライセンスや法律で許可されている範囲で、ユーザはそのフォークを変更してメインプロジェクトに戻したり、プロジェクトの独自のバリエーションとして保持したりすることができます。 これらの各コピーは、元のリポジトリの「[フォーク](/articles/github-glossary/#fork)」であり、フォークの「親」とも呼ばれます。

GitHub は、親リポジトリを無効にするときにフォークを自動的に無効にしません。 これは、フォークはさまざまなユーザに属しており、著しく変更されている可能性があるためです。 GitHub がフォークに対して独立した調査を行うことはありません。 この調査は、機密データの削除リクエストを送信する申立人が実施するようお願いいたします。フォークにも機密データが含まれていると思われる場合は、リクエストにフォークを明示的に含めてください。

### 機密データの削除リクエストの送信

GitHub がホストするコンテンツの種類（主にソフトウェアコード）やコンテンツの管理方法（Git を使用）の性質上、苦情はできるだけ具体的にする必要があります。 ユーザが報告された機密データを完全に削除したことを確認するために、当社は確認すべき箇所を正確に知る必要があります。

このガイドラインの目的は、機密データの削除リクエストの処理をできるだけ簡単にすることです。

#### リクエストには以下を含める必要があります。

1. 機密データを含む各ファイルへの有効でクリック可能なリンク。 （検索結果、例、スクリーンショットから処理することはできません。）
2. 機密データを含む各ファイル内の具体的な行番号。
3. 特定した各アイテムが、あなたまたはあなたの組織にどのようにセキュリティリスクをもたらすかについての簡潔な説明。 ***単にデータがセキュリティリスクをもたらすという記述だけでなく、どのようにもたらされるかを説明することが重要です。***
4. セキュリティリスクに直面している組織の代理人として行動している第三者の場合は、その組織を代理して行動する法的権利があるという声明を含めてください。
5. 任意：リクエストが特に緊急であるかどうかと、その場合は理由をお知らせください。 当社は、すべての機密データの削除リクエストにできるだけ速やかに対応します。 しかし、ごく最近の認証情報が暴露されているなど、このリクエストが特に緊急を要する場合は、その理由を説明してください。

### リクエストの提出方法

機密データの削除リクエストは、[連絡フォーム](https://support.github.com/contact)から提出できます。 メッセージの本文には平文版のリクエストを含めてください。 添付ファイルでリクエストを送信した場合、処理に時間がかかる場合があります。

### 異議申し立て

当社から機密データの削除リクエストを受け取った場合は、これに異議を申し立てることができます。その場合はメールに返信し、問題のコンテンツがこのポリシーの対象となる機密データではないと思われる理由を、可能な限り詳細にお知らせください。
