---
title: GitHubのプライバシーについての声明
redirect_from:
  - /privacy/
  - /privacy-policy/
  - /privacy-statement/
  - /github-privacy-policy/
  - /articles/github-privacy-policy/
  - /articles/github-privacy-statement/
versions:
  free-pro-team: '*'
---

Effective date: July 22, 2020

お客様のソースコードやプロジェクト、個人情報について、GitHub Inc （以下、「GitHub」「当社」と称します）をご信頼いただき、ありがとうございます。 お客様の個人情報を保持することは重大な責務であり、当社がどのように取り扱っているのかを知っていただければと思います。

本文で注釈のない限り、すべての大文字の用語の定義は、[GitHub利用規約](/github/site-policy/github-terms-of-service)にあります。


### ショートバージョン

We use your personal information as this Privacy Statement describes. No matter where you are, where you live, or what your citizenship is, we provide the same high standard of privacy protection to all our users around the world, regardless of their country of origin or location.

もちろん、このショートバージョンと概要にすべてが記載されているわけではありません。詳細は読み進めてください。

### 概要

| セクション                                                                                      | 各セクションの内容                                                                                                                                                                                                                                         |
| ------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [GitHubが収集する情報](#what-information-github-collects)                                         | GitHubは、お客様の登録内容や支払い、取引、ユーザプロフィールから直接情報を収集します。 当社は、また、お客様の同意が必要な場合は同意を得て、自動的に利用情報、クッキーや類似の技術、デバイス情報から収集します。 GitHubは、さらに、サードパーティからユーザの個人情報を収集することがあります。 当社は、必要最小限の個人情報を収集します。ただし、お客様がそれ以上の情報を提供することを選択した場合は除きます。                                   |
| [当社が_収集しない_情報](#what-information-github-does-not-collect)                                  | 当社は、13歳未満の子どもの情報は意図的に収集しません。また、[センシティブな個人情報](https://gdpr-info.eu/art-9-gdpr/)も収集しません。                                                                                                                                                            |
| [当社のお客様情報の利用方法](#how-github-uses-your-information)                                         | In this section, we describe the ways in which we use your information, including to provide you the Service, to communicate with you, for security and compliance purposes, and to improve our Service. 法令が要求している場合、さらに、お客様の情報を処理する法的な根拠を記載します。  |
| [当社が収集したお客様の情報の共有方法](#how-we-share-the-information-we-collect)                             | 次のいずれかの場合において、当社はお客様の情報を第三者と共有することがあります。 ・お客様の同意がある場合 ・当社のサービスプロバイダ間と共有する場合 ・セキュリティを目的とする場合 ・当社の法的義務を遵守する必要がある場合 ・事業法人または事業部門について支配者の変更または売却が行われた場合 当社が個人情報を販売することはありません。GitHubでは広告を掲載することもありません。 お客様の個人情報にアクセスするサービスプロバイダのリストはお客様自身で確認することができます。 |
| [その他の重要なお知らせ](#other-important-information)                                                | 当社は、Github上のリポジトリコンテンツや公開情報、Organizationに関して個別の追加情報を提供します。                                                                                                                                                                                        |
| [追加サービス](#additional-services)                                                             | 当社は、サードパーティアプリケーションやGitHub Pages、GitHubアプリケーションを含む追加のサービス提供についての情報を提供します。                                                                                                                                                                         |
| [当社が収集した情報についてお客様がアクセスし管理する方法](#how-you-can-access-and-control-the-information-we-collect) | 当社は、お客様に対して、お客様の個人情報にアクセス、変更または削除する方法を提供します。                                                                                                                                                                                                      |
| [当社のクッキー及びトラッキングの使用について](#our-use-of-cookies-and-tracking)                                 | 当社では、ウェブサイトの機能全般においてクッキーを使用します。また、当社サイトの一部においてトラッキングおよび分析サービスを使用します。 当社は、このクッキーとトラッキングについて透明性の高いページを提供します。 詳細は、本セクションをご覧ください。                                                                                                                     |
| [お客様情報についての当社の保護方法](#how-github-secures-your-information)                                  | 当社では、GitHub上のお客様の個人情報の秘密性、統合性及び可用性を保護するために合理的なすべての必要な措置を講ずるとともに、サーバーのレジリエンスを保護します。                                                                                                                                                                |
| [GitHubのグローバルプライバシープラクティス](#githubs-global-privacy-practices)                              | We provide the same high standard of privacy protection to all our users around the world.                                                                                                                                                        |
| [当社とお客様との連絡方法](#how-we-communicate-with-you)                                               | 当社は、お客様にemailでご連絡します。 アカウント設定または当社にご連絡いただければ、当社からお客様への方法を管理できます。                                                                                                                                                                                  |
| [苦情の解決](#resolving-complaints)                                                             | In the unlikely event that we are unable to resolve a privacy concern quickly and thoroughly, we provide a path of dispute resolution.                                                                                                            |
| [プライバシーステートメントの変更](#changes-to-our-privacy-statement)                                      | 当社は、本プライバシーステートメントの重大な変更について当該変更が有効となる30日前に、お客様に通知します。 お客様は、変更を当社のサイトポリシーリポジトリにおいて確認することもできます。                                                                                                                                                    |
| [ライセンス](#license)                                                                          | 本プライバシーステートメントは、[Creative Commons Zero license](https://creativecommons.org/publicdomain/zero/1.0/)の元でライセンス付与されています。                                                                                                                              |
| [GitHubへの連絡](#contacting-github)                                                           | 当社のプライバシーステートメントに関するご質問がある場合はお気軽にお問い合わせください。                                                                                                                                                                                                      |
| [翻訳](#translations)                                                                        | 当社では、一部のプライバシーステートメントの翻訳のリンクを提供しています。                                                                                                                                                                                                             |

## GitHubのプライバシーについての声明

### GitHubが収集する情報

「**ユーザ個人情報**」とは、当社のユーザの誰か１人に関する何らかの情報であり、単独またはほかの情報と合わせることでユーザを個人として識別できる、または、ユーザと合理的に結びつける、もしくは、関連づけることができるものとします。 「ユーザ個人情報」は、たとえば、ユーザ名やパスワード、メールアドレス、本名、IPアドレスや画像です。

ユーザ個人情報には、集合的で、個人的でない識別情報は含まないものとし、ユーザを特定できない、または、ユーザと合理的に結び付けられない、もしくは、関連づけられないものは含みません。 当社は、かかる集合的で個人的でない識別情報を、調査ならびに当社のウェブサイトおよびサービスの運営や分析、最適化を目的として使用することがあります。

#### ユーザがGitHubに直接提供する情報

##### Registration information
当社は、アカウント作成時に基本情報を要求しています。 当社は、お客様がユーザ名とパスワードを生成する時に有効なメールアドレスを要求します。

##### Payment information
有料でのアカウントにサインオンする場合や、GitHub Sponsors Programを通じて送金する場合、GitHub Marketplaceでアプリケーションを購入する場合、当社は、お客様のフルネーム、住所およびクレジットカード情報またはPayPal情報を収集します。 GitHubは、お客様のクレジットカード情報またはPaypal情報を処理または保管しませんが、第三者の支払処理者はこれを行うことにご留意ください。

If you list and sell an application on [GitHub Marketplace](https://github.com/marketplace), we require your banking information. If you raise funds through the [GitHub Sponsors Program](https://github.com/sponsors), we require some [additional information](/github/supporting-the-open-source-community-with-github-sponsors/becoming-a-sponsored-developer#submitting-your-bank-information) through the registration process for you to participate in and receive funds through those services and for compliance purposes.

##### Profile information
お客様は、フルネーム、写真を含むアバター、経歴、位置情報、会社、第三者のウェブサイトへのURLなどのお客様のアカウントプロフィールの追加情報を当社に提供するかどうかを選択できます。 この情報には、ユーザの個人情報が含まれる可能性があります。 プロフィール情報は、当社のサービスを使用する他のユーザからも閲覧ができますのでご注意ください。

#### サービスを使用することによってGitHubが収集する情報

##### Transactional information
有料でのアカウントを持っている場合、[GitHub Marketplace](https://github.com/marketplace)に掲載したアプリケーションを販売した場合、または、[GitHub Sponsors Program](https://github.com/sponsors)を通じて資金を調達した場合、当社は、日付、時間や請求金額など、本サービス上でのお客様のトランザクションについての一定の情報を自動的に収集します。

##### Usage information
お客様が当社のサービスまたはウェブサイトにアクセスしている場合、当社は、ほとんどのサービスが収集する情報を、お客様の同意が必要な場合はその同意を得て、自動的に収集します。 この収集する情報は、閲覧しているページ、参照したページ、IPアドレスおよびセッション情報ならびに。それぞれのリクエストの日付および時間などのお客様のサービス利用方法を含みます。 この情報は、アカウントを保有しているかどうかに関わらず、ウェブサイトのすべての訪問者から収集しています。 この情報には、ユーザ個人情報を含む可能性があります。

##### Cookies and similar technologies information
下記でさらに記載しているとおり、かつ、お客様の同意が必要な場合はその同意を条件として、当社は、お客様のログインを継続するため、お客様の環境設定を記憶するため、ならびに、お客様およびそのデバイスを識別するために、クッキーおよび類似する技術（クッキーIDや設定など）から自動的に情報を収集します。

##### Device information
当社は、IPアドレス、ブラウザまたはクライアントアプリケーション情報、言語設定、オペレーティングシステムとアプリケーションバージョン、デバイスの種類とID、デバイスのモデルとメーカーなど、お客様のデバイスについての一定の情報を収集することがあります。 この情報には、ユーザ個人情報を含む可能性があります。

#### 当社から第三者から収集する情報

GitHubは、第三者からユーザの個人情報を収集することがあります。 たとえば、お客様が、トレーニングにサインアップしたり、当社のベンダー、パートナーや関連会社からGitHubについての情報を受け取る場合に、行われる可能性があります。 GitHubは、第三者からのデータブローカーからユーザ個人情報を購入することはありません。

### 当社が収集しない情報

当社は、 「**[センシティブな個人情報](https://gdpr-info.eu/art-9-gdpr/)**」を意図的に収集することはありません。 この情報には、人種または民族的出自、政治上の意見、宗教的または哲学的な信念、あるいは労働組合への加入、自然人を一意に識別する遺伝子データまたはバイオメトリックデータの処理、健康状態に関するデータ、または、性生活や性的指向に関するデータを含みます。 当社のサーバー上でセンシティブな個人情報を保管することを選択した場合、お客様は、当該データに関する一切の規制に従う責任を負うものとします。

お客様が13歳未満のこどもの場合、GitHub上でアカウントを保有することはできません。 GitHubは、13歳以下のこどもから意図的に情報を収集せず、および、13歳以下のこどもを対象としたコンテンツを提供しません。 当社がお客様が13歳未満であることを知った場合、または、そうだと疑う理由がある場合、当社はお客様のアカウントを閉鎖しなければなりません。 当社はお客様がコードを学習することを止めたくはありませんが、これらは規則なのです。 アカウント解除についての情報は、[「利用規約」](/github/site-policy/github-terms-of-service)を参照してください。 様々な国は異なる年齢制限を設けており、お客様がお客様の国でデータ収集に同意できる年齢未満である場合、GitHub上のアカウントを保有することはできません。

当社は、**お客様のリポジトリ**に保管されたユーザ個人情報またはその他の何らかのフォームに入力した内容について、意図的に収集することはありません。 ユーザリポジトリ内の個人情報の一切については、リポジトリのオーナーがその責を負うものとします。

### 当社のお客様情報の利用方法

- 当社は、次の目的のためにお客様の情報を共有することがあります：
- 当社は、アカウントを作成するため、および、サービスを提供するために、お客様の [登録情報](#registration-information)を利用します。
- 当社は、有料アカウントサービス、Marketplaceサービス、Sponsors Programまたはその他のお客様が希望するGitHubの有料サービスを提供するために、お客様の[支払い情報](#payment-information) を利用します。
- 当社は、ユーザ個人情報（特にユーザ名）をGitHub上でお客様を識別するために利用します。
- 当社は、お客様が希望する場合、お客様のアカウントプロフィールに記入するため、および、他のユーザとそのプロフィールを共有するために、お客様の[プロフィール情報](#profile-information)を利用します。
- 当社は、お客様のメールアドレスをお客様にご連絡するために利用します。お客様がOKといった場合、**そして、OKといった理由に限ります**。 詳細は、[emailコミュニケーション](#how-we-communicate-with-you)を参照してください。
- 当社は、サポートリクエストに回答するためにユーザ個別情報を利用します。
- 当社は、ユーザ個人情報およびその他のデータを、お客様がフォローまたはコントリビュートしたいと思う可能性のあるプロジェクトの提案など、お客様へのおススメを行うために利用します。 当社は、お客様のコーディングの関心を判断し、類似プロジェクトを推奨するために、Starを付けたプロジェクトなどお客様のGitHub上の公開行動から学習します。 これらのおススメは自動的な判断ですが、お客様の権利への法的影響は一切ありません。
- 当社は、お客様の同意が必要な場合はその同意を得たうえで、アンケート、ベータプログラムまたはその他のリサーチプロジェクトにお客様を勧誘するために、ユーザ個人情報を利用します。
- 当社は、当社ユーザのGitHub利用方法をより理解し、当社のウェブサイトやサービスを改善するために、[利用情報](#usage-information)および[デバイス情報](#device-information)を利用します。
- 当社は、セキュリティ目的や、GitHubまたはユーザを攻撃する詐欺または試みを調査するために、お客様のユーザ個人情報を利用することがあります。
- 当社は、当社の法的義務の遵守、当社の知的財産権の保護および[利用規約](/github/site-policy/github-terms-of-service)実施のために、ユーザ個人情報を利用することがあります。
- 当社は、ユーザ個人情報の利用を、このプライバシーステートメントに記載した目的に限るものとします。 当社が他の目的のためにお客様のユーザ個人情報を利用する必要がある場合、先立ってお客様の許可を求めるものとします。 お客様は、[ユーザプロフィール](https://github.com/settings/admin)で、当社が保有する情報、当社の利用方法およびお客様が当社に与えた許可を閲覧できます。

#### 情報処理における根拠法令

お客様のユーザ個人情報の処理が、一定の国際法(EUのGDPRを含むがこれに限らない) の対象である範囲において、GitHubはユーザ個人情報を処理する根拠法令についてお客様の通知が要求されています。 GitHubは、次の法的プロセスにおいてユーザ個人情報を処理します。

- 契約の履行
  * お客様がGitHubアカウントを作成する場合、お客様は[登録情報](#registration-information)を提供します。 当社は、この情報をお客様が当社との利用規約を締結するために要求します。当社は、この情報を契約を履行する用途に利用します。 当社は、さらに、お客様のユーザ名およびメールアドレスを他の法的根拠にもとづき利用します。
  * お客様が当社に有料アカウントを保有している場合、当社は、契約を履行する用途のために、追加で[支払い情報](#payment-information)を収集し処理します。
  * お客様がMarketplaceに掲載されたアプリケーションを売買する場合、または、GitHub Sponsors Programを通じて金銭の授受を行う場合、当社は、これらのサービスに適用される契約を履行するために、[支払い情報](#payment-information)および追加情報を処理します。
- 同意
  * 当社は、次の状況において、お客様のユーザ個人情報を利用することにお客様の同意を必要としています。 ・[ユーザプロファイル](https://github.com/settings/admin)に情報を記入した時 ・GitHubトレーニング、リサーチプロジェクト、ベータプログラムまたは調査に参加すると決めた時 ・マーケティングを目的とする時（該当する場合） このユーザ個人情報のすべては選択的なものであり、お客様は、随時、これにアクセス、修正および削除することができます。 お客様はメールアドレスを完全に削除することはできませんが、非公開にすることはできます。 お客様は随時、同意を撤回することができます。
- 追加要求事項
  * 一般的に、当社が行うユーザ個人情報の処理のリマインダーは、追加要求事項を目的とするものです。たとえば、法令遵守、セキュリティおよびGitHubのシステム、ウェブサイトおよびサービスの現在の秘密、統合性、利用可能性およびレジリエンスを保持することを目的としています。
- 同意に基づき当社が処理するデータの削除をご希望の場合、または、当社による個人情報の処理に同意できない場合は[プライバシー連絡フォーム](https://support.github.com/contact/privacy)をご利用ください。

### 当社が収集したお客様の情報の共有方法

当社は以下に記載された状況でお客様のユーザ個人情報を第三者に提供する場合があります。

#### お客様の同意を得た場合
当社は、当社がどの情報を誰とどのような理由で共有するのかお知らせした後にお客様が同意した場合に、ユーザ個人情報を共有します。 たとえば、Marketplaceに掲載されているアプリケーションをお客様が購入した場合、当社は、アプリケーション開発者がサービスをお客様に提供できるようにするためにユーザ名を共有します。 さらに、お客様は、ユーザ個人情報を共有することについてGitHub上でのアクションを通じて当社に指示することもできます。 たとえば、お客様がOrganizationに参加する場合、OrganizationのオーナーにOrganizationのアクセスログを使ってお客様のアクティビティを表示する権限を付与したい旨を指示できます。

#### サービスプロバイダーに提供する場合
当社は、ユーザ個人情報を限定数のサービスプロバイダと共有します。当該情報を処理するサービスプロバイダは、データ保護契約または類似の約束に署名することで、当社のプライバシーステートメントに類似するプライバシー制限に同意し、当社に代わって当社のサービスを提供または改善します。 当社のサービスプロバイダは、支払い処理、カスタマーサポートのチケット発行、ネットワークデータの移行、セキュリティおよびその他の類似サービスを履行します。 GitHubは、ユーザ個人情報のすべてを米国で処理しますが、当社のサービスプロバイダは、米国またはEU以外でデータを処理することがあります。 当社のサービスプロバイダを知りたい場合、当社ページ[GitHubのサブプロセッサ](/github/site-policy/github-subprocessors-and-cookies)を参照してください。

#### セキュリティを目的とする場合
If you are a member of an Organization, GitHub may share your username, [Usage Information](#usage-information), and [Device Information](#device-information) associated with that Organization with an owner and/or administrator of the Organization, to the extent that such information is provided only to investigate or respond to a security incident that affects or compromises the security of that particular Organization.

#### 法令にもとづく開示を求められた場合
GitHubは、法的手続きおよび法的義務を遵守するために透明性を保つ努力をしています。 法令または裁判所の命令によりその努力が妨げられない限り、または、稀なケースには緊急事態が発生しない限り、当社は、法令が要求するお客様の情報の開示について、お客様に通知するために合理的な努力を行います。 GitHubは、有効な召喚令状、裁判所の命令、捜索令状、類似の政府命令が要求する場合、または、当社の法的義務の遵守するため、または、当社、第三者もしくは一般社会の財産もしくは権利を保護するために開示することが必要だと当社が誠意をもって信ずる場合、当社が収集したお客様のユーザ個人情報またはその他の情報を、法執行措置に対して開示します。

法的な要求に対する当社の情報開示についての詳細は、[ユーザデータに対する法的要求についてのガイドライン](/github/site-policy/guidelines-for-legal-requests-of-user-data)を参照してください。

#### 管理者の変更または売却があった場合
当社は、企業法人または事業部門の吸収、売却または合併に関与した場合、ユーザ個人情報を共有することがあります。 所有権の変更が発生した場合、当社は、ユーザ個人情報の秘密性を保持する条項にもとづいてこれが行われることを確実にし、かつ、当社はお客様のユーザ個人情報を移行する前に、ウェブサイトまたはemailにてお客様に通知します。 ユーザ個人情報を受け取るOrganizationは、当社がプライバシーステートメントまたは利用規約で行った約束を尊重する必要があります。

#### 集合的で個人的でない識別情報
当社は、ユーザが、集合的に、GitHubをどのように利用するか、または、カンファレンスやイベントなどの当社のその他の提供に対してユーザがどのように反応するかに関する、特定の集合的で個人的でない識別情報を他者と共有します。 たとえば、[当社は、GitHub全体のオープンソースアクティビティの統計をコンパイルすることなどがあります](https://octoverse.github.com/)。

当社がお客様の個人情報を金銭または他の対価のために売却**することはありません**。

備考：2018年カリフォルニア州消費者プライバシー法（「CCPA」）では、事業体が自らのプライバシーポリシーにおいて、お客様の個人情報を金銭または他の対価と交換で、個人情報を公開するかどうかを記述することを要求しています。 While CCPA only covers California residents, we voluntarily extend its core rights for people to control their data to _all_ of our users, not just those who live in California. CCPAおよび当社の遵守についての詳細は[こちら](/github/site-policy/githubs-notice-about-the-california-consumer-privacy-act)を参照してください。

### その他の重要なお知らせ

#### リポジトリコンテンツ

GitHub personnel [do not access private repositories unless required to](/github/site-policy/github-terms-of-service#e-private-repositories) for security purposes, to assist the repository owner with a support matter, to maintain the integrity of the Service, or to comply with our legal obligations. However, while we do not generally search for content in your repositories, we may scan our servers and content to detect certain tokens or security signatures, known active malware, or other content known to violate our Terms, such as violent extremist or terrorist content or child exploitation imagery based on algorithmic fingerprinting techniques. 当社の利用規約について、[より詳細な内容](/github/site-policy/github-terms-of-service#e-private-repositories)を提供します。

リポジトリが公開されている場合、誰でもそのコンテンツを閲覧できます。 公開リポジトリにメールアドレスまたはパスワードなどのプライベート、秘密または[センシティブな個人情報](https://gdpr-info.eu/art-9-gdpr/)が含まれる場合、その情報はサーチエンジンによりインデックス化されることがあります。または、第三者に利用されることもあります。

[公開リポジトリのユーザ個人情報](/github/site-policy/github-privacy-statement#public-information-on-github)を参照してください。

#### GitHub上の公開情報

GitHubサービスおよび機能の多くは公開向けです。 お客様のコンテンツが公開向けの場合、第三者が、お客様のプロフィールもしくはリポジトリの閲覧または当社のAPIを介してデータをプルするなど、当社の利用規約にもとづきアクセスかつ利用できます。 当社は、そのコンテンツを販売しません。これはお客様の所有物です。 しかし、当社は、研究機関やアーカイブなどの第三者に対して、公開向けのGitHub情報をコンパイルすることを認めています。 データブローカーなどの他の第三者も、GitHubをスクレイプし、データをコンパイルしていることは知られています。

お客様のコンテンツに関係するユーザ個人情報はGitHubデータのコンパイルによって第三者が収集する場合があります。 お客様が第三者によるGitHubデータのコンパイルにユーザ個人情報が含まれることを望まない場合、ユーザ個人情報を公開しないようにしてください。そして、[gitコミット設定](/github/setting-up-and-managing-your-github-user-account/setting-your-commit-email-address)で、[ユーザプロフィールでメールアドレスを非公開に設定してください](https://github.com/settings/emails)。 当社は現在、デフォルト設定ではユーザのメールアドレスを非公開に設定しています。ただし、レガシーのGitHubユーザは設定をアップデートしなくてはならない場合があります。

GitHubデータをコンパイルしたい場合、お客様は、[スクレイピング](/github/site-policy/github-acceptable-use-policies#5-scraping-and-api-usage-restrictions)および[プライバシー](/github/site-policy/github-acceptable-use-policies#6-privacy)に関する当社の利用規約を遵守しなければなりません。ならびに、お客様は、収集した公開向けユーザ個人情報を、当社のユーザが許可した目的に限り利用できるものとします。 たとえば、GitHubユーザが識別および属性用途のためにメールアドレスを公開向けとした場合、当該メールアドレスを商業広告に利用しないものとします。 当社は、お客様が、GitHubから収集したあらゆるユーザ個人情報を合理的に保護すること、ならびに、 GitHubまたは他のユーザからの苦情、削除要請および連絡拒否のリクエストに速やかに対応することを要求します。

これに類して、GitHub上のプロジェクトは、コラボレーティブ処理の一部として収集した公開されている利用可能なユーザ個人情報を含むことがあります。 GitHub上のユーザ個人情報について苦情がある</a>場合、[苦情の解決](/github/site-policy/github-privacy-statement#resolving-complaints)を参照してください。


#### Organization

さらに、お客様は、GitHub上でのアクションを通じて、ユーザ個人情報を共有するために指示することができます。 Organizationでコラボレートしている場合またはそのOrganizationのメンバーとなったの場合、そのアカウントオーナーはお客様のユーザ個人情報を受け取ることができます。 Organizationへの招待を承認した場合、オーナーが閲覧できる情報の種類についてお客様に通知されます。（詳細は、[Organizationメンバーシップについて](/github/setting-up-and-managing-your-github-user-account/about-organization-membership)を参照してください） [認証ドメイン](/github/setting-up-and-managing-organizations-and-teams/verifying-your-organizations-domain)付きOrganizationへの招待を承認した場合、Organizationのオーナーは、Organizationの認証ドメイン内でお客様の完全なメールアドレスを閲覧できます。

Please note, GitHub may share your username, [Usage Information](#usage-information), and [Device Information](#device-information) with the owner(s) of the Organization you are a member of, to the extent that your User Personal Information is provided only to investigate or respond to a security incident that affects or compromises the security of that particular Organization.

お客様が、このプライバシーステートメントに対する[企業向け利用規約](/github/site-policy/github-corporate-terms-of-service)およびData Protection Addendum (DPA) について同意しているアカウントでコラボレートしている場合またはそのメンバーの場合、アカウントでのお客様のアクティビティに関係するこのプライバシーステートメントとDPAの間に矛盾があった場合、DPAを優先するものとします。

Organizationでお客様のユーザ個人情報を処理する方法およびお客様がアカウントでユーザ個人情報にアクセス、アップデート、変更または削除する方法についての詳細情報はアカウントオーナーにご連絡ください。

### 追加サービス

#### サードパーティアプリケーション

お客様は、アカウントで「Developer Products」として知られるサードパーティアプリケーションを有効化または追加することを選択できます。 このDeveloper Productsは、お客様がGitHubを利用するにあたって、必ずしも必要なものではありません。 当社は、MarketplaceからDeveloper Productを購入する場合などお客様の要望があったとき、ユーザ個人情報を第三者と共有します。しかし、第三者のDeveloper Productの利用およびユーザ個人情報を共有する量の選択については、お客様がその責を負うものとします。 お客様のGitHubプロフィールを利用してDeveloper Productに認証した場合、どの情報が提供されるのか[API documentation](/v3/users/)で確認できます。

#### GitHub Pages

GitHub Pagesウェブサイトを作成する場合、お客様は、個人情報およびその他の訪問者の情報の収集、利用および共有方法ならびに適用されるデータプライバシー法令、規則および規定の遵守方法を正確に記述するプライバシーステートメントを掲載する責任を負うものとします。 GitHubは、法的義務を遵守するためならびにウェブサイトおよびサービスのセキュリティおよび統合性を保持するために、お客様のGitHub Pagesウェブサイトへの訪問者から、IPアドレスを含むユーザ個人情報を収集することがあります。

#### GitHubアプリケーション

You can also add applications from GitHub, such as our Desktop app, our Atom application, or other application and account features, to your Account. これらのアプリケーションは、それぞれ固有の規約を有しており、異なる種類のユーザ個人情報を収集する可能性があります。ただし、すべてのGitHubアプリケーションに対してこのプライバシーについての声明が適用されます。当社はユーザ個人情報を必要な分だけ収集し、お客様の提供目的に限って利用するものとします。

### 当社が収集した情報についてお客様がアクセスし管理する方法

お客様がすでにGitHubユーザである場合、[ユーザプロフィールを編集](https://github.com/settings/profile)または[GitHub Support](https://support.github.com/contact)もしくは[GitHubPremium Support](https://enterprise.githubsupport.com/hc/en-us)に連絡することで、お客様の基本ユーザプロフィール情報にアクセス、変更または削除することができます。 当社がお客様について収集する情報は、プロフィールに掲載する情報を限定する、お客様の情報を最新に保つ、または[GitHub Support](https://support.github.com/contact)もしくは[GitHubPremium Support](https://enterprise.githubsupport.com/hc/en-us)に連絡することにより管理できます。

GitHubが[第三者から取得した情報](#information-we-collect-from-third-parties)などのお客様の情報を処理する場合において、お客様がアカウントを保有していないとき、適用される法令にもとづき、お客様は[GitHub Support](https://support.github.com/contact)または[GitHub Premium Support](https://enterprise.githubsupport.com/hc/en-us)に連絡することで、お客様の個人情報の処理にアクセス、変更、削除または反対することができます。

#### データポータビリティ

GitHubユーザとして、お客様は、常に自らのデータを保有することができます。 たとえば、[お客様のリポジトリをデスクトップにクローン](/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop)できます。または、当社が保有するお客様の情報をダウンロードするために、当社の[データポータビリティツール](https://developer.github.com/changes/2018-05-24-user-migration-api/)を利用できます。

#### データの保持とデータの削除

GitHubは、一般的に、ユーザ個人情報をアカウントがアクティブである限りまたはサービス提供に必要な限り保持します。

お客様がアカウントをキャンセルしたい場合またはユーザ個人情報を削除したい場合、お客様の[ユーザプロフィール](https://github.com/settings/admin)で行うことができます。 当社は、法的義務の遵守、紛争解決および当社の契約を実行するためにお客様の情報を保持かつ利用します。法的な要求がある場合を除き、お客様の要望から90日以内に、合理的な範囲でお客様のすべてのプロフィールを削除します。 お客様は、30日以内の同意にもとづき当社が処理したデータを抹消を要求するために、[GitHub Support](https://support.github.com/contact)または[GitHub Premium Support](https://enterprise.githubsupport.com/hc/en-us)に連絡できます。

アカウントが削除された後でも、他のユーザのリポジトリへのコントリビューションおよび他のIssueのコメントなどの一定のデータは残存します。 しかし、当社は、[ゴーストユーザ](https://github.com/ghost)と関係付けることで、Issue、pull requestおよびコメントの作者フィールドからユーザ名およびメールアドレスを含むユーザ個人情報を削除または識別不能にします。

つまり、[Gitコミット設定](/github/setting-up-and-managing-your-github-user-account/setting-your-commit-email-address)を通じてお客様が提供したメールアドレスは、Gitシステムのコミットで常に関係付けられることになります。 メールアドレスを非公開にする場合、Gitコミット設定もアップデートする必要があります。 当社は、Gitコミット履歴のデータを変更または削除することはできません。Gitソフトウェアは記録を保持する設計になっています。ただし、当社は、お客様がその記録に入力する情報を管理できるようにします。

### 当社のクッキー及びトラッキングの使用について

#### クッキー

GitHubは、当社のサービスとのインターアクションを容易かつ有意義なものとするためにクッキーを利用します。 Cookie は、ウェブサイトが訪問者のコンピュータまたはモバイルデバイスに度々格納する小さなテキストファイルです。 当社は、お客様のログインの保持、お客様の設定の記憶およびGitHubの今後の開発のための情報提供を目的として、クッキー（およびHTML5 localStorageのような類似技術）を利用します。 セキュリティ目的のため、当社では、デバイスを識別するためにクッキーを利用しています。 当社のウェブサイトを利用することで、お客様は、お客様のコンピュータまたはデバイスにこれらの種類のクッキーを当社が保管することに同意したものとされます。 お客様がこれらのクッキーを許可するブラウザまたはデバイスの能力を無効にした場合、GitHubのサービスにログインまたは利用することはできなくなります。

当社は、当社が設定するクッキー、これらのクッキーの必要性およびそれらのクッキーの種類（テンポラリーもしくはパーマネント）について記載した、[クッキーおよびトラッキング](/github/site-policy/github-subprocessors-and-cookies)についてのウェブページを提供します。 当社はサードパーティアナリティクスプロバイダおよびその他のサービスプロバイダの一覧を掲載し、かつ、当社のウェブサイトのどの部分についてトラッキングを許可しているのか詳細を掲載します。

#### トラッキングおよびアナリティクス

当社は、当社のユーザによるGitHubの利用の評価、アクティビティの統計レポートのコンパイルならびに当社のコンテンツおよびウェブサイトのパフォーマンスの向上に役立つ、一定数のサードパーティアナリティクスおよびサービスプロバイダを利用しています。 当社は、当社のウェブサイトの一定のエリアでのみこれらのサードパーティアナリティクスプロバイダを利用します。これらのプロバイダはすべて、収集できるユーザ個人情報の種類および情報を処理する目的を制限するデータ保護規約を当社と締結しています。 さらに、当社は、機能を提供ならびにコンテンツおよびパフォーマンスを向上するために内部でアナリティクスソフトウェアを利用します。

一定のブラウザは、「追跡拒否（DNT)」機能が組み込まれており、訪問するウェブサイトに対してトラッキングを望まないシグナルを発信できます。 GitHubは、ブラウザのDNTシグナルに応答し、[DNTシグナルへの応答についてのW3C基準](https://www.w3.org/TR/tracking-dnt/)に従います。 DNTをサポートするブラウザでDNTを有効にしていない場合、当社のウェブサイトの一定箇所は、お客様の他のサービスにおけるオンラインブラウジングアクティビティを繰り返しトラッキングします。ただし、当社は、当社のアナリティクスおよびサービスプロバイダ以外の第三者に対して、GitHub上のユーザのアクティビティを繰り返しトラッキングすることを許可しません。

### お客様情報についての当社の保護方法

GitHubは、不正アクセス、変更および破壊からユーザ個人情報を保護するため、そして、データの正確性を保持しユーザ個人情報が適切に利用されることを確実にするために必要なすべての措置を講じます。

GitHubは、書面によるセキュリティ情報プログラムを実行しています。 当社のプログラム：
- 業界で評価されているフレームワークと提携
- 当社のユーザのデータの秘密性、統合性、利用可能性およびレジリエンスを保護するために合理的に設計されたセキュリティセーフガードを装備
- GitHubの事業遂行に適切な性質、サイズおよび複雑性
- インシデントに対する応答およびデータ侵害通知プロセスを装備
- GitHubがビジネスを行う地理的地域において適用される情報セキュリティ関係法令に適合

お客様のユーザ個人情報に影響を与えるデータ侵害が発生した場合、当社は、速やかに侵害の影響を判断し、遅滞なく影響を受けたユーザに対して通知します。

GitHub上のデータの転送は、SSHおよびHTTPS (TLS) を利用して暗号化されます。Gitリポジトリコンテンツも暗号化されます。 当社は、高レベルの物理的およびネットワークセキュリティを有する第一級のデータセンターで自社所有のかごとラックを管理しています。データをサードパーティのストレージプロバイダーで管理する場合、暗号化されます。

いかなる転送方法または電子的保管方法も、100%安全ではありません。 したがって、当社は絶対的なセキュリティを保証できません。 詳細は、[セキュリティディスクロージャー](https://github.com/security)を参照してください。

### GitHubのグローバルプライバシープラクティス

GitHub, Inc. and, for those in the European Economic Area, the United Kingdom, and Switzerland, GitHub B.V. are the controllers responsible for the processing of your personal information in connection with the Service, except (a) with respect to personal information that was added to a repository by its contributors, in which case the owner of that repository is the controller and GitHub is the processor (or, if the owner acts as a processor, GitHub will be the subprocessor); or (b) when you and GitHub have entered into a separate agreement that covers data privacy (such as a Data Processing Agreement).

Our addresses are:

- GitHub, Inc., 88 Colin P. Kelly Jr. Street, San Francisco, CA 94107.
- GitHub B.V., Vijzelstraat 68-72, 1017 HL Amsterdam, The Netherlands.

We store and process the information that we collect in the United States in accordance with this Privacy Statement, though our service providers may store and process data outside the United States. しかし、当社は、プライバシーについて様々な期待をする、様々な国および地域のユーザがいることを理解しています。当社は、米国が他の国んと同じプライバシーフレームワークを有していない場合でも、その必要性を充たす努力をします。

We provide the same high standard of privacy protection—as described in this Privacy Statement—to all our users around the world, regardless of their country of origin or location, and we are proud of the levels of notice, choice, accountability, security, data integrity, access, and recourse we provide. 当社は、ビジネスを行う場所に関係なく、当社のプライバシー適合のために努力を行うクロスファンクショナルチームの一員としての当社のデータ保護責任者とともに、適用されるデータプライバシー法令に適合するために全力を尽くしています。 加えて、当社のベンダーまたは関係会社がユーザ個人情報にアクセスする場合、当社のプライバシーポリシーおよび適用されるデータプライバシー法令にしたがうことを要求する契約を締結しなければなりません。

主要な点

 - GitHubは、同意にもとづいてユーザ個人情報を収集する場合、データ収集時に明確、精通、具体的かつ自由に同意された、分かりやすい方法を提供します。
 - 当社は、当社の目的に必要な最小限の個人情報を収集します。ただし、お客様がさらに提供することを選択した場合は除きます。 当社は、お客様が共有してよいと思うデータの量に限って、当社に提供することを推奨します。
 - 当社は、法令で認められている場合、当社が収集したユーザ個人情報にアクセス、変更および削除するためのシンプルな方法をお客様に提供します。
 - 当社は、ユーザ個人情報に関係して、ユーザに対して通知、選択肢、アカウンタビリティ、セキュリティおよびアクセスを提供します。かつ、当社は、ユーザ個人情報を処理する目的を限定します。 当社は、ユーザがリコースおよび実行する方法を当社のユーザに提供します。

#### クロスボーダーデータトランスファー

GitHub processes personal information both inside and outside of the United States and relies on Standard Contractual Clauses as the legally provided mechanism to lawfully transfer data from the European Economic Area, the United Kingdom, and Switzerland to the United States. In addition, GitHub is certified to the EU-US and Swiss-US Privacy Shield Frameworks. To learn more about our cross-border data transfers, see our [Global Privacy Practices](/github/site-policy/global-privacy-practices).

### 当社とお客様との連絡方法

当社は、お客様のメールアドレスをお客様にご連絡するために利用します。お客様がOKといった場合、**そして、OKといった理由に限ります**。 たとえば、お客様が当社のサポートチームにリクエストを連絡した場合、当社はemailでお返事します。 お客様は、GitHubでのメールアドレスの使用方法および共有方法について様々な管理を行えます。 お客様は、[ユーザプロフィール](https://github.com/settings/emails)で、コミュニケーションの設定を管理できます。

設計によって、Gitバージョン管理システムは、コミットメッセージなどのユーザのメールアドレスを伴う様々なアクションと協業します。 当社は、Gitシステムの多くの要素を変更することはできません。 パブリックリポジトリにコメントしている場合でも、お客様がメールアドレスを非公開のままにすることを希望するとき、[お客様はユーザプロフィールで非公開メールアドレスを作成できます](https://github.com/settings/emails)。 You should also [update your local Git configuration to use your private email address](/github/setting-up-and-managing-your-github-user-account/setting-your-commit-email-address). このことで、当社からお客様への連絡方法は変わりません。しかし、他のユーザにとってのお客様の表示に影響を及ぼします。 当社は、デフォルト設定では現在のユーザのメールアドレスを非公開に設定しています。ただし、レガシーのGitHubユーザは、設定をアップデートする必要がある可能性があります。 Please see more about email addresses in commit messages [here](/github/setting-up-and-managing-your-github-user-account/setting-your-commit-email-address).

お客様の[email設定](https://github.com/settings/emails)によっては、GitHubは、時々、お客様がWatchしているリポジトリでの変更、新機能、フードバックのお願い、重要なポリシーの変更または顧客サポートを提供するために、通知のemailを送信することがあります。 また、当社は、お客様の選択ならびに適用される法令および規則にしたがって、マーケティングのemailを送信します。 当社がお客様に送信するマーケティングemailの文末には、「サブスクライブ解除」のリンクがあります。 当社から、サポートチームまたはシステムemailなどの重要なコミュニケーションの受け取りを解除することはできません。ですが、その他のコミュニケーションについては、プロフィールの通知設定を変更することで解除できます。

当社のemailには、お客様がemailを開封したかどうか、および、IPアドレスを当社に知らせる小さく明瞭な画像であるピクセルタグを含むことがあります。 当社は、emailをお客様によって効果的にするために、および、望まれないemailを当社がお客様に送信しないことを確実にするために、このピクセルタグを利用します。

### 苦情の解決

ユーザ個人情報の当社の取り扱い方法についてお客様が懸念を有している場合、ただちに当社にお知らせください。 当社はお客様を手助けしたいと考えています。 お客様は、[プライバシー連絡フォーム](https://support.github.com/contact/privacy)に記入することで、当社に連絡できます。 また、お客様は、サブジェクトを「Privacy Concerns」とした当社宛てe-mailを、、privacy@github.comに送信することができます。 当社は、遅くとも45日以内に速やかに返信します。

お客様は、当社のデータ保護責任者に直接連絡することもできます。

| 当社の米国本社                        | 当社のEU事務所           |
| ------------------------------ | ------------------ |
| GitHub Data Protection Officer | GitHub BV          |
| 88 Colin P. Kelly Jr. St.      | Vijzelstraat 68-72 |
| San Francisco, CA 94107        | 1017 HL Amsterdam  |
| 米国                             | The Netherlands    |
| privacy@github.com             | privacy@github.com |

#### 紛争解決プロセス

お客様のユーザ個人情報の当社の取り扱いについてお客様と当社との間に紛争が生起した場合、当社は解決のために最善を尽くします。 Additionally, if you are a resident of an EU member state, you have the right to file a complaint with your local supervisory authority, and you might have more [options](/github/site-policy/global-privacy-practices#dispute-resolution-process).

### プライバシーステートメントの変更

ほとんどの変更は軽微ですが、GitHubは、随時、プライバシーステートメントを変更することがあります。 当社は、ホームページに通知を掲載すること、または、GitHubアカウントで指定するプライマリメールアドレスにemailを送信することで、変更が発効する遅くとも30日前にウェブサイト上で、このプライバシーステートメントの重要な変更についてユーザへの通知を提供します。 また、当社は、このポリシーの変更を追跡している[サイトポリシーリポジトリ](https://github.com/github/site-policy/)をアップデートします。 重要ではない変更またはお客様に影響を与えない、このプライバシーステートメントの変更について、当社は、サイトポリシーリポジトリを頻繁に確認することを推奨します。

### ライセンス

本プライバシーステートメントは、この[Creative Commons Zero license](https://creativecommons.org/publicdomain/zero/1.0/)の元でライセンス付与されています。 詳細は、[サイトポリシーリポジトリ](https://github.com/github/site-policy#license)を参照してください。

### GitHubへの連絡
GitHubプライバシーステートメントまたは情報処理についてのご質問は、[プライバシー連絡フォーム](https://support.github.com/contact/privacy)をご利用ください。

### 翻訳

下記は、本ドキュメントの他言語への翻訳です。 これらのバージョンと英語バージョンとの間に何らかの矛盾、曖昧さ、または、明らかな非一貫性がある場合、英語バージョンを優先的なバージョンとします。

#### フランス語
Cliquez ici pour obtenir la version française: [Déclaration de confidentialité de GitHub](/assets/images/help/site-policy/github-privacy-statement(12.20.19)(FR).pdf)

#### その他の翻訳

For translations of this statement into other languages, please visit [https://docs.github.com/](/) and select a language from the drop-down menu under “English.”
