---
title: GitHub Marketplace開発者同意書
redirect_from:
  - /articles/github-marketplace-developer-agreement
versions:
  free-pro-team: '*'
---

**以下の規約および条件（「同意書」）は、お客様のGitHubの「Marketplaceプログラム」への参加について規定するものです。 「Marketplaceプログラム」への参加登録を行うか、以下の [同意する] をクリックすることにより、お客様は本「同意書」を理解し、そのすべての規約および条件を受け入れたことを確認したことになります。  お客様が、企業またはその他の法人を代表して契約を締結しようとする場合、お客様は、本契約を締結するためにその法人に義務を負担させる法的権限を持つことを表明するものとし、この場合「お客様」とは、あなたが代表する法人のことを意味します。**

Effective Date: July 21, 2020

### 1.  定義

かぎ括弧に括られた用語のうち、本「同意書」において定義されていないものについては、[https://docs.github.com/articles/github-terms-of-service](/articles/github-terms-of-service)にある「GitHub利用規約」(「利用規約」) に記載されている用語の意味を持つものとします。

「アクション」とは、アプリケーションを作成することなく、GitHubで特定のタスクを実行するためのカスタムロジックを実装できる仕組みを意味します。

「ブランドの特徴」とは、各当事者それぞれが、随時所有する（またはライセンスを受ける）商標、トレードマーク、サービスマーク、ロゴ、ドメイン名、およびその他独自のブランドの特徴を意味します。

「開発者」とは、GitHubと関連して使用するためにソフトウェア、コンテンツ、およびデジタル素材を作成し、Marketplace経由でアクセスできるようにした会社または個人、すなわちお客様を意味します。

「開発者アプリケーション」または「開発者製品」とは、GitHubに関して使用するためお客様が作成し、「Marketplace」経由で入手できる「ソフトウェア」、コンテンツ、およびデジタル素材を意味しており、「アクション」を含みます。

「エンドユーザ」とは、「GitHub Marketplace」を通じて「開発者製品」を取得するあらゆる個人、企業、またはその他法人を意味します。

「GitHub API」とは、GitHub独自のアプリケーションプログラムインターフェースを意味します。  「GitHub API」へのアクセスおよび使用には、「利用規約」が適用されます。

「GitHub Marketplace」または「Marketplace」とは、GitHubが運営する独自のオンライン市場サイトを意味し、そこで「開発者製品」を「エンドユーザ」に配信することができます。

「リスティング」とは、「開発者製品」を掲載するため「GitHub Marketplace」上に提供されているコンテンツを意味します。

「税金」とは、あらゆる連邦、州、地方、または外国の所得税、総収入額税、事業税、予定納税、選択的最低額税、売上税、利用税、移転税、付加価値税、消費税、固定資産税、動産財産税、源泉徴収税その他あらゆる税金を意味し、またそれらに関するあらゆる利子、罰金、付帯税、その他付加されるものを含みます。

「利用状況データ」とは、「GitHub Marketplace」の「エンドユーザ」および「開発者製品」のライセンサーについて、「Marketplace」に関連して生成されたデータを意味し、利用統計や販売データを含みますが、これに限定されません。 なお、「利用状況データ」には、銀行および支払い情報は含まれないことを明示しておきます。

### 2.  目的およびライセンスの付与

**2.1** 本「同意書」は、「エンドユーザ」が「開発者製品」を購入し、GitHub.comに関連して使用するために、「開発者」が「GitHub Marketplace」の「リスティング」に掲載するにあたって従うべき規約および条件について規定するものです。  本「同意書」は、無料で配布される「開発者製品」および「エンドユーザ」に課金される「開発者製品」に適用されます。  「開発者」は、本「同意書」において許可されているか、適用法で許可されている目的においてのみ「GitHub Marketplace」を使用することに同意するものとします。  GitHubと「開発者」とに関しては、「開発者製品」は「開発者」が単独で責任を負うものとします。

**2.2**「開発者」は、GitHubに対し、以下の目的のために非独占的、世界的、譲渡可能、サブライセンス可能、全額払い込み済み、ロイヤルティフリーのライセンスを付与するものとします。（a）ホスト、リンク、複製、上演、展示、テスト、配布、利用可能化、ライセンス付与、およびその他の目的で「リスティング」を使用すること、（b）「Marketplace」の運営およびマーケティングに関連して、管理および実演の目的で「リスティング」について複製、実演、展示、使用、およびアクセスすること、（c）本契約に基づき「開発者」がGitHubに提供するあらゆる「開発者」の「ブランドの特徴」を、「Marketplace」に関連して用いる目的および本「同意書」に基づく義務を果たす目的においてのみ、複製、展示、配布、その他使用すること。

**2.3** 上記において付与されるライセンスに加え、GitHubは本「同意書」に基づいて「開発者」から提供された「開発者」の「ブランドの特徴」を、あらゆるプレゼンテーション、文書、マーケティング資料、プレスリリース、顧客リスト（GitHubのウェブサイトに投稿されるあらゆる顧客リストを含み、これに限定されない）、宣伝キャンペーン、およびその他「Marketplace」のマーケティングを目的とした販促物に含めることができます。  「開発者」が「Marketplace」において特定の「開発者製品」の配布を中止した場合、GitHubは商業的に合理的な期間が経過後、配布を中止した「開発者製品」の「ブランドの特徴」の使用を中止します。  本「同意書」のいかなる条項も、開発者に対してGitHubの「ブランドの特徴」を使用する権利を与えるものではありません。

**2.4** 「開発者」は、「Marketplace」に関連する「開発者製品」に含まれる、「開発者製品」からアクセスされる、または「開発者製品」から送信されるあらゆるコンテンツを実行、表示、または使用するための、非独占的、世界的な権利またはライセンスを各「エンドユーザ」に対して付与するものとします。  「開発者」は、前述の文章に代わり「開発者製品」に対する「エンドユーザ」の権利を規定する、エンドユーザ使用許諾契約書（「使用許諾契約書」）を「開発者製品」に対して別途含める必要があります。  「開発者」は、各「開発者製品」に適用される「使用許諾契約書」が、「開発者」と「エンドユーザ」との間のみに適用されることを認め、同意するものとします。  いかなる「使用許諾契約書」の下においても、GitHubはいかなる責務も責任も負わないものとします。

**2.5** 本「同意書」で付与されるライセンス権を除き、（a）「開発者」は「開発者製品」の全ての権利を保持し、（b）各関係者は、米国著作権法またはその他の法域における類似の権利を含め、本「同意書」とは独立した全ての権利を保持し、（c）各当事者はそれぞれの「ブランドの特徴」に存在する全ての権利、権限、および利益を所有するものとします。  各当事者は自らの権利を保護し、行使する責任を負います。いずれの当事者も他方当事者に代わってそれを行う義務を負いません。

**2.6** 「開発者」は、「開発者」が「開発者製品」に対して必要なあらゆる知的財産権を所有していないと主張する第三者に対して、GitHubの独自の裁量により、「開発者」の氏名、住所、その他の連絡先情報をGitHubが提供する権利をもつことを認め、同意するものとします。

### 3.  制限事項と責任

上記セクション2の、目的およびライセンスの付与に定めるあらゆる用件にかかわらず、「開発者」は「Marketplace」の利用および本「プログラム」への参加には「開発者」が、本「同意書」を順守することが必要であることを認め、これに同意するものとします。本「同意書」の順守には、本セクション3に規定される制限およびコンプライアンス用件を含みますが、これに制約されません。

**3.1** 「開発者」は、全ての「エンドユーザ」のプライバシーおよび法的権利を保護するものとします。  「エンドユーザ」の氏名、パスワード、その他の個人情報を「開発者」に提供、または「製品」が収集、開示、アクセス、または使用する場合、開発者は、（a）かかる情報を「開発者製品」が利用できることを「エンドユーザ」に通知し、（b）法的に適切なプライバシーの通知および保護を「エンドユーザ」に提供する必要があります。  さらに、「開発者製品」は「開発者」が「エンドユーザ」から許可を得た範囲内の、限定された目的のためにのみ、かかる情報を用いることができます。 「開発者製品」が「エンドユーザ」より提供されたまたは取得した、個人情報または機微な情報を保存または送信する場合、「開発者」はそれら全ての活動の安全性を確保する必要があり、またGitHubや「Marketplace」の「エンドユーザ」からの苦情、削除要請、また連絡拒否の要求に迅速に対応する必要があります。

**3.2** 「開発者」がGitHub APIを使用およびアクセスするには、サブスクライブを行ってAPI認証情報（「トークン」）を取得する必要があります。 「開発者」は自らの「トークン」をいかなる第三者とも共有してはならず、かかる「トークン」およびあらゆるログイン情報の機密を保ち、「開発者」がGitHub APIにアクセスするための唯一の手段として「トークン」を用いるものとします。

**3.3** 「開発者」は、「Marketplace」において、「開発者製品」の配布を含め、「Marketplace」のポリシーに違反するか、以下に該当するいかなる活動にも携わらないことを認め、これに同意するものとします。

- 1\. 適用法令に違反する、または違法行為を推進すること、
- 2\. アクティブなマルウェアまたはエクスプロイトを含むまたはインストールするもの、あるいは当社のプラットフォームを (コマンドや管理システムの一部としてなど) エクスプロイトを配信する目的で使用すること、
- 3\. あらゆる第三者の機械、システム、ハードウェア、サーバー、ネットワーク、デバイス、データその他の財産またはサービスに対する妨害、破壊、損傷、損害、危害、または不正なアクセスを行うこと、
- 4\. 虚偽または誤解を招くコンテンツを含めること、
- 5\. 特許、商標、企業秘密、パブリシティー権などの権利を含め、あらゆる当事者のあらゆる所有権を侵害すること、
- 6\. 中傷、名誉毀損、あるいは詐欺的なもの、
- 7\. ストリーミングコンテンツやメディアの不正なアクセスを可能にすること、
- 8\. 違法なコンテンツを表示またはそれにリンクすること、
- 9\. GitHub従業員、役員、代理店、その他あらゆる「エンドユーザ」を含む、あらゆる個人またはグループに対する嫌がらせ、罵倒、脅迫、または暴力の誘発を行うこと、
- 10\. 性的・わいせつな内容を含むもの、
- 11\. あらゆる個人やグループを差別または罵倒するもの、
- 12\. 「Marketplace」を模倣したり、「Marketplace」になりすますあらゆるサイトに「エンドユーザ」を迂回させるか、リンクを提供すること。

**3.4** 「開発者」は、いかなる環境においても、「開発者製品」またはその他の方法により、「Marketplace」、「GitHub API」、および「利用状況データ」をリパッケージまたは再販してはならないものとします。 「サービス」、「GitHub API」、「利用状況データ」および「Marketplace」に保存されているか、「Marketplace」によって送信されるその他あらゆるデータのセキュリティを害するまたはその可能性があるような方法で、「開発者」が「GitHub API」およびあらゆる「利用状況データ」を用いることは認められません。 「開発者」は、「Marketplace」や「GitHub API」のあらゆる機能、機能性、およびセキュリティコントロールを妨害、改変、無効化、「Marketplace」や「GitHub API」のあらゆる保護機構を解除、回避、バイパス、削除、無効化その他の方法で迂回、またリバースエンジニアリング、逆コンパイル、逆アセンブル、またはソースコード、基底にあるアイデア、アルゴリズム、機構または組織的形態を抽出してはならず、またすることを試みてもなりません。

**3.5** 「開発者製品」のコンテンツ、制作、運営、サポート、またはメンテナンスに対しては、「開発者」が一切の責任を負い、GitHubはいかなる責務も責任も負わないことを「開発者」は同意するものとします。 上記に加え、「開発者」は以下の責任を単独で負うものとします。
- （i）「開発者製品」の技術的なインストールおよび運用
- （ii）「開発者製品」上、「開発者製品」経由、または「開発者製品」内の情報及びコンテンツを作成および表示すること
- （iii）「開発者製品」があらゆる第三者の知的財産権に違反または抵触しないようにすること
- （iv）「開発者製品」が攻撃的、冒涜的、わいせつ、中傷的、またはその他違法でないようにすること
- （v）「開発者製品」が悪意あるソフトウェアを含まず、「Marketplace」、「GitHub API」、あらゆる「利用状況データ」、その他「Marketplace」を用いて保存または送信されるデータに悪意のあるソフトウェアを導入しないようにすること
- （vi）「開発者製品」が、あらゆるGitHub.comユーザ、エージェント、または「エンドユーザ」に対して同意なしに商用電子メッセージを送信するように設計または使用されないようにすること

**3.6** 「開発者」は、「開発者製品」を設計および実装するにあたって、「GitHub API」の技術的およびポリシーに基づく制限、ならびに本「同意書」による制限を尊重し、順守するものとします。 上記を制限することなく、「開発者」は、「GitHub API」の明示的な呼び出しその他使用に関するレート制限に違反しないものとします。

**3.7** GitHub は、「開発者」が本セクション3の要件または義務に違反したと判断した場合、本「同意書」を直ちに終了する権利を留保します。

**3.8** 本「同意書」のいずれの条項も、いずれかの当事者が相手方当事者のアプリケーションに類似またはその他競合するアプリケーションを開発および公開することを妨げるものではありません。

### 4.  テイクダウン

**4.1** お客様によるテイクダウン。 GitHubに対して、次の歴月1日より30日前以内に書面で通知することにより、「Marketplace」経由の将来的な配信を行う「リスティング」から削除を行うことができます。ただし、「Marketplace」を通じて配信されたあらゆる「リスティング」に対して適用される、本「同意書」は順守する必要があります。本「同意書」には、返金要求を含みますが、これに制限されません。 「Marketplace」配信で配信を行う「リスティング」を将来的に削除することは、 （a）「リスティング」を以前に購入またはインストールした「エンドユーザ」のライセンス権には影響、および（b）リスティングを以前に購入またはインストールしたユーザに配信またはサポートを行うお客様の義務には影響を与えません。

上記にかかわらず、かかる削除が以下の理由による場合は、お客様が「Marketplace」から削除し、GitHubに対して書面で通知した、「Marketplace」のリスティングのいかなる部分も、GitHubが保持することは決してありません。

- （i）著作権、商標、企業秘密、トレードドレス、特許、その他あらゆる人の知的財産家の侵害の申し立て、または実際の侵害
- （ii）名誉毀損の申し立てまたは実際の名誉棄損
- （ii）あらゆる第三者のパブリシティー権またはプライバシーの侵害の申し立て、または実際の侵害
- （iv）かかる「リスティング」が適用法に準拠していないという申し立てまたは判断

本セクション4.1の（i）、（ii）、（iii）、（iv）条に従ってお客様が「Marketplace」から「リスティング」を削除し、かつ「エンドユーザ」が、かかる「リスティング」をテイクダウンが行われる日の前1年以内に購入していた場合、GitHubは、かかる「リスティング」のテイクダウンが行われる日の前1年間に、かかる「エンドカスタマー」が支払った金額を購入者に対して払い戻す責任を負いません。

**4.2** GitHubによる審査およびテイクダウン。 GitHubは、「リスティング」やその内容について監視する義務を負いませんが、お客様のリスティングが本「同意書」、「Marketplace」プログラムのポリシー、その他適用される条件、義務、法令に準拠しているか、GitHubは随時審査または検査することができます。 GitHubは、自らの裁量により、「Marketplace」に「リスティング」を含めることを拒否する権利を留保します。 お客様は、「Marketplace」に登録する、または「Marketplace」を継続的に使用するためのプロセスの一環として、ご自身についての情報（身分証明や連絡先など）を提供するよう求められる場合があります。 お客様は、「Marketplace」に提供するあらゆる情報を常に正確かつ最新のものとすることに同意するものとします。 「リスティング」の仕様の一環として、GitHubはお客様の氏名やメールアドレスなどの「リスティング」情報をファイルに含めるよう求めることができます。 GitHubは、当社のディレクトリにおいて「リスティング」を取り上げるなどの目的のため、この情報を用いることができます。

「リスティング」、それに含まれる内容、またはお客様の「ブランドの特徴」が、以下のいずれかに該当するとGitHubがお客様から通知されるか、その他自らの裁量により認識および判断した場合、
- （a）第三者の知的財産権その他の権利を侵害する
- （b）適用法令に違反する、または差し止め命令を受ける
- （c）ポルノ、わいせつ、その他GitHubが随時自らの裁量により更新できるGitHubのホスティングポリシーやその他サービス規約に違反する
- （d）お客様により不適切に配信されている
- （e）GitHubまたは第三者に法的責任をもたらす
- （f）GitHubが悪意または欠陥があるものと見なす
- （g）本「同意書」または「Marketplace」プログラムポリシーに違反する
- （h）「リスティング」の表示がGitHubサーバーの完全性に影響をもたらす（すなわち、ユーザがかかるコンテンツにアクセスできない、またはその他の困難をもたらす）
- （i）「Marketplace」の「エンドユーザ」が所有するデータに過度のリスクをもたらす、または「Marketplace」や「GitHub」のユーザエクスペリエンスを損なう
- （j）お客様のEULA違反についてユーザからの苦情がある
- （k）その他「規約」や本「同意書」に違反する

GitHubは、自らの裁量により、「リスティング」を「Marketplace」で入手できなくする、「Marketplace」から「リスティング」を削除する、関連する素材（説明、スクリーンショット、メタデータを含むが、これに限定されない）をフラグ付け、フィルター、もしくは変更する、または「リスティング」の分類を変更する場合があります。 GitHubは、自らの裁量により、「Marketplace」からあらゆる「リスティング」をサスペンドまたは除外する権利を留保します。

欠陥、不正、他者の知的財産権の侵害、名誉毀損、第三者のパブリシティー権やプライバシー権の侵害、または適用法令への非準拠のゆえにお客様の「リスティング」が強制的に削除され、かかる「リスティング」をエンドユーザがテイクダウンの日から1年以内に購入していた場合、

- （i）お客様は影響を受けた購入者に対して、かかる「エンドユーザ」が、かかる影響を受けた「リスティング」のテイクダウンの日から1年前までの期間に支払った金額をすべて返金する必要があります。
- （ii）GitHubは、自らの裁量により、上記サブセクション（i）の金額を将来の販売額から留保することができます。

**4.3** GitHubは、「リスティング」に適用可能なバグ修正や機能強化などの更新を、随時確認することができます。 お客様が「Marketplace」への「リスティング」を更新した場合、お客様はかかる更新が、お客様にさらなる通知を行うことなく、自動的に要求、ダウンロード、およびインストールされることに同意するものとします。  GitHubは、かかる更新のタイミングに関して何ら保証しません。 疑義を避けるために述べると、「リスティング」に対する更新につしては、セクション4.2（GitHubによる審査およびテイクダウン）を含み、これに限定されない本「同意書」の「リスティング」に対して適用される条項が同じく適用されます。

**4.4** エンドユーザのテイクダウン。 お客様の「開発者製品」を、「エンドユーザ」が「規約」に違反する方法で使用した場合、当社はお客様に責任を負うことがなく、かかる「エンドユーザ」が「開発者製品」にアクセスする権利を停止または終了する権利を有します。

### 5.  表明、保証および誓約

**5.1** 「開発者」は、アカウントデータが「サービス」の外部に送信されること、およびかかるアカウントデータのセキュリティや完全性については「開発者」の規約が適用されることを、「開発者アプリケーション」の全ユーザに対して通知していることを表明し、保証するものとします。 さらに「開発者」は、「開発者」も「開発者」の「アプリケーション」も、ユーザに対して適切な事前の同意を得るか、適用法によって要求される場合を除き、「開発者」の「アプリケーション」が保存、処理、または送信するアカウントデータについて以下を行わないことを表明し、保証するものとします。
- （i）アカウントデータの完全性に悪影響を及ぼす方法で、アカウントデータの内容を変更すること、
- （ii）第三者にアカウントデータを開示すること、または
- （iii）「開発者アプリケーション」のユーザに対して「開発者アプリケーション」の機能を提供する以外の目的でアカウントデータを使用すること。 「開発者」は、全てのアカウントデータの機密性とセキュリティ、および全てのプライバシーに関する適用法令を守るために、合理的に適切なプライバシーおよびセキュリティ対策に従って、全てのアカウントデータを維持し、取り扱うものとします。

**5.2** 「開発者」は、「データ保護特約」に準拠することに同意するものとします。

**5.3** 「開発者」は、次の事項を表明、保証、および誓約します。（i）「開発者製品」および「開発者」の「ブランドの特徴」が、第三者の知的財産権を違反、侵害、または不正使用していないこと、（ii）「開発者」は、適用されるすべての輸出規制法を含むがこれに限定されない、すべての適用される現地法、州法、国法、および国際法を遵守すると共に、「開発者」が開発、実装、および配布を行うにあたって必要なすべてのライセンス、認可、およびその他の許可を維持すること、（iii）「開発者製品」には悪意のあるソフトウェアが現在においても将来的にも含まれず、「Marketplace」、「GitHub API」、または「Marketplace」を用いて保存または送信される「利用状況データ」やその他のデータに、悪意のあるソフトウェアを導入しないこと、（iv）「開発者製品」がGitHubの顧客、代理店、または「エンドユーザ」の同意なく商用電子メッセージを送信する目的で設計または使用されないこと、（v）GitHubおよび「エンドユーザ」に対し、本「同意書」において提供するようなライセンスを提供するあらゆる権利、権能、および権限を有すること、（vi）本「同意書」のセクション6に定める取引料金または掲載料金をGitHubが請求する権利があることを認めること、「開発者製品」を宣伝するために用いた、または「開発者」が「Marketplace」にアップロードした画像やテキストが、真実、正確であり、「エンドユーザ」を欺いたり混乱させたりする意図を有していないこと。

**5.4** 保証の免責事項。 全てのサーバーおよびネットワークコンポーメントを含め、Marketplace」および「GitHub API」全般は「現状有姿」で提供され、法律で許される範囲内で、いかなる保証もしないものとします。また、GitHubは明示的にも黙示的にも、商品性、権原、特定の目的への適合性、および何らかの違反のないことを含めるがそれに限定されないいかなる保証も拒否します。  「開発者」は、「MarketPlace」および「GitHub API」が中断されないこと、適時に提供されること、安全であること、エラーがないこと、ウイルス、マルウェア、またはワーム（ソフトウェア、ハードウェア、コンピュータシステム、またはネットワークを破壊、無効化、または危害を加えることを特に目的としたコンピュータコードやその他技術のこと）が存在しないことを「GitHub」が保証しないこと、ならびに「開発者」が「GitHub」からまたは「Marketplace」もしくは「GitHub API」を通じて得るいかなる情報や助言も、本「規約」に明示されていない保証を与えるものではないことを認めるものとします。  「GitHub」は、「Marketplace」外における「開発者製品」のあらゆる不正使用に対して責任を負わず、またあらゆる責任を明示的に拒否します。

### 6.  価格と支払い条件

**6.1** GitHubは、「エンドユーザ」が「Marketplace」経由で購入した「開発者製品」について、最終販売責任を負う商業者となります。

**6.2**  「開発者アプリケーション」の「Marketplaceリスティング」の価格は、米ドル（USD）で設定されます。 「開発者」は、各「リスティング」の価格設定を自ら決定でき、一度価格を設定すると、その価格は変更されません。 既存の「リスティング」の価格プランを取りやめ、追加の価格プランを適用することができますが、ただし、かかる新価格プランが、既存の「エンドユーザ」に悪影響を及ぼさないことを条件とします。 「開発者製品」に設定した価格によって、お客様が受け取る金額が決定されます。 GitHubは、米ドルで設定された販売価格の75%を、適用法に基づき要求される源泉徴収税以外の「税金」を控除せずに送金します。 販売価格のうち残りの25%については、GitHubの割り当て分となり、GitHubが保管します。  毎月最終日、500米ドルの最低額に到達した場合に、GitHubはお客様の受け取り金額を送金するものとします。

**6.3** 「返金要件」。 お客様は、「エンドユーザー」への返金に関する条件を指定する責任を負います。 いかなる場合においても、GitHub は返金についてサポートを提供する義務や、返金の支払いについて責任を負う義務を負いません。

**6.4** お客様による「開発者製品」のサポート。 「開発者製品」のサポートおよび保守、ならびに「開発者製品」に対する苦情については、お客様が全責任を負うものとします。 ユーザがカスタマーサポートを得られるよう、サポートの連絡先情報が、各アプリケーションの詳細ページに表示されます。 「開発者製品」に対して適切なサポートを提供しない場合、製品の露出が減少し、場合によっては、「開発者製品」をユーザのために保存し、そこから購入やダウンロードを行うことができた場所である「Marketplace」やその他GitHub.comのあらゆる場所から削除されることもあります。

### 7.  所有権

本「同意書」で明示的に提示されている限定的なライセンスに従い、本「同意書」のいかなる条項も、相手方当事者の「ブランドの特徴」やその他の技術に含まれる知的財産権を移譲または譲渡するものではなく、また本「同意書」のいかなる条項も、一方の当事者に相手方当事者の知的財産権を移譲または譲渡するものではありません。

### 8.  責任制限

「開発者」がかかる損害の可能性について助言を受けたか、また予測できたかどうかに関わらず、本「同意書」に関して「開発者」または第三者により生じた、利益の逸失、販売や事業の喪失、データの喪失、事業の中断その他あらゆる損失を含む、あらゆる間接的、付随的、特別、典型的、派生的、懲罰的その他類似の損害に対して、GitHub、その「関係会社」、役員、取締役、従業員、代理店、または卸売業者も、いかなる状況においても、いかなる法理論においても（契約、不法行為、怠慢その他に関わらず）本契約の下において、「開発者」やあらゆる第三者に対して責任を負わないものとします。本契約中に反対の趣旨の規定があったとしても、本契約により生じる、「開発者」または「第三者」に対するGitHubの責任の限度額は6か月分の支払額を超えないものとします。

### 9.  補償

**9.1** （a）「開発者」による、「Marketplace」の本「同意書」、「規約」、または適用法令に違反した使用、（b）「開発者製品」による、第三者の著作権、商標権、企業秘密、特許またはその他の知的財産権の侵害、（c）「開発者製品」による、データまたは個人情報の喪失または開示、および（d）「開発者」の「使用許諾契約書」(または「利用規約」）により生じた、または関係するあらゆる請求、告訴、 訴訟、訴訟手続き、およびあらゆる損失、責任、損害、 経費、および費用（合理的な弁護料を含む）について、適用法により認められる最大限の範囲において、「開発者」は、GitHub、その「関連会社」、それらの取締役、役員、従業員、および代理店を、補償し、弁護し、無害に保つことに同意するものとします。

### 10. 解約

**10.1** 本「同意書」は、以下に定める通り、いずれかの当事者によって解約されるまで適用されます。

**10.2** いずれの当事者も、翌歴月の45日前に、他方当事者に対して書面で通知することにより、本「同意書」をいかなる理由によっても解約することができます。 かかる45日間の通知期間においては、かかる解約の通知を行った時点において有効である規約が、実際の解約日まで適用されるものとします。

**10.3** （a）お客様が本「同意書」の条項に違反した場合、または（b）GitHubが法律で要求された場合、GitHubは本「同意書」をいつでも解約できます。

**10.4**  「開発者」による「解約」の効果。 「開発者」から45日前の書面による解約通知を受けた時点で、「開発者」は「Marketplace」から新規顧客を獲得できなくなるものとします。 未払いの料金については、解約され、「Marketplace」から「開発者製品」が削除された際に送金されます。 解約が、GitHubが本規約を変更（セクション11）した結果により生じた場合、実際の解約日までの45日間の通知期間においては、かかる変更の直前に有効であった規約が適用されるものとします。

**10.5** セクション2、3、4、5、8、9、12から18までに記載されている義務は、本「同意書」の失効または解約後も存続するものとします。

### 11. 変更

「開発者」は、GitHubが本「同意書」、「Marketplace」、「GitHub API」、「一般的APIポリシー」、「GitHubプライバシーポリシー」、「GitHub開発者プログラム利用規約」、および「GitHub.com利用規約」を随時変更できることを認め、同意するものとします（「変更」）。 全ての「変更」は、「Marketplace」、GitHubのウェブサイト（www.GitHub.com）を通じて伝達されるか、GitHubから「開発者」に直接伝達されるものとします。 さらに「開発者」は、かかる「変更」を随時、「開発者」への通知なしに行うことができることを認め、同意するものとします。 「開発者」は、あらゆる「変更」の通知が最初に行われた日から45日以内（または「通知」に規定された、それより短い期間内）（「移行期間」）に、最新バージョンの「開発者製品」にある最新バージョンのGitHub APIを実装して使用し、かかる「変更」の結果として必要になるあらゆる変更を「開発者製品」に行うことにより、かかる変更に準拠するものとします。 「開発者」は、アプリケーションが「GitHub API」と通信する方法の変更などを含め、これに限定されない悪影響を「変更」が「開発者製品」にもたらす可能性があることを認めるものとします。 GitHubは、かかる「変更」に関して、またかかる「変更」によた生じるあらゆる悪影響に関して、「開発者」や「エンドユーザ」に対しいかなる責任も負わないものとします。 「開発者」が「移行期間」後に「Marketplace」または「GitHub API」に継続的にアクセスまたは使用することにより、この「変更」を拘束力をもって受け入れたこととなります。

### 12. 譲渡、完全なる同意、改訂

**12.1** 「開発者」は、GitHubの書面による同意なしに、直接的か間接的かに関わらず、法律の運用その他の方法により、本「同意書」または本「同意書」に基づく権利の全体または一部を譲渡してはならず、また本「同意書」に基づく「開発者」の義務の履行を移譲してはならないものとします。  本「同意書」により付与された権利を、GitHubは「開発者」の同意なしに譲渡または移譲できます。  また、GitHubは本「同意書」に基づく責任や義務を、「開発者」の同意なしに移譲できます。

**12.2** 本「同意書」は、「利用規約」と共に、本「同意書」の主題に関して当事者間の完全なる合意を構成するものです。 GitHubが本「同意書」のいずれかの条項をいかなる時に施行しなかったとしても、本「同意書」のかかる規定や、その他の規定が放棄されたとはみなされません。

### 13. 分離可能性

本「同意書」のいずれかの規定が管轄裁判所により執行不能であると判断された場合、かかる規定は裁判所により変更され、法律が許容する最大限の範囲で元の規定を最もよく達成できるよう解釈されるものとし、本「同意書」のその他の条項は引き続き有効であるものとします。

### 14. 当事者の関係

両当事者は独立契約者です。 本「同意書」は、パートナーシップ、フランチャイズ、合弁事業、代理店、受託、または雇用関係を当事者間に構築するものではありません。  「開発者」は、GitHubが所属するグループ企業の各構成員が本「同意書」の第三者受益者であり、かかる企業は、本「同意書」の条項がGitHubに対して与える有利な利益や権利を直接執行する、および条項に依拠する権利を付与されることに同意します。  他いかなる個人、企業また法人も、本契約の第三者受益者とはならないものとします。

### 15. 通知

All notices to be provided by GitHub to Developer under this Agreement may be delivered in writing (i) by nationally recognized overnight delivery service (“Courier”) or U.S. 本契約に基づく、GitHubから「開発者」に対して行う全ての通知は、（i）「開発者」からGitHubに提供された連絡先住所に、全国的に認められた宅配便業者（「宅配便業者」）または米国郵便で、または（ii）「開発者」から提供された電子メールアドレスに、電子メールで、書面により配信できるものとします。 Developer must give notice to GitHub in writing by Courier or U.S. 「開発者」は、「宅配便業者」または米国郵便で、次の住所に書面で通知を行う必要があります：GitHub, Inc., Attn: Legal Department, 88 Colin P. Kelly Jr. Street, San Francisco, CA 94107 USA。 全ての通知は、電子メールであれば配信された時点で直ちに行われたものと見なされ、それ以外の手段による場合は、受領時または郵便物として投函したか上記「宅配便業者」に委託してから2営業日後のいずれか早い方に行われたものと見なされるものとします。

### 16. 準拠法

本「同意書」に対しては、抵触法の原則に関わらず、カリフォルニア州の法律が適用されるものとします。 「開発者」は、本「同意書」に関する紛争の解決にあたり、カリフォルニア州サンフランシスコ市郡の連邦裁判所および州裁判所の専属的な人的管轄権に服することを、ここに明示的に同意するものとします。  上記にかかわらず、GitHubは、いかなる管轄下においても、差止め命令による救済またはその他の種類の緊急的な法的救済を求める権利を有するものとします。

### 17. 輸出制限

「Marketplace」を通じて配布される「開発者製品」は、米国またはその他の国や地域による輸出規制または制限の対象となる場合があります。  「開発者」は、適用される米国および国際的な輸出法令を全て順守することに同意するものとします。  これらの法律には、宛先、内容、「エンドユーザ」に対する制限が含まれる場合があります。

### 18.  利用状況データ
GitHubは、「Marketplace」の運営および改善のため、 「Marketplace」および「GitHub API 」、または以前「開発者」製品を購入またはダウンロードできた、GitHubが「エンドユーザ」のために「開発者製品」を保存していたあらゆる場所から、「利用状況データ」を収集することができます。  「利用状況データ」は、その当時に有効であったGitHubのプライバシーポリシーに従って保管されます。  GitHubの独自の裁量により、「開発者」は、限定的な「利用状況データ」を利用できる場合があります。

# 特約1：データ保護特約

本「データ保護特約」（本「特約」）は、お客様とGitHubとの間の「GitHub Marketplace開発者同意書」（「同意書」）に添付され、その一部を構成するものです。 本「特約」に定義されていない用語の意味は、本「同意書」に記載されている意味を持つものとします。 矛盾または不一致がある場合、本「特約」の条項が「同意書」に対して優先するものとします。

**A1-1. 目的および範囲** GitHubは世界中から個人情報を収集していますが、その人々のうちの一部は、強力なデータ保護法を備えた国や地域に居住しています。 この「特約」は、お客様がGitHubから保護されたデータを受け取り、処理する際のお客様の責任について制定するものです。

**A1-2. 定義**

- a. “Applicable Data Protection Laws” means any laws, regulations, regulatory frameworks, or other legislations relating to the processing and use of Personal Information, as applicable to the Agreement, including:
   - The EU General Data Protection Regulation 2016/679 (“GDPR”), along with any implementing or corresponding equivalent national laws or regulations;
   - The California Consumer Privacy Act of 2018, Cal. Civ. Code §§1798.100 et seq. ("CCPA"); and
   - The UK Data Protection Act 2018 and implementation of GDPR contained therein.
- b. “Personal Information” means any information which relates to an individual GitHub End User, customer or employee which could, alone or together with other information, personally identify him or her, whether supplied by GitHub for processing by the Developer or whether generated by the Developer in the course of performing its obligations under this Agreement.
- c. 「処理」とは、「GitHub保護データ」に対して行う収集、記録、系統化、蓄積、合目的的な加工、変更、検索、参照、利用、送信による開示、普及、もしくはその他の方法により入手可能な状態に置くこと、利用停止、削除または破壊その他の個人データに対して実行する全ての操作または一連の操作を意味します。
- d. 「保護データ」とは、「個人情報」、メタデータ、「利用状況データ」、またはその他GitHubの「エンドユーザ」に関連するデータや情報を含む、GitHubの「エンドユーザ」についてGitHubが「開発者」に転送するあらゆる機密情報を意味します。

**A1-3. Compliance with Data Transfer Laws**

- a. GitHubによる順守。 GitHub complies with Applicable Data Protection Laws. GitHub relies on Standard Contractual Clauses ("SCCs") for all transfers out of the European Union, European Economic Area, United Kingdom, and Switzerland to provide its services. In addition, GitHub is certified to the EU-U.S. and Swiss-U.S. Privacy Shield Frameworks and the commitments they entail, although GitHub does not rely on the EU-U.S. Privacy Shield Framework as a legal basis for transfers of Personal Information in light of the judgment of the Court of Justice of the EU in Case C-311/18. GitHubは、「個人情報」を、収集された限定的かつ特定の目的のためにのみ「開発者」に転送します。
- b. 「開発者」による順守。 Developer represents and warrants that it will (i) comply with Applicable Data Protection Laws; and (ii) abide by the requirements of European Economic Area and Swiss data protection law regarding the collection, use, transfer, retention, and other processing of Personal Information from the European Economic Area, United Kingdom, and Switzerland. All transfers of Personal Information to a third country or an international organization will be subject to appropriate safeguards as described in Article 46 of the GDPR and such transfers and safeguards will be documented according to Article 30(2) of the GDPR.

**A1-4. データ保護**

- a. 通知。 「開発者」は、「エンドユーザ」から収集する全てのデータの収集者および処理者として自らを位置づける必要があります。 「開発者」は、あらゆる「個人情報」を、GitHubに代わって収集するかのように振る舞ってはなりません。 「開発者」は、プライバシーポリシーを掲示するなど、プライバシーの取り扱いについて「エンドユーザ」に十分な通知を行う必要があります。
- b. 目的外利用の制限。
   - i. GitHubは、「開発者」と「エンドユーザ」との関係を確立、促進し、「開発者」が「エンドユーザ」にサービスを提供できるようにする目的で、「開発者」に対し「保護データ」要素を提供します。 「開発者」は、「保護データ」の使用をこの目的のみに限定する必要があります。ただし、「エンドユーザ」が別の使用法を許可した場合を除きます。
   - ii. 「開発者」が「保護データ」を処理し、第三者に伝達するのは、「エンドユーザ」との同意に記載されている通り、「エンドユーザ」にサービスを提供するという限定的な特定の目的においてのみとする必要があります。ただし、「エンドユーザ」が他の目的に使用することに同意している場合は除きます。
- c. データの品質と均衡製。 「開発者」は、「保護データ」を正確かつ最新の最新の状態に保つ必要があります。
- d. セキュリティ. 「開発者」は、ユーザの個人情報または「保護データ」を処理することによって生じる偶発的または違法な破壊、偶発的な紛失、改変、不正な開示またはアクセスなどのリスクに適切な合理的なセキュリティ対策をすべて講じる必要があります。
- e. データの保持と削除。 GitHubの合理的な要求があった場合、法律で禁じられている場合を除き、「開発者」は、あらゆる場所に保存されている全ての「個人情報」および関連データを、収集された限定的かつ特定の目的のために不要となった後、返却または破壊する必要があります。 「開発者」は、本「同意書」のセクション3.8に記載されているGitHubのセキュリティ要件を満たす情報破壊プロセスを構築しておくか、開発する必要があります。
- f. 副処理とデータの委譲 「開発者」は、サブプロセッサーに「保護データ」を転送する際の責任を負います。 In the event that Developer must transfer the Protected Data to a third party, or Developer installs, uses, or enables third party services to process the Protected Data on Developer’s behalf, Developer must ensure that the third party will provide at least the same level of privacy protection as is required herein.

**A1-5. 保護データの使用**

- a. 許可される使用範囲。 「開発者」は、「保護データ」をセクション4（b）（i）で定める目的のためにのみ扱うことができ、そ例外の目的で扱うことはできません。
- b. マーケティングでの不使用。 「開発者」は、「保護データ」を第三者の商品やサービスの広告を行う目的で使用してはならず、また「保護データ」を第三者に販売することはできません。
- c. 自動的な意思決定。 「開発者」が、雇用、信用、健康などを含むGitHubの顧客の権利に影響を与える自動的な意思決定を行う場合、「開発者」はそのことを個人に通知する必要があります。

**A1-6. コンプライアンス**

- a. 「開発者」は、以下の方法により、プライバシーおよびデータ使用の慣行についての合理的な要求に従う必要があります。
   - i. 「開発者」は、要求に応じて、「プライバシーについての声明」、「プライバシーポリシー」、「プライバシー通知」、またはそれに類じた文書を閲覧できるようにするものとします。 また、「開発者」は、「プライバシーシールド」の順守を含め、関連するコンプライアンスレポートの通知も行うものとします。
   - ii. 「開発者」は、「GitHub Marketplace開発者同意書」のセクション3.7に記載の「情報セキュリティ」「監査」の義務を順守するものとします。

**A1-7. 解約**

- a. 一時停止。 「開発者」が適切なレベルのプライバシー保護を維持する義務に違反している場合、かかる違反が是正されるか本「同意書」を解約するまで、GitHubは「保護データ」の委譲を一時的に停止するか、GitHubに代わって「保護データ」収集および処理することを禁じることができます。
- b. 理由のある解約。 以下の場合には、GitHubは法律上または衡平法上の他の請求権を損なうことなく本「同意書」を解約できるものとします。
   - i. 「開発者」がGitHubに対し、プライバシーの義務を満たせなくなったと通知した。
   - ii. 「保護データ」の委譲、収集、処理が、セクション7（a）に従って1か月以上一時停止されている。
   - iii. 「開発者」が、本「データ保護特約」に基づく保証または表明を実質的に、または永続的に侵害している。
   - iv. 「開発者」が事業を継続しなくなった、解散した、財産管理に入った、あるいは「開発者」に代わって清算命令が発令された。
- c. 違反。 本「データ保護特約」の重大な条項を遵守できなかった場合は、「マスターサービス契約書」に基づく重大な違反と見なされます。
- d. 通知。 「開発者」が本「同意書」に定めるプライバシー義務を満たせなくなったと判断した場合、ただちにGitHubに通知する必要があります。 「開発者」が「プライバシーシールド」の下で認証を受け、その認証が失効することが見込まれる場合、または「プライバシーシールド」の下で認証を維持することができない場合、「開発者」はただちにGitHubに通知する必要があります。
- e. 変更。 GitHubは、法律より必要な場合には随時、「開発者」に30日前に通知したうえで、本「特約」を変更できます。 「開発者」が本「特約」の変更に従うことができない場合、GitHub は本「同意書」を解約することができます。
- f. 「解約」の際、「開発者」は以下を行う必要があります。
   - i. 妥当かつ適切な手段を講じて、「保護データ」の処理を停止する。
   - ii. 解約後30日以内に、GitHubに代わって「開発者」が保存していた「保護データ」を削除する。
   - iii. 「開発者」が、「保護データ」の処理を停止し、保存された「保護データ」を削除したことについて、GitHubに合理的な保証を提供する。

**A1-8. データ処理の責任**
- a. 直接債務。 「開発者」は、「Marketplace開発者同意書」のセクション8「責任の制限」の条項に従い、本「特約」への違反により生じた実際の責任に対してGitHubに責任を負います。
