---
title: GitHub の行政機関による削除に関するポリシー
versions:
  free-pro-team: '*'
---

#### この項目についての説明
ときどき、GitHub は行政機関から、地域の法律によって違法であるコンテンツを削除するよう要請を受けることがあります。 当社は、これらの法律に常に合意するわけではありませんが、公務員から要件を満たした要請を受けた場合、該当する管轄区域のユーザーが GitHub にアクセスして、協力してソフトウェアの制作を行える状態を保つため、コンテンツをブロックする必要があることがあります。

#### 要件を満たす行政機関からの削除要請とは
要請が要件を満たすものと認められるためには、要請または通知が以下の条件を満たす必要があります。
- 適切な公の行政機関からのものであること
- 違法なコンテンツを同定していること
- 自らの管轄区域において違法である典拠 (法律または裁判所の命令) を明記していること

#### 行政機関から要件を満たす削除要請を受け取った際の対応について

適切な公の行政機関から、違法なコンテンツを示し、違法性の根拠を明記した通知を受け取った場合、当社は以下のように対応いたします。
- 影響を受けるユーザに対し、違法の疑いがある指定されたコンテンツを通知し、これが法的な削除要請であることを知らせる
- 影響を受けるユーザに対し、不服の申し立てを認めることを通知に含める
- 可能な場合は、削除の地理的範囲を制限し、これを通知に含める
- 削除の原因となった正式な要請を、パブリックの [gov-takedowns リポジトリ](https://github.com/github/gov-takedowns)に投稿する

#### 削除の通知を投稿して公開する理由
当社はインターネットの検閲について懸念しており、その時点における具体的な段階について透明性を保つことが、良好な運営のために不可欠であると信じています。 通知を投稿して公開することにより、GitHub で取り下げられているコンテンツと、その理由について一般によりよく伝えることができます。 当社は、言論抑制の可能性を記録するため、削除の通知を投稿します。

#### gov-takedowns リポジトリに通知を投稿することの意味
リポジトリに通知を投稿することは、そこに示されたデータについての通知を当社が受け取ったことを意味します。 これは、コンテンツが違法であるとか誤っているということを意味*しません*。 また、通知に示されたユーザが何か誤った行為を行ったということも意味*しません*。 当社は、削除を要請する当局による主張の正しさについて、いかなる判断をも下さず、またそれを暗示することもしません。 当社はこれらの通知や要請を、情報提供のみを目的として投稿しています。

#### 透明性レポート
行政機関による削除要請の通知を gov-takedowns に投稿することに加え、当社はそれらを透明性レポートにおいて報告しています。 また、当社は GitHub 利用規約の侵害に基づいた行政機関による削除要請を、透明性レポートにおいて追跡・報告しています。 当社は、利用規約の侵害について、他の人々からの利用規約侵害についての報告と同様に対処します。
