---
title: GitHubイベントの行動規範
redirect_from:
  - /articles/github-event-code-of-conduct
versions:
  free-pro-team: '*'
---

GitHubイベントは、テックコミュニティのネットワーキングとコラボレーションを目的としたコミュニティイベントです。

参加する各メンバーが大切なものであり、すべての出席者に楽しく充実した体験をしてほしいと願っています。 したがって、GitHubが主催するイベントの場においては、他の参加者に敬意と礼儀を示すよう出席者全員に求めています。

求められることを明確化するため、当社では行動規範を定めています。GitHubが主催するあらゆるイベントにおいては、すべての出席者、講演者、出展者、主催者、およびボランティアに対して、以下の行動規範に従うことが求められます。 主催者は、イベント全体を通じて、この規範を適用します。

### 行動規範

GitHubは、年齢、性別、性自認、性表現、性指向、障害、容姿、体の大きさ、民族、人種、宗教、国籍、経験の度合いにかかわらず、有益で嫌がらせのない体験をすべての人に提供するよう努めています。 当社はイベントの参加者に対するいかなる嫌がらせも、また他の参加者に身体的または感情的な危機感、不安、脅威を抱かせることにつながるいかなる振る舞いも容認しません。 あらゆるコミュニケーションは、さまざまな背景をもつプロの聴衆にふさわしいものであるべきです。

前向きな環境の推進に貢献する振る舞いの例を以下に挙げます。

* 友好的で差別的な表現がない言葉を使用する
* 異なる視点や経験を尊重する
* 建設的な批判を率直に受け入れる
* イベントに関わる全員にとって最良となることを考える
* 他の参加者への共感を示す

許容できない振る舞いの例を以下に挙げます。

* 性的な言葉または画像の使用、不適切な身体的接触、性的関心、口説きかけ
* いわゆる荒らし行為、侮辱的・軽蔑的なコメント、個人的・政治的攻撃、会話や他のイベントの長時間に及ぶ妨害
* 意図的な脅迫、ストーキング、つきまとい、嫌がらせの写真や録音
* 冗談や皮肉におけるものを含む、あらゆる種類のいやがらせ
* 仕事場において、合理的に考えて不適切と見なされるような、その他の行為

他人に親切にしましょう。 他の出席者を侮辱したり、見下したりしてはいけません。 プロフェッショナルな態度を心がけましょう。 嫌がらせ、性差別、人種差別、排他的な冗談はGitHubのイベントにおいては相応しくないということを覚えておきましょう。

イベントの各ゲストは、自分自身の行動についての全責任を負います。

いごこちのよい、フレンドリーな空間づくりへのご協力を感謝します。

#### 問題の報告

嫌がらせを受けている、他の人が嫌がらせを受けていることに気付いた、またはその他の懸念がある場合は、メール (events@github.com)、電話/テキストメッセージ (+1 415 842 2837)、またはGitHubの従業員やセキュリティ担当者まで直接ご連絡ください。

GitHubのメンバーは、参加者がセキュリティや地域の法執行機関に連絡したり、安全な場所まで送り届けたり、その他嫌がらせを受けている人がカンファレンスの開催中に安心できるよう喜んでお手伝いします。 当社は参加者を尊重します。

### クレジット

本行動規範の一部は、Ada Initiativeやその他のボランティアがCreative Commons Zero licenseの下で作成した、「Geek Feminism wiki」の[嫌がらせ防止ポリシーの例](https://geekfeminism.wikia.org/wiki/Conference_anti-harassment/Policy)から取られています。
