---
title: GitHub Enterprise プラン契約
redirect_from:
  - /articles/github-enterprise-agreement/
  - /articles/github-enterprise-subscription-agreement
versions:
  free-pro-team: '*'
---

Version Effective Date: July 20, 2020

「同意する」またはそれに類似するボタンをクリックするか、(以下に定義する) 本製品を利用することにより、お客様は本契約の規約および条件に同意することになります。 お客様が、法人を代表して契約を締結する場合、お客様は、本契約を締結するためにその法人に義務を負担させる法的権限を持つことを表明するものとします。

本契約は、以下に詳述する GitHub の提供品 (併せて「**製品**」) に対して適用されます。

-   GitHub Enterprise (comprised of GitHub Enterprise Server, which may include Add-On Software, and GitHub Enterprise Cloud) and GitHub One;

-   すべての「ベータプレビュー」、

-   関連するすべての「サポート」、

-   関連するすべての「プロフェッショナルサービス」。

本契約には、以下のセクションおよび付属文書が含まれ、参照することにより本契約に含まれます。

* セクション 1: 一般的な規約および条件

* セクション 2: GitHub Enterprise Server ライセンス規約

* セクション 3: GitHub Enterprise Cloud 利用規約

* EXHIBIT A: Definitions.

お客様が、GitHub の認定代理店から「製品」を購入された場合、本契約のうちセクション 1.1 (契約期間および解約)、セクション 1.2 (支払い)、セクション 2.3 (デリバリ)、およびセクション 2.4 (確認) については、お客様が GitHub の認定代理店と合意した規約が優先するものとします。

## セクション 1: 一般的な規約および条件

セクション 1 では、あらゆる「製品」の、お客様による購入および使用について適用される規約および条件を規定します。 Capitalized terms used but not defined in the body of this Agreement are defined in Exhibit A.

### 1.1 契約期間および解約

#### 1.1.1 契約期間

本契約は、「発効日」から開始し、セクション 1.1 の規定に従って「当事者」により解約されるまで有効であり続けるものとします。

#### 1.1.2 契約解除 アカウントのキャンセル

いずれの「当事者」も、その時点で最新の「プラン契約期間」が終了する少なくとも 30 日前に書面により通知することで、「注文書」または本契約を理由なく解約できます。 お客様が「注文書」または本契約を解約することを選択した場合、お客様は、画面上部のグローバルナビゲーションバーにある「設定」に進み、GitHub でアカウント適切にキャンセルする責任を負います。 GitHub は、メールや電話での要請に対応してアカウントをキャンセルすることはできません。

#### 1.1.3 重大な契約違反による解約

いずれの「当事者」も、相手方「当事者」が本契約に基づく義務に対して重大な違反を犯し、通知を受領してから 30 日以内に違反を是正できなかった場合、通知により本契約を直ちに解約できます。 また、お客様が (ライセンスの付与その他あらゆるライセンスの制限にお客様が従わない場合を含め) GitHub の知的財産に関連した本契約の規約のいずれかに違反した場合、またはお客様のアカウントが 90 日を超えてサスペンドしている場合は GitHub から、あるいは他方がセクション 1.4 に規定された守秘義務に違反した場合はいずれの当事者からも、相手方「当事者」に是正する期間を設けることなく、本契約を書面の通知により直ちに解約する権利を留保するものとします。

#### 1.1.4 解約の効果、存続規定

本契約を解約した場合、お客様は「注文書」を追加で締結することはできないものとします。ただし、残りの有効な「注文書」に対しては、本契約は引き続き有効になるものとします。 「注文書」の解約または失効の際、その「注文書」について、(i) 「ソフトウェア」や「サービス」の「プラン契約期間」は直ちに終了するものとし、(ii) 「注文書」に記載のあらゆる「プランライセンス」は自動的に解約となり、お客様は「製品」を利用する権利を喪失するものとし、(iii) 解約の前に、支払うべき「料金」があった場合、お客様はかかる「料金」を直ちに支払う必要があるものとし、(iv) お客様は、お客様が所有または管理する「ソフトウェア」のすべての複製物を破棄し、その履行を GitHub に対し書面で証明する必要があるものとし、(v) 各「当事者」は、「サービス」により許容される範囲において、相手方に属するすべての「機密情報」を直ちに返却 (相手方当事者が要請する場合は破棄) するものとします。 上記にかかわらず、お客様は、本契約または「注文書」の解約または失効後最大 90 日間、お客様のデータを移行するために引き続き「ソフトウェア」にアクセスすることができ、データをそのリポジトリに移行するよう要請できます。ただし、この期間中、お客様は「ソフトウェア」や「サービス」を実稼働ベースで利用することはできないものとします。 本契約または「注文書」の解約または失効により、その性質上合理的に存続すべきあらゆる規定は存続するものとします。

### 1.2 支払い

#### 1.2.1 料金

お客様は、減額や相殺などに類することを行わず、アメリカ合衆国ドルにより「料金」の全額を前払いで支払うことに同意します。 Dollars. お客様は、GitHub による請求の日付から 30 日以内に「料金」を支払う必要があります。 本契約により支払われる金額は、セクション 1.5.1 および 1.6.2 に定める場合を除き返金できません。 Amounts payable under this Agreement are non-refundable, except as provided in Sections 13 and 14.1. 本契約に関して課されたか、負うようになったあらゆる税金、料金、関税、および政府による査定 (GitHub の純利益に基づく税金を除く) について、お客様は全責任を負います。

#### 1.2.2 プランライセンスの追加購入

GitHub のウェブサイトまたは GitHub の営業チームを通じて要請することで、お客様は本契約の下、「プランライセンス」を追加で取得できます。 お客様が追加の「プランライセンス」を購入する場合、お客様は、該当する「プラン契約期間」の残高に応じた、その時点で最新の、適用される「料金」を支払う必要があります。 「注文書」に特に記載されている場合を除き、お客様が「プランライセンス」を 次の「プラン契約期間」まで更新した際、GitHub は毎年 1 回、すべての「プランライセンス」に対する請求を同時に行います。

#### 1.2.3 アドオンソフトウェア

「アドオンソフトウェア」のライセンスは、「ユーザ」ごとに付与されます。 For the avoidance of doubt, and unless otherwise set forth in an Order Form, the number of Subscription Licenses Customer has at any given time for Add-On Software must equal the number of Subscription Licenses Customer has for the Products under this Agreement. たとえば、お客様がすでに「製品」に対する100ユーザ分の「プランライセンス」を所有していて、「Advanced Security」のプランを購入したい場合、「Advanced Security」に対する100ユーザ分の「プランライセンス」を購入する必要があります。

### 1.3 プロフェッショナルサービス

お客様の「プロフェッショナルサービス」の要請に応じ、GitHub は「プロフェッショナルサービス」に記載されている「SOW」を提供するものとします。 GitHub は、それぞれの「SOW」に記載されている「プロフェッショナルサービス」を実施するものとします。 GitHub は、「プロフェッショナルサービス」が実施される方法および手段を管理するとともに、割り当てる担当者を決定する権利を留保するものとします。 GitHub は、GitHub がその行為および怠慢に対して責任を負うことを条件に、第三者を用いて「プロフェッショナルサービス」を実施できるものとします。 お客様は、ソフトウェア、ツール、仕様、アイデア、概念、発明、プロセス、テクニック、ノウハウを含む、「プロフェッショナルサービス」の実施に関連して使用または開発されたすべての権利、権原、および利益を GitHub が保持することを認め、これに同意するものとします。 「プロフェッショナルサービス」の実施中に、GitHub がお客様に提供する成果物について、お客様が「ソフトウェア」や「サービス」と併用する目的に限り、本契約の期間中、お客様に対して非独占的、譲渡不可、世界的規模、使用料無料の期間限定ライセンスを付与するものとします。

### 1.4 機密保持

いずれの「当事者」も、本契約で許容されている場合を除き、相手方「当事者」の「機密情報」を用いないものとします。 各「当事者」は、相手方「当事者」の「機密情報」について、その機密を保ち、それを保護するにあたり、少なくとも同様の性質を持つ自らの情報に払うものと同程度の注意を払うこと、いかなる場合においても合理的な程度の注意を払うことに同意します。 この同意には、かかる「機密情報」を、(i) かかる情報を知る必要がある、(ii) 本セクション 1.4 に従うために十分な、適切な合意をした当事者である、および (iii) 本セクション 1.4 に記載されている利用および開示の制限について知らされている「担当者」以外に開示しないことが含まれます。 Each Party is responsible for all acts and omissions of its Representatives. 上記の義務は、いずれかの「当事者」が、裁判所、行政機関、その他行政体からの命令または要求に従って、相手方「当事者」の「機密情報」を開示することを制限しないものとします。ただし、かかる開示を要求された「当事者」は、かかる通知が法律により禁じられている場合を除き、相手方「当事者」がかかる命令または要求に対して意義を唱えられるようにするための合理的な通知を行うことが求められます。 本セクション 1.4 に記載されている制限は、本契約の解約または失効後も存続するものとします。

### 1.5 訴訟に対する防御

両「当事者」はセクション 1.5 に定める通り、またその範囲において、第三者からの訴訟に対してお互いに防御し、あらゆる不利な最終判決または示談の合意により生じた金額を支払うものとします。ただし、防御する「当事者」が、訴訟について書面で速やかに通知を受け、防御および示談を行う権利がある場合に限ります。 防御される「当事者」は、防御する「当事者」に対し、要請されたあらゆる支援、情報、および権限を提供する必要があります。 防御する「当事者」は、支援の提供にかかった合理的な費用負担について相手方「当事者」に払い戻すものとし、相手方「当事者」の書面による同意なしに、第三者の訴訟に対して示談または告白を行わないものとします。また、この同意について不合理に拒否または遅延しないものとします。 本セクション 1.5 は、かかる訴訟に対する両「当事者」の唯一の責任および全責任を記述したものです。

#### 1.5.1 GitHub

GitHub は、関係会社以外の第三者による、お客様に対する訴訟について、お客様による「ソフトウェア」または「サービス」の許可を受けた利用が、関係会社以外の第三者の著作権、特許、または商標を侵害している、あるいは企業秘密を不正利用しているとする主張する限りにおいて、関係会社以外の第三者によるあらゆる訴訟に対しお客様を防御するものとします。 GitHub がいずれの訴訟であっても商業的に合理的な条件で解決できない場合、GitHub の判断により、以下のいずれかを行うことができるものとします。 (i) 「ソフトウェア」または「サービス」 (該当するもの) を改善、修復、または交換する、または (ii) お客様のプランを解約し、前払いされ使用されていないあらゆるプラン料金を返金する。 GitHub は、以下により生じた訴訟について、本セクション 1.5.1 の下に義務を負わないものとします。 (a) 「ソフトウェア」または「サービス」の改善、あるいは「ソフトウェア」または「サービス」を、本契約 (「ドキュメンテーション」含む) により明示的に許可されている以外の装置、デバイス、ソフトウェア、またはデータを用いた組み合わせ、操作、または利用すること、(b) 「ソフトウェア」または「サービス」の利用を中止するよう通知された後に、お客様が利用を止めなかった場合、(c) セクション 1.5.2 に基づくお客様の義務、(d) GitHub により無料で提供された製品またはサービス (「ソフトウェア」または「サービス」の利用を含む)、あるいは (e) 「ベータプレビュー」にアクセスするまたはこれらを利用すること。 本セクション 1.5.1 の下に GitHub が負う義務を解釈するにあたり、「ソフトウェア」および「サービス」には、GitHub により組み込まれたオープンソースコンポーネントを含みます。

#### 1.5.2 お客様

お客様は、関係会社以外の第三者による、以下により生じた訴訟に対し GitHub を防御するものとします。(i) お客様が「ソフトウェア」または「サービス」にアップロードした「お客様のコンテンツ」、(ii) お客様による守秘義務の不履行、GitHub の利用規約に対する違反を含む、お客様による本契約に対する違反、(iii) 「ソフトウェア」への「お客様による改善」、あるいは (iv) お客様が「ソフトウェア」または「サービス」と共に組み合わせ、操作、または利用する、あらゆるサードパーティーブランドの装置、デバイス、ソフトウェア、システム、またはデータ。

### 1.6 表明および保証、免責事項、責任の制限

#### 1.6.1 一般保証

各「当事者」は、相手方に対し、本契約を締結する法的権能および権限を持つこと、ならびに本契約、各「注文書」、「SOW」が、かかる「当事者」を本契約の規約および条件に拘束するために必要なあらゆる権限を有する、かかる「当事者」の従業員または代理人により締結されることを表明し、保証します。

#### 1.6.2 限定保証

**(i) 「ソフトウェア」。**GitHub は、(1) お客様がダウンロードにより入手できるようになった時点で、未修正の「ソフトウェア」が、あらゆるマルウェア、ウイルス、またはワーム (お客様のソフトウェア、ハードウェア、コンピュータシステム、またはネットワークを中断、無効化、または損害を与えるように設計されたコンピュータコードその他技術) を含まず、また伝染させないこと、ならびに (2) 最初のダウンロードが可能になった日から 90 日間、未修正の「ソフトウェア」が該当するドキュメントに実質的に準拠することを保証します。 GitHubは、お客様による「ソフトウェア」の利用が中断されないこと、または「ソフトウェア」の操作にエラーがないことを保証するものではありません。 お客様が「ソフトウェア」をセクション 2 および「ドキュメンテーション」で明示的に許可されていない方法で修正または利用した場合、本セクション 1.6.2 (i) の保証は適用されないものとします。 本保証の違反に対する GitHub による唯一の義務、およびお客様への唯一の救済手段は、GitHub が選択する以下のいずれかによるものとし、GitHub はその費用を負担します。 (a) 「ソフトウェア」の修復、(b) 「ソフトウェア」の交換、あるいは (c) 欠陥のある「ソフトウェア」に関する本契約を解約し、該当する欠陥のある「ソフトウェア」に対し、その時点の「プラン契約期間」において未使用の前払い「料金」を返金する。

(ii) **「プロフェッショナルサービス」。**GitHubは、お客様に対し、本契約に基づいて実施される「プロフェッショナルサービス」が、適切な有資格者により、専門的かつ職業的な方法で実施されることを保証します。 本保証の違反に対する GitHub による唯一の義務、およびお客様への唯一の救済手段は、GitHub が選択する以下のいずれかによるものとし、GitHub はその費用を負担します。(1) 本保証の水準を満たさなかったあらゆる「プロフェッショナルサービス」を、速やかに再実施する、あるいは (2) 違反を是正することができない場合、「SOW」を解約し、未使用の前払い「料金」を返金する。

#### 1.6.3 免責事項

**(i) 一般。**本契約に明示的に規定されている場合を除き、GitHub はいかなる種類の保証および表明も行わず、商品性、特定目的への適合性、非侵害性を含め、また取引の過程や取引の使用から生じる保証や条件を含むがこれらに限定されない、いかなる保証についても一切行わないことをここで特に明記します。 口頭か書面かを問わず、GitHub またはその他から提供される助言や情報は、本契約に明示的に記載されていないいかなる保証または条件ももたらしません。

**(ii) 「サービス」。**GitHub は、「サービス」を**「現状のまま」****「提供可能な状態で」**、いかなる保証もなしに提供します。 GitHub は、「サービス」に関して、商品性、特定目的への適合性、権原、セキュリティ、正確性、および非侵害性を含むがこれに限定されない一切の保証を明示的に否認します。 GitHub は、「サービス」がお客様の要件を満たすこと、「サービス」が中断されないこと、適時に提供されること、安全であること、またはエラーがないこと、「サービス」を通じて提供される情報が正確、信頼できる、または的確であること、あらゆる欠陥やエラーが修正されること、「サービス」が特定の時間や場所で利用できること、ならびに「サービス」にウイルスやその他の有害なコンポーネントが含まれていないことを保証しません。 GitHub は、お客様がファイル、情報、「コンテンツ」 、その他「サービス」から取得した資料のダウンロードおよび／または利用により生じるいかなる損失のリスクについても責任を負いません。

**(iii) 「ベータプレビュー」。**お客様は、自らの裁量により「ベータプレビュー」の利用を選択できます。 「ベータプレビュー」はサポートを受けることができない場合があり、その内容は随時予告なく変更される場合があります。 「ベータプレビュー」は、「サービス」ほど信頼性が高くない場合があります。または利用できない可能性もあります。 「ベータプレビュー」は、「サービス」にこれまでも現在も適用されているものと同等のセキュリティ対策および監査の対象ではありません。 GitHub は、「ベータプレビュー」に起因または関連する責任を負わないものとします。 **お客様は、自らの責任において「ベータプレビュー」を利用するものとします。**

#### 1.6.4 責任の制限

**(i)	「間接的損害」。 原因の如何に関わらず、かかる義務が契約、保証、不法行為 (過失を含む)、厳格責任などに基づく請求から生じるあらゆる請求に起因するか、また当事者がかかる損害の可能性について当事者が知らされていたかを問わず、間接的、特別的、偶発的、懲罰的または派生的損害 (利益、収益またはデータの損失を含む)、または本契約に起因または関連して発生する代替製品の取得費用について、いずれの当事者も、相手方当事者またはあらゆる第三者に対して、準拠法によって許される最大限の範囲で、いかなる場合においても責任を負わないものとします。**

**(ii) 「総責任額の制限」。 あらゆる訴因およびあらゆる責任に関する理論により、本契約の下におけるいずれの当事者が負う総責任額は、いかなる場合も、準拠法によって許される最大限の範囲で、かかる責任を生じさせるに至った請求の前の 12 か月間にお客様が GitHub に対して実際に支払った「料金」を超えないものとします。 無料で提供される製品およびサービス (「製品」の利用を含む) については、GitHub の責任は 5,000.00 USD までの直接損害賠償に限定されます。 「ベータプレビュー」については、GitHub の責任は 500.00 USD までの直接損害賠償に限定されます。**

**(iii) 例外。 本セクション 1.6.4 に定める除外および制限は、以下に起因する責任については適用されないものとします。(1) 「当事者」による、セクション 1.4 に記載の守秘義務違反。 ((「GitHub のコンテンツ」以外の) 「コンテンツ」 に関するあらゆる責任を除きます。これについては、上記の除外および制限が適用されます。) (2) 「当事者」による、セクション 1.5 に記載の防御義務。(3) セクション 2.1 および 2.2 に記載の、ライセンスの付与またはライセンスの制限にお客様が従わなかった場合。**

### 1.7 プランライセンス

「プランライセンス」は、「ユーザ」ごとに付与され、複数の「ユーザ」が同一の「プランライセンス」を利用することはできません。 お客様は、「プランライセンス」を最後に再割り当てしてから 90 日間が経過しなければ、新しい「ユーザ」に同一の「プランライセンス」を再割り当てすることはできません。ただし、再割り当てが以下の理由による場合を除きます。(i) ハードウェアの永久的な故障または喪失、(ii) 「ユーザ」の雇用または契約の終了、または (iii) 「ユーザ」の欠勤を代替するための、「プランライセンス」の一時的な再割り当て。 お客様がある「ユーザ」から別の「ユーザ」に「プランライセンス」を割り当てる際は、前の「ユーザ」の「プランライセンス」 およびお客様の「Organization」へのアクセスをお客様がブロックする必要があります。

### 1.8 関係会社

関係会社による「ソフトウェア」および「サービス」へのアクセスおよび利用について、お客様が完全に責任を負う限りにおいて、お客様の関係会社は、本契約に従い、「ソフトウェア」および「サービス」を利用することができます。

### 1.9 サポート

GitHub は、「ソフトウェア」および「サービス」について、以下の通り「サポート」を提供するものとします。

#### 1.9.1 Standard Support.

GitHub は、週末および米国の休日を除き、1 日 24時間、週 5 日の標準的な技術「サポート」を、「ソフトウェア」および「サービス」に対して無料で提供するものとします。 （アメリカの祝日は除く） 「Standard Support」は、「GitHub Support」を通じたウェブベースのチケット発行によってのみ提供され、「サポート」の要請は、GitHub の「サポート」チームがやり取りできる「ユーザ」から行う必要があります。

#### 1.9.2 Enhanced Support Offerings.

GitHub may provide enhanced Support offerings for the Software and Service (including the Premium, Premium Plus, and Engineering Direct Support offerings) in accordance with the [Support terms](/enterprise/admin/enterprise-support/about-github-premium-support-for-github-enterprise), and at the Support level, Fees, and Subscription Term specified in an Order Form or SOW.

#### 1.9.3 免責

GitHub は、お客様が GitHub に通知した、「ソフトウェア」のあらゆる重大、再現可能なエラーを修正するために合理的な努力を払うものとします。 ただし、(i) (GitHub 以外の) 誰かによる「ソフトウェア」の改善、(ii) 「ソフトウェア」またはその性能に悪影響を及ぼすような、お客様によるオペレーションシステムまたは環境の変更、(iii) 本契約または「ドキュメンテーション」により許可されている以外の方法によるお客様の「ソフトウェア」の利用、または (iv) お客様による怠慢または「ソフトウェア」の誤用がある場合、GitHub は「サポート」を提供する義務を負わないものとします。

### 1.10 知的財産権

両「当事者」間の関係において、GitHub は「製品」に対するおよびそれに付随する、すべての知的財産権を含め、すべての権利、権原、および利益を所有しています。 本契約によりお客様に対して明示的に付与されていない、「製品」に対するおよびそれに付随するすべての権利を GitHub は留保します。 GitHub はお客様が提供したりフォーラムに投稿してりすることがあるあらゆる「フィードバック」、コメント、提案を、お客様に対していかなる義務も負うことなく、「製品」に利用、改善、および組み込みすることができます。

### 1.11 フィードバック

お客様は、「製品」に関する「フィードバック」を GitHub に対して行うことができます。 「フィードバック」は自発的なものであり、「お客様の機密情報」と指定している場合であっても、「お客様の機密情報」としては取り扱われません。 GitHubは、かかるフィードバックを以下の目的で十分に活用できます。(i) GitHubの既存および将来的な製品提供、およびかかる提供品の商品化において、操作、機能性、利用性を向上させるため。(ii) 「製品」の品質についての集計した統計値を公開するため。ただし、公開されるデータは、お客様、お客様の従業員、およびお客様の所有するソフトウェアのコードを明確に特定するために用いられることはありません。

### 1.12 法令・規定の遵守

お客様は、「製品」の利用において、データ保護法および労働法規を含むがこれらに限定されない、適用されるすべての法律および規制を遵守するものとします。

### 1.13 一般条項

#### 1.13.1 準拠法、裁判地

お客様の主たる事務所がアメリカ大陸にある場合、本契約はカリフォルニア州の法律に準拠し、解釈されるものとしますが、同州法が定める抵触法の規定は適用を除外します。本契約の下により生じるあらゆる法的措置または手続きは、カリフォルニア州北部地区に在する連邦裁判所または州裁判所のみに提起されるものとし、両「当事者」は、ここに定める人的裁判管轄権よび裁判地に同意するものとします。 お客様の主たる事務所がアメリカ大陸外にある場合、本契約はアイルランドの法律に準拠し、本契約の下により生じるあらゆる法的措置または手続きは、ダブリンに在する裁判所のみに提起されるものとし、両「当事者」はここに定める人的裁判管轄権よび裁判地に同意するものとします。 両「当事者」は、国際物品売買契約に関する国際連合条約および統一コンピュータ情報取引法が本契約に適用されないことに明示的に合意します。 上記の定めにかかわらず、GitHub は適切な管轄権を有する裁判所に衡平法による救済を求めることができるものとします。

#### 1.13.2 米国政府のユーザ ユーザとしての政府機関.

「製品」は民間の資金のみで開発されたものであり、連邦調達規則 12.212 および 27.405-3、ならびに国防連邦調達規則補遺 227.7202-3 に定める「商用コンピュータソフトウェア」および「商用コンピュータソフトウェアドキュメンテーション」と見なされます。 The Products are licensed to the U.S. Government end user as restricted computer software and limited rights data. 本契約に基づいて技術データまたはコンピュータソフトウェアが開発されることはありません。 Any use, disclosure, modification, distribution, or reproduction of the Products or Documentation by the U.S. Government or its contractors is subject to the restrictions set forth in this Agreement. それ以外の使用を禁じます。

#### 1.13.3 輸出

「製品」は、米国政府による輸出規制および一部の外国政府による輸入規制の対象です。 Government and import restrictions by certain foreign governments, and Customer will comply with all applicable export and import laws and regulations in Customer’s use of the Products. お客様は、「製品」の利用にあたり、適用されるすべての輸出入法令を遵守するものとします。 お客様は、(i) あらゆる禁輸対象国またはテロリスト支援国家 (あるいはその国民または住民) に対し、(ii) 米国商務省の否認命令リストまたは米国財務省の特定国籍業者リストに掲載されている者に対し、(iii) かかる輸出または再輸出が制限または禁止されているあらゆる国、あるいは米国政府その他機関が、輸出または再輸出時に、輸出許可またはその他の承認を求める国に対し、かかる許可を得ずに、あるいは (iv) その他米国または外国の政府機関または当局の輸出または輸入の制限、法令または規制に違反する場合、米国からの持ち去りまたは輸出、あるいは「製品」のいかなる部分またはいかなる直接製品も輸出または再輸出をしてはならず、またいかなる第三者にもそれを許可してはなりません。 Commerce Department's Table of Denial Orders or U.S. Treasury Department's list of Specially Designated Nationals; (iii) to any country to which such export or re-export is restricted or prohibited, or as to which the U.S. government or any agency thereof requires an export license or other governmental approval at the time of export or re-export without first obtaining such license or approval; or (iv) otherwise in violation of any export or import restrictions, laws or regulations of any United States or foreign agency or authority. お客様は、 (a) お客様が、かかる禁止国に居住していないこと、その管理下にないこと、またはその国の国民または居住者でないこと、あるいはかかる禁止者のリストに掲載されていないこと、および (b) お客様のデータが武器の国際武器取引規則に基づいて管理されていないことを表明し、保証します。 International Traffic in Arms Regulations. お客様は、米国政府の事前の許可なしに、「製品」を核兵器、化学兵器、生物兵器またはミサイル技術の設計または開発に利用することが制限されていることを認め、これに同意するものとします。 GitHub Enterprise Server is a self-hosted virtual appliance that can be run within Customer’s own datacenter or virtual private cloud.

#### 1.13.4 無許可の宣伝の禁止

GitHub は、お客様を、現在または将来的な顧客に対する顧客として認識する場合があります。 ただし、GitHub は、お客様の名称やロゴを、お客様の許可なく広告またはマーケティング資料に用いることはできないものとします。

#### 1.13.5 譲渡

いずれの「当事者」も、本契約の一部または全体を、相手方当事者の書面による事前の同意なしに譲渡または移転してはならないものとし、またかかる同意を不合理に拒否しないものとし、不合理な拒否の試みは無効になるものとします。ただし、合併、取得、企業再編、あるいは事業または資産の全部または大部分の売却に関しては、相手方当事者に通知の上、相手方「当事者」の合意なく、GitHub は本契約の全体を譲渡できるものとします。

#### 1.13.6 通知

本契約に別段の定めがない限り、本契約に基づく通知、要請、要求、またはその他の通信は、書面 (電子メール可) によるものでなければならず、本契約を参照するものでなければならず、また、(i) 個人的に渡された場合には、その受領時に、(ii) 電子メールの場合は、受取人その受領を確認した後の 1 営業日に、(iii) 受取証明付き書留郵便または配達証明郵便で送付した場合には、送付した日から 5 営業日後、書面による受領確認および電子メールにより、または (iv) 国際的に認められている宅配便業者に入金し、電子メールを送付した後の 3 営業日、書面による受領確認により、正式に提供されたものと見なされます。 「当事者」が他方に対して住所変更を通知している場合を除き、通知は本契約に記載されている住所に送付できるものとします。

#### 1.13.7 不可抗力

天災、然災害、ストライキ、ロックアウト、暴動、戦争行為、伝染病、あるいは電力、通信またはネットワークの故障を含む合理的な制御を超えた異常事態により、本契約の下におけるあらゆる義務の履行が不可能な場合に限り、GitHub は、その責任を免除されるものとします。

#### 1.13.8 独立契約者

各「当事者」は、本契約の主題に関して独立契約者です。 本契約に含まれるいかなる規定も、法的関係、パートナーシップ、合弁事業、雇用、代理、受託、その他これらに類する関係を両「当事者」間に構築するものとはいかなる場合にも見なされるまたは解釈されるものではなく、またいずれの「当事者」も、他方を契約上拘束することはできません。

#### 1.13.9 権利放棄

本契約の下における「当事者」の義務は、相手方「当事者」の権限のある担当者が署名した書面によってのみ免除されます。 本契約の「当事者」が本契約に基づく権利の行使を怠るか遅滞したとしても、本契約を放棄したと見なされることはなく、また、本契約の何らかの権利またはその一部を行使することが、本契約の他の部分またはさらなるの行使、または本契約に基づく法律上または衡平法上の権利の行使を妨げるものでもありません。

#### 1.13.10 完全なる合意

本契約は、付属文書、各「注文書」および「SOW」とともに、本契約の主題に関する両「当事者」のすべての合意および理解を構成しており、かかる主題に関して、両「当事者」間の書面または口頭による、締結前または締結時におけるあらゆる理解および同意に優先します。 お客様の発注書にある規定、書面による規定、その他お客様が GitHub に提出したものにある規定が、本契約と異なる規定または本契約への規定の追加を含んでいる場合、いかなる「発注書」または「SOW」も無効であり、効力を持ちません。

#### 1.13.11 修正、優先順位

GitHub は、独自の裁量により、いつでも本契約を修正する権利を留保し、かかる修正があった場合には本契約を更新します。 GitHub は、独自の裁量により、いつでも本契約を修正する権利を留保し、かかる修正があった場合には本契約を更新します。 重要でない変更については、お客様が「サービス」を継続して利用することをもって、本契約の改訂に同意したものとみなされます。 お客様は、本契約に対するすべての変更を「[サイトポリシー](https://github.com/github/site-policy)」リポジトリで確認できます。 本契約の規定と、あらゆる「注文書」または「SOW」との間に万が一矛盾がある場合、その「注文書」または「SOW」に関してのみ、「注文書」または「SOW」の規定が支配するものとします。

#### 1.13.12 分離可能性

本契約のいずれかの規定が管轄裁判所により違法、無効または執行不能であると判断された場合には、両「当事者」は、当該規定が可能な限り効力を持つように本契約を修正または改正するものとします。 このような修正または改正ができない規定は、削除されたものとみなされ、本契約の残りの規定は、引き続き効力を持つものとします。


## セクション 2: GitHub Enterprise Server ライセンス規約

セクション 2 は、お客様による「ソフトウェア」の利用に適用される規約を詳述しています。

### 2.1 ライセンスの付与

GitHub は、お客様の内部業務目的のために「ソフトウェア」をインストールし利用するため、該当する「プラン契約期間」中、「ドキュメンテーション」に従い、お客様の「注文書」に記載された数の「プランライセンス」のみ、お客様の内部業務目的のために「ソフトウェア」をインストールし利用するための非独占的、譲渡不可、世界的規模、使用料無料の期間限定ライセンスをお客様に付与します。 「ソフトウェア」には、第三者によって GitHub にライセンスを付与されたコンポーネントが含まれており、そうしたソフトウエアの中には、GitHub に対して、それらのコンポーネントのソースコードを入手可能にすることを要求するソフトウェアも含まれています。 これらのコンポーネントのソースコードは、要請に応じて提供いたします。 Without limiting the foregoing, this license permits Customer to download and run Microsoft SQL Server Standard Edition container image for Linux files (“**SQL Server Images**”), which may be used only with the Software as documented. Customer’s right to use the SQL Server Images ends when Customer no longer has rights to use the Software, and Customer must uninstall the SQL Server Images when its right to use them ends. Microsoft Corporation may disable SQL Server Images at any time.

### 2.2 ライセンスの制限

法律または適用されるサードパーティライセンスによって明示的に許可されている場合を除き、お客様およびその関係会社は、いかなるサードパーティに対しても、次のことを行ったり、許可したりしてはなりません。(i) 「ソフトウェア」のサブライセンス、販売、賃貸、リース、譲渡、割り当て、または再配布、(ii) サードパーティの利益のために「ソフトウェア」をホストすること、(iii) 本セクション 2 に明示的に許可されている以外の方法で、サードパーティに対して「ソフトウェア」へのアクセスを開示または許可すること、(iv) 「ライセンスキー」をハッキングする、あるいはライセンスのあらゆる登録プロセスを回避または変更すること、(v) 「お客様による改善」以外で、「ソフトウェア」を改善または「ソフトウェア」の派生物を作成する、あるいは「ソフトウェア」を他のソフトウェアとマージすること、(vi) 逆アセンブル、逆コンパイル、コード難読化のバイパス、その他「ソフトウェア」のリバースエンジニアリング、あるいはソースコード全体または一部を抽出するよう試みること、(vii) 「ソフトウェア」または「ドキュメンテーション」内またはそれらに含まれるあらゆる所有権の通知を改変、不明瞭化、または削除すること、または、(viii) 本契約に明示的に許可されていない方法で 「ソフトウェア」または「ドキュメンテーション」を利用または複製すること。

### 2.3 デリバリ

GitHub は、安全で、パスワードで保護されたウェブサイトから、お客様が「ライセンスキー」をダウンロードで入手できるようにするものとします。 本セクション 2 に基づくすべてのデリバリは電子的なものとします。 疑義を避けるため、お客様はソフトウェアのインストールに責任を負い、「ライセンスキー」の交付後は、GitHub がその「ソフトウェア」についてそれ以上のデリバリを行う義務を負わないことを認めます。 「アップデート」が入手可能になった際、GitHub はその「アップデート」を同一のウェブサイトからダウンロードできるようにするものとします。 お客様は、最低限 1 年に 1 回以上、商業的に合理的な頻度で「ソフトウェア」を「アップデート」する必要があります。 お客様は、お客様のユーザ名とパスワードの機密性を維持する責任を負います。

### 2.4 検証

お客様は、GitHub の要請に基づき、お客様が本契約に従って「ソフトウェア」を利用していることを検証する、「ソフトウェア」が生成したレポートを GitHub に対して速やかに提供するものとします。 GitHub は、本契約の規定を最初に超過した日から、あらゆる追加利用に対する請求書を送付するものとします。

### 2.5 アップデート、リリース

#### 2.5.1 一般

GitHub は、「ソフトウェア」に対する「アップデート」および「リリース」を、お客様が「ソフトウェア」および「ライセンスキー」をダウンロードした場所と同一の安全なウェブサイトにおいてお客様が入手できるようにするものとします。

#### 2.5.2 サポートされるリリース

GitHub は、「ソフトウェア」の特定の「リリース」について、元の「リリース」日から 1 年間、または直近の「リリース」の「アップデート」から 6 か月のうち長い方の期間のみ「サポート」します。 GitHub は、「ソフトウェア」の特定の「リリース」について、元の「リリース」日から 1 年間、または直近の「リリース」の「アップデート」から 6 か月のうち長い方の期間のみ「サポート」します。

### 2.6 Data Protection Considerations for Use of GitHub Insights and Learning Lab for Enterprise Server.

If Customer’s planned use of GitHub Insights or Learning Lab for Enterprise Server involves processing personal data, Customer is solely responsible for determining whether or not to complete a data protection impact assessment or otherwise secure formal legal analysis of Customer’s planned use. It is in Customer’s sole discretion whether to use GitHub Insights or Learning Lab for Enterprise Server to process Customer’s employees’ and/or users’ data, and if Customer does so, Customer is solely responsible for conducting such processing in compliance with applicable law.


### セクション 3: GitHub Enterprise Cloud 利用規約

本セクション 3 では、お客様または GitHub がお客様に代わって「サービス」に「企業アカウント」および/または「Organization」を作成した際、お客様による「サービス」の利用に適用される条件について詳細に説明します。

### 3.1 アカウント利用規約

#### 3.1.1 アカウントの管理

**(i) ユーザ。**お客様は、「ユーザ」が各自のアカウントおよびアカウント内の「コンテンツ」に対する最終的な管理権限を保持することに同意するものとします。 「ユーザ」の「サービス」利用については、本セクション 3 に基づく「ユーザ」のアクティビティに関するものを除き、[GitHub の「標準利用規約」](/github/site-policy/github-terms-of-service)が適用されます。

**(ii) Organization。**お客様は、本セクション 3 に従い、お客様を代表して作成されたあらゆる Organization、およびその Organization 内のリポジトリに投稿された「ユーザ生成コンテンツ」について、最終的な管理権限を保持します。 本セクション 3 は、お客様の Organization の利用について定めます。

#### 3.1.2 アカウントの要件

お客様がアカウントを作成するには、以下を遵守する必要があります:

**(i)** お客様は、13歳未満が利用するためのアカウントを作成してはなりません。 GitHub が 13歳未満の「ユーザ」を知った場合には、その「ユーザ」のアカウントを直ちに削除します。 お客様またはその「ユーザ」が米国外に居住する場合には、その国に適用される最低年齢が 13 歳以上である場合があります。かかる場合、お客様はその国の法律に従う責任を負います。

**(ii)** 「ユーザ」は、ログインを複数人で共有することはできません。

**(iii)** Customer must not use the Service (a) in violation of export control or sanctions laws of the United States or any other applicable jurisdiction, (b) if it is located in or ordinarily resident in a country or territory subject to comprehensive sanctions administered by the U.S. Office of Foreign Assets Control (OFAC), or (c) if Customer is or is working on behalf of a [Specially Designated National (SDN)](https://www.treasury.gov/resource-center/sanctions/SDN-List/Pages/default.aspx) or a person subject to similar blocking or denied party prohibitions. 詳しい情報については、[GitHub の「輸出規制」方針](/articles/github-and-export-controls)を参照してください。

#### 3.1.3 アカウントのセキュリティ

お客様は、以下に対して責任を負います。(i) お客様の「企業アカウント」における、投稿された「コンテンツ」およびアクティビティの全て、(ii) お客様のアカウントのログイン認証情報に関するセキュリティの維持、(iii) お客様のアカウントを通じた、「サービス」のあらゆる不正利用や不正アクセスを認識した際には、速やかに[GitHub に通知](https://support.github.com/contact)すること。  GitHub は、お客様が本セクション 3.1.3 に従わなかったことにより生ずるいかなる損失または損害にも責任を負いません。

#### 3.1.4 追加条項

場合によっては、お客様による「サービス」の利用について、第三者による条項が適用されることがあります。 たとえば、お客様が独自の条項またはライセンス契約を持つ Organization の成員である場合、お客様が「サービス」に統合するアプリケーションをダウンロードしている場合、お客様が他のサービスに認証するために「サービス」を利用している場合などです。 本契約は、お客様と GitHub との完全な合意を示していますが、お客様と第三者との関係については第三者の条項が適用されます。

#### 3.1.5 米国連邦政府の条項 米国連邦政府の条項.

If Customer is a U.S. federal government agency or otherwise accessing or using any portion of the Service in a government capacity, the [U.S. Federal Government Amendment](/articles/amendment-to-github-terms-of-service-applicable-to-us-federal-government-users) applies, and Customer agrees to its provisions.

### 3.2 法の遵守、利用規程、プライバシー

#### 3.2.1 法令・規定の遵守
お客様が「サービス」を使用する際には、著作権法、商標法、輸出規制法、または管轄における規制を含むいかなる適用法にも違反してはなりません。

#### 3.2.2 利用規定
お客様が「製品」を利用する際には、[「GitHub利用規程」](/articles/github-acceptable-use-policies)および[「GitHubコミュニティガイドライン」](/articles/github-community-guidelines)に従う必要があります。 お客様は、いかなる管轄区域内でも、違法、わいせつ、不快、または詐欺的なコンテンツまたは活動 (損害を与えたりそう標榜したりする、ネットワークまたはシステムの完全性またはセキュリティを妨害または侵害する、フィルタを回避する、迷惑・虐待的・虚偽的なメッセージ、ウイルスまたは有害なコードを送信する、あるいは第三者の権利を侵害するなど) の目的で「サービス」を使用してはなりません。

#### 3.2.3 プライバシー
[The GitHub Privacy Statement](/articles/github-privacy-statement) and the [GitHub Data Protection Addendum](/github/site-policy/github-data-protection-addendum) provide detailed notice of GitHub's privacy and data use practices as well as GitHub's processing and security obligations with respect to Customer Personal Data. 「サービス」からデータを収集する個人、団体、またはサービスは、特にユーザの個人情報 (GitHubのプライバシーについての声明に定める) の収集に関して、[「GitHubのプライバシーについての声明」](/articles/github-privacy-statement)に従う必要があります。 お客様がGitHubから「ユーザ個人情報」を収集した場合、お客様は「外部ユーザ」が承認した目的にのみその個人情報を使用するものとします。 お客様は、かかる個人情報を合理的に保護するものとし、GitHubはGitHubまたは「外部ユーザ」からの苦情、削除要請、および連絡拒否の要請に速やかに対応するものとします。

### 3.3 コンテンツの責任、所有権、ライセンス権

#### 3.3.1 「ユーザ生成コンテンツ」に対する責任
「サービス」の利用中に、お客様は「ユーザ生成コンテンツ」を作成またはアップロードすることができます。 投稿、アップロード、リンク、その他の方法でお客様が「サービス」を介して利用できるようにした「ユーザ生成コンテンツ」については、その「ユーザ生成コンテンツ」の形式にかかわらず、お客様が全責任を負うものとします。 GitHubは、「ユーザ生成コンテンツ」のいかなる公開表示または悪用に対しても責任を負いません。

#### 3.3.2 コンテンツの所有権、投稿する権利、ライセンスの付与

**(i)** お客様が作成または所有する「お客様のコンテンツ」の所有権は、お客様が保持します。 お客様は、 (a)「お客様のコンテンツ」に責任を負うこと、 (b) お客様が投稿する権利を有する「お客様のコンテンツ」(サードパーティまたはユーザーが生成したコンテンツを含む) に限って送信すること、(c) お客様が投稿する「お客様のコンテンツ」に関サードパーティのライセンスに完全に従うことに同意するものとします。

**(ii)** お客様は、セクション3.3.3から3.3.6で規定されている権利を、無料で、かつ同セクションに記された目的のために付与します。これは、お客様が「お客様のコンテンツ」をGitHubサーバから削除するまで続きますが、お客様が公に投稿し「外部ユーザ」がフォークしたコンテンツは例外となり、その場合は「お客様のコンテンツ」のすべてのフォークがGitHubサーバから削除されるまで続きます。 お客様が、「サービス」を実行するために必要な権限をGitHubに付与するライセンスをあらかじめ伴うような「お客様のコンテンツ」をアップロードする場合、追加のライセンスは必要ありません。

#### 3.3.3 GitHubへのライセンス付与
お客様は、「お客様のコンテンツ」を保存、解析、表示し、「サービス」の提供に必要な限りにおいて付随的な複製を作成する権利をGitHubに付与します。 これには、「お客様のコンテンツ」をGitHubのデータベースにコピーし、バックアップを作成する権利、お客様およびお客様が閲覧者として選択した相手に「お客様のコンテンツ」を表示する権利、「お客様のコンテンツ」を解析して検索インデックスを作成するなどの形でGitHubのサーバ上で分析する権利、お客様がコンテンツの共有相手として選択した外部ユーザーと「お客様のコンテンツ」を共有する権利、および音楽や動画のような場合に「お客様のコンテンツ」を実演する権利が含まれます。 これらの権利は、パブリックリポジトリとプライベートリポジトリの両方に適用されます。 このライセンスは、「お客様のコンテンツ」を販売またはその他の方法で配布する、あるいは「サービス」以外で使用する権利をGitHubに付与するものではありません。 お客様は、帰属先を明示せず、また「サービス」の提供に必要な限りにおいて「お客様のコンテンツ」を合理的に適応させる目的で、「お客様のコンテンツ」に必要な権利をGitHubに付与します。

#### 3.3.3 外部ユーザへのライセンス付与
**(i)** Issue、コメント、外部ユーザのリポジトリへのコントリビューションなど、お客様が公に投稿するコンテンツは、他のユーザーが閲覧することができます。 リポジトリを公開表示に設定することで、お客様は外部ユーザがお客様のリポジトリを閲覧しフォークすることを許可するものとします。

**(ii)** お客様がそのページおよびリポジトリを一般に公開表示に設定する場合、お客様は「サービス」を通じて「お客様のコンテンツ」を使用、表示、および実演し、またGitHub が提供する機能を通じて許可される限りにおいて (フォークなど) のみ「サービス」上でお客様のコンテンツを複製する、非独占的かつ世界的ライセンスを外部ユーザーに付与します。 お客様が[ライセンスを採用](/articles/adding-a-license-to-a-repository/#including-an-open-source-license-in-your-repository)した場合、お客様は「お客様のコンテンツ」に他の権利を付与することができます。 お客様が作成または所有していない「お客様のコンテンツ」をアップロードする場合には、アップロードする「お客様のコンテンツ」が、これらの権限を外部ユーザーに付与する条項に基づいて必ずライセンスされるよう図る責任をお客様は負います。

#### 3.3.5 リポジトリのライセンス下でのコントリビューション
お客様がライセンスの通知を含むリポジトリに対してコントリビューションを行う際、お客様は必ず同じ条件のもとでそのコントリビューションをライセンスし、それらの条件下でかかるコントリビューションをライセンスする権利を有することに同意するものとします。 お客様が、コントリビューターライセンス契約など、異なる条件のもとでコントリビューションのライセンスを別途締結している場合は、その契約が優先されます。

#### 3.3.6 人格権
お客様は、完全性と帰属の権利も含めて、「サービス」の任意の部分に対してアップロード、公開、またはサブミットする「お客様のコンテンツ」について、すべての人格権を保持します。 ただしお客様は、GitHubがセクション3.3で付与された権利を合理的に行使できるようにする目的に限り、これらの権利を放棄し、GitHubに対してこれらの権利を主張しないことに同意するものとしますが、その目的以外ではこの限りではありません。

### 3.4. プライベートリポジトリ.

#### 3.4.1 管理
お客様は、招待、OrganizationおよびTeamの管理制御、アクセスの終了など、プライベートリポジトリへのアクセスを管理する責任を負います。

#### 3.4.2 機密保持
GitHubは、お客様のプライベートリポジトリにある「お客様のコンテンツ」をお客様の機密情報と見なします。 GitHubは、プライベートリポジトリの「お客様のコンテンツ」を、セクション1.4に従って保護し、厳密に機密扱いします。

#### 3.4.3 アクセス
GitHubがお客様のプライベートリポジトリにアクセスするのは、(i) サポート上の理由からお客様の同意と承認を得ている、または (ii) セキュリティ上の理由からアクセスが必須となっている場合だけです。  お客様は、プライベートリポジトリへのアクセスを追加することもできます。 たとえば、プライベートリポジトリにある「お客様のコンテンツ」への追加の権利を必要とするGitHubの各種サービスまたは機能を有効にするなどが考えられます。 これらの権利はサービスまたは機能によって異なりますが、GitHubは引き続き、お客様のプライベートリポジトリにある「お客様のコンテンツ」をお客様の機密情報として扱います。 これらのサービスが、「サービス」の提供に必要な以上の権利を追加で必要とする場合、GitHubはその件について説明を行います。

#### 3.4.4 免責
プライベートリポジトリのコンテンツが法律または本契約に違反していると考えられる理由がある場合、GitHubはそのコンテンツにアクセスし、レビューして削除する権利を有します。 また、GitHubはお客様のプライベートリポジトリのコンテンツを開示するよう法律で強制される場合があります。 法律に基づく要件で別段拘束されていない限り、またはセキュリティ上の脅威などセキュリティに対するリスクに対応する目的で、GitHubはかかる行動について通知します。

### 3.5. 知的財産に関する通知

#### 3.5.1 コンテンツに対するGitHubの権利
「サービス」の見た目は、copyright © GitHub, Inc. All rights reserved で保護されています。 お客様は、GitHubからの書面による許可なく、HTML/CSS、Javascript、またはビジュアルデザイン要素またはコンセプトのいかなる部分も複製、コピー、再利用することはできません。

#### 3.5.2 著作権侵害とDMCAポリシー

お客様が著作権所有者であり、「サービス」上のコンテンツがお客様の著作権を侵害していると考えられる場合、お客様は[GitHubのデジタルミレニアム著作権法 (DMCA) ポリシー](https://github.com/contact/dmca)に従って、[DMCAの様式](https://github.com/contact/dmca-notice)でGitHubに通知するか、またはcopyright@github.com.に電子メールを送信すして、GitHubに連絡することができます。

#### 3.5.3 GitHubのトレードマークとロゴ

お客様がGitHubのトレードマークを使用したい場合は、[GitHubのロゴと使い方のページ](https://github.com/logos)の内容も含めて、トレードマークに関するGitHubのすべてのガイドラインに従う必要があります。

### 3.6 一時停止
GitHubは、本契約への違反があった場合、または「サービス」の完全性、操作性、およびセキュリティを保護する目的で、いつでも「サービス」の全部または一部へのアクセスを一時停止する権利を有します。一時停止は、通知によって即時発効しますが、かかる通知が法律または法的手続きによって禁止されている、または「サービス」または第三者への差し迫った損害の防止に妨げとなる場合は除きます。 通常は、かかる一時停止の時点またその前に、バナーの形で通知します。 GitHubは、「サービス」の完全性、操作性、およびセキュリティを保全する必要に応じ、その裁量により、かつ誠意をもって任意の一時停止を調整します。

### 3.7 Service Level Agreement.

GitHub’s quarterly uptime commitment for the Service is provided in the [Enterprise Service Level Agreement](/github/site-policy/github-enterprise-service-level-agreement). Customer will be entitled to a service credit if GitHub does not meet its service level.

### 3.8 サービスの変更
GitHub は、「アップデート」および新機能の追加により、サービスを変更します。 セクション3.7に従い、GitHubは通知の有無にかかわらず、「サービス」(またはその一部) をいつでも変更する、あるいは一時的または恒久的に停止する権利を留保するものとします。

### 3.9 追加サービス機能

「サービス」の一部機能については、[GitHub 追加製品の利用規約](/github/site-policy/github-additional-product-terms)に記載されている規約も適用される場合があります。 これらの機能にアクセスまたはこれらを利用することにより、お客様は GitHub 追加製品の利用規約にも同意することになります。

## EXHIBIT A: DEFINITIONS

「**アクティブユーザ**」とは、「停止」時に「サービス」へのアクセスを試みる「ユーザ」を意味します。

**”Add-On Software”** means Advanced Security, Insights, Learning Lab for Enterprise Server, and other additional Software add-on products that GitHub may offer from time to time.

「**Advanced Security**」とは、カスタマイズ可能で、自動化されたセマンティックコードを通じて、お客様がセキュリティの脆弱性を特定できるソフトウェア機能を意味します。

「**関係会社**」とは、直接的または間接的に支配している、支配されている、あるいは当事者と共通の支配下にある、あらゆる法人を意味します。本定義において「支配」とは、所有権のうち 50% 超を持つか、当該法人の経営管理を指揮する権限を有することを意味します。

「**全ユーザ**」とは、「サービス」を利用する、「お客様」の「ユーザ」および「外部ユーザ」を総称的に意味します。

「**アメリカ大陸**」とは、アメリカ合衆国、カナダ、メキシコ、中南米諸国、およびカリブ海諸国を意味します。

「**ベータプレビュー**」とは、アルファ、ベータ、プレビュー、アーリーアクセス、評価版、またはその他同様の意味を持つ言葉や表現により称されるソフトウェア、サービス、または機能を意味します。

「**機密情報**」とは、書面、口頭、その他の手段により機密として指定されたか、あるいは開示側の「当事者」にとって機密であることを受領側の 「当事者」 が知っているまたは開示に関する状況および情報の性質により、機密であることを合理的に知っていると判断される、いずれかの「当事者」 により、他の当事者に開示された、あらゆる非公開情報を意味します。 疑義を避けるため、お客様の「プライベートリポジトリ」に保存されたお客様の「コンテンツ」を除き、「サービス」に投稿された「コンテンツ」は「機密情報」と見なされないものとします。 「機密情報」には、以下のいずれの情報も含まれません。(i) 受領側当事者の過失によらず、公知であったもの、あるいは公知となったもの、(ii) 開示する権利を有する開示側当事者以外の情報源から、機密または所有権の制約を受けることなく、受領側「当事者」が正当に知っていたか正当に知るようになったもの、(iii) 開示側「当事者」に正式に委託を受けた職員により署名された書面により、制約を受けることなく開示することについて、かかる開示側「当事者」により承認されたもの、(iv) 相手方「当事者」の「機密情報」を入手または利用することなく、受領側「当事者」が独自に開発したもの、(v) 「サービス」内、かつお客様の「プライベートリポジトリ」以外に保存または投稿されるまたはされているもの。

「**Connect**」または「**GitHub Connect**」とは、お客様が「ソフトウェア」で「サービス」に接続できるようにする、「ソフトウェア」に含まれる機能を意味します。 「GitHub Connect」の利用については、[GitHub 追加製品の利用規約](/github/site-policy/github-additional-product-terms)に記載されている「GitHub Connect」の規約も適用されます。

「**コンテンツ**」とは、機能、表示、その他 「サービス」を通じて利用できる、テキスト、データ、記事、画像、写真、図表、ソフトウェア、アプリケーション、設計、機能、その他それらに制約されないあらゆる素材を意味します。

「**企業アカウント**」とは、法人を代表して「ユーザ」により作成されたアカウントを意味します。

「**お客様**」とは、GitHub 「同意する」またはそれに類似するボタンをクリックするか、「製品」にアクセスすることにより、GitHub と本契約を締結した企業または団体、その「関係会社」および「担当者」を総称的に意味します。

「**お客様のコンテンツ**」とは、お客様が作成、所有するか、お客様が権利を所有する 「コンテンツ」 を意味します。

「**お客様による改善**」とは、「ソフトウェア」に含めるまたは「ソフトウェア」からリンクすることができる、オープンソースライセンスの下にライセンスを受けたあらゆるライブラリのバグ修正、カスタマイズ、または追加機能を開発する目的のためにのみお客様が行うことができる「ソフトウェア」の改善を意味します。

「**ドキュメンテーション**」とは、GitHub が提供するか、お客様に利用できるようにする、「ソフトウェア」または「サービス」に関連したあらゆるマニュアル、ドキュメンテーション、その他補助資料を意味します。

「**発効日**」とは、お客様が (i) 上記の本契約の規約および条件に同意した日か、(ii) 「製品」を最初に注文した日のうち、いずれか早いほうの日を意味します。

「**不可欠なサービス**」 とは、リポジトリの作成、「フォーク」、およびクローン、ブランチの作成、コミット、およびマージ、プルリクエストの作成、レビュー、およびマージ、ならびに中核となる Git ワークフローへのウェブ、API、および Git クライアントサービスを含む、GitHub の中核となるバージョン管理機能にとって不可欠なサービスを意味します。 これに含まれない周辺的な機能およびサービスの例としては、webhook、Gist、Pages、およびメール通知が挙げられます。

「**外部ユーザ**」とは、「サービス」にアクセスまたは「サービス」を利用する、「お客様」以外の「ユーザ」である個人を意味します。 「料金」とは、(i) 該当する「プラン契約期間」中に「製品」 を利用するため、または (ii) 「プロフェッショナルサービス」を受けるために、GitHub がお客様に支払う必要のある費用を意味します。かかる費用は「注文書」または SOW に記載されています。

「**フィードバック**」とは、GitHub の製品またはサービスについてのアイデア、ノウハウ、アルゴリズム、コードへのコントリビューション、提案、機能拡張リクエスト、その他あらゆるフィードバックを意味します。

「**料金**」とは、(i) 該当する「プラン契約期間」中に「製品」 を利用するため、または (ii) 「プロフェッショナルサービス」を受けるために、GitHub がお客様に支払う必要のある費用を意味します。かかる費用は「注文書」または SOW に記載されています。

「**フォーク**」とは、1 つのリポジトリの「コンテンツ」を別のリポジトリにコピーすることを意味します。

「**GitHub**」とは、GitHub, Inc、その「関係会社」および「担当者」を総称的に意味します。

「**GitHub のコンテンツ**」とは、GitHub が作成、所有、またはその権利を所有する「コンテンツ」を意味します。

「**GitHub Insights**」または「**Insights**」とは、「ソフトウェア」の利用に関するメトリクス、分析、および推奨事項をお客様に提供するソフトウェア機能を意味します。 「GitHub Insights」には、Organization のインサイトやリポジトリのインサイトなど、GitHub のレガシー機能は含まれません。

**“GitHub One”** means the Product bundle which includes GitHub Enterprise, Advanced Security, Insights, Learning Lab for Enterprise Server, and Premium Plus or Engineering Direct Support.

**"Learning Lab for Enterprise Server"** means the Software feature that enables Users to learn about GitHub functionality, including associated Documentation.

「**ライセンスキー**」とは、お客様に「ソフトウェア」のインストール、操作、および利用ができるようにするための、「ソフトウェア」のアクセス管理機構により用いられるデータファイルを意味します。

「**コンピュータアカウント**」とは、「コンピュータアカウント」のために該当する利用規約を受け入れ、有効なメールアドレスを提供し、その動作について責任を負う人間個人により登録されたアカウントを意味します。 「コンピュータアカウント」は、自動化されたタスクを実行するためにのみ用いられます。 「コンピュータアカウント」の動作は、複数の「ユーザ」が指示できますが、コンピュータの動作について究極的な責任を負うのは、アカウントの所有者です。

「**注文書**」とは、「当事者」が「製品」を注文するために用いる、書面または電子的なドキュメント (見積書を含む) を意味します。

「**Organization**」とは、複数の「ユーザ」が、一度に多くのプロジェクトをまたいでコラボレートするために、 単一のエンティティあるいは 1 つまたは複数の「ユーザ」に関連付けることができる共有のワークスペースを意味します。 「ユーザ」は複数の「Organization」のメンバーになることができます。

「**停止**」とは、50% を超える「アクティブユーザ」に影響する、「不可欠なサービス」の中断を意味します。

「**プライベートリポジトリ**」とは、「ユーザ」が「コンテンツ」へのアクセスを制御できるリポジトリを意味します。

「**プロフェッショナルサービス**」とは、相互に締結した「SOW」に従い、GitHub が提供するトレーニング、コンサルティング、または実装サービスを意味します。 「プロフェッショナルサービス」には、「サポート」は含まれません。

「**パブリックリポジトリ**」とは、「コンテンツ」が「全ユーザ」に表示できるリポジトリを意味します。

「**リリース**」とは、GitHub がそのお客様に対して一般的に入手できるようにする「ソフトウェア」のリリースと、それに対応する「ドキュメンテーション」のあらゆる変更を意味し、機能拡張、新機能、新機能性が含まれ、一般的に左から 1 つ目の点の右側にある数字の変更 (例: x.x.x から x.y.x)、または左側の数字の変更 (例: x.x.x から y.x.x) により示されます。

「**担当者**」とは、「当事者」の従業員、代理人、独立契約者、コンサルタント、および財務顧問を意味します。

「**スクレイピング**」とは、ボットやウェブクローラーなどの自動的な処理により、「サービス」からデータを抽出することを意味します。GitHub の API を通して情報を収集することはこれに含まれません。

「**サービス**」とは、ホストされた GitHub Enterprise Cloud サービスを意味します。 「サービス」には、「Organization」アカウント、SAML シングルサインオン、アクセスのプロビジョニング、および該当するあらゆる「ドキュメンテーション」が含まれます。 ここに挙げた機能やサービスは網羅的なものではなく、随時アップデートされる可能性があります。

「**サービスクレジット**」とは、以下に定める計算により、GitHub が適格なアカウントに払い戻す、ドルのクレジットを意味します。

「**ソフトウェア**」とは、GitHub Enterprise Server のオンプレミスのソフトウェアを意味します。 「ソフトウェア」には、「GitHub Connect」機能、該当するあらゆる「ドキュメンテーション」に加え、GitHub がお客様に提供するまたは本契約の下でアクセスできる「ソフトウェア」のあらゆる「アップデート」、さらにお客様のプランに含まれる場合は「アドオンソフトウェア」が含まれます。

「**SOW**」とは、GitHub が実施する「プロフェッショナルサービス」の作業詳細、それに関するあらゆる「料金」、およびそれに関する各「当事者」の義務について、相互に締結した声明書を意味します。

「**プランライセンス**」とは、お客様を代表して「製品」をインストール、操作、アクセス、および利用するために各「ユーザ」に割り当てられるライセンスを意味します。 お客様は、GitHub Enterprise Server のインスタンスおよび GitHub Enterprise Cloud Organization にわたって、「ユーザ」ごとに「プランライセンス」を 1 つのみ割り当てることができます。 各「ユーザ」は、お客様の Enterprise Server インスタンスまたは Enterprise Cloud Organization に、お客様が許可する範囲でアクセスできます。 ただし、明確にするために記すと、お客様が「プランライセンス」を「ユーザ」にいったん割り当ててから、1 人の「ユーザ」が Enterprise Server の「プランライセンス」を利用しながら、別の「ユーザ」が同一の「プランライセンス」で GitHub Enterprise Server の別のインスタンスまたは GitHub Enterprise Cloud の Organization を利用できるようにお客様が「プランライセンス」を分けることは認められないものとします。

「**プラン契約期間**」とは、注文に適用される発効日か、「注文書」に記載されている発効日から 1 年間の期間を意味します。

「**サポート**」とは、GitHub が提供する場合がある、「ソフトウェア」または「サービス」への技術サポートを意味します。

「**アップデート**」とは、GitHub がそのお客様に対して一般的に入手できるようにする「ソフトウェア」のリリースと、それに対応する「ドキュメンテーション」のあらゆる変更を意味し、エラーの修正やバグの修正が含まれ、一般的に左から 2 つ目の点の右側にある数字の変更 (例: x.x.x から x.x.y) により示されます。

「**稼働時間**」とは、各四半期において、GitHub の「不可欠なサービス」が、50% を超える「アクティブユーザ」に影響を与える「停止」により中断されていない時間のパーセンテージを意味します。

「**ユーザ**」とは、(i) 「ソフトウェア」に関しては、「ソフトウェア」の機能を実行するにあたり、「ソフトウェア」の実行を開始するか、「ソフトウェア」と対話するか、「ソフトウェア」に命令する、1 人の人または「コンピュータアカウント」を意味します。(ii) 「サービス」に関しては、「お客様」を代表して、(a) 「サービス」にアクセスまたはそれを利用する、(b) 「お客様」のアカウントの一部にアクセスまたはそれを利用する、あるいは (c) 機能を実行するにあたり「お客様」のアカウントの利用を命令する、個人または「コンピュータアカウント」を意味します。 「ユーザ」の数は、「お客様」が購入した「プランライセンス」の数を超過してはなりません。

「**ユーザ生成コンテンツ**」とは、第三者または「外部ユーザ」が作成または所有する「コンテンツ」を意味します。
