---
title: GitHub Data Protection Addendum
versions:
  free-pro-team: '*'
---

Version Effective Date: July 20, 2020

## INTRODUCTION

The parties agree that the GitHub Data Protection and Security Exhibit (together, the **"Data Protection Addendum"** or **“DPA”**) sets forth their obligations with respect to the processing and security of Customer Personal Data in connection with the GitHub Enterprise Cloud hosted service (the **“Service”**). GitHub makes the commitments in this DPA to all customers using the Service. Separate terms, including different privacy and security terms, govern Customer’s use of non-GitHub products.

In the event of any conflict or inconsistency between the DPA and any other terms in Customer’s agreements with GitHub, the DPA shall prevail. The provisions of the DPA supersede any conflicting provisions of the GitHub Privacy Statement that otherwise may apply to processing of Customer Personal Data as defined herein. For clarity, consistent with Clause 10 of the Standard Contractual Clauses in Attachment 1, the Standard Contractual Clauses prevail over any other terms in the DPA.


## GITHUB DATA PROTECTION

### 1.  定義

1.1 The "**Applicable Data Protection Laws**" means certain laws, regulations, regulatory frameworks, or other legislations relating to the processing and use of Customer Personal Data, as applicable to Customer's use of GitHub and the GitHub Service, including:

  a.  EU 一般データ保護規則 2016/679 (「**GDPR**」)、および施行されているまたはそれに準ずる、効力を有し適用される国家の法令

  b.  The California Consumer Privacy Act of 2018, Cal. Civ. Code §§1798.100 et seq. (**"CCPA"**); and

  c.  The UK Data Protection Act 2018 and implementation of GDPR contained therein.

1.2 "**Controller**," "**Data Subject**," "**Member State**," "**Personal Data**," "**Personal Data Breach**," "**Processing**," "**Processor**," and "**Supervisory Authority**" have the meanings given to them in the Applicable Data Protection Laws. 不一致がある場合は、GDPR で規定された意味が優先されます。

1.3  「**お客様の個人データ**」とは、GitHubによる処理のためにお客様から提供されるか、または本契約に基づく義務を履行する過程でGitHubによって生成されるものかを問わず、お客様がコントローラー (管理者) である個人データのことを言います。 これには、支払い情報、IPアドレス、法人のメールアドレスなど、お客様がコントローラー (管理者) であるあらゆる個人データが該当します。

1.4  「**お客様のリポジトリデータ**」とは、お客様がプライベートリポジトリにアップロードまたは作成した任意のデータまたは情報のことを言います。

1.5 「**データ侵害**」とは、個人データの侵害など、保護されているお客様のデータの侵害が確認された、または合理的に疑われる場合を差します。

1.6  「**エンドユーザー**」とは、GitHubアカウントを管理し、GitHub利用規約に同意していて、その個人データがGitHubによって転送、保存、処理されるデータ主体です。 たとえば、GitHubアカウントを持っている、お客様の各従業員や契約者も、GitHubのエンドユーザーです。

1.7  データ処理の「**許可された目的**」とは、本契約、GitHubのプライバシーについての声明、およびこの付属文書Aに規定されている「サービス」を提供する限定的で特定の目的、あるいはデータ主体がお客様の個人データの使用を承認した目的のことです。

1.8  「**保護されたデータ**」には、本契約に基づいてGitHubが顧客に代わって処理するお客様の個人データとお客様のリポジトリデータが含まれます。

1.9  "**Sensitive Data**" means any Customer Personal Data revealing racial or ethnic origin; political opinions, religious or philosophical beliefs or trade union membership; processing of genetic data or biometric data for the purposes of uniquely identifying a natural person; data concerning health, a natural person's sex life or sexual orientation; and data relating to offences, criminal convictions, or security measures.

### 2. ステータスとコンプライアンス

#### 2.1 Data Processing.
GitHub acts as a Processor in regard to any Customer Personal Data it receives in connection with the Agreement, and GitHub will process Customer Personal Data only for Permitted Purposes in accordance with Customer's instructions as represented by the Agreement and other written communications. 適用されるデータ保護法との不一致などが理由で、GitHubがお客様の指示を遵守できない場合、または適用されるデータ保護法その他の法的要件によって処理が必要とされる場合、GitHubは許可される範囲でお客様に通知します。 GitHubは、お客様の個人データをすべて米国ならびに欧州連合で処理しますが、GitHubのサブプロセッサー (副処理者) はデータを米国または欧州連合以外で処理する可能性があります。 また、GitHubはお客様のリポジトリデータについて処理者として機能します。

#### 2.2 Data Controllers.
GitHub receives Customer Personal Data both from Customer and directly from Data Subjects who create End User accounts. お客様は、直接GitHubに移転する場合にお客様の個人データのコントローラー (管理者) となります。

#### 2.3 GitHub Compliance; Data Transfers.
GitHub will comply with Applicable Data Protection Laws in relation to the processing of Customer Personal Data.

All transfers of Customer Personal Data out of the European Union, European Economic Area, United Kingdom, and Switzerland to provide the Service shall be governed by the Standard Contractual Clauses in Attachment 1 (Standard Contractual Clauses). GitHub will abide by the requirements of European Economic Area and Swiss data protection law regarding the collection, use, transfer, retention, and other processing of Customer Personal Data from the European Economic Area, United Kingdom, and Switzerland. All transfers of Customer Personal Data to a third country or an international organization will be subject to appropriate safeguards as described in Article 46 of the GDPR and such transfers and safeguards will be documented according to Article 30(2) of the GDPR.

In addition, GitHub is certified to the EU-U.S. and Swiss-U.S. Privacy Shield Frameworks and the commitments they entail, although GitHub does not rely on them as a legal basis for transfers of Personal Data.  GitHub agrees to notify Customer if it makes a determination that it can no longer meet its obligation to provide the same level of protection as is required by the Privacy Shield principles.


### 3. データ保護

#### 3.1 Purpose Limitation.
GitHub will process and communicate the Protected Data only for Permitted Purposes, unless the Parties agree in writing to an expanded purpose.

#### 3.2 Data Quality and Proportionality.
GitHub will keep the Customer Personal Data accurate and up to date, or enable Customer to do so. GitHubは商業的に妥当な手順で、お客様に代わって収集した保護データが適切、妥当であり、それが移転および処理される目的に関連して過剰でないことを保証します。 いかなる場合も、GitHubがお客様に代わって故意に過密データを集めることはありません。 お客様は、GitHubサービスが機密データの保存を目的にしないことに同意するものとします。お客様が選択して機密データをサービスにアップロードする場合、お客様はGDPRの第9条、または適用されるデータ保護法で該当する条項に従う必要があります。

#### 3.3 Data Retention and Deletion.
Upon Customer's reasonable request, unless prohibited by law, GitHub will return, destroy, or deidentify all Customer Personal Data and related data at all locations where it is stored after it is no longer needed for the Permitted Purposes within thirty days of request. 適用されるデータ保護法が必要とする限りにおいて、また適用されるデータ保護法の定める範囲とその期間に限って、GitHubはお客様の個人データと関連データを保持する場合があります。ただし、お客様の個人データは適用されるデータ保護法に定められた目的上必要な場合に限って処理し、その他の目的では処理しないこと、またお客様の個人データは適用されるデータ保護法で引き続き保護されることをGitHubは保証するものとします。

#### 3.4 Data Processing.
GitHub provides the following information, required by Article 28(3) of the GDPR, regarding its processing of Customer's Protected Data:

a.  お客様の個人データの*主題と処理期間*は、本契約および本付属文書で定められています。

b.  お客様の個人データの*処理の性質と目的*は、本付属文書のセクション3.1に記載されています。

c.  *処理されるお客様の個人データのタイプ*は、GitHubのプライバシーについての声明に記載されており、ユーザ名、パスワード、メールアドレス、IPアドレスなどの個人データが含まれます。 GitHubは、お客様のアカウントに対する請求に必要な情報を処理しますが、クレジットカード情報は処理も保存もしません。 お客様は、お客様のプロフィール設定で、あるいはお客様の個人データをGitHubリポジトリにアップロードすることによって、追加の個人データをGitHubに提供することもできます。

d.  *お客様の個人データが関係するデータ主体のカテゴリ*は、お客様自体と、そのエンドユーザです。

e.  *お客様の義務の権利*は、本契約および本付属文書で定められています。

### 4. セキュリティと監査の義務

#### 4.1 Technical and Organizational Security Measures.
Taking into account the state of the art, the costs of implementation, and the nature, scope, context and purposes of processing as well as the risk of varying likelihood and severity for the rights and freedoms of natural persons, GitHub will implement appropriate technical and organizational measures to ensure a level of security appropriate to the risks, such as against accidental or unlawful destruction, or loss, alteration, unauthorized disclosure or access, presented by processing the Protected Data. GitHubは、こうした対策の準拠状況を常に監視し、本契約の期間を通じて適切な安全対策をとり続けます。 セキュリティ上の安全対策については、GitHubの責任を定めた、セキュリティに関する付属文書のセクション1.1.を参照してください。

#### 4.2 Incident Response and Breach Notification.
GitHub will comply with the Information Security obligations in the GitHub Security Exhibit and the Applicable Data Protection Laws, including Data Breach notification obligations. セキュリティ上の安全対策については、データ侵害の対応と通知を定めた、セキュリティに関する付属文書のセクション1.2.を参照してください。

#### 4.3 GitHub Personnel.
GitHub represents and warrants that it will take reasonable steps to ensure that all GitHub personnel processing Protected Data have agreed to keep the Protected Data confidential and have received adequate training on compliance with this Addendum and the Applicable Data Protection Laws.

#### 4.4 Records.
GitHub will maintain complete, accurate, and up to date written records of all categories of processing activities carried out on behalf of Customer containing the information required under the Applicable Data Protection Laws. 支援がGitHubのセキュリティに、または個々のデータ主体のプライバシー権にリスクをもたらさない限り、GitHubはこれらの記録を、お客様が適用されるデータ保護法に準拠していることを証明するためなど合理的に必要とされる場合に、請求があればお客様に公開します。 セキュリティインシデントの発生時に支援を提供する際のGitHubの要件については、GitHubのセキュリティに関する付属文書のセクション1.2を参照してください。

#### 4.5 Compliance Reporting.
GitHub will provide security compliance reporting in accordance with Section 2.3 of the GitHub Security Exhibit and privacy compliance reporting in accordance with Section 2.3 of the GitHub Security Exhibit. お客様は、適用されるデータ保護法 (該当する場合は、GDPRの第28条第3項hも含め) によって付与される情報および監査の権利が、これらのコンプライアンスレポートによって満たされること、またGitHubの提供するコンプライアンスレポートが十分な情報を提供しない場合、またはお客様が規制当局または監督機関の監査に応じなければならない場合に限り発生することに同意します。 規制当局または監督機関の監査に関する当局の責任については、GitHubのセキュリティに関する付属文書のセクション3.1に記載されています。

#### 4.6 Assistance.
GitHub will provide reasonable assistance to Customer with concerns such as data privacy impact assessments, Data Subject rights requests, consultations with Supervisory Authorities, and other similar matters, in each case solely in relation to the processing of Customer Personal Data and taking into account the nature of processing.

### 5. 保護データの使用と開示

#### 5.1 No Use in Marketing.
GitHub will not use the Protected Data for the purposes of advertising third-party content, and will not sell the Protected Data to any third party except as part of a merger or acquisition.

#### 5.2 GitHub Privacy Statement.
The GitHub Privacy Statement, publicly available at [https://docs.github.com/articles/github-privacy-statement](/articles/github-privacy-statement), provides detailed notice of GitHub's privacy and data use practices, including its use of cookies, its dispute resolution process, and further details about GitHub's GDPR compliance.

### 6. 副処理とデータの委譲

#### 6.1 Protection of Data.
GitHub is liable for onward transfers of Protected Data to its subprocessors, such as its third-party payment processor. In the event that GitHub does transfer the Protected Data to a third-party subprocessor, or GitHub installs, uses, or enables a third party or third-party services to process the Protected Data on GitHub's behalf, GitHub will ensure that the third-party subprocessor is bound by written agreement that requires them to provide at least the same level of confidentiality, security, and privacy protection as is required of GitHub by this DPA and the Applicable Data Protection Laws.

#### 6.2 Acceptance of GitHub Subprocessors.
Customer authorizes GitHub to appoint (and permit each subprocessor appointed in accordance with this Section 6 to appoint) subprocessors in accordance with Section 6 and any other restrictions in the Agreement. GitHubは、本契約の発効日時点で契約している現行のサブプロセッサーをそのまま採用し続けることもできます。

#### 6.3 General Consent for Onward Subprocessing.
Customer provides a general consent for GitHub to engage onward subprocessors, conditional on GitHub's compliance with the following requirements:

a.  Any onward subprocessor must agree in writing to only process data in a country that the European Commission has declared to have an "adequate" level of protection; or to only process data on terms equivalent to the Standard Contractual Clauses, or pursuant to a Binding Corporate Rules approval granted by competent European data protection authorities, or pursuant to compliant and valid EU-US Privacy Shield and Swiss-U.S. Privacy Shield certifications; and

b.  GitHubは、後続のサブプロセッサーによるお客様の個人データへのアクセスを、そのサービスの実施に厳密に必要な内容のみに制限し、サブプロセッサーがそれ以外の目的でお客様の個人データを処理することを禁じます。

#### 6.4 Disclosure of Subprocessor Agreements.
GitHub maintains a list of onward subprocessors it has engaged to process Customer Personal Data at [https://docs.github.com/articles/github-subprocessors-and-cookies](/articles/github-subprocessors-and-cookies), including the categories of Customer Personal Data processed, a description of the type of processing the subprocessor performs, and the location of its processing. お客様から書面による請求があれば、GitHubはこのサブプロセッサーリストと、お客様の個人データが処理されるときの条項を提供します。 サブプロセッサーの守秘制限に従って、GitHubはリストと条項をお客様に提供する前に、機密情報や商売上重要な情報を削除する場合があります。 GitHubが機密または重要な情報お客様に開示できない場合、当事者はGitHubが副処理の契約に従って合理的に可能な情報を提供することに合意します。

#### 6.5 Objection to Subprocessors.
GitHub will provide thirty (30) days' prior written notice of the addition or removal of any subprocessor, including the categories listed in Section 6.4, by announcing changes on its <https://github.com/github/site-policy> site. GitHubと新しいサブプロセッサーとの契約に合理的な異議がある場合、お客様はただちに書面でGitHubに通知する必要があります。 可能な場合GitHubは、異議を受けたサブプロセッサーによるデータの処理を避けるために、商業的に相応の努力で、該当する「サービス」に代替策を講じるものとします。 90日以内にGitHubが代替策を講じられず、当事者も解決できない場合、お客様は本契約を解約することができます。

### 7. 解約

#### 7.1 一時停止
In the event that GitHub is in breach of its obligations to maintain an adequate level of security or privacy protection, Customer may temporarily suspend the transfer of all Customer Personal Data or prohibit collection and processing of Customer Personal Data on Customer's behalf until the breach is repaired or the Agreement is terminated.

#### 7.2 Termination with Cause.
In addition to any termination rights Customer has under the Agreement, Customer may terminate the Agreement without prejudice to any other claims at law or in equity in the event that:

a.  GitHubがプライバシー義務を満たせなくなったとお客様に通達する。

b.  お客様の個人データすべての委譲、収集、処理が、セクション7.1に従って1か月以上一時停止されている。

c.  GitHubが、本付属文書での保証または代理を実質的に、または永続的に侵害している。

d.  GitHubが、事業を継続しなくなった、解散した、財産管理に入った、あるいはGitHubに代わって清算命令が発令された。

e.  セクション6.5に従ってお客様がサブフォルダに異議を申し立て、GitHubが90日以内に代替策を講じられなかった。

#### 7.3 Breach.
Failure to comply with the material provisions of this Addendum is considered a material breach under the Agreement.

#### 7.4 Failure to perform.
In the event that changes in law or regulation render performance of this Addendum impossible or commercially unreasonable, the Parties may renegotiate the Addendum in good faith. 再交渉しても解決に至らない、または当事者が合意に達しない場合、当事者は30日後に本契約を解約できます。

#### 7.5 Notification.
In the event that GitHub determines that it can no longer meet its privacy obligations under this Addendum, GitHub will notify Customer in writing immediately.

#### 7.6 Modifications.
GitHub may modify this Addendum from time to time as required by the Applicable Data Protection Laws, with thirty days' notice to Customer.

#### 7.7 Termination Requirements.
Upon Termination, GitHub must:

a.  妥当かつ適切な手段を講じて、お客様の個人データの処理を停止する。

b.  セクション3.3に従ってGitHubがお客様に代わって保存していたお客様の個人データを、解約後90日以内に削除または匿名化する。

c.  gitHubがセクション7.7の義務に従っているという合理的な保証をお客様に提示する。

### 8. データ処理の責任

#### 8.1 Limitations.
Except as limited by the Applicable Data Protection Laws, any claims brought under this Addendum will be subject to the terms of the Agreement regarding Limitations of Liability.

## Attachment 1 – The Standard Contractual Clauses (Processors)
Execution of the applicable agreement by Customer includes execution of this Attachment 1 to the GitHub Data Protection Addendum, which is countersigned by GitHub, Inc.

In countries where regulatory approval is required for use of the Standard Contractual Clauses, the Standard Contractual Clauses cannot be relied upon under European Commission 2010/87/EU (of February 2010) to legitimize export of data from the country, unless Customer has the required regulatory approval.

For the purposes of Article 46(2) of the General Data Protection Regulation (EU 2016/679) for the transfer of personal data to processors established in third countries which do not ensure an adequate level of data protection, Customer (as data exporter) and GitHub (as data importer, whose signature appears below), each a “party,” together “the parties,” have agreed on the following Contractual Clauses (the “Clauses” or “Standard Contractual Clauses”) in order to adduce adequate safeguards with respect to the protection of privacy and fundamental rights and freedoms of individuals for the transfer by the data exporter to the data importer of the personal data specified in Appendix 1.

#### Clause 1: Definitions
(a) 'personal data', 'special categories of data', 'process/processing', 'controller', 'processor', 'data subject' and 'supervisory authority' shall have the same meaning as in the General Data Protection Regulation (EU 2016/679) on the protection of individuals with regard to the processing of personal data and on the free movement of such data;

(b) 'the data exporter' means the controller who transfers the personal data;

(c) 'the data importer' means the processor who agrees to receive from the data exporter personal data intended for processing on his behalf after the transfer in accordance with his instructions and the terms of the Clauses and who is not subject to a third country's system ensuring adequate protection within the meaning of Article 45(2) of the General Data Protection Regulation (EU 2016/679);

(d) 'the subprocessor' means any processor engaged by the data importer or by any other subprocessor of the data importer who agrees to receive from the data importer or from any other subprocessor of the data importer personal data exclusively intended for processing activities to be carried out on behalf of the data exporter after the transfer in accordance with his instructions, the terms of the Clauses and the terms of the written subcontract;

(e) 'the applicable data protection law' means the legislation protecting the fundamental rights and freedoms of individuals and, in particular, their right to privacy with respect to the processing of personal data applicable to a data controller in the Member State in which the data exporter is established;

(f) 'technical and organisational security measures' means those measures aimed at protecting personal data against accidental or unlawful destruction or accidental loss, alteration, unauthorised disclosure or access, in particular where the processing involves the transmission of data over a network, and against all other unlawful forms of processing.

#### Clause 2: Details of the transfer
The details of the transfer and in particular the special categories of personal data where applicable are specified in Appendix 1 below which forms an integral part of the Clauses.

#### Clause 3: Third-party beneficiary clause
1. The data subject can enforce against the data exporter this Clause, Clause 4(b) to (i), Clause 5(a) to (e), and (g) to (j), Clause 6(1) and (2), Clause 7, Clause 8(2), and Clauses 9 to 12 as third-party beneficiary.

2. The data subject can enforce against the data importer this Clause, Clause 5(a) to (e) and (g), Clause 6, Clause 7, Clause 8(2), and Clauses 9 to 12, in cases where the data exporter has factually disappeared or has ceased to exist in law unless any successor entity has assumed the entire legal obligations of the data exporter by contract or by operation of law, as a result of which it takes on the rights and obligations of the data exporter, in which case the data subject can enforce them against such entity.

3. The data subject can enforce against the subprocessor this Clause, Clause 5(a) to (e) and (g), Clause 6, Clause 7, Clause 8(2), and Clauses 9 to 12, in cases where both the data exporter and the data importer have factually disappeared or ceased to exist in law or have become insolvent, unless any successor entity has assumed the entire legal obligations of the data exporter by contract or by operation of law as a result of which it takes on the rights and obligations of the data exporter, in which case the data subject can enforce them against such entity. Such third-party liability of the subprocessor shall be limited to its own processing operations under the Clauses.

4. The parties do not object to a data subject being represented by an association or other body if the data subject so expressly wishes and if permitted by national law.

#### Clause 4: Obligations of the data exporter
The data exporter agrees and warrants:

(a) that the processing, including the transfer itself, of the personal data has been and will continue to be carried out in accordance with the relevant provisions of the applicable data protection law (and, where applicable, has been notified to the relevant authorities of the Member State where the data exporter is established) and does not violate the relevant provisions of that State;

(b) that it has instructed and throughout the duration of the personal data processing services will instruct the data importer to process the personal data transferred only on the data exporter's behalf and in accordance with the applicable data protection law and the Clauses;

(c) that the data importer will provide sufficient guarantees in respect of the technical and organisational security measures specified in Appendix 2 below;

(d) that after assessment of the requirements of the applicable data protection law, the security measures are appropriate to protect personal data against accidental or unlawful destruction or accidental loss, alteration, unauthorised disclosure or access, in particular where the processing involves the transmission of data over a network, and against all other unlawful forms of processing, and that these measures ensure a level of security appropriate to the risks presented by the processing and the nature of the data to be protected having regard to the state of the art and the cost of their implementation;

(e) that it will ensure compliance with the security measures;

(f) that, if the transfer involves special categories of data, the data subject has been informed or will be informed before, or as soon as possible after, the transfer that its data could be transmitted to a third country not providing adequate protection within the meaning of the General Data Protection Regulation (EU 2016/679);

(g) to forward any notification received from the data importer or any subprocessor pursuant to Clause 5(b) and Clause 8(3) to the data protection supervisory authority if the data exporter decides to continue the transfer or to lift the suspension;

(h) to make available to the data subjects upon request a copy of the Clauses, with the exception of Appendix 2, and a summary description of the security measures, as well as a copy of any contract for subprocessing services which has to be made in accordance with the Clauses, unless the Clauses or the contract contain commercial information, in which case it may remove such commercial information;

(i) that, in the event of subprocessing, the processing activity is carried out in accordance with Clause 11 by a subprocessor providing at least the same level of protection for the personal data and the rights of data subject as the data importer under the Clauses; and

(j) that it will ensure compliance with Clause 4(a) to (i).

#### Clause 5: Obligations of the data importer
The data importer agrees and warrants:

(a) to process the personal data only on behalf of the data exporter and in compliance with its instructions and the Clauses; if it cannot provide such compliance for whatever reasons, it agrees to inform promptly the data exporter of its inability to comply, in which case the data exporter is entitled to suspend the transfer of data and/or terminate the contract;

(b) that it has no reason to believe that the legislation applicable to it prevents it from fulfilling the instructions received from the data exporter and its obligations under the contract and that in the event of a change in this legislation which is likely to have a substantial adverse effect on the warranties and obligations provided by the Clauses, it will promptly notify the change to the data exporter as soon as it is aware, in which case the data exporter is entitled to suspend the transfer of data and/or terminate the contract;

(c) that it has implemented the technical and organisational security measures specified in Appendix 2 before processing the personal data transferred;

(d) that it will promptly notify the data exporter about:

(i) any legally binding request for disclosure of the personal data by a law enforcement authority unless otherwise prohibited, such as a prohibition under criminal law to preserve the confidentiality of a law enforcement investigation,

(ii) any accidental or unauthorised access, and

(iii) any request received directly from the data subjects without responding to that request, unless it has been otherwise authorised to do so;

(e) to deal promptly and properly with all inquiries from the data exporter relating to its processing of the personal data subject to the transfer and to abide by the advice of the supervisory authority with regard to the processing of the data transferred;

(f) at the request of the data exporter to submit its data processing facilities for audit of the processing activities covered by the Clauses which shall be carried out by the data exporter or an inspection body composed of independent members and in possession of the required professional qualifications bound by a duty of confidentiality, selected by the data exporter, where applicable, in agreement with the supervisory authority;

(g) to make available to the data subject upon request a copy of the Clauses, or any existing contract for subprocessing, unless the Clauses or contract contain commercial information, in which case it may remove such commercial information, with the exception of Appendix 2 which shall be replaced by a summary description of the security measures in those cases where the data subject is unable to obtain a copy from the data exporter;

(h) that, in the event of subprocessing, it has previously informed the data exporter and obtained its prior written consent;

(i) that the processing services by the subprocessor will be carried out in accordance with Clause 11; and

(j) to send promptly a copy of any subprocessor agreement it concludes under the Clauses to the data exporter.

#### Clause 6: Liability
1. The parties agree that any data subject who has suffered damage as a result of any breach of the obligations referred to in Clause 3 or in Clause 11 by any party or subprocessor is entitled to receive compensation from the data exporter for the damage suffered.

2. If a data subject is not able to bring a claim for compensation in accordance with paragraph 1 against the data exporter, arising out of a breach by the data importer or his subprocessor of any of their obligations referred to in Clause 3 or in Clause 11, because the data exporter has factually disappeared or ceased to exist in law or has become insolvent, the data importer agrees that the data subject may issue a claim against the data importer as if it were the data exporter, unless any successor entity has assumed the entire legal obligations of the data exporter by contract of by operation of law, in which case the data subject can enforce its rights against such entity. The data importer may not rely on a breach by a subprocessor of its obligations in order to avoid its own liabilities.

3. If a data subject is not able to bring a claim against the data exporter or the data importer referred to in paragraphs 1 and 2, arising out of a breach by the subprocessor of any of their obligations referred to in Clause 3 or in Clause 11 because both the data exporter and the data importer have factually disappeared or ceased to exist in law or have become insolvent, the subprocessor agrees that the data subject may issue a claim against the data subprocessor with regard to its own processing operations under the Clauses as if it were the data exporter or the data importer, unless any successor entity has assumed the entire legal obligations of the data exporter or data importer by contract or by operation of law, in which case the data subject can enforce its rights against such entity. The liability of the subprocessor shall be limited to its own processing operations under the Clauses.

#### Clause 7: Mediation and jurisdiction
1. The data importer agrees that if the data subject invokes against it third-party beneficiary rights and/or claims compensation for damages under the Clauses, the data importer will accept the decision of the data subject:

(a) to refer the dispute to mediation, by an independent person or, where applicable, by the supervisory authority;

(b) to refer the dispute to the courts in the Member State in which the data exporter is established.

2. The parties agree that the choice made by the data subject will not prejudice its substantive or procedural rights to seek remedies in accordance with other provisions of national or international law.

#### Clause 8: Cooperation with supervisory authorities
1. The data exporter agrees to deposit a copy of this contract with the supervisory authority if it so requests or if such deposit is required under the applicable data protection law.

2. The parties agree that the supervisory authority has the right to conduct an audit of the data importer, and of any subprocessor, which has the same scope and is subject to the same conditions as would apply to an audit of the data exporter under the applicable data protection law.

3. The data importer shall promptly inform the data exporter about the existence of legislation applicable to it or any subprocessor preventing the conduct of an audit of the data importer, or any subprocessor, pursuant to paragraph 2. In such a case the data exporter shall be entitled to take the measures foreseen in Clause 5(b).

#### Clause 9: Governing Law.
The Clauses shall be governed by the law of the Member State in which the data exporter is established.

#### Clause 10: Variation of the contract
The parties undertake not to vary or modify the Clauses. This does not preclude the parties from adding clauses on business related issues where required as long as they do not contradict the Clause.

#### Clause 11: Subprocessing
1. The data importer shall not subcontract any of its processing operations performed on behalf of the data exporter under the Clauses without the prior written consent of the data exporter. Where the data importer subcontracts its obligations under the Clauses, with the consent of the data exporter, it shall do so only by way of a written agreement with the subprocessor which imposes the same obligations on the subprocessor as are imposed on the data importer under the Clauses. Where the subprocessor fails to fulfil its data protection obligations under such written agreement the data importer shall remain fully liable to the data exporter for the performance of the subprocessor's obligations under such agreement.

2. The prior written contract between the data importer and the subprocessor shall also provide for a third-party beneficiary clause as laid down in Clause 3 for cases where the data subject is not able to bring the claim for compensation referred to in paragraph 1 of Clause 6 against the data exporter or the data importer because they have factually disappeared or have ceased to exist in law or have become insolvent and no successor entity has assumed the entire legal obligations of the data exporter or data importer by contract or by operation of law. Such third-party liability of the subprocessor shall be limited to its own processing operations under the Clauses.

3. The provisions relating to data protection aspects for subprocessing of the contract referred to in paragraph 1 shall be governed by the law of the Member State in which the data exporter is established.

4. The data exporter shall keep a list of subprocessing agreements concluded under the Clauses and notified by the data importer pursuant to Clause 5 (j), which shall be updated at least once a year. The list shall be available to the data exporter's data protection supervisory authority.

#### Clause 12: Obligation after the termination of personal data processing services
1. The parties agree that on the termination of the provision of data processing services, the data importer and the subprocessor shall, at the choice of the data exporter, return all the personal data transferred and the copies thereof to the data exporter or shall destroy all the personal data and certify to the data exporter that it has done so, unless legislation imposed upon the data importer prevents it from returning or destroying all or part of the personal data transferred. In that case, the data importer warrants that it will guarantee the confidentiality of the personal data transferred and will not actively process the personal data transferred anymore.

2. The data importer and the subprocessor warrant that upon request of the data exporter and/or of the supervisory authority, it will submit its data processing facilities for an audit of the measures referred to in paragraph 1.

### Appendix 1 to the Standard Contractual Clauses
Data exporter: Customer is the data exporter.

**Data importer:** The data importer is GitHub, Inc., a global producer of software and services.

**Data subjects:** Data subjects include the data exporter’s representatives and end-users including employees, contractors, collaborators, and customers of the data exporter. Data subjects may also include individuals attempting to communicate or transfer personal information to users of the services provided by data importer. GitHub acknowledges that, depending on Customer’s use of the Service, Customer may elect to include personal data from any of the following types of data subjects in the Customer Personal Data:

-   Employees, contractors and temporary workers (current, former, prospective) of data exporter;
-   Dependents of the above;
-   Data exporter's collaborators/contact persons (natural persons) or employees, contractors or temporary workers of legal entity collaborators/contact persons (current, prospective, former);
-   Users (e.g., customers, clients, patients, visitors, etc.) and other data subjects that are users of data exporter's services;
-   Partners, stakeholders or individuals who actively collaborate, communicate or otherwise interact with employees of the data exporter and/or use communication tools such as apps and websites provided by the data exporter;
-   Stakeholders or individuals who passively interact with data exporter (e.g., because they are the subject of an investigation, research or mentioned in documents or correspondence from or to the data exporter); or
-   Professionals with professional privilege (e.g., doctors, lawyers, notaries, religious workers, etc.).

**Categories of data:** The personal data transferred that is included in e-mail, documents and other data in an electronic form in the context of the Service.  GitHub acknowledges that, depending on Customer’s use of the Service, Customer may elect to include personal data from any of the following categories in the Customer Personal Data:
-   Authentication data (for example, username, email, password);
-   Contact information (for example, email);
-   Unique identification numbers and signatures (IP addresses, unique identifier in tracking cookies or similar technology).
-   Other unique identifying information. Data subjects may include more data such as real names, avatar images, and other personal information;

**Special categories of data (if appropriate):** The data importer does not intentionally collect or process any special categories of data in carrying out its services to the data exporter.

However, because the data importer provides storage services and does not control the categories of data it stores, the data exporter may choose to transfer special categories of data. Consequently, the data exporter is solely responsible for ensuring that it complies with all obligations imposed by applicable laws and regulations relating to the collection and processing of any special categories of data, including obtaining the explicit consent of the data subject prior to processing sensitive personal data.

**Processing operations:** The personal data transferred will be subject to the following basic processing activities: GitHub uses personal data for the limited purposes set forth in the GitHub Privacy Statement, available at [https://docs.github.com/articles/github-privacy-statement](/articles/github-privacy-statement), and the “Data Processing” section of the DPA. Subcontractors: In accordance with the DPA, the data importer may hire other companies to provide limited services on data importer’s behalf, such as providing customer support. Any such subcontractors will be permitted to obtain Customer Personal Data only to deliver the services the data importer has retained them to provide, and they are prohibited from using Customer Personal Data for any other purpose.

### Appendix 2 to the Standard Contractual Clauses
Description of the technical and organizational security measures implemented by the data importer in accordance with Clauses 4(d) and 5(c):

**1. Personnel.** Data importer’s personnel will not process Customer Personal Data without authorization. Personnel are obligated to maintain the confidentiality of any Customer Personal Data and this obligation continues even after their engagement ends.

**2. Data Privacy Contact.** The data privacy officer of the data importer can be reached at the following address: GitHub, Inc. Attn: Privacy 88 Colin P. Kelly Jr. Street San Francisco, CA 94107 USA

**3. Technical and Organization Measures.** The data importer has implemented and will maintain appropriate technical and organizational measures, internal controls, and information security routines intended to protect Customer Personal Data, as defined in the GitHub Security Exhibit, against accidental loss, destruction, or alteration; unauthorized disclosure or access; or unlawful destruction as follows: The technical and organizational measures, internal controls, and information security routines set forth in the GitHub Security Exhibit are hereby incorporated into this Appendix 2 by this reference and are binding on the data importer as if they were set forth in this Appendix 2 in their entirety. Signature of GitHub, Inc. appears below.

Signing the Standard Contractual Clauses, Appendix 1 and Appendix 2 on behalf of the data importer

![Screen Shot 2020-07-20 at 2 20 29 PM](/assets/images/help/site-policy/docusign-signature.png)

Lynn Hashimoto, Head of Product & Regulatory Legal

GitHub, Inc.


## SECURITY EXHIBIT

### 1. 情報セキュリティプログラム

#### 1.1 セキュリティ管理

Throughout the duration of the Agreement, GitHub will maintain and enforce a written information security program (**"Security Program"**) that aligns with industry recognized frameworks; includes security safeguards reasonably designed to protect the confidentiality, integrity, availability, and resilience of Customer Protected Data; is appropriate to the nature, size, and complexity of GitHub's business operations; and complies with the Applicable Data Protection Laws and other specific information security related laws and regulations that are applicable to the geographic regions in which GitHub does business.

a. セキュリティ責任者。 GitHubは、そのセキュリティプログラムの監督および実行と、情報セキュリティ問題に関するガバナンスおよび内部連絡について、その責任を負う上級従業員を指名しています。

b. セキュリティプログラムの変更。 関連する法律および規制によって通知が必要な場合、GitHubはお客様の保護データのセキュリティに悪影響を及ぼすセキュリティプログラムを変更しません。

c. GitHubは標準的なセキュリティ業界の慣例を維持します。これには以下のものが含まれますが、これに限定はされません。

- 脆弱性管理プログラム
- セキュア開発のトレーニング、レビュー、およびコーディングの慣例
- 本番システムの論理および物理アクセス制御
- 外部の技術支援および監査
- セキュリティポリシー、標準、および標準運用手順
- セキュリティおよびプライバシー意識向上トレーニング


#### 1.2 Security Incident Management.
Throughout the duration of the Agreement, and where applicable, GitHub will provide a Security incident management program as follows:

a. セキュリティの可用性とエスカレーション。 GitHubは、お客様と従業員がGitHubセキュリティチームにIssueを発行できるように、24時間365日の体制で、セキュリティ窓口とエスカレーションプロセスを設けます。

b. インシデント対応。 If GitHub becomes aware of a breach of security leading to the accidental or unlawful destruction, loss, alteration, unauthorized disclosure of, or access to Customer Personal Data (each a **"Security Incident"**), GitHub will promptly and without undue delay (1) notify Customer of the Security Incident; (2) investigate the Security Incident and provide Customer with detailed information about the Security Incident; (3) take reasonable steps to mitigate the effects and to minimize any damage resulting from the Security Incident.

c. 通知。 セキュリティインシデントの通知は、GitHubが選ぶどんな手段を使ってでも、1つ以上のお客様の管理者に届きます。 お客様の管理者が通知を監視しておき応答するよう図ることは、全面的にお客様の責任となります。 お客様は、お客様に該当するインシデント通知関連法のもとでの義務に従い、セキュリティインシデントに関係する第三者の通知義務を満たす責任を全面的に負います。

d. 妥当な支援。 GitHubは、適用法または規制のもとで、かかるセキュリティインシデントについて関連監督機関およびデータ主体に通知するという義務をお客様が履行するのを支援するために、商業的に妥当な努力を払います。

#### 1.3 Due Diligence over Subcontractors and Vendors.
GitHub will maintain appropriate due diligence when utilizing subcontractors and vendors. GitHubは、ベンダー評価レポートなど任意の評価結果を、最低3年間保管します。

#### 1.4 Data Center Physical Safeguards.
To the extent GitHub utilizes third party vendors to host production environments, GitHub will select vendors that comply with physical security controls outlined in industry standards and that issue an annual external audit report such as SOC 2 or ISO 27001 certification. 通信、ネットワークデバイス、その他の「データ伝送線」または機器を収めるエリア、キャビネット、ラックへのアクセスは、すべて以下のように制御されます。

a. 1つ以上の入口で、アクセスをバッジリーダーで制御する

b. 出口としてのみ使われるドアには、「一方通行」のドアノブを使用するか、バー状の出口装置を設置する

c. すべてのドアには、ドアアラームを設置する

d. 出口のドアにはビデオ監視機能を付ける

e. カードアクセスおよびビデオシステムはすべて、発電機またはUPSバックアップシステムに接続する

### 2. 情報請求とコンプライアンスレポート

#### 2.1 Requests for Information.
Upon Customer's written request and no more than once annually, GitHub will respond to one request for information to assess security and compliance risk-related information. この応答は、請求の受理から30日以内に書面で行われ、どの請求も必要な説明は保留されます。

#### 2.2 Response Contents.
GitHub will include in its annual response relevant audit reports for production datacenter, IaaS, PaaS or private hosting providers, as deemed relevant by GitHub, in its sole discretion and based on data and services rendered.

#### 2.3 GitHub Security Audit Report.
GitHub will execute external audits to produce a SOC1, type 2, audit report and a SOC2, type 2, audit report. GitHubは監査を実行し続け、本契約の期間を通じて、少なくとも1年に1回、対応するレポートを発行します。

### 3. 規制監査との協力
Should Customer realize a regulatory audit or an audit in response to a Supervisory Authority that requires participation from GitHub, GitHub will fully cooperate with related requests by providing access to relevant knowledgeable personnel, documentation, and application software. お客様は、かかる規制または監督機関の監査について、以下の責任を負います。

a. お客様は必ず独立第三者 (つまり規制者または規制者の代理) を使用し、お客様に関係しない結果とデータにはお客様のアクセスを制限します。

b. かかる監査の通知は、書面にて、適切なタイミングでGitHubに提供される必要があります。規制者の通知は保留され、適切なスタッフが支援に回れるようになります。 規制者が監査または捜査のことを事前にお客様に通知できなかった場合、GitHubは規制者が定める期限で応答します。

c. 第三者の監査人は、発見結果と、規制者が許可する場合の推奨策をGitHubに開示する必要があります。

d. 規制監査の場合、アクセスが許可されるのは規制者の営業時間内 (太平洋時間) だけです。

e. 法律の許可する範囲において、お客様はGitHubのかかる監査を通じて収集された、性質上機密であるべき情報の機密を保持する必要があります。
