---
title: GitHub企業向け利用規約
redirect_from:
  - /articles/github-corporate-terms-of-service
versions:
  free-pro-team: '*'
---

貴社のビジネスにおけるニーズを満たすために GitHub をお選びいただき、ありがとうございます。 本契約を注意深くお読みください。GitHub がお客様と書面による合意を別途行わない限り、本製品 (以下に定義) の利用に対しては、この契約が適用されます。 「同意する」またはそれに類似するボタンをクリックするか、本製品を利用することにより、お客様は本契約の規約および条件の全てに同意することになります。 お客様が、企業またはその他の法人を代表して契約を締結しようとする場合、お客様は、本契約を締結するためにその企業またはその他の法人に義務を負担させる法的権限を持つことを表明するものとします。

### GitHub企業向け利用規約
Version Effective Date: July 20, 2020

本契約は、以下に詳述する GitHub の提供品 (併せて「**製品**」) に対して適用されます。
- 「サービス」、
- すべての「ベータプレビュー」、
- 関連するすべての「サポート」、
- 関連するすべての「プロフェッショナルサービス」。

### A. 定義

「**関係会社**」とは、直接的または間接的に支配している、支配されている、あるいは当事者と共通の支配下にある、あらゆる法人を意味します。本定義において「支配」とは、所有権のうち 50% 超を持つか、当該法人の経営管理を指揮する権限を有することを意味します。

「**契約**」とは、集合的に、本書に含まれるか、または本書で参照されるすべての規約、条件、通知、並びに、当社が適宜「サービス」に掲載する場合があるその他すべての操作規則、ポリシーおよび手順を指します。 GitHub のサイトポリシーは、[https://docs.github.com/categories/site-policy](/categories/site-policy) でご確認いただけます。

「**全ユーザ**」とは、「サービス」を利用する、「お客様」の「ユーザ」および「外部ユーザ」を総称的に意味します。

「**アメリカ大陸**」とは、アメリカ合衆国、カナダ、メキシコ、中南米諸国、およびカリブ海諸国を意味します。

「**ベータプレビュー**」とは、アルファ、ベータ、プレビュー、アーリーアクセス、評価版、またはその他同様の意味を持つ言葉や表現により称されるソフトウェア、サービス、または機能を意味します。

「**機密情報**」とは、書面、口頭、その他の手段により機密として指定されたか、あるいは開示側の「当事者」にとって機密であることを受領側の 「当事者」 が知っているまたは開示に関する状況および情報の性質により、機密であることを合理的に知っていると判断される、いずれかの「当事者」 により、他の当事者に開示された、あらゆる非公開情報を意味します。 疑義を避けるため、お客様の「プライベートリポジトリ」に保存されたお客様の「コンテンツ」を除き、「サービス」に投稿された「コンテンツ」は「機密情報」と見なされないものとします。 「機密情報」には、以下のいずれの情報も含まれません。(i) 受領側当事者の過失によらず、公知であったもの、あるいは公知となったもの、(ii) 開示する権利を有する開示側当事者以外の情報源から、機密または所有権の制約を受けることなく、受領側「当事者」が正当に知っていたか正当に知るようになったもの、(iii) 開示側「当事者」に正式に委託を受けた職員により署名された書面により、制約を受けることなく開示することについて、かかる開示側「当事者」により承認されたもの、(iv) 相手方「当事者」の「機密情報」を入手または利用することなく、受領側「当事者」が独自に開発したもの、(v) 「サービス」内、かつお客様の「プライベートリポジトリ」以外に保存または投稿されるまたはされているもの。

「**コンテンツ**」とは、機能、表示、その他 「サービス」を通じて利用できる、コード、テキスト、データ、記事、画像、パッケージ、写真、図表、ソフトウェア、アプリケーション、設計、機能、その他それらに制約されないあらゆる素材を意味します。

「**企業アカウント**」とは、法人を代表して「ユーザ」により作成されたアカウントを意味します。

「**お客様**」とは、「同意する」またはそれに類似するボタンをクリックするか、「製品」にアクセスすることにより、GitHub と本契約を締結した企業または団体を意味します。

「**お客様のコンテンツ**」とは、お客様が作成、所有するか、お客様が権利を所有する 「コンテンツ」 を意味します。

「**ドキュメンテーション**」とは、GitHub が提供するか、お客様に利用できるようにする、「製品」に関連したあらゆるマニュアル、ドキュメンテーション、その他補助資料を意味します。

「**発効日**」とは、お客様が (i) 本契約の規約および条件に「同意する」をクリックした日か、(ii) 「製品」を最初に注文した日のうち、いずれか早いほうの日を意味します。

「**外部ユーザ**」とは、「サービス」にアクセスまたは「サービス」を利用する、「お客様」以外の「ユーザ」である個人を意味します。

「**フィードバック**」とは、GitHub の製品またはサービスについてのアイデア、ノウハウ、アルゴリズム、コードへのコントリビューション、提案、機能拡張リクエスト、その他あらゆるフィードバックを意味します。

「**料金**」とは、(i) 該当する「契約期間」中に「製品」 を利用するため、または (ii) 「プロフェッショナルサービス」を受けるために、GitHub がお客様に支払う必要のある費用を意味します。かかる費用は「注文書」または SOW に記載されています。

「**フォーク**」とは、1 つのリポジトリの「コンテンツ」を別のリポジトリにコピーすることを意味します。

「**GitHub**」とは、GitHub, Inc、その「関係会社」および「担当者」を意味します。

「**GitHub のコンテンツ**」とは、GitHub が作成、所有、またはその権利を所有する「コンテンツ」を意味します。

「**コンピュータアカウント**」とは、「コンピュータアカウント」のために該当する利用規約を受け入れ、有効なメールアドレスを提供し、その動作について責任を負う人間個人により登録されたアカウントを意味します。 「コンピュータアカウント」は、自動化されたタスクを実行するためにのみ用いられます。 「コンピュータアカウント」の動作は、複数の「ユーザ」が指示できますが、コンピュータの動作について究極的な責任を負うのは、アカウントの所有者です。

「**注文書**」とは、「当事者」が「製品」を注文するために用いることができる、書面または電子的なドキュメント (見積書を含む) を意味します。

「**Organization**」とは、複数の「ユーザ」が、一度に多くのプロジェクトをまたいでコラボレートするために、 単一のエンティティあるいは 1 つまたは複数の「ユーザ」に関連付けることができる共有のワークスペースを意味します。 「ユーザ」は複数の「Organization」のメンバーになることができます。

「**プライベートリポジトリ**」とは、「ユーザ」が「コンテンツ」へのアクセスを制御できるリポジトリを意味します。

「**プロフェッショナルサービス**」とは、相互に締結した「SOW」に従い、GitHub がお客様に対して提供するトレーニング、コンサルティング、または実装サービスを意味します。 「プロフェッショナルサービス」には、「サポート」は含まれません。

「**プロフェッショナルサービスクレジット**」とは、「プロフェッショナルサービス」 (旅費および宿泊費除く) を購入するための前払い方式による支払いを意味し、お客様は、これを「プロフェッショナルサービス」のために (「注文書」に特に明記していない場合) 12 か月間利用できます。 (「注文書」に特に明記していない場合) 購入日から 12 か月経過した月末までに利用されていない「プロフェッショナルサービスクレジット」は自動的に取り消しとなり、返金できません。

「**パブリックリポジトリ**」とは、「コンテンツ」が「全ユーザ」に表示できるリポジトリを意味します。

「**担当者**」とは、「当事者」の従業員、役員、代理人、独立契約者、コンサルタント、および財務顧問を意味します。

「**スクレイピング**」とは、ボットやウェブクローラーなどの自動的な処理により、「サービス」からデータを抽出することを意味します。GitHub の API を通して情報を収集することはこれに含まれません。

「**サービス**」とは、GitHub のホストしたサービスおよび該当するあらゆる「ドキュメンテーション」を意味します。

「**SOW**」とは、GitHub が実施する「プロフェッショナルサービス」の作業詳細、それに関するあらゆる「料金」、およびそれに関する各「当事者」の義務について、相互に締結した声明書を意味します。

「**プランライセンス**」とは、お客様を代表して「サービス」をインストール、操作、アクセス、および利用するために各「ユーザ」に割り当てられるライセンスを意味します。 お客様は、自らの Organization に属する「ユーザ」ごとに「プラン・ライセンス」を 1 つのみ割り当てることができます。 明確にするために記すと、お客様が「プラン・ライセンス」を「ユーザ」にいったん割り当ててから、お客様が「プラン・ライセンス」を分けて、1 人の「ユーザ」がある Organization で「プラン・ライセンス」を利用しながら、別の「ユーザ」が別の Organization で同一の「プラン・ライセンス」を利用できるようにすることは認められません。

「**サポート**」とは、GitHub が提供する場合がある「サービス」への技術サポートを意味します。

「**ユーザ**」とは、「お客様」を代表して、(a) 「サービス」にアクセスまたはそれを利用する、(b) 「お客様」のアカウントの一部にアクセスまたはそれを利用する、あるいは (c) 機能を実行するにあたり「お客様」のアカウントの利用を命令する、個人または「コンピュータアカウント」を意味します。 「ユーザ」の数は、「お客様」が購入した「プランライセンス」の数を超過してはなりません。

「**ユーザ生成コンテンツ**」とは、第三者または「外部ユーザ」が作成または所有する「コンテンツ」を意味します。

### B. アカウント利用規約

#### 1. アカウントの管理.
  * _ユーザ。_お客様は、「ユーザ」が各自のアカウントおよびアカウント内の「コンテンツ」に対する最終的な管理権限を保持することに同意するものとします。 「ユーザ」の「サービス」利用については、本セクション 3 に基づく「ユーザ」のアクティビティに関するものを除き、[GitHub の「標準利用規約」](/articles/github-terms-of-service)が適用されます。

  * _(ii) Organization。_お客様は、本セクション B に従い、お客様を代表して作成されたあらゆる Organization、およびその Organization 内のリポジトリに投稿された「ユーザ生成コンテンツ」について、最終的な管理権限を保持します。本セクション B は、お客様の Organization による利用について規定するものです。

#### 2. アカウントの要件
お客様がアカウントを作成するには、以下を遵守する必要があります:

* お客様は、13歳未満が利用するためのアカウントを作成してはなりません。 GitHub が 13歳未満の「ユーザ」を知った場合には、その「ユーザ」のアカウントを直ちに削除します。 お客様またはその「ユーザ」が米国外に居住する場合には、その国に適用される最低年齢が 13 歳以上である場合があります。かかる場合、お客様はその国の法律に従う責任を負います。

*   「ユーザ」は、ログインを複数人で共有することはできません。

- お客様が以下に該当する場合、「製品」を利用することはできません。 (a) 米国またはその他の該当する管轄区域の輸出規制または制裁に関する法律に違反する場合、(b) 米国財務省外国資産管理局 (OFAC) が管理する包括的制裁の対象となる国または地域にの居住者であるか、常時滞在している場合、(c) お客様が、[特定国籍 (SDN)](https://www.treasury.gov/resource-center/sanctions/SDN-List/Pages/default.aspx)、同様の制限に服する個人、または取引禁止者であるか、それらのために働いている場合。 詳しくは「[輸出規制方針](/articles/github-and-export-controls)」をご覧ください。

#### 3. アカウントのセキュリティ
お客様は、以下に対して責任を負います。(i) お客様の「企業アカウント」における、投稿された「コンテンツ」およびアクティビティの全て、(ii) お客様のアカウントのログイン認証情報に関するセキュリティの維持、(iii) お客様のアカウントを通じた、「サービス」のあらゆる不正利用や不正アクセスを認識した際には、[速やかにGitHub に通知](https://github.com/contact)すること。  GitHub は、お客様が本セクション B に従わなかったことにより生ずるいかなる損失または損害にも責任を負いません。

#### 4. 第三者の規約
場合によっては、お客様による GitHub の利用について、第三者による規約が適用されることがあります。 たとえば、お客様が独自の条項またはライセンス契約を持つ Organization の成員である場合、お客様が「サービス」に統合するアプリケーションをダウンロードしている場合、お客様が他のサービスに認証するために「サービス」を利用している場合などです。 本契約は、お客様と GitHub との完全な合意を示していますが、お客様と第三者との関係については第三者の規約が適用されます。

#### 5. アメリカ合衆国の祝日 米国連邦政府の条項
If Customer is a U.S. government entity or otherwise accessing or using the Service in a government capacity, the [U.S. Federal Government Amendment](/articles/amendment-to-github-terms-of-service-applicable-to-us-federal-government-users) applies, and Customer agrees to its provisions.

#### 6. Enterprise Cloud Service Level Agreement
GitHub’s quarterly uptime commitment for GitHub Enterprise Cloud is provided in the [Enterprise Service Level Agreement](/github/site-policy/github-enterprise-service-level-agreement). If Customer signed up for GitHub Enterprise Cloud, then Customer will be entitled to a service credit if GitHub does not meet its service level.

### C. 法の遵守、利用規程、プライバシー

#### 1. 法令・規定の遵守
お客様が「製品」を利用する際には、著作権法、商標法、輸出規制法、または管轄における規制を含むいかなる適用法にも違反してはなりません。

#### 2. 利用規定
お客様が「製品」を利用する際には、[「GitHub利用規程」](/articles/github-acceptable-use-policies)および[「GitHubコミュニティガイドライン」](/articles/github-community-guidelines)に従う必要があります。 お客様は、いかなる管轄区域内でも、違法、わいせつ、不快、または詐欺的なコンテンツまたは活動 (損害を与えたりそう標榜したりする、ネットワークまたはシステムの完全性またはセキュリティを妨害または侵害する、フィルタを回避する、迷惑・虐待的・虚偽的なメッセージ、ウイルスまたは有害なコードを送信する、あるいは第三者の権利を侵害するなど) の目的で「サービス」を使用してはなりません。

#### 3. プライバシー
The [GitHub Privacy Statement](/articles/github-privacy-statement) and the [GitHub Data Protection Addendum](/github/site-policy/github-data-protection-addendum) provide detailed notice of GitHub's privacy and data use practices as well as GitHub's processing and security obligations with respect to Customer Personal Data. 「サービス」からデータを収集する個人、団体、またはサービスは、特にユーザの個人情報 (「GitHub のプライバシーについての声明」に規定) の収集に関して、GitHubの プライバシーについての声明に従う必要があります。 お客様がGitHubから「ユーザ個人情報」を収集した場合、お客様は「外部ユーザ」が承認した目的にのみその個人情報を使用するものとします。 お客様は、かかる個人情報を合理的に保護するものとし、GitHubはGitHubまたは「外部ユーザ」からの苦情、削除要請、および連絡拒否の要請に速やかに対応するものとします。

### D. コンテンツの責任、所有権、ライセンス権

#### 1. 「ユーザ生成コンテンツ」に対する責任
「サービス」の利用中に、お客様は「ユーザ生成コンテンツ」を作成またはアップロードすることができます。 投稿、アップロード、リンク、その他の方法でお客様が「サービス」を介して利用できるようにした「ユーザ生成コンテンツ」については、その「ユーザ生成コンテンツ」の形式にかかわらず、お客様が全責任を負うものとします。 GitHubは、「ユーザ生成コンテンツ」のいかなる公開表示または悪用に対しても責任を負いません。

#### 2. コンテンツの所有権、投稿する権利、ライセンスの付与
お客様が作成または所有する「お客様のコンテンツ」の所有権は、お客様が保持します。 お客様は、 (a)「お客様のコンテンツ」に責任を負うこと、 (b) お客様が投稿する権利を有する「お客様のコンテンツ」(サードパーティまたはユーザーが生成したコンテンツを含む) に限って送信すること、(c) お客様が投稿する「お客様のコンテンツ」に関サードパーティのライセンスに完全に従うことに同意するものとします。 お客様は、セクション D.3 から D.6 で規定されている権利を、無料で、かつ同セクションに記された目的のために付与します。これは、お客様が「お客様のコンテンツ」を GitHub サーバから削除するまで続きますが、お客様が公に投稿し「外部ユーザ」がフォークしたコンテンツは例外となり、その場合は「お客様のコンテンツ」のすべてのフォークが GitHub サーバから削除されるまで続きます。 お客様が、「サービス」を実行するために必要な権限をGitHubに付与するライセンスをあらかじめ伴うような「お客様のコンテンツ」をアップロードする場合、追加のライセンスは必要ありません。

#### 3. 当社へのライセンス許可
お客様は、「お客様のコンテンツ」を保存、解析、表示し、「サービス」の提供に必要な限りにおいて付随的な複製を作成する権利をGitHubに付与します。 これには、「お客様のコンテンツ」をGitHubのデータベースにコピーし、バックアップを作成する権利、お客様およびお客様が閲覧者として選択した相手に「お客様のコンテンツ」を表示する権利、「お客様のコンテンツ」を解析して検索インデックスを作成するなどの形でGitHubのサーバ上で分析する権利、お客様がコンテンツの共有相手として選択した外部ユーザーと「お客様のコンテンツ」を共有する権利、および音楽や動画のような場合に「お客様のコンテンツ」を実演する権利が含まれます。 これらの権利は、パブリックリポジトリとプライベートリポジトリの両方に適用されます。 このライセンスは、「お客様のコンテンツ」を販売またはその他の方法で配布する、あるいは「サービス」以外で使用する権利をGitHubに付与するものではありません。 お客様は、帰属先を明示せず、また「サービス」の提供に必要な限りにおいて「お客様のコンテンツ」を合理的に適応させる目的で、「お客様のコンテンツ」に必要な権利をGitHubに付与します。

#### 4. 外部ユーザへのライセンス付与
Issue、コメント、外部ユーザのリポジトリへのコントリビューションなど、お客様が公に投稿するコンテンツは、他のユーザーが閲覧することができます。 リポジトリを公開表示に設定することで、お客様は外部ユーザがお客様のリポジトリを閲覧しフォークすることを許可するものとします。 お客様がそのページおよびリポジトリを一般に公開表示に設定する場合、お客様は「サービス」を通じて「お客様のコンテンツ」を使用、表示、および実演し、またGitHub が提供する機能を通じて許可される限りにおいて (フォークなど) のみ「サービス」上でお客様のコンテンツを複製する、非独占的かつ世界的ライセンスを外部ユーザーに付与します。 お客様がライセンスを採用した場合、他の権利を付与することができます。 お客様が作成または所有していない「お客様のコンテンツ」をアップロードする場合には、アップロードする「お客様のコンテンツ」が、これらの権限を外部ユーザーに付与する条項に基づいて必ずライセンスされるよう図る責任をお客様は負います。

#### 5. リポジトリのライセンス下でのコントリビューション
お客様がライセンスの通知を含むリポジトリに対してコントリビューションを行う際、お客様は必ず同じ条件のもとでそのコントリビューションをライセンスし、それらの条件下でかかるコントリビューションをライセンスする権利を有することに同意するものとします。 お客様が、コントリビューターライセンス契約など、異なる条件のもとでコントリビューションのライセンスを別途締結している場合は、その契約が優先されます。

#### 6. 人格権
お客様は、完全性と帰属の権利も含めて、「サービス」の任意の部分に対してアップロード、公開、またはサブミットする「お客様のコンテンツ」について、すべての人格権を保持します。 ただしお客様は、GitHubがセクション Dで付与された権利を合理的に行使できるようにする目的に限り、これらの権利を放棄し、GitHubに対してこれらの権利を主張しないことに同意するものとしますが、その目的以外ではこの限りではありません。

### E. プライベートリポジトリ

#### 1. 管理
客様は、招待、OrganizationおよびTeamの管理制御、アクセスなど、プライベートリポジトリへのアクセスを管理する責任を負います。

#### 2. 機密保持
GitHubは、お客様のプライベートリポジトリにある「お客様のコンテンツ」をお客様の機密情報と見なします。 GitHubは、プライベートリポジトリの「お客様のコンテンツ」を、セクション Pに従って保護し、厳密に機密扱いします。

#### 3. アクセス
GitHub personnel may only access Customer’s Private Repositories (i) with Customer’s consent and knowledge, for support reasons or (ii) when access is required for security reasons.  お客様は、プライベートリポジトリへのアクセスを追加することもできます。 たとえば、プライベートリポジトリにある「お客様のコンテンツ」への追加の権利を必要とするGitHubの各種サービスまたは機能を有効にするなどが考えられます。 これらの権利はサービスまたは機能によって異なりますが、GitHubは引き続き、お客様のプライベートリポジトリにある「お客様のコンテンツ」をお客様の機密情報として扱います。 これらのサービスが、「サービス」の提供に必要な以上の権利を追加で必要とする場合、GitHubはその件について説明を行います。

#### 4. 除外
プライベートリポジトリのコンテンツが法律または本契約に違反していると考えられる理由がある場合、GitHubはそのコンテンツにアクセスし、レビューして削除する権利を有します。 また、[法律により強制された](/github/site-policy/github-privacy-statement#for-legal-disclosure)場合、GitHubは「プライベートリポジトリ」の「コンテンツ」を開示する場合があります。 法律に基づく要件で別段拘束されていない限り、またはセキュリティ上の脅威などセキュリティに対するリスクに対応する目的で、GitHubはかかる行動について通知します。

### F. 知的財産に関する通知

#### 1. コンテンツに対する GitHub の権利
「サービス」の見た目は、copyright © GitHub, Inc. All rights reserved で保護されています。 お客様は、GitHubからの書面による許可なく、HTML/CSS、Javascript、またはビジュアルデザイン要素またはコンセプトのいかなる部分も複製、コピー、再利用することはできません。

#### 2. GitHub のトレードマークとロゴ
お客様がGitHubのトレードマークを使用したい場合は、GitHubの[ロゴページ](https://github.com/logos)の内容も含めて、トレードマークに関するGitHubのすべてのガイドラインに従う必要があります。

#### 3. GitHub ライセンスポリシー
本「契約」は、[Creative Commons Zero license](https://creativecommons.org/publicdomain/zero/1.0/) の元でライセンス付与されています。 詳細は、[サイトポリシーリポジトリ](https://github.com/github/site-policy#license)を参照してください。

#### 4. 著作権侵害と DMCA ポリシー
お客様が著作権所有者であり、「サービス」上のコンテンツがお客様の著作権を侵害していると考えられる場合、お客様は[GitHubのデジタルミレニアム著作権法 (DMCA) ポリシー](/articles/dmca-takedown-policy/)に従って、[DMCAの様式](https://github.com/contact/dmca)を用いるか、またはcopyright@github.com に電子メールを送信して、GitHubに通知できます。

#### 5. 知的財産権の留保
両「当事者」間の関係において、GitHub は「製品」に対するおよびそれに付随する、すべての知的財産権を含め、すべての権利、権原、および利益を所有しています。 本契約によりお客様に対して明示的に付与されていない、「製品」に対するおよびそれに付随するすべての権利を GitHub は留保します。

### G. GitHub追加製品の利用規約
「サービス」の一部機能については、[GitHub 追加製品の利用規約](/github/site-policy/github-additional-product-terms)に記載されている規約も適用される場合があります。 これらの機能にアクセスまたはこれらを利用することにより、お客様は GitHub 追加製品の利用規約にも同意することになります。

### H. プラン・ライセンス
「プランライセンス」は、「ユーザ」ごとに付与され、複数の「ユーザ」が同一の「プランライセンス」を利用することはできません。 お客様は、「プランライセンス」を最後に再割り当てしてから 90 日間が経過しなければ、新しい「ユーザ」に同一の「プランライセンス」を再割り当てすることはできません。ただし、再割り当てが以下の理由による場合を除きます。(i) ハードウェアの永久的な故障または喪失、(ii) 「ユーザ」の雇用または契約の終了、または (iii) 「ユーザ」の欠勤を代替するための、「プランライセンス」の一時的な再割り当て。 お客様がある「ユーザ」から別の「ユーザ」に「プランライセンス」を割り当てる際は、前の「ユーザ」の「プランライセンス」 およびお客様の「Organization」へのアクセスをお客様がブロックする必要があります。

### I. 関係会社
関係会社による「製品」へのアクセスおよび利用について、お客様が完全に責任を負う限りにおいて、お客様の関係会社は、本契約に従い、「製品」を利用することができます。

### J. 支払い

#### 1. 価格、料金

**支払い条件** 料金については、[github.com/pricing](https://github.com/pricing) に掲載されているものが適用されます (ただし、関係者による協議を行い、「注文書」に記載されている場合を除きます)。 お客様は、減額や相殺などに類することを行わず、アメリカ合衆国ドルにより「料金」の全額を前払いで支払うことに同意します。 Dollars. お客様は、GitHub による請求の日付から 30 日以内に「料金」を支払う必要があります。 本「契約」に基づいて支払われる金額は、本「契約」に別段の定めがある場合を除き、返金できません。 お客様が定められた期限に「料金」を支払わなかった場合、普通法または衡平法に基づく法的措置を取ることに加え、GitHub は次の権利を留保します。(i) 過去の未払い金に対して毎月 1.0% か、法律により許容される最高額の金利のうち、いずれか低い額の金利を課し、かつ回収に要するあらゆる費用を課すこと、および (ii) 該当する「注文書」または SOW を解約すること。 本契約に関して課されたか、負うようになったあらゆる税金、料金、関税、および政府による査定 (GitHub の純利益に基づく税金を除く) について、お客様は全責任を負います。

**従量制支払い:** 「サービス」の一部の機能は、使用量に基づいて請求されます。 かかる「サービス」機能は、限られた使用量および期間であれば、追加料金なしでご利用のプランで使用できる場合があります。 ご利用のプランに含まれる数量を超えて有料の「サービス」機能を購入することを選択した場合、お客様は前月の実際の使用量に基づいてかかる「サービス」機能の料金を支払います。 かかる購入に対する毎月の支払いは、後払いで定期的に請求されます。ただし、請求書払いのお客様については、有料の「サービス」機能は前払いとなります。 詳しくは、[GitHub 追加製品の利用規約](/github/site-policy/github-additional-product-terms)を参照してください。

#### 2. プランライセンスの追加購入
「サービス」または GitHub の営業チームを通じて要請することで、お客様は本契約の下、「プランライセンス」を追加で取得できます。 お客様が追加の「プランライセンス」を購入する場合、お客様は、該当する「プラン契約期間」の残高に応じた、その時点で最新の、適用される「料金」を支払う必要があります。 「注文書」に特に記載されている場合を除き、お客様が「プランライセンス」を 次の「プラン契約期間」まで更新した際、GitHub は毎年 1 回、すべての「プランライセンス」に対する請求を同時に行います。

#### 3. プロフェッショナルサービスクレジット
お客様が「プロフェッショナルサービス」への支払いに「プロフェッショナルサービスクレジット」を利用する場合、お客様による「SOW」の受領をもって、お客様の「プロフェッショナルサービスクレジット」残高から、適切な「プロフェッショナルサービスクレジット」が差し引かれるものとします。 お客様は、「プロフェッショナルサービス」について GitHub に発行する発注書に、「SOW」に定められた価格を確実に反映する責任を負います。 「SOW」に記載された価格と、お客様の発注書に記載された価格に相違がある場合、「SOW」の価格が優先するものとします。 両「当事者」は、「プロフェッショナルサービスクレジット」による「SOW」の支払いには、それを有効かつ強制力を持つものとするために、いずれの「当事者」による署名も不要であることに同意します。 「プロフェッショナルサービスクレジット」は、すべて「注文書」に記載された期間内に使用する必要があります。期間内に使用されなかった場合は自動的に取り消され、返金できません。 お客様は、「プロフェッショナルサービスクレジット」を旅費および宿泊費に充てることはできず、旅費および宿泊費は別途請求されます。

#### 4. 承認
お客様は、登録されたクレジットカード、PayPal アカウント、またはその他の承認された支払い方法に請求する許可を GitHub に対して与えるものとします。

### K. 契約期間、解約、一時停止

#### 1. 契約期間
本契約は、「発効日」から開始し、セクション K の規定に従って「当事者」により解約されるまで有効であり続けるものとします。

#### 2. 契約解除、アカウントのキャンセル
いずれの「当事者」も、少なくとも 30 日前に書面により通知することで、「注文書」(該当する場合) または本契約を理由なく解約できます。 お客様が「注文書」または本契約を解約することを選択した場合、お客様は、画面上部のグローバルナビゲーションバーにある「設定」に進み、GitHub でアカウント適切にキャンセルする責任を負います。 GitHub は、メールや電話での要請に対応してアカウントをキャンセルすることはできません。

#### 3. 重大な契約違反による解約
いずれの「当事者」も、相手方「当事者」が本契約に基づく義務に対して重大な違反を犯し、通知を受領してから 30 日以内に違反を是正できなかった場合、通知により本契約を直ちに解約できます。  GitHub は、お客様のアカウントが 90 日を超えて一時停止している場合、本契約を解約できます。

#### 4. 解約の効果
- _「注文書」。_本契約を解約した場合、お客様は「注文書」(該当する場合) を追加で締結することはできないものとします。ただし、残りの有効な「注文書」に対しては、本契約は引き続き有効になるものとします。 「注文書」の解約または失効の際、その「注文書」について、(i) 「契約期間」は直ちに終了するものとし、(ii) 「注文書」に記載のあらゆる「プランライセンス」は自動的に解約となり、お客様は「サービス」を利用する権利を喪失するものとし、(iii) 解約の前に、支払うべき「料金」があった場合、お客様はかかる「料金」を直ちに支払う必要があるものとし、(iv) 各「当事者」は、「サービス」により許容される範囲において、相手方に属するすべての「機密情報」を直ちに返却 (相手方当事者が要請する場合は破棄) するものとします。 上記にかかわらず、解約、一時停止、またはダウングレードから 90 日以内にお客様から要請を受けた場合、GitHub はお客様に対し、合法的で他者の権利を侵害していないアカウントの「コンテンツ」について、そのコピーを提供するための合理的な努力を払います。

- GitHub は、法的義務の遵守、紛争解決および当社の契約を実行するためにお客様の情報を保持かつ利用します。ただし、法的に要求されていない場合は、解約また契約失効から 90 日以内に、当社はお客様のすべてのプロフィールとリポジトリの「コンテンツ」を削除します (ただし、一部の情報は暗号化されたバックアップに残る場合があります)。 お客様のアカウントがキャンセルされると、この情報は復元できません。

- お客様が「外部ユーザ」のリポジトリにコントリビューションした「コンテンツ」や、「外部ユーザ」がフォークした「コンテンツ」については、GitHub は削除いたしません。

#### 5. 一時停止
GitHubは、本契約への違反があった場合、または「サービス」の完全性、操作性、およびセキュリティを保護する目的で、いつでも「サービス」の全部または一部へのアクセスを即時、事前予告の有無を問わず、一時停止する権利を有します。 かかる通知が法律または法的手続きによって禁止されている、または「サービス」または第三者への差し迫った損害の防止に妨げとなる場合を除き、GitHub は、通常、かかる一時停止の時点またその前に、バナーまたは email で通知します。 GitHubは、「サービス」の完全性、操作性、およびセキュリティを保全する必要に応じ、その裁量により、かつ誠意をもって任意の一時停止を調整します。

#### 6. 存続
本質的に解約後も存続すべき本「契約」のすべての条項は、解約後も存続します。これには、所有権の条項、保証の免責、補償、責任の制限が含まれますがこれらに限定されません。

### L. GitHub との通信手段

#### 1. 電子通信の必要性
契約上の目的で、お客様は (1) 提出したメールアドレスまたは「サービス」を介して、電子形式で通信を受信すること、並びに (2) GitHub がお客様に電子的に提供するすべての「利用規約」、契約、通知、開示、およびその他の通信が、かかる通信が紙面である場合に満たす法的要件を満たすことに同意するものとします。 本セクションは、お客様の放棄不能な権利には影響しません。

#### 2. 書面で行う必要がある GitHub への法的通知
電子メールまたは GitHub サポートのメッセージングシステムを介して行われる通信は、契約または法規制上 GitHub への通知が必要な状況において、GitHub への法的通知とはなりません。 GitHub への法的通知は書面で行い、[GitHub の法的代理人に送達](/articles/guidelines-for-legal-requests-of-user-data/#submitting-requests)される必要があります。

### M. 限定保証、免責事項

_「一般保証」_。 各「当事者」は、相手方に対し、本契約を締結する法的権能および権限を持つこと、ならびに本契約、各「注文書」、「SOW」が、かかる「当事者」を本契約の規約および条件に拘束するために必要なあらゆる権限を有する、かかる「当事者」の従業員または代理人により締結されることを表明し、保証します。

_「プロフェッショナルサービス保証」。_SOW に別段の定めがない限り、GitHubは、お客様に対し、本契約に基づいて実施される「プロフェッショナルサービス」が、適切な有資格者により、専門的かつ職業的な方法で実施されることを保証します。 本保証の違反に対する GitHub による唯一の義務、およびお客様への唯一の救済手段は、GitHub が選択する以下のいずれかによるものとし、GitHub はその費用を負担します。(i) 本保証の水準を満たさなかったあらゆる「プロフェッショナルサービス」を、速やかに再実施する、あるいは (ii) 違反を是正することができない場合、「SOW」を解約し、未使用の前払い「料金」を返金する。

_「サービスの免責事項」。_GitHub は、「サービス」を**「現状のまま」****「提供可能な状態で」**、いかなる保証もなしに提供します。 GitHub は、「サービス」に関して、商品性、特定目的への適合性、権原、セキュリティ、正確性、および非侵害性を含むがこれに限定されない一切の保証を明示的に否認します。 GitHub は、「サービス」がお客様の要件を満たすこと、「サービス」が中断されないこと、適時に提供されること、安全であること、またはエラーがないこと、「サービス」を通じて提供される情報が正確、信頼できる、または的確であること、あらゆる欠陥やエラーが修正されること、「サービス」が特定の時間や場所で利用できること、ならびに「サービス」にウイルスやその他の有害なコンポーネントが含まれていないことを保証しません。 GitHub は、お客様がファイル、情報、「コンテンツ」 、その他「サービス」から取得した資料のダウンロードおよび／または利用により生じるいかなる損失のリスクについても責任を負いません。

_「ベータプレビューの免責事項」。_お客様は、自らの裁量により「ベータプレビュー」の利用を選択できます。 「ベータプレビュー」はサポートを受けることができない場合があり、その内容は随時予告なく変更される場合があります。 「ベータプレビュー」は、「サービス」ほど信頼性が高くない場合があります。または利用できない可能性もあります。 「ベータプレビュー」は、「サービス」にこれまでも現在も適用されているものと同等のセキュリティ対策および監査の対象ではありません。 GitHub は、「ベータプレビュー」に起因または関連する責任を負わないものとします。 **お客様は、自らの責任において「ベータプレビュー」を利用するものとします。**

### N. 責任の制限
**_「間接的損害」。_原因の如何に関わらず、かかる義務が契約、保証、不法行為 (過失を含む)、厳格責任などに基づく請求から生じるあらゆる請求に起因するか、また当事者がかかる損害の可能性について当事者が知らされていたかを問わず、間接的、特別的、偶発的、懲罰的または派生的損害 (利益、収益またはデータの損失を含む)、または本契約に起因または関連して発生する代替製品の取得費用について、いずれの当事者も、相手方当事者またはあらゆる第三者に対して、準拠法によって許される最大限の範囲で、いかなる場合においても責任を負わないものとします。**

**_「総責任額の制限」。_ あらゆる訴因およびあらゆる責任に関する理論により、本契約の下におけるいずれの当事者が負う総責任額は、いかなる場合も、準拠法によって許される最大限の範囲で、かかる責任を生じさせるに至った請求の前の 12 か月間にお客様が GitHub に対して実際に支払った「料金」を超えないものとします。 無料で提供される製品およびサービス (「製品」の利用を含む) については、GitHub の責任は 5,000.00 USD までの直接損害賠償に限定されます。 「ベータプレビュー」については、GitHub の責任は 500.00 USD までの直接損害賠償に限定されます。**

**_「除外事項」。_ 本セクション N に定める除外および制限は、以下に起因する責任については適用されないものとします。(1) 「当事者」による、セクション P に記載の守秘義務違反。 ((「GitHub のコンテンツ」以外の) 「コンテンツ」 に関するあらゆる責任を除きます。これについては、上記の除外および制限が適用されます。) (2) 「当事者」による、セクション O に記載の防御義務。**

### O. 訴訟に対する防御、免責

両「当事者」はセクション O に定める通り、またその範囲において、第三者からの訴訟に対してお互いに防御し、あらゆる不利な最終判決または示談の合意により生じた金額を支払うものとします。ただし、防御する「当事者」が、訴訟について書面で速やかに通知を受け、防御および示談を行う権利がある場合に限ります。 防御される「当事者」は、防御する「当事者」に対し、要請されたあらゆる支援、情報、および権限を提供する必要があります。 防御する「当事者」は、支援の提供にかかった合理的な費用負担について相手方「当事者」に払い戻すものとし、相手方「当事者」の書面による同意なしに、第三者の訴訟に対して示談または告白を行わないものとします。また、この同意について不合理に拒否または遅延しないものとします。 本セクション O は、かかる訴訟に対する両「当事者」の唯一の責任および全責任を記述したものです。

#### 1. GitHub の責任
GitHub は、関係会社以外の第三者による、お客様に対する訴訟について、お客様による「サービス」の許可を受けた利用が、関係会社以外の第三者の著作権、特許、または商標を侵害している、あるいは企業秘密を不正利用しているとする主張する限りにおいて、関係会社以外の第三者によるあらゆる訴訟に対しお客様を防御するものとします。 GitHub がかかるあらゆる訴訟を商業的に合理的な条件で解決できない場合、GitHub の判断により、以下のいずれかを行うことができるものとします。 (a)「サービス」 (該当するもの) を改善、修復、または交換する、または (b) お客様のプランを解約し、前払いされ使用されていないあらゆるプラン料金を返金する。 GitHub は、以下により生じた訴訟について、本セクション O.1 の下に義務を負わないものとします。 (i) 「サービス」の改善、あるいは「サービス」を、本契約 (「ドキュメンテーション」含む) により明示的に許可されている以外の装置、デバイス、ソフトウェア、またはデータを用いた組み合わせ、操作、または利用、(ii) 「サービス」の利用を中止するよう通知された後に、お客様が利用を止めなかった場合、(iii) セクション O.2 に基づくお客様の義務、(iv) GitHub により無料で提供された製品またはサービス (「サービス」の利用を含む)、あるいは (v) 「ベータプレビュー」のアクセスまたは利用。 本セクション O.1 の下に GitHub が負う義務を解釈するにあたり、「サービス」には、GitHub により組み込まれたオープンソースコンポーネントを含みます。

#### 2. お客様の責任
お客様は、関係会社以外の第三者による、以下により生じた訴訟に対し GitHub を防御するものとします。(i) お客様が「サービス」にアップロードした「お客様のコンテンツ」、(ii) お客様による守秘義務の不履行、またはセクション C に対する違反を含む、お客様による本契約に対する違反、あるいは (iii) お客様が「サービス」と共に組み合わせ、操作、または利用する、あらゆるサードパーティーブランドの装置、デバイス、ソフトウェア、システム、またはデータ。

#### 3. 他のユーザとの紛争
お客様と 1 人または複数の「ユーザ」との間で紛争が発生した場合、お客様は、GitHub を、かかる紛争に起因するか、または何らかの形で関係する、既知および未知のあらゆる種類および性質のあらゆる請求、要求、および損害 (実際および結果) から免責することに同意するものとします。

### P. 機密保持
いずれの「当事者」も、本契約で許容されている場合を除き、相手方「当事者」の「機密情報」を用いないものとします。 各「当事者」は、相手方「当事者」の「機密情報」について、その機密を保ち、それを保護するにあたり、少なくとも同様の性質を持つ自らの情報に払うものと同程度の注意を払うこと、いかなる場合においても合理的な程度の注意を払うことに同意します。 各「当事者」は、相手方「当事者」の「機密情報」を、許可なく開示することを防止するため、あらゆる合理的な注意を払うことに同意します。この同意には、かかる「機密情報」を、(i) かかる情報を知る必要がある、(ii) 本セクション P に従うために十分な、適切な合意をした当事者である、および (iii) 本セクション P に記載されている利用および開示の制限について知らされている「担当者」以外に開示しないことが含まれます。各「当事者」は、自らの「担当者」の行為および怠慢について、一切の責任を負います。 上記の義務は、いずれかの「当事者」が、裁判所、行政機関、その他行政体からの命令または要求に従って、相手方「当事者」の「機密情報」を開示することを制限しないものとします。_ただし、_かかる開示を要求された「当事者」は、かかる通知が法律により禁じられている場合を除き、相手方「当事者」がかかる命令または要求に対して意義を唱えられるようにするための合理的な通知を行うことが求められます。 本セクション P に記載されている制限は、本契約の解約または失効後も存続するものとします。

### Q. プロフェッショナルサービス
お客様の「プロフェッショナルサービス」の要請に応じ、GitHub は「プロフェッショナルサービス」に記載されている「SOW」を提供するものとします。 GitHub は、それぞれの「SOW」に記載されている「プロフェッショナルサービス」を実施するものとします。 GitHub は、「プロフェッショナルサービス」が実施される方法および手段を管理するとともに、割り当てる担当者を決定する権利を留保するものとします。 GitHub は、GitHub がその行為および怠慢に対して責任を負うことを条件に、第三者を用いて「プロフェッショナルサービス」を実施できるものとします。 お客様は、ソフトウェア、ツール、仕様、アイデア、概念、発明、プロセス、テクニック、ノウハウを含む、「プロフェッショナルサービス」の実施に関連して使用または開発されたすべての権利、権原、および利益を GitHub が保持することを認め、これに同意するものとします。 「プロフェッショナルサービス」の実施中に、GitHub がお客様に提供する成果物について、お客様が「サービス」と併用する目的に限り、本契約の期間中、お客様に対して非独占的、譲渡不可、世界的規模、使用料無料の期間限定ライセンスを付与するものとします。

### R. 本規約またはサービスの変更
GitHub は、独自の裁量により、いつでも本契約を修正する権利を留保し、かかる修正があった場合には本契約を更新します。 GitHub は、独自の裁量により、いつでも本契約を修正する権利を留保し、かかる修正があった場合には本契約を更新します。 重要でない変更については、お客様が「サービス」を継続して利用することをもって、本契約の改訂に同意したものとみなされます。 お客様は、本契約に対するすべての変更を「[サイトポリシー](https://github.com/github/site-policy)」リポジトリで確認できます。

GitHub は、「アップデート」および新機能の追加により、サービスを変更します。 上記にかかわらず、GitHubは通知の有無にかかわらず、「サービス」(またはその一部) をいつでも変更する、あるいは一時的または恒久的に停止する権利を留保するものとします。

### S. サポート
GitHub は、週末および米国の休日を除き、1 日 24時間、週 5 日の標準的な技術「サポート」を、「サービス」に対して無料で提供するものとします。 （アメリカの祝日は除く） 「Standard Support」は、「GitHub Support」を通じたウェブベースのチケット発行によってのみ提供され、「サポート」の要請は、GitHub の「サポート」チームがやり取りできる「ユーザ」から行う必要があります。 GitHub は、「注文書」または「SOW」に記載されている「サポート」レベル、「料金」、および「プラン契約期間」で、「サービス」に対してプレミアム「サポート」 (「[GitHub Enterprise Cloud の GitHub Premium Support](/articles/about-github-premium-support)」の規定に従う) または専用技術「サポート」を提供することができます。

### T. 雑則

#### 1. 準拠法
お客様の主たる事務所がアメリカ大陸にある場合、本契約はカリフォルニア州の法律に準拠し、解釈されるものとしますが、同州法が定める抵触法の規定は適用を除外します。本契約の下により生じるあらゆる法的措置または手続きは、カリフォルニア州北部地区に在する連邦裁判所または州裁判所のみに提起されるものとし、両「当事者」は、ここに定める人的裁判管轄権よび裁判地に同意するものとします。 お客様の主たる事務所がアメリカ大陸外にある場合、本契約はアイルランドの法律に準拠し、本契約の下により生じるあらゆる法的措置または手続きは、ダブリンに在する裁判所のみに提起されるものとし、両「当事者」はここに定める人的裁判管轄権よび裁判地に同意するものとします。 両「当事者」は、国際物品売買契約に関する国際連合条約および統一コンピュータ情報取引法が本契約に適用されないことに明示的に合意します。 上記の定めにかかわらず、GitHub は適切な管轄権を有する裁判所に衡平法による救済を求めることができるものとします。

#### 2. フィードバック
お客様は、「製品」に関する「フィードバック」を GitHub に対して行うことができます。 「フィードバック」は自発的なものであり、「お客様の機密情報」と指定している場合であっても、「お客様の機密情報」としては取り扱われません。 GitHubは、かかるフィードバックを以下の目的で十分に活用できます。(i) GitHubの既存および将来的な製品提供、およびかかる提供品の商品化において、操作、機能性、利用性を向上させるため。(ii) 「製品」の品質についての集計した統計値を公開するため。ただし、公開されるデータは、お客様、お客様の従業員、およびお客様の所有するソフトウェアのコードを明確に特定するために用いられることはありません。

#### 3. 割り当て不能
いずれの「当事者」も、本契約の一部または全体を、相手方当事者の書面による事前の同意なしに譲渡または移転してはならないものとし、またかかる同意を不合理に拒否しないものとし、不合理な拒否の試みは無効になるものとします。ただし、合併、取得、企業再編、あるいは事業または資産の全部または大部分の売却に関しては、相手方当事者に通知の上、相手方「当事者」の合意なく、GitHub は本契約の全体を譲渡できるものとします。

#### 4. 権利放棄
本契約の下における「当事者」の義務は、相手方「当事者」の権限のある担当者が署名した書面によってのみ免除されます。 本契約の「当事者」が本契約に基づく権利の行使を怠るか遅滞したとしても、本契約を放棄したと見なされることはなく、また、本契約の何らかの権利またはその一部を行使することが、本契約の他の部分またはさらなるの行使、または本契約に基づく法律上または衡平法上の権利の行使を妨げるものでもありません。

#### 5. 契約規定分離条項
本契約のいずれかの規定が管轄裁判所により違法、無効または執行不能であると判断された場合には、両「当事者」は、当該規定が可能な限り効力を持つように本契約を修正または改正するものとします。 このような修正または改正ができない規定は、削除されたものとみなされ、本契約の残りの規定は、引き続き効力を持つものとします。

#### 6. 修正、完全合意、優先順位
本「契約」は、GitHub の権限のある代表者が署名した書面による修正、または「セクション T」に従った GitHub による改訂版の投稿によってのみ変更できます。本契約は、関係者間の完全かつ排他的な合意を表しています。 本「契約」は、守秘義務契約または機密保持契約を含むかかる規約の主題に関する口頭または書面による提案または事前の契約、および関係者間のその他の通信に優先します。 本契約の規定と、あらゆる「注文書」または「SOW」との間に万が一矛盾がある場合、その「注文書」または「SOW」に関してのみ、「注文書」または「SOW」の規定が支配するものとします。

#### 7. 広報
お客様が、自らのアカウントに、自らの会社または組織の名前を公に表示しているか、プロフィールページに商標やロゴを公に表示している場合、お客様はその会社または組織の名前を、GitHub のお客様として宣伝素材において取り上げることを、GitHub に対して許諾するものとします。 お客様は、企業または組織の名前を公に非表示とし、組織名を宣伝素材において使用することを止めるよう、GitHub に対して書面で通知することにより、この許諾を取り消すことができます。 ただし、宣伝素材で過去に使用または配布したものについて、GitHub はそれらを削除または回収する義務を負いません。

#### 8. 不可抗力
天災、然災害、ストライキ、ロックアウト、暴動、戦争行為、伝染病、あるいは電力、通信またはネットワークの故障を含む合理的な制御を超えた異常事態により、本契約の下におけるあらゆる義務の履行が不可能な場合に限り、GitHub は、その責任を免除されるものとします。

#### 9. 独立契約者
各「当事者」は、本契約の主題に関して独立契約者です。 本契約に含まれるいかなる規定も、法的関係、パートナーシップ、合弁事業、雇用、代理、受託、その他これらに類する関係を両「当事者」間に構築するものとはいかなる場合にも見なされるまたは解釈されるものではなく、またいずれの「当事者」も、他方を契約上拘束することはできません。

#### 10. 質問
「利用規約」について質問がございましたら、 [お問い合わせください](https://github.com/contact/)。
