---
title: GitHubコミュニティガイドライン
redirect_from:
  - /community-guidelines/
  - /articles/github-community-guidelines
versions:
  free-pro-team: '*'
---

GitHub では、何百万人もの開発者が何百万ものプロジェクト（オープンソースとクローズドソースの両方）をホストしています。私たちは、コミュニティの日々のコラボレーションに貢献できることを光栄に思います。 私たちには、誇りに思うことができるコミュニティを実現するための素晴らしいチャンスがあると同時に、責任も背負っています。

世界中の GitHub ユーザたちの持つ視点、アイデア、経験は十人十色。数日前に初めて「Hello World」プロジェクトを作った人から、世界で最も有名なソフトウェア開発者まで、さまざまなユーザがいます。 私たちは、GitHub をコミュニティ内のさまざまな意見や視点に対応した快適な環境にし、人々が自由に自分を表現できるスペースになるよう取り組んでいます。

We rely on our community members to communicate expectations, [moderate](#what-if-something-or-someone-offends-you) their projects, and {% data variables.contact.report_abuse %} or {% data variables.contact.report_content %}. 当社がモデレートするコンテンツを積極的に探すことはありません。 GitHub でコラボレーションする最適な方法や、どんな行為やコンテンツが[利用規約](#legal-notices)に違反する恐れがあるのかを皆様に理解していただくために、ここではコミュニティ内では何が期待されるのかを説明いたします。 当社は不正行為の報告を調査し、利用規約に違反していると判断したサイトの公開コンテンツをモデレートする場合があります。

### 強いコミュニティを作る

GitHub コミュニティの主な目的は、ソフトウェアプロジェクトの共同作業です。 私たちの望みは、そんな皆様の共同作業がより良くなることです。 当社はサイトを管理していますが、これは私たちが*共に*構築するコミュニティです。それを最高のものにするためには、皆様のサポートが必要です。

* **広い心で受け入れる** - 他のコラボレータとあなたとでは、経験値やバックグラウンドが異なるかもしれませんが、だからといって相手がコントリビューションにつながる良いアイデアを持っていないということにはなりません。 新たなコラボレータや、かけだしのユーザーは歓迎してあげましょう。

* **お互いを尊重し合うこと。**無礼な態度ほど、健全な会話を妨げるものはありません。 礼儀正しく、大人の態度を保ちましょう。一般的に攻撃的、虐待的、ヘイトスピーチとみなされるような内容を投稿しないでください。 嫌がらせや、人が悲しむような行為は禁止されています。 あらゆるやり取りにおいて、お互いに品位と配慮をもって接しましょう。

  意見に反対したいこともあるでしょう。 それは全くかまいません。 ただし、批判すべきはアイデアであって、人ではありません。 悪口、個人攻撃、投稿の内容ではなく口調に対する応答、脊髄反射的な反論を行うのではなく、 会話の質を高めるような、理論的な反論を行いましょう。

* **共感をもってコミュニケーションを行う** - 意見の不一致や相違はよくあることです。 コミュニティの一員であることは、あなたとは違った背景や視点を持つさまざまな人と交流するということです。 誰かと意見が合わない場合は、それを直に伝える前に、その人を理解し、相手の立場に立ってみるようにしましょう。 こうすることで、質問や議論への参加、コントリビューションなどがしやすい、敬意と親密さに満ちた雰囲気が作られます。

* **明確に伝え、トピックから逸脱しない** - GitHub は、仕事を進めたり生産性を高めたりするために使われるものです。 トピックから逸脱したコメントは、生産的に働いて仕事を終わらせるという目的から気をそらしてしまいます（たまにはいいかもしれませんが、普段は慎みましょう）。 トピックに集中することで、ポジティブで生産的な議論が生まれます。

   また、インターネット上で見知らぬ人とやりとりする場合は、注意深さが求められます。 口調を伝えたり読み取ったりすることは難しく、皮肉な言葉が誤解されることも少なくありません。 明確な言葉を用い、相手がそれをどのように受け取るかを考えるようにしましょう。

### 嫌な思いをしたら

対応が必要な問題が当社の耳に入るかどうかは、コミュニティにかかっています。 私たちが攻撃的なコンテンツについてサイトを積極的に監視することはありません。 サイトで不快な思いをした場合は、GitHub が提供するいくつかのツールを使用することですぐに行動を取ることができます。

* ** 期待を伝える** - コミュニティ固有の独自のガイドラインを設定していないコミュニティに参加する場合は、プルリクエストを送信して、README ファイルまたは [CONTRIBUTING](/articles/setting-guidelines-for-repository-contributors/) ファイル、または[専用の行動規範](/articles/adding-a-code-of-conduct-to-your-project/)のいずれかで参加することを推奨します。

* **コメントをモデレートする** - リポジトリの[書き込みアクセス権限](/articles/repository-permission-levels-for-an-organization/)がある場合、コミット、プルリクエスト、および Issue に関するコメントを編集、削除、または非表示にすることができます。 リポジトリの読み取りアクセスがあれば、誰でもコミットの編集履歴を見ることができます。 コメントの作者とリポジトリの書き込みアクセスがある人は、コメントの編集履歴から機密情報を削除できます。 詳細については、「[コメントの変更を追跡する](/articles/tracking-changes-in-a-comment)」および「[混乱を生むコメントを管理する](/articles/managing-disruptive-comments)」を参照してください。

* **会話をロックする**  - Issue やプルリクエストのディスカッションが制御不能になった場合は、[会話をロック](/articles/locking-conversations/)できます。

* **ユーザーをブロックする**  - 繰り返し不適切な行動を取るユーザに遭遇した場合は、[ユーザを個人アカウントからブロック](/articles/blocking-a-user-from-your-personal-account/)したり、[ユーザを Organization からブロック](/articles/blocking-a-user-from-your-organization/)できます。

Of course, you can always contact us to {% data variables.contact.report_abuse %} if you need more help dealing with a situation.

### 禁止事項

私たちは、ユーザが自由に自己表現し、それが技術的な内容であろうがそうでなかろうが、お互いのアイデアについて意見を交換できるコミュニティを維持できるように取り組んでいます。 しかし、コミュニティのメンバーが怒鳴られたり、発言するのが怖いためにアイデアが出てこない場合、このようなディスカッションから実りある対話が生まれることは少ないでしょう。 このため、常に敬意を払い、礼儀正しく振る舞うべきで、相手が何者かであるかを根拠にして他人を攻撃することは控えるべきです。 当社は、一線を越えた次のような行為を許容しません。

* **暴力の脅威** - 他人を脅したり、サイトを利用して現実世界の暴力やテロ行為を組織、促進、または扇動することはできません。 言葉を発する場合や画像を投稿する場合はもちろん、ソフトウェアを作成する場合でさえも、それが他人からどのように解釈される可能性があるかを慎重に考えてください。 あなたが冗談のつもりでも、そのように受け取られないかもしれません。 自分が投稿したコンテンツが脅しである、または暴力やテロを助長していると他の誰かが解釈する*かもしれない*と思われる場合は、 それをGitHubに投稿するのを止めましょう。 場合によっては、当社が身体的危害のリスクや公共の安全に対する脅威だと判断し、暴力の脅威として法執行機関に報告する場合があります。

* **差別的発言と差別** - 年齢、体の大きさ、障害、民族性、性自認、性表現、経験の度合い、国籍、容姿、人種、宗教、性同一性、性的指向などのトピックを持ち出すこと自体は禁止されていませんが、相手が何者かであるかを根拠にして個人またはグループを攻撃する発言を当社は許容しません。 攻撃的または侮辱的なアプローチでこうしたデリケートなトピックを扱った場合、他の人を不快に感じさせたり、場合によっては危険にさえ感じさせたりすることがあることを認識してください。 誤解が生まれる可能性を完全に排除することはできませんが、デリケートなトピックを議論するときは、常に敬意を払い、礼儀正しく振る舞うことがコミュニティメンバーに期待されます。

* **いじめと嫌がらせ** - 私たちは、いじめや嫌がらせを容認しません。 これは、特定の個人またはグループを標的とする常習的な煽りや脅迫のことです。 一般的に、迷惑な行動を続けた場合、いじめや嫌がらせになる恐れが高くなります。

* **なりすまし** - 他人のアバターをコピーしたり、他人のメールアドレスを使ってコンテンツを投稿したり、類似するユーザ名を使用したりするなど、他人になりすまして自分の身元を誤解させようとしてはいけません。 なりすましは嫌がらせの一つです。

* **晒しとプライバシーの侵害** - 電話番号、プライベート用のメールアドレス、住所、クレジットカード番号、社会保障番号、国民識別番号、パスワードなど、他の人の個人情報は投稿しないでください。 脅迫や嫌がらせに該当するなど状況次第では、当社は対象の同意なしに撮影または配信された写真やビデオなどの他の情報をプライバシーの侵害とみなす場合があります。その情報が対象の安全リスクになる場合は特にです。

* **わいせつなコンテンツ** - ポルノに該当するコンテンツは投稿しないでください。 これは、すべてのヌード、または性に関するすべてのコードやコンテンツが禁止されていることを意味するものではありません。 セクシュアリティは生活の一部であり、ポルノ以外の性的コンテンツがプロジェクトの一部になったり、教育的または芸術的な目的で提示され得るものであることを当社は認識しています。 ただし、わいせつな性的コンテンツや未成年者の搾取や性的関与を含むコンテンツは許可されません。

* **脈絡のない暴力的コンテンツ** - 合理的な状況や警告なしに暴力的な画像やテキストなどのコンテンツを投稿しないでください。 ビデオゲーム、ニュースレポート、過去の出来事の説明に暴力的なコンテンツを含めることは多くの場合問題ありませんが、無差別に投稿された暴力的コンテンツや、他のユーザにとって回避が困難な方法（例えば、プロフィールアバターや Issue のコメントとして）で投稿された暴力的コンテンツは許可されません。 他のコンテキスト内に明確な警告や断りがあれば、ユーザはそのようなコンテンツに関与したいかどうかについて知識に基づいて判断を下すことができるでしょう。

* **Misinformation and disinformation** - You may not post content that presents a distorted view of reality, whether it is inaccurate or false (misinformation) or is intentionally deceptive (disinformation) because such content is likely to result in harm to the public or to interfere with fair and equal opportunities for all to participate in public life. For example, we do not allow content that may put the well-being of groups of people at risk or limit their ability to take part in a free and open society. We encourage active participation in the expression of ideas, perspectives, and experiences and may not be in a position to dispute personal accounts or observations. We generally allow parody and satire that is in line with our Acceptable Use Polices, and we consider context to be important in how information is received and understood; therefore, it may be appropriate to clarify your intentions via disclaimers or other means, as well as the source(s) of your information.

* **アクティブなマルウェアやエクスプロイト** - コミュニティの一員になる以上、コミュニティの他のメンバーにつけ込むような行為を行ってはいけません。 悪意のある実行可能ファイルを配信する手段としてや、サービス拒否攻撃を組織したりコマンドアンドコントロールサーバーを管理したりといった攻撃インフラとして GitHub を使用するなど、当社のプラットフォームをエクスプロイトの配信に使用することは許されません。 ただし、マルウェアやエクスプロイトの開発に使用される可能性のあるソースコードの投稿は禁止していません。そのようなソースコードの公開と配布には教育的価値があり、セキュリティコミュニティに純粋な利益をもたらすためです。


### 誰かがルールに違反した場合は

ユーザから不適切な行動やコンテンツの報告があった場合に当社が講じる措置はさまざまです。 これは、事態の正確な状況次第で決まるのが普通です。 人はさまざまな理由で不適切な発言や行動をしてしまうことがあるというのが、当社の認識です。 自分の言葉がどのように受け取られるのかをわかっていなかったという場合もあるでしょう。 または、つい感情的になってしまったという場合もあるでしょう。 もちろん、単にスパムをばらまいたり、トラブルを引き起こすことを目的とする人がいることも事実です。

ケースバイケースで異なるアプローチが必要なため、当社は報告を受けた状況に合った対応を行うように心がけています。 このため、不正行為に関する報告は個別に確認しています。 いずれの場合も、多様性に富んだチームがコンテンツとそれに関する事情を調査し、必要に応じて対応し、このガイドラインに基づいて決定を下します。

不正行為の報告を受けた際に当社が講じる措置には以下が含まれますが、これらに限定されません。

* コンテンツの削除
* コンテンツのブロック
* アカウントの一時停止
* アカウントの解約

### 法的通知

本コミュニティガイドラインは、[CC0-1.0](https://creativecommons.org/publicdomain/zero/1.0/) の条件に基づいて、誰でも使用、再利用、改作、その他あらゆることが可能になるようにパブリックドメインになっています。

これはあくまでもガイドラインであり、[利用規約](/articles/github-terms-of-service/)を変更するものや、完全なリストであることを意図したものではありません。 GitHub は、[利用規約](/articles/github-terms-of-service/#c-acceptable-use)に基づいて、利用規定に違反するコンテンツを削除するか、または利用規定に違反する活動のアカウントを解約することができる、完全な裁量を保持します。 本ガイドラインでは、かかる裁量を行使する場合について説明しています。
