---
title: GitHubコミュニティフォーラムの行動規範
redirect_from:
  - /articles/github-community-forum-code-of-conduct
versions:
  free-pro-team: '*'
---

### 概要と目的

GitHub では、何百万人もの開発者が何百万ものプロジェクト（オープンソースとクローズドソースの両方）をホストしています。私たちは、開発者コミュニティの日々のコラボレーションに貢献できることを光栄に思います。 私たちには、誇りに思うことができるコミュニティを実現するための素晴らしいチャンスがあると同時に、責任も背負っています。

GitHubコミュニティフォーラムは、コラボレーション、サポート、およびブレインストーミングを推進する場となることを目的としています。 ここは、他のユーザとつながり、新しいスキルを学び、意見やアイデアを共有し、さらにGitHubプロジェクトに必要なサポートを得るための快適な場です。 このコミュニティに参加することにより、GitHub.comに適用される[利用規約](/articles/github-terms-of-service/)の他に、このコミュニティに固有の行動規範にも同意することになります。

この行動規範が、 GitHubコミュニティフォーラムに貢献する最善の方法、モデレーターにできること、およびコミュニティへの参加が一時的または永久に停止される行為やコンテンツの種類について理解の助けになることを願います。 当社は不正行為の報告を調査し、GitHub利用規約または本行動規範のいずれかに違反していると当社が判断したコミュニティ内の公開コンテンツを管理することがあります。

世界中の GitHub ユーザたちの持つ視点、アイデア、経験は十人十色。数日前に初めて「Hello World」プロジェクトを作った人から、世界で最も有名なソフトウェア開発者まで、さまざまなユーザがいます。 私たちは、GitHubおよびGitHubコミュニティフォーラムを、さまざまな意見や視点に対応した快適な環境にし、人々が自由に自分を表現できるスペースになるよう取り組んでいます。

### 誓約

オープンで居心地の良い環境を醸成するために、我々はコントリビューター、そして管理者としてGitHubコミュニティフォーラムへ参加するにあたり、年齢、体の大きさ、能力、民族、性別のアイデンティティや外観、経験のレベル、国籍、個人の見た目、人種、宗教や、性的なアイデンティティや指向に関するハラスメントを行わないことを誓います。

### 規範

GitHubコミュニティフォーラムを、敬意をもって扱ってください。 私たちは共有資源です。スキル、知識、関心を、会話を通じて分かち合う場です。

以下は杓子定規の決まりごとではなく、コミュニティにおける人間の判断を助けるためのものです。 気持ちよい、礼儀正しい話し合いの場である状態を保つため、このガイドラインを用いましょう。

#### *強いコミュニティを作るためのベストプラクティス*

- 敬意と思いやりを持ちましょう。
  - **広い心で受け入れる。**他のコミュニティメンバーとあなたとでは、経験値やバックグラウンドが異なるかもしれませんが、だからといって相手がコントリビューションにつながる良いアイデアを持っていないということにはなりません。 新たなメンバーや、かけだしのユーザーは歓迎してあげましょう。
  - **お互いを尊重し合うこと。**無礼な態度ほど、健全な会話を妨げるものはありません。 礼儀正しく、大人の態度を保ちましょう。一般的に攻撃的、虐待的、ヘイトスピーチとみなされるような内容を投稿しないでください。 嫌がらせや、人が悲しむような行為は禁止されています。 あらゆるやり取りにおいて、お互いに品位と配慮をもって接しましょう。

    意見に反対したいこともあるでしょう。 それは全くかまいません。 ただし、批判すべきはアイデアであって、人ではありません。 悪口、個人攻撃、投稿の内容ではなく口調に対する応答、脊髄反射的な反論を行うのではなく、 会話の質を高めるような、理論的な反論を行いましょう。
  - **共感をもってコミュニケーションを行う。**意見の不一致や相違はよくあることです。 コミュニティの一員であることは、あなたとは違った背景や視点を持つさまざまな人と交流するということです。 誰かと意見が合わない場合は、それを直に伝える前に、その人を理解し、相手の立場に立ってみるようにしましょう。 こうすることで、質問や議論への参加、コントリビューションなどがしやすい、敬意と親密さに満ちた雰囲気が作られます。
- 肯定的、建設的な方法で貢献しましょう。
  - **ディスカッションを向上させる。**ディスカッションを少しでも向上させるよう努めて、コミュニティが良いディスカッションの場になるようご協力ください。 投稿が会話を深めるか自信がない場合、何を言いたいかをまず考えてみてください。

    この場で話し合われる話題は私たちにとって大切なので、あなたにもそれを大切にしてもらいたいと思います。 何か同意できないことがある場合でも、話題やそれを話し合う人々を尊重してください。
  - **明確でトピックに沿うようにやりとりする。**インターネット上で見知らぬ人とやりとりするには、注意深さが求められます。 口調を伝えたり読み取ったりすることは難しく、皮肉な言葉が誤解されることも少なくありません。 明確な言葉を用い、相手がそれをどのように受け取るかを考えるようにしましょう。

    これは、リンクを書き込むことについても当てはまります。 コミュニティフォーラムでリンクを書き込む場合、関連する適切な情報を提供する目的で行う必要があります。 単にトラフィックを呼び込んだり、サイトに注目を集めたりするためにリンクを投稿すべきではありません。 リンクを投稿する際は、常にリンク先のコンテンツや目的についての十分な説明を添えてください。 関連性や価値あるコンテンツがない、不要なリンクを投稿すれば、広告や悪意の目的があるものと受け取られる可能性があります。

    さらに、GitHubコミュニティフォーラムは、コラボレーション、アイデアの共有、そしてお互いの作業を終わらせるための場です。 トピックから逸脱したコメントは、生産的に働いて仕事を終わらせるという目的から気をそらしてしまいます（たまにはいいかもしれませんが、普段は慎みましょう）。 トピックに集中することで、ポジティブで生産的な議論が生まれます。
  - **伝え方に注意する。**他の人にフィードバックを求めたり、プロジェクトへのコラボレーションを求めたりする場合は、背景を伝えるため、有益で関連あるリソースのみを共有しましょう。 話題に貢献しないリンクや、自分のプロジェクトやサイトへのリンクをむやみに他のユーザのスレッドに投稿しないでください。

    また、重要な情報を書き込まないでください。 これには、あなたのメールアドレスも含まれます。 このコミュニティフォーラムでは、そうした情報の書き込みを許可していません。投稿者や他のユーザにとって、安全やプライバシーのリスクが生じるためです。 他のフォーラムメンバーをプロジェクトのコラボレートや共同作業に招待したい場合は、作業中のプロジェクトにあるリポジトリのリンクを伝えてください。 プロジェクトの内容や、求めている支援やフィードバックについての情報を添えて、プロジェクトのリポジトリへのリンクを共有することで、あなたの個人情報を伝えることなく、Issueやプルリクエストを通じてコラボレーションするよう他の人々を招待できます。 また、プロジェクトのリポジトリに外部のコラボレータて追加して、プロジェクトを開発するために役立つ特別な権限を与えることも可能です。
  - **秩序正しく。**適切な場所に書くことに気をつけて、内容の整理よりもディスカッションに多くの時間を割けるようにしましょう。 ですから、以下のことにご協力ください。
    - 間違ったカテゴリでトピックを開始しないでください。
    - 複数のトピックに同じ内容をクロスポストしないでください。
    - 中身のない返信を投稿しないでください。
    - 新しく適切な情報を共有するのでない限り、スレッドを上げないでください。
    - 話の流れを途中で変えて、話題を逸らさないでください。

    「+1」や「賛成」と投稿するよりも、Kudosボタンを使いましょう。 既存のトピックを全く別の方向に進めるよりも、新たなトピックを開始しましょう。

- 信頼されるようになりましょう。
  - **常に正直に。**誤った情報を故意に共有したり、GitHubコミュニティフォーラムの他のメンバーを意図的に誤解させたりしないでください。 質問の答えはわからないけれど手を貸したい場合、情報収集やリソースの発見を手伝いましょう。 GitHubスタッフもコミュニティで活動しているので、答えがわからない場合は、モデレーターが助けることができる可能性があります。

#### *禁止事項*

- **暴力による脅し。**他人を脅したり、サイトを利用して現実世界の暴力やテロ行為を組織、促進、または扇動することはできません。 言葉を発する場合や画像を投稿する場合はもちろん、ソフトウェアを作成する場合でさえも、それが他人からどのように解釈される可能性があるかを慎重に考えてください。 あなたが冗談のつもりでも、そのように受け取られないかもしれません。 If you think that someone else might interpret the content you post as a threat, or as promoting violence or terrorism, stop. それを投稿しないでください。 場合によっては、当社が身体的危害のリスクや公共の安全に対する脅威だと判断し、暴力の脅威として法執行機関に報告する場合があります。

- **差別的発言と差別。**年齢、体の大きさ、能力、民族性、性自認、性表現、経験の度合い、国籍、容姿、人種、宗教、性同一性、性的指向などのトピックを持ち出すこと自体は禁止されていませんが、相手が何者かであるかを根拠にして個人またはグループを攻撃する発言を当社は許容しません。 これらやその他のセンシティブな話題について話すと、他の人が迷惑がられていると感じたり、また攻撃的あるいは侮辱的な話し方の場合は危険を感じさせたりすることもあることを認識しましょう。 デリケートな話題を議論するときは、常に礼儀正しく振る舞うことがコミュニティメンバーに期待されます。

- **いじめと嫌がらせ。**私たちは、いじめや嫌がらせを容認しません。 これは、特定の個人またはグループを標的とする常習的な煽りや脅迫のことです。 一般的に、迷惑な行動を続けた場合、いじめや嫌がらせになる恐れが高くなります。

- **なりすまし** 他人のアバターをコピーしたり、他人のメールアドレスを使ってコンテンツを投稿したり、類似するユーザ名を使用したりするなどして、他人になりすましてはいけません。 なりすましは嫌がらせの一つです。

- **晒しとプライバシーの侵害。**電話番号、プライベート用のメールアドレス、住所、クレジットカード番号、社会保障番号、国民識別番号、パスワードなど、他の人の個人情報は投稿しないでください。 脅迫や嫌がらせに該当するなど状況次第では、当社は対象の同意なしに撮影または配信された写真やビデオなどの他の情報をプライバシーの侵害とみなす場合があります。その情報が対象の安全リスクになる場合は特にです。

- **わいせつ／性的に露骨なコンテンツ。**基本的に、ポルノは投稿しないでください。 これは、すべてのヌードや性的コンテンツが禁止されていることを意味するものではありません。 セクシュアリティは生活の一部であり、ポルノ以外の性的コンテンツがプロジェクトの一部になったり、教育的または芸術的な目的で提示され得るものであることを当社は認識しています。 投稿したいものについて質問がある場合は、事前に[ご連絡ください](https://support.github.com/contact)。

- **スパム。**GitHubコミュニティフォーラムを尊重してください。 広告の投稿、スパムサイトへのリンクなど、コミュニティを破壊するようなことをしてはなりません。 このコミュニティは、GitHubユーザがプロジェクトについて議論したり、学び、アイデアをお互いに共有することを目的としています。広告やスパム的なコンテンツを投稿する場ではありません。 私たちがスパムと考えるコンテンツは削除されます。

- **著作権で保護されたコンテンツまたは違法なコンテンツ。**自分に権利があるものだけを投稿してください。 あなたは投稿したものについて責任を負います。 自分で作成していないものを投稿する場合は、投稿する権利を所持する必要があります。 著作権法および商標法に基づく違法コンテンツ、違法コンテンツへのリンク、法律を回避する方法などの、違法なコンテンツを投稿することはできません。

- **アクティブなマルウェアやエクスプロイト。** コミュニティの一員になる以上、コミュニティの他のメンバーにつけ込むような行為を行ってはいけません。 いかなる人であれ、当社のプラットフォームを、（コミュニティを悪意ある実行ファイルを配信する手段とするなど）悪意のある実行可能ファイルを配信するために用いたり、（サービス拒否攻撃の企画や、コマンドアンドコントロールサーバーの管理などの）攻撃インフラとして用いたりすることは許可しません。 ただし、マルウェアやエクスプロイトの開発に使用される可能性のあるソースコードの投稿は禁止していません。そのようなソースコードの公開と配布には教育的価値があり、セキュリティコミュニティに純粋な利益をもたらすためです。

- **13歳未満。**13歳未満のこどもは、GitHubコミュニティ（およびGitHub自体）のアカウントを所有できません。 GitHubは、13歳以下のこどもから意図的に情報を収集せず、および、13歳以下のこどもを対象としたコンテンツを提供しません。 当社は、あなたが13歳未満であることを知った場合、または、そうだと疑う理由がある場合、残念ながらGitHubコミュニティフォーラムとGitHub.comの両方のアカウントを閉鎖する必要があります。 当社はお客様がコードを学習することを止めたくはありませんが、これらは規則なのです。 アカウント解約についての情報は、[「利用規約」](/articles/github-terms-of-service/)を参照してください。

- **その他合理的に考えてプロフェッショナルな場ではふさわしくない行為。**GitHubコミュニティフォーラムはプロフェッショナルな場であり、それにふさわしい振る舞いが求められます。

### 行動規範の施行

#### *GitHubコミュニティフォーラムのメンバーができること*

- **問題を見かけたら、報告してください。**モデレーターには特別な権限があり、このコミュニティに対して責任を負っています。 しかし、あなたもコミュニティに責任を負っているのです。 あなたの助けがあってこそ、モデレーターは守衛や警察のように振る舞うだけでなく、コミュニティの進行役を努めることができるのです。

  悪意のある書き込みを見ても、返信しないでください。 その存在を認識することで、悪い振る舞いが促され、あなたを疲弊させ、みんなの時間を無駄にします。 その代わり、オプションメニューの「不適切なコンテンツを報告する」から報告してください。 十分な数の報告があれば、自動的に、またはモデレーターの介入によって対処します。

#### 私たちの責任

不適切な行動やコンテンツの報告に対して当社が講じる措置はさまざまです。 これは、事態の正確な状況次第で決まるのが普通です。 人はさまざまな理由で不適切な発言や行動をしてしまうことがあるというのが、当社の認識です。 自分の言葉がどのように受け取られるのかをわかっていなかったという場合もあるでしょう。 または、つい感情的になってしまったという場合もあるでしょう。 もちろん、単にスパムをばらまいたり、トラブルを引き起こすことを目的とする人がいることも事実です。

ケースバイケースで異なるアプローチが必要なため、当社は状況に合った対応を行うように心がけています。 このため、それぞれの状況を個別に確認しています。 いずれの場合も、多様性に富んだチームがコンテンツとそれに関する事情を調査し、必要に応じて対応し、この行動規範に基づいて決定を下します。

フラグや不正行為の報告を受けた際に当社が講じる措置には以下が含まれますが、これらに限定されません。
  - コンテンツの削除
  - コンテンツのブロック
  - コミュニティフォーラムアカウントの一時停止
  - コミュニティフォーラムアカウントの削除

行動規範を誠実に遵守もしくは施行しないコミュニティフォーラムのモデレーターは、コミュニティフォーラムのマネージャによる裁定により、一時的または永久的な処分を受けることがあります。

### GitHubスタッフへの連絡

If, for any reason, you want to contact GitHub Staff, the Community Managers, Administrators, or Moderators of this forum privately, you can use our [Support contact form](https://support.github.com/contact?tags=community-support). Contacting any member of GitHub Staff via channels other than the forum itself or the Support contact form is strongly discouraged and may be considered a violation of our prohibition against harassment.

お互いの存在とその時間を尊重することにより、このフォーラムを安心して参加できる場に保つよう協力しましょう。

### 法的通知

法律的な言葉はつまらないものですが、しかし私たちは自分自身、ひいては皆さんやそのデータを、敵意ある人々から守る必要があります。 あなた（と当社）のコンテンツ、プライバシー、および法律に関する振る舞いや権利については、[「GitHub利用規約」](/articles/github-terms-of-service/)および[「プライバシーについての声明」](/articles/github-privacy-statement/)に記載しています。 このサービスを利用するには、[「GitHub利用規約」](/articles/github-terms-of-service/)および[「プライバシーについての声明」](/articles/github-privacy-statement/)の順守に同意する必要があります。

この行動規範は、[「GitHub利用規約」](/articles/github-terms-of-service/)を変更するものではなく、また包括的なリストであることを意図したものではありません。 GitHub は、[「GitHub利用規約」](/articles/github-terms-of-service/)に基づいて、「非合法、攻撃的、脅迫的、中傷、名誉毀損、ポルノ、わいせつ、その他不快なもの、他者の知的財産権を侵害するもの、本利用規約に違反するもの」であるあらゆるコンテンツを削除し、またこれを行ったアカウントを解約できる、完全な裁量を保持します。 This Code of Conduct describes when we will exercise that discretion.
