---
title: GitHub追加製品の利用規約
versions:
  free-pro-team: '*'
---

アカウントを作成すると利用できるようになる各種の機能と製品は、すべて本サービスの一部です。 このような機能と製品の多くは機能性が異なるため、その機能や製品に固有の利用規約が必要になる場合があります。 以下に、こうした機能や製品と、サービスのその部分に対応して適用される追加のルールを示します。

GitHubの使用には、該当する規約 (以下「契約」) と、以下のGitHub追加製品利用規約 (以下「追加条項」) が適用されます。 本契約に同意し、追加の製品や機能を使用することにより、本追加条項にも同意したことになります。 追加条項に違反すると契約にも違反することになります。 かぎ括弧で括った項のうち、追加条項で定義されていないものについては、本契約に示された意味を持つものとします。

### 1. Marketplace

GitHub Marketplaceを通じて開発者製品をリストする場合は、リストされるプロジェクトを送信する前に、[GitHub Marketplace開発者同意書](/github/site-policy/github-marketplace-developer-agreement)に同意する必要があります。

GitHub Marketplaceを通じて開発者製品を購入する場合は、購入には[GitHub Marketplace利用規約](/github/site-policy/github-marketplace-terms-of-service)が適用されます。 GitHub Marketplaceの使用には、本契約と、[GitHub Marketplace利用規約](/github/site-policy/github-marketplace-terms-of-service)が適用されます。

### 2. サードパーティとのインテグレーション

#### a. アプリケーションの作成
サードパーティのアプリケーション、またはユーザ個人情報またはユーザ生成コンテンツを収集し、GitHubのAPI、OAuthの仕組みその他を通じてサービスと統合される開発者製品 (以下「開発者製品」) を作成して他のユーザに公開する場合、次の要件に従う必要があります。
- 本契約とGitHubのプライバシーについての声明に従う必要があります。
- 法律またはライセンスなどで許可されている場合を除き、お客様は、お客様が収集するユーザの個人情報や「ユーザ生成コンテンツ」の使用を、ユーザが収集を許可した目的に限定する必要があります。
- お客様は、ユーザの個人情報または「ユーザ生成コンテンツ」を処理することによって生じる偶発的または違法な破壊、偶発的な紛失、改変、不正な開示またはアクセスなどのリスクに適切な合理的なセキュリティ対策をすべて講じる必要があります。
- お客様は、GitHubに代わってユーザの個人情報または「ユーザ生成コンテンツ」を収集すると主張したり、プライバシーポリシーを掲示するなどして、そのプライバシー慣行をユーザに通知したりしてはなりません。
- お客様は、保存が法律により要求されている場合や、ライセンスなどにより許可されている場合を除き、お客様がGitHubを通じて収集したユーザ個人情報または「ユーザ生成コンテンツ」を、ユーザが収集を承認した限定的な特定の目的のために必要でなくなった時点で、削除する方法をユーザに提供する必要があります。

#### b. サードパーティアプリケーションの使用
お客様は、プライベートリポジトリを含むリポジトリのコンテンツの使用、アクセス、開示を「開発者製品」に許可することができます。 一部の「開発者製品」は、[[GitHub Marketplace](https://github.com/marketplace)で入手できます。 一部の「開発者製品」は、自動化されたタスクの実行に使用でき、多くの場合、複数のユーザが「開発者製品」にアクションを指定することもできます。 ただし、お客様がそのアカウントで「開発者製品」を購入および/または設定する場合、またはお客様が統合された「開発者製品」に対してアカウントの所有者である場合、お客様はそのアカウントでまたはアカウントを通じて実行される「開発者製品」のアクションについて責任を負います。 「開発者製品」のデータの共有に関する詳細は、「[プライバシーについての声明](/github/site-policy/github-privacy-statement#third-party-applications)」を参照してください。

**GitHubは「開発者製品」に関していかなる保証も行わず、お客様が「お客様のコンテンツ」へのアクセスを許可した第三者への開示について責任を負いません。 サードパーティアプリケーションを、お客様は自らの責任ににおいて利用するものとします。**

### 3. Git LFSのサポート

アカウントでLarge File Storage (以下「Git LFS」) を有効にすると、大容量のファイルもGitで扱う通常のファイルと同じようにフェッチ、修正、プッシュできます。 お客様のアカウントには、Git LFSで使用できる一定量の帯域とストレージ付属しています。これについては、[Git LFSのドキュメント](/github/managing-large-files/about-storage-and-bandwidth-usage)を参照してください。 Git LFSの帯域幅とストレージの使用量は、[アカウント設定](https://github.com/settings/billing)に表示されます。 割り当てられている帯域幅とストレージを超えてGit LFSを使用したい場合は、[追加のデータパックを購入する](/github/setting-up-and-managing-billing-and-payments-on-github/upgrading-git-large-file-storage)こともできます。

### 4. ページ

各GitHubアカウントには、[GitHub Pagesの静的ホスティングサービス](/github/working-with-github-pages/about-github-pages)へのアクセス権があります。 このホスティングサービスは、すべてのユーザの静的Webページをホストするためのサービスですが、主に個人および組織のプロジェクトのためのショウケースの役割をはたしています。 ページでは、寄付のボタンやクラウドファンディングのリンクなど、収益化の行為が一部認められています。

GitHub Pagesは、特定の帯域幅および使用法の制限を受けるため、帯域幅が大きいなど理由で適さない場合には適切でない可能性があります。 詳細は、「[GitHub Pagesのガイドライン](/github/working-with-github-pages/about-github-pages)」を参照してください。 GitHubは、責任を負うことなくGitHubの任意のサブドメインを取得する権利を常に有します。

### 5. アクションとパッケージ

#### a. アクションの使用量
GitHubアクションでは、カスタムソフトウェア開発のライフサイクルにわたるワークフローをGitHubリポジトリに直接作成することができます。 各アカウントには、アクションで使用できる付属の計算処理およびストレージ容量が、アカウントプランに応じて付属しています。これについては、[Gアクションのドキュメント](/github/automating-your-workflow-with-github-actions/about-github-actions#about-github-actions)を参照してください。 アクションの計算使用量は[アカウント設定](https://github.com/settings/billing)に表示され、付属の量の制限に達すると前ってメールで通知されます。 付属の量を超えてアクションを使用したい場合は、[超過使用を有効にする](/github/setting-up-and-managing-billing-and-payments-on-github/about-billing-for-github-actions)こともできます。

付属の量と有料の量の計算使用量は、実行するアクションの種類 (Linux、Windows、macOSなど)に基づいて分単位で計算されます。 各アクションのジョブまたはタスクに使用された時間を、分単位で切り上げます。 付属の量の場合は、アクションの種類に応じ、各ジョブまたはタスクの実行に使われた時間に倍数をかけてから、最も近い分単位に切り上げます。 超過使用時間は、実行するアクションの種類に基づいて[申告された分単位の価格](https://github.com/features/actions)で請求されます。 アクションとパッケージはストレージを共有し、ストレージの使用量は、[アカウント設定](https://github.com/settings/billing)に表示されます。 付属の量の使用量計算に関する詳細は、[アクションのドキュメント](/github/automating-your-workflow-with-github-actions/about-github-actions#about-github-actions)を参照してください。

アクションとアクションサービスの要素は、本契約、[利用規定](/github/site-policy/github-acceptable-use-policies)、またはGitHubアクション[サービス制限](/github/automating-your-workflow-with-github-actions/about-github-actions#usage-limits)に違反して使用される場合があります。 また、アクションは次の用途には使用しないでください。
- クリプトマイニング;
- 当社サーバーを使用して、何らかのサービス、デバイス、データ、アカウントまたはネットワークを妨害すること、またはこれらに不正アクセスするかあるいはこれを試みること ([GitHub Bug Bounty program](https://bounty.github.com) により許可されている場合を除く)、
- the provision of a stand-alone or integrated application or service offering Actions or any elements of Actions for commercial purposes;
- any activity that places a burden on our servers, where that burden is disproportionate to the benefits provided to users (for example, don't use Actions as a content delivery network or as part of a serverless application, but a low benefit Action could be ok if it’s also low burden); or
- gitHubアクションが使用されるリポジトリに関連するソフトウェアプロジェクトの製造、テスト、デプロイ、公開に関連しないその他の行為。

このような使用制限違反や、GitHubアクションの悪用を防ぐために、GitHubはGitHubアクションの使用を監視する場合があります。 GitHubアクションを不正利用した場合には、ジョブが停止されたり、GitHubアクションの使用を制限されたりすることもあります。

#### b. パッケージの使用量
GitHubパッケージを使用してコンテンツのパッケージをダウンロード、公開、管理することができます。 各アカウントプランには、パッケージで使用できる付属の帯域幅およびストレージ容量が付属しています。これについては、[パッケージのドキュメント](/github/managing-packages-with-github-package-registry/about-github-package-registry)を参照してください。 アクションとパッケージは、2つのサービス機能間でストレージを共有します。 ストレージと帯域幅の使用量は[アカウント設定](https://github.com/settings/billing)に表示され、付属の量の制限に達すると前もってメールで通知されます。 付属の帯域幅およびストレージを超えてパッケージを使用したい場合は、[超過使用を有効にする](/github/setting-up-and-managing-billing-and-payments-on-github/about-billing-for-github-packages)こともできます。

帯域幅の使用量は、パッケージを通じてリポジトリの外部に委譲されたデータの量に基づいて計算されますが、アクションを通じてのパッケージ委譲は、付属の量にも有料の量にも含まれません。 パッケージの帯域幅使用量は[利用規定](/github/site-policy/github-acceptable-use-policies#7-excessive-bandwidth-use)によって制限されますが、付属の帯域幅の量は、[アカウントプラン](https://github.com/pricing)によって決まります。

アクションとパッケージのストリーム使用量は、2つのサービス機能間で共有します。 ストレージの使用量は1か月を通じた加重平均で計算され、毎月リセットはされません。 パブリックリポジトリとプライベートリポジトリでは付属するストレージの量が異なり、プライベートリポジトリの付属の量は[アカウントプラン](https://github.com/pricing)によって異なります。

#### c. アカウントとパッケージに対する支払いと請求
アクションとパッケージに対する請求は従量制です。 アクションまたはパッケージの追加の量を個別に購入することはできません。  月次請求のお客様が、これらのサービス機能の追加料の支払いを選択するには、支払い方法がファイルに指定されている必要があります。 請求書払いでない場合は、前月の使用量に基づいて毎月定期的に請求されます。 請求書払いのお客様の場合は、GitHubの請求日から30日以内にお支払いください。 サービス機能の制限超過分を前払いしたお客様の場合、未使用分数の前払い分は次の請求期間に繰り越されず、返金されません。

[アカウント設定](https://github.com/settings/billing/cost_management)で、毎月の使用制限を設定することができます。 付属の量の制限や、有料で追加した量に指定した使用制限に近づくと、前もってメールで通知されます。

### 6. Learning Lab

**Enrollment.** To complete enrollment in Learning Lab for Organizations, you agree to create a separate organization for Learning Lab purposes, and you authorize us to add Learning Lab course materials to that organization on your behalf.

**Learning Lab Course Materials.** Any course materials GitHub provides are owned solely by GitHub; provided, however, that GitHub grants you a worldwide, non-exclusive, limited-term, non-transferable, royalty-free license to copy, maintain, use and run such course materials for your internal business purposes associated with Learning Lab use. This license grant is subject to any additional open source licensing agreements that may be provided along with the source code.  Course materials you create are owned solely by you, provided, however, that you grant to GitHub a worldwide, non-exclusive, perpetual, non-transferable, royalty-free license to copy, maintain, use, host, and run (as applicable) on the Service, such course materials. Your use of GitHub course materials and your creation and storage of your own course materials does not constitute joint ownership in either party's respective intellectual property by the other party.

**Privacy.** Learning Lab may collect personal information. You control what information Learning Lab collects in your GitHub.com profile settings panel. If Learning Lab collects personal information on GitHub's behalf, GitHub will process that information in accordance with the [GitHub Privacy Statement](/github/site-policy/github-privacy-statement). If you enroll in or are completing a private course through Learning Lab, GitHub may share your enrollment information and course progress through completion with the organization admins. This may include individual data such as your GitHub username, course start date, and course end date. Course completion data may also be presented in aggregate form to help guide improvements to the course content.

### 7. Connect

GitHub Connectにアクセスするには、お客様がGitHub.comにアカウントを少なくとも1つ持ち、ソフトウェアのライセンスを少なくとも1つ持っている必要があります。 GitHub Connectは、自動化されたタスクを実行するために使用できます。 また、GitHub Connectで複数のユーザが特定のアクションを振り向けることもできます。 お客様は、そのアカウントで、またはそのアカウントを通じて実行されるアクションに責任を負います。 GitHubは、機能の提供と改善を目的にお客様のGitHub Connect 使用状況について情報を収集することがあります。 GitHub Connectを使用すると、お客様は、プライベートリポジトリデータとユーザの個人情報 (GitHubのプライバシーについての声明に定義) を含め、保護されたデータをお客様のGitHub Enterprise Serverアカウントから収集する権限をGitHubに付与することになります。 またお客様は、GitHub Connectを通じて、身元の特定につながるインスタンス情報がGitHubに転送されることを承認します。この情報には、GitHubのプライバシーについての声明が適用されます。

### 8. Sponsorsプログラム

スポンサード開発者になるには、[GitHub Sponsorsプログラムの追加条項](/github/site-policy/github-sponsors-additional-terms)に同意する必要があります。

### 9. GitHub Advanced Security

GitHub Advanced Security enables you to identify security vulnerabilities through customizable and automated semantic code analysis. GitHub Advanced Security is licensed on a per User basis. If you are using GitHub Advanced Security as part of GitHub Enterprise Cloud, many features of GitHub Advanced Security, including automated code scanning of private repositories, also require the use of GitHub Actions. Billing for usage of GitHub Actions is usage-based and is subject to the [GitHub Actions terms](/github/site-policy/github-additional-product-terms#c-payment-and-billing-for-actions-and-packages).

### 10. Dependabot Preview

Dependabot Previewの使用には、別の[利用規約](https://dependabot.com/terms)および[プライバシーポリシー](https://dependabot.com/privacy)が適用されます。

### 11. Spectrum

Your use of Spectrum is governed by the GitHub [Terms of Service](/github/site-policy/github-terms-of-service) and [Privacy Statement](/github/site-policy/github-privacy-statement).

### 12. Advisory Database

#### a. 当社へのライセンス許可

当社には、GitHub Advisory Databaseへのコントリビューションを[National Vulnerability Database](https://nvd.nist.gov/)などのパブリックドメインデータセットに提出するための法的権利、並びに、セキュリティ研究者、オープンソースコミュニティ、業界、および公衆が使用するためのオープンタームに基づいてGitHub Advisory Databaseをライセンス付与するための法的権利が必要です 。 あなたは、[Creative Commons Zeroライセンス](https://creativecommons.org/publicdomain/zero/1.0/)の下でGitHub Advisory Databaseへのコントリビューションをリリースすることに同意するものとします。

#### b. GitHub Advisory Databaseのライセンス

GitHub Advisory Databaseは、[Creative Commons Attribution 4.0ライセンス](https://creativecommons.org/licenses/by/4.0/)の下でライセンスされています。 帰属条件は、<https://github.com/advisories>のGitHub Advisory Databaseまたは使用される個々のGitHub Advisory Databaseレコード（<https://github.com/advisories>で始まる）にリンクすることで満たすことができます。

