---
title: GitHub 利用規定
redirect_from:
  - /articles/github-acceptable-use-policies
versions:
  free-pro-team: '*'
---

**趣旨の要約:** _私たちは、世界中のさまざまな協同プロジェクトをホストしており、そうしたコラボレーションは、ユーザ同士が誠実に協力できる場合にのみ成り立ちます。 あなたが「サービス」を利用する際は、本利用規定に従う必要があります。本利用規定には、あなたが投稿できるコンテンツについての制限、サービス上の行動、その他の制限が記載されています。 その趣旨を要約すれば、お互いのことを思いやりましょうということです。_

かぎ括弧に括られた用語のうち、本利用規定で定義されていないものについては、 「[利用規約](/articles/github-terms-of-service)」、「[企業向け利用規約](/articles/github-corporate-terms-of-service)」、および「[プライバシーについての声明](/articles/github-privacy-statement)」に記載された定義に従うものとします。 「[企業向け利用規約](/articles/github-corporate-terms-of-service)」が適用されるお客様については、「あなた」は「お客様」または「ユーザ」を指します。 「私たち」、「当社」は「GitHub」を指します。

### 1. 法令・規定の遵守
あなたは、本「サービス」を利用するにあたり、全ての適用法、規制、および当社の定める全ての利用規定を遵守する責任を負います。 これらの規定は、更新されることがあります。更新内容については以下、ならびに当社の「[利用規約](/articles/github-terms-of-service)」および「[企業向け利用規約](/articles/github-corporate-terms-of-service)」をご確認ください。

### 2. コンテンツの制限
「ユーザ」は、いかなる場合においても、以下に該当するいかなる「コンテンツ」をいかなるリポジトリに対してもアップロード、投稿、ホスト、実行、または送信しないものとします:

- 非合法、または非合法行為を促進するもの、

- 性的・わいせつな内容を含むもの、

- 中傷、名誉毀損、あるいは詐欺的なもの、

- あらゆる個人やグループを差別または罵倒するもの、

- 暴力的画像を含め、不必要に暴力を描写または美化するもの、

- is or contains false, inaccurate, or intentionally deceptive information that is likely to adversely affect the public interest (including health, safety, election integrity, and civic participation);

- アクティブなマルウェアまたはエクスプロイトを含むまたはインストールするもの、あるいは当社のプラットフォームをエクスプロイトを配信する (コマンドや管理システムの一部としてなど) 目的で使用するもの、または

- 特許、商標、企業秘密、パブリシティー権などの権利を含め、あらゆる当事者のあらゆる所有権を侵害するもの。

### 3. 行動の制限
「サービス」を利用する際は、いかなる場合においても以下のことを行わないものとします:

- 当社従業員、役員、代理店、その他ユーザを含む、あらゆる個人またはグループに対する嫌がらせ、罵倒、脅迫、または暴力の誘発、

- あらゆる自動化された過剰な大規模活動 (スパムや暗号通貨のマイニングなど) に当社サーバーを利用すること、自動化された手段により当社サーバーに不当な負荷を加えること、または当社サーバーを経由して、あらゆる未承諾広告や勧誘行為 (攻略法詐欺など) を中継すること、

- 当社サーバーを使用して、何らかのサービス、デバイス、データ、アカウントまたはネットワークを妨害するかあるいはこれを試みること、またはこれらに不正アクセスするかあるいはこれを試みること ([GitHub Bug Bounty program](https://bounty.github.com) により許可されている場合を除く)、

- GitHub との偽りの関係性を騙ること、悪用目的で自分の身分やサイトの目的を偽ることなどにより、当社従業員や代表者を含め、あらゆる個人や法人に成りすますこと、

- 他人の個人情報を同意なしに投稿するなどにより、あらゆる第三者のプライバシーを侵害すること。

### 4. サービス利用の制限
当社が書面により明示的に許可する場合を除き、「サービス」のいずれか一部、「サービス」の使用、または「サービス」へのアクセスを複製、複写、コピー、販売、再販売、または活用してはなりません。

### 5. スクレイピングおよび API 利用の制限
スクレイピングとは、ボットやウェブクローラーなどの自動的な処理により、当社「サービス」からデータを抽出することを指します。 API を介した情報の収集は指していません。 Please see Section H of our [Terms of Service](/articles/github-terms-of-service#h-api-terms) for our API Terms. 本ウェブサイトをスクレイピングできるのは次を理由とする場合のみです。

- 研究者は、公開された研究結果が自由にアクセスできる場合にのみ、非個人的なパブリック情報を「サービス」から研究目的でスクレイピングすることができます。
- アーキビストは、データを保管する目的で「サービス」のパブリックデータをスクレイピングすることができます。

(「[GitHub のプライバシーについての声明](/articles/github-privacy-statement)」の定義による) 「ユーザ個人情報」を、人事採用担当者、ヘッドハンター、求人掲示板などに販売する目的を含め、スパム目的で本「サービス」をスクレイピングすることはできません。

スクレイピングにより収集したデータの利用はすべて、「 [GitHub のプライバシーについての声明](/articles/github-privacy-statement)」に従う必要があります。

### 6. プライバシー
「ユーザ個人情報」の悪用は禁じられています

本「サービス」からデータを収集するあらゆる個人、法人、またはサービスは、特に「ユーザ個人情報」の収集に関して、「[GitHub のプライバシーについての声明](/articles/github-privacy-statement)」に従う必要があります。 「サービス」から何らかの「ユーザ個人情報」を収集する場合、あなたは「ユーザ」が承認した目的においてのみ「ユーザ個人情報」を利用することに同意するものとします。 あなたは、「サービス」から収集した、あらゆる「ユーザ個人情報」を合理的に保護することに同意するものとし、当社やその他ユーザからの苦情、削除要請、および連絡拒否の要請に速やかに対応するものとします。

### 7. 過剰な帯域の使用
「サービス」の帯域制限は、利用する機能によって異なります。 帯域の利用が、同類の機能の他のユーザと比較して過剰であると当社が判断した場合、帯域の消費を抑えられるまで、当社はお客様の「アカウント」を停止したり、ファイルのホスティングを抑制したりするなどしてアクティビティを制限する権利を留保します。 We also reserve the right—after providing advance notice—to delete repositories that we determine to be placing undue strain on our infrastructure. For guidance on acceptable use of object storage in repositories, refer to "[What is my disk quota?](/github/managing-large-files/what-is-my-disk-quota)". For more details on specific features' bandwidth limitations, see the [GitHub Additional Product Terms](/github/site-policy/github-additional-product-terms).

### 8. GitHubでの広告
**趣旨の要約:** *基本的に、当社は GitHub の広告としての利用を禁止していません。 しかし、GitHub がスパムの温床にならないよう、当社はユーザが特定の制限に従うことを期待します。 このような事態は誰も望まないからです。*

当社は、お客様が支持者の名前またはロゴをアカウントに掲載することによって自身の「コンテンツ」のプロモーションを行いたい場合があることを理解していますが、「アカウント」内あるいは「アカウント」を通して「サービス」へと投稿される「コンテンツ」の主な目的が広告またはプロモーション活動であってはなりません。 これには、「ページ」、「パッケージ」、リポジトリ、および「サービス」のその他一切の部分内か、またはこれを通じて投稿される「コンテンツ」が含まれます。 お客様の「アカウント」に関連する README ドキュメントまたはプロジェクト説明セクションに、静止画像、リンク、広告文を記載することはできますが、それは GitHub でホスティングしているプロジェクトに関連するものでなければなりません。 収益目的または過度に大きいコンテンツを Issue に投稿するなど、他の「ユーザ」の「アカウント」で広告を行うことはできません。

違法か、その他当社の[利用規約](/github/site-policy/github-terms-of-service/)、[コミュニティガイドライン](/github/site-policy/github-community-guidelines/)、もしくは[利用規定](/github/site-policy/github-acceptable-use-policies/)で禁止されているコンテンツもしくはアクティビティのプロモーションまたは配布を行うことがはできません。これには、自動化された過剰な大規模活動 (スパムなど)、攻略法詐欺、およびプロモーションに関連する不実表示または虚偽が含まれます。

「アカウント」に何らかの宣伝材料を投稿することを決めた場合、お客様はすべての適用される法令に従う責任を負うものとします。 この法令には、「推奨・証言に関する米国連邦取引委員会のガイドライン」が含まれますが、それに限定されません。 当社は、GitHub の何らかの規約またはポリシーに違反すると当社が独自に裁量した、一切の宣伝材料または広告を削除する権利を留保します。

### 9. GitHub におけるスパムおよび不正活動
GitHub では、スパム送信などの自動化された過剰な大規模活動および組織的な不正活動は禁止されています。 禁止活動には以下が含まれます。
* GitHub の規約およびポリシーによって禁止されているプロモーションおよび広告の大量配布
* 偽のアカウントや自動化された不正活動などの不正なインタラクション
* 自動化された Star 付けやフォローなどのランクの悪用
* 不正活動を拡散する目的でのセカンダリーマーケットの作成または参加
* 他のプラットフォームで悪用を伝播するためのプラットフォームとして GitHub を利用すること
* フィッシングまたはフィッシングの試み

GitHub は、本ポリシーに違反する一切の「コンテンツ」を削除する権利を留保します。

### 10. ユーザの保護
他のユーザを著しく害する行動をしてはなりません。 当社は、ユーザ全体の利益保護を優先して紛争を解決します。
