---
title: Organization のリポジトリ権限レベル
intro: Organization の各リポジトリに対するアクセスを、権限レベルを細かく設定することによりカスタマイズできます。これにより、ユーザが必要な機能やタスクにアクセスできるようになります。
redirect_from:
  - /articles/repository-permission-levels-for-an-organization-early-access-program/
  - /articles/repository-permission-levels-for-an-organization
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---

管理権限を持つ人は、Organization が所有するリポジトリに対する人およびチームのアクセスを管理できます。

### Organization が所有するリポジトリの権限レベル

Organization のメンバー、外部のコラボレータ、および Team に対して、Organization が所有するリポジトリに異なるレベルのアクセスを付与できます。 権限レベルごとに、リポジトリのコンテンツと設定へのアクセスが段階的に増加します。 プロジェクトにおける各人または各 Team のロールに相応しいレベルを選択し、プロジェクトに対して必要以上のアクセスを与えないようにしましょう。

以下のリストでは、Organization のリポジトリに対する権限レベルを、低いものから高いものに並べています:
- **Read**: プロジェクトを表示またはプロジェクトについてディスカッションしたい、コードを書かないコントリビューターにおすすめします{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.18" %}
- **Triage**: 書き込みアクセスなしに、Issue やプルリクエストを積極的に 管理したいコントリビューターにおすすめします{% endif %}
- **Write**: プロジェクトに積極的にプッシュしたいコントリビューターにおすすめします{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.18" %}
- **Maintain**: センシティブ、または破壊的なアクションにアクセスせずにリポジトリを管理する必要がある、プロジェクト管理者におすすめします{% endif %}
- **Admin**: セキュリティの管理やリポジトリの削除など、センシティブおよび破壊的なアクションを含めて、プロジェクトへの完全なアクセスが必要な人におすすめします

{% if currentVersion == "free-pro-team@latest" %}

{% endif %}

ユーザおよび Team にリポジトリへのアクセスを付与することに関する詳細は、「[Organization のリポジトリに対するアクセスを管理する](/articles/managing-access-to-your-organizations-repositories)」を参照してください。

Organizationのオーナーは、その Organization のリポジトリにアクセスするとき、Organization の全メンバーに適用される基本レベルの権限を設定できます。 詳しい情報については、「[Organization の基本レベル権限の設定](/github/setting-up-and-managing-organizations-and-teams/setting-base-permissions-for-an-organization#setting-base-permissions)」を参照してください。

また、Organization のオーナーは、Organization 全体にわたって、特定の設定およびアクセスをさらに制限することも選択できます。 特定の設定についてのオプションに関する詳細は、[Organization の設定を管理する](/articles/managing-organization-settings)」を参照してください。

Organization レベルの設定を管理することに加え、Organization のオーナは Organization が所有するすべてのリポジトリの管理者権限を持っています。 詳細は「[Organization の権限レベル](/articles/permission-levels-for-an-organization)」を参照してください。

{% warning %}

**警告:** 誰かがリポジトリにデプロイキーを追加すると、そのリポジトリに対しては、秘密鍵を持つユーザであれば (鍵の設定によっては) 誰でも読み取りや書き込みができます。そのユーザが後に Organization から削除されても同じです。

{% endwarning %}

### 各権限レベルが可能なリポジトリへのアクセス
{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.18" %}
| リポジトリアクション                                                                                                                                                                                                          | Read  | Triage | Write | Maintain |                                                                               Admin                                                                                |
|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |:-----:|:------:|:-----:|:--------:|:------------------------------------------------------------------------------------------------------------------------------------------------------------------:|
| 個人または Team の割り当てリポジトリからのプル                                                                                                                                                                                          | **X** | **X**  | **X** |  **X**   |                                                                               **X**                                                                                |
| 個人または Team の割り当てリポジトリのフォーク                                                                                                                                                                                          | **X** | **X**  | **X** |  **X**   |                                                                               **X**                                                                                |
| 自分のコメントの編集および削除                                                                                                                                                                                                     | **X** | **X**  | **X** |  **X**   |                                                                               **X**                                                                                |
| Issue のオープン                                                                                                                                                                                                         | **X** | **X**  | **X** |  **X**   |                                                                               **X**                                                                                |
| 自分でオープンした Issue のクローズ                                                                                                                                                                                               | **X** | **X**  | **X** |  **X**   |                                                                               **X**                                                                                |
| 自分でクローズした Issue を再オープン                                                                                                                                                                                              | **X** | **X**  | **X** |  **X**   |                                                                               **X**                                                                                |
| 自分に割り当てられた Issue の取得                                                                                                                                                                                                | **X** | **X**  | **X** |  **X**   |                                                                               **X**                                                                                |
| Team の割り当てリポジトリのフォークからのプルリクエストの送信                                                                                                                                                                                   | **X** | **X**  | **X** |  **X**   |                                                                               **X**                                                                                |
| プルリクエストについてのレビューのサブミット                                                                                                                                                                                              | **X** | **X**  | **X** |  **X**   |                                                                               **X**                                                                                |
| 公開済みリリースの表示                                                                                                                                                                                                         | **X** | **X**  | **X** |  **X**   |                                                              **X** |{% if currentVersion == "free-pro-team@latest" %}
| [[GitHub Actions workflow runs](/actions/automating-your-workflow-with-github-actions/managing-a-workflow-run)] の表示                                                                                                 | **X** | **X**  | **X** |  **X**   |                                                                         **X** |{% endif %}
| wiki の編集                                                                                                                                                                                                            | **X** | **X**  | **X** |  **X**   |                                                              **X** |{% if currentVersion == "free-pro-team@latest" %}
| [悪用あるいはスパムの可能性があるコンテンツのレポート](/articles/reporting-abuse-or-spam)                                                                                                                                                     | **X** | **X**  | **X** |  **X**   |                                                                         **X** |{% endif %}
| ラベルの適用                                                                                                                                                                                                              |       | **X**  | **X** |  **X**   |                                                                               **X**                                                                                |
| すべての Issue およびプルリクエストのクローズ、再オープン、割り当て                                                                                                                                                                               |       | **X**  | **X** |  **X**   |                                                                               **X**                                                                                |
| マイルストーンの適用                                                                                                                                                                                                          |       | **X**  | **X** |  **X**   |                                                                               **X**                                                                                |
| [重複した Issue とプルリクエスト](/articles/about-duplicate-issues-and-pull-requests)のマーク付け                                                                                                                                     |       | **X**  | **X** |  **X**   |                                                                               **X**                                                                                |
| [プルリクエストのレビュー](/articles/requesting-a-pull-request-review)の要求                                                                                                                                                       |       | **X**  | **X** |  **X**   |                                                                               **X**                                                                                |
| 個人または Team の割り当てリポジトリへのプッシュ (書き込み)                                                                                                                                                                                  |       |        | **X** |  **X**   |                                                                               **X**                                                                                |
| コミット、プルリクエスト、Issue についての他者によるコメントの編集と削除                                                                                                                                                                             |       |        | **X** |  **X**   |                                                                               **X**                                                                                |
| [他者によるコメントの非表示](/articles/managing-disruptive-comments)                                                                                                                                                             |       |        | **X** |  **X**   |                                                                               **X**                                                                                |
| [会話のロック](/articles/locking-conversations)                                                                                                                                                                           |       |        | **X** |  **X**   |                                               **X** |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.17" %}
| Issue の移譲 (詳細は「[他のリポジトリへ Issue を移譲する](/articles/transferring-an-issue-to-another-repository)」を参照)                                                                                                                   |       |        | **X** |  **X**   |                                                                         **X** |{% endif %}
| [リポジトリに指定されたコードオーナーとしてのアクション](/articles/about-code-owners)                                                                                                                                                          |       |        | **X** |  **X**   |                                                                               **X**                                                                                |
| [プルリクエストのドラフトに、レビューの準備ができたことを示すマークを付ける](/articles/changing-the-stage-of-a-pull-request)                                                                                                                             |       |        | **X** |  **X**   |                                               **X** |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.20" %}
| [プルリクエストをドラフトに変換する](/articles/changing-the-stage-of-a-pull-request)                                                                                                                                                 |       |        | **X** |  **X**   |                                                                         **X** |{% endif %}
| プルリクエストのマージ可能性に影響するレビューのサブミット                                                                                                                                                                                       |       |        | **X** |  **X**   |                                                                               **X**                                                                                |
| プルリクエストに[提案された変更を適用する](/articles/incorporating-feedback-in-your-pull-request)                                                                                                                                       |       |        | **X** |  **X**   |                                                                               **X**                                                                                |
| [ステータスチェック](/articles/about-status-checks)の作成                                                                                                                                                                       |       |        | **X** |  **X**   |                                                              **X** |{% if currentVersion == "free-pro-team@latest" %}
| Create, edit, run, re-run, and cancel [GitHub Actions workflows](/actions/automating-your-workflow-with-github-actions/)                                                                                            |       |        | **X** |  **X**   |                                                                         **X** |{% endif %}
| リリースの作成と編集                                                                                                                                                                                                          |       |        | **X** |  **X**   |                                                                               **X**                                                                                |
| ドラフトリリースの表示                                                                                                                                                                                                         |       |        | **X** |  **X**   |                                                                               **X**                                                                                |
| リポジトリの説明の編集                                                                                                                                                                                                         |       |        |       |  **X**   |                                                              **X** |{% if currentVersion == "free-pro-team@latest" %}
| [View and install packages](/packages/publishing-and-managing-packages)                                                                                                                                             | **X** | **X**  | **X** |  **X**   |                                                                               **X**                                                                                |
| [Publish packages](/packages/publishing-and-managing-packages/publishing-a-package)                                                                                                                                 |       |        | **X** |  **X**   |                                                                               **X**                                                                                |
| [Delete packages](/packages/publishing-and-managing-packages/deleting-a-package)                                                                                                                                    |       |        |       |          |                                                                               **X**                                                                                |{% endif %}
| [Topics](/articles/classifying-your-repository-with-topics) の管理                                                                                                                                                     |       |        |       |  **X**   |                                                                               **X**                                                                                |
| Wiki の有効化および Wiki 編集者の制限                                                                                                                                                                                            |       |        |       |  **X**   |                                                                               **X**                                                                                |
| プロジェクトボードの有効化                                                                                                                                                                                                       |       |        |       |  **X**   |                                                                               **X**                                                                                |
| [プルリクエストのマージ](/articles/configuring-pull-request-merges)の設定                                                                                                                                                         |       |        |       |  **X**   |                                                                               **X**                                                                                |
| [{% data variables.product.prodname_pages %} の公開ソース](/articles/configuring-a-publishing-source-for-github-pages)の設定                                                                                            |       |        |       |  **X**   |                                                                               **X**                                                                                |
| [保護されたブランチへのプッシュ](/articles/about-protected-branches)                                                                                                                                                               |       |        |       |  **X**   |                                                                               **X**                                                                                |
| [リポジトリソーシャルカードの作成と編集](/articles/customizing-your-repositorys-social-media-preview)                                                                                                                                  |       |        |       |  **X**   |                                                              **X** |{% if currentVersion == "free-pro-team@latest" %}
| [リポジトリでのインタラクション](/github/building-a-strong-community/limiting-interactions-in-your-repository)を制限する                                                                                                                |       |        |       |  **X**   |                                                                         **X** |{% endif %}
| Issue の削除 (「[Issue を削除する](/articles/deleting-an-issue)」を参照)                                                                                                                                                         |       |        |       |          |                                                                               **X**                                                                                |
| 保護されたブランチでのプルリクエストのマージ（レビューの承認がなくても）                                                                                                                                                                                |       |        |       |          |                                                                               **X**                                                                                |
| [リポジトリのコードオーナーの定義](/articles/about-code-owners)                                                                                                                                                                     |       |        |       |          |                                                                               **X**                                                                                |
| リポジトリを Team に追加する (詳細は「[Organization リポジトリへの Team のアクセスを管理する](/github/setting-up-and-managing-organizations-and-teams/managing-team-access-to-an-organization-repository#giving-a-team-access-to-a-repository)」を参照) |       |        |       |          |                                                                               **X**                                                                                |
| [外部のコラボレータのリポジトリへのアクセスの管理](/articles/adding-outside-collaborators-to-repositories-in-your-organization)                                                                                                             |       |        |       |          |                                                                               **X**                                                                                |
| [リポジトリの可視性の変更](/articles/restricting-repository-visibility-changes-in-your-organization)                                                                                                                            |       |        |       |          |                                               **X** |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.17" %}
| リポジトリのテンプレート化 (「[テンプレートリポジトリを作成する](/articles/creating-a-template-repository)」を参照)                                                                                                                                   |       |        |       |          |                                                                         **X** |{% endif %}
| リポジトリ設定の変更                                                                                                                                                                                                          |       |        |       |          |                                                                               **X**                                                                                |
| Team およびコラボレータのリポジトリへのアクセス管理                                                                                                                                                                                        |       |        |       |          |                                                                               **X**                                                                                |
| リポジトリのデフォルトブランチ編集                                                                                                                                                                                                   |       |        |       |          |                                                                               **X**                                                                                |
| Webhookおよびデプロイキーの管理                                                                                                                                                                                                 |       |        |       |          |                                                              **X** |{% if currentVersion == "free-pro-team@latest" %}
| プライベートリポジトリの[依存関係グラフの有効化](/github/visualizing-repository-data-with-graphs/exploring-the-dependencies-and-dependents-of-a-repository)                                                                                |       |        |       |          |                                                                               **X**                                                                                |
| リポジトリでの[脆弱性のある依存関係に対する{% data variables.product.prodname_dependabot_alerts %}](/github/managing-security-vulnerabilities/about-alerts-for-vulnerable-dependencies)を受信                                        |       |        |       |          |                                                                               **X**                                                                                |
| [{% data variables.product.prodname_dependabot_alerts %} を閉じる](/github/managing-security-vulnerabilities/viewing-and-updating-vulnerable-dependencies-in-your-repository)                                    |       |        |       |          |                                                                               **X**                                                                                |
| 脆弱な依存関係についての[{% data variables.product.prodname_dependabot_alerts %}を受信する個人または Team の追加指定](/github/administering-a-repository/managing-security-and-analysis-settings-for-your-repository)                   |       |        |       |          |                                                                               **X**                                                                                |
| [プライベートリポジトリ用のデータ利用設定を管理する](/github/understanding-how-github-uses-and-protects-your-data/managing-data-use-settings-for-your-private-repository)                                                                    |       |        |       |          | **X** |{% endif %}{% if currentVersion == "free-pro-team@latest" %}| [セキュリティアドバイザリ](/github/managing-security-vulnerabilities/about-github-security-advisories)の作成 | | | | | **X** |{% endif %}
| [リポジトリのフォークポリシーを管理する](/github/administering-a-repository/managing-the-forking-policy-for-your-repository)                                                                                                           |       |        |       |          |                                                                               **X**                                                                                |
| [リポジトリの Organization への移譲](/articles/restricting-repository-creation-in-your-organization)                                                                                                                          |       |        |       |          |                                                                               **X**                                                                                |
| [リポジトリの削除または Organization 外への移譲](/articles/setting-permissions-for-deleting-or-transferring-repositories)                                                                                                           |       |        |       |          |                                                                               **X**                                                                                |
| [リポジトリのアーカイブ](/articles/about-archiving-repositories)                                                                                                                                                               |       |        |       |          |                                                              **X** |{% if currentVersion == "free-pro-team@latest" %}
| スポンサーボタンの表示 (「[リポジトリにスポンサーボタンを表示する](/articles/displaying-a-sponsor-button-in-your-repository)」を参照)                                                                                                                  |       |        |       |          |                                         **X** |{% endif %}{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.18" %}
| JIRA や Zendesk などの外部リソースに対する自動リンク参照を作成します (「[外部リソースを参照する自動リンクの設定](/articles/configuring-autolinks-to-reference-external-resources)」を参照)。                                                                            |       |        |       |          |                                                                         **X** |{% endif %}

{% else %}

| リポジトリアクション                                                                                                                                                                                                                                    | Read 権限 | Write 権限 |                                Admin 権限                                |
|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |:-------:|:--------:|:----------------------------------------------------------------------:|
| 個人または Team の割り当てリポジトリからのプル (読み取り)                                                                                                                                                                                                             |  **X**  |  **X**   |                                 **X**                                  |
| 個人または Team の割り当てリポジトリのフォーク (コピー)                                                                                                                                                                                                              |  **X**  |  **X**   |                                 **X**                                  |
| コミット、プルリクエスト、Issue についての自分によるコメントの編集と削除                                                                                                                                                                                                       |  **X**  |  **X**   |                                 **X**                                  |
| Issue のオープン                                                                                                                                                                                                                                   |  **X**  |  **X**   |                                 **X**                                  |
| 自分でオープンした Issue のクローズ                                                                                                                                                                                                                         |  **X**  |  **X**   |                                 **X**                                  |
| 自分でクローズした Issue を再オープン                                                                                                                                                                                                                        |  **X**  |  **X**   |                                 **X**                                  |
| 自分に割り当てられた Issue の取得                                                                                                                                                                                                                          |  **X**  |  **X**   |                                 **X**                                  |
| Team の割り当てリポジトリのフォークからのプルリクエストの送信                                                                                                                                                                                                             |  **X**  |  **X**   |                                 **X**                                  |
| プルリクエストについてのレビューのサブミット                                                                                                                                                                                                                        |  **X**  |  **X**   |                                 **X**                                  |
| 公開済みリリースの表示                                                                                                                                                                                                                                   |  **X**  |  **X**   |                                 **X**                                  |
| wiki の編集                                                                                                                                                                                                                                      |  **X**  |  **X**   |                **X** |{% if currentVersion == "free-pro-team@latest" %}
| [悪用あるいはスパムの可能性があるコンテンツのレポート](/articles/reporting-abuse-or-spam)                                                                                                                                                                               |  **X**  |  **X**   |                           **X** |{% endif %}
| 個人または Team の割り当てリポジトリへのプッシュ (書き込み)                                                                                                                                                                                                            |         |  **X**   |                                 **X**                                  |
| コミット、プルリクエスト、Issue についての他者によるコメントの編集と削除                                                                                                                                                                                                       |         |  **X**   |                                 **X**                                  |
| [他者によるコメントの非表示](/articles/managing-disruptive-comments)                                                                                                                                                                                       |         |  **X**   |                                 **X**                                  |
| [会話のロック](/articles/locking-conversations)                                                                                                                                                                                                     |         |  **X**   |                                 **X**                                  |
| ラベルとマイルストーンの適用                                                                                                                                                                                                                                |         |  **X**   |                                 **X**                                  |
| すべての Issue のクローズ、再オープン、割り当て                                                                                                                                                                                                                   |         |  **X**   |                **X** |{% if currentVersion == "free-pro-team@latest" %}
| [重複した Issue とプルリクエスト](/articles/about-duplicate-issues-and-pull-requests)のマーク付け                                                                                                                                                               |         |  **X**   |                           **X** |{% endif %}
| [リポジトリに指定されたコードオーナーとしてのアクション](/articles/about-code-owners)                                                                                                                                                                                    |         |  **X**   |                                 **X**                                  |
| [プルリクエストのドラフトに、レビューの準備ができたことを示すマークを付ける](/articles/changing-the-stage-of-a-pull-request)                                                                                                                                                       |         |  **X**   |                                 **X**                                  |
| [プルリクエストのレビュー](/articles/requesting-a-pull-request-review)の要求                                                                                                                                                                                 |         |  **X**   |                                 **X**                                  |
| プルリクエストのマージ可能性に影響するレビューのサブミット                                                                                                                                                                                                                 |         |  **X**   |                                 **X**                                  |
| プルリクエストに対して提案された変更の適用（詳細については「[プルリクエストでのフィードバックを取り込む](/articles/incorporating-feedback-in-your-pull-request)」を参照）                                                                                                                             |         |  **X**   |                                 **X**                                  |
| [ステータスチェック](/articles/about-status-checks)の作成                                                                                                                                                                                                 |         |  **X**   |                                 **X**                                  |
| リリースの作成と編集                                                                                                                                                                                                                                    |         |  **X**   |                                 **X**                                  |
| ドラフトリリースの表示                                                                                                                                                                                                                                   |         |  **X**   |                                 **X**                                  |
| Issue の削除 (「[Issue を削除する](/articles/deleting-an-issue)」を参照)                                                                                                                                                                                   |         |          |                                 **X**                                  |
| 保護されたブランチでのプルリクエストのマージ（レビューの承認がなくても）                                                                                                                                                                                                          |         |          |                                 **X**                                  |
| [リポジトリのコードオーナーの定義](/articles/about-code-owners)                                                                                                                                                                                               |         |          |                                 **X**                                  |
| リポジトリの説明の編集                                                                                                                                                                                                                                   |         |          |                                 **X**                                  |
| [Topics](/articles/classifying-your-repository-with-topics) の管理                                                                                                                                                                               |         |          | **X** |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.17" %}
| リポジトリソーシャルカードの作成および編集 (詳細については「[リポジトリのソーシャルメディア向けプレビューをカスタマイズする](/articles/customizing-your-repositorys-social-media-preview)」を参照)                                                                                                            |         |          |                           **X** |{% endif %}
| リポジトリを Team に追加する (詳細は「[Organization リポジトリへの Team のアクセスを管理する](/github/setting-up-and-managing-organizations-and-teams/managing-team-access-to-an-organization-repository#giving-a-team-access-to-a-repository)」を参照)                           |         |          |                                 **X**                                  |
| 外部のコラボレータのリポジトリへのアクセスの管理 (詳細については「[外部のコラボレータを Organization のリポジトリに追加する](/articles/adding-outside-collaborators-to-repositories-in-your-organization)」を参照)                                                                                     |         |          |                **X** |{% if currentVersion == "free-pro-team@latest" %}
| [リポジトリでのインタラクション](/github/building-a-strong-community/limiting-interactions-in-your-repository)を制限する                                                                                                                                          |         |          |                           **X** |{% endif %}
| リポジトリの可視性の変更（詳細については「[Organization 内でリポジトリの可視性の変更を制限する](/articles/restricting-repository-visibility-changes-in-your-organization)」を参照）                                                                                                        |         |          | **X** |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.17" %}
| リポジトリのテンプレート化 (「[テンプレートリポジトリを作成する](/articles/creating-a-template-repository)」を参照)                                                                                                                                                             |         |          |                         | | **X** |{% endif %}
| リポジトリ設定の変更                                                                                                                                                                                                                                    |         |          |                                 **X**                                  |
| Team およびコラボレータのリポジトリへのアクセス管理                                                                                                                                                                                                                  |         |          |                                 **X**                                  |
| リポジトリのデフォルトブランチ編集                                                                                                                                                                                                                             |         |          |                                 **X**                                  |
| Webhookおよびデプロイキーの管理                                                                                                                                                                                                                           |         |          |                **X** |{% if currentVersion == "free-pro-team@latest" %}
| プライベートリポジトリの[依存関係グラフの有効化](/github/visualizing-repository-data-with-graphs/exploring-the-dependencies-and-dependents-of-a-repository)                                                                                                          |         |          |                                 **X**                                  |
| リポジトリでの[脆弱性のある依存関係に対する{% data variables.product.prodname_dependabot_alerts %}](/github/managing-security-vulnerabilities/about-alerts-for-vulnerable-dependencies)を受信                                                                  |         |          |                                 **X**                                  |
| [{% data variables.product.prodname_dependabot_alerts %} を閉じる](/github/managing-security-vulnerabilities/viewing-and-updating-vulnerable-dependencies-in-your-repository)                                                              |         |          |                                 **X**                                  |
| 脆弱な依存関係についての[{% data variables.product.prodname_dependabot_alerts %}を受信する個人または Team の追加指定](/github/administering-a-repository/managing-security-and-analysis-settings-for-your-repository#granting-access-to-github-dependabot-alerts) |         |          |                                 **X**                                  |
| [プライベートリポジトリ用のデータ利用設定を管理する](/github/understanding-how-github-uses-and-protects-your-data/managing-data-use-settings-for-your-private-repository)                                                                                              |         |          |          **X** |{% endif %}{% if currentVersion == "free-pro-team@latest" %}
| [セキュリティアドバイザリ](/github/managing-security-vulnerabilities/about-github-security-advisories)の作成")                                                                                                                                               |         |          |                                 **X**                                  |{% endif %}
| [リポジトリのフォークポリシーを管理する](/github/administering-a-repository/managing-the-forking-policy-for-your-repository)                                                                                                                                     |         |          |                                 **X**                                  |
| リポジトリの Organization アカウントへの移譲（詳細については［[Organization 内でリポジトリの作成を制限する](/articles/restricting-repository-creation-in-your-organization)」を参照）                                                                                                     |         |          |                                 **X**                                  |
| リポジトリの削除や移譲 (詳細については「[Organization のリポジトリを削除や移譲する権限を設定する](/articles/setting-permissions-for-deleting-or-transferring-repositories)」を参照)                                                                                                       |         |          |                                 **X**                                  |
| [リポジトリのアーカイブ](/articles/about-archiving-repositories)                                                                                                                                                                                         |         |          |                                 **X**                                  |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.18" %}
| JIRA または Zendesk など外部リソースへの自動リンク参照を作成する (「[外部リソースを参照する自動リンクの設定](/articles/configuring-autolinks-to-reference-external-resources)」を参照)                                                                                                         |         |          |                         | | **X** |{% endif %}

{% endif %}

### 参考リンク

- "[Organization のリポジトリへのアクセスを管理する](/articles/managing-access-to-your-organization-s-repositories)"
- [外部コラボレーターを Organization のリポジトリに追加する](/articles/adding-outside-collaborators-to-repositories-in-your-organization)
- [Organization のプロジェクトボード権限](/articles/project-board-permissions-for-an-organization)
