---
title: Organization の権限レベル
intro: '[Organizationを作成](/articles/creating-a-new-organization-account)したら、Organization アカウントを管理する少人数グループにオーナー権限を付与する必要があります。'
redirect_from:
  - /articles/permission-levels-for-an-organization-early-access-program/
  - /articles/permission-levels-for-an-organization
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---

### Organization の権限レベル

Organization のメンバーは、*owner (オーナー)*{% if currentVersion == "free-pro-team@latest" %}、*billing manager (支払いマネージャー)*、{% endif %}あるいは *member (メンバー)* ロールを持つことができます。

- **オーナー**は、Organization について完全な管理アクセスを持ちます。 このロールは制限する必要がありますが、Organization で少なくとも 2 人は指定する必要があります。 詳細は、「[Organization の所有権の継続性を管理する](/github/setting-up-and-managing-organizations-and-teams/maintaining-ownership-continuity-for-your-organization)」を参照してください。
{% if currentVersion == "free-pro-team@latest" %}
- **支払いマネージャー**は、個人に支払い設定の管理を許可できます。 詳細は「[Organization に支払いマネージャーを追加する](/articles/adding-a-billing-manager-to-your-organization)」を参照してください。
{% endif %}
- **メンバー**は、それ以外のユーザのデフォルトのロールです。

{% if currentVersion == "free-pro-team@latest" %}
<!--Dotcom version has extra column for Billing managers-->

| Organization のアクション                                                                                                                                                                                                                                                                                                                                                        | オーナー  | メンバー  |             支払いマネージャー              |
|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |:-----:|:-----:|:----------------------------------:|
| リポジトリの作成 (詳細については「[Organization 内でリポジトリの作成を制限する](/articles/restricting-repository-creation-in-your-organization)」を参照)                                                                                                                                                                                                                                                      | **X** | **X** |                                    |
| 支払い情報を表示および編集する                                                                                                                                                                                                                                                                                                                                                            | **X** |       |               **X**                |
| Organization に参加するようユーザを招待する                                                                                                                                                                                                                                                                                                                                               | **X** |       |                                    |
| Organization に参加する招待を編集およびキャンセルする                                                                                                                                                                                                                                                                                                                                          | **X** |       |                                    |
| Organization からメンバーを削除する                                                                                                                                                                                                                                                                                                                                                   | **X** |       |                                    |
| 以前のメンバーを Oraganization に復帰させる                                                                                                                                                                                                                                                                                                                                              | **X** |       |                                    |
| **すべての Team** に対してユーザーを追加および削除する                                                                                                                                                                                                                                                                                                                                           | **X** |       |                                    |
| Organization メンバーを*チームメンテナ*に昇格させる                                                                                                                                                                                                                                                                                                                                          | **X** |       |                                    |
| コードレビューの割り当てを設定する ([「Team のコードレビューの割り当てを管理する」](/github/setting-up-and-managing-organizations-and-teams/managing-code-review-assignment-for-your-team)を参照)                                                                                                                                                                                                                  | **X** |       |                                    |
| スケジュールされたリマインダーを設定する (「[プルリクエストのスケジュールされたリマインダーを管理する](/github/setting-up-and-managing-organizations-and-teams/managing-scheduled-reminders-for-pull-requests)」を参照)                                                                                                                                                                                                         | **X** |       |                                    |
| **すべてのリポジトリに**コラボレーターを追加する                                                                                                                                                                                                                                                                                                                                                 | **X** |       |                                    |
| Organization 参加ログにアクセスする                                                                                                                                                                                                                                                                                                                                                   | **X** |       |                                    |
| Organization のプロフィールページを変更する (詳細は「[Organization のプロフィールについて](/articles/about-your-organization-s-profile)」を参照)                                                                                                                                                                                                                                                             | **X** |       |                                    |
| Organization のドメインを検証する (詳細は「[Organization のドメインを検証する](/articles/verifying-your-organization-s-domain)」を参照)                                                                                                                                                                                                                                                                | **X** |       |                                    |
| **すべての Team** を削除する                                                                                                                                                                                                                                                                                                                                                        | **X** |       |                                    |
| すべてのリポジトリを含めて Organization のアカウントを削除する                                                                                                                                                                                                                                                                                                                                     | **X** |       |                                    |
| Team を作成する (詳細は「[Organization のチーム作成権限を設定する](/articles/setting-team-creation-permissions-in-your-organization)」を参照)                                                                                                                                                                                                                                                        | **X** | **X** |                                    |
| [Organization の階層で Team を移動する](/articles/moving-a-team-in-your-organization-s-hierarchy)                                                                                                                                                                                                                                                                                   | **X** |       |                                    |
| プロジェクトボードを作成する (詳細は「[Organization のプロジェクトボード権限](/articles/project-board-permissions-for-an-oganization)」を参照)                                                                                                                                                                                                                                                               | **X** | **X** |                                    |
| Organization の全メンバーおよび Team の表示                                                                                                                                                                                                                                                                                                                                            | **X** | **X** |                                    |
| 参照可能なチームへの @メンション                                                                                                                                                                                                                                                                                                                                                          | **X** | **X** |                                    |
| *チームメンテナ*に指定できる                                                                                                                                                                                                                                                                                                                                                            | **X** | **X** |                                    |
| Organization のインサイトを表示する (詳細は「[Organization のインサイトを表示する](/articles/viewing-insights-for-your-organization)」を参照)                                                                                                                                                                                                                                                            | **X** | **X** |                                    |
| パブリック Team のディスカッションを表示し、**すべての Team** に投稿する (詳細は「[Team ディスカッションについて](/articles/about-team-discussions)」を参照)                                                                                                                                                                                                                                                               | **X** | **X** |                                    |
| プライベート Team のディスカッションを表示し、**すべての Team** に投稿する (詳細は「[Team ディスカッションについて](/articles/about-team-discussions)」を参照)                                                                                                                                                                                                                                                              | **X** |       |                                    |
| **すべての Team** で Team ディスカッションを編集および削除する (詳細は「[混乱を生むコメントを管理する](/articles/managing-disruptive-comments)」を参照)                                                                                                                                                                                                                                                                 | **X** |       |                                    |
| コミット、プルリクエスト、Issue についてコメントを非表示にする (詳細は「[混乱を生むコメントを管理する](/articles/managing-disruptive-comments)」を参照)                                                                                                                                                                                                                                                                      | **X** | **X** |                                    |
| Organization の Team ディスカッションを無効にする (詳細は「[Organization の Team ディスカッションを無効化する](/articles/disabling-team-discussions-for-your-organization)」を参照)                                                                                                                                                                                                                              | **X** |       | |{% if currentVersion == "free-pro-team@latest" %}
| Organization dependency insights の可視性を管理する (詳細は「[Organization dependency insights の可視性を変更する](/articles/changing-the-visibility-of-your-organizations-dependency-insights)」を参照)                                                                                                                                                                                             | **X** |       |            |{% endif %}
| **すべての Team** で Team プロフィール画像を設定する (詳細は「[Team のプロフィール画像を設定する](/articles/setting-your-team-s-profile-picture)」を参照)                                                                                                                                                                                                                                                          | **X** |       |                                    |
| Disable publication of {% data variables.product.prodname_pages %} sites from repositories in the organization (see "[Disabling publication of {% data variables.product.prodname_pages %} sites for your organization](/github/setting-up-and-managing-organizations-and-teams/disabling-publication-of-github-pages-sites-for-your-organization)" for details) | **X** |       |                                    |
| Organization のセキュリティおよび分析設定を管理する (詳細は「[Organization のセキュリティおよび分析設定を管理する](/github/setting-up-and-managing-organizations-and-teams/managing-security-and-analysis-settings-for-your-organization)」を参照)                                                                                                                                                                       | **X** |       |                                    |
| [SAML シングルサインオン](/articles/about-identity-and-access-management-with-saml-single-sign-on)を有効にして強制する                                                                                                                                                                                                                                                                        | **X** |       |                                    |
| [組織へのユーザーの SAML アクセスを管理する](/github/setting-up-and-managing-organizations-and-teams/viewing-and-managing-a-members-saml-access-to-your-organization)                                                                                                                                                                                                                        | **X** |       |                                    |
| Organization の SSH 認証局を管理する (詳細は「[Organization の SSH 認証局を管理する](/articles/managing-your-organizations-ssh-certificate-authorities)」を参照)                                                                                                                                                                                                                                     | **X** |       |                                    |
| リポジトリを移譲する                                                                                                                                                                                                                                                                                                                                                                 | **X** |       |                                    |
| {% data variables.product.prodname_marketplace %} アプリケーションを購入、インストール、支払い管理、キャンセルする                                                                                                                                                                                                                                                                                    | **X** |       |                                    |
| {% data variables.product.prodname_marketplace %} のアプリケーションをリストする                                                                                                                                                                                                                                                                                                     | **X** |       |                                    |
| Organization のリポジトリすべてについて、脆弱な依存関係についての [{% data variables.product.prodname_dependabot_alerts %}](/github/managing-security-vulnerabilities/about-alerts-for-vulnerable-dependencies) アラートを受け取る                                                                                                                                                                     | **X** |       |                                    |
| {% data variables.product.prodname_dependabot_security_updates %} の管理 (「[{% data variables.product.prodname_dependabot_security_updates %} の設定](/github/managing-security-vulnerabilities/configuring-github-dependabot-security-updates)」を参照)                                                                                                               | **X** |       |                                    |
| [フォークポリシーの管理](/github/setting-up-and-managing-organizations-and-teams/managing-the-forking-policy-for-your-organization)                                                                                                                                                                                                                                                   | **X** |       |                                    |
| [Organization のパブリックリポジトリでのアクティビティを制限する](/articles/limiting-interactions-in-your-organization)                                                                                                                                                                                                                                                                             | **X** |       |                                    |
| Organization にある*すべてのリポジトリ*のプル (読み取り)、プッシュ (書き込み)、クローン作成 (コピー)                                                                                                                                                                                                                                                                                                             | **X** |       |                                    |
| Organization メンバーの[外部コラボレーター](#outside-collaborators)への変換                                                                                                                                                                                                                                                                                                                  | **X** |       |                                    |
| [Organization リポジトリへのアクセス権がある人を表示する](/articles/viewing-people-with-access-to-your-repository)                                                                                                                                                                                                                                                                              | **X** |       |                                    |
| [Organization リポジトリへのアクセス権がある人のリストをエクスポートする](/articles/viewing-people-with-access-to-your-repository/#exporting-a-list-of-people-with-access-to-your-repository)                                                                                                                                                                                                           | **X** |       |                                    |
| デフォルトラベルの管理 (「[Organization 内のリポジトリのためのデフォルトラベルを管理する](/articles/managing-default-labels-for-repositories-in-your-organization)」を参照)                                                                                                                                                                                                                                        | **X** |       |                                    |
| Team の同期を有効化する (「[Organization の Team 同期を管理する](/github/setting-up-and-managing-organizations-and-teams/managing-team-synchronization-for-your-organization)」を参照)                                                                                                                                                                                                           | **X** |       |                                    |

{% else %}
<!--GHE version doesn't have the extra column for Billing managers-->

| Organization のアクション                                                                                                                                                                                                                                                                                                                                                        | オーナー  |                  メンバー                   |
|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |:-----:|:---------------------------------------:|
| Organization に参加するようユーザを招待する                                                                                                                                                                                                                                                                                                                                               | **X** |                                         |
| Organization に参加する招待を編集およびキャンセルする                                                                                                                                                                                                                                                                                                                                          | **X** |                                         |
| Organization からメンバーを削除する                                                                                                                                                                                                                                                                                                                                                   | **X** |                    |                    |
| 以前のメンバーを Oraganization に復帰させる                                                                                                                                                                                                                                                                                                                                              | **X** |                    |                    |
| **すべての Team** に対してユーザーを追加および削除する                                                                                                                                                                                                                                                                                                                                           | **X** |                                         |
| Organization メンバーを*チームメンテナ*に昇格させる                                                                                                                                                                                                                                                                                                                                          | **X** |  |{% if currentVersion ver_gt "enterprise-server@2.19" %}
| コードレビューの割り当てを設定する ([「Team のコードレビューの割り当てを管理する」](/github/setting-up-and-managing-organizations-and-teams/managing-code-review-assignment-for-your-team)を参照)                                                                                                                                                                                                                  | **X** |              |{% endif %}
| **すべてのリポジトリに**コラボレーターを追加する                                                                                                                                                                                                                                                                                                                                                 | **X** |                                         |
| Organization 参加ログにアクセスする                                                                                                                                                                                                                                                                                                                                                   | **X** |                                         |
| Organization のプロフィールページを変更する (詳細は「[Organization のプロフィールについて](/articles/about-your-organization-s-profile)」を参照)                                                                                                                                                                                                                                                             | **X** |                    |                    |
| **すべての Team** を削除する                                                                                                                                                                                                                                                                                                                                                        | **X** |                                         |
| すべてのリポジトリを含めて Organization のアカウントを削除する                                                                                                                                                                                                                                                                                                                                     | **X** |                                         |
| Team を作成する (詳細は「[Organization のチーム作成権限を設定する](/articles/setting-team-creation-permissions-in-your-organization)」を参照)                                                                                                                                                                                                                                                        | **X** |                  **X**                  |
| Organization の全メンバーおよび Team の表示                                                                                                                                                                                                                                                                                                                                            | **X** |                  **X**                  |
| 参照可能なチームへの @メンション                                                                                                                                                                                                                                                                                                                                                          | **X** |                  **X**                  |
| *チームメンテナ*に指定できる                                                                                                                                                                                                                                                                                                                                                            | **X** |                  **X**                  |
| リポジトリを移譲する                                                                                                                                                                                                                                                                                                                                                                 | **X** |  |{% if currentVersion ver_gt "enterprise-server@2.18" %}
| Organization の SSH 認証局を管理する (詳細は「[Organization の SSH 認証局を管理する](/articles/managing-your-organizations-ssh-certificate-authorities)」を参照)                                                                                                                                                                                                                                     | **X** |              |{% endif %}
| プロジェクトボードを作成する (詳細は「[Organization のプロジェクトボード権限](/articles/project-board-permissions-for-an-oganization)」を参照)                                                                                                                                                                                                                                                               | **X** |                 **X** |                 |
| パブリック Team のディスカッションを表示し、**すべての Team** に投稿する (詳細は「[Team ディスカッションについて](/articles/about-team-discussions)」を参照)                                                                                                                                                                                                                                                               | **X** |                 **X** |                 |
| プライベート Team のディスカッションを表示し、**すべての Team** に投稿する (詳細は「[Team ディスカッションについて](/articles/about-team-discussions)」を参照)                                                                                                                                                                                                                                                              | **X** |                    |                    |
| **すべての Team** で Team ディスカッションを編集および削除する (「[混乱を生むコメントを管理する](/articles/managing-disruptive-comments)」を参照)                                                                                                                                                                                                                                                                    | **X** |                    |                    |
| コミット、プルリクエスト、Issue についてコメントを非表示にする (詳細は「[混乱を生むコメントを管理する](/articles/managing-disruptive-comments)」を参照)                                                                                                                                                                                                                                                                      | **X** |              **X** | **X**              |
| Organization の Team ディスカッションを無効にする (詳細は「[Organization の Team ディスカッションを無効化する](/articles/disabling-team-discussions-for-your-organization)」を参照)                                                                                                                                                                                                                              | **X** |                    |                    |
| **すべての Team** で Team プロフィール画像を設定する (詳細は「[Team のプロフィール画像を設定する](/articles/setting-your-team-s-profile-picture)」を参照)                                                                                                                                                                                                                                                          | **X** | |  |{% if currentVersion ver_gt "enterprise-server@2.22" %}
| Disable publication of {% data variables.product.prodname_pages %} sites from repositories in the organization (see "[Disabling publication of {% data variables.product.prodname_pages %} sites for your organization](/github/setting-up-and-managing-organizations-and-teams/disabling-publication-of-github-pages-sites-for-your-organization)" for details) | **X** |             | |{% endif %}
| [Organization の階層で Team を移動する](/articles/moving-a-team-in-your-organization-s-hierarchy)                                                                                                                                                                                                                                                                                   | **X** |                    |                    |
| Organization にある*すべてのリポジトリ*のプル (読み取り)、プッシュ (書き込み)、クローン作成 (コピー)                                                                                                                                                                                                                                                                                                             | **X** |                                         |
| Organization メンバーの[外部コラボレーター](#outside-collaborators)への変換                                                                                                                                                                                                                                                                                                                  | **X** |                                         |
| [Organization リポジトリへのアクセス権がある人を表示する](/articles/viewing-people-with-access-to-your-repository)                                                                                                                                                                                                                                                                              | **X** |                                         |
| [Organization リポジトリへのアクセス権がある人のリストをエクスポートする](/articles/viewing-people-with-access-to-your-repository/#exporting-a-list-of-people-with-access-to-your-repository)                                                                                                                                                                                                           | **X** |  |{% if currentVersion ver_gt "enterprise-server@2.19" %}
| デフォルトラベルの管理 (「[Organization 内のリポジトリのためのデフォルトラベルを管理する](/articles/managing-default-labels-for-repositories-in-your-organization)」を参照)                                                                                                                                                                                                                                        | **X** |              |{% endif %}

{% endif %}

### {% data variables.product.prodname_github_app %} マネージャー

By default, only organization owners can manage the settings of {% data variables.product.prodname_github_app %}s owned by an organization. To allow additional users to manage {% data variables.product.prodname_github_app %}s owned by an organization, an owner can grant them {% data variables.product.prodname_github_app %} manager permissions.

When you designate a user as a {% data variables.product.prodname_github_app %} manager in your organization, you can grant them access to manage the settings of some or all {% data variables.product.prodname_github_app %}s owned by the organization. 詳しい情報については、以下を参照してください。

- [GitHub App マネージャーを Organization に追加する](/articles/adding-github-app-managers-in-your-organization)
- [GitHub App マネージャーを Organization から削除する](/articles/removing-github-app-managers-from-your-organization)

### 外部コラボレーター

リポジトリへのアクセスを許可している間、Organization を安全に保つために、*外部コラボレーター*を追加することができます。 {% data reusables.organizations.outside_collaborators_description %}

### 参考リンク

- [Organization のリポジトリ権限レベル](/articles/repository-permission-levels-for-an-organization)
- [Team について](/articles/about-teams)
- [Organization のプロジェクトボード権限](/articles/project-board-permissions-for-an-organization)
