---
title: 一時的なプライベートフォークで、セキュリティ脆弱性を解決するためにコラボレートする
intro: リポジトリにおけるセキュリティ脆弱性の修正について非公開でコラボレートするため、一時的なプライベートフォークを作成できます。
redirect_from:
  - /articles/collaborating-in-a-temporary-private-fork-to-resolve-a-security-vulnerability
versions:
  free-pro-team: '*'
---

### 必要な環境

一時的なプライベートフォークでコラボレートする前に、ドラフトのセキュリティアドバイザリを作成する必要があります。 詳しい情報については、「[セキュリティアドバイザリを作成する](/github/managing-security-vulnerabilities/creating-a-security-advisory)」を参照してください。

### 一時的なプライベートフォークを作成する

セキュリティアドバイザリに対する管理者権限があるユーザなら誰でも、一時的なプライベートフォークを作成できます。

脆弱性についての情報を保護するため、CI を含むインテグレーションは、一時的なプライベートフォークにアクセスできません。

{% data reusables.repositories.navigate-to-repo %}
{% data reusables.repositories.sidebar-security %}
{% data reusables.repositories.sidebar-advisories %}
4. [Security Advisories] のリストから、一時的なプライベートフォークを作成するセキュリティアドバイザリをクリックします。 ![リスト内のセキュリティアドバイザリ](/assets/images/help/security/security-advisory-in-list.png)
5. [**New temporary private fork**] をクリックします。 ![[New temporary private fork] ボタン](/assets/images/help/security/new-temporary-private-fork-button.png)

### 一時的なプライベートフォークにコラボレータを追加する

セキュリティアドバイザリの管理者権限を持つユーザは、セキュリティアドバイザリにコラボレータを追加でき、セキュリティアドバイザリのコラボレータは一時的なプライベートフォークにアクセスできます。 詳しい情報については、「[セキュリティアドバイザリにコラボレータを追加する](/github/managing-security-vulnerabilities/adding-a-collaborator-to-a-security-advisory)」を参照してください。

### 一時的なプライベートフォークに変更を追加する

セキュリティアドバイザリに対する管理者権限があるユーザなら誰でも、一時的なプライベートフォークに変更を追加できます。

{% data reusables.repositories.navigate-to-repo %}
{% data reusables.repositories.sidebar-security %}
{% data reusables.repositories.sidebar-advisories %}
4. [Security Advisories] のリストから、変更を追加するセキュリティアドバイザリをクリックします。 ![リスト内のセキュリティアドバイザリ](/assets/images/help/security/security-advisory-in-list.png)
5. {% data variables.product.product_name %} またはローカルに変更を追加します:
   - {% data variables.product.product_name %} に変更を追加するには、[Add changes to this advisory] で、[**the temporary private fork**] をクリックします。 そして、新しいブランチを作成し、ファイルを編集します。 詳細は「[リポジトリ内でブランチを作成および削除する](/articles/creating-and-deleting-branches-within-your-repository)」および「[リポジトリのファイルを編集する](/articles/editing-files-in-your-repository)」を参照してください。
   - ローカルで変更を追加するには、「クローンを作成して新しいブランチを作成する」および「変更を加えてからプッシュする」の手順に従ってください。 ![このアドバイザリボックスに変更を追加](/assets/images/help/security/add-changes-to-this-advisory-box.png)

### 一時的なプライベートフォークからプルリクエストを作成する

セキュリティアドバイザリに対する書き込み権限があるユーザなら誰でも、一時的なプライベートフォークからプルリクエストを作成できます。

{% data reusables.repositories.navigate-to-repo %}
{% data reusables.repositories.sidebar-security %}
{% data reusables.repositories.sidebar-advisories %}
4. [Security Advisories] のリストから、セキュリティアドバイザリを作成するプルリクエストをクリックします。 ![リスト内のセキュリティアドバイザリ](/assets/images/help/security/security-advisory-in-list.png)
5. ブランチ名の右側にある、[**Compare & pull request**] をクリックします。 ![[Compare & pull request] ボタン](/assets/images/help/security/security-advisory-compare-and-pr.png)
{% data reusables.repositories.pr-title-description %}
{% data reusables.repositories.create-pull-request %}

{% data reusables.repositories.merge-all-pulls-together %} 詳しい情報については、「[Merging changes in a security advisory](#merging-changes-in-a-security-advisory)」を参照してください。

### 変更をセキュリティアドバイザリにマージする

セキュリティアドバイザリに対する管理者権限があるユーザなら誰でも、セキュリティアドバイザリに変更をマージできます。

{% data reusables.repositories.merge-all-pulls-together %}

セキュリティアドバイザリの変更をマージするには、一時的なプライベートフォークにあるすべてのオープンされたプルリクエストがマージできる必要があります。 マージコンフリクトは許容されません。また、ブランチ保護の要件を満たす必要があります。 脆弱性についての情報を保護するため、一時的なプライベートフォークにあるプルリクエストに対しては、ステータスチェックは実行されません。 詳しい情報については[保護されたブランチについて](/articles/about-protected-branches)を参照してください。

{% data reusables.repositories.navigate-to-repo %}
{% data reusables.repositories.sidebar-security %}
{% data reusables.repositories.sidebar-advisories %}
4. [Security Advisories] のリストから、変更をマージするセキュリティアドバイザリをクリックします。 ![リスト内のセキュリティアドバイザリ](/assets/images/help/security/security-advisory-in-list.png)
5. 一時的なプライベートフォークにあるすべてのオープンされたプルリクエストをマージするには、[**Merge pull requests**] をクリックします。 ![[Merge pull requests] ボタン](/assets/images/help/security/merge-pull-requests-button.png)

セキュリティアドバイザリの変更をマージした後は、プロジェクトの以前のバージョンにある脆弱性についてコミュニティにアラートするため、セキュリティアドバイザリを公開できます。 詳しい情報については、「[セキュリティアドバイザリを公開する](/github/managing-security-vulnerabilities/publishing-a-security-advisory)」を参照してください。

### 参考リンク

- 「[セキュリティアドバイザリの権限レベル](/github/managing-security-vulnerabilities/permission-levels-for-security-advisories)」
- 「[セキュリティアドバイザリを公開する](/github/managing-security-vulnerabilities/publishing-a-security-advisory)」
