---
title: Git と GitHub の学習リソース
redirect_from:
  - /articles/good-resources-for-learning-git-and-github/
  - /articles/what-are-other-good-resources-for-learning-git-and-github/
  - /articles/git-and-github-learning-resources
intro: 'ウェブ上には数多くの役に立つ Git と {% data variables.product.product_name %} のリソースが存在します。 おすすめのものをまとめました。'
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---

### Git を使用する

[公式 Git プロジェクトサイト](https://git-scm.com)にアクセスして[ProGit ebook](http://git-scm.com/book) を読み、Git に慣れましょう。 [Try Git](https://try.github.com) シミュレーターを使用しながら、[Git コマンドリスト](https://git-scm.com/docs)や[Git コマンドルックアップ参照](http://gitref.org)を確認できます。

### {% data variables.product.product_name %}を使用する

{% if currentVersion == "free-pro-team@latest" %}

{% data variables.product.prodname_learning %} では、即座に自動化されたフィードバックやヘルプとともに、{% data variables.product.prodname_dotcom %} に組み込まれた無料のインタラクティブなコースを提供しています。 最初のプルリクエストをオープンしたり、最初のオープンソースへのコントリビューションを行ったり、{% data variables.product.prodname_pages %} のサイトを作成したりできます。 コースについての詳細は、[{% data variables.product.prodname_learning %}]({% data variables.product.prodname_learning_link %}) をご覧ください。

{% endif %}

[bootcamp](/categories/bootcamp/) 記事で、{% data variables.product.product_name %} に精通しましょう。 [{% data variables.product.prodname_dotcom %} のフロー](https://guides.github.com/introduction/flow)でプロセスの紹介をご確認ください。 [概要ガイド](https://guides.github.com)を参照して基本的な概念をご覧ください。

{% data reusables.support.ask-and-answer-forum %}

#### ブランチ、フォーク、プルリクエスト

インタラクティブなツールを使用して、[Git のブランチ](http://learngitbranching.js.org/)について学びましょう。 [フォーク](/articles/about-forks)や[プルリクエスト](/articles/using-pull-requests)、および {% data variables.product.prodname_dotcom %} で[プルリクエストがどのように使用されているのか](https://github.com/blog/1124-how-we-use-pull-requests-to-build-github)をお読みください。

[コマンドライン](https://hub.github.com)についてのクイックリファレンスや、{% data variables.product.prodname_dotcom %} の[チェックリスト、チートシートなど](https://services.github.com/on-demand/resources)にアクセスしてください。

#### 動画

{% data variables.product.prodname_dotcom %}[YouTube のトレーニングおよびガイドチャンネル](https://youtube.com/githubguides)では、[プルリクエスト](https://www.youtube.com/watch?v=d5wpJ5VimSU&list=PLg7s6cbtAD15G8lNyoaYDuKZSKyJrgwB-&index=19)、[フォーキング](https://www.youtube.com/watch?v=5oJHRbqEofs)、[リベース](https://www.youtube.com/watch?v=SxzjZtJwOgo&list=PLg7s6cbtAD15G8lNyoaYDuKZSKyJrgwB-&index=22)、および[リセット](https://www.youtube.com/watch?v=BKPjPMVB81g)機能についてのチュートリアルを提供しています。 各トピックの所要時間は 5 分以内です。

### トレーニング

#### 無料クラス

{% data variables.product.product_name %} では、インタラクティブな [オンデマンドのトレーニングコース](https://services.github.com/on-demand/)のシリーズを提供しています。これには、{% data variables.product.prodname_dotcom %}101: [導入](https://services.github.com/on-demand/intro-to-github/), {% data variables.product.prodname_dotcom %}102: [GitHub Desktop](https://services.github.com/on-demand/github-desktop)、および{% data variables.product.prodname_dotcom %}103: [コマンドライン](https://services.github.com/on-demand/github-cli)が含まれます。

#### {% data variables.product.prodname_dotcom %}のウェブベース教育プログラム

{% data variables.product.prodname_dotcom %} では、生中継の[トレーニング](https://services.github.com/#upcoming-events)を提供しています。コマンドラインの好き嫌いにかかわらず、すべてのユーザに向けたハンズオン、プロジェクトベースのアプローチを紹介しています。

#### 企業向けトレーニング

{% data variables.product.prodname_dotcom %} では、経験豊富な教育者による[対面クラス](https://services.github.com/#offerings)を提供しています。 トレーニングに関するお問い合わせについては、[こちら](https://services.github.com/#contact)までどうぞ。

### その他

[Code School](http://codeschool.com) によるインタラクティブな[オンラインの Git コース](http://www.codeschool.com/courses/git-real)では、数十の楽しいゲーム形式のエクササイズを含む 7 段階のサービスを提供しています。 [.gitignore テンプレート](https://github.com/github/gitignore)では、お客様のニーズに合わせることができます。

{% data variables.product.prodname_dotcom %} のリーチを、{% if currentVersion == "free-pro-team@latest" %}[インテグレーション](/articles/about-integrations){% else %}インテグレーション{% endif %}、または[{% data variables.product.prodname_desktop %}](https://desktop.github.com) と堅牢な [Atom](https://atom.io) テキストエディタで拡張しましょう。

[オープンソースのガイド](https://opensource.guide/)で、オープンソースのプロジェクトを立ち上げ成長させる方法をご確認ください。
