---
title: GitHub のプランの変更に関する FAQ
intro: 2020 年 4 月 14 日時点で、GitHub は GitHub の主要機能がすべて無料で利用可能になったことを発表しました。
versions:
  free-pro-team: '*'
---

### GitHub が 4 月 14 日に発表したプランと料金の変更

GitHub は、以下のプランと価格の変更を発表しました。

- Organization 向けの GitHub Free が即座に利用可能で、無制限のユーザ向けのプライベートリポジトリが含まれています。
- 以前 Team for Open Source を使用していたすべての Organization が GitHub Free を利用できるようになりました。
- 個々の開発者向けの GitHub Free に無制限のコラボレータが含まれるようになりました。
- GitHub Free を使用している Organization および個人は、GitHub コミュニティサポートを利用できます。
- GitHub Pro には 2GB のパッケージストレージと 10GB のデータ転送が含まれています。
- GitHub Pro の月額料金が 4 ドルに引き下げられました。
- GitHub Teamの月額は減額されてユーザごとに4ドルになりました
- GitHub Teamでは最小5シートが必須ではなくなりました
- GitHub Teamには、プライベートリポジトリに対して月あたり3,000 Actions分が含まれます

### プランのアップグレード方法

ユーザアカウントのプランをアップグレードするには、「[個人アカウントのサブスクリプションのアップグレード](/github/setting-up-and-managing-billing-and-payments-on-github/upgrading-your-github-subscription#upgrading-your-personal-accounts-subscription)」を参照してください。 Organizationのプランをアップグレードするには、「[Organizationのサブスクリプションのアップグレード](/github/setting-up-and-managing-billing-and-payments-on-github/upgrading-your-github-subscription#upgrading-your-organizations-subscription)」を参照してください。

### プランのダウングレード方法

アカウントのプランをダウングレードするには、「[ユーザアカウントのサブスクリプションのダウングレード](/github/setting-up-and-managing-billing-and-payments-on-github/downgrading-your-github-subscription#downgrading-your-user-accounts-subscription)」を参照してください。 Organizationのプランをダウングレードするには、「[Organizationのサブスクリプションのダウングレード](/github/setting-up-and-managing-billing-and-payments-on-github/downgrading-your-github-subscription#downgrading-your-organizations-subscription)」を参照してください。

### GitHub Teamあるいは旧来のプランからGitHub Freeにダウングレードした場合、なくなるのはどの機能ですか？
- プライベートリポジトリでの必須レビュー担当者
- プライベートリポジトリの保護されたブランチ
- プライベートリポジトリのコードオーナー
- プライベートリポジトリのGitHub Pages
- プライベートリポジトリのWiki
- プライベートリポジトリでのIssue及びプルリクエストの複数人へのアサイン
- プライベートリポジトリでのプルリクエストの複数のレビュー担当者
- プライベートリポジトリのドラフトプルリクエスト
- プライベートリポジトリでの自動リンクされたリファレンス
- Standard Support

### GitHub Free または GitHub Team の Organization の作成方法

GitHub アカウントをお持ちの場合は、[Team プランページ](https://github.com/organizations/plan)で新しい Organization を作成してください。 GitHub アカウントをお持ちでない場合は、[ホームページでアカウントを作成](https://github.com/)できます。サインアッププロセス中に Organization を作成するように求められます。

### 各プランの機能を比較する方法

各製品の料金と機能の全リストは <{% data variables.product.pricing_url %}> に掲載されています。

### GitHub Free で無制限のコラボレータが許可される期間

期限はありません。 この変更は恒久的なものです。

### 既に年間の Pro または Team プランへの支払いを済ませている場合の差額の払い戻し

現在年間で Pro および Team プランのお支払いが完了していて、4 月 14 日以前にサインアップを行っているお客様は、年間の支払期間の終了時までで日割り計算した金額が返金されます。 たとえば、サブスクリプションの年間支払い後 2 ヶ月以内の場合。 残り 10 ヶ月分の差額は返金されます。 これらの払い戻しは約 30 日で処理されます。 払い戻しが処理されると、支払い請求先メールアドレスに通知が送信されます。

### 個人の開発者向けの GitHub Free と Organization 向けの GitHub Free の違い

GitHub Free の各製品の違いに関する詳細は、「[{% data variables.product.prodname_dotcom %} の製品](/articles/github-s-products)」を参照してください。

### GitHub Team プランで割り当てられた以上の分数が必要な場合、どうすればアクションの分数を増やすことができますか？

ほとんどの小規模チームが使用するアクション数は 1 か月あたり 3,000 未満ですが、一部の Team はそれ以上必要な場合があります。 Team がプライベートリポジトリに追加を必要とする場合は、GitHub Actions の利用上限を増やすことができます。 アクション分とパッケージストレージは、パブリックリポジトリでは引き続き無料です。 詳しい情報については、「[GitHub Actions の利用上限を管理する](/github/setting-up-and-managing-billing-and-payments-on-github/managing-your-spending-limit-for-github-actions)」を参照してください。

### シート制限の変更の影響はどのようなものですか？

{% data variables.product.prodname_team %}の最小シートの要求がなくなったので、Organizationで5シート未満しか使っていないなら、有料シートを削除して支払いを引き下げられます。 詳細は「[{% data variables.product.prodname_dotcom %} プランのダウングレード](/github/setting-up-and-managing-billing-and-payments-on-github/downgrading-your-github-subscription#removing-paid-seats-from-your-organization)」を参照してください。

### GitHub Team for Open Source プランの Team の変更

現在、Organization アカウントで GitHub Team for Open Source プランを使用している場合は、GitHub Free に自動的に移行します。GitHub には、無制限のコラボレータが含まれるプライベートリポジトリ、プライベートリポジトリの 2,000 アクション分、GitHub コミュニティサポートが含まれています。 アクション分とパッケージストレージは、パブリックリポジトリでは引き続き無料です。

### GitHub コミュニティサポートとは

GitHub コミュニティサポートには、[コミュニティフォーラム](https://github.community/)によるサポートが含まれており、GitHub コミュニティで解決方法を閲覧したり、新しい質問をしたり、アイデアを共有したりすることができます。 GitHub コミュニティサポートには、GitHub Team のサポートエンジニアが配置されています。サポートエンジニアは、最もアクティブなコミュニティメンバーと共にコミュニティフォーラムを管理しています。 スパムの報告、不正利用の報告、アカウントへのアクセスに問題がある場合は、https://support.github.com/ からサポートチームにメッセージを送信できます。

### この変更による教育関係の特典への影響

学生や教員は、これまでと同様のすべての特典を受けることができます。 GitHub は、[学生向け開発者パック](https://education.github.com/pack)の特典の一部として、引き続き GitHub Pro をすべての学生に提供します。 さらに、教員は [Teacher Toolbox ](https://education.github.com/toolbox) の一部として GitHub Team に引き続きアクセスできます。

### 現在請求書を利用して支払いを行っている場合の影響

現在請求書をご利用の場合は、詳細について営業担当者にメールでお問い合わせください。 営業担当者が不明な場合は、支払いマネージャーまたはアカウント所有者にお問い合わせください。

### 米国政府の制裁が適用される地域のユーザと Organization にどのように影響しますか？ government sanctions are applied?

Due to U.S. 米国の貿易管理法の制限により、GitHub は米国の制裁対象地域のアカウントにプライベートリポジトリサービスと有料サービスを提供できません。 sanctioned regions. ただし、GitHub は無料の公開リポジトリサービスへのアクセスを保持しています。 詳細については、「[GitHub と貿易管理](/github/site-policy/github-and-trade-controls)」をご覧ください。

GitHub は、無料のプライベートリポジトリを含め、認可された地域の開発者が無料のコードコラボレーションサービスに最大限にアクセスできるように、米国の規制当局に引き続き提唱していきます。 regulators for the greatest possible access to free code collaboration services to developers in sanctioned regions, including free private repositories. We believe that offering those free services supports U.S. foreign policy of encouraging the free flow of information and free speech in those regions.
