---
title: リポジトリのリリースを管理する
intro: リリースを作成し、プロジェクトのイテレーションをバンドルしてユーザに配信できます。
redirect_from:
  - /articles/creating-releases
  - /articles/listing-and-editing-releases/
  - /articles/editing-and-deleting-releases
  - /articles/managing-releases-in-a-repository
  - /github/administering-a-repository/creating-releases
  - /github/administering-a-repository/editing-and-deleting-releases
permissions: リポジトリのコラボレータと、リポジトリへの書き込みアクセスを持つ人は、リリースを作成、編集、削除できます。
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---

### リリース管理について

特定のリリースのアクションを {% data variables.product.prodname_marketplace %} で公開することもできます。 詳しい情報については、「[アクションを {% data variables.product.prodname_marketplace %} で公開する](/actions/creating-actions/publishing-actions-in-github-marketplace)」を参照してください。

{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.22" %}
{% data variables.large_files.product_name_long %}（{% data variables.large_files.product_name_short %}）オブジェクトを、{% data variables.product.product_name %} がリリースごとに作成する ZIP ファイルと tarball に含めるかどうかを選択できます。 詳しい情報については、「[リポジトリのアーカイブ内の {% data variables.large_files.product_name_short %} オブジェクトを管理する](/github/administering-a-repository/managing-git-lfs-objects-in-archives-of-your-repository)」を参照してください。
{% endif %}

{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.19" %}
{% tip %}

**Tip**: You can also manage releases using the {% data variables.product.prodname_cli %}. For more information, see "[`gh release`](https://cli.github.com/manual/gh_release)" in the {% data variables.product.prodname_cli %} documentation.

{% endtip %}
{% endif %}

### リリースの作成

{% data reusables.repositories.navigate-to-repo %}
{% data reusables.repositories.releases %}
3. [**Draft a new release**] をクリックします。 ![新しいリリースのドラフトを作成するボタン](/assets/images/help/releases/draft_release_button.png)
4. リリースのバージョン番号を入力します。 バージョンは [Git タグ](https://git-scm.com/book/en/Git-Basics-Tagging)に基づきます。 名前付けタグは[セマンティック バージョニング ](http://semver.org/)に準じることをおすすめします。 ![タグ付きバージョンのリリース](/assets/images/help/releases/releases-tag-version.png)
5. ドロップダウンメニューを使ってリリース対象のプロジェクトを含むブランチを選択します。 ![タグ付きブランチのリリース](/assets/images/help/releases/releases-tag-branch.png)
6. リリースのタイトルと説明を入力します。 ![リリースの説明](/assets/images/help/releases/releases_description.png)
7. オプションで、コンパイルされたプログラムなどのバイナリファイルをリリースに含めるには、ドラッグアンドドロップするかバイナリボックスで手動で選択します。 ![リリースに DMG ファイルを含める](/assets/images/help/releases/releases_adding_binary.gif)
8. リリースが不安定であり、運用準備ができていないことをユーザに通知するには、[**This is a pre-release**] を選択します。 ![リリースをプレリリースとしてマークするチェックボックス](/assets/images/help/releases/prerelease_checkbox.png)
9. リリースを公開する準備ができている場合は、[**Publish release**] をクリックします。 リリースの作業を後でする場合は、[**Save draft**] をクリックします。 ![[Publish release] と [Save draft] ボタン](/assets/images/help/releases/release_buttons.png)

コマンドラインから、またはスクリプトでリリースを自動的に作成することもできます。 詳しい情報については、「[リリース](/v3/repos/releases/#create-a-release)」を参照してください。

### リリースの編集

{% data reusables.repositories.navigate-to-repo %}
{% data reusables.repositories.releases %}
3. ページの右側で、編集するリリースの横にある [**Edit release**] をクリックします。 ![リリースの編集](/assets/images/help/releases/edit-release.png)
4. フォームでリリースの詳細を編集し、[**Update release**] をクリックします。 ![リリースの更新](/assets/images/help/releases/update-release.png)

### リリースの削除

リリースを削除するには、まずリリースに添付されているバイナリファイルをすべて削除する必要があります。

{% data reusables.repositories.navigate-to-repo %}
{% data reusables.repositories.releases %}
3. 削除するリリースの名前をクリックします。 ![リリースを表示するリンク](/assets/images/help/releases/release-name-link.png)
4. ページの右上にある [**Delete**] をクリックします。 ![リリースの削除ボタン](/assets/images/help/releases/delete-release.png)
5. [**Delete this release**] をクリックします。 ![リリースの削除を確認](/assets/images/help/releases/confirm-delete-release.png)
