---
title: Guía para enviar un aviso de retiro de DMCA
redirect_from:
  - /dmca-notice-how-to/
  - /articles/dmca-notice-how-to/
  - /articles/guide-to-submitting-a-dmca-takedown-notice
versions:
  free-pro-team: '*'
---

Esta guía describe la información que GitHub necesita para procesar una solicitud de retiro de DMCA. Si tienes preguntas más generales sobre qué es la DMCA o cómo procesa GitHub las solicitudes de retiro de DMCA, por favor revisa nuestra [política de retiro de DMCA](/articles/dmca-takedown-policy).

Debido al tipo de contenido de los hosts de GitHub (principalmente de código de software) y a la forma en que se gestiona el contenido (con Git), necesitamos que las demandas sean lo más específicas posible. Estas directrices están diseñadas para que el procesamiento de las notificaciones de supuestas infracciones sea lo más sencillo posible. Nuestra forma de notificación indicada a continuación es coherente con el formulario sugerido por el estatuto DMCA, que se puede encontrar en el sitio web oficial de la Oficina de Derechos de Autor de EE. UU.: <https://www.copyright.gov>. Copyright Office's official website: <https://www.copyright.gov>.

Como en todas las cuestiones jurídicas, siempre es mejor consultar con un profesional sobre tus preguntas o situación específicas. Te recomendamos enfáticamente que lo hagas antes de emprender cualquier acción que pueda afectar tus derechos. Esta guía no es asesoramiento legal y no debería ser tomada como tal.

### Antes de comenzar

***Di la Verdad.*** La DMCA requiere que prestes atención a los hechos en tu queja de derechos de autor *bajo pena de perjurio*. Es un crimen federal mentir intencionadamente en una declaración jurada. (*Consulta* [Código de Estados Unidos, Título 18, Sección 1621](https://www.gpo.gov/fdsys/pkg/USCODE-2011-title18/html/USCODE-2011-title18-partI-chap79-sec1621.htm). Code, Title 18, Section 1621</a>.) La presentación de información falsa también podría resultar en responsabilidad civil, es decir, podrías ser demandado por daños monetarios. La DMCA por sí misma [proporciona daños](https://en.wikipedia.org/wiki/Online_Copyright_Infringement_Liability_Limitation_Act#%C2%A7_512(f)_Misrepresentations) contra cualquier persona que, a sabiendas, tergiversa materialmente dicha actividad o material infractor.

***Investiga.*** Millones de usuarios y organizaciones se esfuerzan demasiado en los proyectos que crean y contribuyen en GitHub. La presentación de una queja de DMCA contra un proyecto de este tipo es una acusación legal seria que conlleva consecuencias reales para las personas reales. Por eso, te pedimos que realices una investigación exhaustiva y consultes con un abogado antes de enviar una solicitud de retiro para asegurarte que el uso no sea realmente permisible.

***Primero pregunta amablemente.*** Un gran primer paso antes de enviarnos una notificación de retiro es intentar contactar directamente al usuario. Pueden haber enumerado información de contacto en su página de perfil público o en el README del repositorio, o podrías ponerse en contacto abriendo una propuesta o solicitud de extracción en el repositorio. Esto no es estrictamente necesario, pero es común.

***Envia una solicitud de corrección.*** Sólo podemos aceptar notificaciones de retiro de DMCA para obras protegidas por derechos de autor y que identifiquen un trabajo específico con derechos de autor. Si tienes una queja sobre el abuso de la marca registrada, consulta nuestra [política de marcas](/articles/github-trademark-policy/). Si desea eliminar datos sensibles como contraseñas, consulta nuestra [política sobre datos sensibles](/articles/github-sensitive-data-removal-policy/). Si usted está tratando con difamación u otro comportamiento abusivo, por favor consulta nuestras [Directrices de la comunidad](/articles/github-community-guidelines/).

***El código es diferente de otro contenido creativo.*** GitHub está construido para colaborar en el código de software. Esto hace que la identificación de una infracción válida de derechos de autor sea más complicada de lo que podría ser de otra manera para, fotos, música o videos, por ejemplo.

Existen diversas razones por las que el código es diferente de otros contenidos creativos. Por ejemplo:

- Un repositorio puede incluir bits y partes de código de muchas personas diferentes, pero sólo un archivo o incluso una subrutina dentro de un archivo infringe tus derechos de autor.
- El código mezcla funcionalidad con expresión creativa, pero los derechos de autor sólo protegen los elementos expresivos, no las partes que son funcionales.
- A menudo hay licencias a considerar. El hecho de que una parte del código tenga una notificación de derechos de autor no significa necesariamente que sea infractora. Es posible que el código se esté utilizando de acuerdo con una licencia de código abierto.
- Un uso particular puede ser [uso legítimo](https://www.lumendatabase.org/topics/22) si solamente utiliza una pequeña cantidad del contenido protegido por derechos de autor, si utiliza ese contenido de forma transformativa, lo utiliza para fines educativos, o alguna combinación de lo anterior. Dado que el código naturalmente se presta a dichos usos, cada caso de uso es diferente y debe considerarse por separado.
- Se puede alegar que el código infringe de muchas formas diferentes, exigiendo explicaciones detalladas e identificaciones de obras.

Esta lista no es exhaustiva, por lo que hablar con un profesional legal sobre tu propuesta de reclamación es doblemente importante cuando se trata de un código.

***Sin bots.*** Deberías contar con un profesional capacitado para evaluar los datos de cada notificación de retito que envíes. Si estás subcontratando tus labores a un tercero, asegúrate de saber cómo trabajand y asegúrate que no estén utilizando bots automatizados para presentar quejas en masa. ¡Estas quejas a menudo no son válidas y su procesamiento da lugar a la supresión innecesaria de proyectos!

***Los temas de derechos de autor son difíciles.*** Puede ser muy difícil determinar si un trabajo en particular está protegido o no por derechos de autor. Por ejemplo, los hechos (incluyendo los datos) generalmente no tienen derechos de autor. Las palabras y las frases cortas generalmente no tienen derechos de autor. Las URLs y los nombres de dominio generalmente no tienen derechos de autor. Dado que sólo puede utilizar el proceso DMCA para abordar contenido protegido por derechos de autor, deberías hablar con un abogado si tienes preguntas sobre si tu contenido es o no protegible.

***Puedes recibir una contra notificación.*** Cualquier usuario afectado por tu notificación de retiro puede decidir enviar una [contra notificación](/articles/guide-to-submitting-a-dmca-counter-notice). Si lo hacen, reactivaremos tu contenido en un plazo de 10 a 14 días a menos que nos notifique que has iniciado una acción legal encaminada a impedir que el usuario se involucre en infringir la actividad relacionada con el contenido en GitHub.

***Tu queja se publicará.*** Como se indica en nuestra [política de DMCA](/articles/dmca-takedown-policy#d-transparency), después de modificar la información personal, publicamos todas las notificaciones de retiro completas y accionables en [https://github. om/github/dmca](https://github.com/github/dmca).

***GitHub no es el juez.*** GitHub ejerce poca discreción en el proceso además de determinar si las notificaciones cumplen con los requisitos mínimos de la DMCA. Corresponde a las partes (y a sus abogados) evaluar el mérito de sus reclamaciones, teniendo en cuenta que las notificaciones deben realizarse bajo pena de perjurio.

### Tu queja debe ...

1. **Incluir la siguiente declaración: "He leído y entendido la guía de GitHub para presentar una notificación de DMCA.** No nos negaremos a procesar una queja completa si no incluye esta declaración. Pero sabremos que no has leído estas directrices y podríamos solicitarte que regreses y lo lleves a cabo.

2. **Identifica el trabajo con derechos de autor que consideras que ha sido infringido.** Esta información es importante porque ayuda al usuario afectado a evaluar su reclamación y le da la capacidad de comparar su trabajo con el tuyo. La especificidad de su identificación dependerá de la naturaleza del trabajo que consideras que ha sido infringido. Si has publicado tu trabajo, solo podrás enlazar a una página web donde reside. Si es autónoma y no está publicada, puedes describirlo y explicar que es propietario. Si lo has registrado en la Oficina de Derechos de Autor, debes incluir el número de registro. Si estás alegando que el contenido alojado es una copia directa y literal de tu trabajo, también puedes explicar ese hecho.

3. **Identifica el material al que haces referencia que está infringiendo el trabajo protegido por derechos de autor que aparece en el artículo #2, anterior.** Es importante ser lo más específico posible en tu identificación. Esta identificación debe ser razonablemente suficiente para permitir a GitHub localizar el material. Como mínimo, esto significa que debe incluir la URL del material que supuestamente infringe sus derechos de autor. Si aseguras que se infringe menos de un repositorio completo, identifica el(los) archivo(s) específicos o números de línea dentro de un archivo al que te refieres. Si aseguras que se infringe todo el contenido en una URL, por favor se explícito al respecto también. Por último, ten en cuenta que GitHub *no* deshabilitará automáticamente los [forks](/articles/dmca-takedown-policy#b-what-about-forks-or-whats-a-fork) al desactivar un repositorio matriz. Si has investigado y analizado los forks de un repositorio y crees que también están infringiendo, por favor identifique explícitamente cada fork supuestamente infractor. Por favor, confirma también que has investigado cada caso individual y que tus declaraciones juradas se aplican a cada fork identificado.

4. **Explica lo que el usuario afectado tendría que hacer para remediar la infracción.** De nuevo, la especificidad es importante. Cuando transmitimos su queja al usuario, esto les dirá lo que tienen que hacer para evitar que el resto de su contenido esté desactivado. ¿Necesita el usuario añadir una declaración de atribución? ¿Necesitan eliminar ciertas líneas dentro de su código, o archivos completos? Por supuesto, entendemos en algunos casos, todo el contenido de un usuario puede infringirse presuntamente y no hay nada que puedan hacer más que borrarlo todo. Si ese es el caso, por favor deja esto claro también.

5. **Proporciona tu información de contacto.** Incluye tu dirección de correo electrónico, nombre, número de teléfono y dirección.

6. **Proporciona información de contacto, si la conoces, para el presunto infractor.** Generalmente esto se realizará proporcionando el nombre de usuario de GitHub asociado con el contenido presuntamente infractor. Sin embargo, puede haber casos en los que tengas conocimientos adicionales sobre el presunto infractor. Si es así, por favor comparte esa información con nosotros.

7. **Incluye la siguiente declaración: "Tengo buena fe en que el uso de los materiales protegidos por derechos de autor descritos anteriormente en las páginas web infractoras no está autorizado por el propietario de los derechos de autor, o su agente, o la ley. He tenido en cuenta el uso justo."**

8. **También incluye la siguiente declaración: "Juro, bajo pena de perjurio, que la información de esta notificación es exacta y que soy el propietario de los derechos de autor, o estoy autorizado para actuar en nombre del propietario, de un derecho exclusivo que se infringe presuntamente".**

9. **Incluye tu firma física o electrónica.**

### Quejas sobre Tecnología de Anti Elusión

La Ley de Derechos de Autor también prohíbe la elusión de medidas tecnológicas que controlen eficazmente el acceso a las obras protegidas por los derechos de autor. Si crees que el contenido alojado en GitHub viola esta prohibición, por favor envíanos un informe a través de nuestro {% data variables.contact.contact_dmca %}, e incluye información específica sobre qué contenido viola esa prohibición, qué medidas tecnológicas aplicas y por qué el contenido viola la prohibición.

### Como presentar tu queja

La forma más rápida de obtener una respuesta es ingresar tu información y responder a todas las preguntas de nuestro {% data variables.contact.contact_dmca %}.

También puedes enviar una notificación por correo electrónico a <copyright@github.com>. Puedes incluir un archivo adjunto si lo deseas, pero por favor incluye una versión de texto simple de tu carta en el cuerpo de tu mensaje.

Si debes enviar tu aviso por correo físico, también puedes hacerlo pero tardará *substancialmente* en que lo recibamos y respondamos al mismo. Las notificaciones que recibimos por correo electrónico de texto plano tienen una respuesta mucho más rápida que los archivos adjuntos PDF o el correo. Si aún deseas enviarnos tu aviso, nuestra dirección es:

```
GitHub, Inc
En atención a: Agente de DMCA
88 Colin P Kelly Jr St
San Francisco, CA. 94107
```
