---
title: Términos de servicio de GitHub
redirect_from:
  - /tos/
  - /terms/
  - /terms-of-service/
  - /github-terms-of-service-draft/
  - /articles/github-terms-of-service
versions:
  free-pro-team: '*'
---

¡Gracias por usar GitHub! Estamos felices de que estés aquí. Por favor, lee cuidadosamente estos Términos de Servicio antes de ingresar o usar GitHub. Ya que se trata de un contrato tan importante entre nosotros y nuestros usuarios, intentamos ser muy claros. Para tu comodidad, presentamos estos términos en un breve resumen no vinculante seguido de los términos legales completos.

### Resumen

| Sección                                                                     | ¿Qué puedes encontrar allí?                                                                                                                                                                                                                        |
| --------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [A. Definiciones](#a-definitions)                                           | Algunos términos básicos, definidos de forma que te ayude a entender este acuerdo. Consulta la copia de seguridad de esta sección para obtener una aclaración.                                                                                     |
| [B. Términos de la cuenta](#b-account-terms)                                | Estos son los requisitos básicos para tener una cuenta en GitHub.                                                                                                                                                                                  |
| [C. Uso aceptable](#c-acceptable-use)                                       | Estas son las reglas básicas que debes seguir cuando uses tu cuenta de GitHub.                                                                                                                                                                     |
| [D. Contenido generado por el usuario](#d-user-generated-content)           | Eres responsable del contenido que publicas en GitHub. Sin embargo, tienes ciertas responsabilidades al respecto y te pedimos que nos otorgues algunos derechos de manera que podamos proporcionarte los servicios.                                |
| [E. Repositorios privados](#e-private-repositories)                         | Esta sección expone cómo tratará GitHub el contenido que publiques en los repositorios privados.                                                                                                                                                   |
| [F. Copyright & Política DMCA](#f-copyright-infringement-and-dmca-policy)   | Esta sección explica la forma en la que GitHub responderá si crees que alguien está infringiendo tus derechos de autor en GitHub.                                                                                                                  |
| [G. Notificación de propiedad intelectual](#g-intellectual-property-notice) | Describe los derechos de GitHub en el sitio web y el servicio.                                                                                                                                                                                     |
| [H. Términos de la API](#h-api-terms)                                       | Estas son las reglas para usar las API de GitHub, ya sea que estés usando la API para el desarrollo o la recopilación de datos.                                                                                                                    |
| [I. Términos de producto adicionales](#i-github-additional-product-terms)   | Tenemos algunas reglas específicas para las características y productos de GitHub.                                                                                                                                                                 |
| [J. Vista previa Beta](#j-beta-previews)                                    | Estos son algunos de los términos adicionales que se aplican a las características de GitHub que continúan en desarrollo.                                                                                                                          |
| [K. Pago](#k-payment)                                                       | Eres responsable del pago. Somos responsables de facturarte con exactitud.                                                                                                                                                                         |
| [L. Cancelación y terminación](#l-cancellation-and-termination)             | Puedes cancelar este acuerdo y cerrar tu cuenta en cualquier momento.                                                                                                                                                                              |
| [M. Comunicaciones con GitHub](#m-communications-with-github)               | Sólo utilizamos el correo electrónico y otros medios electrónicos para estar en contacto con nuestros usuarios. No ofrecemos soporte telefónico.                                                                                                   |
| [N. Exención de garantías](#n-disclaimer-of-warranties)                     | Proporcionamos nuestro servicio tal y como es y no hacemos promesas ni garantías sobre este servicio. **Lee esta sección cuidadosamente; deberías entender qué esperar.**                                                                          |
| [O. Limitación de responsabilidad](#o-limitation-of-liability)              | No seremos responsables de daños o pérdidas derivadas de tu uso o incapacidad para usar el servicio o de cualquier otra forma que surja en virtud de este acuerdo. **Lee esta sección cuidadosamente; esto limita nuestras obligaciones contigo.** |
| [P. Liberación e indemnización](#p-release-and-indemnification)             | Eres completamente responsable de tu uso del servicio.                                                                                                                                                                                             |
| [Q. Cambios a estos Términos de Servicio](#q-changes-to-these-terms)        | Podemos modificar este acuerdo, pero te notificaremos con 30 días de antelación sobre los cambios que afecten tus derechos.                                                                                                                        |
| [R. Varios](#r-miscellaneous)                                               | Consulta esta sección para obtener detalles legales, incluyendo nuestra elección de la ley.                                                                                                                                                        |

### Términos de servicio de GitHub
Fecha de entrada en vigencia: 2 de abril de 2020


### A. Definiciones
**Versión resumida:** *Utilizamos estos términos básicos a lo largo del acuerdo y tienen significados específicos. Es necesario que comprendas el significado de cada uno de nuestros términos. No habrá una evaluación sobre ello, pero es información útil.*

1. Una "Cuenta" representa tu relación legal con GitHub. Una "Cuenta de Usuario" representa la autorización individual del Usuario para iniciar sesión y utilizar el Servicio y sirve como identidad del Usuario en GitHub. “Organización” se refiere a un espacio de trabajo compartido que se puede asociar con una única entidad o con uno o más Usuarios donde múltiples Usuarios pueden colaborar en muchos proyectos a la vez. Una Cuenta de Usuario puede ser miembro de cualquier número de organizaciones.
2. El "Acuerdo" se refiere, colectivamente, a todos los términos, condiciones, avisos contenidos o a los que se hace referencia en el presente documento (los "Términos de Servicio" o los "Términos") y todas las demás reglas de funcionamiento, políticas (incluyendo la Declaración de Privacidad de GitHub, disponible en [github.com/site/privacy](https://github.com/site/privacy)) y procedimientos que podemos publicar de vez en cuando en el Sitio Web. La mayoría de nuestras políticas de sitio están disponibles en [docs.github.com/categories/site-policy](/categories/site-policy).
3. "Vistas Previas Beta" se refiere al software, los servicios o las características identificadas como alfa, beta, vista previa, acceso temprano o evaluación o a las palabras o frases con significados similares.
4. "Contenido" se refiere al contenido presentado o mostrado a través del sitio web, incluyendo, sin limitación al código, texto, datos, artículos, imágenes, fotografías, gráficos, software, aplicaciones, paquetes, diseños, características y otros materiales disponibles en el Sitio Web o disponibles de otra forma a través del Servicio. "Contenido" también incluye Servicios. “Contenido generado por el usuario” es Contenido, escrito o no, creado o cargado por nuestros Usuarios. "Tu Contenido" es Contenido que creas o posees.
5. “GitHub” y “Nosotros” se refieren a GitHub, Inc., así como a nuestros afiliados, directores, subsidiarios, contratistas, licenciadores, oficiales, agentes y empleados.
6. El “Servicio” se refiere a las aplicaciones, software, productos y servicios proporcionados por GitHub, incluyendo cualquier Vista Previa Beta.
7. “El Usuario”, “Tú” y “tu” se refieren a la persona, empresa u organización que ha visitado o está utilizando el Sitio Web o Servicio; que ingresa o utiliza cualquier parte de la Cuenta; o que dirije el uso de la Cuenta en el desempeño de sus funciones. Un usuario debe tener al menos 13 años de edad. Las condiciones especiales pueden aplicarse para cuentas empresariales o gubernamentales (véase [Section B(5): Términos Adicionales](#5-additional-terms)).
8. El "Sitio Web" se refiere al sitio web de GitHub ubicado en [github. om](https://github.com/) y todos los contenidos, servicios y productos proporcionados por GitHub en o a través del sitio web. También se refiere a subdominios propiedad de GitHub de github.com, tales como [education.github.com](https://education.github.com/) y [pages.github.com](https://pages.github.com/). Estos Términos también rigen los sitios web de la conferencia de GitHub, como [githubuniverse.com](https://githubuniverse.com/) y sitios web de productos, como [atom.io](https://atom.io/). Ocasionalmente, los sitios web propiedad de GitHub pueden proporcionar condiciones de servicio diferentes o adicionales. Si estos términos adicionales entran en conflicto con este Contrato, los términos más específicos se aplican a la página o servicio correspondiente.

### B. Términos de la cuenta
**Versión resumida:** *Las Cuentas de Usuario y las Organizaciones tienen diferentes controles administrativos; una persona debe crear tu cuenta; debes tener 13 años o más; debes proporcionar una dirección de correo electrónico válida; y no es posible tener más de una cuenta gratuita. Eres el único responsable de tu Cuenta y de todo lo que ocurra mientras estas conectado o usando tu Cuenta. Eres responsable de mantener tu cuenta segura.*

#### 1. Controles de la cuenta
- Usuarios. Sujeto a estos términos, conserva el control administrativo definitivo sobre tu cuenta de usuario y el Contenido dentro de ella.

- Organizaciones. El "propietario" de una Organización que fue creada bajo estos Términos tiene el control administrativo final sobre esa Organización y el Contenido dentro de ella. Dentro del Servicio, un propietario puede administrar el acceso del Usuario a los datos y proyectos de la Organización. Una Organización puede tener múltiples propietarios, pero debe haber al menos una Cuenta de Usuario designada como propietario de una Organización. Si eres el propietario de una Organización bajo estos términos, te consideramos responsable de las acciones que se llevan a cabo en o a través de dicha Organización.

#### 2. Información requerida
Debes proporcionar una dirección de correo electrónico válida para completar el proceso de registro. Cualquier otra información solicitada, como tu nombre real, es opcional, a menos que aceptes estos términos en nombre de una entidad legal (en cuyo caso necesitamos más información sobre la entidad legal) o si optas por una [Cuenta de pago](#k-payment), en cuyo caso será necesaria información adicional para fines de facturación.

#### 3. Requisitos de la cuenta
Tenemos unas cuantas reglas simples para cuentas de usuario en el servicio de GitHub.
- Debes ser una persona para crear una cuenta. No se permiten las cuentas que registren ni los "bots", ni otros métodos automatizados. Permitimos cuentas de máquina:
- Una cuenta de máquina se refiere a una cuenta registrada por una persona que acepta los términos aplicables del servicio en nombre de la Cuenta, proporciona una dirección de correo electrónico válida y es responsable de sus acciones. Una Cuenta de máquina se usa exclusivamente para ejecutar tareas automatizadas. Múltiples usuarios pueden dirigir las acciones de una cuenta de máquina, pero el propietario de la cuenta es responsable en última instancia de las acciones de la máquina. No puedes mantener más de una cuenta de máquina gratuita además de tu cuenta de usuario gratuita.
- Una persona o entidad legal no puede mantener más de una cuenta gratuita (si también decide controlar una cuenta de máquina, está bien, pero sólo se puede utilizar para ejecutar una máquina).
- Debes ser mayor de 13 años. Si bien estamos encantados de ver a los geniales programadores jóvenes entusiasmados aprendiendo a programar, debemos cumplir con la ley de los Estados Unidos. GitHub no dirige nuestro Servicio a niños menores de 13 años y no permitimos ningún Usuario menor de 13 años en nuestro Servicio. Si tenemos conocimiento de algún usuario menor de 13 años, [daremos por terminada inmediatamente la cuenta del usuario](#l-cancellation-and-termination). Si estás ubicado en un país fuera de los Estados Unidos, la edad mínima de ese país puede ser mayor; en ese caso, el Cliente es responsable de cumplir con las leyes de ese país.
- Su inicio de sesión sólo puede usarse por una persona — es decir, un único inicio de sesión no puede ser compartido por varias personas. Una Organización de pago sólo puede proporcionar acceso a tantas cuentas de usuario como su suscripción lo permita.
- No puedes usar GitHub en violación de las leyes de control de exportación o sanciones de los Estados Unidos o de cualquier otra jurisdicción aplicable. No puedes usar GitHub si estás trabajando o en nombre de un [Nacional Especialmente Diseñado (SDN)](https://www.treasury.gov/resource-center/sanctions/SDN-List/Pages/default.aspx) o una persona sujeta a prohibiciones similares de bloqueo o denegadas por una agencia gubernamental de EE. UU. government agency.  GitHub puede permitir que personas en ciertos países o territorios sancionados accedan a ciertos servicios de GitHub de conformidad con las autorizaciones del gobierno de los Estados Unidos. government authorizations.  Para obtener más información, consulta nuestra[Política de Controles de Exportación](/articles/github-and-export-controls).

#### 4. Seguridad de la cuenta de usuario
Eres responsable de mantener tu Cuenta segura mientras utilizas nuestro Servicio. Ofrecemos herramientas como autenticación de dos factores para ayudarte a mantener la seguridad de tu cuenta pero el contenido de tu Cuenta y su seguridad depende de ti.
- Eres responsable de todo el contenido publicado y la actividad que se produzca bajo tu Cuenta (incluso cuando el contenido sea publicado por otros que tienen Cuentas bajo tu Cuenta).
- Eres responsable de mantener la seguridad de tu cuenta y contraseña. GitHub no será responsable de ninguna pérdida o daño que surja del incumplimiento de esta obligación de seguridad.
- Debes notificar inmediatamente [a GitHub](https://support.github.com/contact) si tienes conocimiento de cualquier uso no autorizado, o acceso a nuestro Servicio a través de tu Cuenta, incluyendo cualquier uso no autorizado de tu contraseña o Cuenta.

#### 5. Términos adicionales
En algunas situaciones, pueden aplicarse términos de terceros a tu uso de GitHub. Por ejemplo, puedes ser miembro de una Organización en GitHub con tus propios términos o acuerdos de licencia; puedes descargar una aplicación que se integre con GitHub; o puedes usar el Servicio para autenticarte a otro servicio. Ten en cuenta que aunque estos Términos son nuestro acuerdo total contigo, los términos de otras partes rigen sus relaciones contigo.

Si eres un usuario del gobierno o de otro modo accedes o utilizas cualquier servicio de GitHub en una capacidad gubernamental, esta [Enmienda del Gobierno a los Términos de Servicio de GitHub](/articles/amendment-to-github-terms-of-service-applicable-to-u-s-federal-government-users/) aplican para ti y debes aceptar sus disposiciones.

Si te registraste en la nube GitHub Enterprise, la [ Apéndice Enterprise Cloud ](/articles/github-enterprise-cloud-addendum/) aplica para ti y debes aceptar sus disposiciones.

### C. Uso aceptable
**Versión simplificada:** *GitHub presenta una amplia variedad de proyectos en equipo en todo el mundo y dicha cooperación solamente funciona cuando nuestros usuarios pueden trabajar juntos con buenas intenciones. Mientras usas el Servicio, debes cumplir con los términos de esta sección, que incluyen algunas restricciones sobre el contenido que puedes publicar, que realizar en el servicio y otras limitaciones. En síntesis, la idea es que sean geniales entre sí.*

Tu uso del sitio web y del servicio no debe violar ninguna ley aplicable, incluyendo leyes de derechos de autor o de marcas, leyes de control de exportación o sanciones, u otras leyes de su jurisdicción. Eres responsable de asegurarte que tu uso del Servicio cumpla con las leyes y cualquier normativa aplicable.

Aceptas que en ningún caso violarás nuestras [Políticas de uso aceptable](/articles/github-acceptable-use-policies) o [Directrices de la comunidad](/articles/github-community-guidelines).

### D. Contenido generado por el usuario
/**Versión resumida+*:** *Eres propietario del contenido que creas, pero nos permitirás ciertos derechos para que podamos mostrar y compartir el contenido que publiques. Continúas teniendo el control sobre tu contenido y responsabilidad por el mismo y los derechos que nos concedes están limitados a aquellos que necesitamos para proporcionar el servicio. Tenemos derecho a eliminar el contenido o cerrar cuentas si lo necesitamos.*

#### 1. Responsabilidad para el Contenido generado por el usuario
Puedes crear o cargar Contenido generado por el Usuario mientras usas el Servicio. Eres el único responsable del contenido y por cualquier daño que resulte de cualquier Contenido generado por el Usuario que publiques, cargues, enlaces o que de otra forma esté disponible a través del Servicio, independientemente de la forma de dicho Contenido. No eres responsable de ninguna visualización pública o uso indebido del Contenido generado por el Usuario.

#### 2. GitHub puede eliminar contenido
No pre-seleccionamos el Contenido generado por el Usuario, pero tenemos el derecho (aunque no la obligación) de rechazar o eliminar cualquier contenido generado por el usuario que, a nuestra sola discreción, viole cualquier [condición o política de GitHub](/github/site-policy).

#### 3. Propiedad del Contenido, Derecho a publicar y Otorgamientos de licencia
Conservas la propiedad y la responsabilidad de tu contenido. Si estás publicando algo que no hayas creado tu mismo o de lo cual no posees los derechos, aceptas que eres responsable de cualquier Contenido que publiques; que sólo enviarás contenido que tengas derecho a publicar; y que cumplirás plenamente con cualquier licencia de terceros relacionada con el Contenido que publiques.

Ya que conservas la propiedad y la responsabilidad de tu contenido, necesitamos que nos concedas — y a otros usuarios de GitHub — ciertos permisos legales, listados en las Secciones D. — D.7. Estas licencias se aplican a Tu Contenido. Si cargas Contenido que ya viene con una licencia que le otorga a GitHub los permisos que necesita para ejecutar el Servicio, no se requiere ninguna licencia adicional. Debes comprender que no recibirás ningún pago por ninguno de los derechos otorgados en las Secciones D.4 — D.7. Las licencias que nos concedes terminarán cuando retires Tu Contenido de nuestros servidores, a menos que otros Usuarios lo hayan bifurcado.

#### 4. Licencia otorgada
Necesitamos el derecho legal de hacer cosas como alojar Tu Contenido, publicarlo y compartirlo. Nos concedes y a nuestros sucesores legales el derecho a almacenar, analizar y mostrar tu contenido, y hacer copias incidentales según sea necesario para prestar el Sitio Web y prestar el Servicio. Esto incluye el derecho a hacer cosas como copiarlo a nuestra base de datos y hacer copias de seguridad; mostrártelo y mostrarlo a otros usuarios; analizarlo en un índice de búsqueda o analizarlo en nuestros servidores; compartirlo con otros usuarios; y ejecutarlo, en caso de que Tu Contenido sea algo como música o vídeo.

Esta licencia no le otorga a GitHub el derecho a vender Tu Contenido o de otra forma distribuirlo o utilizarlo por fuera de nuestra prestación del Servicio.

#### 5. Otorgamiento de la licencia a otros Usuarios
Cualquier contenido generado por el usuario que postees públicamente, incluyendo temas, comentarios y contribuciones a los repositorios de otros usuarios, puede ser visto por otros. Al configurar tus repositorios para ser vistos públicamente, aceptas permitir a otros ver y "bifurcar" tus repositorios (esto significa que otros pueden hacer sus propias copias de Contenido de tus repositorios en los repositorios que controlan).

Si configuras tus páginas y repositorios para ser vistos públicamente, estás otorgando a cada usuario de GitHub una licencia no exclusiva a nivel mundial para usar, mostrar, y reproducir Tu Contenido a través del Servicio de GitHub y para reproducir Tu Contenido únicamente en GitHub según lo permitido a través de la funcionalidad de GitHub (por ejemplo, a través de bifurcación). Puedes otorgar derechos adicionales si [adoptas una licencia](/articles/adding-a-license-to-a-repository/#including-an-open-source-license-in-your-repository). Si estás cargando Contenido que no creaste ni posees, eres responsable de asegurar que el Contenido del Cliente que carga cuente con licencia conforme a los términos que otorgan estos permisos a los Usuarios externos.

#### 6. Contribuciones conforme a la Licencia del repositorio
Siempre que hagas una contribución a un repositorio que contenga un aviso de licencia, estás autorizando tu contribución conforme a los mismos términos y aceptas que tienes derecho a licenciar dicha contribución conforme a esos términos. Si tienes otro acuerdo para licenciar tus contribuciones conforme a términos diferentes, tal como un acuerdo de licencia de colaborador, ese acuerdo prevalecerá.

¿No es así justo como funciona ahora? Sí. Esto se acepta ampliamente como la norma en la comunidad de código abierto; se conoce comúnmente por el abreviado "inbound=outbound". Lo estamos haciendo explícito.

#### 7. Derechos morales
Conservas todos los derechos morales sobre Tu Contenido que cargas, publicas o envías a cualquier parte del Servicio, incluyendo los derechos de integridad y atribución. Sin embargo, renuncias a estos derechos y aceptas no ejercerlos contra nosotros para ejercer razonablemente los derechos otorgados en la Sección D.4, pero no de otra manera.

En la medida en que este acuerdo no sea exigible por la legislación aplicable, concedes a GitHub los derechos que necesitamos para usar Tu Contenido sin atribución y para hacer adaptaciones razonables de Tu Contenido según sea necesario para prestar el Sitio Web y el Servicio.

### E. Repositorios privados
**Versión resumida:** *Puedes tener acceso a repositorios privados. Tratamos el contenido de los repositorios privados como confidencial y sólo accedemos a él por razones de soporte, con tu consentimiento o si es necesario por razones de seguridad.*

#### 1. Control de repositorios privados
Algunas cuentas pueden tener repositorios privados, que permiten al Usuario controlar el acceso al Contenido.

#### 2. Control de repositorios privados
GitHub considera que el contenido de los repositorios privados es confidencial para ti. GitHub protegerá el contenido de los repositorios privados del uso no autorizado, el acceso, o divulgación de la misma manera que utilizaríamos para proteger nuestra propia información confidencial de naturaleza similar y, en ningún caso, con un grado de atención más razonable.

#### 3. Acceso
El personal de GitHub solo puede acceder al contenido de tus repositorios privados en las siguientes situaciones:
- Con su consentimiento y conocimiento, por razones de soporte. Si GitHub ingresa a un repositorio privado por razones de soporte, sólo lo haremos con el consentimiento y el conocimiento del propietario.
- Cuando se requiere acceso por razones de seguridad, incluyendo cuando se requiere acceso para mantener la confidencialidad, integridad, disponibilidad y resistencia continua de los sistemas y el Servicio de GitHub.

Puedes decidir habilitar acceso adicional a tus repositorios privados. Por ejemplo:
- Puedes habilitar diversos servicios o funciones de GitHub que requieren derechos adicionales sobre Tu Contenido en los repositorios privados. Estos derechos pueden variar dependiendo del servicio o función, pero GitHub continuará tratando su contenido de repositorio privado como confidencial. Si estos servicios o características requieren derechos además de aquellos que necesitamos para proporcionar el servicio de GitHub, le daremos una explicación sobre esos derechos.

#### 4. Exclusiones
Si tienes razones para creer que el contenido de un repositorio privado incumple la ley o de estos Términos, tenemos el derecho de ingresar, revisar y eliminar dicho contenido. Además, podemos estar [obligados por ley](/github/site-policy/github-privacy-statement#for-legal-disclosure) a divulgar el contenido de tus repositorios privados.

### F. Violación de la propiedad intelectual y la política de DMCA
Si crees que el contenido de nuestro sitio web viola tus derechos de autor, por favor contáctanos de acuerdo con nuestra [Política sobre la Ley de Derechos de Autor Digital del Milenio](/articles/dmca-takedown-policy/). Si eres propietario de derechos de autor y consideras que el contenido en GitHub viola tus derechos, por favor contáctanos a través de [nuestro sencillo formulario DMCA](https://github.com/contact/dmca) o enviando un correo electrónico a copyright@github.com. Puede haber consecuencias legales por enviar un aviso de sumisión falso o poco serio. Antes de enviar una solicitud de sumisión, debes considerar usos legales tales como uso justo y usos autorizados.

Cancelaremos las Cuentas de [infractores insistentes](/articles/dmca-takedown-policy/#e-repeated-infringement) de esta política.

### G. Notificación de propiedad intelectual
**Versión resumida:** *Somos dueños del servicio y de todo nuestro contenido. Para que puedas utilizar nuestro contenido, te damos ciertos derechos, pero sólo puedes utilizar nuestro contenido de la forma que lo hemos permitido.*

#### 1. Derechos de GitHub sobre el Contenido
GitHub y nuestros licenciatarios, vendedores, agentes y/o nuestros proveedores de contenidos conservan la propiedad de todos los derechos de propiedad intelectual de cualquier tipo relacionados con el Sitio Web y el Servicio. Nos reservamos todos los derechos que no se le conceden expresamente en virtud de este Acuerdo o por ley. La apariencia del Sitio Web y el Servicio es propiedad intelectual de GitHub, Inc. Todos los derechos reservados. No puedes duplicar, copiar o volver a usar ninguna parte de los elementos o conceptos de HTML/CSS, Javascript o de diseño visual sin autorización expresa por escrito de GitHub.

#### 2. Nombres comerciales y logos de GitHub
Si deseas usar las marcas registradas de GitHub, debes seguir todas nuestras directrices de marca registrada, incluyendo las que aparecen en nuestra página de logos: https://github.com/logos.

#### 3. Licencia a políticas de GitHub
La presente Declaración de privacidad está autorizada conforme a esta [licencia de Creative Commons Zero](https://creativecommons.org/publicdomain/zero/1.0/). Para obtener más detalles, consulta nuestro [repositorio de políticas del sitio](https://github.com/github/site-policy#license).

### H. Términos de la API
**Versión resumida:** *Aceptas estos términos de servicio, además de esta sección H, al usar cualquiera de las API de GitHub (Interfaz del Proveedor de la Aplicación), incluyendo el uso de la API a través de un producto de terceros que ingresa a GitHub.*

Las solicitudes abusivas o excesivamente frecuentes a GitHub a través de la API pueden resultar en la suspensión temporal o permanente del acceso de tu Cuenta a la API. GitHub, a nuestra sola discreción, determinará el abuso o el uso excesivo de la API. Intentaremos avisarte por correo electrónico antes de la suspensión.

No puedes compartir tokens API para exceder las limitaciones de velocidad de GitHub.

No puedes utilizar la API para descargar datos o Contenido de GitHub con fines de spamming, incluyendo el propósito de vender la información personal de los usuarios de GitHub, tales como reclutadores, cazatalentos y bolsas de trabajo.

Todo uso de la API de GitHub está sujeto a estos términos de servicio y a la [Declaración de privacidad de GitHub](https://github.com/site/privacy).

GitHub puede ofrecer acceso basado en suscripción a nuestra API para aquellos usuarios que requieren acceso de alto rendimiento o acceso que resultaría en reventa del servicio de GitHub.

### I. Términos adicionales de los productos de GitHub
**Versión resumida:** *Debes seguir ciertos términos y condiciones específicos para las diversas características y productos de GitHub y aceptas los Términos y Condiciones Suplementarios cuando estés de acuerdo con este Contrato.*

Algunas características del servicio pueden estar sujetas a términos adicionales específicos de esa característica o producto según lo establecido en los términos adicionales del producto de GitHub. Al ingresar o utilizar los Servicios, también aceptas los [Términos de adicionales del producto de GitHub](/github/site-policy/github-additional-product-terms).

### J. Vista previa Beta
**Versión resumida:** *Las vistas previas Beta no pueden ser soportadas o pueden cambiar en cualquier momento, puedes recibir información confidencial a través de aquellos programas que deben permanecer confidenciales mientras el programa es privado y nos encantaría tener tu opinión para mejorar nuestras Vistas Previas Beta.*

#### 1. Sujeto a cambio

Las Vistas previas Beta pueden no ser compatibles y pueden cambiarse en cualquier momento sin previo aviso. Además, las Vistas Previas Beta no están sujetas a las mismas medidas de seguridad y de auditoría a las que se encuentra sujeto el Servicio. **Al hacer uso de una Vista Previa beta, la estás utilizando bajo tu propio riesgo.**

#### 2. Confidentiality

Como usuario de las Vistas Previas Beta, puedes tener acceso a información especial que no está disponible para el resto del mundo. Debido a la naturaleza delicada de esta información, es importante que nos aseguremos que mantengas esa información en secreto.

**Obligaciones de confidencialidad.** Aceptas que cualquier información no pública de Vista Previa Beta que te proporcionamos, como información sobre una vista previa privada Beta, se considerará información confidencial de GitHub (colectivamente, “Información Confidencial”), independientemente de si está marcada o identificada como tal. Aceptas usar dicha Información Confidencial únicamente para el propósito expreso de probar y evaluar la Vista Previa Beta (el “Propósito”) y para ningún otro propósito. Debes tener el mismo cuidado que con tu propia información confidencial pero no menos de las precauciones razonables para prevenir cualquier uso no autorizado, revelación, publicación o divulgación de nuestra Información Confidencial. Te comprometes a no revelar, publicar o divulgar ninguna Información Confidencial a terceros a menos que no prohibamos o restrinjamos dicha divulgación (por ejemplo, puede ser parte de una discusión de grupo organizada por GitHub acerca de una característica de la Vista Previa Beta).

**Excepciones.** La Información Confidencial no incluirá información que: (a) sea o esté disponible públicamente sin violación de este Contrato a través de ningún acto o inacción por su parte (como cuando una Vista Previa Beta privada se convierte en una Vista Previa Beta pública); (b) conozcas antes de que lo divulguemos; (c) esté desarrollada independientemente por ti sin violación de ninguna obligación de confidencialidad con nosotros o con terceros; o (d) sea revelada con permiso de GitHub. No violarás los términos de este Acuerdo si se te pide revelar Información Confidencial de acuerdo con el funcionamiento de la ley, siempre y cuando GitHub haya recibido un aviso por escrito razonable para objetar, a menos que la ley lo prohíba.

#### 3. Comentarios

Siempre estamos tratando de mejorar los productos y servicios y tus comentarios como usuario de las Vistas Previas Beta nos ayudarán a hacerlo. Si decides darnos cualquier idea, conocimiento, algoritmos, contribuciones de código, sugerencias, solicitudes de mejora, recomendaciones o cualquier otro comentario para nuestros productos o servicios (colectivamente, "Comentarios"), reconoces y aceptas que GitHub tendrá una licencia sin cargo de regalías completamente pagada, mundial, transferible, irrevocable para implementar, usar, modificar, explotar comercialmente y/o incorporar los Comentarios en nuestros productos, servicios y documentación.

### K. Pago
**Versión resumida:** *Eres responsable de cualquier cargo asociado con tu uso de GitHub. Somos responsables de comunicarte esos cobros con claridad y precisión y de hacerte saber con mucha antelación si esos precios cambian.*

#### 1. Precios
Nuestros precios y términos de pago están disponibles en [github.com/pricing](https://github.com/pricing). Si aceptas un precio de suscripción, ese seguirá siendo tu precio durante la duración del plazo de pago; sin embargo, los precios están sujetos a cambios al final de un plazo de pago.

#### 2. Mejoras, descensos y cambios
- Te cobraremos inmediatamente cuando pase del plan gratuito a cualquier plan de pago.
- Si cambias de un plan de facturación mensual a un plan de facturación anual, GitHub te cobrará por un año completo en la próxima fecha de facturación mensual.
- Si mejoras a un mayor nivel de servicio, te cobraremos el plan actualizado inmediatamente.
- Puedes cambiar tu nivel de servicio en cualquier momento [eligiendo una opción de plan](https://github.com/pricing) o entrando a tu [configuración de facturación](https://github.com/settings/billing). Si decides bajar la categoría de tu Cuenta, puedes perder el acceso al Contenido, características o capacidad de tu Cuenta. Consulta nuestra sección sobre [Cancelación](#l-cancellation-and-termination) para obtener información sobre cómo obtener una copia de ese contenido.

#### 3. Programación de facturación; no reembolsos
**Pago basado en el plan** para planes de pago mensuales o anuales, el Servicio se cobra con antelación de forma mensual o anual respectiva y no es reembolsable. No habrá reembolsos o créditos Para meses parciales de servicio, reembolsos o reembolsos durante meses sin usar con una cuenta abierta; sin embargo, el servicio permanecerá activo durante el período de facturación pagado. Para tratar a todos por igual, no se harán excepciones.

**Pago basado en el uso** Algunas funciones de servicio se facturan según su uso. Una cantidad limitada de estas características del Servicio puede incluirse en su plan por un período limitado sin cargo adicional. Si decides comprar características de Servicio pagadas más allá de la cantidad incluida en tu plan, pagarás por estas funciones del Servicio con base en tu uso real en el mes anterior. El pago mensual de estas compras se cobrará de forma periódica en mora. Consulte los [Términos adicionales del producto de GitHub para conocer más detalles](/github/site-policy/github-additional-product-terms).

**Facturación** Para usuarios facturados, el usuario acepta pagar los cobros en su totalidad, por adelantado sin deducción ni saldar cuentas de ningún tipo, en dólares americanos. estadounidenses. El usuario debe pagar las cuotas dentro de treinta (30) días a partir de la fecha de facturación de GitHub. Los importes pagaderos en virtud de este Acuerdo no son reembolsables, excepto que se estipule de otro modo en este Acuerdo. Si el usuario no paga las cuotas a tiempo, GitHub se reserva el derecho, además de tomar cualquier otra acción conforme a derecho o equidad, a (i) cobrar intereses sobre importes vencidos en 1.0% al mes o el tipo de interés más alto permitido por la ley, el que sea menor y a cobrar todos los gastos de recuperación y (ii) cancelar el formulario de pedido aplicable. El usuario es el único responsable de todos los impuestos, tarifas, obligaciones y valoraciones gubernamentales (a excepción de los impuestos basados en los ingresos netos de GitHub) que se imponen o vencen en relación con el presente Acuerdo.

#### 4. Autorización
Al aceptar estos términos, nos das permiso para hacer un cargo a tu tarjeta de crédito en el archivo Cuenta de PayPal, u otros métodos de pago aprobados para los cobros que autorizas para GitHub.

#### 5. Responsabilidad de pago
Eres responsable de todas las cuotas, incluyendo los impuestos, asociados con tu uso del Servicio. Al utilizar el Servicio, aceptas pagar a GitHub cualquier cobro incurrido en relación con tu uso del Servicio.  Si impugnas el asunto, ponte en contacto con [el soporte de GitHub](https://support.github.com/contact). Eres responsable de proporcionarnos un medio de pago válido para las pagar las Cuentas. Las cuentas gratuitas no están obligadas a proporcionar información de pago.

### L. Cancelación y terminación
**Versión resumida:** *Puedes cerrar tu Cuenta en cualquier momento. Si lo haces, trataremos tu información de forma responsable.*

#### 1. Cancelación de la cuenta
Es tu responsabilidad cancelar correctamente tu cuenta con GitHub. Puedes [cancelar tu cuenta en cualquier momento](/articles/how-do-i-cancel-my-account/) entrando a tu Configuración en la barra de navegación global en la parte superior de la pantalla. La pantalla de la Cuenta proporciona un enlace simple y sin preguntas de cancelación. No podemos cancelar Cuentas en respuesta a una solicitud de correo electrónico o teléfono.

#### 2. Tras la cancelación
Conservaremos y usaremos tu información cuando sea necesario para cumplir con nuestras obligaciones legales, resolver disputas y hacer cumplir nuestros acuerdos, pero sin requerimientos legales, borraremos tu perfil completo y el Contenido de tus repositorios dentro de los 90 días posteriores a la cancelación o terminación (aunque es posible que permanezca alguna información en las copias de seguridad cifradas). Esta información no se puede recuperar una vez que su cuenta sea cancelada.

No eliminaremos el contenido con el que hayas contribuido a los repositorios de otros usuarios o que otros usuarios hayan bifurcado.

Si se solicita, haremos un esfuerzo razonable para proporcionar al propietario de una cuenta una copia de los contenidos legales, no infringido de la Cuenta después de la cancelación, terminación o descenso de categoría. Debes hacer esta solicitud dentro de los 90 días siguientes a la cancelación, terminación o descenso de categoría.

#### 3. GitHub pueder rescindir
GitHub tiene derecho a suspender o rescindir tu acceso a todas o a cualquier parte del sitio web en cualquier momento con o sin causa, con o sin previo aviso, efectivo inmediatamente. GitHub se reserva el derecho de denegar el servicio a cualquier persona por cualquier motivo en cualquier momento.

#### 4. Continuidad
Todas las disposiciones de este Acuerdo que, por su naturaleza, deben sobrevivir a la terminación *sobrevivirán* la terminación — incluyendo, sin limitación: Disposiciones de propiedad, exenciones de garantía, indemnización y limitaciones de responsabilidad.

### M. Comunicaciones con GitHub
**Versión resumida:** *Utilizamos correo electrónico y otros medios electrónicos para mantenernos en contacto con nuestros usuarios.*

#### 1. Comunicación electrónica requerida
Para propósitos contractuales, (1) otorgarás tu consentimiento para recibir nuestras comunicaciones en forma electrónica a través de la dirección de correo electrónico que ingresaste o a través del Servicio; y (2) aceptarás que todos los Términos de Servicio, acuerdos, avisos, revelaciones, y otras comunicaciones que le proporcionamos electrónicamente satisfacen cualquier requisito legal que dichas comunicaciones satisfagan si estuvieran en papel. Esta sección no afecta tus derechos no renunciables.

#### 2. El aviso legal para GitHub debe ser por escrito
Las comunicaciones realizadas a través del correo electrónico o el sistema de mensajería de soporte de GitHub no constituirán un aviso legal a GitHub ni a ninguno de sus oficiales, empleados, agentes o representantes en cualquier situación en la que el aviso a GitHub se requiera por contrato o cualquier ley o reglamento. El aviso legal a GitHub debe ser por escrito y [presentado al agente legal de GitHub](/articles/guidelines-for-legal-requests-of-user-data/#submitting-requests).

#### 3. Sin soporte telefónico
GitHub sólo ofrece soporte por correo electrónico, comunicaciones en el servicio y mensajes electrónicos. No ofrecemos soporte telefónico.

### N. Exención de garantías
**Versión resumida:** *Proporcionamos nuestro servicio tal y como es y no hacemos promesas ni garantías sobre este servicio. Lee esta sección cuidadosamente; deberías entender qué esperar.*

GitHub proporciona el sitio web y el servicio “tal cual” y “según disponibilidad”, sin garantía de ningún tipo. Sin perjuicio de esto, renunciamos expresamente a todas las garantías, ya sean explícitas, implícitas o reglamentarias, respecto al Servicio Web y el Servicio incluyendo entre otras cualquier garantía implícita de comercialización, idoneidad para un propósito en particular, título, seguridad, precisión y de no incumplimiento.

GitHub no garantiza que los Servicios cumplan con tus requisitos; que el Servicio no se interrumpa y sea oportuno, seguro o sin errores; que la información que se provee a través de los Servicios sea precisa, confiable o correcta; que cualquier defecto o error será corregido; que el Servicio estará disponible en cualquier momento o ubicación en particular; o que el Servicio se encuentra libre de virus u otros componentes dañinos. Asumes toda la responsabilidad y el riesgo de pérdida resultante de su descarga y/o uso de archivos, información, contenido u otro material obtenido del Servicio.

### O. Limitación de responsabilidad
**Versión resumida:** *No seremos responsables de daños o pérdidas derivadas de tu uso o incapacidad para usar el servicio o de cualquier otra forma que surja en virtud de este acuerdo. Lee esta sección cuidadosamente; esto limita nuestras obligaciones contigo.*

Comprendes y aceptas que no seremos responsables ante ti o ante ningún tercero por ninguna pérdida de ganancias, uso, buena voluntad, o datos, o para cualquier daño accidental, indirecto, especial, consecuencial o exemplatorio, que surjan sin embargo de

- el uso, divulgación o visualización de tu contenido generado por el usuario;
- tu uso o incapacidad para usar el Servicio;
- cualquier modificación, cambio de precios, suspensión o interrupción del Servicio;
- el Servicio generalmente o el software o sistemas que hacen el Servicio disponible;
- acceso no autorizado a o alteraciones de tus transmisiones o datos;
- declaración o conducta de cualquier tercero en el Servicio;
- cualquier otra interacción de usuario que introduzca o reciba a través del uso del Servicio; o
- cualquier otro asunto relacionado con el Servicio.

Nuestra responsabilidad es limitada, ya sea que hayamos sido informados o no de la posibilidad de tales daños, e incluso si se descubre que un remedio establecido en este Acuerdo no ha cumplido su propósito esencial. No nos responsabilizaremos por ningún fallo o retraso debido a asuntos que escapen a nuestro control razonable.

### P. Liberación e indemnización
**Versión resumida:** *Eres responsable de tu uso del servicio. Si dañas a otra persona o entras en una disputa con otra persona, no estaremos implicados.*

Si tienes una disputa con uno o más usuarios, aceptas liberar a GitHub de todos y cada uno de los reclamos, demandas y daños (reales y consecuentes) de todo tipo y naturaleza, conocidos y desconocidos, que surjan de o de cualquier forma relacionados con tales disputas.

Aceptas indemnizarnos, defendernos y liberarnos de toda responsabilidad contra cualquier reclamación, responsabilidad y gastos, incluyendo los honorarios de abogados, derivados del uso del Sitio Web y del Servicio, incluyendo sin limitación a tu violación de este Acuerdo, considerando que GitHub (1) te dé un aviso por escrito de la reclamación, demanda, juicio o procedimiento; (2) te da control exclusivo de la defensa y resolución de reclamaciones, demanda, juicio o diligencia (siempre y cuando no pueda solucionar ninguna reclamación, demanda, juicio o diligencia, a menos que el acuerdo libere incondicionalmente a GitHub de toda responsabilidad); y (3) te proporcione toda la asistencia razonable, a su cargo.

### Q. Modificaciones a estos términos
**Versión resumida:** *Desamos que nuestros usuarios estén informados sobre los cambios importantes en nuestros términos, pero algunos cambios no son tan importantes — no queremos molestarte cada vez que arreglamos un error tipográfico. Así que mientras podamos modificar este acuerdo en cualquier momento, notificaremos a los usuarios de cualquier cambio que afecte a sus derechos y te daremos tiempo para ajustarte a ellos.*

Nos reservamos el derecho, a nuestro exclusivo criterio, de modificar el presente Acuerdo en cualquier momento y actualizaremos este Acuerdo en el caso en que ocurran dichas modificaciones. Notificaremos a nuestros Usuarios sobre los cambios sustanciales al presente Acuerdo, tales como cambios en los precios, al menos 30 días antes de que el cambio entre en vigencia publicando un aviso en el Servicio. Para modificaciones no sustanciales, el uso continuo del Servicio por parte del Cliente representa la aceptación de nuestras revisiones sobre el presente Acuerdo. Puedes visualizar todas las modificaciones a estos Términos en nuestro repositorio [Site Policy](https://github.com/github/site-policy)-.

Nos reservamos el derecho en cualquier momento y de vez en cuando de modificar o interrumpir, temporal o permanentemente, el Sitio Web (o cualquier parte de este) con o sin notificación.

### R. Varios

#### 1. Legislación aplicable
Excepto en la medida en que la ley aplicable establezca lo contrario, este Acuerdo entre tu persona y GitHub y cualquier acceso o uso del Sitio Web o del Servicio se rige por las leyes federales de los Estados Unidos de América y las leyes del Estado de California, sin tener en cuenta el conflicto de disposiciones legales. Tú y GitHub acuerdan someterse a la jurisdicción exclusiva y sede de los tribunales ubicados en la Ciudad y el Condado de San Francisco, California.

#### 2. Intransferible
GitHub puede asignar o delegar estos Términos de Servicio y/o la [Declaración de privacidad de GitHub](https://github.com/site/privacy), en su totalidad o en parte, a cualquier persona o entidad en cualquier momento con o sin tu consentimiento, incluyendo la concesión de licencia en la Sección D.4. No puedes asignar ni delegar ningún derecho u obligación bajo los Términos de Servicio o Declaración de Privacidad sin nuestro previo consentimiento por escrito y ninguna asignación no autorizada y delegación por ti es nula.

#### 3. Encabezados y resúmenes de sección
A lo largo de este Acuerdo, cada sección incluye títulos y breves resúmenes de los siguientes términos y condiciones. Estos títulos de sección y breves resúmenes no son legalmente vinculantes.

#### 4. Divisibilidad, sin exención y supervivencia
Si alguna parte de este Acuerdo es considerada inválida o no aplicable, esa parte del Acuerdo será interpretada para reflejar la intención original de las partes. Las partes restantes permanecerán en pleno vigor y efecto. Cualquier incumplimiento por parte de GitHub para hacer cumplir cualquier disposición de este Acuerdo no será considerado una renuncia a nuestro derecho a hacer cumplir dicha disposición. Nuestros derechos en virtud de este Acuerdo sobrevivirán a cualquier rescisión de este Acuerdo.

#### 5. Enmiendas, acuerdo completo
Este Acuerdo sólo puede modificarse por una enmienda por escrito firmada por un representante autorizado de GitHub o por la publicación de GitHub de una versión revisada de acuerdo con la sección [Q. Cambios a estos términos](#q-changes-to-these-terms). Estos Términos de Servicio, junto con la Declaración de Privacidad de GitHub, representan la declaración completa y exclusiva del acuerdo entre tu persona y nosotros. Este Acuerdo sustituye cualquier propuesta o acuerdo previo oral o escrito, y cualquier otra comunicación entre tu persona y GitHub relacionada con el tema de estos términos, incluyendo cualquier acuerdo de confidencialidad o no divulgación.

#### 6. Preguntas
¿Preguntas sobre los Términos de Servicio? [Contáctanos](https://support.github.com/contact).
