---
title: Términos complementarios de GitHub para las licencias por volumen de Microsoft
redirect_from:
  - /articles/GitHub-Supplemental-Terms-for-Microsoft-Volume-Licensing/
  - /articles/github-supplemental-terms-for-microsoft-volume-licensing
versions:
  free-pro-team: '*'
---

Fecha de entrada en vigor de la versión: 20 de julio de 2020

Los siguientes términos suplementarios de GitHub (incluyendo los formularios de pedidos correspondientes) complementan el acuerdo de licencias por volumen de Microsoft del cliente ("**Acuerdo del cliente de Microsoft**") y, junto con el acuerdo del cliente de Microsoft, rigen el uso de los productos por parte del cliente (como se define a continuación). El contrato de cliente de Microsoft se incorpora en este documento a través de esta referencia.  Los términos con mayúscula inicial usados pero no definidos en estos términos suplementarios tienen los significados asignados a ellos en el contrato de cliente de Microsoft.

Estos términos suplementarios se aplican a las siguientes ofertas de GitHub, como se define a continuación (en conjunto, el "**Productos**"):

-   GitHub Enterprise (que se compone del servidor de GitHub Enterprise, que puede incluir complemento de software y GitHub Enterprise Cloud) y GitHub One;

-   Cualquier Soporte relacionado; y

-   Cualquier Servicio profesional relacionado.

Estos términos suplementarios de GitHub incluyen las siguientes secciones y anexos, cada uno de los cuales se incorpora por referencia en el presente documento:

* SECCIÓN 1: Términos de la licencia del servidor de GitHub Enterprise;

* SECCIÓN 2: Términos de servicio de GitHub Enterprise Cloud;

* SECCIÓN 3: Disposiciones generales; y

* PRUEBA A: Definiciones.



## SECCIÓN 1: TÉRMINOS DE LA LICENCIA DEL SERVIDOR GITHUB ENTERPRISE

La presente Sección 1 detalla los términos aplicables al uso del Software por parte del Cliente.

### 1.1 Otorgamiento de la Licencia.

GitHub le otorga al Cliente una licencia de plazo limitado no exclusiva, intransferible, multinacional y exenta de regalías para instalar y usar el Software para los propósitos comerciales internos del Cliente durante el Plazo de suscripción aplicable, de acuerdo con la Documentación y solamente por el número de Licencias de suscripción establecidos en el Formulario de pedidos del Cliente. El Software incluye componentes autorizados por terceros a GitHub, incluido el software cuya licencia exige que GitHub facilite el código fuente para que esos componentes estén disponibles. El código fuente para dichos componentes se facilitará previa solicitud. Sin limitar lo anterior, esta licencia permite que el cliente descargue y ejecute la imagen del contenedor de la edición estándar de Microsoft SQL Server para los archivos de Linux ("**Imágenes de SQL Server**"), que solo se puede utilizar con el software como se documenta. El derecho del cliente a usar las imágenes de SQL Server finaliza cuando el cliente ya no tiene derechos para usar el software y el cliente debe desinstalar las imágenes de SQL Server cuando su derecho a usarlos finalice. Microsoft Corporation puede inhabilitar las imágenes de SQL Server en cualquier momento.

### 1.2 Restricciones.

A excepción de lo expresamente permitido por la ley o por la licencia de terceros aplicable, el cliente y sus filiales no deben y no deben permitir que ningún tercero: (i) sublicencie, venda, alquile, arriende, transfiera, asigne o redistribuya el software; (II) aloje el software en beneficio de terceros; (III) divulgue o permita que un tercero acceda al software, excepto como se permita expresamente en la presente sección 1; (IV) hackee o modifique la clave de licencia, o evite o modifique cualquier proceso de registro de licencia; (v) excepto las modificaciones del cliente, modifique u origine trabajos derivados del software, o fusione el software con otro software; (VI) desmonte, descompile, omita cualquier ofuscación de código o, de lo contrario, haga ingeniería inversa del software o trate de derivar cualquiera de sus códigos fuente, en su totalidad o en parte; (VII) modifique, oscurezca o elimine cualquier aviso de derechos de propiedad incluido en o en el software o la documentación; o (VIII) de lo contrario, use o copie el software o la documentación de una manera que no esté expresamente permitida por estos términos suplementarios de GitHub.

### 1.3 Delivery.

GitHub facilitará la Clave de la licencia al Cliente para descargar en un sitio web seguro protegido con contraseña. All deliveries under this Section 1 will be electronic. Para evitar dudas, el Cliente es responsable de la instalación de cualquier Software y reconoce que GitHub no tiene ninguna obligación de entrega adicional con respecto al Software después de la entrega de la Clave de la licencia. Cuando las actualizaciones estén disponibles, GitHub las facilitará para la descarga en el mismo sitio web. El Cliente debe Actualizar el Software sobre una base comercialmente razonable pero no menos de una (1) vez al año. El Cliente es responsable de mantener la confidencialidad de sus nombres de usuario y sus contraseñas.

### 1.4 Verification.

A solicitud de GitHub, el cliente proporcionará de inmediato a GitHub un informe generado por software que verifica que el cliente está usando el software de acuerdo con estos términos suplementarios de GitHub. GitHub facturará al cliente por cualquier uso adicional, efectivo desde la fecha en que su uso superó por primera vez los términos de estos términos suplementarios de GitHub.

### 1.5 Support

GitHub proporcionará soporte técnico para el software como se describe más detalladamente en el acuerdo del cliente de Microsoft. GitHub podrá proporcionar ofertas de soporte ampliado para el Software y los servicios (incluyendo aquellas para Soporte Premium, Premium Plus, y Soporte Directo de Ingeniería) de acuerdo con las [Condiciones de soporte](/enterprise/admin/enterprise-support/about-github-premium-support-for-github-enterprise), y en el nivel de soporte, cuotas y término de la suscripción que se especifica en un Formato de Compra o SOW. Sin perjuicio de cualquier disposición contraria en el acuerdo del cliente de Microsoft, (i) GitHub hará los esfuerzos razonables para corregir cualquier error material, reproducible en el software a la notificación del cliente de un error, pero no será responsable de proporcionar soporte cuando (a) alguien (que no sea GitHub) modifique el software; (b) el cliente cambie su sistema operativo o entorno de una manera que afecte adversamente el software o su desempeño; (c) el cliente use el software de una manera que no sea la autorizada conforme al acuerdo del cliente de Microsoft, esta sección 1 o la documentación; o (d) exista un accidente o negligencia del cliente, o mal uso del software; y (II) GitHub solo admitirá una versión determinada durante un (1) año a partir de la fecha de lanzamiento original, o seis (6) meses desde la última actualización del lanzamiento, la que sea más larga.

### 1.6 Updates; Releases.

#### 1.6.1 Generally.

GitHub facilitará al Cliente las Actualizaciones y Lanzamientos del Software en el mismo sitio web seguro donde el Cliente descargó el Software y la Clave de la licencia.

#### 1.6.2 Supported Releases.

GitHub solamente dará Soporte un Lanzamiento dado del Software durante un (1) año desde la fecha del Lanzamiento original, o seis (6) meses desde la última Actualización del lanzamiento, lo que sea más prolongado. Si el Cliente requiere Soporte para Lanzamientos anteriores del Software, en ese caso el Cliente debe pagar por ese Soporte de acuerdo con los términos de un Formulario de pedidos o SOW convenidos mutuamente.

### 1.7 Software agregado.

El software agregado está licenciado por usuario. Para evitar dudas y a menos que se estipule lo contrario en un formulario de pedidos, la cantidad de licencias de suscripción que el cliente tiene en un momento dado para el software del complemento debe ser igual a la cantidad de licencias de suscripción que el cliente tiene para los productos conforme a lo dispuesto en el presente acuerdo. Por ejemplo, si el cliente desea comprar una suscripción a Insights y ya cuenta con licencias de suscripción para l100 usuarios para los productos, debe comprar licencias de suscripción para 100 usuarios para Insights.

### 1.8 Consideraciones sobre la protección de datos para el uso de GitHub Insights and Learning Lab for Enterprise Server.

Si el uso planificado del cliente de GitHub Insights o Learning Lab for Enterprise Server implica el procesamiento de datos personales, el cliente es el único responsable de determinar si completar o no una evaluación de impacto de protección de datos o el análisis legal formal del uso planificado del cliente. A criterio exclusivo del cliente, ya sea usar GitHub Insights o Learning Lab for Enterprise Server para procesar los datos de los empleados y/o usuarios del cliente, y si el cliente lo hace, el cliente es el único responsable de llevar a cabo dicho procesamiento de conformidad con la legislación aplicable.

### 1.9 Garantía de Software Limitada.

GitHub garantiza que, por 90 (90) días a partir de la fecha en que se encuentra disponible para la descarga inicial, el software sin modificar se ajustará sustancialmente a su documentación. GitHub no garantiza que el uso del software por parte del cliente será ininterrumpido, o que la operación del software estará libre de errores. Esta garantía no se aplicará si el cliente modifica o usa el software de cualquier manera que no esté expresamente permitida por la presente sección 1 y la documentación. La única obligación de GitHub, y el único remedio del cliente, por cualquier incumplimiento de esta garantía limitada será como se establece en el acuerdo del cliente de Microsoft.

## SECTION 2: GITHUB ENTERPRISE CLOUD TERMS OF SERVICE

Upon creation of a Corporate Account and/or an Organization on the Service by Customer or by GitHub on Customer’s behalf, this Section 2 details terms applicable to Customer’s use of the Service.

### 2.1 Account Terms.

#### 2.1.1 Account Controls.

  **(i) Usuarios.** El Cliente reconoce que los Usuarios conservan el control administrativo final sobre sus cuentas individuales y sobre el Contenido de las mismas. [Los términos de servicio estándar de GitHub](/github/site-policy/github-terms-of-service) rigen el uso del servicio por parte de los usuarios, excepto con respecto a las actividades de los usuarios conforme a lo dispuesto en la presente sección 2.

  **(ii) Organizaciones.** El Cliente conserva el control administrativo final sobre cualquier Organización creada en nombre del Cliente y sobre el Contenido generado por el Usuario publicado en los repositorios dentro de su(s) Organización(es), sujetos a la presente Sección 2. This Section 2 will govern the use of Customer’s Organization(s).

#### 2.1.2 Account Requirements.

Para crear una cuenta, el Cliente debe adherirse a los siguientes puntos:

**(i)** El Cliente no debe crear una cuenta para que la use cualquier persona menor de 13 años. Si GitHub se entera de que existe algún Usuario menor de 13 años, cancelará esa cuenta de Usuario de inmediato. Si el Cliente o su(s) Usuario(s) están ubicados en un país fuera de los Estados Unidos, la edad mínima de ese país puede ser mayor; en ese caso, el Cliente es responsable de cumplir con las leyes de ese país.

**(ii)** Un Inicio de sesión de un Usuario no se debe compartir con múltiples personas.

**(iii)** El cliente no deberá utilizar el Servicio (a) si este viola las leyes de sanción o control de exportaciones de los Estados Unidos o de cualquier otra jurisdicción aplicable, (b) si se ubica en o reside habitualmente en un país o territorio sujeto a sanciones generales administrades por la Oficina de Control de Bienes Extranjeros de los EE.UU. (OFAC, por sus siglas en inglés), o (c) si el Cliente es o está trabajando por parte de un [Nacional Especialmente Designado (SDN, por sus siglas en inglés)](https://www.treasury.gov/resource-center/sanctions/SDN-List/Pages/default.aspx) o una persona sujeta a bloqueos o prohibiciones de la parte denegada similares. Para obtener más información, por favor consulta la [Política de controles comerciales de GitHub](/github/site-policy/github-and-trade-controls).

#### 2.1.3 Account Security.

El Cliente es responsable por lo siguiente: (i) todos los Contenidos publicados y las actividades que ocurran en su Cuenta corporativa; (ii) mantener la seguridad de sus credenciales de inicio de sesión de su cuenta; y (iii) de inmediato [notificar a GitHub](https://support.github.com/contact) al enterarse de cualquier uso no autorizado del Servicio o acceso a este a través de su cuenta.  GitHub will not be liable for any loss or damage from Customer’s failure to comply with this Section 2.1.3.

#### 2.1.4 Additional Terms.

En algunas situaciones, pueden aplicarse términos de terceros al uso del Servicio por parte del Cliente. Por ejemplo, el Cliente puede ser miembro de una Organización con sus propios términos o acuerdos de licencia; el Cliente puede descargar una aplicación que se integre con el Servicio; o el Cliente puede usar el Servicio para autenticarse a otro servicio. Si bien el acuerdo del cliente de Microsoft, incluidos estos términos complementarios de GitHub, es el acuerdo completo de GitHub con el cliente, los términos de otras partes rigen sus relaciones con el cliente.

#### 2.1.5 Términos del Gobierno federal de los EE.⁰UU. Términos del Gobierno federal de los EE.⁰UU.

If Customer is a U.S. federal government agency or otherwise accessing or using any portion of the Service in a government capacity, the [U.S. Federal Government Amendment](/github/site-policy/amendment-to-github-terms-of-service-applicable-to-us-federal-government-users) applies, and Customer agrees to its provisions.

### 2.2 Compliance with Laws; Acceptable Use; Privacy.

#### 2.2.1 Compliance with Laws and Regulations.

El uso del Servicio por parte del Cliente no debe infringir las leyes vigentes, incluidas las leyes de propiedad intelectual o el nombre comercial, las leyes de control de las exportaciones o las regulaciones en su jurisdicción.

#### 2.2.2 Acceptable Use.

El uso del servicio por parte del cliente debe cumplir con las [Políticas de Uso Aceptable de GitHub](/github/site-policy/github-acceptable-use-policies) y con [los Lineamientos de la Comunidad de GitHub](/github/site-policy/github-community-guidelines). El Cliente no debe usar el Servicio en ninguna jurisdicción si contiene Contenidos o actividades ilegales, obscenos, ofensivos o fraudulentos, tales como promover o causar daño, vulnerar la integridad o la seguridad de una red o sistema o interferir en ellos, evadir filtros, enviar mensajes no solicitados, abusivos o engañosos, virus o códigos perjudiciales, o socavar los derechos de terceros.

#### 2.2.3 Privacy.
[La Declaración de Privacidad de GitHub](/github/site-policy/github-privacy-statement) y la [Adenda de Protección de Datos de GitHub](/github/site-policy/github-data-protection-addendum) proporciona notificación detallada de las prácticas de privacidad y uso de datos así como de las obligaciones de seguridad y procesamiento de GitHub con respecto a los Datos Personales del Cliente. Cualquier persona, entidad o servicio que recolecta datos del Servicio debe cumplir con la [Declaración de privacidad de GitHub](/github/site-policy/github-privacy-statement), particularmente en cuanto a la recopilación de la Información personal del Usuario (como se define en la Declaración de privacidad de GitHub). Si el Cliente recopila cualquier Información personal del usuario proveniente de GitHub, el Cliente solamente la usará para el propósito por el cual el Usuario externo lo autorizó. El Cliente asegurará razonablemente dicha Información personal y el Cliente responderá de inmediato a las quejas, las solicitudes de eliminación y las solicitudes de "no contactar" de GitHub o de Usuarios externos.

### 2.3 Content Responsibility; Ownership; License Rights.

#### 2.3.1 Responsibility for User-Generated Content.
El Cliente puede crear o cargar Contenido generado por el Usuario mientras usa el Servicio. El Cliente es el único responsable de cualquier Contenido generado por el Usuario que se publique, cargue, vincule o ponga a disposición de cualquier otra manera a través del Servicio, independientemente de la forma de ese Contenido generado por el Usuario. GitHub no es responsable de ninguna visualización pública o uso indebido del Contenido generado por el Usuario.

#### 2.3.2 Ownership of Content, Right to Post, and License Grants.

**(i)** El Cliente mantiene la propiedad sobre el Contenido del Cliente que el Cliente crea o posee. El Cliente reconoce lo siguiente: (a) que es responsable del Contenido del Cliente, (b) que solo enviará el Contenido del Cliente que el Cliente tenga derecho a publicar (incluido el Contenido generado por el Usuario o por terceros) y (c) que el Cliente cumplirá plenamente con cualquier licencia de terceros relacionada con el Contenido del Cliente que el Cliente publica.

**(ii)** Customer grants the rights set forth in Sections 2.3.3 through 2.3.6, free of charge and for the purposes identified in those sections until such time as Customer removes Customer Content from GitHub servers, except for Content Customer has posted publicly and that External Users have Forked, in which case the license is perpetual until such time as all Forks of Customer Content have been removed from GitHub servers. Si el Cliente carga Contenido del Cliente que ya viene con una licencia y le otorga a GitHub los permisos que necesita para ejecutar el Servicio, no se requiere ninguna licencia adicional.

#### 2.3.3 License Grant to GitHub.
El Cliente le otorga a GitHub el derecho a almacenar, analizar y mostrar el Contenido del Cliente y de hacer copias incidentales solo como sea necesario para proporcionar el Servicio. Esto incluye el derecho a copiar el Contenido del Cliente en la base de datos de GitHub y a hacer copias de seguridad; mostrarle el Contenido del Cliente al Cliente y a quienes el Cliente decida; analizar el Contenido del Cliente en un índice de búsqueda o, de lo contrario, analizarlo en los servidores de GitHub; compartir el Contenido del Cliente con Usuarios externos con los cuales el Cliente elige compartirlo; y reproducir el Contenido del Cliente, en el caso de que se trate de música o vídeo. Estos derechos se aplican tanto a los Repositorios privados como a los públicos. Esta licencia no le otorga a GitHub el derecho a vender el Contenido del Cliente o a distribuirlo o utilizarlo por fuera del Servicio. El Cliente le otorga a GitHub los derechos que necesita para usar el Contenido del Cliente sin atribución y para hacer las adaptaciones razonables del Contenido del Cliente como sea necesario para proporcionar el Servicio.

#### 2.3.4 License Grant to External Users.
**(i)** Cualquier Contenido que el Cliente publica de forma pública, incluidas propuestas, comentarios y contribuciones a los repositorios de Usuarios externos, puede ser visto por otras personas. El Cliente acepta permitir que Usuarios externos vean y bifurquen los repositorios del Cliente cuando configura sus repositorios para que se vean públicamente.

**(ii)** Si el Cliente configura sus páginas y repositorios para que se vean públicamente, el Cliente les otorga a los Usuarios externos una licencia no exclusiva y multinacional para usar, mostrar y ejecutar el Contenido del Cliente a través del Servicio y para reproducir el Contenido del Cliente únicamente en el Servicio, según se permite a través de la funcionalidad que proporciona GitHub (por ejemplo, a través de la Bifurcación). El Cliente puede otorgar derechos adicionales sobre el Contenido del Cliente si el Cliente [adopta una licencia](/github/building-a-strong-community/adding-a-license-to-a-repository#including-an-open-source-license-in-your-repository). Si el Cliente está cargando Contenido del Cliente que no creó ni posee, el Cliente es responsable de asegurar que el Contenido del Cliente que carga cuente con licencia conforme a los términos que otorgan estos permisos a los Usuarios externos.

#### 2.3.5 Contributions Under Repository License.
Siempre que el Cliente hace una contribución a un repositorio que contiene un aviso de licencia, el Cliente licencia tal contribución conforme a los mismos términos y acepta que tiene derecho a licenciar dicha contribución conforme a esos términos. Si el Cliente tiene otro acuerdo para licenciar sus contribuciones conforme a términos diferentes, tal como un acuerdo de licencia de colaborador, ese acuerdo prevalecerá.

#### 2.3.6 Moral Rights.
El Cliente conserva todos los derechos morales sobre el Contenido del Cliente que carga, publica o envía a cualquier parte del Servicio, incluidos los derechos de integridad y atribución. However, Customer waives these rights and agrees not to assert them against GitHub, solely to enable GitHub to reasonably exercise the rights granted in Section 2.3, but not otherwise.

### 2.4. Repositorios privados.

#### 2.4.1 Control.

El Cliente es responsable de administrar el acceso a sus Repositorios privados, incluidas las invitaciones, el control administrativo de las Organizaciones y los equipos, y la anulación del acceso.

#### 2.4.2 Confidentiality.

GitHub considera que el Contenido del Cliente en los Repositorios privados del Cliente constituye Información confidencial del Cliente. GitHub protegerá y mantendrá estrictamente confidencial el contenido del cliente de los repositorios privados de acuerdo con la disposición de confidencialidad aplicable en el acuerdo del cliente de Microsoft.

#### 2.4.3 Access.

GitHub solo puede acceder a los Repositorios privados del Cliente (i) con el consentimiento y el conocimiento del Cliente, por razones de asistencia o (ii) cuando se requiere el acceso por razones de seguridad.  El Cliente puede decidir habilitar más acceso a sus Repositorios privados. Por ejemplo, el Cliente puede habilitar varios servicios o funciones de GitHub que requieren derechos adicionales sobre el Contenido del Cliente en los Repositorios privados. Estos derechos pueden variar según el servicio o la función, pero GitHub continuará considerando el Contenido del Cliente en los Repositorios privados del Cliente como Información confidencial. GitHub proporcionará una explicación sobre esos derechos si esos servicios o funciones requieren más derechos de los que necesita para proporcionar el Servicio.

#### 2.4.4 Exclusions.

Si GitHub tiene motivos para creer que el contenido de un repositorio privado infringe la ley o estos términos suplementarios de GitHub, GitHub tiene derecho a acceder, revisar y eliminar ese contenido. Además, GitHub puede ser obligado por ley a divulgar el Contenido de los Repositorios privados del Cliente. A menos que los requisitos previstos por la ley indiquen lo contrario o que sea en respuesta a una amenaza de seguridad u otro riesgo para la seguridad, GitHub dará aviso de tales acciones.

### 2.5. Notificaciones de propiedad intelectual.

#### 2.5.1 GitHub's Rights to Content.

La apariencia del Servicio es propiedad intelectual de © GitHub, Inc. Todos los derechos reservados. El Cliente no puede duplicar, copiar o volver a usar ninguna parte de los elementos o conceptos de HTML/CSS, Javascript o de diseño visual sin autorización expresa por escrito de GitHub.

#### 2.5.2 Copyright Infringement and DMCA Policy.

Si el Cliente es propietario de los derechos de autor y determina que el Contenido del Servicio viola dichos derechos, éste podrá contactar a GitHub de acuerdo con la [Política sobre la Ley de Derechos de Autor de la Era Digital](https://github.com/contact/dmca) de GitHub si le notifica a través de su [Formato DMCA](https://github.com/contact/dmca-notice) o si envía un mensaje de correo electrónico a copyright@github.com.

#### 2.5.3 GitHub Trademarks and Logos.

Si el Cliente desea usar los nombres comerciales de GitHub, debe seguir todas las pautas de nombres comerciales de GitHub, incluidas las que se encuentran en la [Página de logos y uso de GitHub](https://github.com/logos).

### 2.6 Suspension.

GitHub tiene el derecho de suspender el acceso a la totalidad o a cualquier parte del servicio, incluido el eliminar contenido, en cualquier momento por la violación del acuerdo del cliente de Microsoft, incluyendo estos términos suplementarios de GitHub, o para proteger la integridad, la operabilidad y la seguridad del servicio, con efecto inmediato, con o sin aviso. A menos que esté prohibido por ley o proceso legal o para prevenir daños inminentes al Servicio o a cualquier tercero, GitHub normalmente proporciona un aviso en forma de banner o correo electrónico en o antes de dicha suspensión. GitHub personalizará, a su criterio y de buena fe, cualquier suspensión que sea necesaria para preservar la integridad, operatividad y seguridad del Servicio.

### Comunicaciones con GitHub.

Con fines contractuales, el Cliente (1) consiente recibir comunicaciones en un formulario electrónico a través de la dirección de correo electrónico que se envío o a través del Servicio; y (2) acepta que todos los Términos de Servicio, acuerdos, avisos, revelaciones y otras comunicaciones que GitHub proporciona electrónicamente cumple con cualquier requerimiento legal que estas comunicaciones satisfagan si estuvieran en papel. Esta sección no afecta los derechos no renunciables del Cliente.

### 2.8 Service Level Agreement.

GitHub’s quarterly uptime commitment for the Service is provided in the [Enterprise Service Level Agreement](/github/site-policy/github-enterprise-service-level-agreement). Customer will be entitled to a service credit if GitHub does not meet its service level.

### 2.9 Service Changes.

GitHub cambia el Servicio mediante Actualizaciones y adición de nuevas características. Subject to Section 2.8, GitHub reserves the right at any time to modify or discontinue, temporarily or permanently, the Service (or any part of it) with or without notice.

### 2.10 Características adicionales del servicio.

Algunas características de servicio pueden estar sujetas a términos adicionales como se establece en los [términos de producto adicionales de GitHub](/github/site-policy/github-additional-product-terms). Al acceder o utilizar estas características, el cliente acepta las condiciones de producto adicionales de GitHub.

## SECCIÓN 3: DISPOSICIONES GENERALES.

This Section 3 sets forth the terms and conditions applicable to Customer’s purchase and use of any of the Products.

### 3,1 Plazo; terminaciones; efecto de la terminación.

#### 3.1.1 Term.
Estos términos suplementarios de GitHub continuarán en vigencia hasta que una parte la cancele de acuerdo con lo dispuesto en la presente sección 3.1.

#### 3.1.2 Terminación por conveniencia; cancelación de la cuenta.
Cualquiera de las partes puede terminar un formulario de pedidos o estos términos suplementarios de GitHub, sin causa, al menos treinta (30) días de aviso por escrito antes del final del plazo de suscripción vigente en ese momento. Si el cliente opta por terminar un formulario de pedidos o estos términos suplementarios de GitHub, es responsabilidad del cliente cancelar correctamente su cuenta con GitHub entrando en configuraciones en la barra de navegación global en la parte superior de la pantalla. GitHub no puede cancelar cuentas en respuesta a un correo electrónico o a una solicitud telefónica.

#### 3.1.3 Termination for Material Breach.
Cualquiera de las partes puede rescindir estos términos suplementarios de GitHub inmediatamente después de la notificación si la otra parte viola una obligación material conforme a lo dispuesto en los presentes términos suplementarios de GitHub y no remedia la violación dentro de los treinta (30) días a partir de la fecha en que recibe la notificación.  GitHub puede poner fin a estos términos suplementarios de GitHub si la cuenta del cliente ha sido suspendida por más de 90 días.

#### 3.1.4 Efecto de la terminación.
Tras la terminación de estos términos suplementarios de GitHub, el cliente no puede ejecutar formularios de pedidos adicionales; sin embargo, estos términos suplementarios de GitHub seguirán vigentes para el resto de los formularios de pedidos activos. Cuando un formulario de pedidos finaliza o expira, en cuanto a ese formulario de pedidos: (i) el plazo de suscripción finalizará de inmediato; (II) cualquier licencia de suscripción en el formulario de pedidos terminará automáticamente y el cliente ya no tendrá derecho a usar los productos; (III) si alguna tarifa se adeudaba antes de la terminación, el cliente debe pagar esas tarifas de inmediato; (IV) el cliente debe destruir todas las copias del software en posesión o control del cliente y certificar por escrito a GitHub que el cliente lo ha hecho; (v) cada una de las partes devolverá de inmediato (o, si la otra parte lo solicita, destruirá) toda la información confidencial que pertenezca a la otra en la medida permitida por el servicio. Sin perjuicio de lo anterior, el Cliente puede continuar accediendo al Software para migrar sus datos y puede solicitar la migración de los datos en sus repositorios por hasta noventa (90) días después de la terminación o la caducidad del presente Acuerdo o de un Formulario de pedidos; sin embargo, el Cliente no puede usar el Software o el Servicio sobre una base de producción durante ese período de tiempo. Cualquier disposición que por su naturaleza debiera mantenerse razonablemente en vigencia continuará luego de la terminación o la caducidad del presente Acuerdo o de un Formulario de pedidos.

### 3.2 Retroalimentación.
El Cliente puede proporcionar Retroalimentación a GitHub con respecto a los Productos. La retroalimentación es voluntaria y no es Información Confidencial del Cliente, incluso si se designa como tal. GitHub puede ejercer y explotar plenamente dicha Retroalimentación con el propósito de (i) mejorar la operación, funcionalidad y uso de las ofertas de productos existentes y futuras de GitHub; y (ii) publicación de estadísticas agregadas sobre la calidad de los Productos, siempre que no se utilicen datos en ninguna de estas publicaciones para identificar específicamente al Cliente, sus empleados o el código de software propietario del Cliente.

### 3.3. Cumplimiento con las leyes y regulaciones.
El cliente cumplirá con todas las leyes y regulaciones aplicables, incluyendo, entre otras, las leyes y regulaciones de protección de datos y empleo, en su uso de los productos.

### 3.4 Orden de precedencia
En el caso de un conflicto entre los términos suplementarios, por una parte, y un formulario de pedidos, por otro lado, el formulario de pedidos se regirá con respecto a esa orden únicamente. En el caso de un conflicto entre los términos suplementarios (incluyendo cualquier formulario de pedidos) y el acuerdo del cliente de Microsoft, los términos suplementarios prevalecerán con respecto al asunto únicamente.

## PRUEBA A: DEFINICIONES

**"Usuario activo"** se refiere a un Usuario que trata de acceder al Servicio en el momento de una Interrupción.

**"Software agregado"** se refiere a Advanced Security, Insights, Learning Lab for Enterprise Server y otros productos adicionales de software agregado que GitHub puede ofrecer de vez en cuando.

**"Seguridad avanzada"** se refiere a la característica de software que permite que el cliente identifique vulnerabilidades de seguridad mediante un análisis de código semántico personalizable y automatizado.

**"Subsidiaria"** se refiere a cualquier entidad que controla directa o indirectamente, que es controlada o se encuentra bajo el control normal de una parte, donde "control" significa tener más del cincuenta por ciento (50⁰%) de la propiedad o el derecho a dirigir la administración de la entidad.

**“Todos los usuarios”** se refiere, en conjunto, a los Usuarios del Cliente y los Usuarios externos que usan el Servicio.

**“Conexión”** o **“Conexión con GitHub”** se refiere a una función incluida en el Software que habilita al Cliente a conectar el Software con GitHub.com. El uso de conexión con GitHub está sujeto a los términos de conexión de GitHub establecidos en los [Términos adicionales del producto de GitHub](/github/site-policy/github-additional-product-terms).

**"Contenido"** se refiere, entre otros, a textos, datos, artículos, imágenes, fotografías, gráficos, software, aplicaciones, diseños, funciones y otros materiales que se presentan, se muestran o se ponen a disposición a través del Servicio.

**"Cuenta corporativa"** se refiere a una cuenta creada por el Usuario en nombre de una entidad.

**Cliente** significa, colectivamente, la empresa u organización que ha celebrado estos términos suplementarios de GitHub con GitHub al hacer clic en el botón "Acepto" o en un botón similar o al acceder a los productos y a los afiliados y representantes del cliente.

**"Contenido del Cliente"** se refiere al Contenido que el Cliente crea, posee o sobre el cual el Cliente tiene los derechos.

**“Modificaciones del Cliente”** se refiere a las modificaciones del Software que el Cliente puede hacer únicamente con el fin de realizar corrección de errores, personalizaciones o funciones adicionales para cualquier biblioteca con licencia en las licencias de código abierto que se pueden incluir con el Software o vincularse a este.

**"Documentación"** se refiere a cualquier manual, documentación y otros materiales de soporte relacionados con el Software o el Servicio que GitHub proporciona o pone a disposición del Cliente.

**"Fecha de vigencia"** es la primera fecha en que el cliente (i) acepta los términos y condiciones de estos términos suplementarios de GitHub, como se describe arriba, o (II) coloca primero un pedido para los productos.

**"Servicios esenciales"** se refiere a los servicios esenciales para la funcionalidad de control de la versión principal de GitHub, que incluyen crear, bifurcar y clonar repositorios; crear, confirmar y fusionar ramas; crear, revisar y fusionar solicitudes de extracción; y las interfaces web, API y Git del cliente para los flujos de Git principales. Los siguientes ejemplos muestran funciones periféricas y servicios que no están incluidos: webhooks, Gists, Páginas y notificaciones por correo electrónico.

**"Usuario externo"** se refiere a un individuo, que no incluye a los Usuarios del Cliente, que visita o usa el Servicio.

**"Cuotas"** significa que las cuotas que el cliente tiene que pagar a GitHub por (i) usar los Productos durante el término de suscripción aplicable o (ii) recibir Servicios Profesionales, ya que dichas cuotas se reflejan en un formulario de pedido o SOW.

**"Retroalimentación"** hace referencia a cualquier idea, conocimiento, algoritmos, contribuciones de código, sugerencias, solicitudes de mejora, recomendaciones o cualquier otro comentario sobre productos o servicios de GitHub.

**“Bifurcación”** se refiere a copiar el Contenido de un repositorio en otro repositorio.

**"GitHub"** se refiere, en conjunto, a GitHub, Inc., sus Subsidiarias y Representantes.

**"Contenido de GitHub"** se refiere al Contenido que GitHub crea, posee o el contenido sobre el cual tiene los derechos.

**"Insights de GitHub"** o **Insights** se refiere a la característica de software que le brinda a los clientes métricas, analíticas y recomendaciones relacionadas con el uso del software. GitHub Insights no incluye características heredadas de GitHub incluyendo información de la organización e información del repositorio.

**"GitHub One"** se refiere al paquete de productos que incluye GitHub Enterprise, Advanced Security, Insights, Learning Lab for Enterprise Server y Premium Plus o soporte de ingeniería Direct.

**"Learning Lab for Enterprise Server"** hace referencia a la función de software que permite a los usuarios aprendan sobre la funcionalidad de GitHub, incluyendo la documentación asociada.

**"Clave de licencia"** se refiere a los archivos de datos que usa el mecanismo de control de acceso del Software que le permiten al Cliente instalar, operar y usar el Software.

**“Cuenta de máquina”** se refiere a una cuenta registrada por una persona que acepta los términos aplicables del servicio en nombre de la Cuenta de máquina, proporciona una dirección de correo electrónico válida y es responsable de sus acciones. Una Cuenta de máquina se usa exclusivamente para ejecutar tareas automatizadas. Múltiples usuarios pueden dirigir las acciones de una Cuenta de máquina, pero el propietario de la cuenta es responsable en última instancia de las acciones de la máquina.

**"Formulario de pedidos"** se refiere a la documentación electrónica o por escrito (incluido un presupuesto) que las Partes usan para pedir los Productos.

**“Organización”** se refiere a un espacio de trabajo compartido que se puede asociar con una única entidad o con uno o más Usuarios donde múltiples Usuarios pueden colaborar en muchos proyectos a la vez. Un Usuario puede ser miembro de más de una Organización.

**"Interrupción"** se refiere a la interrupción de un Servicio esencial que afecta a más del 50⁰% de los Usuarios activos.

**“Repositorio privado”** se refiere a un repositorio que permite que un Usuario controle el acceso al Contenido.

**"Servicios profesionales"** se refiere a los servicios de capacitación, consultoría o implementación que GitHub proporciona conforme a un SOW ejecutado recíprocamente. Los Servicios profesionales no incluyen el Soporte.

**“Repositorio público”** se refiere a un repositorio cuyo Contenido es visible para todos los Usuarios.

**"Lanzamiento"** se refiere a un lanzamiento de Software que GitHub generalmente pone a disposición de sus clientes, junto con cualquier cambio correspondiente en la Documentación, que contiene mejoras, funciones o funcionalidades nuevas, que se suelen indicar con un cambio en el dígito a la derecha del primer punto decimal (por ejemplo, x.x.x a x.y.x) o a la izquierda del primer punto decimal (por ejemplo, x.x.x a y.x.x).

**"Representantes"** se refiere a empleados, agentes, contratistas independientes, consultores y asesores legales y financieros de una de las Partes.

**“Extracción”** se refiere a extraer datos del Servicio a través de un proceso automatizado, como un bot o agente de búsqueda, y que no incluye la recopilación de información a través de la API de GitHub.

**"Servicio"** se refiere al servicio alojado de GitHub Enterprise Cloud. El Servicio incluye:  Cuenta(s) de organización, inicio único de sesión de SAML, provisión de acceso y cualquier Documentación correspondiente. Esta lista de funciones y servicios no es exhaustiva y puede ser actualizada de vez en cuando.

**"Crédito de servicio"** se refiere a un crédito en dólares, calculado como se establece a continuación, que GitHub puede acreditar a una cuenta elegible.

**"Software"** significa el Software local de GitHub Enterprise Server. El Software incluye la característica de GitHub Connect, cualquier Documentación aplicable, cualquier Actualización al Software que Github proporcione al Cliente o al que éste pueda acceder bajo las presentes Condiciones Adicionales de GitHub y, si se incluyese en la suscripción del Cliente, el Software Complementario.

**"SOW"** se refiere a una declaración de trabajo ejecutada recíprocamente que detalla los Servicios profesionales que GitHub realizará, cualquier Tarifa relacionada y las obligaciones relacionadas de cada una de las Partes.

**“Licencia de suscripción”** se refiere a la licencia asignada a cada Usuario para instalar, operar, acceder y usar los Productos en nombre del Cliente. El Cliente puede asignar solamente una Licencia de suscripción por Usuario en sus instancias del servidor de GitHub Enterprise y Organizaciones de GitHub Enterprise Cloud. Cada Usuario tendrá acceso a tantas instancias del servidor de Enterprise del Cliente o a Organizaciones de Enterprise Cloud como el Cliente lo permita. Para mayor claridad, sin embargo, una vez que el Cliente asigna una Licencia de suscripción a un Usuario, el Cliente no estará autorizado a bifurcar la Licencia de suscripción de modo que un Usuario podrá usar una Licencia de suscripción en el servidor de Enterprise mientras otro Usuario usa la misma Licencia de suscripción en otra instancia del servidor de GitHub Enterprise o en una Organización de GitHub Enterprise Cloud. Las Licencias de suscripción se otorgan por Usuario y la misma Licencia de suscripción no puede ser utilizada por múltiples Usuarios. El Cliente puede reasignar una Licencia de suscripción a un nuevo Usuario solo después de noventa (90) días desde la última reasignación de esa misma Licencia de suscripción, excepto que la reasignación se deba a (i) la pérdida o la falla permanente del hardware, (ii) la terminación del empleo o el contrato del Usuario, o (iii) la readjudicación temporal de las Licencias de Suscripción para cubrir una ausencia del Usuario. Cuando el Cliente reasigna una Licencia de suscripción de un Usuario a otro, el Cliente debe bloquear el acceso del Usuario anterior a la Licencia de suscripción y a las Organizaciones del Cliente.

**“Plazo de la suscripción”** se refiere a un (1) año a partir de la fecha de entrada en vigor correspondiente de un pedido o como se indique en el Formulario de pedidos.

**“Soporte”** se refiere al soporte técnico para el Software o el Servicio que GitHub puede proporcionar.

**“Actualizar”** se refiere a un lanzamiento de Software que GitHub, generalmente, pone a disposición de sus clientes, junto con cualquier cambio correspondiente en la Documentación, que contiene correcciones o solución de errores, que se suele indicar con un cambio en el dígito a la derecha del segundo punto decimal (por ejemplo, x.x.x a x.x.y).

**“Tiempo de actividad”** se refiere al porcentaje de tiempo en un trimestre dado en que los Servicios esenciales de GitHub no se detendrán por una Interrupción que afecte a más del 50⁰% de los Usuarios activos

**"Usuario"** significa (i) con respecto al Software, una sola persona o Cuenta de Máquina que inicia la ejecución de dicho Software o interactúa o dirige a éste al desempeño de sus funciones; y (ii) con respecto al Servicio, un individuo o Cuenta de Máquina que (a) accede o utiliza el Servicio, (b) accede a, o utiliza, cualquier parte de la cuenta del Cliente, o (c) dirige el uso de la cuenta del Cliente en la ejecución de sus funciones, en cada caso, en representación del Cliente. La cantidad de Usuarios no debe exceder el número de Licencias de suscripción que el Cliente compró.

**“Contenido generado por el Usuario”** se refiere al Contenido que un tercero o un Usuario externo crea o posee.
