---
title: Subprocesadores y cookies de GitHub
redirect_from:
  - /subprocessors/
  - /github-subprocessors/
  - /github-tracking/
  - /github-cookies/
  - /articles/github-subprocessors-and-cookies
versions:
  free-pro-team: '*'
---

Fecha de entrada en vigencia: **12 de agosto de 2020**

GitHub ofrece una gran cantidad de transparencia en cuanto a cómo usamos tus datos, cómo recopilamos tus datos y con quién los compartimos. Con ese fin proporcionamos esta página, la cual detalla [nuestros subprocesadores](#github-subprocessors), cómo usamos las [cookies](#cookies-on-github) y dónde y cómo realizamos cualquier [rastreo en GitHub](#tracking-on-github).

### Subprocesadores de GitHub

Cuando compartimos tu información con subprocesadores de terceros, como nuestros vendedores y proveedores de servicios, seguimos siendo responsables de ella. Trabajamos arduamente para mantener tu confianza cuando traemos nuevos proveedores y exigimos que todos los proveedores celebren acuerdos de protección de datos con nosotros que restrinjan su procesamiento de la información personal de los usuarios (tal como se define en la [Declaración de Privacidad](/articles/github-privacy-statement/)).

| Nombre del subprocesador | Descripción del procesamiento                               | Ubicación del procesamiento | Ubicación Corporativa |
| ------------------------ | ----------------------------------------------------------- | --------------------------- | --------------------- |
| Automattic               | Servicio de alojamiento                                     | Estados Unidos              | Estados Unidos        |
| AWS Amazon               | Alojamiento de datos                                        | Estados Unidos              | Estados Unidos        |
| Braintree (PayPal)       | Procesador de pagos de suscripción con tarjeta de crédito   | Estados Unidos              | Estados Unidos        |
| Clearbit                 | Servicio de enriquecimiento de datos de marketing           | Estados Unidos              | Estados Unidos        |
| Discourse                | Proveedor de software del foro de la comunidad              | Estados Unidos              | Estados Unidos        |
| DiscoverOrg              | Servicio de enriquecimiento de datos de marketing           | Estados Unidos              | Estados Unidos        |
| Eloqua                   | Automatización de campañas de marketing                     | Estados Unidos              | Estados Unidos        |
| Google Apps              | Infraestructura interna de la empresa                       | Estados Unidos              | Estados Unidos        |
| Google Analytics         | Análisis y rendimiento del sitio web                        | Estados Unidos              | Estados Unidos        |
| LinkedIn Navigator       | Servicio de enriquecimiento de datos de marketing           | Estados Unidos              | Estados Unidos        |
| Magic Robot              | Informes de campaña (Adición del equipo de ventas)          | Estados Unidos              | Estados Unidos        |
| MailChimp                | Proveedor de servicios de correo de billetaje de clientes   | Estados Unidos              | Estados Unidos        |
| Mailgun                  | Proveedor de servicios de correo transaccional              | Estados Unidos              | Estados Unidos        |
| Microsoft                | Servicios de Microsoft                                      | Estados Unidos              | Estados Unidos        |
| Monday.com               | Plataforma de colaboración en equipo y gestión de proyectos | Estados Unidos              | Israel                |
| Nexmo                    | Proveedor de notificaciones SMS                             | Estados Unidos              | Estados Unidos        |
| Oracle                   | Sistema financiero corporativo                              | Estados Unidos              | Estados Unidos        |
| Salesforce.com           | Gestión de relaciones con clientes                          | Estados Unidos              | Estados Unidos        |
| Sendgrid                 | Proveedor de servicios de correo transaccional              | Estados Unidos              | Estados Unidos        |
| Sentry.io                | Proveedor de monitoreo de aplicaciones                      | Estados Unidos              | Estados Unidos        |
| Stripe                   | Proveedor de pagos                                          | Estados Unidos              | Estados Unidos        |
| Twilio                   | Proveedor de notificaciones SMS                             | Estados Unidos              | Estados Unidos        |
| Zendesk                  | Sistema de tickets de soporte al cliente                    | Estados Unidos              | Estados Unidos        |
| Zuora                    | Sistema de facturación corporativa                          | Estados Unidos              | Estados Unidos        |

Cuando traemos un nuevo subprocesador que maneja la información personal de nuestros usuarios o eliminas un subprocesador, o cambiamos la manera en que usamos un subprocesador, actualizaremos esta página. Si tienes preguntas o inquietudes acerca de un nuevo subprocesador, estaremos encantados de ayudarte. Ponte en contacto con nosotros vía{% data variables.contact.contact_privacy %}.

### Cookies en GitHub

GitHub utiliza cookies para hacer que las interacciones con nuestro servicio sean fáciles y significativas. Utilizamos cookies (y tecnologías similares, como HTML5 localStorage) para mantenerte conectado, recordar tus preferencias, proporcionar información para el futuro desarrollo de GitHub y para publicitar los productos y servicios de GitHub en sitios de terceros.

Una cookie es un pequeño fragmento de texto que nuestro servidor Web almacena en tu computadora o dispositivo móvil, que tu navegador nos envía cuando regresas a nuestro sitio. Las cookies no necesariamente te identifican si simplemente estás visitando GitHub; sin embargo, una cookie puede almacenar un identificador único para cada usuario que inició sesión. Usamos cookies para mantenerte registrado, recordar tus preferencias y proporcionar información para el desarrollo futuro de GitHub. Por razones de seguridad, usamos cookies para identificar un dispositivo. Al usar nuestro sitio web, aceptas que podamos colocar este tipo de cookies en tu computadora o dispositivo. Si desactivas tu navegador o la capacidad de tu dispositivo para aceptar estas cookies, no podrás iniciar sesión ni utilizar los servicios de GitHub. En ciertas áreas del sitio web, también podríamos usar cookies para identificarte a ti y/o a tu dispositivo a fin de publicitar productos y servicios de GitHub en sitios de terceros.

GitHub configura las siguientes cookies en nuestros usuarios por las siguientes razones:

| Nombre de la cookie                  | Razón                                                                                                                                                                  |
| ------------------------------------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `user_session`                       | Esta cookie se utiliza para que inicies sesión.                                                                                                                        |
| `logged_in`                          | Esta cookie se utiliza para indicarnos que el usuario ya está registrado.                                                                                              |
| `dotcom_user`                        | Esta cookie se utiliza para indicarnos que el usuario ya está registrado.                                                                                              |
| `_gh_sess`                           | Esta cookie se usa para la aplicación temporal y el estado del marco entre las páginas copara indicar en qué paso está el usuario en un formulario de múltiples pasos. |
| `tz`                                 | Esta cookie permite a tu navegador decirnos en qué zona horaria te encuentras.                                                                                         |
| `gist_user_session`                  | Esta cookie es usada por Gist cuando se ejecuta en un host por separado.                                                                                               |
| `saml_csrf_token`                    | Esta cookie se establece mediante el método de ruta de autenticación de SAML para asociar un token con el cliente.                                                     |
| `saml_return_to`                     | Esta cookie se establece mediante el método de ruta de autenticación de SAML para mantener el estado durante el bucle de autenticación SAML.                           |
| `gist_oauth_csrf`                    | Esta cookie se establece por Gist para asegurar que el usuario que inició el flujo OAuth sea el mismo usuario que lo completa.                                         |
| `__Host-user_session_same_site`      | Esta cookie se configura para asegurar que los navegadores que soportan las cookies de SameSite pueden verificar si una solicitud se origina desde GitHub.             |
| `__Host-gist_user_session_same_site` | Esta cookie se configura para asegurar que los navegadores que soportan las cookies de SameSite pueden verificar si una solicitud se origina desde GitHub.             |
| `_ga`                                | Esta cookie es utilizada por Google Analytics.                                                                                                                         |
| `_gat`                               | Esta cookie es utilizada por Google Analytics.                                                                                                                         |
| `_gid`                               | Esta cookie es utilizada por Google Analytics.                                                                                                                         |
| `_octo`                              | Esta cookie es utilizada por Octolytics, nuestro servicio analítico interno, para distinguir usuarios y clientes únicos.                                               |
| `tracker`                            | Esta cookie rastrea la fuente de referencia para el análisis de registro.                                                                                              |

Algunas páginas de nuestro sitio pueden establecer otras cookies de terceros. Por ejemplo, es posible que insertamos contenido, como vídeos, desde otro sitio que establezca una cookie. Si bien tratamos de minimizar estas cookies de terceros, no siempre podemos controlar qué cookies establece este contenido de terceros.

### Rastreo en GitHub

"[No realizar un seguimiento](https://www.eff.org/issues/do-not-track)"(DNT) es una preferencia de privacidad que puedes configurar en tu navegador si no deseas que los servicios en línea, en concreto las redes publicitarias, recopilen y compartan determinados tipos de información sobre tu actividad en línea a partir de servicios de seguimiento de terceros. GitHub responde a las señales DNT del navegador y sigue el estándar [W3C para responder a las señales DNT](https://www.w3.org/TR/tracking-dnt/). Si deseas configurar tu navegador para que indique que no deseas que se rastree, revisa la documentación de tu navegador acerca de cómo habilitar esa señal. También hay buenas aplicaciones que bloquean el seguimiento en línea, como [Privacy Badger](https://www.eff.org/privacybadger).

Si no has habilitado DNT en un navegador que lo admita, las cookies en algunas partes de nuestro sitio web rastrearán tu actividad de navegación en línea en otros servicios en línea a lo largo del tiempo, aunque no permitimos que terceros que no sean nuestros proveedores de análisis y servicios rastreen la actividad de los usuarios de GitHub con el paso del tiempo en GitHub. Utilizamos estas cookies para permitirnos publicitar productos y servicios de GitHub en sitios web y servicios de terceros. También tenemos acuerdos con ciertos proveedores, como proveedores de análisis, que nos ayudan a rastrear los movimientos de los visitantes en ciertas páginas en nuestro sitio. Solo nuestros proveedores, que están recopilando información personal en nuestro nombre, pueden recopilar datos en nuestras páginas y hemos firmado acuerdos de protección de datos con cada proveedor que recopila estos datos en nuestro nombre. Utilizamos los datos que recibimos de estos proveedores para comprender mejor los intereses de nuestros visitantes, para comprender el rendimiento de nuestro sitio web y para mejorar nuestro contenido. Cualquier vendedor de análisis se incluirá en nuestra lista de Subprocesadores antes mencionada y es posible que veas una lista de cada página en la que recopilemos este tipo de datos que enunciamos a continuación.

#### Google Analytics

Utilizamos Google Analytics como un servicio analítico de terceros y para hacer un seguimiento de nuestras campañas publicitarias en sitios web y servicios de terceros. Utilizamos Google Analytics para recopilar información sobre cómo funciona nuestro sitio web y cómo nuestros usuarios, en general, navegan y usan GitHub. Esto nos ayuda a evaluar el uso de GitHub por parte de nuestros usuarios; compilar informes estadísticos sobre la actividad; y mejorar nuestro contenido y el rendimiento del sitio Web. Google brinda más información acerca de sus propias prácticas de privacidad y [ofrece un complemento del navegador para dejar de participar en el seguimiento de Google Analytics](https://tools.google.com/dlpage/gaoptout).

#### Páginas en GitHub en las que se puede habilitar analytics

Las páginas en las URL que contienen cualquiera de los siguientes dominios y rutas (incluidos los subdominios o subtrazados) en nuestros sitios pueden tener Analytics u otro código de seguimiento habilitado. Si deseas evitar que recopilemos información sobre tu actividad de navegación en GitHub, puedes usar un bloqueador de rastreo como [Privacy Badger](https://www.eff.org/privacybadger) u optar por el seguimiento de Google Analytics.

- github.com/home (si has cerrado sesión o no tienes una cuenta, esta es la página que verás cuando vayas a github.com)
- github.com/about
- github.blog
- github.com/enterprise
- github.com/collections
- github.com/developer-stories
- github.com/events
- github.com/explore
- github.com/features
- github.com/logos
- github.com/nonprofit
- github.com/open-source
- github.com/personal
- github.com/pricing
- github.com/ten
- github.com/trending
- resources.github.com
- de.github.com
- fr.github.com
