---
title: Acuerdo de GitHub contra la esclavitud moderna y el trabajo infantil
redirect_from:
  - /articles/github-statement-against-modern-slavery-and-child-labor
versions:
  free-pro-team: '*'
---

*Declaración 2018*

Según la organización internacional del trabajo (OIT), [40 millones de personas fueron víctimas de la esclavitud moderna y 152 millones niños fueron sometidos a trabajo infantil](https://www.ilo.org/global/about-the-ilo/newsroom/news/WCMS_574717/lang--en/index.htm) globalmente en 2016. Como lo informa la OIT[](https://www.ilo.org/global/topics/forced-labour/lang--en/index.htm):
   - 1 de cada 4 víctimas de esclavitud moderna son niños.
   - De los 24.9 millones de personas atrapadas en el trabajo forzoso, se explotan 16 millones personas en el sector privado, como el trabajo doméstico, la construcción o la agricultura; 4.8 millones de personas en la explotación sexual forzada y 4 millones de personas en el trabajo forzoso impuestas por las autoridades del estado.
   -    Las mujeres y las niñas se ven afectadas de manera desproporcionada por el trabajo forzoso, que representa el 99% de las víctimas en la industria sexual comercial y el 58% en otros sectores.

GitHub deplora la presencia y la persistencia de la esclavitud moderna y el trabajo infantil y toma en serio su responsabilidad de asegurar que ni la esclavitud moderna ni el trabajo infantil se lleven a cabo en su cadena de suministro o en cualquier parte de su negocio. ("Esclavitud moderna" en esta declaración se refiere a la esclavitud, el trabajo forzoso u obligatorio, el tráfico, la servidumbre y los trabajadores que están encarcelados, identificados o Unidos. "Trabajo infantil" se refiere al trabajo realizado por alguien menor de 16 años de edad o menor de 14 años para trabajo liviano, considerando que no se limite a los periodos que interfieaen con la educación del niño y no en condiciones que interfieran con la salud o el bienestar del niño.)

De acuerdo con la [Ley de Esclavitud Moderna del Reino Unido](https://www.legislation.gov.uk/ukpga/2015/30/section/54/enacted), y en cumplimiento con el [ILO 2014 Protocolo para la Convención de Trabajo Forzado](https://www.ilo.org/dyn/normlex/en/f?p=NORMLEXPUB:12100:0::NO::P12100_ILO_CODE:P029)", la [ILO Declaración de Principios Fundamentales y Derechos en el Trabajo](https://www.ilo.org/declaration/thedeclaration/textdeclaration/lang--en/index.htm), y la [meta 8.7 de las Metas de Desarrollo Sostenible de las Naciones Unidas](https://sustainabledevelopment.un.org/sdg8), esta Declaración de 2018 Contra la Esclavitud Moderna y el Trabajo Infantil ("la Declaración") describe los pasos que ha tomado GitHub para prevenir que se suscite la esclavitud moderna y el trabajo infantil en su negocio o cadena de suministro.

### La estructura, empresas y las cadenas de suministro de GitHub

GitHub es una plataforma de desarrollo de software con su sede en San Francisco y empleados y contratistas que trabajan en numerosos países.

Todos los empleados de GitHub y los contratistas independientes individuales son voluntarios y están a la misma disposición. GitHub tiene una mano de obra distribuida en gran medida y se esfuerza por brindar compensaciones y beneficios competitivos a sus empleados y contratistas, independientemente de su ubicación. Esto es cierto ya sea que contratemos contratistas independientes directamente o a través de un intermediario.

GitHub no conduce la manufactura o produce hardware, ni GitHub utiliza agencias de reclutamiento para los tipos de servicios a menudo realizados por los trabajadores migrantes. La naturaleza del negocio de GitHub no la somete a cambios repentinos en las presiones de carga de trabajo o de precios, que a menudo impulsan la demanda de prácticas que aumentan el riesgo de trabajo forzoso en las cadenas de suministro, como las horas extras forzadas.

GitHub ofrece software gratuito y de pago y software basado en la web como un servicio para los clientes en todo el mundo. Los productos de GitHub incluyen:
   - GitHub.com: Colaboración basada en la web y plataforma de hospedaje de código
   - GitHub Enterprise: Colaboración local y software de alojamiento de código
   - Atom: Editor de texto
   - Electron: Marco para escribir aplicaciones multiplataforma de escritorio
   - Escritorio de GitHub: Aplicación de escritorio para acceder a GitHub.com y GitHub Enterprise

La cadena de suministro de GitHub está formada por bienes y servicios para nuestros productos y operaciones que incluyen servicios de computación, planificación de eventos, compra de artículos comerciales y promocionales, suministros de oficina y arrendamiento de instalaciones, como espacios de oficinas y centros de datos.

### Políticas en relación con la esclavitud moderna y el trabajo infantil

#### Esclavitud moderna y trabajo infantil

**El código de ética de GitHub** prohíbe usar, participar, apoyar o tolerar de manera consciente la esclavitud moderna (esclavitud, trabajo forzoso u obligatorio, tráfico, servidumbre o trabajadores que están encarcelados, matriculados o adheridos) o trabajo infantil en sus operaciones comerciales. Cualquier empleado o contratista de GitHub que viole esta prohibición estará sujeto a la terminación de la relación laboral o comercial.

**Los estándares de conducta de GitHub** prohíben conductas inseguras e ilegales, que incluyen el uso a sabiendas, la participación, el apoyo o la tolerancia de la esclavitud moderna (esclavitud, trabajo forzoso u obligatorio, tráfico, servidumbre o trabajadores que están encarcelados, identificados o vinculados) o trabajo infantil.

GitHub cumple con las leyes que prohíben la trata y el trabajo infantil en las jurisdicciones en las que opera, incluyendo la [Regulación de adquisición federal de EE. UU. 22.17 sobre la lucha contra la trata de personas](https://www.govinfo.gov/content/pkg/CFR-2009-title48-vol1/pdf/CFR-2009-title48-vol1-part22-subpart22-17.pdf).

Además, GitHub estableció una asociación con el programa FairHotel, lo que significa que GitHub alienta a sus empleados a elegir Hoteles aprobados por FairHotel, donde los trabajadores tienen salarios justos, beneficios adecuados y una voz en el trabajo. Ser un socio de FairHotel también significa que GitHub brinda negocios a los hoteles como un empleador justo.

En el futuro, GitHub comunicará esta declaración a todos los empleados, contratistas y proveedores, incluyendo reclutadores y agencias de empleo. Además, GitHub está desarrollando capacitación para todos los empleados de GitHub sobre esclavitud moderna y trabajo infantil. Github [publica su declaración frente a la esclavitud moderna y el trabajo infantil públicamente.](/articles/github-statement-against-modern-slavery-and-child-labor)

GitHub tiene una política de no represalias para informar las inquietudes relacionadas con el lugar de trabajo. De acuerdo con esta afirmación, GitHub les permite a los empleados y contratistas informar las propuestas relacionadas con la esclavitud moderna y el trabajo infantil sin temor a represalias.

### Legislaciones y prácticas laborales

Las prácticas laborales de GitHub son

**justas**:
   - GitHub paga a sus empleados y contratistas un salario justo, de acuerdo con los salarios legales aplicables
   - GitHub mantiene condiciones de trabajo humanas
   - GitHub no requiere que los trabajadores excedan las horas máximas de trabajo diario establecidas por las leyes o regulaciones locales y nacionales
   - GitHub paga a sus empleados y contratistas de manera oportuna, con documentación (como un talón de pago) que indica la base sobre la que se les paga y mantiene los registros de los empleados de acuerdo con las leyes locales y nacionales

**humanas y éticas**:
   - GitHub usa solo mano de obra voluntaria
   - GitHub prohíbe el trabajo infantil
   - GitHub no participa en disciplina física o abuso
   - GitHub no tolera acoso o discriminación ilegal en la fuerza laboral o en el lugar de trabajo

**respetuosas**:
   - GitHub protege los derechos de sus empleados a la libertad de asociación y la negociación colectiva de acuerdo con los requisitos legales, incluyendo el de publicar avisos legales de los derechos de los empleados conforme a la ley nacional de relaciones laborales
   - GitHub brinda beneficios a los empleados en exceso o por encima de los niveles esperados en la industria
   - GitHub invita a los empleados a informar cualquier queja en el lugar de trabajo y no tolera represalias por informar

### Procesos de diligencia debida en relación con la esclavitud moderna y el trabajo infantil en sus cadenas comerciales y de suministro

GitHub evalúa su cadena de negocio y de suministro para los riesgos relacionados con la esclavitud moderna y el trabajo infantil. Aprovechando la experiencia interna y externa en materia de derechos humanos, GitHub participó en un análisis de funcionalidad cruzada (que incluye políticas, asesoría legal, adquisiciones, finanzas y operaciones, especialmente recursos humanos) para determinar dónde existen los servicios laborales en su cadena de negocios y de suministro y para identificar los riesgos potenciales relacionados con la esclavitud moderna y el trabajo infantil. GitHub prioriza las áreas en las que esos riesgos pueden ser más significativos en términos de gravedad, escala o probabilidad para una mayor diligencia debida, monitoreo y verificación. GitHub continúa considerando dónde pueden ocurrir riesgos y cómo abordarlos. Además, GitHub ahora obtiene la certeza de sus proveedores de que tienen prácticas consistentes con esta declaración, incluso al cumplir con las leyes relacionadas con la esclavitud moderna o el trabajo infantil.

### Lugares en las cadenas de negocios y suministros de GitHub donde hay un riesgo de esclavitud moderna y trabajo infantil y los pasos que GitHub ha tomado para evaluar y administrar dicho riesgo

GitHub no identificó a ningún proveedor de alto riesgo; sin embargo, la esclavitud moderna o el trabajo infantil sería más probable que ocurra con los proveedores de servicios que implican mano de obra manual, como el apoyo a eventos, construcción, servicios de instalaciones y servicios de alimentos. GitHub auditará a sus proveedores existentes y requerirá que aquellos en esas áreas de mayor riesgo confirmen que brindan servicios consistentes con esta declaración.

A pesar de que GitHub no sabe de ninguna esclavitud moderna o alegada moderna o trabajo infantil en su cadena de negocios o de suministro y no tiene una base creíble para creer que está ocurriendo, GitHub se compromete a proveer remedios si GitHub en sí misma causara la esclavitud moderna o el trabajo infantil y la remediación de patrones más amplios de no conformidad con esta declaración causada por deficiencias en los sistemas o procesos. La remediación de GitHub a las víctimas individuales incluiría protocolos de acción inmediata adecuada para eliminar las prácticas modernas de esclavitud y trabajo infantil, junto con recursos para servicios razonables y apropiados de víctimas diseñados para compensar el daño experimentado.

### Efectividad para asegurar que no se esté produciendo la esclavitud moderna ni el trabajo infantil en las cadenas comerciales o de suministro de GitHub

GitHub cumple y seguirá cumpliendo con las leyes relacionadas con la esclavitud moderna y el trabajo infantil.

En el futuro, GitHub ahora requiere que sus proveedores cumplan con esta declaración, así como con las leyes relacionadas con la esclavitud moderna y el trabajo infantil. GitHub ahora también requiere que sus proveedores:
   - no usen, participen, apoyen o toleren la esclavitud moderna o el trabajo infantil
   - no utilicen prácticas engañosas o fraudulentas de reclutamiento o compromiso para empleados o trabajadores contratados
   - no cobren a los empleados o a los trabajadores contratados cuotas de compromiso
   - no destryan, oculten, confisquen o nieguen el acceso de un empleado o de cualquier trabajador contratante al pasaporte, la licencia de conducir u otros documentos de identidad;
   - nos permitan terminar nuestros acuerdos con ellos por cualquier violación de sus obligaciones relacionadas con la esclavitud moderna o el trabajo infantil; y
   - remedien cualquier daño causado a cualquier trabajador que se encuentre sometido a cualquier forma de esclavitud moderna o trabajo infantil, si así lo solicita la ley.

Además, GitHub recomienda firmemente a sus proveedores que:
   - lleven a cabo procesos antimodernos de esclavitud y diligencia debida del trabajo infantil, incluyendo evaluaciones de riesgo, para sus proveedores;
   - tomen medidas para abordar riesgos identificados; y
   - utilicen una esclavitud antimoderna similar y un lenguaje de trabajo infantil con sus proveedores.

Las instrucciones de contratación de GitHub a los empleados que realizan compras de la empresa ahora incluyen una referencia al requisito de que los proveedores cumplan con el código de conducta del proveedor de Microsoft o esta declaración.

### Capacitación para el personal de GitHub sobre la esclavitud moderna y la trata de personas

GitHub está desarrollando la esclavitud moderna y la capacitación de trabajo infantil que será obligatoria para todos los empleados, con vistas a los negocios y la cadena de suministro de GitHub. GitHub hará hincapié en los proveedores que prestan servicios relacionados con el trabajo manual, como el apoyo a eventos, la construcción, los servicios de instalaciones y los servicios de alimentos, como áreas de mayor riesgo potencial.

**El Consejo de administración de GitHub aprobó [esta declaración](/assets/images/help/site-policy/github-statement-against-modern-slavery-and-child-labor.pdf).**
