---
title: Declaración de Privacidad de GitHub
redirect_from:
  - /privacidad/
  - /privacy-policy/
  - /privacy-statement/
  - /github-privacy-policy/
  - /articles/github-privacy-policy/
  - /articles/github-privacy-statement/
versions:
  free-pro-team: '*'
---

Fecha de entrada en vigor: 22 de julio del 2020

Gracias por confiar a GitHub Inc. (“GitHub”, “nosotros”) tu código fuente, tus proyectos y tu información personal. Conservar tu información privada es una responsabilidad importante, y queremos que sepas cómo lo hacemos.

Todos los términos en mayúsculas tienen su definición en las [Condiciones de Servicio de GitHub](/github/site-policy/github-terms-of-service) a menos de que se indique lo contrario.


### La versión corta

Utilizamos tu información personal como lo describe la presente Declaración de Privacidad. Sin importar quién seas, dónde vives, o cuál sea tu nacionalidad, proporcionames el mismo estándar alto de protección de la privacidad a todos nuestros usuarios en el mundo, sin importar su país de orígen o su ubicación.

Por supuesto, la versión corta y el Resumen que aparecen a continuación no informan todos los detalles, por lo tanto, sigue leyendo para acceder a ellos.

### Resumen

| Sección                                                                                                                      | ¿Qué puedes encontrar allí?                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| ---------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [Qué información recopila GitHub](#what-information-github-collects)                                                         | GitHub recopila información directamente a partir de tu registro, tus pagos, tus transacciones y del perfil del usuario. Asimismo, cuando resulta necesario, recopilamos datos automáticamente a partir de tu información de uso, cookies y tecnologías similares, y de la información del dispositivo, sujeto a tu consentimiento. Puede que GitHub también recopile Información personal del usuario a partir de terceros. Solo recopilamos la mínima cantidad de información personal necesaria a través de ti, a menos que decidas proporcionar más. |
| [Qué información GitHub _no_ recopila](#what-information-github-does-not-collect)                                            | No recopilamos intencionalmente información de niños menores de 13 años y no recopilamos [Información personal sensible](https://gdpr-info.eu/art-9-gdpr/).                                                                                                                                                                                                                                                                                                                                                                                              |
| [Cómo utiliza GitHub tu información](#how-github-uses-your-information)                                                      | En esta sección, describimos las formas en las que utilizamos tu información, incluyendo el proporcionarte el Servicio, comunicarnos contigo, para propósitos de seguridad y cumplimiento, y para mejorar nuestro Servicio. También describimos la base legal sobre la cual procesamos tu información personal, cuando se exige legalmente.                                                                                                                                                                                                              |
| [Cómo compartimos la información que recopilamos](#how-we-share-the-information-we-collect)                                  | Puede que compartamos tu información con terceros en una de las siguientes circunstancias: con tu consentimiento, con nuestros proveedores de servicio, por motivos de seguridad, para cumplir con nuestras obligaciones legales o cuando exista un cambio de control o venta de las entidades corporativas o unidades de negocios. En GitHub, no vendemos tu información personal y no alojamos publicidad. Puedes consultar una lista de los proveedores de servicio que acceden a tu información.                                                     |
| [Otra información importante](#other-important-information)                                                                  | Proporcionamos más información específica sobre los contenidos del repositorio, la información pública y las Organizaciones de GitHub.                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [Servicios adicionales](#additional-services)                                                                                | Proporcionamos información sobre las ofertas de servicio adicionales, incluso aplicaciones de terceros, Páginas de GitHub y aplicaciones de GitHub.                                                                                                                                                                                                                                                                                                                                                                                                      |
| [Cómo puedes acceder y controlar la información que recopilamos](#how-you-can-access-and-control-the-information-we-collect) | Proporcionamos formas para que accedas, modifiques o elimines tu información personal.                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| [Uso de cookies y seguimiento](#our-use-of-cookies-and-tracking)                                                             | Utilizamos cookies para la funcionalidad general de nuestro Sitio web y una pequeña cantidad de servicios de análisis y de seguimiento en pocas partes de nuestro sitio. Ofrecemos una página que hace que esto sea muy transparente. Consulta esta sección para obtener más información.                                                                                                                                                                                                                                                                |
| [Cómo asegura GitHub tu información](#how-github-secures-your-information)                                                   | Tomamos todas las medidas razonablemente necesarias para proteger la confidencialidad, integridad y disponibilidad de tu información personal en GitHub y para proteger la resistencia de nuestros servidores.                                                                                                                                                                                                                                                                                                                                           |
| [Prácticas de privacidad mundiales de GitHub](#githubs-global-privacy-practices)                                             | Proporcionamos el mismo estándar alto de protección de la privacidad a todos nuestros usuarios en el mundo entero.                                                                                                                                                                                                                                                                                                                                                                                                                                       |
| [Cómo nos comunicamos contigo](#how-we-communicate-with-you)                                                                 | Nos comunicamos contigo por correo electrónico. Puedes controlar la manera en que te contactamos en las configuraciones de la cuenta o poniéndote en contacto con nosotros.                                                                                                                                                                                                                                                                                                                                                                              |
| [Resolver reclamos](#resolving-complaints)                                                                                   | En el caso improbable de que no podamos resolver una inquietud sobre la privacidad de forma rápida y exhaustiva, proporcionaremos un medio de resolución por medio de una disputa.                                                                                                                                                                                                                                                                                                                                                                       |
| [Cambios en tu Declaración de privacidad](#changes-to-our-privacy-statement)                                                 | Te notificamos los cambios importantes en esta Declaración de privacidad 30 días antes de que cualquier cambio entre en vigencia. Puedes rastrear los cambios en nuestro repositorio de Políticas del sitio.                                                                                                                                                                                                                                                                                                                                             |
| [Licencia](#license)                                                                                                         | La presente Declaración de privacidad está autorizada por la [licencia Creative Commons Zero](https://creativecommons.org/publicdomain/zero/1.0/).                                                                                                                                                                                                                                                                                                                                                                                                       |
| [Contactarse con GitHub](#contacting-github)                                                                                 | Siéntete libre de contactarnos si tienes preguntas acerca de nuestra Declaración de privacidad.                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [Traducciones](#translations)                                                                                                | Proporcionamos enlaces a algunas traducciones de la Declaración de privacidad.                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |

## Declaración de Privacidad de GitHub

### Qué información recopila GitHub

La "**Información personal del usuario**" es cualquier información acerca de alguno de nuestros Usuarios que podría, de manera independiente o junto con otra información, identificarlo individualmente, o que está vinculada o conectada de cualquier otra forma con él. Información como un nombre de usuario y contraseña, una dirección de correo electrónico, un nombre real, una dirección de Protocolo de Internet (IP) y una fotografía son ejemplos de "Información personal del usuario".

La Información personal del usuario no incluye información agregada, información de carácter no personal que no identifica a un Usuario o que no se puede vincular o conectar de manera razonable con él. Podemos utilizar dicha información agregada que no identifica de manera personal a un usuario con motivos de investigación y para operar, analizar y optimizar nuestro Sitio web y el Servicio.

#### Información que los usuarios proporcionan directamente a GitHub

##### Información de registro
Necesitamos cierta información básica al momento de creación de la cuenta. Cuando creas tu propio nombre de usuario y contraseña, te solicitamos una dirección de correo electrónico válida.

##### Información de Pago
Si te registras para una Cuenta paga, envías fondos a través del Programa de patrocinadores de GitHub o compras una aplicación en el Mercado GitHub, recopilamos tu nombre completo y la información de la tarjeta de crédito o la información de PayPal. Ten en cuenta que GitHub no procesa ni almacena tu información de tarjeta de crédito o información de PayPal, pero sí lo hace nuestro procesador de pago subcontratado.

Si detallas y vendes una aplicación en el [Mercado GitHub](https://github.com/marketplace), te solicitamos la información de tu banco. Si recabas fondos a través del [Programa de Patrocinadores de GitHub](https://github.com/sponsors), necesitamos algo de [información adicional](/github/supporting-the-open-source-community-with-github-sponsors/becoming-a-sponsored-developer#submitting-your-bank-information) mediante el proceso de registro para que participes y recibas los fondos a través de estos servicios y para propósitos de cumplimiento.

##### Información de perfil
Puedes decidir proporcionarnos más información para tu Perfil de cuenta, como tu nombre completo, un avatar que puede incluir una fotografía, tu biografía, tu ubicación, tu empresa y una URL a un sitio web de terceros. Esta información puede incluir Información personal del usuario. Ten en cuenta que tu información de perfil puede ser visible para otros Usuarios de nuestro Servicio.

#### Información que GitHub recopila automáticamente a partir del uso del Servicio

##### Información transaccional
Si tienes una Cuenta paga con nosotros, vendes una aplicación detallada en el [Mercado GitHub](https://github.com/marketplace) o recaudas fondos a través del [Programa de patrocinadores de GitHub](https://github.com/sponsors), automáticamente recopilamos determinada información acerca de tus transacciones en el Servicio, como la fecha, la hora y el monto cobrado.

##### Información de uso
Si accedes a nuestro Servicio o Sitio web, automáticamente recopilamos la misma información básica que recopila la mayoría de los servicios, sujeto a tu consentimiento cuando resulte necesario. Esto incluye información acerca de cómo utilizas el Servicio, por ejemplo, las páginas que miras, el sitio referido, tu dirección IP e información de sesión, y la fecha y hora de cada solicitud. Recopilamos esta información de todos los visitantes del Sitio web, tengan o no una Cuenta. Esta información puede incluir Información personal del usuario.

##### Cookies e información de tecnologías similares
Como se describe con más detalle a continuación, y sujeto a tu consentimiento, cuando resulta necesario, recopilamos automáticamente información de cookies y tecnologías similares (como ID y configuraciones de la cookie) a fin de mantenerte registrado, recordarte tus preferencias e identificarte a ti y a tu dispositivo.

##### Información de dispositivo
Puede que recopilemos determinada información acerca de tu dispositivo, como la dirección IP, el navegador o información de la aplicación del cliente, preferencias de idioma, sistema operativo y versión de la aplicación, tipo e ID del dispositivo y modelo y fabricante del dispositivo. Esta información puede incluir Información personal del usuario.

#### Información que recopilamos de terceros

GitHub puede recopilar Información personal del usuario a partir de terceros. Por ejemplo, esto puede ocurrir si inicias sesión para capacitarte o recibir información acerca de GitHub de parte de alguno de nuestros proveedores, socios o subsidiarias. GitHub no compra Información personal del usuario a agentes de datos de terceros.

### Qué información no recopila GitHub

No recopilamos de manera intencional “**[Información personal sensible](https://gdpr-info.eu/art-9-gdpr/)**”, como datos personales que revelan origen racial o étnico, opiniones políticas, creencias religiosas o filosóficas o afiliación sindical, y tampoco procesamos datos genéticos ni datos biométricos con el único fin de identificar a una persona física, datos del estado de salud o datos sobre la vida sexual o la orientación sexual de una persona física. Si decides almacenar alguna Información personal en tus servidores, eres responsable de cumplir con cualquier control regulatorio al respecto de esos datos.

Si eres un niño menor de 13 años, no puedes tener una Cuenta en GitHub. GitHub no recopila intencionalmente información de niños menores de 13 años ni dirige ninguno de nuestros contenidos de manera específica a ellos. Si sabemos o tenemos motivos para sospechar que eres un Usuario menor de 13 años, tendremos que cerrar tu Cuenta. No queremos desalentarte de que aprendas nuestro código, pero esas son las reglas. Por favor, consulta nuestras [Condiciones de Servicio](/github/site-policy/github-terms-of-service) para la información acerca de la cancelación de la cuenta. Puede que los diferentes países tengan diferentes límites de edad mínimos. Si estás por debajo de la edad mínima para brindar consentimiento para la recopilación de datos en tu país, no puedes tener una Cuenta en GitHub.

No recopilamos de manera intencional la Información personal del usuario que está **almacenada en tus repositorios** u otros ingresos de contenido de forma libre. Toda información personal dentro del repositorio de un usuario es responsabilidad del propietario del repositorio.

### Cómo utiliza GitHub tu información

- Podemos utilizar tu información con los siguientes fines:
- Utilizamos tu [Información de registro](#registration-information) para crear tu cuenta y para proporcionarte el Servicio.
- Utilizamos tu [Información de pago](#payment-information) para proporcionarte el servicio de Cuenta paga, el servicio de Mercado, el Programa de patrocinadores o cualquier otro servicio pago de GitHub que solicites.
- Utilizamos tu Información personal del usuario, específicamente tu nombre de usuario, para identificarte en GitHub.
- Utilizamos tu [Información del perfil](#profile-information) para completar tu perfil de Cuenta y para compartir ese perfil con otros usuarios, si nos pides que lo hagamos.
- Utilizamos tu dirección de correo electrónico para comunicarnos contigo, si estuviste de acuerdo con ello, **y solo por las razones con las que estuviste de acuerdo**. Consulta nuestra sección en [comunicación por correo electrónico](#how-we-communicate-with-you) para obtener más información.
- Utilizamos Información personal del usuario para responder a las solicitudes de soporte técnico.
- Utilizamos Información personal del usuario y otros datos para hacerte recomendaciones, por ejemplo, sugerir proyectos que puedes querer seguir o con los que puedes querer contribuir. Aprendemos de tu comportamiento público en GitHub, por ejemplo, los proyectos a los que les pones estrellas, para determinar tus intereses de codificación y recomendamos proyectos similares. Estas recomendaciones son decisiones automáticas, pero no tienen un impacto legal en tus derechos.
- Podemos utilizar Información personal del usuario para invitarte a formar parte de las encuestas, los programas beta u otros proyectos de investigación, sujeto a tu consentimiento cuando resulte necesario.
- Utilizamos [Información de uso](#usage-information) e [Información del dispositivo](#device-information) para comprender mejor cómo utilizan GitHub nuestros Usuarios y para mejorar nuestro Sitio web y el Servicio.
- Si es necesario, podemos utilizar tu Información personal del usuario por motivos de seguridad o para investigar posibles fraudes o intentos de dañar a GitHub o a nuestros Usuarios.
- Podríamos utilizar tu Información personal de usuario para cumplir con nuestras obligaciones legales, proteger nuestra propiedad intelectual y hacer cumplir nuestras [Condiciones de Servicio](/github/site-policy/github-terms-of-service).
- Restringimos nuestro uso de tu Información personal del Usuario para los fines detallados en esta Declaración de privacidad. Si necesitamos utilizar tu Información personal del usuario para otros fines, te pediremos permiso primero. Siempre puedes ver qué información tenemos, cómo la estamos utilizando y qué permisos nos has dado en tu [perfil de usuario](https://github.com/settings/admin).

#### Nuestras bases legales para el procesamiento de información

En la medida que el procesamiento de tu Información personal del usuario esté sujeto a determinadas normas internacionales (incluido, entre otros, el Reglamento General de Protección de Datos [RGPD]) de la Unión Europea, se le exige a GitHub que te notifique acerca de la base legal sobre la cual procesamos la Información personal del usuario. GitHub procesa la Información personal del usuario sobre las siguientes bases legales:

- Ejecución del contrato:
  * Cuando creas una Cuenta de GitHub, proporcionas tu [Información de registro](#registration-information). Solicitamos esta información para que celebres el acuerdo de Términos del Servicio con nosotros y procesamos esa información sobre la base de la ejecución de ese contrato. También procesamos tu nombre de usuario y dirección de correo electrónico sobre otras bases legales, como se describe a continuación.
  * Si tienes una Cuenta paga con nosotros, recopilamos y procesamos más [Información de pago](#payment-information) sobre la base de la ejecución de ese contrato.
  * Cuando compras o vendes una aplicación listada en nuestro Marketplace o, cuando envías o recibes fondos a través del Programa GitHub Sponsors, procesamos la [Información de pago](#payment-information) y elementos adicionales para realizar el contrato que se aplica a esos servicios.
- Consentimiento:
  * Dependemos de tu consentimiento para utilizar tu Información personal del usuario en las siguientes circunstancias: cuando completas la información en tu [perfil de usuario](https://github.com/settings/admin); cuando decides participar en una capacitación de GitHub, proyecto de investigación, programa beta o encuesta; y con fines de marketing cuando corresponda. Toda esta Información personal del Usuario es completamente opcional, y tienes la capacidad de acceder a ella, modificarla y eliminarla en cualquier momento. Aunque no puedes eliminar tu dirección de correo electrónico por completo, puedes volverlo privado. Puedes retirar tu consentimiento en cualquier momento.
- Intereses legítimos:
  * En general, el recordatorio del procesamiento de Información personal del usuario que hacemos es necesario con fines de nuestro legítimo interés, por ejemplo, con fines de cumplimiento legal, fines de seguridad o para mantener la permanente confidencialidad, integridad, disponibilidad y resistencia de los sistemas, el sitio web y el Servicio de GitHub.
- Si quieres solicitar la eliminación de datos que procesamos sobre la base del consentimiento u objetar el procesamiento de la información personal que hacemos, utiliza nuestro [Formulario de contacto sobre Privacidad](https://support.github.com/contact/privacy).

### Cómo compartimos la información que recopilamos

Podemos compartir tu Información personal del usuario con terceros en alguna de las siguientes circunstancias:

#### Con tu consentimiento
Compartimos tu Información Personal del Usuario, si lo consientes, después de dejarte saber qué información será compartida, con quién y por qué. Por ejemplo, si compras una aplicación detallada en nuestro Mercado, compartimos tu nombre de usuario para permitirle al Programador de la aplicación que te proporcione los servicios. Asimismo, te puedes dirigir a nosotros a través de tus acciones en GitHub para compartir tu Información personal del usuario. Por ejemplo, si te unes a una Organización, indicas tu intención de proporcionarle al usuario de la Organización la capacidad de ver tu actividad en el registro de acceso de la Organización.

#### Con proveedores de servicios
Compartimos información personal del usuario con un número limitado de proveedores de servicios que la procesan en nuestro nombre para proporcionar o mejorar nuestro servicio, y quienes han aceptado restricciones de privacidad similares a las de nuestra Declaración de Privacidad firmando acuerdos de protección de datos o haciendo compromisos similares. Nuestros proveedores de servicio realizan el procesamiento de pagos, la emisión de tickets de soporte técnico del cliente, la transmisión de datos de red, la seguridad y otros servicios similares. Mientras GitHub procesa toda la Información Personal del Usuario en los Estados Unidos, nuestros proveedores de servicios pueden procesar datos fuera de los Estados Unidos o de la Unión Europea. Si te gustaría saber quiénes son nuestros proveedores de servicios, por favor consulta nuestra página sobre nuestros [Subprocesadores](/github/site-policy/github-subprocessors-and-cookies).

#### Con fines de seguridad
Si eres un miembro de una organización, GitHub puede compartir tu nombre de usuario, [Información de Uso](#usage-information), e [Información de Dispositivo](#device-information) asociadas con dicha organización con un propietario y/o administrador de la misma al punto en que tal información se proporcione únicamente para investigar o responder a un incidente de seguridad que afecte o ponga en riesgo la seguridad de esta organización en particular.

#### Para divulgación legal
GitHub se esfuerza por conseguir transparencia en el cumplimiento de los procesos legales y las obligaciones legales. A menos que no lo permita la ley o una orden judicial, o en circunstancias únicas y apremiantes, hacemos un esfuerzo razonable para notificarles a los usuarios cualquier divulgación obligatoria o exigida de su información personal. Si así se requiere, GitHub puede divulgar Información personal del usuario u otra información que recopilamos acerca de ti para cumplir con la ley y responder una citación válida, orden judicial, orden de allanamiento u orden gubernamental similar, o cuando consideremos de buena fe que la divulgación es necesaria para cumplir con nuestras obligaciones legales, para proteger nuestra propiedad o nuestros derechos, los de terceros o los del público en general.

Para obtener más información acerca de la divulgación en respuesta a solicitudes legales, consulta nuestros [Lineamientos para las Solicitudes Legales de Datos de Usuario](/github/site-policy/guidelines-for-legal-requests-of-user-data).

#### Cambios por control o venta
Podemos compartir Información Personal del Usuario si estamos involucrados en una fusión, venta o adquisición de entidades corporativas o unidades de negocio. Si ocurre cualquier cambio de propiedad, nos aseguraremos de que sea conforme a los términos que preservan la confidencialidad de la Información personal del usuario y, antes de hacer cualquier transferencia de tu Información personal del usuario, lo notificaremos en nuestro Sitio web o por correo electrónico. La organización que reciba alguna Información personal del usuario tendrá que respetar cualquier compromiso que hayamos asumido en nuestra Declaración de privacidad o Términos del Servicio.

#### Información agregada y sin indentificación personal
Compartimos cierta información agregada y no identificativa personal con otros acerca de cómo nuestros usuarios, de forma colectiva, utilice GitHub, o cómo nuestros usuarios responden a nuestras otras ofertas, tales como nuestras conferencias o eventos. Por ejemplo, [podemos compilar estadísticas sobre la actividad de código abierto en GitHub](https://octoverse.github.com/).

**No** vendemos tu Información personal del usuario con fines monetarios o en función de consideraciones de otro tipo.

Tenga en cuenta: La Ley de Privacidad del Consumidor de California de 2018 (“CCPA”) les exige a las empresas que expliciten en su política de seguridad si divulgan o no información personal a cambio de retribuciones monetarias u otras consideraciones de valor. While CCPA only covers California residents, we voluntarily extend its core rights for people to control their data to _all_ of our users, not just those who live in California. Puedes conocer más acerca de la CCPA y de cómo cumplimos con sus disposiciones [aquí](/github/site-policy/githubs-notice-about-the-california-consumer-privacy-act).

### Otra información importante

#### Contenidos del repositorio

El personal de GitHub [no accede a los repositorios privados a menos de que lo requiera](/github/site-policy/github-terms-of-service#e-private-repositories) por motivos de seguridad, para asistir al propietario del repositorio con un asunto de soporte, para mantener la integridad del Servicio o para cumplir con nuestras obligaciones legales. Sin embargo, si bien no buscamos contenido en tus repositorios generalmente, podríamos escanear nuestros servidores y su contenido para detectar ciertos tokens o firmas de seguridad, malware activo conocido, u otro tipo de contenido que sepamos que viola nuestras condiciones, tales como contenido violento extremista o terrorista o imágenes de explotación infantil con base en las técnicas algorítmicas de huellas digitales. Nuestras Condiciones de Servicio te proporcionan [más detalles](/github/site-policy/github-terms-of-service#e-private-repositories).

Si tu repositorio es público, cualquier persona puede ver los contenidos. Si incluyes [Información personal sensible](https://gdpr-info.eu/art-9-gdpr/) en tu repositorio público, como direcciones de correo electrónico o contraseñas, esa información se puede indexar por medio de motores de búsqueda o puede ser utilizada por terceros.

Por favor, consulta más sobre la [Información Personal del Usuario en los repositorios públicos](/github/site-policy/github-privacy-statement#public-information-on-github).

#### Información pública en GitHub

Muchos de los servicios y características de GitHub están orientados al público. Si tu contenido es público, los terceros pueden acceder y utilizarlo de acuerdo con nuestros Términos de servicio, como ver tu perfil o los repositorios o extraer datos por medio de nuestra API. Nosotros no vendemos ese contenido; es tuyo. Sin embargo, permitimos que terceros, como organizaciones de investigación o archivos, compilen información de GitHub orientada al público. Se ha sabido que otros terceros, como corredores de datos, también han extraído y compilado información de GitHub.

Tu Información personal del usuario, asociada con tu contenido, puede ser recopilada por terceros en estas compilaciones de datos de GitHub. Si no quieres que tu información personal de usuario aparezca en las compilaciones de los datos de GitHub de terceros, por favor no hagas tu Información Personal de Usuario disponible públicamente y asegúrate de [configurar tu dirección de correo electrónico en tu perfil de usuario para que sea privada](https://github.com/settings/emails), así como en tu [configuración de confirmaciones de git](/github/setting-up-and-managing-your-github-user-account/setting-your-commit-email-address). Actualmente configuramos la dirección de correo electrónico de los usuarios como privada por defecto, pero es posible que los usuarios de GitHub heredados necesiten actualizar sus configuraciones.

Si quieres compilar datos de GitHub, debes cumplir con nuestras condiciones de servicio con respecto al [scraping](/github/site-policy/github-acceptable-use-policies#5-scraping-and-api-usage-restrictions) y a la [privacidad](/github/site-policy/github-acceptable-use-policies#6-privacy), y podrías utilizar únicamente cualquier Información Personal de Usuario de cara al público que obtengas con el propósito para el cual lo autorizó nuestro usuario. Por ejemplo, donde un usuario de GitHub haya puesto una dirección de correo electrónico de cara al público para propósitos de identificación y atribución, no la utilices para publicidad comercial. Esperamos que protejas de manera razonable cualquier Información Personal de Usuario que hayas reunido de GitHub y respondas de inmediato a las quejas, las solicitudes de eliminación y las solicitudes de "no contactar" que haga GitHub u otros usuarios de GitHub.

Del mismo modo, los proyectos en GitHub pueden incluir Información Personal de Usuario disponible públicamente como parte del proceso de colaboración. Si tienes alguna queja sobre cualquier tipo de Información Personal de Usuario en GitHub, por favor, consulta nuestra sección de [resolución de quejas](/github/site-policy/github-privacy-statement#resolving-complaints).


#### Organizaciones

Puedes indicar, a través de tus acciones en GitHub, que estás dispuesto a compartir tu Información Personal de Usuario. Si colaboras o te conviertes en miembro de una Organización, los propietarios de su cuenta podrán recibir tu Información personal del usuario. Cuando aceptas una invitación a una Organización, se te notificará de los tipos de información que los propietarios pueden ver (para obtener más información, consulta la sección [Acerca de la Membrecía de Organización](/github/setting-up-and-managing-your-github-user-account/about-organization-membership)). Si aceptas una invitación a una organización con un [dominio verificado](/github/setting-up-and-managing-organizations-and-teams/verifying-your-organizations-domain), entonces los propietarios de dicha organización podrán ver tu(s) dirección(es) de correo electrónico completa(s) dentro de l(los) dominio(s) verificado(s) de la organización.

Por favor, nota que GitHub podría compartir tu nombre de usuario, [información de uso](#usage-information). e [Información de Dispositivo](#device-information) con el(los) propietario(s) de la organización a la cual perteneces, en medida en que tu Información Personal de Usuario se proporcione únicamente para investigar o responder a incidentes de seguridad que afecten o pongan en riesgo la seguridad de esta organización en particular.

Si colaboras con, o te conviertes en miembro de una cuenta que ha aceptado las [Condiciones de Servicio Corporativas](/github/site-policy/github-corporate-terms-of-service) y con una Adenda de Protección de Datos (DPA) para esta Declaración de Privacidad, entonces, dicha DPA regirá sobre los otros instrumentos en caso de que haya un conflicto con esta Declaración de Privacidad y con la DPA con respecto a tu actividad en la cuenta.

Contacta a los propietarios de la cuenta para obtener más información sobre la manera en que procesan tu Información personal del usuario y los modos de acceder, actualizar, modificar o borrar la Información personal del usuario almacenada en esa cuenta.

### Servicios adicionales

#### Aplicaciones de terceros

Tienes la opción de habilitar o agregar aplicaciones de terceros, conocidas como "Productos de programador", a tu cuenta. Estos Productos de Desarrollador no son necesarios para usar GitHub. Compartirás tu Información personal del usuario a terceros cuando nos lo solicites, como al comprar un Producto de programador de Marketplace; sin embargo, eres responsable del uso del Producto de programador de un tercero y por la cantidad de Información personal del usuario que eliges compartir con este. Puede revisar nuestra [documentación de API](/v3/users/) para ver qué información se proporciona cuando te autenticas en un Producto de Desarrollador usando tu perfil de GitHub.

#### Páginas de GitHub

Si creas un sitio web de Páginas de GitHub, es tu responsabilidad publicar una declaración de privacidad que describa con precisión cómo recolectar, usar y compartir información personal y otra información de visitantes, y cómo cumples con las leyes, normas y reglamentos de privacidad de datos vigentes. Ten en cuenta que GitHub puede recopilar Información personal del usuario de los visitantes a tu sitio web de Páginas de GitHub incluyendo registros de las direcciones IP del visitante, para mantener la seguridad e integridad del sitio web y del servicio.

#### Aplicaciones de GitHub

También puedes agregar aplicaciones desde GitHub, tales como nuestra aplicación de Escritorio, nuestra aplicación de Atom, u otras aplicaciones y características de las cuentas, a tu propia cuenta. Estas aplicaciones tienen sus propios términos y pueden recopilar diferentes tipos de Información personal del usuario; sin embargo, todas las aplicaciones de GitHub están sujetas a esta Declaración de Privacidad, y siempre recogeremos la cantidad mínima de Información personal del usuario necesaria y la usaremos únicamente para el propósito por el que nos la diste.

### Cómo puedes acceder y controlar la información que recopilamos

Si ya eres un usuario de GitHub, puedes acceder, actualizar, modificar o eliminar la información básica de tu perfil de usuario [editando tu perfil de usuario](https://github.com/settings/profile) o poniéndote en contacto con [el Soporte de GitHub](https://support.github.com/contact) o [el Soporte Premium de GitHub](https://enterprise.githubsupport.com/hc/en-us). Puedes controlar la información que recopilamos acerca de ti limitando la información que contiene tu perfil, manteniendo tu información actual, o poniéndote en contacto con [GitHub Support](https://support.github.com/contact) o [GitHub Premium Support](https://enterprise.githubsupport.com/hc/en-us).

Si GitHub procesa información sobre ti, como la información que [GitHub recibe de terceros](#information-we-collect-from-third-parties), y no tienes una cuenta, entonces puedes, sujeto a la ley vigente, acceder, actualizar, modificar, eliminar u objetar el procesamiento de tu información personal poniéndote en contacto con [GitHub Support](https://support.github.com/contact) o [GitHub Premium Support](https://enterprise.githubsupport.com/hc/en-us).

#### Portabilidad de datos

Como usuario de GitHub, siempre puedes llevar tus datos contigo. Puedes [clonar tus repositorios en tu escritorio](/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop), por ejemplo, o puedes utilizar nuestras [herramientas de portabilidad de datos](https://developer.github.com/changes/2018-05-24-user-migration-api/) para descargar la información que tenemos sobre ti.

#### Retención de datos y eliminación de datos

Generalmente, GitHub conserva la Información personal del usuario mientras tu cuenta esté activa o cuando sea necesaria para brindarte servicios.

If you would like to cancel your account or delete your User Personal Information, you may do so in your [user profile](https://github.com/settings/admin). Conservamos y utilizamos tu información según se necesita para cumplir con nuestras obligaciones legales, resolver disputas y hacer cumplir nuestros acuerdos, pero salvo requisitos legales, eliminaremos tu perfil completo (dentro de lo razonable) dentro de los 90 días siguientes a tu solicitud. Puedes ponerte en contacto con [GitHub Support](https://support.github.com/contact) o [GitHub Premium Support](https://enterprise.githubsupport.com/hc/en-us) para solicitar la eliminación de los datos que procesamos sobre la base del consentimiento en un plazo de 30 días.

Después de que una cuenta se ha eliminado, ciertos datos, tales como contribuciones a los repositorios de otros usuarios y comentarios en asuntos ajenos, permanecerán. Sin embargo, eliminaremos o desidentificaremos tu Información personal del usuario, incluyendo tu nombre de usuario y dirección de correo electrónico del campo de autor de propuestas, solicitudes de extracción y comentarios al asociarlos con un [usuario fantasma](https://github.com/ghost).

Una vez dicho esto, la dirección de correo electrónico que suministraste [a través de tu configuración de confirmaciones de Git](/github/setting-up-and-managing-your-github-user-account/setting-your-commit-email-address) siembre se asociará con tus confirmaciones en el sistema de Git. Si eliges hacer tu dirección de correo electrónico privada, también deberías actualizar la configuración de tu confirmación de cambios de Git. No podemos cambiar o eliminar datos en el historial de confirmación de Git (el software de Git está diseñado para mantener un registro) pero te permitimos controlar qué información pones en ese registro.

### Uso de cookies y seguimiento

#### Cookies

GitHub utiliza cookies para hacer que las interacciones con nuestro servicio sean fáciles y significativas. Las cookies son pequeños archivos de texto que los sitios web almacenan a menudo en discos duros o dispositivos móviles de los visitantes. Utilizamos cookies (y tecnologías similares, como HTML5 localStorage) para mantenerte conectado, recordar tus preferencias y proporcionar información para el desarrollo futuro de GitHub. Por razones de seguridad, utilizamos cookies para identificar un dispositivo. Al utilizar nuestro Sitio Web, aceptas que podamos colocar este tipo de cookies en tu ordenador o dispositivo. Si desactivas tu navegador o la capacidad de tu dispositivo para aceptar estas cookies, no podrás iniciar sesión ni utilizar los servicios de GitHub.

Proporcionamos una página web sobre [cookies y rastreo](/github/site-policy/github-subprocessors-and-cookies) que describe las cookies que implementamos, las necesidades que tenemos para utilizarlas y los tipos de cookies que manejamos (temporales y permanentes). También enumera a nuestros proveedores analíticos externos y a otros proveedores de servicios y detalla exactamente qué partes de nuestro Sitio Web les permitimos rastrear.

#### Seguimiento y análisis

Utilizamos una serie de proveedores analíticos y proveedores de servicios externos para ayudarnos a evaluar el uso de GitHub por parte de nuestros usuarios, compilar informes estadísticos sobre actividad y mejorar nuestro contenido y el rendimiento del sitio web. Solo utilizamos estos proveedores analíticos externos en ciertas áreas de nuestro sitio web, y todos ellos han firmado acuerdos de protección de datos con nosotros que limitan el tipo de Información personal del usuario que pueden recopilar y la finalidad para la que pueden procesar la información. Además, utilizamos nuestro propio software de análisis interno para proporcionar características y mejorar nuestro contenido y rendimiento.

Algunos navegadores han incorporado características de "No rastrear" (DNT) que pueden enviar una señal a los sitios web que visitas, que indica que no deseas ser rastreado. GitHub responde a las señales DNT del navegador y sigue el estándar [W3C para responder a las señales DNT](https://www.w3.org/TR/tracking-dnt/). Si no has habilitado DNT en un navegador que lo admita, las cookies de algunas partes de nuestro sitio web rastrearán tu actividad de navegación en línea en otros servicios en el transcurso del tiempo, aunque no permitimos que terceros que no sean nuestros proveedores analíticos y de servicios hagan un seguimiento de la actividad de los usuarios de GitHub a lo largo del tiempo en GitHub.

### Cómo asegura GitHub tu información

GitHub toma todas las medidas razonablemente necesarias para proteger la Información personal del usuario contra accesos no autorizados, modificación o destrucción; mantener la exactitud de los datos y ayudar a asegurar el uso adecuado de la Información personal del usuario.

GitHub aplica un programa escrito de información de seguridad. Nuestro programa:
- se alinea con los marcos reconocidos de la industria;
- incluye protecciones de seguridad diseñadas de manera razonable para proteger la confidencialidad, la integridad, la disponibilidad y la flexibilidad de los datos de usuarios;
- es adecuado para la naturaleza, el tamaño y la complejidad de las operaciones comerciales de GitHub;
- incluye procesos de respuesta frente a un incidente y notificación de filtración de datos; y
- cumple con las leyes y regulaciones vigentes relacionadas a la seguridad de la información en las regiones geográficas donde GitHub realiza operaciones.

En caso de una filtración de datos que afecte tu Información personal del usuario, actuaremos rápidamente para mitigar el impacto de una infracción y notificar a los usuarios afectados sin demoras indebidas.

La transmisión de datos en GitHub es cifrada usando SSH, HTTPS (TLS) y el contenido del repositorio de git es cifrado en reposo. Administramos nuestras propias jaulas y racks en centros de datos de alto nivel con un alto nivel de seguridad física y de red, y cuando los datos se almacenan con un proveedor de almacenamiento de terceros se cifran.

Ningún método de transmisión, o método de almacenamiento electrónico, es 100 % seguro. Por lo tanto, no podemos garantizar su seguridad absoluta. Para obtener más información, consulta nuestras [divulgaciones de seguridad](https://github.com/security).

### Prácticas de privacidad mundiales de GitHub

GitHub, Inc. and, for those in the European Economic Area, the United Kingdom, and Switzerland, GitHub B. V. are the controllers responsible for the processing of your personal information in connection with the Service, except (a) with respect to personal information that was added to a repository by its contributors, in which case the owner of that repository is the controller and GitHub is the processor (or, if the owner acts as a processor, GitHub will be the subprocessor); or (b) when you and GitHub have entered into a separate agreement that covers data privacy (such as a Data Processing Agreement).

Nuestras direcciones físicas son:

- GitHub, Inc., 88 Colin P. Kelly Jr. Street, San Francisco, CA 94107.
- GitHub B.V., Vijzelstraat 68-72, 1017 HL Amsterdam, The Netherlands.

Almacenamos y procesamos la información que recolectamos en los Estados Unidos de acuerdo con esta Declaración de Privacidad, aunque nuestros proveedores de servicios podrían almacenar y procesar los datos fuera de los Estados Unidos. Sin embargo, entendemos que tenemos usuarios de diferentes países y regiones con diferentes expectativas de privacidad e intentamos satisfacer esas necesidades incluso cuando los Estados Unidos no tienen el mismo marco de privacidad que otros países.

Proporcionamos el mismo estándar alto de protección de privacidad—como se describe en la presente Declaración de Privacidad—a todos nuestros usuarios en todo el mundo, sin importar su país de origen o ubicación, y estamos orgullosos de los niveles de notificaciones, elección, responsabilidad, seguridad, integridad de datos, acceso y recursos que proporcionamos. Trabajamos duro para cumplir con las leyes vigentes sobre privacidad de datos dondequiera que hagamos negocios, al trabajar con nuestro Oficial de Protección de Datos como parte de un equipo multifuncional que supervisa nuestros esfuerzos de cumplimiento de la privacidad. Además, si nuestros proveedores o afiliados tienen acceso a la Información personal del usuario, deben firmar acuerdos que los obliguen a cumplir con nuestras políticas de privacidad y con las leyes vigentes sobre privacidad de datos.

En particular:

 - GitHub proporciona métodos claros de consentimiento sin ambigüedad, informado, específico y libremente dado en el momento de la recopilación de datos, cuando recopilamos tu Información personal del usuario utilizando el consentimiento como base.
 - Solo recopilamos la cantidad mínima de Información personal del usuario necesaria para nuestros propósitos, a menos que decidas proporcionar más. Te animamos a que sólo nos proporciones la cantidad de datos que consideres oportuno compartir.
 - Te ofrecemos métodos sencillos de acceso, modificación o eliminación de la Información personal del usuario que hemos recopilado, en los casos legalmente permitidos.
 - Proporcionamos a nuestros usuarios aviso, elección, responsabilidad, seguridad y acceso con respecto a su Información personal del usuario y limitamos el propósito por el cual procesarla. También proporcionamos a nuestros usuarios un método de recurso y cumplimiento.

#### Transferencias de datos transfronterizas

GitHub procesa información personal tanto dentro como fuera de los Estados Unidos y se basa en las Cláusulas Contractuales Estándar como un mecanismo legal para transferir datos legalmente desde el Área Económica Europea, el Reino Unido y Suiza hacia los Estados Unidos. Adicionalmente, GitHub se certifica en los Marcos de Trabajo de Escudo de Privacidad de UE-U. S. A y Suiza-U. S. A. Para conocer más sobre las transferencias de datos interfronterizas, consulta nuestras [Prácticas de Privacidad Globales](/github/site-policy/global-privacy-practices).

### Cómo nos comunicamos contigo

Utilizamos tu dirección de correo electrónico para comunicarnos contigo, si estuviste de acuerdo con ello, **y solo por las razones con las que estuviste de acuerdo**. Por ejemplo, si contactas a nuestro equipo de Soporte con una solicitud, te responderemos por correo electrónico. Tienes mucho control sobre cómo se utiliza y comparte tu dirección de correo electrónico en y a través de GitHub. Puedes administrar tus preferencias de comunicación en tu perfil de usuario [](https://github.com/settings/emails).

Por diseño, el sistema de control de versiones de Git asocia muchas acciones con la dirección de correo electrónico de un usuario, como mensajes de confirmación. No podemos cambiar muchos aspectos del sistema Git. Si deseas que tu dirección de correo electrónico siga siendo privada, incluso cuando estés comentando en los repositorios públicos, [puedes crear una dirección de correo electrónico privada en tu perfil de usuario](https://github.com/settings/emails). También deberías [actualizar tu configuración local de Git para utilizar tu dirección de correo electrónico privada](/github/setting-up-and-managing-your-github-user-account/setting-your-commit-email-address). Esto no cambiará la forma en que nos pondremos en contacto contigo, pero afectará la manera en que otros te vean. Actualmente configuramos la dirección de correo electrónico de los usuarios de forma privada por defecto, pero es posible que los usuarios de GitHub heredados necesiten actualizar sus configuraciones. Por favor, consulta la información adicional sobre las direcciones de correo electrónico en los mensajes de confirmación [aquí](/github/setting-up-and-managing-your-github-user-account/setting-your-commit-email-address).

Dependiendo de tu [configuración de correo electrónico](https://github.com/settings/emails), GitHub puede enviar ocasionalmente correos electrónicos de notificación sobre los cambios en un repositorio que estás viendo, nuevas características, solicitudes de comentarios, cambios importantes en la política o para ofrecer asistencia al cliente. También enviamos correos electrónicos de marketing, basados en tus opciones y de acuerdo con las leyes y regulaciones vigentes. Hay un enlace "darse de baja" ubicado en la parte inferior de cada uno de los correos electrónicos de marketing que te enviamos. Ten en cuenta que no puedes optar por no recibir comunicaciones importantes de nosotros, como correos electrónicos de nuestro equipo de soporte o correos electrónicos del sistema, pero puedes configurar la configuración de las notificaciones en tu perfil para optar por no recibir otras comunicaciones.

Nuestros correos electrónicos pueden contener una etiqueta de píxeles, que es una pequeña imagen clara que puede decirnos si has abierto o no un correo electrónico y cuál es tu dirección IP. Utilizamos esta etiqueta de píxeles para que nuestro correo electrónico sea más efectivo para ti y para asegurarnos de que no te estamos enviando correo electrónico no deseado.

### Resolver reclamos

Si tienes inquietudes acerca de la forma en que GitHub está manejando tu Información personal del usuario, por favor haznos un comentario inmediatamente. Queremos ayudar. Puedes ponerte en contacto con nosotros completando el [Formulario de contacto de privacidad](https://support.github.com/contact/privacy). También puedes enviarnos un correo electrónico directamente a privacy@github.com con el asunto "Confirmaciones de privacidad". Responderemos rápidamente, dentro de los 45 días a más tardar.

También puedes ponerte en contacto directamente con nuestro Responsable de Protección de Datos.

| Nuestra casa central de los Estados Unidos | Nuestra oficina de la UE |
| ------------------------------------------ | ------------------------ |
| Oficial de Protección de Datos de GitHub   | GitHub BV                |
| 88 Colin P. Kelly Jr. St.                  | Vijzelstraat 68-72       |
| San Francisco, CA 94107                    | 1017 HL Amsterdam        |
| Estados Unidos                             | Países Bajos             |
| privacy@github.com                         | privacy@github.com       |

#### Proceso de resolución de disputas

En el improbable caso de que surja una disputa entre tú y GitHub con respecto al manejo de tu Información personal del usuario, haremos todo lo posible por resolverla. Adicionalmente, si eres un residente de un estado miembro de la UE, tienes el derecho de emitir una queja con tu autoridad supervisora local, y podrías tener más [opciones](/github/site-policy/global-privacy-practices#dispute-resolution-process).

### Cambios en tu Declaración de privacidad

Aunque es probable que la mayoría de los cambios sean mínimos, GitHub puede cambiar nuestra Declaración de privacidad de manera ocasional. Les notificaremos a los Usuarios acerca de los cambios materiales a esta Declaración de privacidad por medio de nuestro Sitio web, al menos, 30 días antes de que el cambio entre en vigencia a través de la publicación de un aviso en nuestra página de inicio o enviando un correo electrónico a la dirección principal de correo electrónico que se especifica en tu cuenta de GitHub. También actualizaremos nuestro [Repositorio de políticas del sitio](https://github.com/github/site-policy/), que realiza un seguimiento de todos los cambios de esta política. Por cambios en esta Declaración de privacidad que no sean cambios sustanciales o que no afecten tus derechos, alentamos a los Usuarios a revisar nuestro repositorio de Políticas del sitio de manera frecuente.

### Licencia

La presente Declaración de privacidad está autorizada conforme a esta [licencia de Creative Commons Zero](https://creativecommons.org/publicdomain/zero/1.0/). Para obtener más detalles, consulta nuestro [repositorio de políticas del sitio](https://github.com/github/site-policy#license).

### Contactarse con GitHub
Las preguntas al respecto de la Declaración de privacidad de GitHub o de las prácticas de manejo de la información se deben realizar por medio de nuestro [Formulario de contacto de privacidad](https://support.github.com/contact/privacy).

### Traducciones

A continuación, aparecen traducciones de este documento a otros idiomas. En caso de cualquier conflicto, incertidumbre o aparente inconsistencia entre cualquiera de esas versiones y la versión en inglés, la versión en inglés es la versión que prima.

#### Francés
Cliquez ici pour obtenir la version française: [Déclaration de confidentialité de GitHub](/assets/images/help/site-policy/github-privacy-statement(12.20.19)(FR).pdf)

#### Otras traducciones

Para las traducciones de esta declaración hacia otros idiomas, por favor visita [https://docs.github.com/](/) y selecciona el idioma desde el menú desplegable debajo de "Inglés".
