---
title: Adenda de protección de datos de GitHub
versions:
  free-pro-team: '*'
---

Fecha de entrada en vigencia de la versión: 20 de julio de 2020

## INTRODUCCIÓN

Las partes acuerdan que la Protección de Datos de GitHub y la Evidencia de Seguridad (en conjunto, la **Adenda de Protección de Datos"** o **"DPA"**) enuncia sus obligaciones con respecto al procesamiento y seguridad de los Datos Personales del Cliente en conexión con el servicio hospedado de GitHub Enterprise Cloud (el **"Servicio"**). En esta DPA, GitHub se compromete con todos los clientes que utilicen el Servicio. Las condiciones separadas, incluyendo aquellas condiciones diferentes de privacidad y seguridad, rigen el uso de los clientes para los productos diferentes a los de GitHub.

En caso de que exista cualquier conflicto o inconsistencia entre la DPA y cualquier otra condición en el acuerdo del cliente con Github, la DPA deberá prevalecer. Las disposiciones de la DPA sustituyen cualquier disposición que entre en conflicto con la Declaración de Privacidad de GitHub que pudiera aplicarse de otra forma al procesamiento de los Datos Personales del Cliente como se define en el presente documento. Para mayor claridad, en apego a la Cláusula 10 de las Cláusulas Contractuales Estándar en el Adjunto 1, las Cláusulas Contractuales Estándar prevalecerán sobre cualquier otra condición en la DPA.


## PROTECCIÓN DE DATOS DE GITHUB

### 1.  Definiciones.

1.1 Las "**Leyes de Protección de Datos Aplicables**" se refiere a ciertas leyes, regulaciones, marcos de trabajo regulatorios, u otras legislaciones que se relacionen con el procesamiento y el uso de los Datos Personales del Cliente, de acuerdo a lo aplicable con el uso de GitHub por parte del cliente y del Servicio de GitHub, incluyendo:

  a.  El reglamento general de protección de datos 2016/679 de la UE (**RGPD**), junto con cualquier legislación o reglamentación nacional equivalente que sea de aplicación o correspondiente, una vez que se aplique o sea aplicable; y

  b.  La Ley de Privacidad de los Consumidores de California de 2018, Cal. Civ. Code §§1798.100 et seq. (**"CCPA"**); y

  c.  La Ley de Protección de Datos del Reino Unido de 2018 y la implementación de RGDP que se contiene en la misma.

1,2 Las palabras "**Controlador**", "**Titular de los datos**", "**Estado miembro**", "**Datos Personales**", "**Violación a los Datos Personales**, "**Procesamiento**", "**Procesador**", y "**Autoridad de Supervisión**" tienen los significados que se les otorguen en las Leyes de Protección de Datos Aplicables. En el caso de un conflicto, prevalecerán los significados que se les atribuyen en el RGPD.

1.3  "**Datos personales del Cliente**" se refiere a cualquier Dato personal del cual el Cliente sea Controlador, ya sea suministrado por el Cliente para el procesamiento de GitHub o generado por GitHub durante la realización de sus obligaciones conforme al Acuerdo. Incluye datos como información de la facturación, direcciones IP, direcciones de correo electrónico corporativas y cualquier otro Dato personal del cual el Cliente sea Controlador.

1.4  "**Datos del Repositorio del Cliente**" se refiere a cualquier dato o información que el Cliente carga o crea en cualquiera de sus Repositorios privados.

1.5 A "**Violación de datos**" se refiere a una violación de datos personales o cualquier otro incumplimiento confirmado o razonablemente sospechado de los datos protegidos del cliente.

1.6  "**Usuario final**" se refiere a un Sujeto de datos individual que controla una cuenta de GitHub y aceptó los Términos de servicio de GitHub, y cuyos datos personales están siendo transferidos, almacenados o procesados por GitHub. Por ejemplo, cada empleado o contratista del Cliente que tiene una cuenta de GitHub también es un Usuario final de GitHub.

1.7  "**Fines permitidos**" para el procesamiento de datos son aquellos fines limitados y específicos de prestación del Servicio según se establece en el Acuerdo, en la Declaración de privacidad de GitHub y en el presente Apéndice A, o los fines para los cuales un Sujeto de datos autorizó el uso de los Datos personales del Cliente.

1.8  "**Datos protegidos**" incluye cualquier Dato personal del Cliente y cualquier Dato del Repositorio del Cliente procesado por GitHub en nombre del Cliente, según lo dispuesto en el Acuerdo.

1.9  "**Datos Sensibles**" Significa cualquier tipo de dato personal que revele el origen racial o étnico; las opiniones políticas, las creencias religiosas o filosóficas o afiliaciones a sindicatos; procesamiento de datos genéticos o biométricos para propósitos únicos de identificación de una persona natural; datos pertinentes a la salud, la vida sexual de una persona natural o la orientación sexual de la misma; y los datos pertinentes a las ofensas, convicciones criminales o medidas de seguridad.

### 2. Estado y cumplimiento.

#### 2.1 Procesamiento de Datos.
GitHub actúa como un Procesador con respecto a los Datos Personales de los clientes que recibe en conexión con el Acuerdo, y GitHub procesará los Datos Personales del Cliente únicamente para los propósitos permitidos de acuerdo con las instrucciones del Cliente de acuerdo a como se representa en el Acuerdo y en otros comunicados por escrito. En el caso de que GitHub no pueda cumplir con las indicaciones del Cliente, por ejemplo, debido a conflictos con las Leyes aplicables de Protección de datos, o cuando las Leyes aplicables de Protección de datos u otros requisitos legales requieren el procesamiento, GitHub notificará al Cliente en la medida de lo permitido. GitHub procesa todos los Datos personales del Cliente en los Estados Unidos o en la Unión Europea; sin embargo, los subprocesadores de GitHub pueden procesar datos fuera de los Estados Unidos o la Unión Europea. Además, GitHub actúa como Procesador para cualquier Dato del Repositorio del Cliente.

#### 2.2 Controladores de Datos.
GitHub recibe Datos Personales de los Clientes tanto del Cliente como directamente de los Titulares de los Datos que crean cuentas de Usuario Final. El Cliente es Controlador únicamente de los Datos personales del Cliente que transfiere directamente a GitHub.

#### 2.3 Cumplimiento de GitHub; Transferencias de Datos.
GitHub cumplirá con las Leyes Aplicables de Protección de Datosen relación con el procesamiento de los Datos Personales del Cliente.

Todas las transferencias de Datos Personales del Cliente fuera de la Unión Europea, el Área Económica Europea, el Reino Unido y Suiza par aproporcionar el Servicio se regirán por las Cláusulas Contractuales Estándar en el Adjunto 1 (Cláusulas Contractuales Estándar). GitHub cumplirá con los requerimientos del Área Económica Europea y la ley de protección de datos suiza de acuerdo con la recolección, uso, transferencia, retención y otros tipos de procesamiento de Datos Personales de los Clientes desde el Área Económica Europea, el Reino Unido y Suiza. Todas las transferencias de Datos Personales del Cliente a un país tercero o a una organización internacional estarán sujetos a la salvaguarda adecuada de acuerdo a lo descrito en el artículo 46 del RGPD y dichas transferencias y salvaguardas se documentarán de acuerdo con el artículo 30(2) del RGPD.

Adicionalmente, GitHub está certificado en el Marco del Escudo de Privacidad de U.E. - E.U.A. y de Suiza - E.U.A. Privacy Shield Frameworks and the commitments they entail, although GitHub does not rely on them as a legal basis for transfers of Personal Data.  GitHub acuerda notificar al cliente si hace una determinación de que ya no puede cumplir con su obligación de proporcional el mismo nivel de protección de acuerdo a como se requiere con los principios del Escudo de Privacidad.


### 3. Protección de datos.

#### 3.1 Limitación de propósitos.
GitHub procesará y comunicará los Datos Protegidos únicmente para los Propósitos Permitidos, a menos de que las partes convengan por escrito un propósito ampliado.

#### 3.2 Calidad y Proporcionalidad de los Datos.
GitHub mantendrá los Datos Personales del Cliente actualizados y exactos, o habilitará al cliente para que lo haga. GitHub seguirá los pasos comercialmente razonables para asegurar que cualquier Dato protegido que recopile en nombre del Cliente sea adecuado, relevante y no excesivo en relación con los fines para los cuales se transfiere y se procesa. En ningún caso GitHub recopilará intencionalmente Datos confidenciales en nombre del Cliente. El Cliente acepta que el Servicio de GitHub no está destinado al almacenamiento de Datos confidenciales. Si el Cliente decide cargar Datos confidenciales en el Servicio, el Cliente debe cumplir con el Artículo 9 del GDPR, o las disposiciones equivalentes de las Leyes aplicables de Protección de datos.

#### 3.3 Retención y Eliminación de Datos.
Bajo la solicitud razonable del cliente, a menos de que se prohiba por ley, GitHub devolverá, destruirá o desidentificará todos los Datos Personales del Cliente y los datos relacionados en todas las ubicaciones donde se almacenen después de que dejen de requerirse para los Propósitos Permitidos dentro de treinta días de la solicitud. GitHub puede conservar los Datos personales del Cliente y los datos relacionados en la medida que lo exijan las Leyes aplicables de Protección de datos y solo en la medida y por el período que estas lo requieran, siempre que GitHub asegure que los Datos personales del Cliente se procesarán solo si se necesitan para el fin especificado en las Leyes aplicables de Protección de datos y sin ningún otro fin, y los Datos personales del Cliente segruirán protegidos por las Leyes aplicables de Protección de datos.

#### 3.4 Procesamiento de Datos.
GitHub proporciona la siguiente información, requerida por el Artículo 28(3) del RGPD, con respecto a su procesamiento de los Datos protegidos del Cliente:

a.  *El motivo y la duración del procesamiento* de los Datos personales del Cliente están establecidos en el Acuerdo y en el presente Anexo.

b.  *La naturaleza y el fin del procesamiento* de los Datos personales del Cliente se describen en la Sección 3.1 del presente Anexo.

c.  *Los tipos de Datos personales del Cliente que se procesarán* se describen en la Declaración de privacidad de GitHub e incluyen Datos personales del Cliente, tales como nombres de usuario, contraseñas, direcciones de correo electrónico y direcciones IP. GitHub también procesa la información necesaria para la facturación de la cuenta del Cliente, pero no procesa ni almacena información sobre tarjetas de crédito. El Cliente puede elegir suministrarle a GitHub Datos personales del Cliente, por ejemplo, en los parámetros del perfil del Cliente o al cargar Datos personales del Cliente en sus repositorios de GitHub.

d.  *Las categorías del Sujeto de datos con quien se relacionan los Datos personales del Cliente* son el propio Cliente y sus Usuarios finales.

e.  *Las obligaciones y los derechos del Cliente* están establecidos en el Acuerdo y en el presente Anexo.

### 4. Seguridad y obligaciones de auditoría.

#### 4.1 Medidas de Seguridad Técnicas y Organizacionales.
Tomando en cuenta las tecnologías más actuales, los costos de implementación, y la naturaleza, alcance, contexto y propósito de procesamiento, así como el riesgo de variar la probabilidad y severidad de los derechos y libertades de las personas naturales, GitHub implementará medidas técnicas y organizacionales adecuadas para garantizar un nivel de seguridad adecuado para los riesgos, tales como aquellas contra la destrucción accidental o ilegal, o contra la pérdida, alteración, o contra el acceso o divulgación no autorizados que se presenten debido al Procesamiento de los Datos. GitHub supervisará regularmente el cumplimiento de estas medidas y continuará tomando las debidas salvaguardias durante la vigencia del Acuerdo. Consulte la Sección 1.1 del Apéndice de Seguridad de GitHub respecto de las responsabilidades de GitHub en relación con las salvaguardias de seguridad.

#### 4.2 Respuesta a Incidentes y Notificación de Filtración.
GitHub cumplirá con las obligaciones de Seguridad de la Información que se encuentran en las Pruebas de Seguridad de GitHub y en las Leyes de Protección de Datos, incluyendo las obligaciones de notificación para la Filtración de Datos. Consulte la Sección 1.2 del Apéndice de Seguridad de GitHub sobre las responsabilidades de GitHub en relación con la respuesta y notificación del Incumplimiento de datos.

#### 4.3 Personal de GitHub.
GitHub representa y garantiza que tomará los pasos razonables para asegurarse de que todo su personal que maneje Datos Protegidos haya acordado mantener dichos datos como confidenciales y haya recibido capacitación adecuada para cumplir con esta Adenda y con las Leyes de Protección de Datos Aplicables.

#### 4.4 Registros.
GitHub mantendrá los registros por escrito completos, precisos y actualizados para todas las categorías de las actividades de procesamiento que se lleven a cabo en nombre de un Cliente, las cuales contengan la información que se requiere por las Leyes de Protección de Datos Aplicables. En la medida que la asistencia no ponga en riesgo la seguridad de GitHub o los derechos de privacidad de Sujetos de datos individuales, GitHub pondrá a disposición del Cliente estos registros a su solicitud cuando se requieran de manera razonable, por ejemplo, para ayudar al Cliente a demostrar su cumplimiento según lo dispuesto en las Leyes aplicables de Protección de datos. Para conocer más sobre los requisitos de GitHub para proporcionar asistencia en caso de un incidente de seguridad, consulta la Sección 1.2 del Apéndice de Seguridad de GitHub.

#### 4.5 Reporte de Cumplimiento.
GitHub proporcionará reportes de cumplimiento en seguridad de acuerdo con la sección 2.3 de la Prueba de Seguridad de Github y también los reportes de cumplimiento de privacidad de acuerdo con la misma sección. El Cliente acepta que cualquier información y derechos de auditoría concedidos por las Leyes aplicables de Protección de datos (incluido, cuando corresponda, el Artículo 28(3)(h) del GDPR) se cubrirán con estos informes de cumplimiento y solo se presentarán en la medida que la generación de un informe de cumplimiento por parte de GitHub no brinde suficiente información o en la medida que el Cliente deba responder a una auditoría de la Autoridad de supervisión o reglamentaria. La Sección 3.1 del Apéndice de Seguridad de GitHub describe las responsabilidades de las Partes en relación con una auditoría de la Autoridad de supervisión o reglamentaria.

#### 4.6 Asistencia.
GitHub proporcionará asistencia considerable a los Clientes con preocupaciones tales como la valoración de impacto de la privacidad de los datos, solicitudes de derechos de los Titulares de los Datos, consultas con las Autoridades Supervisantes, y otros asuntes similares, en cada caso, únicamente para el procesamiento de los Datos Personales del cliente y tomando en cuenta la naturaleza del procesamiento.

### 5. Uso y divulgación de Datos protegidos.

#### 5.1 Si Uso para Marketing.
GitHub no utilizará los Datos Protegidos para propósitos de anunciar el contenido de terceros, y no venderá los Datos Protegidos a ningún tercero, excepto como parte de una adquisición o fusión.

#### 5.2 Declaración de Privacidad de GitHub.
La Declaración de Privacidad de GitHub, la cual está disponible al público en [https://docs.github.com/articles/github-privacy-statement](/articles/github-privacy-statement), proporciona notificaciones detalladas de las prácticas de uso de datos y de privacidad de GitHub, incluyendo su uso de cookies, su proceso de resolución de disputas, y más detalles sobre el cumplimiento con el RGPD.

### 6. Subprocesamiento y transferencia ulterior.

#### 6.1 Protección de los Datos.
GitHub es responsable de las transferencias subsecuentes de los Datos Protegidos a sus subprocesadores, tales como su procesador de pagos tercero. En caso de que GitHub sí transfiera los Datos Protegidos a un subprocesador tercero, o que GitHub instale, use o habilite a un tercero o a un servicio de un tercero para procesar los Datos Protegidos en nombre de GitHub, github garantizará que dicho subprocesador tercero esté vinculado por un contrato escrito que le requiera proporcionar por lo menos el mismo nivel de confidencialidad, seguridad y protección de privacidad de acuerdo a como lo requiere GitHub en esta DPA y conforme a las Leyes de Protección de Datos Aplicables.

#### 6.2 Aceptación de los Subprocesadores de GitHub.
El cliente autoriza a GitHub para designar (y permitir a cada subprocesador designado de acuerdo con la sección 6 el designar) subprocesadores de acuerdo con la sección 6 y con cualquier otra restricción en el Acuerdo. GitHub puede seguir usando los subprocesadores a los que actualmente recurre a partir de la Fecha de entrada en vigor del presente Anexo.

#### 6.3 Consentimiento General para el Subprocesamiento Posterior.
El cliente proporciona un consentimiento general para que GitHub incluya subprocesadores posteriores, condicionalmente con el cumplimiento de GitHub con los siguientes requisitos:

a.  Cualquier suprocesador posterior deberá acordar por escrito solo procesar los datos en un país en el que la Comisión Europea haya declarado tener un nivel de protección "adecuado"; o el procesar solo datos en condiciones equivalentes a las Cláusulas Contractuales Estándar, o conforme a una aprobación de Reglas Corporativas de Vinculación que otorgue una autoridad de protección de datos europea competente, o conforme a las certificaciones de Escudo de Privacidad de UE-EUA y Suiza-E.U.A válids. ; y

b.  GitHub restringirá el acceso de los subprocesadores ulteriores a los Datos personales del Cliente solo a lo que resulte estrictamente necesario para prestar sus servicios, y GitHub le prohibirá al subprocesador procesar los Datos personales del Cliente para cualquier otro fin.

#### 6.4 Divulgación de los Acuerdos de los Subprocesadores.
GitHub mantiene una lista de subprocesadores posteriores que ha contactado para procesar los Datos Personales de los Clientes en [https://docs.github.com/articles/github-subprocessors-and-cookies](/articles/github-subprocessors-and-cookies), incluyendo las categorías de Datos Personales de Clientes que se han procesado, una descripción del tipo de procesamiento que realiza el subprocesador, y la ubicación de su procesamiento. GitHub proporcionará al Cliente, previa solicitud escrita, la lista de subprocesadores y los términos según los cuales procesan los Datos personales del Cliente. Conforme a las restricciones de confidencialidad del subprocesador, GitHub puede eliminar cualquier información confidencial o comercialmente sensible antes de proporcionarle la lista y los términos al Cliente. En el caso de que GitHub no le pueda divulgar información confidencial o sensible al Cliente, las Partes acuerdan que GitHub proporcionará toda la información que razonablemente pueda en conexión con sus acuerdos de subprocesamiento.

#### 6.5 Objeción a los Subprocesadores.
GitHub proporcionará treinta (30) días de notificación previa por escrito sobre la adición o eliminación de cualquier subprocesador, incluyendo a los de las categorías listadas en la sección 6.4, mediante el anuncio de los cambios en su sitio de <https://github.com/github/site-policy>. Si el Cliente tiene una objeción razonable sobre la incorporación de un nuevo subprocesador por parte de GitHub, el Cliente se lo debe notificar de inmediato por escrito a GitHub. En lo posible, GitHub hará los esfuerzos comercialmente razonables para proporcionar una solución alternativa al Servicio afectado para evitar el procesamiento de los datos por parte del subprocesador objetable. En el caso de que GitHub no pueda proporcionar una solución alternativa, y las Partes no puedan resolver el conflicto dentro de los noventa días, el Cliente puede poner fin al Acuerdo.

### 7. Terminación.

#### 7.1 Suspensión.
En caso de que GitHub se encuentre en una violación de sus obligaciones para mantener un niel adecuado de seguridad o protección de la privacidad, el cliente deberá suspender temporalmente la transferencia de todos los Datos Personales del mismo o prohibir la recolección y procesamiento de estos en nombre del cliente hasta que la violación se repare o hasta que finalice el contrato.

#### 7.2 Terminación con Causa.
Adicionalmente a cualquier derecho de terminación que tenga el clinte bajo el contrato, dicho cliente puede terminar el contrato sin afectación a ningún otro reclamo en derecho o equidad en caso de que:

a.  GitHub notifica al Cliente que ya no puede cumplir con sus obligaciones de privacidad;

b.  la transferencia, recopilación o procesamiento de todos los Datos personales del Cliente ha sido suspendida de forma temporal por más de un mes en virtud de la Sección 7.1;

c.  GitHub se encuentra en incumplimiento sustancial o persistente de cualquiera de las garantías o manifestaciones según lo dispuesto en el presente Anexo;

d.  GitHub no continúa con su actividad, se disuelve, entra en quiebra o se hace una orden de liquidación a nombre de GitHub;

e.  El Cliente objeta al subprocesador conforme a la Sección 6.5, y GitHub no ha podido proporcionar una solución alternativa dentro de los noventa días.

#### 7.3 Violación.
El incumplimiento con los aprovisionamientos materiales de esta adenda se considera una violación material bajo el acuerdo.

#### 7.4 Incapacidad de realización.
En caso de que los cambios a la ley o a las regulaciones se traduzcan en la imposibilidad de hacer valer esta adenda o que el hacerlo sea comercialmente irracional, las partes podrán volver a negociar la adenda de buena fe. Si la renegociación no soluciona la imposibilidad, o si las Partes no pueden llegar a un acuerdo, las Partes pueden terminar el Acuerdo luego de treinta días.

#### 7.5 Notificación.
En caso de que GitHub determine que ya no puede cumplir con sus obligaciones de privacidad conforme a esta adenda, Github notificará al cliente inmediatamente por escrito.

#### 7.6 Modificaciones.
GitHub podrá modificar esta adenda de vez en cuando de acuerdo a los requisitos de las Leyes de Protección de Datos Aplicables emitiendo una notificación al Cliente treinta días antes de hacerlo.

#### 7.7 Requisitos de la Terminación.
Al momento de la Terminación, GitHub Deberá:

a.  tomar las medidas razonables y adecuadas para detener el procesamiento de los Datos personales del Cliente;

b.  dentro de los noventa días posteriores a la terminación, eliminar o anonimizar cualquier Dato personal del Cliente que GitHub almacena en nombre del Cliente en virtud de la Sección 3.3;

c.  proporcionar al Cliente la certeza razonable de que GitHub ha cumplido con sus obligaciones de la Sección 7.7.

### 8. Responsabilidad por el procesamiento de datos.

#### 8.1 Limitaciones.
Salvo a las limitaciones que proporcionan las Leyes de Protección de Datos Aplicables, cualquier reclamo que se suscite bajo esta adenda estará sujeto a las condiciones del acuerdo con respecto a las Limitaciiones de Responsabilidades.

## Adjunto 1 – Las Cláusulas Contractuales Estándar (Procesadores)
La ejecución del presente acuerdo a manes del cliente incluye la ejecución de este Adjunto 1 a la Adenda de Protección de Datos de Github, la cual refrenda GitHub, Inc.

En los países donde se requiera de aprobación regulatoria para utilizar las Cláusulas Contractuales Estándar, no se podrá depender de éstas bajo la Comisión Europea 2010/87/EU (de febrero de 2010) para legitimar la exportación de datos del país en cuestión, a menos de que el cliente tenga la aprobación regulatoria requerida.

Para propósitos del artículo 46(2) de la Regulación General de Protección de Datos (EU 2016/679) para la transferencia de datos personales a los procesadores establecidos en países terceros que no garantizan un nivel adecuado de protección de datos, el Cliente (como exportador de datos) y GitHub (como importador de datos, cuya firma aparece debajo), siendo cada uno de ellos una "parte", y en conjunto "las partes", acuerdan cumplir con las siguientes Cláusulas Contractuales (las "Cláusulas" o las "Cláusulas Contractuales Estándar") para citar los salvaguardos adecuados con respecto a la protección de la privacidad y de los derechos y libertades fundamentales de los individuos para la transferencia por parte del exportador de datos al importador de datos que manejará los datos personales especificados en el Apéndice 1.

#### Cláusula 1: Definiciones
(a) los términos 'datos personales', 'categorías especiales de datos, 'proceso/procesamiento', 'controlador', 'procesador', 'titular de los datos' y 'autoridad supervisora' tendrán el mismo significado que en la Regulación General de Protección de Datos (EU 2016/679) sobre la protección de los individuos con respecto al procesamiento de los datos personales y sobre el movimiento libre de dichos datos;

(b) 'el exportador de datos' se refiere al controlador que transifere los datos personales;

(c) 'el importador de datos' se refiere al procesador que acuerda recibir datos personales del exportador, los cuales se pretenden procesar en su nombre después de la transferencia, de acuerdo con sus instrucciones y los términos de las Cláusulas y quien no está sujeto a un sistema de país tercero que garantice la protección adecuada dentro de las disposiciones del artículo 45(2) de la Regulación General para la Protección de Datos (EU 2016/679);

(d) 'el subprocesador' significa cualquier procesador contactado mediante el importador de datos o mediante cualquier otro subprocesador del importador de datos quien acuerde recibir del importador de datos o de cualquier otro subprocesador de dicho importador los datos personales exclusivos que se pretenden utilizar en actividades de procesamiento que se llevarán acabo en nombre del exportador de datos después de la transferencia de acuerdo con sus instrucciones, las condiciones de las Cláusulas y las de el subcontrato por escrito;

(e) 'la ley de protección de datos aplicable' se refiere a la legislación que protege los derechos fundamentales y las libertades de los individuos y, particularmente, su derecho a la privacidad con respecto al procesamiento de los datos personales aplicables al controlador de datos en el Estado Miembro en el cual se establece el exportador de datos;

(f) 'medidas de seguridad técnicas y organizacionales' se refiere a aquellas medidas que se enfocan en proteger los datos contra una pérdida accidental o una destrucción ilegal, alteraciones, diseminación no autorizada o acceso, particularmente donde el procesamiento involucre la transmisión de datos a través de una red, y contra todo el resto de formas ilegales de procesamiento.

#### Cláusula 2: Detalles de la transferencia
Los detalles de la transferencia y, en particular, de las categorías especiales de datos personales en donde sean aplicables se especifican en el Apéndice 1 que se encuentra más adelante, el cual forma una parte integral de las Cláusulas.

#### Cláusula 3: Cláusula de beneficiario tercero
1. El titular de los datos podrá hacer valer la ley contra el exportador de datos en esta Cláusula, la Cláusula 4(b) a (i), la Cláusula 5(a) a (e), y de (g) a (j), la Cláusula 6(1) y (2), la Cláusula 8(2), y las Cláusulas 9 a 12 como beneficiario tercero.

2. El titular de los datos podrá hacer valer la ley contra el importador de datos en esta Cláusula, la Cláusula 5(a) a (e) y (g), la Cláusula 6, Cláusula 7, Clúsula 8(2) y las Cláusulas 9 a 12, en los casos en donde el exportador de los datos haya desaparecido realmente o haya dejado de existir en la ley a menos de que alguna entidad de sucesión haya asumido las obligaciones legales integrales del exportador de datos mediante onctrato o mediante la operación legal, como resultado de que lo que asume en los derechos y obligaciones del exportador de datos, en cuyo caso, el titular de los datos podrá hacer valor esto contra dicha entidad.

3. El sujeto de los datos puede aplicar la ley en contra del subprocesador de esta Cláusula, la Cláusula 5(a) a (e) y (g), Cláusula 6, Cláusula 7, Cláusula 8(2) y Cláusulas 9 a 12, en casos en donde tanto el exportador como el importador de los datos hayan desaparecido realmente o dejado de existir en la ley o se hayan declarado insolventes, a menos de que cualquier entidad sucesora haya asumido todas las obligaciones del exportador de los datos contractualmente o conforme a derecho que resulte en la toma de derchos y obligaciones del exportador de datos, en cuyo caso, el titular de los datos puede aplicar la ley en contra de dicha entidad. Dicha responsabilidad de terceros del subprocesador se limitará a sus propias operaciones de procesamiento bajo las Cláusulas.

4. Las partes no se oponen a que un titular de los datos se represente mediante una asociación o cualquier otro cuerpo si dicho titular así lo desea expresamente y si la ley nacional lo permite.

#### Cláusula 4: Las obligaciones del exportador de los datos
El exportador de los datos acuerda y garantiza:

(a) que el procesamiento, incluyendo la transferencia misma de los datos personales, se ha estado llevando a cabo y se seguirá haciendo de acuerdo con las disposiciones generales de la ley de protección de datos aplicable (y, cuando sea aplicable, se ha notificado a las autoridades relevantes del Estado Miembro en donde se establece el exportador de los datos) y no viola las disposiciones generales relevantes de dicho estado;

(b) que se ha instruido y, a través de la duración de los servicios de procesamiento de datos personales, se instuirá al importador de los datos para procesar los datos personales transferidos únicamente en nombre del exportador de los datos de acuerdo con la ley de protección de datos personales y con las Cláusulas;

(c) Que el importador de los datos proporcionará garantía suficiente con respecto a las medidas de seguridad técnicas y organizacionales especificadas en el Apéndice 2 descrito posteriormente;

(d) que después de la valoración de los requisitos para la ley de protección de datos aplicable, las medidas de seguridad son adecuadas para proteger los datos personales contra la destrucción accidental o ilegal o contra la pérdida, alteración, divulgación no autorizada o acceso accidentales, particularmente en donde el procesamiento involucre la transmisión de datos a través de una red, y contra cualquier otra forma ilegal de procesamiento, y que estas medidas garantizan un nivel de seguridad adecuado para los riesgos que se presentan mediante el procesamiento y por la naturaleza de los datos que se protegerán con respecto a las tecnologías más recientes y el costo de su implementación;

(e) que garantizará el cumplimiento con las medidas de seguridad;

(f) que, si la transferencia involucra categorías especiales de datos, se ha informado o se informará previamente al titular de los datos, o se hará tan pronto como sea posible posteriormente, sobre que la transferencia de sus datos puede realizarse a un país tercero que no proporciona protección adecuada dentro de las estipulaciones de la Regulación General para la Protección de los Datos (EU 2016/679);

(g) reenviar cualquier notificación que se recibe de un importador de datos o de cualquier subprocesador de acuerdo con la Cláusula 5(b) y la Cláusula 8(3) a la autoridad supervisora de protección de datos si el exportador de los datos decide continuar con la transferencia o levantar la suspeción;

(h) poner a disposición una copia de las Cláusulas para los titulares de los datos por solicitud, con la exepción del Apéndice 2, y un resúmen descriptivo de las medidas de seguridad, así como una copia de cualquier contrato para los servicios de subprocesamiento que se tiene que hacer de acuerdo con las Cláusulas, a menos de que las Cláusulas o el contrato contengan información comercial, en cuyo caso se podrá eliminar dicha información comercial;

(i) que, en caso de subprocesamiento, la actividad de procesamiento se llevará a cabo de acuerdo con la Cláusula 11 mediante un subprocesador que proporcione por lo menos el mismo nivel de protección para los datos personales y para los derechos del titual de los datos como importador de los mismos bajo las Cláusulas; y

(j) que garantizará el cumplimiento con la Cláusula 4(a) a la (j).

#### Cláusula 5: Obligaciones del importador de los datos
El importador de los datos acuerda y garantiza:

(a) procesar los datos personales únicamente en nombre del exportador de los datos y en cumplimiento con sus instrucciones y con las Cláusulas; si no puede proporcionar dicho cumplimiento por cualquier razón, acuerda informar de manera oportuna al exportador de los datos de dicha incapacidad, en cuyo caso, el exportador de los datos tendrá derecho a suspender al trasnferencia de los mismos o de terminar el contrato;

(b) que no hay razón para creer que la legislación aplicable a ello les previene de completar las instrucciones recibidas del exportador de datos y sus obligaciones contractuales y que en caso de un cambio a dicha legislación, el cual probablemente tenga un efecto adverso sobre las garantías y obligaciones que proporcionan las Cláusulas, se notificará oportunamente sobre el cambio al exportador de los datos tan pronto sea de su conocimiento, en cuyo caso, el exportador de los datos tendrá derecho para suspender la transferencia de los mismos y/o de terminar el contrato;

(c) que ha implementado las medidas de seguridad técnicas y organizacionales especificadas en el Apéndice 2 antes de procesar los datos personales transferidos;

(d) que notificará oportunamente al exportador de los datos sobre:

(i) cualquier solicitud legalmente vinculante para la divulgación de los datos personales mediante una autoridad legal a menos de que se prohiba de otro modo, tal como una prohibición bajo leyes judiciales para preservar la confidencialidad de una investigación legal,

(ii) cualquier acceso accidental o no autorizado, y

(iii) cualquier solicitud recibida directamente de los titulares de los datos sin responder a dicha solicitud, a menos de que se haya autorizado de otra forma;

(e) lidiar oportuna y adecuadamente con todas las investigaciones de exportador de datos que se relacionen con su procesamiento de los datos personales sujetos a transferencia y cumplir con los consejos de la autoridad supervisante con respecto al procesamiento de los datos transferidos;

(f) bajo solicitud del exportador de los datos, emitir sus medios de procesamiento de datos para su auditoría de actividades de procesamiento que se cubren en las cláusulas, lo cual se deberá llevar a cabo por medio del exportador de los datos o mediante un cuerpo de inspección compuesto de miembros independientes y en posesión de las certificaciones profesionales requeridas y ligadas por deber o confidencialidad, seleccionadas por el exportador de los datos, cuando sea aplicable, de acuerdo con la autoridad supervisora;

(g) poner a disposición para el titular de los datos bajo solicitud una copia de las Cláusulas, o de cualquier contrato existente para el subprocesamiento, a menos de que dichas Cláusulas o contrato contengan información compercial, en cuyo caso pudiera eliminar dicha información comercial, con excepción del Apéndice 2, el cual se deberá reemplazar con un resumen descriptivo de las medidas de seguridad en esos casos donde el titular de los datos no puede obtener una copia del exportador de los datos;

(h) que, en caso de subprocesamiento, se ha informado previamente al exportador de los datos y se ha obtenido una aprobación previa por escrito;

(i) que los servicios de procesamiento del subprocesador se llevarán acabo de acuerdo con la Cláusula 11; y

(j) enviar al exportador de los datos oportunamente una copia de cualquier contrato de subprocesamiento que se concluya bajo las Cláusulas.

#### Cláusula 6: Responsabilidades
1. Las partes concuerdan que cualquier titular de los datos que haya sufrido daños como resultado de cualquier violación a las obligaciones descritas en la Cláusula 3 o en la Cláusula 11 por parte de cualquier subprocesador tiene derecho a recibir una compensación del exportador de los datos por dicho daño sufrido.

2. Si algún titular de los datos no puede presentr un reclamo de indemnización en contra del exportador de los datos de acuerdo con el párrafo 1, la cual se derive de una violación por parte del importador de los datos o de su subprocesador o de cualquiera de sus obligaciones que se describen en la Cláusula 3 o en la Cláusula 11, debido a que el exportador de los datos ha desaparecido realmente o dejado de existir ante la ley, o se ha declarado insolvente, el importador de los datos acuerda que el titular de los datos puede emitir un reclamo contra el importador de los datos como si fuera el exportador de los mismos, a menos de que alguna entidad sucesora haya asumido las obligaciones legales íntegras del exportador de los datos contractualmente o mediante la aplicación de la ley, en cuyo caso, el sujeto de los datos puede hacer valer sus derechos contra dicha entidad. El importador de los datos podría no depender de que exista una violación por parte de un subprocesador de sus obligaciones para evitar las suyas propias.

3. Si un titular de los datos no puede presentar un reclamo en contra del exportador o importador de los datos a los cuales se hace referencia en los párrafos 1 y 2, derivado de una violación por parte del subprocesador o por cualquiera de sus obligaciones explicadas en la Cláusula 2 o en la Cláusula 11 ya que ambos, importador y exportador, hayan desaparecido realmente o dejado de existir ante la ley, o se hayan declarado insolventes, el subprocesador acuerda que el titular de los datos podrá emitir un reclamo contra el subprocesador de los datos con respecto a sus propias operaciones de procesamiento bajo las Cláusulas como si fuera el exportador o importador de los mismos, a menos de que cualquier entidad sucesora haya asumido las obligaciones íntegras del exportador o importador de los datos contractualmente o por aplicación de la ley, en cuyo caso, el titular de los datos puede hacer valer sus derechos en contra de dicha entidad. La responsabilidad del subprocesador deberá limitarse a sus propias operaciones de procesamiento bajo las Cláusulas.

#### Cláusula 7: Mediación y Jurisdicción
1. El iimportador de los datos acuerda que si el titular de los datos apelase en contra de sus derechos de beneficiario tercero y/o reclama una compensación por daños bajo las Cláusulas, el importador de los datos aceptará la decisión del titular de los datos:

(a) para referir la disputa de mediación, mediante una persona independiente o, cuando sea aplicable, mediante la autoridad supervisora;

(b) referir la disputa en las cortes del Estado Miembro en el cual se establece el exportador de los datos.

2. Las partes acuerdan que la elección que haga el titular de los datos no perjudicará sus derechos sustantivos o procesales para buscar remedios de acuerdo con otras disposiciones de la ley internacional o nacional.

#### Cláusula 8: Cooperación con las autoridades supervisantes
1. El exportador de los datos acuerda depositar una copia de este contrato con la autoridad supervisora si así lo requiere o si dicho depósito se requiere bajo la ley de protección de datos aplicable.

2. Las partes concuerdan que la autoridad supervisora tiene el derecho de conducir una auditoría del importador de los datos, y de cualquier subprocesador, la cual tiene el mismo alcance y está sujeta a las mismas condiciones que aplcarían en una auditoría del exportador de los datos bajo la ley de protección de datos aplicable.

3. El importador de los datos deberá informar de manera oportuna al exportador de los datos acerca de la existencia de la legislación aplicable a éste o a cualquier subprocesador, previniendo la conducción de una auditoría al importador de los datos o a cualquier subprocesador de acuerdo con el párrafo 2. En dado caso, el exportador de los datos tenga derecho a tomar las medidas previstas en la Cláusula 5(b).

#### Cláusula 9: Ley Aplicable.
Las Cláusulas deberán regirse por medio de la ley del Estado Miembro en el cual se establece el exportador de los datos.

#### Cláusula 10: Variación del contrato
Las partes se comprometen a no variar o modificar las Cláusulas. Esto no impide que las partes agreguen cláusulas sobre los asuntos relacionados con los negocios conforme se requieran mientras que éstas no contradigan la Cláusula.

#### Cláusula 11: Subprocesamiento
1. El importador de los datos no deberá subcontratar ninguna de sus operaciones de procesamiento que se realicen en nombre del exportador de los datos bajo las Cláusulas sin el consentimiento previo y por escrito del exportador de los datos. En caso de que el importador de los datos subcontrate sus obligaciones debajo de las Cláusulas, con el consentimiento del exportador de los datos, deberá hacerlo únicamente por medio de un contrato por escrito con el subprocesador, el cual imponga las mismas obligaciones en el subprocesador que se impusieron en el importador de los datos bajo las Cláusulas. Donde sea que el subprocesador incumpla con sus obligaciones de protección de datos bajo dicho contrato por escrito, el importador de los datos deberá ser plenamente responsable del exportador de los datos por el cumplimiento de las obligaciones del subprocesador bajo dicho contrato.

2. El contrato escrito previo entre el importador de los datos y el subprocesador también deberá proporcionar una cláusula de terceros beneficiarios de acuerdo con lo asentado en la Cláusula 3 para los casos en donde el titular de los datos no pueda preentar una reclamación de compensación como se refiere en el párrafo 1 de la Cláusula 6 en contra del exportador o del importador de los datos debido a que han desaparecido realmente o han dejado de existir ante la ley o se hayan declarado insolventes y ninguna entidad sucesora haya asumido las obligaciones legales íntegras del exportador o importador de los datos contractualmente o mediante la ley aplicable. Dicha responsabilidad de terceros del subprocesador se limitará a sus propias operaciones de procesamiento bajo las Cláusulas.

3. Las disposiciones que se relacionan con los aspectos de protección de datos para el subprocesamiento del cntracto al cual se refiere en el párrafo 1 deberán regirse por la ley del Estado Miembro en el cual se establezca el exportador de los datos.

4. El exportador de los datos deberá mantener una lista de contratos de subprocesamiento que se celebren bajo las Cláusulas y que el importador de los datos notifique de acuerdo con la Cláusula 5 (j), la cual se debe actualizar por lo menos una vez al año. La lista deberá estar disponible para la autoridad supervisora de protección de datos del exportador de los datos.

#### Cláusula 12: Obligaciones después de la terminación de los servicios de procesamiento de datos personales
1. Las partes acuerdan que, en la terminación de la prestación de los servicios de procesamiento de datos, el importador y subprocesador de los mismos deberá, a elección del exportador, regresar todos los datos personales transferidos y las copias de los mismos al exportador de los datos o deberá destruir todos los dtos personales y certificar ante el exportador de los datos que así lo ha hecho, a menos de que la legislación impuesta en el importador de los datos impida que regrese o destrulla todos o parte de los datos personales transferidos. En dado caso, el importador de los datos justifica que garantizará la confidencialidad de los datos personales transferidos y que ya no procesará activamente dichos datos personales.

2. El importador de los datos y el subprocesador garantizan que, bajo solicitud del exportador de los datos y/o de la autoridad supervisora, emitirán sus instalaciones de procesamiento de datos para auditoría de las medidas descritas en el párrafo 1.

### Apéndice 1 para las Cláusulas Contractuales Estándar
Exportador de los datos: El cliente es el exportador de los datos.

**Importador de los datos:** El importador de los datos es GitHub, Inc., un productor global de software y servicios.

**Titulares de los datos:** Los titulares de los datos incluyen a los representantes de los exportadores de datos y a los usuarios finales, incluyendo a los empleados, consultores, colaboradores, y clientes del exportador de los datos. Los titulares de los datos también podrían incluir a aquellos individuos que intentan comunicarse o transferir información personal a los usuarios de los servicios proporcionados por el importador de los datos. GitHub reconoce que, dependiendo de el uso del Servicio que tenga el Cliente, éste puede elegir el incluir los datos personales de cualquiera de los siguientes tipos de titulares de datos en los Datos Personales del Cliente:

-   Empleados, consultores y trabajadores temporales (actuales, previos o futuros) del exportador de los datos;
-   Dependientes de los antes listados;
-   Consultores/personas de contacto del exportador de datos (personas naturales) o los empleados, consultores o trabajadores temporales de la entidad legal de las personas de contacto/consultores (actuales, futuros, pasados);
-   Usuarios (por ejemplo, clientes, pacientes, visitantes, etc.) y otros titulares de los datos que sean usuarios de los servicios del exportador de los datos;
-   Socios, interesados o individuos que colaboren, se comuniquen o interactuen activamente de otra forma con los empleados del exportador de los datos y/o que utilicen herramientas de comunicación tales como apps y sitios web que proporcione el exportador de los datos;
-   Los interesados o los individuos que interactuen pasivamente con el exportador de los datos (por ejemplo, porque son el titular de una inspección, investigación o que se mencionan en documentos o en correspondencia dirigida a o proviniente del exportador de los datos); o
-   Profesionales con privilegios de profesionista (por ejemplo, doctores, abogados, notarios, trabajadores religiosos, etc.).

**Categorías de los datos:** Los datos personales transferidos que se incluyen en los correos electrónicos, documentos y en otros tipos de datos en forma electrónica o en el contexto del Servicio.  GitHub reconoce que, dependiendo del uso que el Cliente de al Servicio, éste puede elegir incluir datos personales de cualquiera de las siguientes categorías dentro de los Datos Personales del Cliente:
-   Datos de autenticación (por ejemplo, nombre de usuario, correo electrónico, contraseña);
-   Información de contacto (por ejemplo, correo electrónico);
-   Números de identificación única y firmas (direcciones IP, identificadores únicos en cookies de rastreo o tecnologías similares).
-   Otra información de identificación única. Los titulares de los datos podrían incluir más datos tales como nombres reales, imágenes de avatar, y otra información personal;

**Categorías especiales de los datos (si corresponde):** El importador de los datos no recolecta procesa intencionalmente ninguna categoría especial de datos para llevar a cabo sus servicios para el exportador de los mismos.

Sin embargo, ya que el importador de los dtos proporciona servicios de almacenamiento y no controla las categorías de los datos que almacena, el exportador de los datos podría elegir transferir las categorías especiales de los datos. Por consiguiente, el exportador de los datos es el único responsable de garantizar que cumple con todas las obligaciones impuestas por las leyes y regulaciones aplicables relacionadas con la recolección y procesamiento de cualquier categoría de datos, incluyendo el obtener el consentimiento explícito del titular de los datos antes de procesar datos personales sensibles.

**Operaciones de procesamiento:** Los datos personales transferidos estarán sujetos a las actividades de procesamiento básico siguientes: GitHub utiliza los datos pesonales para los propósitos limitados que se establecen en la Declaración de Privacidad de GitHub, disponible en [https://docs.github.com/articles/github-privacy-statement](/articles/github-privacy-statement), y en la sección de "Procesamiento de Datos" de la DPA. Subcontratistas: De acuerdo con la DPA, el importador de los datos podrá contratar a otras compañías para proporcionar servicios limitados en nombre del importador de los datos, tales como proporcionar soporte al cliente. Cualquier subcontratista de este tipo tendrá permiso de obtener los Datos Personales del Cliente únicamente para entregar los servicios para los cuales lo contrató el importador de los mismos, y se les prohibe utilizar los Datos Personales del Cliente para cualquier otro propósito.

### Apéndice 2 para las Cláusulas Contractuales Estándar
Descripción de las medidas de seguridad técnicas y organizacionales implementadas por el importador de los datos de acuerdo con las Cláusulas 4(d) y 5(c):

**1. Personal.** El personal del importador de los datos no procesará los Datos Personales del Cliente sin autorización. El personal está obligado a mantener la confidencialidad de cualquier Dato Personal del Cliente y esta obligación continúa aún después de que la relación termine.

**2. Contacto de Privacidad de los Datos.** El director de privacidad para el importador de los datos puede contactarse en la siguiente dirección: GitHub, Inc. Atención: Privacidad 88 Colin P. Kelly Jr. Street San Francisco, CA 94107 USA

**3. Medidas Técnicas y Organizacionales.** El importador de los datos ha implementado y mantendrá las medidas técnicas y organizacionales adecuadas, controles internos y rutinas de seguridad informática que pretenden proteger los Datos Personales del Cliente de acuerdo como se definen en las Pruebas de Seguridad de GitHub, contra la pérdida accidental, destrucción o alteración; divulgación no autorizada o acceso; o destrucción ilegal de acuerdo a lo siguiente: Las medidas organizacionales y técnicas, controles internos, y rutinas de seguridad informática establecidas en las Pruebas de Seguridad de Github se incorporan en la presente a este Apéndice 2 mediante esta referencia y se vinculan con el importador de los datos como si se establecieran en este Apéndice 2 íntegramente. La Firma de GitHub, Inc. se muestra a continuación.

Se firman las Cláusulas Contractuales Estándar, Apéndice 1 y Apéndice 2 en nombre del importador de los datos

![Impresión de pantalla 2020-07-20 a las 2 20 29 PM](/assets/images/help/site-policy/docusign-signature.png)

Lynn Hashimoto, Jefe de Producto & Regulación Legal

GitHub, Inc.


## PRUEBA DE SEGURIDAD

### 1. Programa de seguridad de la información.

#### 1.1 Administración de la seguridad.

Durante la vigencia del Acuerdo, GitHub mantendrá y hará valer un programa de seguridad informática por escrito (**"Programa de Seguridad"**) que se alínea con los marcos de trabajo reconocidos por la industria; incluye salvaguardas de seguridad razonables diseñadas para proteger la confidencialidad, integridad, disponibilidad y resiliencia de los Datos Protegidos del Cliente; es adecuada para la naturaleza, tamaño y complegidad de las operaciones de negocio de GitHub; y cumple con las Leyes de Protección de Datos Aplicables y otras leyes y regulaciones de seguridad informática específicas que aplican en las regiones geográficas en donde GitHub conduce sus negocios.

a. Oficial de seguridad. GitHub ha designado a un empleado de rango superior para que sea responsable de supervisar y llevar a cabo su Programa de seguridad y para la gobernanza y las comunicaciones internas sobre los temas de seguridad de la información.

b. Cambios en el Programa de seguridad. GitHub no hará cambios en su Programa de seguridad que afecten negativamente la seguridad de cualquier Dato protegido del Cliente sobre los que se exija notificación según lo dispuesto en las reglamentaciones y leyes aplicables.

c. GitHub mantendrá las prácticas de seguridad estándar del sector que incluyen, entre otras, las siguientes:

- Programa de Administración de vulnerabilidades
- Capacitación para el Desarrollo seguro, Prácticas de revisión y codificación
- Controles de acceso lógicos y físicos a los Sistemas de producción
- Evaluaciones y auditorías técnicas externas
- Políticas de seguridad, estándares y procedimientos de operaciones estándar
- Capacitación para la concientización sobre la seguridad y la privacidad


#### 1.2 Administración de Incidentes de Seguridad.
Durante la vigencia del Acuerdo y donde sea aplicable, GitHub proporcionará un programa de administración de incidentes de acuerdo a lo siguiente:

a. Disponibilidad de seguridad e intensificación. GitHub mantendrá el contacto de seguridad adecuado y los procesos de intensificación las 24 horas del día, los 7 días de la semana, para asegurar que los clientes y los empleados puedan enviar propuestas al equipo de Seguridad de GitHub.

b. Respuesta ante incidentes. Si GitHub supiese de cualquier violación de seguridad que conlleve a la destrucción ilegal o accidental, pérdida, alteración, divulgación o acceso no autorizado a los Datos Personales del Cliente (cada uno de éstos considerado un **"Incidente de Seguridad"**), GitHub, oportunamente y sin retraso alguno (1) notificará al cliente del Incidente de Seguridad; (2) investigará el Incidente de Seguridad y proporcionará al cliente con la información detallada sobre dicho Incidente de Seguridad; (3) tomará los pasos razonables para mitigar los efectos y para minimizar cualquier daño que resulte del Incidente de Seguridad.

c. Notificación. La(s) Notificación(es) de los Incidentes de seguridad se entregarán a uno o más administradores del Cliente por el medio que GitHub seleccione. Es responsabilidad únicamente del Cliente asegurar que los administradores del Cliente supervisen y respondan cualquier notificación. El Cliente es el único responsable de cumplir con sus obligaciones según las leyes de notificación de incidentes aplicables al Cliente y de cumplir con las obligaciones de notificación de terceros relacionadas con cualquier Incidente de seguridad.

d. Asistencia razonable. GitHub hará los esfuerzos comercialmente razonables para ayudar al Cliente a cumplir con su obligación del Cliente, según las regulaciones o leyes aplicables, de notificar a la autoridad correspondiente y a los sujetos de datos sobre dicho Incidente de seguridad.

#### 1.3 Cuidado Adecuado sobre los Subcontratistas y Proveedores.
GitHub mantendrá un cuidado adecuado cuando utilice subcontratistas y proveedores. GitHub conservará los informes de evaluación del proveedor y cualquier trabajo de evaluación por un mínimo de tres años.

#### 1.4 Salvaguardas Físicas en el Centro de Datos.
En medida que GitHub utilice proveedores terceros para hospedar ambientes productivos, GitHub seleccionará aquellos que cumplan con los controles de seguridad física descritos en los estándares de la industria y que emitan un reporte de auditoría externa anual tal como una certificación de SOC 2 o de ISO 27001. Todos los accesos a las áreas, gabinetes o estantes que alojan telecomunicaciones, dispositivos de red y otras "líneas de transmisión de datos" o equipos se controlarán como se indica a continuación:

a. el acceso se controlará con lectores de insignia en uno o más puntos de entrada;

b. las puertas que solo se usan como puntos de salida tendrán picaportes de un solo lado o dispositivos con barra antipánico en la salida;

c. todas las puertas se equiparán con contactos de alarmas;

d. todas las puertas de salida tendrán capacidad de videovigilancia;

e. todos los accesos con tarjeta y sistemas de vídeo estarán vinculados a un generador o a un sistema de respaldo UPS.

### 2. Solicitudes de información e informes del cumplimiento.

#### 2.1 Solicitudes de Información.
En caso de que exista una solicitud por escrito y no más de una vez por año, GitHub responderá a las solicitudes de información para valorar la información del cumplimiento y seguridad reñacionada con los riesgos. La respuesta se entregará por escrito dentro de los treinta días de recibida la solicitud, a la espera de aclaraciones necesarias de cualquier solicitud.

#### 2.2 Contenidos de la Respuesta.
GitHub incluirá en su respuesta anual los reportes de auditoría relevantes para los centros de datos productivos, IaaS, Paas, o proveedores de hospedaje privado, así como GitHub determine relevante, bajo su criterio exclusivo, y basándose en los servicios y datos proporcionados.

#### 2.3 Reporte de Auditoría de Seguridad de GitHub.
GitHub ejecutará auditorías externas para producir un reporte de auditoría de SOC1, tipo 2, y de SOC2, tipo2. GitHub continuará ejecutando auditorías y emitiendo los informes correspondientes durante la vigencia del Acuerdo al menos anualmente.

### 3. Cooperación con las auditorías reglamentarias.
En caso de que el cliente lleve a cabo una auditoría regulatoria o una auditoría en respuesta a una Autoridad Supervisora la cual requiera la participación de GitHub, GitHub cooperará íntegramente con las solicitudes relacionadas al proporcionar acceso al personal experto, documentación y software de aplicación relevantes. El Cliente tiene las siguientes responsabilidades sobre cualquiera de dichas auditorías de Autoridad de supervisión o reglamentarias:

a. El Cliente debe asegurar el uso de un tercero independiente (es decir, el regulador o el delegado del regulador) y que los resultados y los datos no relevantes para el Cliente quedarán restringidos para el acceso del Cliente.

b. La notificación de dicha auditoría deber ser por escrito y se debe entregar a GitHub en su debido momento, a la espera de la notificación del regulador, y de una forma que permita que el personal adecuado esté disponible para ayudar. Cuando los reguladores no proporcionen notificación por anticipado al Cliente acerca de la auditoría o la investigación, GitHub responderá en su debido momento según lo exijan los reguladores.

c. Cualquier auditor externo debe divulgarle a GitHub los resultados y las acciones recomendadas cuando el regulador lo permita.

d. En el caso de que haya una auditoría reglamentaria, se permitirá el acceso solo durante las horas de trabajo habituales, hora del Pacífico.

e. En la medida que lo permita la ley, el Cliente debe mantener confidencial cualquier información reunida mediante este tipo de auditorías de GitHubb que, por su naturaleza, debe ser confidencial.
