---
title: Pautas de la comunidad GitHub
redirect_from:
  - /community-guidelines/
  - /articles/github-community-guidelines
versions:
  free-pro-team: '*'
---

Millones de desarrolladores albergan millones de proyectos en GitHub — tanto de código abierto como de código cerrado — y tenemos el honor de participar en la colaboración de toda la comunidad todos los días. Juntos tenemos una emocionante oportunidad y responsabilidad de hacer de esta una comunidad de la que podemos estar orgullosos.

Los usuarios de GitHub en todo el mundo ofrecen perspectivas, ideas y experiencias diferentes y van desde personas que crearon su primer proyecto "Hola Mundo" la semana pasada hasta los desarrolladores de software más conocidos del mundo. Estamos comprometidos a hacer de GitHub un ambiente acogedor para todas las diferentes voces y perspectivas de nuestra comunidad, manteniendo un espacio donde la gente sea libre de expresarse.

Dependemos de nuestros miembros de la comunidad para que comuniquen las expectativas, [moderen](#what-if-something-or-someone-offends-you) sus proyectos, y {% data variables.contact.report_abuse %} o {% data variables.contact.report_content %}. No buscamos activamente contenido para moderar. Al describir lo que esperamos ver dentro de nuestra comunidad, esperamos ayudarte a entender cómo colaborar de mejor forma en GitHub y qué tipo de acciones o contenido pueden violar nuestros [Términos de Servicio](#legal-notices). Investigaremos cualquier reporte de abuso y podremos moderar el contenido público en nuestro sitio que determinemos que infringe nuestros Términos de Servicio.

### Construir una comunidad sólida

El propósito principal de la comunidad de GitHub es colaborar en proyectos de software. Deseamos que la gente trabaje mejor juntos. Aunque mantenemos el sitio, esta es una comunidad que construimos *juntos* y necesitamos tu ayuda para que sea lo mejor.

* **Se cordial y de mentalidad abierta** - Otros colaboradores pueden no tener el mismo nivel de experiencia o antecedentes que tú, pero eso no significa que no tengan buenas ideas para aportar. Te invitamos a dar la bienvenida a los nuevos miembros y a los que están empezando a trabajar.

* **Respeto unos a otros.** Nada sabotea una conversación saludable como la rudeza. Se cortés y profesional y no publiques nada que una persona razonable consideraría ofensivo, abusivo o un discurso de odio. No acoses ni molestes a nadie. Trato mutuo con dignidad y consideración en todas las interacciones.

  Es probable que desees responder a algo discrepándolo. Está bien. Pero recuerda criticar las ideas, no a las personas. Evita ataques usando el nombre, ad hominem, respondiendo al tono de un post en lugar de su contenido real y contradicción reactiva. En lugar de ello, proporciona contra-argumentos razonados que mejoran la conversación.

* **Comunícate con empatía.** Los desacuerdos o diferencias de opinión son un hecho de la vida. Formar parte de una comunidad significa interactuar con personas de diferentes orígenes y perspectivas, muchas de las cuales pueden no ser propias. Si no estás de acuerdo con alguien, trata de entender y compartir sus sentimientos antes de abordarlos. Esto promoverá un ambiente respetuoso y amistoso donde la gente se sienta cómoda haciendo preguntas, participando en discusiones y haciendo contribuciones.

* **Se claro y permanece en el tema** -Las personas usan GitHub para hacer el trabajo y ser más productivos. Los comentarios fuera del tema son una distracción (en ocasiones bien recibido, pero generalmente no) sobre realizar el trabajo y ser productivo. Mantener el tema ayuda a producir discusiones positivas y productivas.

   Además, comunicarse con extraños en Internet puede ser incómodo. Es difícil transmitir o leer el tono y el sarcasmo es frecuentemente mal entendido. Intenta usar un lenguaje claro y piensa cómo será recibido por la otra persona.

### ¿Qué pasa si algo o alguien te ofende?

Confiamos en que la comunidad nos comunique cuándo sea necesario abordar una cuestión. No monitoreamos activamente el sitio por contenido ofensivo. Si encuentras algo o alguien en el sitio que sea censurable, aquí hay algunas herramientas que proporciona GitHub para ayudarte a tomar acción inmediatamente:

* **Comunica las expectativas** - Si participas en una comunidad que no haya establecido sus propias pautas específicas de la comunidad, invítalos a realizarlo en el archivo README o [CONTRIBUTING](/articles/setting-guidelines-for-repository-contributors/), o en [un código de conducta dedicado](/articles/adding-a-code-of-conduct-to-your-project/), enviando una solicitud de extracción.

* **Modera comentarios** - Si tienes [privilegios de acceso de escritura](/articles/repository-permission-levels-for-an-organization/) para un repositorio, puedes editar, eliminar u ocultar los comentarios de cualquier persona sobre confirmaciones, solicitudes de extracción y propuestas. Cualquier persona con acceso de lectura a un repositorio puede ver el historial de edición del comentario. Los autores del comentario y las personas con acceso de escritura a un repositorio pueden eliminar información confidencial del historial de edición de un comentario. Para obtener más información, consulta "[Seguimiento de cambios en un comentario](/articles/tracking-changes-in-a-comment)" y "[Gestión de comentarios perturbadores](/articles/managing-disruptive-comments)."

* **Bloquea Conversaciones**- Si una discusión en una propuesta o solicitud de extracción sale de control, puedes [bloquear la conversación](/articles/locking-conversations/).

* **Bloquea usuarios** - Si encuentras a un usuario que continúa presentando un mal comportamiento, puedes [bloquear al usuario desde su cuenta personal](/articles/blocking-a-user-from-your-personal-account/) o [bloquear al usuario desde su organización](/articles/blocking-a-user-from-your-organization/).

Claro que siempre podrás contactarnos en {% data variables.contact.report_abuse %} si necesitas más ayuda con alguna situación.

### ¿Qué no está permitido?

Estamos comprometidos a mantener una comunidad donde los usuarios sean libres de expresarse y desafiar las ideas de los demás, tanto técnicas como de otro tipo. Sin embargo, es poco probable que dichos debates fomenten un diálogo fructífero cuando se silencian las ideas porque los miembros de la comunidad están siendo bloqueados o tienen miedo de hablar. Esto significa que deberías ser respetuoso y civil en todo momento y que deberías esforzarse por no atacar a los demás considerando quiénes son. No toleramos un comportamiento que cruce la línea de lo siguiente:

* **Amenaza de violencia** - No puedes amenazar con violencia a otros ni usar el sitio para organizar, promover o incitar a actos de violencia o terrorismo en el mundo real. Piensa detenidamente en las palabras que usas, las imágenes que publicas e incluso el software que escribas y cómo lo pueden interpretar otros. Incluso si dices algo como una broma, es posible que no se reciba de esa forma. Si crees que alguien más *podría* interpretar el contenido que publicas como una amenaza o como una promoción de la violencia o el terrorismo, detente. No lo publiques en GitHub. En casos extraordinarios podemos denunciar amenazas de violencia a la aplicación de la ley si creemos que puede haber un verdadero riesgo de daños físicos o una amenaza para la seguridad pública.

* **Discurso de odio y discriminación** - Aunque no está prohibido abordar temas como la edad, complexión corporal, discapacidad, etnicidad, identidad de género y expresión, nivel de experiencia, nacionalidad, apariencia personal, raza, religión e identidad y orientación sexual, no toleramos el discurso que ataque a una persona o grupo de personas en función de quiénes son. Sólo date cuenta de que cuando se trata de una forma agresiva o insultante, estos (y otros) temas delicados pueden hacer que otros se sientan no deseados o incluso inseguros. Aunque siempre existe la posibilidad de malentendidos, esperamos que los miembros de nuestra comunidad continúen siendo respetuosos y corteses cuando discutan temas delicados.

* **Intimidación y acoso** - No toleramos acoso ni intimidación. Esto significa cualquier acoso o intimidación habitual dirigida a una persona o grupo específico de personas. En general, si tus acciones son indeseables y continúas participando en ellas, hay una buena posibilidad de que te dirijas a territorio de intimidación o acoso.

* **Suplantación** - No puedes intentar confundir a otros en cuanto a tu identidad copiando el avatar de otra persona, publicando contenido bajo su dirección de correo electrónico, usando un nombre de usuario similar o presentándote de otra manera como alguien más. La suplantación es una forma de acoso.

* **Doxing e invasión de privacidad** - No publique información personal de otras personas, como números de teléfono, direcciones de correo electrónico privadas, direcciones físicas, números de tarjetas de crédito, números de seguridad social o de identificación nacional o contraseñas. Dependiendo del contexto, como en el caso de intimidación o acoso, podemos considerar otra información, tales como fotos o vídeos que fueron tomados o distribuidos sin el consentimiento de la persona, una invasión de la privacidad, especialmente cuando dicho material representa un riesgo para la seguridad del sujeto.

* **Contenido sexualmente obsceno** - No publiques contenido pornográfico. Esto no significa que toda la desnudez o todo el código y contenido relacionados con la sexualidad, esté prohibido. Reconocemos que la sexualidad es parte de la vida y que el contenido sexual no pornográfico puede ser parte de su proyecto o puede presentarse con fines educativos o artísticos. No permitimos contenidos sexuales obscenos que puedan implicar la explotación o la sexualización de menores.

* **Contenido violento injustificadamente** - No publique imágenes, texto u otro contenido sin un contexto o advertencias razonables. Aunque a menudo es correcto incluir contenido violento en videojuegos, reportes de noticias y descripciones de acontecimientos históricos, no permitimos contenido violento que se publique de forma indiscriminada o que se publique de una manera que dificulte a otros usuarios evitarlo (por ejemplo, un avatar de perfil o un comentario sobre una propuesta). Una clara advertencia o renuncia de responsabilidad en otros contextos ayuda a los usuarios a tomar una decisión educada sobre si quieren participar en dichos contenidos o no.

* **Información errónea y desinformación** - No puedes publicar contenido que presente una visión distorsionada de la realidad, es probable que sea inexacta o falsa (información errónea) o que sea intencionalmente engañosa (desinformación) porque dicho contenido probablemente resultará en daño al público o para interferir con oportunidades justas y equitativas para que todos participen en la vida pública. Por ejemplo, no permitimos contenido que pueda poner el bienestar de grupos de personas en riesgo o limitar su capacidad de participar en una sociedad libre y abierta. Fomentamos la participación activa en la expresión de ideas, perspectivas y experiencias y podríamos no estar en posición de disputar cuentas personales u observaciones. Por lo general, permitimos la parodia y la sátira que está en línea con nuestras políticas de uso aceptable y consideramos que el contexto es importante en la manera en que se recibe y se entiende la información; por lo tanto, puede ser adecuado aclarar tus intenciones mediante renuncias u otros medios, así como la fuente(s) de tu información.

* **Malware activo o explotación de vulnerabilidad** - Ser parte de una comunidad incluye no aprovecharse de otros miembros de la comunidad. No permitimos que nadie utilice nuestra plataforma para la entrega de explotación de vulnerabilidad, por ejemplo usar GitHub como un medio para entregar ejecutables maliciosos, o como infraestructura de ataques, por ejemplo organizando ataques de denegación de servicio o gestionando servidores de comando y control. Sin embargo, ten en cuenta, que no prohibimos la publicación de código fuente que podría utilizarse para desarrollar malware o explotación de vulnerabilidad, ya que la publicación y distribución de dicho código fuente tiene un valor educativo y proporciona un beneficio neto a la comunidad de seguridad.


### ¿Qué sucede si alguien no comple con las reglas?

Hay una serie de acciones que podemos tomar cuando un usuario reporta un comportamiento o contenido inadecuado. Por lo general, depende de las circunstancias exactas de un caso en particular. Reconocemos que en ocasiones la gente puede decir o hacer cosas inadecuadas por diversas razones. Tal vez no se dieron cuenta de cómo se percibirían sus palabras. O tal vez sólo dejan que sus emociones saquen lo mejor de ellos. Por supuesto, en ocasiones, hay gente que sólo quiere hacer spam o causar problemas.

Cada caso requiere un enfoque diferente e intentamos adaptar nuestra respuesta para satisfacer las necesidades de la situación que se ha informado. Revisaremos cada informe de abuso caso por caso. En cada caso, tendremos un equipo diverso que investigue el contenido y los hechos relacionados y responda según corresponda, utilizando estas directrices para guiar nuestra decisión.

Las acciones que podemos emprender en respuesta a un informe de abuso incluyen, pero no se limitan a:

* Eliminación de contenido
* Bloqueo de contenido
* Suspensión de la cuenta
* Terminación de la cuenta

### Avisos legales

Dedicamos estas Pautas de la Comunidad al dominio público para que cualquiera pueda usar, reutilizar, adaptar o lo que sea, bajo los términos de [CC0-1.0](https://creativecommons.org/publicdomain/zero/1.0/).

Estas son solo directrices; no modifican nuestros [Términos de Servicio](/articles/github-terms-of-service/) y no pretenden ser una lista completa. GitHub mantiene total discreción bajo los [Términos de Servicio](/articles/github-terms-of-service/#c-acceptable-use) para eliminar cualquier contenido o cancelar cualquier cuenta por actividad que infrinja nuestros Términos del Uso Aceptable. Estas directrices describen en qué situaciones ejerceremos dicha discreción.
