---
title: Código de conducta del foro de la comunidad GitHub
redirect_from:
  - /articles/github-community-forum-code-of-conduct
versions:
  free-pro-team: '*'
---

### Descripción y propósito

Millones de programadores albergan millones de proyectos en GitHub — tanto de código abierto como de código cerrado — y tenemos el honor de participar en permitir la colaboración de toda la comunidad de programadores todos los días. Juntos tenemos una emocionante oportunidad y responsabilidad de hacer de esta una comunidad de la que podemos estar orgullosos.

El Foro de la Comunidad de GitHub está previsto para ser un lugar para más colaboración, apoyo y reunión de reflexión. Este es un lugar civilizado para conectarse con otros usuarios, aprender nuevas habilidades, compartir comentarios e ideas y encontrar todo el apoyo que necesitas para tus proyectos de GitHub. Al participar en esta Comunidad, aceptas los mismos [Términos de Servicio](/articles/github-terms-of-service/) que se aplican a GitHub.com, así como este Código de Conducta específico para la Comunidad.

Con este Código de Conducta esperamos ayudarte a entender cómo colaborar mejor en el Foro de la Comunidad de GitHub, lo que puedes esperar de los moderadores y qué tipo de acciones o contenidos pueden resultar en una suspensión temporal o permanente de la participación en la Comunidad. Investigaremos cualquier reporte de abuso y podremos moderar el contenido público dentro de la Comunidad que determinemos que viola los Términos de Servicio de GitHub o de este Código de Conducta.

Los usuarios de GitHub en todo el mundo ofrecen perspectivas, ideas y experiencias diferentes y van desde personas que crearon su primer proyecto "Hola Mundo" la semana pasada hasta los desarrolladores de software más conocidos del mundo. Estamos comprometidos a hacer de GitHub y el Foro de la Comunidad de GitHub un entorno acogedor para todas las diferentes voces y perspectivas aquí, manteniendo un espacio donde la gente es libre de expresarse.

### Compromiso

En interés de fomentar un entorno abierto y acogedor, como colaboradores y mantenedores nos comprometemos a hacer de la participación en el Foro de la Comunidad de GitHub una experiencia sin acoso para todos, sin importar la edad, complexión, capacidad, etnicidad, identidad y expresión de género, nivel de experiencia, nacionalidad, apariencia personal, raza, religión o identidad y orientación sexual.

### Estándares

Trata el Foro de la Comunidad de GitHub con respeto. Somos un recurso compartido — un lugar para compartir habilidades, conocimientos e intereses a través de una conversación continua.

Lo siguiente no son normas duras y rápidas, sino ayudas al juicio humano de nuestra Comunidad. Utiliza estas pautas para mantener este lugar limpio y bien iluminado para el discurso público civilizado.

#### *Mejores prácticas para construir una comunidad sólida*

- Se respetuoso y considerado.
  - **Se bienvenido y abierto.** Es posible que otros miembros de la comunidad no tengan el mismo nivel de experiencia o antecedentes que tú, pero eso no significa que no tengan buenas ideas para contribuir. Te invitamos a dar la bienvenida a los nuevos miembros y a los que están empezando a trabajar.
  - **Respeto unos a otros.** Nada sabotea una conversación saludable como la rudeza. Se cortés y profesional y no publiques nada que una persona razonable consideraría ofensivo, abusivo o un discurso de odio. No acoses ni molestes a nadie. Trato mutuo con dignidad y consideración en todas las interacciones.

    Es probable que desees responder a algo discrepándolo. Está bien. Pero recuerda criticar las ideas, no a las personas. Evita ataques usando el nombre, ad hominem, respondiendo al tono de un post en lugar de su contenido real y contradicción reactiva. En lugar de ello, proporciona contra-argumentos razonados que mejoran la conversación.
  - **Comunícate con empatía.** Los desacuerdos o diferencias de opinión son un hecho de la vida. Formar parte de una comunidad significa interactuar con personas de diferentes orígenes y perspectivas, muchas de las cuales pueden no ser propias. Si no estás de acuerdo con alguien, trata de entender y compartir sus sentimientos antes de abordarlos. Esto promoverá un ambiente respetuoso y amistoso donde la gente se sienta cómoda haciendo preguntas, participando en discusiones y haciendo contribuciones.
- Contribuye de forma positiva y constructiva.
  - **Mejorar el debate.** Ayúdanos a hacer de esto un gran lugar para el debate trabajando siempre para mejorar la discusión de alguna manera, sin embargo siempre breve. Si no estás seguro de que tu publicación sume a la conversación, piensa en lo que quieres decir e inténtalo de nuevo más tarde.

    Los temas debatidos aquí nos importan y esperamos que actúes como si también te importasen. Se respetuoso con los temas y con las personas que los debaten, aunque no estés de acuerdo con algo de los que se dice.
  - **Se claro y enfócate en el tema.** Comunicarse con extraños en Internet puede ser incómodo. Es difícil transmitir o leer el tono y el sarcasmo es frecuentemente mal entendido. Intenta usar un lenguaje claro y piensa cómo será recibido por la otra persona.

    Esto también se aplica al intercambio de vínculos. Cualquier enlace compartido en el Foro de la Comunidad debe compartirse con la intención de proporcionar información relevante y apropiada. Los enlaces no deben publicarse para simplemente conducir el tráfico o la atención a un sitio. Los enlaces siempre deberán ir acompañados de una explicación completa del contenido y propósito de los mismos. Publicar enlaces, especialmente los no solicitados, sin un contexto relevante y valioso puede parecer publicidad o con fines aún más maliciosos.

    Además, el Foro de la Comunidad de GitHub tiene el objetivo de colaborar, compartir ideas y ayudarse mutuamente a hacer cosas. Los comentarios fuera del tema son una distracción (en ocasiones bien recibido, pero generalmente no) sobre realizar el trabajo y ser productivo. Mantener el tema ayuda a producir discusiones positivas y productivas.
  - **Comparte con precaución.** Al pedir a otros que te den comentarios o colaboren en un proyecto, solo comparte recursos valiosos y relevantes para proporcionar un contexto. No publiques enlaces que no añadan valor al tema y no publiques enlaces no solicitados a tus propios proyectos o sitios en los temas de otros usuarios.

    Además, no compartas información confidencial. Esto incluye tu propia dirección de correo electrónico. No permitimos compartir dicha información en este Foro de la Comunidad, ya que puede crear riesgos de seguridad y privacidad para la persona que publica, así como para otros usuarios. Si quieres invitar a otros miembros del Foro a colaborar en un proyecto o trabajar contigo, comparte un enlace al repositorio en el que existe el proyecto en el que estás trabajando. Al compartir el enlace al repositorio de tu proyecto - con alguna información sobre lo que es tu proyecto y qué tipo de ayuda o retroalimentación estás buscando, puedes invitar a otros a colaborar contigo a través de temas o solicitudes de extracción sin tener que compartir tu información privada. También puedes añadir a otros como colaboradores externos en el repositorio de tu proyecto para darles permisos especiales que te ayuden a desarrollar tu proyecto.
  - **Mantén el orden.** Haz el esfuerzo de colocar las cosas en el lugar correcto, para que podamos pasar más tiempo debatiendo y menos tiempo resolviendo problemas. Así que:
    - No inicies un tema en la categoría equivocada.
    - No publiques lo mismo en múltiples temas.
    - No publiques respuestas sin contenido.
    - No "infles" publicaciones, a menos que tengas información nueva y relevante que compartir.
    - No desvíes un tema cambiándolo a midstream.

    En lugar de publicar “+1” o “De acuerdo”, utiliza el botón Kudos. En lugar de tomar un tema existente en una dirección radicalmente diferente, abre un nuevo tema.

- Se digno de confianza.
  - **Siempre se honesto.** No compartas conscientemente información incorrecta o confundas intencionalmente a otros miembros del foro de la comunidad de GitHub. Si no conoces la respuesta a la pregunta de alguien pero deseas ayudarle, puedes intentar ayudarle a investigar o encontrar recursos en su lugar. El personal de GitHub también estará activo en la Comunidad, así que si no estás seguro de una respuesta, es probable que un moderador pueda ayudar.

#### *Lo que no está permitido*

- **Amenazas de violencia.** No puede amenazar la violencia hacia otros ni utilizar el sitio para organizar, promover o incitar a actos de violencia o terrorismo en el mundo real. Piensa detenidamente en las palabras que usas, las imágenes que publicas e incluso el software que escribas y cómo lo pueden interpretar otros. Incluso si dices algo como una broma, es posible que no se reciba de esa forma. If you think that someone else might interpret the content you post as a threat, or as promoting violence or terrorism, stop. No lo publiques. En casos extraordinarios podemos denunciar amenazas de violencia a la aplicación de la ley si creemos que puede haber un verdadero riesgo de daños físicos o una amenaza para la seguridad pública.

- **Discurso de odio y discriminación.** Aunque no está prohibido abordar temas como edad, complexión, capacidad, etnia, identidad de género y expresión, nivel de experiencia, nacionalidad, apariencia personal, raza, religión u identidad y orientación sexual, no toleramos el discurso que ataque a una persona o grupo de personas en función de quiénes son. Sólo date cuenta de que hablar de estos u otros temas delicados puede hacer que otros se sientan insólitos, o quizás incluso inseguros si se enfoca de forma agresiva o aislante. Esperamos que nuestros miembros de la Comunidad sean respetuosos a la hora de debatir temas delicados.

- **Intimidación y acoso** No toleramos acoso ni intimidación. Esto significa cualquier acoso o intimidación habitual dirigida a una persona o grupo específico de personas. En general, si tus acciones son indeseables y continúas participando en ellas, hay una buena posibilidad de que te dirijas a territorio de intimidación o acoso.

- **Suplantación.** No puedes suplantar a otra persona copiando su avatar, publicando contenido bajo su dirección de correo electrónico, utilizar intencionalmente un nombre de usuario engañosamente similar o de otro modo hacer publicaciones como alguien más. La suplantación es una forma de acoso.

- **Doxing e invasión de privacidad** - No publiques información personal de otras personas, como números de teléfono, direcciones de correo electrónico privadas, direcciones físicas, números de tarjetas de crédito, números de seguridad social o de identificación nacional o contraseñas. Dependiendo del contexto, como en el caso de intimidación o acoso, podemos considerar otra información, tales como fotos o vídeos que fueron tomados o distribuidos sin el consentimiento de la persona, una invasión de la privacidad, especialmente cuando dicho material representa un riesgo para la seguridad del sujeto.

- **Contenido impúdico/sexualmente explícito.** Básicamente, no publique pornografía. Esto no significa que toda la desnudez o contenido sexual esté prohibido. Reconocemos que la sexualidad es parte de la vida y que el contenido sexual no pornográfico puede ser parte de su proyecto o puede presentarse con fines educativos o artísticos. Si tienes alguna pregunta o inquietud sobre algo que quieras publicar, [no dudes en contactar y preguntar](https://support.github.com/contact) de antemano.

- **Spam.** Respeta el Foro de la Comunidad de GitHub. No publiques anuncios, enlaces a sitios web con spam ni vandalices de otro modo a la Comunidad. Esta comunidad está diseñada para que los usuarios de GitHub debatan sobre proyectos, aprendan y compartan ideas entre sí - no para publicidad u otro contenido como spam. Los contenidos que consideremos spam serán eliminados.

- **Contenido con derechos de autor o ilegal.** Publica solo tus propias cosas. Eres responsable de lo que publicas. Si publicas algo que no te creaste, debes tener derecho a publicarlo. Ni puedes publicar contenido ilegal, incluyendo contenido ilegal bajo las leyes de copyright y marca registrada, enlaces a contenido ilegal, o métodos para eludir la ley.

- **Malware activo o explotación de vulnerabilidad** - Ser parte de una comunidad incluye no aprovecharse de otros miembros de la comunidad. No permitimos que nadie utilice nuestra plataforma para la entrega de explotación (p. ej. Utilizar la Comunidad como medio para entregar ejecutables maliciosos) o como infraestructura de ataque (p. ej. Organizar ataques de denegación de servicio o administrar servidores de comandos y control). Sin embargo, ten en cuenta, que no prohibimos la publicación de código fuente que podría utilizarse para desarrollar malware o explotación de vulnerabilidad, ya que la publicación y distribución de dicho código fuente tiene un valor educativo y proporciona un beneficio neto a la comunidad de seguridad.

- **Cualquier persona menor de 13 años.** Si eres menor de 13 años, no puedes tener una cuenta en el Foro de la Comunidad de GitHub (o en el propio GitHub). GitHub no recopila intencionalmente información de niños menores de 13 años ni dirige ninguno de nuestros contenidos de manera específica a ellos. Si aprendemos o tenemos motivos para sospechar que eres un usuario menor de 13 años, desafortunadamente tendremos que cerrar tanto tu Foro de la Comunidad de GitHub como tus cuentas en GitHub.com. No queremos desalentarte de que aprendas nuestro código, pero esas son las reglas. Consulta nuestras [Términos de servicio](/articles/github-terms-of-service/) para obtener información sobre la cancelación de la cuenta.

- **Otras conductas que podrían considerarse razonablemente inadecuadas en un entorno profesional.** El Foro de la Comunidad de GitHub es un espacio profesional y debe ser tratado como tal.

### Cumplimiento

#### *Qué actividades pueden realizar los miembros de los foros de la comunidad de GitHub*

- **Si ves un problema, repórtalo.** Los moderadores tienen autoridad especial; son responsables de esta comunidad. Pero tú también. Con tu ayuda, los moderadores pueden ser facilitadores de la comunidad, no sólo personal de limpieza o policía.

  Cuando observes un mal comportamiento, no respondas. Fomenta el mal comportamiento al reconocerlo, consume tu energía y pierde el tiempo de todos. Simplemente repórtalo a través de "Reporte de contenido inapropiado" en el Menú Opción. Si se acumulan suficientes informes, se tomarán medidas, ya sea automáticamente o mediante la intervención del moderador.

#### Nuestras responsabilidades

Existe una variedad de acciones que podemos tomar en respuesta al comportamiento o contenido inadecuado. Por lo general, depende de las circunstancias exactas de un caso en particular. Reconocemos que en ocasiones la gente puede decir o hacer cosas inadecuadas por diversas razones. Tal vez no se dieron cuenta de cómo se percibirían sus palabras. O tal vez sólo dejan que sus emociones saquen lo mejor de ellos. Por supuesto, en ocasiones, hay gente que sólo quiere hacer spam o causar problemas.

Cada caso requiere un enfoque diferente, e intentamos adaptar nuestra respuesta para satisfacer las necesidades de la situación. Revisaremos cada situación caso por caso. En cada caso, tendremos un equipo diverso que investigue el contenido y los hechos relacionados y responda según corresponda, usando este Código de Conducta para guiar nuestra decisión.

Las acciones que podemos llevar a cabo en respuesta a un reporte de abuso incluyen, pero no se limitan a:
  - Eliminación de contenido
  - Bloqueo de contenido
  - Suspensión de la cuenta del Foro de la Comunidad
  - Terminación de la cuenta del Foro de la Comunidad

Los moderadores del Foro de la Comunidad que no sigan o no hagan cumplir el Código de Conducta de buena fe pueden enfrentarse a repercusiones temporales o permanentes según lo determine el liderazgo de otros miembros del Foro de la Comunidad.

### Contacto con el personal de GitHub

Si por cualquier razón quieres contactar en privado al personal de GitHub, los Gerentes Comunitarios, Administradores o Moderadores de este foro, puedes utilizar nuestro [Formulario de contacto para soporte](https://support.github.com/contact?tags=community-support). Se recomienda fuertemente que no contactes a ningún miembro del personal de GitHub a través de cualquier canal diferente al foro mismo o del formato de contacto para soporte y, el hacerlo, podria considerarse como una violación a nuestra prohibición contra el acoso.

Trabajemos juntos para mantener el foro un lugar donde las personas se sientan seguras de participar por ser respetuosas con ellos y su tiempo.

### Avisos legales

Sí, los términos legales son aburridos, pero debemos protegernos –y por extensión, tú y tus datos– de las personas poco amistosas. Tenemos [Términos de Servicio](/articles/github-terms-of-service/) y la [Declaración de Privacidad](/articles/github-privacy-statement/) que describe tu comportamiento (y nuestro) y los derechos relacionados con el contenido, privacidad y leyes. Para utilizar este servicio, debes aceptar cumplir nuestros [Términos de Servicio](/articles/github-terms-of-service/) y la [Declaración de Privacidad](/articles/github-privacy-statement/).

Este Código de Conducta no modifica nuestros [Términos de Servicio](/articles/github-terms-of-service/) y no pretende ser una lista completa. GitHub conserva toda la discreción bajo los [Términos de Servicio](/articles/github-terms-of-service/) para eliminar cualquier contenido o cancelar cualquier cuenta de actividad que sea "ilegal, ofensivo, amenazante, calumnioso, difamatorio, pornográfico, obsceno o de otro modo censurable o que viole la propiedad intelectual de cualquier parte o estos Términos de Servicio. Este Código de Conducta describe cuándo ejerceremos esa discreción.
