---
title: Declaración antisoborno de GitHub
redirect_from:
  - /articles/github-anti-bribery-statement
versions:
  free-pro-team: '*'
---

GitHub defiende nuestro compromiso con prácticas comerciales éticas, que incluyen prohibir el soborno y la corrupción. Como la [Transparencia Internacional](https://www.transparency.org/what-is-corruption#costs-of-corruption) lo explica, los costos de la corrupción son:
- **políticos**, que plantean un gran obstáculo para la democracia y el estado de derecho
- **económicos**, agotando la riqueza nacional
- **sociales**, al socavar la confianza de las personas en la sociedad, las instituciones y los líderes políticos
- **ambientales**, al facilitar la no aplicación de las leyes y regulaciones ambientales.

Según el [Banco Mundial](https://www.worldbank.org/en/topic/governance/brief/anti-corruption) en 2017, las empresas y personas pagan un estimado de $1.5 billones en sobornos cada año.

### Políticas de GitHub que prohíben el soborno

GitHub hace que nuestro compromiso con el anti-soborno sea claro en una cantidad de políticas de la empresa. Como parte de la familia de Microsoft, GitHub también se compromete con la política anticorrupción de Microsoft, que se aplica a todos los empleados y contratistas de GitHub, además de las políticas aquí descritas.

El **código de ética** de GitHub prohíbe que los empleados y los contratistas participen o contribuyan con el soborno o la corrupción y establece requisitos de mantenimiento de registros:
> Nunca debes pagar, ofrecer pagar, prometer pagar, inducir, aceptar o autorizar el pago de ninguna otra cosa de valor, a ninguna persona, incluyendo a ninguna persona en una posición de poder o autoridad, por ejemplo, funcionarios del gobierno o en transacciones comerciales, con el fin de obtener o mantener negocios, o asegurar cualquier otra ventaja inapropiada para GitHub o Microsoft. Tampoco debes solicitar o aceptar sobornos, ni ningún otro pago indebido en efectivo. ... [Los empleados de GitHub] están obligados a mantener registros precisos y razonables de todas las transacciones que implican cualquier gasto hecho en nombre de GitHub, por ejemplo, al mantener los recibos y proporcionar descripciones precisas de tus gastos, o cualquier otra transacción que implique la eliminación o la transferencia de los activos de GitHub. Such actions are required by the U.S. Foreign Corrupt Practices Act, the U.K. Estas acciones se exigen por la ley de prácticas corruptas extranjeras de los EE. UU., la ley de soborno del Reino Unido de 2010 y las leyes antisoborno de otras jurisdicciones en las que GitHub hace negocios y que también son simplemente la manera correcta de proceder.

El código ético de GitHub detalla ciertas situaciones, incluyendo sobre regalos, viajes y entretenimiento; facilitación de pagos; donaciones caritativas; puestos laborales y trabajar con representantes, así como la descripción de quién se considera un funcionario del gobierno.

Las normas de conducta de GitHub prohíben:
> Sobornar a funcionarios del gobierno u otras personas para obtener una ventaja injusta y tomar sobornos de cualquier persona.

La **política de regalos y entretenimiento** de GitHub explica que el soborno no está permitido en relación con los viajes o el entretenimiento y proporciona ejemplos para ilustrar conductas inadecuadas. La política describe los regalos adecuados e inadecuados, los gastos de viajes y entretenimiento; los procesos de la empresa para que los directores de GitHub, funcionarios, empleados y agentes hagan regalos y los requisitos para el mantenimiento de registros, sanciones; y la denuncia de violaciones. Incluye umbrales monetarios claros para los regalos junto con las limitaciones anuales, con excepciones limitadas para los regalos aprobados por la administración adecuada. La política es clara y de fácil acceso para los empleados y los contratistas de GitHub.

### Formación para nuestros empleados

Los empleados de GitHub están obligados a participar en la capacitación sobre corrupción, incluyendo sobornos. También proporcionamos capacitación adicional para personas y equipos particularmente relevantes, como nuestro equipo de ventas. The training explains relevant elements of the U.S. La capacitación explica los elementos pertinentes de la ley de prácticas corruptas extranjeras de los EE. UU. y la ley de soborno del Reino Unido de 2010. Bribery Act of 2010. Por ejemplo,
- definición y efectos estructurales de la corrupción
- que está cubierto, incluyendo
   - funcionarios públicos u otros en una posición de poder
   - terceros
- qué tipo de actividad está cubierta, incluyendo
   - efectivo, regalos, viajes y entretenimiento
   - pagos de facilitación
   - contribuciones caritativas y patrocinio
- para qué propósito, incluyendo
   - intento
   - ventaja o influencia incorrecta
- diligencia debida y señales de alerta
- requisitos de mantenimiento de registros

Además, la capacitación cubre las políticas internas de GitHub relacionadas con la lucha contra la corrupción y el soborno, incluyendo nuestra política de no represalias (denuncia de irregularidades).

While the U.S. FCPA is focused on interactions with government officials, the U.K. Bribery Act is broader and extends to bribing anyone, regardless of whether they are a government official. Ambas leyes pueden extenderse a las acciones de GitHub en otro lugar del mundo. Las políticas de GitHub prohíben sobornar a cualquier persona, en cualquier parte del mundo.

### Involucrar a nuestros socios
- Los acuerdos de reventa de GitHub ** con socios de canal** incluyen cláusulas de anti-corrupción obligatorias. En adelante, GitHub requirá que nuestros socios de canal se comprometan a cumplir con esta declaración anticorrupción.
- En adelante, los **contratos de vendedores** de GitHub requerirán un compromiso para cumplir con el código de conducta del proveedor de Microsoft o con esta declaración anticorrupción.
