---
title: Términos adicionales de los productos de GitHub
versions:
  free-pro-team: '*'
---

Al crear una Cuenta, se le da acceso a muchas características y productos diferentes que forman parte del Servicio. Debido a que muchas de estas características y productos ofrecen una funcionalidad diferente, pueden requerir términos y condiciones adicionales específicas de esa característica o producto. A continuación, hemos enumerado esas características y productos, junto con las correspondientes reglas adicionales que se aplican a esas partes del Servicio.

Tu uso de GitHub está sujeto a los términos aplicables (el "Contrato") así como a los siguientes términos del producto adicional de GitHub (los "Términos Adicionales"). Al aceptar el Contrato y utilizar los productos y características adicionales, también estás aceptando estos Términos Adicionales. Cualquier violación de las Condiciones Adicionales es una violación del Contrato. Los términos en mayúsculas no definidos en las Condiciones Adicionales tendrán el significado establecido en el Contrato.

### 1. Marketplace

Si registras un Producto de Desarrollador a través de GitHub Marketplace, entonces debes aceptar el [Acuerdo de Desarrollador de GitHub Marketplace](/github/site-policy/github-marketplace-developer-agreement), antes de enviar el proyecto a registrar.

Si compras Productos de Desarollador a través de GitHub Marketplace, los [Términos de servicio de GitHub Marketplace](/github/site-policy/github-marketplace-terms-of-service) controlarán tu compra. El Acuerdo, así como los [Términos de Servicio de GitHub Marketplace](/github/site-policy/github-marketplace-terms-of-service), regirán tu uso de GitHub Marketplace.

### 2. Integraciones de terceros

#### a. Creating Applications
Si creas una aplicación de terceros u otro producto de desarrollador que recopile Información Personal de Usuario o Contenido Generado por el Usuario e que se integre con el Servicio a través de la API de GitHub, el Mecanismo OAuth, o de otro modo ("Producto de Desarrollador") y está a disposición de otros usuarios, entonces debe cumplir con los siguientes requisitos:
- Debes cumplir con este Acuerdo y la Declaración de privacidad de GitHub.
- Excepto que se permita de otra manera, por ley o por una licencia, debes limitar tu uso de la Información Personal del Usuario o el Contenido Generado por el Usuario que recopiles para ese propósito para el cual el Usuario ha autorizado su recopilación.
- Debes tomar todas las medidas de seguridad razonables apropiadas para los riesgos, por ejemplo, contra la destrucción accidental o ilegal, o pérdidas accidentales, alteración, divulgación o acceso no autorizado, presentado mediante el procesamiento de la Información Personal del Usuario o Contenido Generado por el Usuario.
- No debes recopilar información personal o contenido generado por el usuario en nombre de GitHub y proporcionar un aviso necesario de tus prácticas de privacidad al Usuario, como por ejemplo, mediante la publicación de una política de privacidad.
- Debes ofrecerle a los Usuarios un método para borrar cualquier Información personal del Usuario o Contenido generado por el Usuario que hayas recopilado por medio de GitHub cuando deje de ser necesario para los fines limitados y especificados para los cuales el Usuario autorizó su recopilación, excepto cuando se requiera su retención por ley o se permita lo contrario, por ejemplo, a través de una licencia.

#### b. Solicitudes de uso de terceros
Puedes conceder una autorización de Producto de Desarrollador para usar, ingresar y divulgar el contenido de sus repositorios, incluyendo sus repositorios privados. Algunos Productos de Desarrollador están disponibles a través de [GitHub Marketplace](https://github.com/marketplace). Algunos Productos de Desarrollador pueden usarse para realizar tareas automatizadas y a menudo diversos usuarios pueden dirigir las acciones de un Producto de Desarrollador. Sin embargo, si compras y/o configuras un Producto de Desarrollador en tu Cuenta o eres propietario de una Cuenta con un Producto de Desarrollador integrado, entonces serás responsable de las acciones del Producto del Desarrollador que se llevan a cabo en o a través de tu Cuenta. Consulta nuestra [Declaración de Privacidad](/github/site-policy/github-privacy-statement#third-party-applications) para obtener más información sobre cómo compartimos datos con los Productos del Desarrollador.

**GitHub no ofrece ninguna garantía de ningún tipo en relación con los Productos de Desarrollador y no se hace responsable de las revelaciones a terceros que autorice a acceder a Tu Contenido. El uso que hagas de cualquier solicitud de terceros corre por tu cuenta y riesgo.**

### 3. Soporte de Git LFS

Si activas Git Large File Storage ("Git LFS") en tu Cuenta, podrás obtener, modificar y extraer archivos grandes como esperarías con cualquier archivo que Git gestione. Tu Cuenta viene con cierta cantidad de ancho de banda y almacenamiento para usar con Git LFS, que se puede encontrar en la [documentación de Git LFS](/github/managing-large-files/about-storage-and-bandwidth-usage). El ancho de banda y el uso de almacenamiento de Git LFS se muestran en la [configuración de Tu cuenta](https://github.com/settings/billing). Si deseas utilizar Git LFS más allá del ancho de banda y almacenamiento asignados, puedes [comprar paquetes de datos adicionales](/github/setting-up-and-managing-billing-and-payments-on-github/upgrading-git-large-file-storage).

### 4. Pages

Cada cuenta de GitHub viene con acceso al [servicio de alojamiento estático de las páginas de GitHub](/github/working-with-github-pages/about-github-pages). Este servicio de alojamiento está destinado a albergar páginas web estáticas para todos los usuarios, pero principalmente como escaparate para proyectos personales y organizativos. Se permiten algunas iniciativas de monetización en las Páginas, tales como botones de donación y enlaces de financiación colectiva.

Las páginas de GitHub están sujetas a algunos límites específicos de ancho de banda y uso y podrían no ser adecuadas para algunos usos de alto ancho de banda u otros usos prohibidos. Consulte nuestras [directrices de páginas de GitHub](/github/working-with-github-pages/about-github-pages) para obtener más información. GitHub se reserva el derecho en todo momento de reclamar cualquier subdominio de GitHub sin responsabilidad.

### 5. Acciones y paquetes

#### a. Uso de acciones
Acciones de GitHub te permiten crear flujos de trabajo de ciclo de vida de desarrollo del software personalizado directamente en tu repositorio de GitHub. Cada Cuenta viene con cantidades incluidas de cálculo y almacenamiento para usar con las Acciones, dependiendo del plan de tu cuenta, que pueden encontrarse en la [documentación de acciones](/github/automating-your-workflow-with-github-actions/about-github-actions#about-github-actions). Tu uso de acciones se muestra en [la configuración de tu cuenta](https://github.com/settings/billing) y se te notificará por correo electrónico antes de alcanzar el límite de las cantidades incluidas. Si deseas usar Acciones más allá de las cantidades incluidas, puedes [habilitar sobrecargas](/github/setting-up-and-managing-billing-and-payments-on-github/about-billing-for-github-actions).

El uso de las cantidades incluidas y pagadas se calcula en minutos en función del tipo de Acciones que ejecutes (por ejemplo, Linux, Windows, macOS). Los minutos utilizados para el trabajo o tarea de cada acción se redondearán hasta el minuto más cercano. Para cantidades incluidas y dependiendo del tipo de Acción, se puede aplicar un multiplicador a la cantidad de tiempo usado para ejecutar cada trabajo o tarea, antes de ser redondeado hasta el minuto más cercano. Los minutos promedio se cobran al [precio por minuto](https://github.com/features/actions) con base en el tipo de Acciones que ejecutes. Las Acciones y los Paquetes comparten almacenamiento y tu uso de almacenamiento se muestra en la configuración de tu cuenta[](https://github.com/settings/billing). Para obtener más detalles sobre los cálculos de uso de la cantidad incluida, consulta la [documentación de Acciones](/github/automating-your-workflow-with-github-actions/about-github-actions#about-github-actions).

Las acciones y cualquier elemento del servicio de las Acciones puede utilizarse en violación del Acuerdo, la [Política de Uso Aceptable](/github/site-policy/github-acceptable-use-policies)o las limitaciones de servicio [de las Acciones de GitHub](/github/automating-your-workflow-with-github-actions/about-github-actions#usage-limits). Además, las acciones no deben utilizarse para:
- criptominería;
- usar nuestros servidores para interrumpir,o para ganar o intentar obtener acceso no autorizado a, cualquier servicio, dispositivo, datos, cuenta o red (además de los autorizados por el [programa de recompensas de error de GitHub](https://bounty.github.com))
- el aproviosionamiento de las aplicaciones autónomas o integradas o del servicio que ofrece acciones o cualquier elemento de ellas para propósitos comerciales;
- cualquier actividad que coloque un peso en nuestros servidores, ya sea que dicho peso sea excesivo para los beneficios que se proporcionan a los usuarios (por ejemplo, no utilizamos acciones como una red de entrega de contenido o como parte de una aplicación sin servidores, pero una acción de beneficio mínimo podría estar bien si también implica un peso mínimo); o
- cualquier otra actividad no relacionada con la producción, prueba, despliegue o publicación del proyecto de software asociado con el repositorio donde se utilizan las Acciones de GitHub.

Para evitar violaciones de estas limitaciones y abuso de las Acciones de GitHub, GitHub puede controlar tu uso de Acciones de GitHub. El uso indebido de Acciones de GitHub puede resultar en la terminación de trabajos o restricciones en tu capacidad de usar Acciones de GitHub.

#### b. Uso de paquetes
Los paquetes de GitHub se pueden usar para descargar, publicar y administrar los paquetes de Contenido. Cada plan de Cuenta viene con ancho de banda incluido y cantidades de almacenamiento para tu uso con Paquetes, que se pueden encontrar en la [documentación de Paquetes](/github/managing-packages-with-github-package-registry/about-github-package-registry). Las Acciones y Paquetes comparten almacenamiento entre las dos características de Servicio. El uso de almacenamiento y ancho de banda se muestran en la configuración de tu cuenta [](https://github.com/settings/billing) y se te notificará por correo electrónico antes de alcanzar el límite de las cantidades incluidas. Si deseas utilizar Paquetes más allá de las cantidades de ancho de banda y almacenamiento incluidos, puedes [habilitar sobrecargas](/github/setting-up-and-managing-billing-and-payments-on-github/about-billing-for-github-packages).

El uso de ancho de banda se calcula basándose en la cantidad de datos transferidos fuera de tus repositorios mediante Paquetes, pero las transferencias de paquetes a través de Acciones no contarán para las cantidades incluidas o pagadas. El uso de ancho de banda de los paquetes está limitado por la [Política de Uso Aceptable](/github/site-policy/github-acceptable-use-policies#7-excessive-bandwidth-use) y las cantidades de ancho de banda incluidas se determinan por su plan de [Cuenta](https://github.com/pricing).

Las Acciones y el uso de almacenamiento de Paquetes se comparte entre las dos características de Servicio. El uso del almacenamiento se calcula como una media ponderada en el transcurso del mes y no se reinicia cada mes. Los repositorios públicos y privados tienen diferentes cantidades de almacenamiento incluidas, y las cantidades incluidas para los repositorios privados dependen de su [plan de Cuenta](https://github.com/pricing).

#### c. Pago y facturación de las Acciones y los Paquetes
La facturación para las Acciones y los Paquetes se basa en el uso. Las cantidades adicionales de Acciones o Paquetes no se pueden comprar por separado.  Para clientes facturados mensualmente, debes tener un método de pago en el archivo para elegir pagar por cantidades adicionales de estas características del Servicio. Se te cobrará mensualmente, recurriendo a la base de tu uso en el mes anterior, a menos que se te cobre por factura. Para clientes facturados, debes pagar las tarifas dentro de los treinta (30) días siguientes a la fecha de la factura de GitHub. Para los clientes que pagan con antelación los excedentes en la característica del servicio, los minutos prepagados no utilizados no se transferirán al próximo período de facturación y no se reembolsarán.

Puedes establecer un límite de gasto mensual en tu [configuración de cuenta](https://github.com/settings/billing/cost_management). Se te notificará por correo electrónico antes de alcanzar el límite de las cantidades incluidas y el límite de gasto designado de tus cantidades adicionales pagadas.

### 6. Laboratorio de aprendizaje

**Inscripción.** Para completar la inscripción en Learning Lab for Organizations, aceptas crear una organización diferente para los fines de laboratorio de aprendizaje y nos autorizas a agregar materiales del curso Learning Lab a esa organización en tu nombre.

**Materiales del curso Learning Lab.** Todos los materiales del curso que ofrece GitHub son propiedad únicamente de GitHub; sin embargo, siempre que GitHub te conceda una licencia a nivel mundia, no exclusiva, a plazo limitado, no transferible y exenta de regalías para copiar, mantener, usar y ejecutar dicho material del curso para tus fines comerciales internos asociados con el uso de Learning Lab. Esta concesión de licencia está sujeta a cualquier acuerdo de licencia de código abierto adicional que se pueda proporcionar junto con el código fuente.  Los materiales del curso que origines son propiedad únicamente tuya, considerando que concedes a GitHub una licencia mundial, no exclusiva, perpetua, no transferible y exenta de regalías para copiar, mantener, usar, alojar y ejecutar (según corresponda) en el servicio, dichos materiales del curso. Tu uso de los materiales del curso de GitHub y tu creación y almacenamiento de tus propios materiales del curso no constituye una propiedad conjunta en la propiedad intelectual respectiva de cualquiera de las partes por parte de la otra.

**Privacidad.** Learning Lab puede recopilar información personal. Controlas qué Information Learning Lab recopila en tu panel de ajustes del perfil de GitHub.com. Si Learning Lab recopila información personal en nombre de GitHub, GitHub procesará esa información de acuerdo con la [Declaración de privacidad de GitHub](/github/site-policy/github-privacy-statement). Si te inscribes o estás completando un curso privado a través de Learning Lab, GitHub puede compartir tu información de inscripción y el progreso del curso mediante la finalización con los administradores de la organización. Esto puede incluir datos individuales como el nombre de usuario de GitHub, la fecha de inicio del curso y la fecha de finalización del curso. Los datos de finalización del curso también se pueden presentar en forma agregada para ayudar a orientar las mejoras en el contenido del curso.

### 7. Conexión

Para acceder a Conexión con GitHub, el Cliente debe tener al menos una (1) cuenta en GitHub.com y una (1) instancia con licencia del Software. La Conexión con GitHub se puede usar para ejecutar tareas automatizadas. Además, múltiples Usuarios pueden dirigir determinadas acciones con Conexión con GitHub. El Cliente es responsable de las acciones que se realizan en sus cuentas o a través de ellas. GitHub puede recopilar información sobre la manera en que el Cliente usa la Conexión con GitHub para proporcionar y mejorar la función. Al usar la Conexión con GitHub, el Cliente autoriza a GitHub a recopilar datos protegidos, que incluyen datos del Repositorio privado e Información personal del Usuario (como se define en la Declaración de privacidad de GitHub), de la cuenta del servidor de GitHub Enterprise del Cliente. El Cliente también autoriza la transferencia de información de la instancia de identificación a GitHub por medio de la Conexión con GitHub. Esta información se rige por la Declaración de privacidad de GitHub.

### 8. Programa de patrocinadores

Para convertirse en un Desarrollador Patrocinado, debes aceptar los [Términos Adicionales del Programa de Patrocinadores de GitHub](/github/site-policy/github-sponsors-additional-terms).

### 9. GitHub Advanced Security

GitHub Advanced Security te permite identificar vulnerabilidades de seguridad a través del análisis semántico automatizado de código. GitHub Advanced Security maneja las licencias por usuario. Si utilizas la GitHub Advanced Security como parte de GitHub Enterprise Cloud, muchas de las características de la primera, incluyendo el escaneo automatizado de código para repositorios privados, también requerirán que utilices GitHub Actions. La facturación para el uso de GitHub Actions se basa en su uso, y está sujeta a las [Condiciones de GitHub Actions](/github/site-policy/github-additional-product-terms#c-payment-and-billing-for-actions-and-packages).

### 10. Vista previa de Dependabot

Tu uso de la vista previa de Dependabot se rige por los [Términos de Servicio](https://dependabot.com/terms) y la [Política de Privacidad](https://dependabot.com/privacy) por separado.

### 11. Spectrum

Tu uso de Spectrum se rige por las [Condiciones de Servicio](/github/site-policy/github-terms-of-service) de GitHub y por la [Declaración de Privacidad](/github/site-policy/github-privacy-statement).

### 12. Base de datos consultiva

#### a. Licencia otorgada

Necesitamos el derecho legal de enviar tus contribuciones a la base de datos consultiva de GitHub a los conjuntos de datos de dominio público como la [Base de datos nacional de vulnerabilidad](https://nvd.nist.gov/) y para licenciar la base de datos consultiva de GitHub bajo condiciones abiertas para su uso por investigadores de seguridad, la comunidad de código abierto, la industria y el público. Aceptas publicar tus contribuciones a la base de datos consultiva de GitHub bajo la [licencia Creative Commons Zero](https://creativecommons.org/publicdomain/zero/1.0/).

#### b. Licencia para la base de datos consultiva de GitHub

La base de datos consultiva de GitHub está bajo la licencia [Creative Commons Attribution 4.0](https://creativecommons.org/licenses/by/4.0/). La condición de la atribución se puede cumplir enlazando a la base de datos consultiva de GitHub en [https://github. om/advisories](https://github.com/advisories) o a registros individuales de la base de datos consultiva de GitHub usada, con la calificación de <https://github.com/advisories>.

