---
title: Política de retiro de DMCA
redirect_from:
  - /dmca/
  - /dmca-takedown/
  - /dmca-takedown-policy/
  - /articles/dmca-takedown/
  - /articles/dmca-takedown-policy
versions:
  free-pro-team: '*'
---

Bienvenido a la Guía sobre la Ley de Derechos de Autor del Milenio Digital de GitHub, comúnmente conocida como la "DMCA". Esta página no está pensada como un manual extenso del estatuto. Sin embargo, si has recibido un aviso de retiro de la DMCA orientado al contenido que has publicado en GitHub o si eres un titular de derechos que busca proponer dicho aviso, esperamos que esta página ayude a desmitificar la ley un poco, así como nuestras políticas para cumplirla.

(Si solo deseas enviar un aviso, puedes [ir al final del documento](#f-submitting-notices).)

Como en todas las cuestiones jurídicas, siempre es mejor consultar con un profesional sobre tus preguntas o situación específicas. Te recomendamos enfáticamente que lo hagas antes de emprender cualquier acción que pueda afectar tus derechos. Esta guía no es asesoramiento legal y no debería ser tomada como tal.

### ¿Qué es la DMCA?

Para entender la DMCA y algunas de las orientaciones de la política, tal vez sea útil considerar la duración antes de que se promulgara.

La DMCA proporciona un puerto seguro para los proveedores de servicios que albergan contenido generado por los usuarios. Dado que incluso una sola reclamación de infracción de derechos de autor puede conllevar daños estatutarios por hasta $150,000, la posibilidad de responsabilizarse de los contenidos generados por los usuarios podría ser muy perjudicial para los proveedores de servicios. Con daños potenciales multiplicados a través de millones de usuarios, la computación en la nube y los sitios de contenido generados por usuarios como YouTube, Facebook, o GitHub probablemente [nunca habrían existido](https://arstechnica.com/tech-policy/2015/04/how-the-dmca-made-youtube/) sin la DMCA (o al menos sin pasar parte de ese costo a sus usuarios).

La DMCA aborda este problema mediante la creación de un [puerto seguro de responsabilidad de derechos de autor](https://www.copyright.gov/title17/92chap5.html#512) para los proveedores de servicios de Internet que presuntamente infrinjan el contenido generado por los usuarios. Esencialmente, mientras un proveedor de servicios siga las reglas de notificación y retiro de la DMCA, no será responsable de la infracción de derechos de autor con base en el contenido generado por los usuarios. Debido a esto, es importante que GitHub mantenga su estado de puerto seguro de la DMCA.

### Avisos de la DMCA en Nutshell

La DMCA proporciona dos procedimientos claros y sencillos sobre los que todos los usuarios de GitHub deberían tener conocimiento: (i) un procedimiento [de notificación de retiro](/articles/guide-to-submitting-a-dmca-takedown-notice) para que los titulares de los derechos de autor soliciten que se elimine el contenido; y (ii) una [contra notificación](/articles/guide-to-submitting-a-dmca-counter-notice) para que se reactive el contenido, cuando se elimina por error o identificación incorrecta.

Los propietarios de derechos de autor utilizan [notificaciones de retiro de la DMCA](/articles/guide-to-submitting-a-dmca-takedown-notice) para solicitar a GitHub que retire el contenido que consideran infractor. Si eres diseñador de software o desarrollador, creas contenido con derechos de autor todos los días. Si alguien más está utilizando tu contenido con derechos de autor sin autorización dentro de GitHub, puedes enviarnos una notificación de retiro de la DMCA para solicitar que se cambie o elimine el contenido que comete dicha violación.

Por otro lado, se pueden utilizar [contra notificaciones](/articles/guide-to-submitting-a-dmca-counter-notice) para corregir errores. Quizá la persona que envía la notificación de retiro no tiene los derechos de autor o no se percató que tienes una licencia o cometió algún otro error en su notificación de retiro. Ya que GitHub normalmente no puede saber si ha ocurrido un error, la contra notificación de la DMCA te permite hacernos saber y solicitar que le volvamos a poner el contenido nuevamente.

El proceso de eliminación notificación y retiro de la DMCA debe utilizarse únicamente para reclamaciones sobre violaciones de derechos de autor. Las notificaciones enviadas a través de nuestro proceso DMCA deben identificar obras o trabajos protegidos por derechos de autor que supuestamente están siendo infringidos. El proceso no puede utilizarse para otras reclamaciones, tales como quejas sobre presuntas [infracciones de marcas](/articles/github-trademark-policy/) o [datos sensibles](/articles/github-sensitive-data-removal-policy/); ofrecemos procesos separados para esas situaciones.

### A. ¿Cómo funciona realmente?

El marco de la DMCA es un poco como pasar notas en clase. El propietario de los derechos de autor entrega a GitHub una reclamación sobre un usuario. Si está redactado correctamente, pasamos la queja al usuario. Si el usuario cuestiona la reclamación, puede regresar una nota afirmando. GitHub ejerce poca discreción en el proceso aparte de determinar si los avisos cumplen con los requisitos mínimos de la DMCA. Corresponde a las partes (y a sus abogados) evaluar el mérito de sus reclamaciones, teniendo en cuenta que las notificaciones deben realizarse bajo pena de perjurio.

Aquí están los pasos básicos en el proceso.

1. **El Propietario de Derechos de Autor investiga.** Un propietario de los derechos de autor siempre debe realizar una investigación inicial para confirmar (a) que son propietarios de los derechos de autor de una obra original y (b) que el contenido de GitHub no está autorizado y es infractor. Esto incluye confirmar que el uso no está protegido como [uso razonable](https://www.lumendatabase.org/topics/22). Un uso particular puede ser justo si solamente utiliza una pequeña cantidad de contenido protegido por derechos de autor, utiliza ese contenido de forma transformativa, lo utiliza para fines educativos, o alguna combinación de lo anterior. Dado que el código naturalmente se presta a dichos usos, cada caso de uso es diferente y debe considerarse por separado.
> **Ejemplo:** Un empleado de Acme Web Company encuentra parte del código de la empresa en un repositorio de GitHub. Acme Web Company otorga licencias de su código fuente a diversos socios de confianza. Antes de enviar una notificación de retiro, Acme debe revisar dichas licencias y sus acuerdos para confirmar que el código en GitHub no esté autorizado bajo ninguna de ellas.

2. **El propietario de los derechos de autor envía una notificación.** Después de realizar una investigación, un propietario de los derechos de autor prepara y envía una [notificación de retiro](/articles/guide-to-submitting-a-dmca-takedown-notice) a GitHub. Suponiendo que la notificación de retiro esté suficientemente detallada de acuerdo con los requisitos legales (como se explica en la [guía práctica](/articles/guide-to-submitting-a-dmca-takedown-notice)), [publicaremos la notificación](#d-transparency) en nuestro [repositorio público](https://github.com/github/dmca) y pasaremos el enlace al usuario afectado.

3. **GitHub solicita a sus usuarios hacer cambios.** Si la notificación declara que todo el contenido de un repositorio o un paquete están cometiendo una violación, saltaremos al Paso 6 e inhabilitaremos todo el repositorio o paquete expeditamente. De lo contrario, debido a que GitHub no puede inhabilitar el acceso a archivos específicos dentro de un repositorio, nos contactaremos con el usuario que creó el repositorio y les daremos aproximadamente 1 día hábil para eliminar o modificar el contenido especificado en el aviso. Notificaremos al propietario de los derechos de autor si y cuando demos al usuario la oportunidad de hacer cambios. Ya que los paquetes son inmutables, si solo una parte de un paquete incurre en una violación, GitHub necesitará inhabilitar todo el paquete, pero permitiremos su restablecimiento una vez que se elimine la parte que comete la violación.

4. **El usuario notifica a GitHub acerca de los cambios.** Si el usuario opta por realizar los cambios especificados, *Debe* avísanos dentro de la ventana de aproximadamente 1 día hábil. Si no lo hacen, deshabilitaremos el repositorio (como se describe en el paso 6). Si el usuario nos notifica que realizó cambios, verificaremos que los cambios se hayan realizado y posteriormente notificaremos al propietario de los derechos de autor.

5. **El titular de los derechos de autor revisa o retrae la notificación.** Si el usuario realiza cambios, el propietario de los derechos de autor debe revisarlos y renovar o revisar su aviso de eliminación si los cambios son insuficientes. GitHub no tomará ninguna acción adicional a menos que el propietario de los derechos de autor se ponga en contacto con nosotros para renovar la notificación de retiro original o presentar uno revisado. Si el propietario de los derechos de autor está satisfecho con los cambios, puede presentar una retracción formal o no hacer nada. GitHub interpretará el silencio durante más de dos semanas como una retracción implícita del aviso de retiro.

6. **GitHub puede inhabilitar el acceso al contenido.** GitHub inhabilitará el contenido de un usuario si: (i) el propietario de los derechos de autor reclama dichos derechos sobre un paquete o todo el repositorio del usuario (como se explica en el Paso 3); (ii) el usuario no ha realizado cambios después de habérsele proporcionado una oportunidad para hacerlo (de acuerdo con el Paso 4); o (iii) el propietario de los derechos de autor renovó su notificación de retiro después de que el usuario tuvo una oportunidad de realizar los cambios. Si el propietario de los derechos de autor elige *revisar* la notificación, volveremos al paso 2 y repetiremos el proceso como si la notificación revisada fuera un nuevo aviso.

7. **El usuario puede enviar una contra notificación.** Alentamos a los usuarios que han deshabilitado contenido a consultar con un abogado sobre sus opciones. Si un usuario considera que su contenido fue deshabilitado como resultado de un error o identificación incorrecta, pueden enviarnos una [contra notificación](/articles/guide-to-submitting-a-dmca-counter-notice). Como en la notificación original, nos aseguraremos de que la contra notificación esté lo suficientemente detallada (como se explica en la [guía práctica](/articles/guide-to-submitting-a-dmca-counter-notice)). Si es así, [lo publicaremos](#d-transparency) en nuestro [repositorio público](https://github.com/github/dmca) y pasaremos el aviso al propietario de los derechos de autor enviándole el enlace.

8. **El propietario de los derechos de autor puede presentar una acción legal.** Si un propietario de derechos de autor desea mantener el contenido deshabilitado después de recibir una contra notificación, tendrán que iniciar una acción legal que busque una orden judicial para impedir que el usuario se implique en actividades relacionadas con el contenido de GitHub. En otras palabras, podrías ser demandado. Si el propietario de los derechos de autor no da aviso a GitHub en un plazo de 10-14 días, enviando una copia de una queja legal válida presentada en un tribunal de jurisdicción competente, GitHub rehabilitará el contenido inhabilitado.

### B. ¿Qué hay de las bifurcaciones? (o ¿Qué es una bifurcación?)

Una de las mejores características de GitHub es la capacidad de los usuarios de "bifurcar" los repositorios de otros. ¿Qué significa esto? En esencia, significa que los usuarios pueden hacer una copia de un proyecto en GitHub en sus propios repositorios. Como la licencia o la ley permite, los usuarios pueden hacer cambios en esa bifurcación para volver al proyecto principal o simplemente mantener como su propia variación de un proyecto. Cada una de estas copias es una "[bifurcación](/articles/github-glossary#fork)" del repositorio original, que a su vez también se puede llamar la "matriz" de la bifurcación.

GitHub *no deshabilitará automáticamente* las bifurcaciones cuando se deshabilite un repositorio matriz. Esto se debe a que las bifurcaciones pertenecen a diferentes usuarios, pueden haber sido alteradas de manera significativa y pueden ser licenciadas o utilizada de una manera diferente que estén protegidas por la doctrina de uso leal. GitHub no lleva a cabo ninguna investigación independiente sobre las bifucaciones. Esperamos que los propietarios de los derechos de autor lleven a cabo esa investigación y, si creen que las bifurcaciones también están infringiendo, incluyan expresamente bifurcaciones en su notificación de retiro.

### C. ¿Qué pasa si perdí inadvertidamente el período para hacer cambios?

Reconocemos que existen muchas razones válidas para que no puedas hacer cambios dentro de la ventana de aproximadamente 1 día laborable que proporcionamos antes de que tu repositorio se inhabilite. Quizá nuestro mensaje fue marcado como spam, tal vez estabas de vacaciones, posiblemente no revisas esa cuenta de correo electrónico regularmente, o probablemente solo estabas ocupado. Lo entendemos. Si respondes para hacernos saber que te hubiera gustado hacer los cambios, pero de alguna manera faltaste a la primera oportunidad, rehabilitaremos el repositorio un tiempo adicional durante aproximadamente 1 día hábil para permitir que realices los cambios. Nuevamente, debes notificarnos que has realizado los cambios con el fin de mantener el repositorio habilitado después de esa ventana de aproximadamente 1 día hávil, como se mencionó anteriormente en el [Paso A. 4](#a-how-does-this-actually-work). Ten en cuenta que sólo te daremos una oportunidad adicional.

### D. Transparencia

Creemos que la transparencia es una virtud. El público debería saber qué contenido se está eliminando de GitHub y por qué. Un público informado puede notar y descubrir posibles problemas superficiales que de otro modo pasarían desapercibidos en un sistema poco claro. Publicamos copias redactadas de cualquier aviso legal que recibamos (incluyendo notificaciones originales, contra notificaciones o retracciones) en <https://github.com/github/dmca>. No haremos pública tu información de contacto personal; eliminaremos la información personal (excepto los nombres de usuario en las URLs) antes de publicar notificaciones. Sin embargo, no redactaremos ninguna otra información de tu notificación a menos que nos lo solicites específicamente. Estos son algunos ejemplos de una [notificación ](https://github.com/github/dmca/blob/master/2014/2014-05-28-Delicious-Brains.md) publicada y [una contra notificación](https://github.com/github/dmca/blob/master/2014/2014-05-01-Pushwoosh-SDK-counternotice.md) para que veas cómo son. Cuando eliminemos el contenido, publicaremos un enlace al aviso relacionado en su lugar.

Ten también en cuenta que, aunque no publicaremos avisos no modificados, podemos proporcionar una copia completa y no editada de cualquier notificación que recibamos directamente a cualquier parte cuyos derechos se verían afectados por ella.

### E. Retición de una infracción

Es la política de GitHub, en circunstancias apropiadas y a su entera discreción, desactivar y terminar las cuentas de los usuarios que puedan infringir los derechos de autor u otros derechos de propiedad intelectual de GitHub u otros.

### F. Cómo enviar notificaciones

Si estás listo para enviar una notificación o una contra notificación:
- [Cómo enviar una notificación de la DMCA](/articles/guide-to-submitting-a-dmca-takedown-notice)
- [Cómo enviar una contra notificación de la DMCA](/articles/guide-to-submitting-a-dmca-counter-notice)

### Conoce más y comunícate

Si exploras Internet, no es demasiado difícil encontrar comentarios y críticas sobre el sistema de derechos de autor en general y la DMCA en particular. Mientras que GitHub reconoce y aprecia el importante papel que ha desempeñado la DMCA en la promoción de la innovación en línea creemos que las leyes de derechos de autor probablemente podrían usar un patch o dos, o bien una versión completamente nueva. En software, estamos constantemente mejorando y actualizando nuestro código. Piensa en cuánto ha cambiado la tecnología desde 1998, cuando se redactó la DMCA. ¿No tiene sentido actualizar estas leyes que se aplican al software?

No presumimos de tener todas las respuestas. Pero si eres curioso, aquí tienes algunos enlaces a artículos informativos y entradas de blog que hemos encontrado con opiniones y propuestas para la reforma:

- [Consecuencias no deseadas: Doce años bajo la DMCA](https://www.eff.org/wp/unintended-consequences-under-dmca) (Constitución de la Frontera Electrónica)
- [Daños y Perjuicios Reglamentarios en la Ley de Derechos de Autor: Un recordatorio en la necesidad de la reforma](https://papers.ssrn.com/sol3/papers.cfm?abstract_id=1375604) (William & Revisión de la ley María)
- [¿El plazo de protección de los derechos de autor es demasiado largo?](https://the1709blog.blogspot.com/2012/11/is-term-of-protection-of-copyright-too.html) (el 1709 blog)
- [Si vamos a cambiar 'Notificación y Retiro', de la DMCA, centrémonos en su amplio abuso](https://www.techdirt.com/articles/20140314/11350426579/if-were-going-to-change-dmcas-notice-takedown-lets-focus-how-widely-its-abused.shtml) (TechDirt)
- [Oportunidades para la reforma de los derechos de autor](https://www.cato-unbound.org/issues/january-2013/opportunities-copyright-reform) (Cato sin asociar)
- [Uso Justo de la Doctrina y la Ley de Derechos de Autor del Milenio Digital: ¿Existe un uso justo en Internet bajo la DMCA?](https://digitalcommons.law.scu.edu/lawreview/vol42/iss1/6/) (Revisión de la Ley de Santa Clara)

GitHub no necesariamente respalda ninguno de los puntos de vista en esos artículos. Proporcionamos los enlaces para invitarte a conocer más, formar tus propias opiniones y posteriormente llegar a tu(s) representante(s) electos (por ejemplo, en el [Congreso de los Estados Unidos](https://www.govtrack.us/congress/members) o [Parlamento de los EE. UU.](https://www.europarl.europa.eu/meps/en/home)) para buscar los cambios que consideras que deberían llevarse a cabo. Congress</a> or [E.U. Parliament](https://www.europarl.europa.eu/meps/en/home)) to seek whatever changes you think should be made.
