---
title: Niveles de permiso del repositorio para una organización
intro: 'Puedes personalizar el acceso a cada repositorio de tu organización con niveles de permiso granulares, dándoles a las personas acceso a las funciones y tareas que necesitan.'
redirect_from:
  - /articles/repository-permission-levels-for-an-organization-early-access-program/
  - /articles/repository-permission-levels-for-an-organization
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---

Las personas con permisos de administrador pueden administrar el acceso individual o del equipo al repositorio que le pertenece a la organización.

### Niveles de permiso para los repositorios que le pertenecen a una organización

Puedes otorgar diferentes niveles de acceso a los miembros de la organización, los colaboradores externos y los equipos de personas para los repositorios que le pertenecen a una organización. Cada nivel de permiso aumenta de manera progresiva el acceso al contenido y los parámetros de un repositorio. Elige el nivel que mejor se adecue a cada rol de persona o equipo de tu proyecto, evitando otorgar a las personas más acceso al proyecto del que necesitan.

Del menor acceso al mayor acceso, los niveles de permiso para el repositorio de una organización son los siguientes:
- **Lectura**: Recomendado para los contribuyentes sin código que quieren ver tu proyecto u opinar sobre él {% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.18" %}
- **Prueba**: Recomendado para los contribuyentes que necesiten administrar propuestas y solicitudes de extracción de manera proactiva sin acceso de escritura{% endif %}
- **Escritura**: Recomendado para los contribuyentes que suben contenido a tu proyecto de manera activa{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.18" %}
- **Mantenimiento (beta)**: Recomendado para los gerentes del proyecto que necesiten administrar el repositorio sin acceder a las acciones confidenciales o destructivas{% endif %}
- **Administrador**: Recomendado para las personas que necesitan acceso total al proyecto, incluidas las acciones conflictivas y destructivas, como gestionar la seguridad o eliminar un repositorio

{% if currentVersion == "free-pro-team@latest" %}

{% endif %}

Para obtener más información acerca de otorgar acceso a los repositorios a las personas y los equipos, consulta "[Administrar el acceso a los repositorios de tu organización](/articles/managing-access-to-your-organizations-repositories)".

Los dueños de las organizaciones pueden configurar permisos base que apliquen a todos los miembros de la misma cuando accedan a cualquiera de los repositorios que le pertenezcan a dicha organización. Para obtener más información, consulta la sección "[Configurar los permisos base para una organización](/github/setting-up-and-managing-organizations-and-teams/setting-base-permissions-for-an-organization#setting-base-permissions)".

Los propietarios de la organización también pueden decidir limitar más el acceso a determinados parámetros y acciones de la organización. Para obtener más información sobre las opciones de parámetros específicos, consulta "[Administrar los parámetros de la organización](/articles/managing-organization-settings)".

Además de administrar los parámetros al nivel de la organización, los propietarios de la organización tienen permisos de administradores para cada repositorio que le pertenece a la organización. Para obtener más información, consulta "[Niveles de permiso para una organización](/articles/permission-levels-for-an-organization)".

{% warning %}

**Advertencia:** Cuando una persona agrega una llave de implementación a un repositorio, cualquier usuario que tenga la llave privada puede leer o escribir en el repositorio (según los parámetros de la llave), incluso si luego es eliminada de la organización.

{% endwarning %}

### Acceso al repositorio para cada nivel de permiso
{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.18" %}
| Acción del repositorio                                                                                                                                                                                                                                                                                        | Lectura | Clasificación | Escritura | Mantenimiento |                                                                                      Admin                                                                                      |
|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |:-------:|:-------------:|:---------:|:-------------:|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------:|
| Extraer desde los repositorios asignados de la persona o el equipo                                                                                                                                                                                                                                            |  **X**  |     **X**     |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| Bifurcar los repositorios asignados de la persona o el equipo                                                                                                                                                                                                                                                 |  **X**  |     **X**     |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| Editar y eliminar sus propios comentarios                                                                                                                                                                                                                                                                     |  **X**  |     **X**     |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| Abrir propuestas                                                                                                                                                                                                                                                                                              |  **X**  |     **X**     |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| Cerrar propuestas que ellos mismos abrieron                                                                                                                                                                                                                                                                   |  **X**  |     **X**     |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| Reabrir propuestas que ellos mismos cerraron                                                                                                                                                                                                                                                                  |  **X**  |     **X**     |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| Recibir la asignación de una propuesta                                                                                                                                                                                                                                                                        |  **X**  |     **X**     |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| Enviar solicitudes de extracción desde las bifurcaciones de los repositorios asignados del equipo                                                                                                                                                                                                             |  **X**  |     **X**     |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| Enviar revisiones sobre solicitudes de extracción                                                                                                                                                                                                                                                             |  **X**  |     **X**     |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| Ver los lanzamientos publicados                                                                                                                                                                                                                                                                               |  **X**  |     **X**     |   **X**   |     **X**     |                                                                    **X** |{% if currentVersion == "free-pro-team@latest" %}
| Ver las [Ejecuciones de flujo de trabajo de GitHub Actions](/actions/automating-your-workflow-with-github-actions/managing-a-workflow-run)                                                                                                                                                                    |  **X**  |     **X**     |   **X**   |     **X**     |                                                                               **X** |{% endif %}
| Editar wikis                                                                                                                                                                                                                                                                                                  |  **X**  |     **X**     |   **X**   |     **X**     |                                                                    **X** |{% if currentVersion == "free-pro-team@latest" %}
| [Informar contenido abusivo o de spam](/articles/reporting-abuse-or-spam)                                                                                                                                                                                                                                     |  **X**  |     **X**     |   **X**   |     **X**     |                                                                               **X** |{% endif %}
| Aplicar etiquetas                                                                                                                                                                                                                                                                                             |         |     **X**     |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| Elegir, reabrir y asignar todas las propuestas y solicitudes de extracción                                                                                                                                                                                                                                    |         |     **X**     |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| Aplicar hitos                                                                                                                                                                                                                                                                                                 |         |     **X**     |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| Marcar [duplicar propuestas y solicitudes de extracción](/articles/about-duplicate-issues-and-pull-requests)                                                                                                                                                                                                  |         |     **X**     |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| Solicitar [revisiones de solicitudes de extracción](/articles/requesting-a-pull-request-review)                                                                                                                                                                                                               |         |     **X**     |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| Subir a (escribir en) los repositorios asignados de la persona o el equipo                                                                                                                                                                                                                                    |         |               |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| Editar y eliminar comentarios o confirmaciones, solicitudes de extracción y propuestas de cualquier persona                                                                                                                                                                                                   |         |               |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| [Ocultar los comentarios de cualquier persona](/articles/managing-disruptive-comments)                                                                                                                                                                                                                        |         |               |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| [Bloquear conversaciones](/articles/locking-conversations)                                                                                                                                                                                                                                                    |         |               |   **X**   |     **X**     |                                                     **X** |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.17" %}
| Transferir propuestas (consulta "[Transferir una propuesta a otro repositorio](/articles/transferring-an-issue-to-another-repository)" para obtener detalles)                                                                                                                                                 |         |               |   **X**   |     **X**     |                                                                               **X** |{% endif %}
| [Actuar como propietario del código designado para un repositorio](/articles/about-code-owners)                                                                                                                                                                                                               |         |               |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| [Marcar un borrador de solicitud de extracción como listo para revisión](/articles/changing-the-stage-of-a-pull-request)                                                                                                                                                                                      |         |               |   **X**   |     **X**     |                                                     **X** |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.20" %}
| [Convertir una solicitud de extracción en borrador](/articles/changing-the-stage-of-a-pull-request)                                                                                                                                                                                                           |         |               |   **X**   |     **X**     |                                                                               **X** |{% endif %}
| Enviar revisiones que afecten la capacidad de fusión de una solicitud de extracción                                                                                                                                                                                                                           |         |               |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| [Aplicar cambios sugeridos](/articles/incorporating-feedback-in-your-pull-request) a las solicitudes de extracción                                                                                                                                                                                            |         |               |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| Crear [comprobaciones de estado](/articles/about-status-checks)                                                                                                                                                                                                                                               |         |               |   **X**   |     **X**     |                                                                    **X** |{% if currentVersion == "free-pro-team@latest" %}
| Crear, editar, ejecutar, volver a ejecutar y cancelar [Flujos de trabajo de Acciones de GitHub](/actions/automating-your-workflow-with-github-actions/)                                                                                                                                                       |         |               |   **X**   |     **X**     |                                                                               **X** |{% endif %}
| Crear y editar lanzamientos                                                                                                                                                                                                                                                                                   |         |               |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| Ver lanzamientos en borrador                                                                                                                                                                                                                                                                                  |         |               |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| Editar la descripción de un repositorio                                                                                                                                                                                                                                                                       |         |               |           |     **X**     |                                                                    **X** |{% if currentVersion == "free-pro-team@latest" %}
| [View and install packages](/packages/publishing-and-managing-packages)                                                                                                                                                                                                                                       |  **X**  |     **X**     |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| [Publish packages](/packages/publishing-and-managing-packages/publishing-a-package)                                                                                                                                                                                                                           |         |               |   **X**   |     **X**     |                                                                                      **X**                                                                                      |
| [Borrar paquetes](/packages/publishing-and-managing-packages/deleting-a-package)                                                                                                                                                                                                                              |         |               |           |               |                                                                                      **X**                                                                                      |{% endif %}
| Administrar [temas](/articles/classifying-your-repository-with-topics)                                                                                                                                                                                                                                        |         |               |           |     **X**     |                                                                                      **X**                                                                                      |
| Habilitar wikis y restringir editores de wikis                                                                                                                                                                                                                                                                |         |               |           |     **X**     |                                                                                      **X**                                                                                      |
| Habilitar tableros de proyecto                                                                                                                                                                                                                                                                                |         |               |           |     **X**     |                                                                                      **X**                                                                                      |
| Configurar las [fusiones de la solicitud de extracción](/articles/configuring-pull-request-merges)                                                                                                                                                                                                            |         |               |           |     **X**     |                                                                                      **X**                                                                                      |
| Configurar [una fuente de publicaciones para {% data variables.product.prodname_pages %}](/articles/configuring-a-publishing-source-for-github-pages)                                                                                                                                                    |         |               |           |     **X**     |                                                                                      **X**                                                                                      |
| [Subir a ramas protegidas](/articles/about-protected-branches)                                                                                                                                                                                                                                                |         |               |           |     **X**     |                                                                                      **X**                                                                                      |
| [Crear y editar las tarjetas sociales del repositorio](/articles/customizing-your-repositorys-social-media-preview)                                                                                                                                                                                           |         |               |           |     **X**     |                                                                    **X** |{% if currentVersion == "free-pro-team@latest" %}
| Limitar las [interacciones en un repositorio](/github/building-a-strong-community/limiting-interactions-in-your-repository)                                                                                                                                                                                   |         |               |           |     **X**     |                                                                               **X** |{% endif %}
| Eliminar una propuesta (consulta "[Eliminar una propuesta](/articles/deleting-an-issue)")                                                                                                                                                                                                                     |         |               |           |               |                                                                                      **X**                                                                                      |
| Fusionar solicitudes de extracción en ramas protegidas, incluso si no existen revisiones en aprobación                                                                                                                                                                                                        |         |               |           |               |                                                                                      **X**                                                                                      |
| [Definir propietarios del código para un repositorio](/articles/about-code-owners)                                                                                                                                                                                                                            |         |               |           |               |                                                                                      **X**                                                                                      |
| Añadir un repositorio a un equipo (consulta la sección "[Administrar el acceso de un equipo a un repositorio de la organización](/github/setting-up-and-managing-organizations-and-teams/managing-team-access-to-an-organization-repository#giving-a-team-access-to-a-repository)" para obtener más detalles) |         |               |           |               |                                                                                      **X**                                                                                      |
| [Gestionar el acceso de un colaborador externo a un repositorio](/articles/adding-outside-collaborators-to-repositories-in-your-organization)                                                                                                                                                                 |         |               |           |               |                                                                                      **X**                                                                                      |
| [Cambiar la visibilidad de un repositorio](/articles/restricting-repository-visibility-changes-in-your-organization)                                                                                                                                                                                          |         |               |           |               |                                                     **X** |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.17" %}
| Volver plantilla un repositorio (consulta "[Crear un repositorio de plantilla](/articles/creating-a-template-repository)")                                                                                                                                                                                    |         |               |           |               |                                                                               **X** |{% endif %}
| Cambiar los parámetros de un repositorio                                                                                                                                                                                                                                                                      |         |               |           |               |                                                                                      **X**                                                                                      |
| Administrar el acceso de un equipo o colaborador al repositorio                                                                                                                                                                                                                                               |         |               |           |               |                                                                                      **X**                                                                                      |
| Editar la rama predeterminada del repositorio                                                                                                                                                                                                                                                                 |         |               |           |               |                                                                                      **X**                                                                                      |
| Administrar webhooks y desplegar llaves                                                                                                                                                                                                                                                                       |         |               |           |               |                                                                    **X** |{% if currentVersion == "free-pro-team@latest" %}
| [Habilitar el gráfico de dependencias](/github/visualizing-repository-data-with-graphs/exploring-the-dependencies-and-dependents-of-a-repository) de un repositorio privado                                                                                                                                   |         |               |           |               |                                                                                      **X**                                                                                      |
| Recibir [{% data variables.product.prodname_dependabot_alerts %} para las dependencias vulnerabiles](/github/managing-security-vulnerabilities/about-alerts-for-vulnerable-dependencies) en un repositorio                                                                                             |         |               |           |               |                                                                                      **X**                                                                                      |
| [Ignorar las {% data variables.product.prodname_dependabot_alerts %}](/github/managing-security-vulnerabilities/viewing-and-updating-vulnerable-dependencies-in-your-repository)                                                                                                                       |         |               |           |               |                                                                                      **X**                                                                                      |
| [Designar personas o equipos adicionales para que reciban las {% data variables.product.prodname_dependabot_alerts %}](/github/administering-a-repository/managing-security-and-analysis-settings-for-your-repository) para las dependencias vulnerables                                               |         |               |           |               |                                                                                      **X**                                                                                      |
| [Administrar la configuración de uso de datos para tu repositorio privado](/github/understanding-how-github-uses-and-protects-your-data/managing-data-use-settings-for-your-private-repository)                                                                                                               |         |               |           |               | **X** |{% endif %}{% if currentVersion == "free-pro-team@latest" %}| Crear [asesorías de seguridad](/github/managing-security-vulnerabilities/about-github-security-advisories) | | | | | **X** |{% endif %}
| [Administrar la política de bifurcación para un repositorio](/github/administering-a-repository/managing-the-forking-policy-for-your-repository)                                                                                                                                                              |         |               |           |               |                                                                                      **X**                                                                                      |
| [Transferir repositorios a la organización](/articles/restricting-repository-creation-in-your-organization)                                                                                                                                                                                                   |         |               |           |               |                                                                                      **X**                                                                                      |
| [Eliminar o transferir repositorios fuera de la organización](/articles/setting-permissions-for-deleting-or-transferring-repositories)                                                                                                                                                                        |         |               |           |               |                                                                                      **X**                                                                                      |
| [Archivar repositorios](/articles/about-archiving-repositories)                                                                                                                                                                                                                                               |         |               |           |               |                                                                    **X** |{% if currentVersion == "free-pro-team@latest" %}
| Mostrar el botón de un patrocinador (consulta "[Mostrar el botón de un patrocinador en tu repositorio](/articles/displaying-a-sponsor-button-in-your-repository)")                                                                                                                                            |         |               |           |               |                                                **X** |{% endif %}{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.18" %}
| Crear referencias de enlace automático a recursos externos, como JIRA o Zendesk (consulta "[Configurar enlaces automáticos para referenciar recursos externos](/articles/configuring-autolinks-to-reference-external-resources)")                                                                             |         |               |           |               |                                                                               **X** |{% endif %}

{% else %}

| Acción del repositorio                                                                                                                                                                                                                                                                                        | Permisos de lectura | Permisos de escritura |                       Permisos de administrador                        |
|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |:-------------------:|:---------------------:|:----------------------------------------------------------------------:|
| Extraer desde (leer) los repositorios asignados de la persona o el equipo                                                                                                                                                                                                                                     |        **X**        |         **X**         |                                 **X**                                  |
| Bifurcar (copiar) los repositorios asignados de la persona o el equipo                                                                                                                                                                                                                                        |        **X**        |         **X**         |                                 **X**                                  |
| Editar y eliminar sus propios comentarios sobre confirmaciones, solicitudes de extracción y propuestas                                                                                                                                                                                                        |        **X**        |         **X**         |                                 **X**                                  |
| Abrir propuestas                                                                                                                                                                                                                                                                                              |        **X**        |         **X**         |                                 **X**                                  |
| Cerrar propuestas que ellos mismos abrieron                                                                                                                                                                                                                                                                   |        **X**        |         **X**         |                                 **X**                                  |
| Reabrir propuestas que ellos mismos cerraron                                                                                                                                                                                                                                                                  |        **X**        |         **X**         |                                 **X**                                  |
| Recibir la asignación de una propuesta                                                                                                                                                                                                                                                                        |        **X**        |         **X**         |                                 **X**                                  |
| Enviar solicitudes de extracción desde las bifurcaciones de los repositorios asignados del equipo                                                                                                                                                                                                             |        **X**        |         **X**         |                                 **X**                                  |
| Enviar revisiones sobre solicitudes de extracción                                                                                                                                                                                                                                                             |        **X**        |         **X**         |                                 **X**                                  |
| Ver los lanzamientos publicados                                                                                                                                                                                                                                                                               |        **X**        |         **X**         |                                 **X**                                  |
| Editar wikis                                                                                                                                                                                                                                                                                                  |        **X**        |         **X**         |                **X** |{% if currentVersion == "free-pro-team@latest" %}
| [Informar contenido abusivo o de spam](/articles/reporting-abuse-or-spam)                                                                                                                                                                                                                                     |        **X**        |         **X**         |                           **X** |{% endif %}
| Subir a (escribir en) los repositorios asignados de la persona o el equipo                                                                                                                                                                                                                                    |                     |         **X**         |                                 **X**                                  |
| Editar y eliminar comentarios o confirmaciones, solicitudes de extracción y propuestas de cualquier persona                                                                                                                                                                                                   |                     |         **X**         |                                 **X**                                  |
| [Ocultar los comentarios de cualquier persona](/articles/managing-disruptive-comments)                                                                                                                                                                                                                        |                     |         **X**         |                                 **X**                                  |
| [Bloquear conversaciones](/articles/locking-conversations)                                                                                                                                                                                                                                                    |                     |         **X**         |                                 **X**                                  |
| Aplicar etiquetas e hitos                                                                                                                                                                                                                                                                                     |                     |         **X**         |                                 **X**                                  |
| Cerrar, reabrir y asignar todas las propuestas                                                                                                                                                                                                                                                                |                     |         **X**         |                **X** |{% if currentVersion == "free-pro-team@latest" %}
| Marcar [duplicar propuestas y solicitudes de extracción](/articles/about-duplicate-issues-and-pull-requests)                                                                                                                                                                                                  |                     |         **X**         |                           **X** |{% endif %}
| [Actuar como propietario del código designado para un repositorio](/articles/about-code-owners)                                                                                                                                                                                                               |                     |         **X**         |                                 **X**                                  |
| [Marcar un borrador de solicitud de extracción como listo para revisión](/articles/changing-the-stage-of-a-pull-request)                                                                                                                                                                                      |                     |         **X**         |                                 **X**                                  |
| Solicitar [revisiones de solicitudes de extracción](/articles/requesting-a-pull-request-review)                                                                                                                                                                                                               |                     |         **X**         |                                 **X**                                  |
| Enviar revisiones que afecten la capacidad de fusión de una solicitud de extracción                                                                                                                                                                                                                           |                     |         **X**         |                                 **X**                                  |
| Aplicar cambios sugeridos a las solicitudes de extracción (consulta "[Incorporar opiniones en tu solicitud de extracción](/articles/incorporating-feedback-in-your-pull-request)" para obtener más detalles)                                                                                                  |                     |         **X**         |                                 **X**                                  |
| Crear [comprobaciones de estado](/articles/about-status-checks)                                                                                                                                                                                                                                               |                     |         **X**         |                                 **X**                                  |
| Crear y editar lanzamientos                                                                                                                                                                                                                                                                                   |                     |         **X**         |                                 **X**                                  |
| Ver lanzamientos en borrador                                                                                                                                                                                                                                                                                  |                     |         **X**         |                                 **X**                                  |
| Eliminar una propuesta (consulta "[Eliminar una propuesta](/articles/deleting-an-issue)")                                                                                                                                                                                                                     |                     |                       |                                 **X**                                  |
| Fusionar solicitudes de extracción en ramas protegidas, incluso si no existen revisiones en aprobación                                                                                                                                                                                                        |                     |                       |                                 **X**                                  |
| [Definir propietarios del código para un repositorio](/articles/about-code-owners)                                                                                                                                                                                                                            |                     |                       |                                 **X**                                  |
| Editar la descripción de un repositorio                                                                                                                                                                                                                                                                       |                     |                       |                                 **X**                                  |
| Administrar [temas](/articles/classifying-your-repository-with-topics)                                                                                                                                                                                                                                        |                     |                       | **X** |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.17" %}
| Crear y editar las tarjetas sociales del repositorio (consulta "[Personalizar la vista preliminar de las redes sociales del repositorio](/articles/customizing-your-repositorys-social-media-preview))                                                                                                        |                     |                       |                           **X** |{% endif %}
| Añadir un repositorio a un equipo (consulta la sección "[Administrar el acceso de un equipo a un repositorio de la organización](/github/setting-up-and-managing-organizations-and-teams/managing-team-access-to-an-organization-repository#giving-a-team-access-to-a-repository)" para obtener más detalles) |                     |                       |                                 **X**                                  |
| Administrar el acceso de un colaborador externo a un repositorio (consulta "[Agregar colaboradores externos a los repositorios de tu organización](/articles/adding-outside-collaborators-to-repositories-in-your-organization)" para obtener más detalles)                                                   |                     |                       |                **X** |{% if currentVersion == "free-pro-team@latest" %}
| Limitar las [interacciones en un repositorio](/github/building-a-strong-community/limiting-interactions-in-your-repository)                                                                                                                                                                                   |                     |                       |                           **X** |{% endif %}
| Cambiar la visibilidad de un repositorio (consulta "[Restringir cambios en la visibilidad del repositorio de tu organización](/articles/restricting-repository-visibility-changes-in-your-organization)" para obtener más detalles)                                                                           |                     |                       | **X** |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.17" %}
| Volver plantilla un repositorio (consulta "[Crear un repositorio de plantilla](/articles/creating-a-template-repository)")                                                                                                                                                                                    |                     |                       |                         | | **X** |{% endif %}
| Cambiar los parámetros de un repositorio                                                                                                                                                                                                                                                                      |                     |                       |                                 **X**                                  |
| Administrar el acceso de un equipo o colaborador al repositorio                                                                                                                                                                                                                                               |                     |                       |                                 **X**                                  |
| Editar la rama predeterminada del repositorio                                                                                                                                                                                                                                                                 |                     |                       |                                 **X**                                  |
| Administrar webhooks y desplegar llaves                                                                                                                                                                                                                                                                       |                     |                       |                **X** |{% if currentVersion == "free-pro-team@latest" %}
| [Habilitar el gráfico de dependencias](/github/visualizing-repository-data-with-graphs/exploring-the-dependencies-and-dependents-of-a-repository) de un repositorio privado                                                                                                                                   |                     |                       |                                 **X**                                  |
| Recibir [{% data variables.product.prodname_dependabot_alerts %} para las dependencias vulnerabiles](/github/managing-security-vulnerabilities/about-alerts-for-vulnerable-dependencies) en un repositorio                                                                                             |                     |                       |                                 **X**                                  |
| [Ignorar las {% data variables.product.prodname_dependabot_alerts %}](/github/managing-security-vulnerabilities/viewing-and-updating-vulnerable-dependencies-in-your-repository)                                                                                                                       |                     |                       |                                 **X**                                  |
| [Designar personas o equipos adicionales para que reciban las {% data variables.product.prodname_dependabot_alerts %}](/github/administering-a-repository/managing-security-and-analysis-settings-for-your-repository#granting-access-to-github-dependabot-alerts) para las dependencias vulnerables   |                     |                       |                                 **X**                                  |
| [Administrar la configuración de uso de datos para tu repositorio privado](/github/understanding-how-github-uses-and-protects-your-data/managing-data-use-settings-for-your-private-repository)                                                                                                               |                     |                       |          **X** |{% endif %}{% if currentVersion == "free-pro-team@latest" %}
| Crear [asesorías de seguridad](/github/managing-security-vulnerabilities/about-github-security-advisories)")                                                                                                                                                                                                  |                     |                       |                                 **X**                                  |{% endif %}
| [Administrar la política de bifurcación para un repositorio](/github/administering-a-repository/managing-the-forking-policy-for-your-repository)                                                                                                                                                              |                     |                       |                                 **X**                                  |
| Transferir repositorios a la cuenta de la organización (consulta "[Restringir la creación de repositorios en tu organización](/articles/restricting-repository-creation-in-your-organization)" para obtener más detalles)                                                                                     |                     |                       |                                 **X**                                  |
| Eliminar o transferir repositorios (consulta "[Establecer permisos para eliminar o transferir repositorios en tu organización](/articles/setting-permissions-for-deleting-or-transferring-repositories)" para obtener más detalles)                                                                           |                     |                       |                                 **X**                                  |
| [Archivar repositorios](/articles/about-archiving-repositories)                                                                                                                                                                                                                                               |                     |                       |                                 **X**                                  |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.18" %}
| Crear referencias de enlace automático a recursos externos, como JIRA o Zendesk (consulta "[Configurar enlaces automáticos para referenciar recursos externos](/articles/configuring-autolinks-to-reference-external-resources)"                                                                              |                     |                       |                         | | **X** |{% endif %}

{% endif %}

### Leer más

- [Administrar el acceso a los repositorios de tu organización](/articles/managing-access-to-your-organization-s-repositories)"
- "[Agregar colaboradores externos a repositorios de tu organización](/articles/adding-outside-collaborators-to-repositories-in-your-organization)"
- [Permisos de tablero de proyecto para una organización](/articles/project-board-permissions-for-an-organization)"
