---
title: Recursos de aprendizaje de Git y GitHub
redirect_from:
  - /articles/good-resources-for-learning-git-and-github/
  - /articles/what-are-other-good-resources-for-learning-git-and-github/
  - /articles/git-and-github-learning-resources
intro: 'Hay muchos recursos útiles de Git y {% data variables.product.product_name %} disponibles en la web. La siguientes es una pequeña lista de nuestros favoritos.'
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---

### Utilizar GitHub

Para familiarizarte con Git, visita el [sitio oficial del proyecto Git](https://git-scm.com) y lee el [libro electrónico Progit](http://git-scm.com/book). Puedes revisar la [lista de comandos de Git](https://git-scm.com/docs) o la [referencia para buscar comandos de Git](http://gitref.org) mientras usas el simulador [Try Git](https://try.github.com).

### Uso de {% data variables.product.product_name %}

{% if currentVersion == "free-pro-team@latest" %}

{% data variables.product.prodname_learning %} ofrece cursos interactivos gratuitos integrados en {% data variables.product.prodname_dotcom %} con evaluación y asistencia instantáneas y automatizadas. Aprende a abrir tu primera solicitud de extracción, hacer tu primera contribución de código abierto, crear un sitio {% data variables.product.prodname_pages %}, y mucho más. Para obtener más información acerca de los cursos ofrecidos, consulta [{% data variables.product.prodname_learning %}]({% data variables.product.prodname_learning_link %}).

{% endif %}

Adquiere más conocimientos con {% data variables.product.product_name %} a través de nuestros artículos de [seminario intensivo](/categories/bootcamp/). Consulta nuestro [ flujo de {% data variables.product.prodname_dotcom %}](https://guides.github.com/introduction/flow) para acceder a una introducción del proceso. Consulta nuestras [guías de descripción general](https://guides.github.com) para conocer nuestros conceptos básicos.

{% data reusables.support.ask-and-answer-forum %}

#### Ramas, bifurcaciones y solicitudes de extracción

Conoce más sobre las [ramas de Git](http://learngitbranching.js.org/) usando una herramienta interactiva. Lee más acerca de [bifrucaciones](/articles/about-forks) y [solicitudes de extracción](/articles/using-pull-requests), además de [cómo usar las solicitudes de extracción](https://github.com/blog/1124-how-we-use-pull-requests-to-build-github) en {% data variables.product.prodname_dotcom %}.

Accede a guías de referencia rápida acerca de la [línea de comando](https://hub.github.com) y de [guías de comprobación, hojas de referencia de {% data variables.product.prodname_dotcom %}, y mucho más](https://services.github.com/on-demand/resources).

#### Ponte al día

Nuestro {% data variables.product.prodname_dotcom %} [canal con guías y capacitación de YouTube](https://youtube.com/githubguides) ofrece tutoriales acerca de [solicitudes de extracción](https://www.youtube.com/watch?v=d5wpJ5VimSU&list=PLg7s6cbtAD15G8lNyoaYDuKZSKyJrgwB-&index=19), [ bifurcaciones](https://www.youtube.com/watch?v=5oJHRbqEofs), las funciones de [rebase](https://www.youtube.com/watch?v=SxzjZtJwOgo&list=PLg7s6cbtAD15G8lNyoaYDuKZSKyJrgwB-&index=22) y [reinicio](https://www.youtube.com/watch?v=BKPjPMVB81g). Cada tema se cubre en menos de 5 minutos.

### Capacitación

#### Clases gratuitas

{% data variables.product.product_name %} ofrece una serie de cursos de capacitación interactivos a pedido [on-demand training courses](https://services.github.com/on-demand/), entre otros, {% data variables.product.prodname_dotcom %} 101: [Introducción](https://services.github.com/on-demand/intro-to-github/), {% data variables.product.prodname_dotcom %} 102: [GitHub Desktop](https://services.github.com/on-demand/github-desktop) y {% data variables.product.prodname_dotcom %} 103: [Línea de comando](https://services.github.com/on-demand/github-cli).

#### Programas educativos basados en la web de {% data variables.product.prodname_dotcom %}

{% data variables.product.prodname_dotcom %} ofrece [capacitaciones](https://services.github.com/#upcoming-events) en vivo con un enfoque práctico basado en proyectos tanto para los amantes de la línea de comando como para quienes no están familiarizados con esta herramienta.

#### Capacitación para tu compañía

{% data variables.product.prodname_dotcom %} ofrece [clases presenciales](https://services.github.com/#offerings) a cargo de nuestros capacitadores sumamente experimentados. [Contáctanos](https://services.github.com/#contact) para que podamos responder tus preguntas relacionadas con la capacitación.

### Extras

Un [curso de Git en línea](http://www.codeschool.com/courses/git-real) interactivo de [Code School](http://codeschool.com) con siete niveles y muchos ejercicios en un formato amigable. Adapta libremente nuestras [plantillas .gitignore](https://github.com/github/gitignore) para que resuelvan tus necesidades.

Amplía el alcance de tu {% data variables.product.prodname_dotcom %} con[integraciones de {% if currentVersion == "free-pro-team@latest" %}](/articles/about-integrations){% else %}integraciones{% endif %}, o instala [{% data variables.product.prodname_desktop %}](https://desktop.github.com) y el poderoso editor de texto [Atom](https://atom.io).

Descubre cómo lanzar y hacer crecer tu proyecto de código abierto con las [Guías de código abierto](https://opensource.guide/).
