---
title: Encontrar maneras para colaborar con el código abierto en GitHub
intro: 'Puedes encontrar maneras de contribuir a los proyectos de código abierto en {% data variables.product.product_name %} que te parezcan relevantes.'
redirect_from:
  - /articles/where-can-i-find-open-source-projects-to-work-on/
  - /articles/finding-interesting-projects-on-github/
  - /articles/about-official-github-mirrors/
  - /articles/about-github-mirrors/
  - /articles/finding-open-source-projects-on-github
  - /github/getting-started-with-github/finding-open-source-projects-on-github
versions:
  free-pro-team: '*'
---

### Descubrir proyectos relevantes

Si hay un tema en particular que te interese, visita `github.com/topics/<topic>`. Por ejemplo, si te interesa el aprendizaje automático, puedes encontrar proyectos relevantes e informes de problemas iniciales si visitas https://github.com/topics/machine-learning. Puedes buscar temas populares si visitas [Temas](https://github.com/topics). También puedes buscar repositorios que empaten con algún tema que te interese. Para obtener más información, consulta "[Buscar repositorios](/articles/searching-for-repositories/#search-by-topic)".

Si has tenido actividad en {% data variables.product.product_name %} recientemente, puedes encontrar recomendaciones personalizadas para proyectos e informes de problemas iniciales que se basen en tus contribuciones, estrellas y otras actividades previas en [Explore](https://github.com/explore). También puedes registrarte para el boletín Explore para recibir correos electrónicos sobre las oportunidades disponibles para colaborar con {% data variables.product.product_name %} de acuerdo a tus intereses. Para registrarte, consulta [Boletín Explore por correo](https://github.com/explore/subscribe).

Mantente al tanto de las actividades recientes de los repositorios y personas que sigues en la sección "Toda la actividad" de tu tablero personal. Para obtener más información, consulta "[Acerca de tu tablero personal](/articles/about-your-personal-dashboard)".

{% data reusables.support.ask-and-answer-forum %}

### Encontrar informes de problemas iniciales

Si ya sabes en qué proyecto quieres trabajar, puedes encontrar informes de problemas aptos para principiantes en ese repositorio si visitas `github.com/<owner>/<repository>/contribute`. Como ejemplo, puedes encontrar cómo realizar tu primera contribución a `electron/electron` en https://github.com/electron/electron/contribute.

### Proyectos de código abierto con espejos en {% data variables.product.prodname_dotcom %}

Algunos proyectos de código abierto presentan espejos en {% data variables.product.prodname_dotcom_the_website %} además de sus repositorios oficiales, que se alojan en otro lugar.

Los siguientes son algunos de los repositorios más importantes que tienen sus espejos en {% data variables.product.prodname_dotcom_the_website %}:

- [android](https://github.com/android)
- [The Apache Software Foundation](https://github.com/apache)
- [The Chromium Project](https://github.com/chromium)
- [The Eclipse Foundation](https://github.com/eclipse)
- [The FreeBSD Project](https://github.com/freebsd)
- [The Glasgow Haskell Compiler](https://github.com/ghc)
- [GNOME](https://github.com/GNOME)
- [The Linux kernel source tree](https://github.com/torvalds/linux)
- [Qt](https://github.com/qt)

Para configurar tu propio espejo, puedes configurar [un gancho posrecepción](https://git-scm.com/book/en/Customizing-Git-Git-Hooks) en tu repositorio oficial del proyecto para subir automáticamente las confirmaciones a un repositorio espejo en {% data variables.product.product_name %}.

Puedes buscar repositorios en función de si tienen un espejo o no. Para obtener más información, consulta "[Buscar repositorios](/articles/searching-for-repositories/#search-based-on-whether-a-repository-is-a-mirror)".

### Leer más

- "[Clasificar tu repositorio con temas](/articles/classifying-your-repository-with-topics)"
- "[Acerca del tablero de tu organización](/articles/about-your-organization-dashboard)"
