---
title: Alcances para las Apps de OAuth
intro: '{% data reusables.shortdesc.understanding_scopes_for_oauth_apps %}'
redirect_from:
  - /apps/building-integrations/setting-up-and-registering-oauth-apps/about-scopes-for-oauth-apps/
  - /apps/building-oauth-apps/scopes-for-oauth-apps/
  - /apps/building-oauth-apps/understanding-scopes-for-oauth-apps
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---

Cuando estás configurando una App de OAuth en GitHub, los alcances solicitados se muestran al usuario en el formato de autorización.

{% note %}

**Nota:** Si estás creando una GitHub App, no necesitas proporcionar alcances en tu solicitud de autorización. Para obtener más información sobre esto, consulta la sección "[Identificar y autorizar usuarios para las GitHub Apps](/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/)".

{% endnote %}

{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.21" %}
Si tu {% data variables.product.prodname_oauth_app %} no tiene acceso a un buscador, tal como una herramienta de CLI, entonces no necesitarás especificar un alcance para que los usuarios se autentiquen dicha app. Para obtener más información, consulta la sección "[Autorizar las Apps de OAuth](/developers/apps/authorizing-oauth-apps#device-flow)".
{% endif %}

Verifica los encabezados para ver qué alcances de OAuth tienes, y cuáles acepta la acción de la API:

```shell
$ curl -H "Authorization: token OAUTH-TOKEN" {% data variables.product.api_url_pre %}/users/codertocat -I
HTTP/1.1 200 OK
X-OAuth-Scopes: repo, user
X-Accepted-OAuth-Scopes: user
```

* `X-OAuth-Scopes` lista los alcances que tu token tiene autorizados.
* `X-Accepted-OAuth-Scopes` lista los alcances que revisrá la acción.

### Alcances disponibles

| Nombre                   | Descripción                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| ------------------------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| **`(no scope)`**         | Otorga acceso de solo lectura a la información pública (incluye la información del perfil de usuario público, y los gists){% if currentVersion != "free-pro-team@latest" %}
| **`site_admin`**         | Otorga a los administradores de sitio acceso a las [Terminales de la API para la Administración de {% data variables.product.prodname_ghe_server %}](/v3/enterprise-admin).{% endif %}
| **`repo`**               | Otorga acceso completo a los repositorios públicos y privados. Esto incluye acceso de lectura/escritura al código, estados de las confirmaciones, proyectos de repositorio y de organización, invitaciones, colaboradores, agregar membrecías de equipo, estados de despliegue, y webhooks de repositorio para aquellos repositorios privados y públicos y para las organizaciones. También otorga la capacidad de administrar proyectos de usuario. |
| &emsp;`repo:status`      | Otorga acceso de lectura/escritura en los estados de confirmación de los repositorios privados. Este alcance solo se necesita para otorgar a otros usuarios o servicios el acceso a los estados de las confirmaciones en repositorios privados *sin* otorgarles acceso al código.                                                                                                                                                                    |
| &emsp;`repo_deployment`  | Otorga acceso a los [estados de despliegue](/v3/repos/deployments) para los repositorios públicos y privados. Este alcance solo se necesita para otorgar a otros usuarios o servicios el acceso a los estados de despliegue *sin* otorgarles acceso al código.                                                                                                                                                                                       |
| &emsp;`public_repo`      | Limita el acceso a los repositorios públicos. Esto incluye el acceso de lectura/escritura al código, estados de las confirmaciones, proyectos de repositorio, colaboradores y estados de despliegue para los repositorios públicos y para las organizaciones. También se requiere para marcar a los repositorios públicos con una estrella.                                                                                                          |
| &emsp;`repo:invite`      | Otorga capacidades de aceptar/rechazar las invitaciones para colaborar con un repositorio. Este alcance solo es necesario para otorgar a otros usuarios o servicios acceso a las invitaciones *sin* otorgar acceso al código.{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.21"%}
| &emsp;`security_events`  | Otorga acceso de lectura y escritura a los eventos de seguridad en la [API de {% data variables.product.prodname_code_scanning %}](/v3/code-scanning).{% endif %}
| **`admin:repo_hook`**    | Otorga acceso de lectura, escritura, ping y borrado a los ganchos de los repositorios privados y públicos. Los alcances `repo` y `public_repo` otorgan acceso completo a los repositorios, incluyendo a los ganchos de éstos. Utiliza el alcance `admin:repo_hook` para limitar el acceso únicamente a los ganchos de los repositorios.                                                                                                              |
| &emsp;`write:repo_hook`  | Otorga acceso de lectura, escritura y ping a los ganchos en los repositorios públicos o privados.                                                                                                                                                                                                                                                                                                                                                    |
| &emsp;`read:repo_hook`   | Otorga acceso de lectura y de ping a los ganchos en los repositorios privados o públicos.                                                                                                                                                                                                                                                                                                                                                            |
| **`admin:org`**          | Para administrar totalmente la organización y sus equipos, proyectos y membrecías.                                                                                                                                                                                                                                                                                                                                                                   |
| &emsp;`write:org`        | Acceso de lectura y escritura para la membrecía de organización y de los equipos y para los proyectos de la organización.                                                                                                                                                                                                                                                                                                                            |
| &emsp;`read:org`         | Acceso de solo lectura para la membrecía de organización y de los equipos y para los proyectos de la organización.                                                                                                                                                                                                                                                                                                                                   |
| **`admin:public_key`**   | Administrar totalmente las llaves públicas.                                                                                                                                                                                                                                                                                                                                                                                                          |
| &emsp;`write:public_key` | Crear, listar y ver los detalles de las llaves públicas.                                                                                                                                                                                                                                                                                                                                                                                             |
| &emsp;`read:public_key`  | Listar y ver los detalles para las llaves públicas.                                                                                                                                                                                                                                                                                                                                                                                                  |
| **`admin:org_hook`**     | Otorga acceso de lectura, escritura, ping y borrado para los ganchos de la organización. **Nota:** Los tokens de OAuth solo podrán realizar estas acciones en los ganchos de la organización los cuales haya creado la App de OAuth. Los tokens de acceso personal solo podrán llevar a cabo estas acciones en los ganchos de la organización que cree un usuario.                                                                                   |
| **`gist`**               | Otorga acceso de escritura a los gists.                                                                                                                                                                                                                                                                                                                                                                                                              |
| **`notificaciones`**     | Otorga: <br/>* acceso de lectura a las notificaciones de un usuario <br/>* acceso de marcar como leído en los hilos <br/>* acceso de observar y dejar de observar en un repositorio, y <br/>* acceso de lectura, escritura y borrado para las suscripciones a los hilos.                                                                                                                                                     |
| **`usuario`**            | Otorga acceso de lectura/escritura únicamente para la información de perfil.  Este alcance incluye a `user:email` y `user:follow`.                                                                                                                                                                                                                                                                                                                   |
| &emsp;`read:user`        | Otorga acceso para leer los datos de perfil de un usuario.                                                                                                                                                                                                                                                                                                                                                                                           |
| &emsp;`user:email`       | Otorga acceso de lectura para las direcciones de correo electrónico de un usuario.                                                                                                                                                                                                                                                                                                                                                                   |
| &emsp;`user:follow`      | Otorga acceso para seguir o dejar de seguir a otros usuarios.                                                                                                                                                                                                                                                                                                                                                                                        |
| **`delete_repo`**        | Otorga acceso para borrar los repositorios administrables.                                                                                                                                                                                                                                                                                                                                                                                           |
| **`write:discussion`**   | Permite el acceso de lectura y escritura para los debates de equipo.                                                                                                                                                                                                                                                                                                                                                                                 |
| &emsp;`read:discussion`  | Permite los accesos de lectura y escritura para los debates de equipo.{% if currentVersion == "free-pro-team@latest" %}
| **`write:packages`**     | Otorga acceso para cargar o publicar un paquete en el {% data variables.product.prodname_registry %}. Para obtener más información, consulta la sección "[Publicar un paquete](/github/managing-packages-with-github-packages/publishing-a-package)".                                                                                                                                                                                           |
| **`read:packages`**      | Otorga acceso para descargar o instalar paquetes desde el {% data variables.product.prodname_registry %}. Para obtener más información, consulta la sección "[Instalar un paquete](/github/managing-packages-with-github-packages/installing-a-package)".                                                                                                                                                                                       |
| **`delete:packages`**    | Otorga acceso para borrar paquetes del {% data variables.product.prodname_registry %}. Para obtener más información, consulta la sección "[Borrar paquetes](/github/managing-packages-with-github-packages/deleting-a-package)".{% endif %}
| **`admin:gpg_key`**      | Administra las llaves GPG totalmente.                                                                                                                                                                                                                                                                                                                                                                                                                |
| &emsp;`write:gpg_key`    | Crea, lista, y visualiza los detalles de las llaves GPG.                                                                                                                                                                                                                                                                                                                                                                                             |
| &emsp;`read:gpg_key`     | Lista y visualiza los detalles de las llaves GPG.{% if currentVersion == "free-pro-team@latest" %}
| **`flujo de trabajo`**   | Otorga la capacidad de agregar y actualizar archivos del flujo de trabajo de las {% data variables.product.prodname_actions %}. Los archivos de flujo de trabajo pueden confirmarse sin este alcance en caso de que el mismo archivo (con la misma ruta y el mismo contenido) exista en otra rama en el mismo repositorio.{% endif %}

{% note %}

**Nota:** Tu App de OAuth puede solicitar los alcances en la redirección inicial. Puedes especificar varios alcances si los separas con un espacio:

    https://github.com/login/oauth/authorize?
      client_id=...&
      scope=user%20public_repo

{% endnote %}

### Alcances solicitados y otorgados

El atributo `scope` lista los alcances adjuntos al token que otorgó el usuario. Normalmente, estos alcances serán idénticos a lo que solicitaste. Sin embargo, los usuarios pueden editar sus alcances, lo cual es efectivo para otorgar a tu organización menos accesos de lo que solicitaste originalmente. También, los usuarios puede editar los alcances de los tokens después de completar un flujo de OAuth. Debes estar consciente de esta posibilidad y ajustar el comportamiento de tu aplicación de acuerdo con esto.

Es importante gestionar los casos de error en donde un usuario elige otorgarte menos acceso de lo que solicitaste originalmente. Por ejemplo, las aplicaciones pueden advertir o comunicar de cualquier otra forma a sus usuarios si experimentarán funcionalidad reducida o si serán incapaces de realizar alguna acción.

También, las aplicaciones siempre pueden enviar nuevamente de regreso a los usuarios a través del flujo para obtener permisos adicionales, pero no olvides que dichos usuarios siempre pueden rehusarse a hacerlo.

Revisa la sección [Guía de aspectos básicos de la autenticación](/guides/basics-of-authentication/), la cual proporciona consejos sobre la gestión de alcances modificables de los tokens.

### Alcances normalizados

Cuando solicites alcances múltiples, el token se guarda con una lista de alcances normalizada y descarta aquellos que se otro alcance solicitado incluya implícitamente. Por ejemplo, el solicitar `user,gist,user:email` dará como resultado un token con alcances de `user` y de `gist` únicamente, ya que el acceso que se otorga con el alcance `user:email` se incluye en el alcance `user`.
