---
title: Diferencias entre GitHub Apps y Apps de OAuth
intro: 'El entender las diferencias entre {% data variables.product.prodname_github_app %} y {% data variables.product.prodname_oauth_app %} te ayudará a decidir qué app quieres crear. Una {% data variables.product.prodname_oauth_app %} actúa como un usuario de Github, mientras que una {% data variables.product.prodname_github_app %} utiliza su propia identidad cuando se instala en una organización o en repositorios dentro de una organización.'
redirect_from:
  - /early-access/integrations/integrations-vs-oauth-applications/
  - /apps/building-integrations/setting-up-a-new-integration/about-choosing-an-integration-type/
  - /apps/differences-between-apps
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---

### ¿Quién puede instalar GitHub Apps y autorizar Apps de OAuth?

Puedes instalar GitHub Apps en tu cuenta personal o en las organizaciones que te pertenezcan. Si tienes permisos administrativos en un repositorio, puedes instalar GitHub Apps en las cuentas de la organización. Si se instala una GitHub App en un repositorio y requiere permisos de organización, el propietario de la organización deberá aprobar la aplicación.

{% data reusables.apps.app_manager_role %}

Por el contrario, los usuarios _autorizan_ las Apps de OAuth, lo cual otorga a estas apps la capacidad de actuar como un usuario autenticado. Por ejemplo, puedes autorizar una App de OAuth que encuentre todas las notificaciones para el usuario autenticado. Siempre puedes retirar los permisos de las Apps de OAuth.

{% data reusables.apps.deletes_ssh_keys %}

| GitHub Apps                                                                                                                                                                                                                                                                                          | OAuth Apps                                                                                                                                                                                                                                      |
| ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| Debes ser un propietario de la organización o tener permisos administrativos en un repositorio para instalar una GitHub App en una organización. Si se instala una GitHub App en un repositorio y requiere permisos de organización, el propietario de la organización deberá aprobar la aplicación. | Puedes autorizar una app de OAuth para que tenga acceso a los recursos.                                                                                                                                                                         |
| Puedes instalar una GitHu App en tu repositorio personal.                                                                                                                                                                                                                                            | Puedes autorizar una app de OAuth para que tenga acceso a los recursos.                                                                                                                                                                         |
| Debes ser un propietario de la organización, propietario del repositorio personal, o tener permisos administrativos en un repositorio para desinstalar una GitHub App y eliminar su acceso.                                                                                                          | Puedes borrar un token de acceso de OAuth para eliminar el acceso.                                                                                                                                                                              |
| Debes ser un propietario de la organización o tener permisos administrativos en un repositorio para solicitar la instalación de una GitHub App.                                                                                                                                                      | Si está activa una política de aplicación organizacional, cualquier miembro de la organización puede solicitar la instalación de una App de OAuth en dicha organización. Un propietario de la organización deberá aprobar o negar la solicitud. |

### ¿A qué recursos pueden acceder las GitHub Apps y las Apps de OAuth?

Los propietarios de las cuentas pueden utilizar una {% data variables.product.prodname_github_app %} en una cuenta sin otorgarle acceso a otra cuenta. Por ejemplo, puedes instalar un servicio de compilación de terceros en la organización de tu patrón laboral, pero puedes decidir no otorgar a esa compilación acceso de servicio a los repositorios en tu cuenta personal. Una GitHub App permanece instalada si la persona que la configuró deja a la organización.

Una App de OAuth _autorizada_ tiene acceso a todos los recursos que son accesibles para el usuario o el propietario de la organización.

| GitHub Apps                                                                                                                                                                                        | OAuth Apps                                                                                                                                                                                                                                                                                                                                    |
| -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| Instalar la GitHub App le otorga acceso a la misma en los repositorios elegidos de la cuenta de usuario o de organización.                                                                         | Autorizar una App de OAuth otorga a dicha app acceso a los recursos que puede acceder el usuario. Por ejemplo, a los repositorios que puede acceder.                                                                                                                                                                                          |
| El token de instalación de una GitHub App pierde acceso a los recursos si un administrador elimina los repositorios de la instalación.                                                             | Un token de acceso de OAuth pierde acceso a los recursos cuando el usuario mismo pierde acceso a ellos, como cuando pierden el acceso de escritura a un repositorio.                                                                                                                                                                          |
| Los tokens de acceso de la instalación se limitan a los repositorios especificados con los permisos que escogió el creador de la app.                                                              | Un token de acceso de OAuth se limita por alcances.                                                                                                                                                                                                                                                                                           |
| Las GitHub Apps pueden solicitar acceso por separado a los informes de problemas y a las solicitudes de extracción sin acceder al contenido real del repositorio.                                  | Las Apps de OAuth necesitan solicitar el alcance de `repo` para obtener acceso a los informes de problemas, solicitudes de extracción, o a cualquier recurso que pertenezca al repositorio.                                                                                                                                                   |
| Las GitHub Apps no están sujetas a las políticas de aplicación de la organización. Una GitHub app solo tendrá acceso a los repositorios que haya otorgado el propietario de una organización.      | Si una política de aplicación de la organización se encuentra activa, únicamente el propietario de la organización podrá autorizar la instalación de una App de OAuth. Si se instala, la App de OAuth obtiene acceso a todo lo que esté visible para el token que tiene el propietario de la organización dentro de la organización aprobada. |
| Las GitHub Apps reciben un evento de webhook cuando se cambia o elimina una instalación. Esto indica al creador de la app cuando han recibido más o menos accesos a los recursos organizacionales. | Las Apps de OAuth pueden perder el acceso a una organización o a un repositorio en cualquier momento con base en acceso cambiante del usuario que otorga los permisos. La App de OAuth no te informará cuando pierde el acceso a un recurso.                                                                                                  |

### Identificación basada en tokens

{% note %}

**Nota:** Las GitHub Apps también pueden utilizar un token basado en un usuario. Para obtener más información, consulta la sección "[Identificar y autorizar usuarios para las GitHub Apps](/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/)".

{% endnote %}

| GitHub Apps                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | OAuth Apps                                                                                                                                                                                                                                                                                                                                           |
| -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| Una GitHub App puede solicitar un token de acceso de la instalación si utiilza una llave privada con un formato de token web de JSON fuera de banda.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | Una App de OAuth puede intercambiar un token de solicitud por un token de acceso después de una redirección a través de una solicitud web.                                                                                                                                                                                                           |
| Un token de instalación identifica a la app como el bot de las GitHub Apps, tal como el @jenkins-bot.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | Un token de acceso identifica a la app como el usuario que otorgó el token para la app, tal como el @octocat.                                                                                                                                                                                                                                        |
| Los tokens de instalación caducan después de un tiempo predefinido (actualmente, 1 hora).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | Los tokens de OAuth permanecen activos hasta que el cliente los revoque.                                                                                                                                                                                                                                                                             |
| {% data reusables.apps.api-rate-limits-non-ghec %}{% if currentVersion == "free-pro-team@latest" %} Se aplican límites de tasa más altos para {% data variables.product.prodname_ghe_cloud %}. Para obtener más información, consulta la sección "[Límites de tasa para las GitHub Apps](/developers/apps/rate-limits-for-github-apps)".{% endif %}                                                                                                                                                                                                                                                                                                                                              | Los tokens de OAuth utilizan el límite de tasa del usuario de 5,000 solicitudes por hora.                                                                                                                                                                                                                                                            |
| Pueden otorgarse incrementos en el límite de tasa tanto a nivel de las GitHub Apps (lo cual afecta a todas las instalaciones) como a nivel de la instalación individual.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | Los incrementos en el límite de tasa se otorgan por cada App de OAuth. Cada token que se otorgue a esa App de OAuth obtiene el límite incrementado. |{% if currentVersion == "free-pro-team@latest" or currentVersion ver_gt "enterprise-server@2.21" %}
| Las {% data variables.product.prodname_github_app %} pueden autenticarse a nombre del usuario y a esto se le llama solicitudes de usuario a servidor. El flujo para autorizaciones es el mismo que aquél de las autorizaciones para las apps de OAuth. Los tokens de usuario a servidor pueden caducar y renovarse con un token de actualización. Para obtener más información, consulta las secciones "[Actualizar un token de acceso de usuario a servidor](/apps/building-github-apps/refreshing-user-to-server-access-tokens/)" y "[Identificar y autorizar a los usuarios para las GitHub Apps](/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/)". | El flujo de OAuth que utilizan las {% data variables.product.prodname_oauth_app %} autoriza a una {% data variables.product.prodname_oauth_app %} a nombre del usuario. Este es el mismo flujo que se utiliza en las autorizaciones de usuario a servidor de una {% data variables.product.prodname_github_app %}. |{% endif %}

### Solicitar niveles de permiso para recursos

A diferencia de las apps de OAuth, las GitHub Apps tiene permisos específicos que les permiten solicitar acceso únicamente a lo que necesitan. Por ejemplo, una GitHub App de Integración Continua (IC) puede solicitar acceso de lectura al contenido del repositorio y acceso de escritura la API de estado. Puede que alguna otra GitHub App no tenga acceso de escritura o lectura al código, pero aún podrá administrar informes de problemas, etiquetas e hitos. Las Apps de OAuth no pueden utilizar permisos granulares.

| Acceso                                                                | GitHub Apps (permisos de `read` o `write`)                       | OAuth Apps                                    |
| --------------------------------------------------------------------- | ---------------------------------------------------------------- | --------------------------------------------- |
| **Para acceder a los repositorios públicos**                          | El repositorio público necesita elegirse durante la instalación. | alcance `public_repo`.                        |
| **Para acceder al código/contenido del repositorio**                  | Contenidos del repositorio                                       | alcance `repo`.                               |
| **Para acceder a informes de problemas, etiquetas e hitos**           | Problemas                                                        | alcance `repo`.                               |
| **Para acceder a solicitudes de extracción, etiquetas e hitos**       | Solicitudes de extracción                                        | alcance `repo`.                               |
| **Para acceder a estados de confirmación (para compilaciones de IC)** | Estados de confirmación                                          | alcance `repo:status`.                        |
| **Para acceder a los despliegues y estados de despliegue**            | Implementaciones                                                 | alcance `repo_deployment`.                    |
| **Para recibir eventos a través de un webhook**                       | Las GitHub Apps incluyen un webhook predeterminadamente.         | alcance `write:repo_hook` o `write:org_hook`. |

### Descubrimiento de repositorios

| GitHub Apps                                                                                                                   | OAuth Apps                                                                                                                                                                     |
| ----------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| Las GitHub Apps pueden ver a `/installation/repositories` para encontrar repositorios a los que puede acceder la instalación. | Las Apps de OAuth pueden ver a `/user/repos` para tener una vista de tipo usuario o a `/orgs/:org/repos` para tener una de tipo organización para los repositorios accesibles. |
| Las Github Apps reciben webhooks cuando los repositorios se agregan o eliminan de la instalación.                             | Las Apps de OAuth crean webhooks de organización para las notificaciones cuando se crea un repositorio nuevo dentro de una organización.                                       |

### Webhooks

| GitHub Apps                                                                                                                                                           | OAuth Apps                                                                                                                                                                                      |
| --------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| Predeterminadamente, las GitHub Apps tienen un solo webhook que recibe los eventos que se les ha configurado para recibir para cada repositorio al que tengan acceso. | Las Apps de OAuth solicitan el alcance de webhook para crear un webhook de repositorio para cada repositorio del cual necesiten recibir eventos.                                                |
| Las GitHub Apps reciben algunos eventos a nivel organizacional con el permiso del miembro de la organización.                                                         | Las Apps de OAuth solicitan el alcance de webhook de la organización para crear un webhook de organización para cada organización de la cual necesiten recibir eventos de nivel organizacional. |

### Acceso a Git

| GitHub Apps                                                                                                                                                                                                                                                     | OAuth Apps                                                                                                                                                                                                         |
| --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| Las GitHub Apps solicitan permiso a los contenidos del repositorio y utilizan tu token de instalación para autenticarte a través de [Git basado en HTTP](/apps/building-github-apps/authenticating-with-github-apps/#http-based-git-access-by-an-installation). | Las Apps de OAuth piden el alcance `write:public_key` y [Crean una llave de despliegue](/v3/repos/keys/#create-a-deploy-key) a través de la API. Entonces puedes utilizar esa llave para ejecutar comandos de Git. |
| El token se utiliza como la contraseña HTTP.                                                                                                                                                                                                                    | El token se utiliza como el nombre de usuario HTTP.                                                                                                                                                                |

### Cuentas de máquina vs cuentas de bot

Las cuentas de usuario de máquina son cuentas de usuario basadas en OAuth que segregan sistemas automatizados utilizando el sistema de usuarios de GitHub.

Las cuentas de bot son específicas para las GitHub Apps y se crean en cada GitHub App.

| GitHub Apps                                                                                                              | OAuth Apps                                                                                                              |
| ------------------------------------------------------------------------------------------------------------------------ | ----------------------------------------------------------------------------------------------------------------------- |
| Los bots de las GitHub Apps no consumen una plaza de {% data variables.product.prodname_enterprise %}.              | Una cuenta de usuario de máquina consume una plaza de {% data variables.product.prodname_enterprise %}.            |
| Ya que jamás se otorga una contraseña a un bot de una GitHub App, un cliente no podrá iniciar sesión directamente en él. | Una cuenta de usuario de máquina obtiene un nombre de usuario y contraseña para que el cliente lo administre y asegure. |
