---
title: Crear una GitHub App utilizando parámetros de URL
intro: 'Puedes preseleccionar los ajustes de una nueva {% data variables.product.prodname_github_app %} utilizando [parámetros de consulta] de una URL (https://en.wikipedia.org/wiki/Query_string) para configurar rápidamente los nuevos ajustes de la {% data variables.product.prodname_github_app %}.'
redirect_from:
  - /apps/building-github-apps/creating-github-apps-using-url-parameters
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---


### Acerca de los parámetros de URL de las {% data variables.product.prodname_github_app %}

Puedes agregar parámetros de consulta a estas URL para preseleccionar la configuración de una {% data variables.product.prodname_github_app %} en una cuenta organizacional o personal:
* **Cuenta de usuario:** `https://github.com/settings/apps/new`
* **Cuenta de organización:** `https://github.com/organizations/:org/settings/apps/new`

El creador de la app puede editar los valores preseleccionados desde la página de registro de la {% data variables.product.prodname_github_app %} antes de emitirla. Si no incluyes los parámetros requeridos en la secuencia de consulta de la URL, como el `name`, el creador de la app necesitará ingresar un valor antes de emitirla.

La siguiente URL crea una app pública nueva que se llama `octocat-github-app` con una descripción preconfigurada y una URL de rellamado. Esta URL también selecciona los permisos de lectura y escritura para las `checks`, se suscribe a los eventos de webhook de `check_run` y `check_suite`, y selecciona la opción para solicitar la autorización del usuario (OAuth) durante la instalación:

  ```
  https://github.com/settings/apps/new?name=octocat-github-app&description=An%20Octocat%20App&callback_url=https://example.com&request_oauth_on_install=true&public=true&checks=write&events[]=check_run&events[]=check_suite
  ```

La lista completa de parámetros de consulta, permisos y eventos disponibles se lista en las secciones siguientes.

### Parámetros de configuración de una {% data variables.product.prodname_github_app %}

 | Nombre                     | Tipo                     | Descripción                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
 | -------------------------- | ------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
 | `name (nombre)`            | `secuencia`              | El nombre de la {% data variables.product.prodname_github_app %}. Pónle un nombre claro y breve a tu app. Tu app no puede tener el mismo nombre que un usuario de GitHub, a menos de que sea tu propio nombre de usuario u organización. Una versión simplificada del nombre de tu aplicación se mostrará en la interface de usuario cuando tu integración tome alguna acción.                                                                                                                                                                                     |
 | `descripción`              | `secuencia`              | Una descripción de la {% data variables.product.prodname_github_app %}.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
 | `url`                      | `secuencia`              | La URL complea de la página principal del sitio web de tu {% data variables.product.prodname_github_app %}.                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
 | `callback_url`             | `secuencia`              | La URL completa a la cual se redirigirá después de que alguien autorice la instalación. Esta URL se utiliza si tu app necesita identificar y autorizar las solicitudes de usuario a servidor.                                                                                                                                                                                                                                                                                                                                                                             |
 | `request_oauth_on_install` | `boolean`                | Si tu app autoriza a los usuarios mediante el flujo de OAuth, puedes configurar esta opción como `true` para permitir que las personas autoricen la app cuando la instalen, lo cual te ahorra un paso. Si seleccionas esta opción, la `setup_url` deja de estar disponible y se redirigirá a los usuarios a tu `callback_url` después de que instalen la app.                                                                                                                                                                                                             |
 | `setup_url`                | `secuencia`              | La URL completa a la cual se redirigirá después de que instalen la {% data variables.product.prodname_github_app %} si ésta requiere de alguna configuración adicional después de su instalación.                                                                                                                                                                                                                                                                                                                                                                  |
 | `setup_on_update`          | `boolean`                | Configúralo como `true` para redireccionar a las personas a la URL de ajustes cuando las instalaciones se actualicen, por ejemplo, después de que se agreguen o eliminen repositorios.                                                                                                                                                                                                                                                                                                                                                                                    |
 | `public`                   | `boolean`                | Configúralo como `true` cuando tu {% data variables.product.prodname_github_app %} se encuentre disponible al público, o como `false` cuando solo el propietario de la misma tenga acceso a ella.                                                                                                                                                                                                                                                                                                                                                                  |
 | `webhook_url`              | `secuencia`              | La URL completa a la cual quisieras enviar cargas útiles de eventos de webhook.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
 | `webhook_secret`           | `secuencia`              | Puedes especificar un secreto para asegurar tus webhooks. Consulta la sección "[Asegurar tus webhooks](/webhooks/securing/)" para obtener más detalles.                                                                                                                                                                                                                                                                                                                                                                                                                   |
 | `eventos`                  | `conjunto de secuencias` | Eventos de webhook. Algunos eventos de webhook requieren asignar permisos de `read` o de `write` a un recurso antes de que puedas seleccionar el evento cuando registras una {% data variables.product.prodname_github_app %} nueva. Consulta la sección "[Eventos de webhook de las {% data variables.product.prodname_github_app %}](#github-app-webhook-events)" para encontrar los eventos disponibles y sus permisos requeridos. Puedes seleccionar eventos múltiples en una secuencia de consulta. Por ejemplo, `events[]=public&events[]=label`. |
 | `dominio`                  | `secuencia`              | La URL de una referencia de contenido.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
 | `single_file_name`         | `secuencia`              | Cuando otorgas acceso de `read` o de `write` al permiso de `single_file`, este campo proporciona la ruta al archivo único que administrará tu {% data variables.product.prodname_github_app %}.                                                                                                                                                                                                                                                                                                                                                                    |

### Permisos de la {% data variables.product.prodname_github_app %}

Puedes seleccionar los permisos en una secuencia de consulta utilizando los nombres de permiso conforme en la siguiente tabla a manera de nombres de parámetro de consulta y usando el tipo de permiso como el valor de la consulta. Por ejemplo, para seleccionar los permisos de `Read & write` en la interface de usuario para `contents`, tu secuencia de consulta incluiría `&contents=write`. Para seleccionar los permisos de `Read-only` en la interface de usuario para `blocking`, tu secuencia de consulta incluiría `&blocking=read`. Para seleccionar `no-access` en la interface de usuario para las `checks`, tu secuencia de consulta no incluiría el permiso `checks`.

| Permiso                                                                                                                          | Descripción                                                                                                                                                                                                                                                                                                               |
| -------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [`administración`](/rest/reference/permissions-required-for-github-apps/#permission-on-administration)                           | Otorga acceso a diversas terminales para la administración de organizaciones y repositorios. Puede ser uno de entre: `none`, `read`, o `write`.{% if currentVersion == "free-pro-team@latest" %}
| [`blocking`](/rest/reference/permissions-required-for-github-apps/#permission-on-blocking)                                       | Otorga acceso a la [API de Bloqueo de Usuarios](/v3/users/blocking/). Puede ser uno de entre: `none`, `read`, o `write`.{% endif %}
| [`verificaciones`](/rest/reference/permissions-required-for-github-apps/#permission-on-checks)                                   | Otorga acceso a la [API de verificaciones](/v3/checks/). Puede ser uno de entre `none`, `read`, o `write`.                                                                                                                                                                                                                |
| `content_references`                                                                                                             | Otorga acceso a la terminal "[Crear un adjunto de contenido](/v3/apps/installations/#create-a-content-attachment)". Puede ser uno de entre `none`, `read`, o `write`.                                                                                                                                                     |
| [`contenidos`](/rest/reference/permissions-required-for-github-apps/#permission-on-contents)                                     | Otorga acceso a diversas terminales que te permiten modificar el contenido de los repositorios. Puede ser uno de entre `none`, `read`, o `write`.                                                                                                                                                                         |
| [`implementaciones`](/rest/reference/permissions-required-for-github-apps/#permission-on-deployments)                            | Otorga acceso a la [API de despliegues](/v3/repos/deployments/). Puede ser uno de entre `none`, `read`, o `write`.                                                                                                                                                                                                        |
| [`correos electrónicos`](/rest/reference/permissions-required-for-github-apps/#permission-on-emails)                             | Otorga acceso a la [API de Correos electrónicos](/v3/users/emails/). Puede ser uno de entre `none`, `read`, o `write`.                                                                                                                                                                                                    |
| [`seguidores`](/rest/reference/permissions-required-for-github-apps/#permission-on-followers)                                    | Otorga acceso a la [API de Seguidores](/v3/users/followers/). Puede ser uno de entre `none`, `read`, o `write`.                                                                                                                                                                                                           |
| [`claves_gpg`](/rest/reference/permissions-required-for-github-apps/#permission-on-gpg-keys)                                     | Otorga acceso a la [API de Llaves GPG](/v3/users/gpg_keys/). Puede ser uno de entre `none`, `read`, o `write`.                                                                                                                                                                                                            |
| [`propuestas`](/rest/reference/permissions-required-for-github-apps/#permission-on-issues)                                       | Otorga acceso a la [API de Informe de problemas](/v3/issues/). Puede ser uno de entre `none`, `read`, o `write`.                                                                                                                                                                                                          |
| [`keys`](/rest/reference/permissions-required-for-github-apps/#permission-on-keys)                                               | Otorga acceso a la [API de Llaves Públicas](/v3/users/keys/). Puede ser uno de entre `none`, `read`, o `write`.                                                                                                                                                                                                           |
| [`members`](/rest/reference/permissions-required-for-github-apps/#permission-on-members)                                         | Otorga acceso para administrar los miembros de una organización. Puede ser uno de entre: `none`, `read`, o `write`.{% if currentVersion == "free-pro-team@latest" %}
| [`metadatos`](/rest/reference/permissions-required-for-github-apps/#metadata-permissions)                                        | Otorga acceso a las terminales de solo lectura que no filtran datos sensibles. Puede ser `read` o `none`. Su valor predeterminado es `read` cuando configuras cualquier permiso, o bien, `none` cuando no especificas ningún permiso para la {% data variables.product.prodname_github_app %}.                     |
| [`organization_administration`](/rest/reference/permissions-required-for-github-apps/#permission-on-organization-administration) | Otorga acceso a la terminal "[Actualizar una organización](/v3/orgs/#update-an-organization)" y a la [API de Restricciones de Interacción en la Organización](/v3/interactions/orgs/#set-interaction-restrictions-for-an-organization). Puede ser uno de entre: `none`, `read`, o `write`.{% endif %}
| [`organization_hooks`](/rest/reference/permissions-required-for-github-apps/#permission-on-organization-hooks)                   | Otorga acceso a la [API de Webhooks de la Organización](/v3/orgs/hooks/). Puede ser uno de entre `none`, `read`, o `write`.                                                                                                                                                                                               |
| `organization_plan`                                                                                                              | Otorga acceso para obtener información acerca del plan de una organización que utilice la terminal "[Obtener una organización](/v3/orgs/#get-an-organization)". Puede ser uno de entre `none` o `read`.                                                                                                                   |
| [`organization_projects`](/rest/reference/permissions-required-for-github-apps/#permission-on-organization-projects)             | Otorga acceso a la [API de Proyectos](/v3/projects/). Puede ser uno de entre: `none`, `read`, `write`, o `admin`.{% if currentVersion == "free-pro-team@latest" %}
| [`organization_user_blocking`](/rest/reference/permissions-required-for-github-apps/#permission-on-organization-projects)        | Otorga acceso a la [API de Bloqueo de Usuarios de la Organización](/v3/orgs/blocking/). Puede ser uno de entre: `none`, `read`, o `write`.{% endif %}
| [`páginas`](/rest/reference/permissions-required-for-github-apps/#permission-on-pages)                                           | Otorga acceso a la [API de páginas](/v3/repos/pages/). Puede ser uno de entre `none`, `read`, o `write`.                                                                                                                                                                                                                  |
| `plan`                                                                                                                           | Otorga acceso para obtener información acerca del plan de GitHub de un usuario que utilice la terminal "[Obtener un usuario](/v3/users/#get-a-user)". Puede ser uno de entre `none` o `read`.                                                                                                                             |
| [`pull_requests`](/rest/reference/permissions-required-for-github-apps/#permission-on-pull-requests)                             | Otorga acceso a varias terminales de solicitud de extracción. Puede ser uno de entre `none`, `read`, o `write`.                                                                                                                                                                                                           |
| [`repository_hooks`](/rest/reference/permissions-required-for-github-apps/#permission-on-repository-hooks)                       | Otorga acceso a la [API de Webhooks del Repositorio](/v3/repos/hooks/). Puede ser uno de entre `none`, `read`, o `write`.                                                                                                                                                                                                 |
| [`repository_projects`](/rest/reference/permissions-required-for-github-apps/#permission-on-repository-projects)                 | Otorga acceso a la [API de Proyectos](/v3/projects/). Puede ser uno de entre: `none`, `read`, `write`, o `admin`.                                                                                                                                                                                                         |
| [`single_file`](/rest/reference/permissions-required-for-github-apps/#permission-on-single-file)                                 | Otorga acceso a la [API de Contenidos](/v3/repos/contents/). Puede ser uno de entre `none`, `read`, o `write`.                                                                                                                                                                                                            |
| [`starring`](/rest/reference/permissions-required-for-github-apps/#permission-on-starring)                                       | Otorga acceso a la [API de marcar con estrella](/v3/activity/starring/). Puede ser uno de entre `none`, `read`, o `write`.                                                                                                                                                                                                |
| [`estados`](/rest/reference/permissions-required-for-github-apps/#permission-on-statuses)                                        | Otorga acceso a la [API de Estados](/v3/repos/statuses/). Puede ser uno de entre `none`, `read`, o `write`.                                                                                                                                                                                                               |
| [`team_discussions`](/rest/reference/permissions-required-for-github-apps/#permission-on-team-discussions)                       | Otorga acceso a la [API de debates de equipo](/v3/teams/discussions/) y a la [API de comentarios en debates de equipo](/v3/teams/discussion_comments/). Puede ser uno de entre `none`, `read`, o `write`.                                                                                                                 |
| `vulnerability_alerts`                                                                                                           | Otorga acceso para recibir alertas de seguridad para las dependencias vulnerables en un repositorio. Consulta la sección "[Acerca de las alertas de seguridad para las dependencias vulnerables](/articles/about-security-alerts-for-vulnerable-dependencies)" para aprender más. Puede ser uno de entre `none` o `read`. |
| `observación`                                                                                                                    | Otorga acceso a la lista y cambia los repositorios a los que un usuario está suscrito. Puede ser uno de entre `none`, `read`, o `write`.                                                                                                                                                                                  |

### Eventos de webhook de {% data variables.product.prodname_github_app %}

| Nombre del evento de webhook                                                                                 | Permiso requerido                               | Descripción                                                                                         |
| ------------------------------------------------------------------------------------------------------------ | ----------------------------------------------- | --------------------------------------------------------------------------------------------------- |
| [`check_run`](/webhooks/event-payloads/#check_run)                                                           | `verificaciones`                                | {% data reusables.webhooks.check_run_short_desc %}                                           |
| [`check_suite`](/webhooks/event-payloads/#check_suite)                                                       | `verificaciones`                                | {% data reusables.webhooks.check_suite_short_desc %}                                          |
| [`comentario_confirmación de cambios`](/webhooks/event-payloads/#commit_comment)                             | `contenidos`                                    | {% data reusables.webhooks.commit_comment_short_desc %}                                      |
| [`content_reference`](/webhooks/event-payloads/#content_reference)                                           | `content_references`                            | {% data reusables.webhooks.content_reference_short_desc %}                                   |
| [`create (crear)`](/webhooks/event-payloads/#create)                                                         | `contenidos`                                    | {% data reusables.webhooks.create_short_desc %}                                              |
| [`eliminar`](/webhooks/event-payloads/#delete)                                                               | `contenidos`                                    | {% data reusables.webhooks.delete_short_desc %}                                              |
| [`deployment`](/webhooks/event-payloads/#deployment)                                                         | `implementaciones`                              | {% data reusables.webhooks.deployment_short_desc %}                                          |
| [`deployment_status`](/webhooks/event-payloads/#deployment_status)                                           | `implementaciones`                              | {% data reusables.webhooks.deployment_status_short_desc %}                                   |
| [`bifurcación`](/webhooks/event-payloads/#fork)                                                              | `contenidos`                                    | {% data reusables.webhooks.fork_short_desc %}                                                |
| [`gollum`](/webhooks/event-payloads/#gollum)                                                                 | `contenidos`                                    | {% data reusables.webhooks.gollum_short_desc %}                                              |
| [`propuestas`](/webhooks/event-payloads/#issues)                                                             | `propuestas`                                    | {% data reusables.webhooks.issues_short_desc %}                                              |
| [`comentario_propuesta`](/webhooks/event-payloads/#issue_comment)                                            | `propuestas`                                    | {% data reusables.webhooks.issue_comment_short_desc %}                                       |
| [`etiqueta`](/webhooks/event-payloads/#label)                                                                | `metadatos`                                     | {% data reusables.webhooks.label_short_desc %}                                               |
| [`member`](/webhooks/event-payloads/#member)                                                                 | `members`                                       | {% data reusables.webhooks.member_short_desc %}                                              |
| [`membership`](/webhooks/event-payloads/#membership)                                                         | `members`                                       | {% data reusables.webhooks.membership_short_desc %}                                          |
| [`hito`](/webhooks/event-payloads/#milestone)                                                                | `solicitud_extracción`                          | {% data reusables.webhooks.milestone_short_desc %}{% if currentVersion == "free-pro-team@latest" %}
| [`org_block`](/webhooks/event-payloads/#org_block)                                                           | `organization_administration`                   | {% data reusables.webhooks.org_block_short_desc %}{% endif %}
| [`organización`](/webhooks/event-payloads/#organization)                                                     | `members`                                       | {% data reusables.webhooks.organization_short_desc %}                                        |
| [`page_build`](/webhooks/event-payloads/#page_build)                                                         | `páginas`                                       | {% data reusables.webhooks.page_build_short_desc %}                                          |
| [`project`](/webhooks/event-payloads/#project)                                                               | `repository_projects` u `organization_projects` | {% data reusables.webhooks.project_short_desc %}                                             |
| [`project_card`](/webhooks/event-payloads/#project_card)                                                     | `repository_projects` u `organization_projects` | {% data reusables.webhooks.project_card_short_desc %}                                        |
| [`project_column`](/webhooks/event-payloads/#project_column)                                                 | `repository_projects` u `organization_projects` | {% data reusables.webhooks.project_column_short_desc %}                                      |
| [`public`](/webhooks/event-payloads/#public)                                                                 | `metadatos`                                     | {% data reusables.webhooks.public_short_desc %}                                              |
| [`solicitud_extracción`](/webhooks/event-payloads/#pull_request)                                             | `pull_requests`                                 | {% data reusables.webhooks.pull_request_short_desc %}                                        |
| [`revisión_solicitud de extracción`](/webhooks/event-payloads/#pull_request_review)                          | `solicitud_extracción`                          | {% data reusables.webhooks.pull_request_review_short_desc %}                               |
| [`comentarios _revisiones_solicitudes de extracción`](/webhooks/event-payloads/#pull_request_review_comment) | `solicitud_extracción`                          | {% data reusables.webhooks.pull_request_review_comment_short_desc %}                       |
| [`subir`](/webhooks/event-payloads/#push)                                                                    | `contenidos`                                    | {% data reusables.webhooks.push_short_desc %}                                                |
| [`lanzamiento`](/webhooks/event-payloads/#release)                                                           | `contenidos`                                    | {% data reusables.webhooks.release_short_desc %}                                             |
| [`repositorio`](/webhooks/event-payloads/#repository)                                                        | `metadatos`                                     | {% data reusables.webhooks.repository_short_desc %}{% if currentVersion == "free-pro-team@latest"%}
| [`repository_dispatch`](/webhooks/event-payloads/#repository_dispatch)                                       | `contenidos`                                    | Permite que los integradores que utilizan GitHub Actions activen eventos personalizados.{% endif %}
| [`estado`](/webhooks/event-payloads/#status)                                                                 | `estados`                                       | {% data reusables.webhooks.status_short_desc %}                                              |
| [`equipo`](/webhooks/event-payloads/#team)                                                                   | `members`                                       | {% data reusables.webhooks.team_short_desc %}                                                |
| [`team_add`](/webhooks/event-payloads/#team_add)                                                             | `members`                                       | {% data reusables.webhooks.team_add_short_desc %}                                            |
| [`ver`](/webhooks/event-payloads/#watch)                                                                     | `metadatos`                                     | {% data reusables.webhooks.watch_short_desc %}                                               |
