---
title: GitHub Pages-Website mit Jekyll erstellen
intro: 'Du kannst mit Jekyll eine {% data variables.product.prodname_pages %}-Website in einem neuen oder vorhandenen Repository erstellen.'
product: '{% data reusables.gated-features.pages %}'
redirect_from:
  - /articles/creating-a-github-pages-site-with-jekyll
permissions: 'Personen mit Administratorberechtigungen für ein Repository können mit Jekyll eine {% data variables.product.prodname_pages %}-Website erstellen.'
versions:
  free-pro-team: '*'
  enterprise-server: '*'
---

### Vorrausetzungen

Bevor Du mit Jekyll eine {% data variables.product.prodname_pages %}-Website erstellen kannst, musst Du Jekyll und Git installieren. Weitere Informationen finden Sie unter „[Installation](https://jekyllrb.com/docs/installation/)“ in der Jekyll-Dokumentation und unter „[Git einrichten](/articles/set-up-git)“.

{% data reusables.pages.recommend-bundler %}

{% data reusables.pages.jekyll-install-troubleshooting %}

### Ein Repository für eine Website erstellen

{% data reusables.pages.new-or-existing-repo %}

{% data reusables.pages.private_pages_are_public_warning %}

{% data reusables.repositories.create_new %}
{% data reusables.repositories.owner-drop-down %}
{% data reusables.pages.create-repo-name %}
{% data reusables.repositories.choose-repo-visibility %}

### Eine Website erstellen

{% data reusables.pages.must-have-repo-first %}

{% data reusables.command_line.open_the_multi_os_terminal %}
2. Wenn Du noch keine lokale Kopie Deines Repositorys besitzt, navigiere zu dem Speicherort, an dem Du die Quelldateien Deiner Website speichern möchtest, und ersetze dabei _PARENT-FOLDER_ durch den Ordner, der den Ordner für Dein Repository enthalten soll.
  ```shell
  $ cd <em>PARENT-FOLDER</em>
  ```
3. Wenn Du dies noch nicht getan hast, initialisiere ein lokales Git-Repository, und ersetzen dabei _REPOSITORY-NAME_ durch den Namen Deines Repositorys.
  ```shell
  $ git init <em>REPOSITORY-NAME</em>
  > Initialized empty Git repository in /Users/octocat/my-site/.git/
  # Erstellt einen neuen Ordner auf Deinem Computer, der als Git-Repository initialisiert wird
  ```
  4. Wechsle in das Verzeichnis des Repositorys.
  ```shell
  $ cd <em>REPOSITORY-NAME</em>
  # Ändert das Arbeitsverzeichnis
  ```
{% data reusables.pages.decide-publishing-source %}
{% data reusables.pages.navigate-publishing-source %}
  For example, if you chose to publish your site from the `docs` folder on the default branch, create and change directories to the `docs` folder.
 ```shell
 $ mkdir docs
 # Erstellt einen neuen Ordner mit dem Namen docs
 $ cd docs
 ```
 Wenn Du Deine Website aus dem `gh-pages`-Branch veröffentlichen möchtest, erstelle den `gh-pages`-Branch und checke ihn aus.
 ```shell
 $ git checkout --orphan gh-pages
 # Erstellt einen neuen Branch, ohne Verlauf und Inhalte, mit dem namen gh-pages und wechselt zum gh-pages-Branch
 ```
 7. Um eine neue Jekyll-Website zu erstellen, führe den Befehl `jekyll new` aus. Ersetze dabei _VERSION_ durch die aktuelle Abhängigkeitsversion für Jekyll. Weitere Informationen finden Sie unter „[Abhängigkeitsversionen](https://pages.github.com/versions/)“ auf der {% data variables.product.prodname_pages %}-Website.
    - Wenn Du Bundler installiert hast:
      ```shell
      $ bundle exec jekyll <em>VERSION</em> new .
      # Erstellt eine Jekyll-Website im aktuellen Verzeichnis
      ```
    - Wenn Du Bundler nicht installiert hast:
     ```shell
     $ jekyll <em>VERSION</em> new .
     # Erstellt eine Jekyll-Website im aktuellen Verzeichnis
     ```
8. Öffne das gerade erstellte Gemfile, und befolge die Anweisungen in den Gemfile-Kommentaren, um {% data variables.product.prodname_pages %} zu verwenden. ![Anleitung zum Aktualisieren der Gemfile](/assets/images/help/pages/gemfile-instructions.png)
9. Aktualisiere die Zeile `gem "github-pages"` so, dass sie wie folgt aussieht. Ersetze dabei _VERSION_ durch die aktuelle Abhängigkeitsversion für `github-pages`. Weitere Informationen finden Sie unter „[Abhängigkeitsversionen](https://pages.github.com/versions/)“ auf der {% data variables.product.prodname_pages %}-Website.
```shell
gem "github-pages", "~> <em>VERSION</em>", group: :jekyll_plugins
```
10. Speichere und schließe das Gemfile.
11. Teste Deine Website optional lokal. Weitere Informationen findest Du unter „[Deine {% data variables.product.prodname_pages %}-Website lokal mit Jekyll testen](/articles/testing-your-github-pages-site-locally-with-jekyll).“
12. Füge Dein {% data variables.product.product_name %}-Repository als Remote-Repository hinzu. Ersetze dabei {% if currentVersion != "free-pro-team@latest" %}_HOSTNAME_ durch den Hostnamen Deiner Appliance,{% endif %} _USER_ durch das Konto, das das Repository besitzt{% if currentVersion != "free-pro-team@latest" %},{% endif %} und _REPOSITORY_ durch den Namen des Repositorys.
```shell
{% if currentVersion == "free-pro-team@latest" %}
$ git remote add origin https://github.com/<em>USER</em>/<em>REPOSITORY</em>.git
{% else %}
$ git remote add origin https://<em>HOSTNAME</em>/<em>USER</em>/<em>REPOSITORY</em>.git
{% endif %}
```
13. Übertrage das Repository zu {% data variables.product.product_name %}, und ersetze dabei _BRANCH_ durch den Namen des Branches, auf dem Du gerade arbeitest.
   ```shell
   $ git push -u origin <em>BRANCH</em>
   ```
{% data reusables.pages.configure-publishing-source %}
{% data reusables.pages.navigate-site-repo %}
{% data reusables.repositories.sidebar-settings %}
{% data reusables.pages.visit-site %}

{% data reusables.pages.admin-must-push %}

### Nächste Schritte:

Informationen dazu, wie Du eine neue Seite oder einen neuen Beitrag zu Deiner Website hinzufügst, findest Du unter „[Inhalte zur {% data variables.product.prodname_pages %}-Website mit Jekyll hinzufügen](/articles/adding-content-to-your-github-pages-site-using-jekyll).“

{% data reusables.pages.add-jekyll-theme %} Weitere Informationen findest Du unter „[Ein Design zu Deiner {% data variables.product.prodname_pages %}-Website mit Jekyll hinzufügen](/articles/adding-a-theme-to-your-github-pages-site-using-jekyll).“
