---
title: Globale Datenschutzpraktiken
redirect_from:
  - /eu-safe-harbor/
  - /articles/global-privacy-practices
versions:
  free-pro-team: '*'
---

Effective date: July 22, 2020

GitHub provides the same high standard of privacy protection—as described in GitHub’s [Privacy Statement](/github/site-policy/github-privacy-statement#githubs-global-privacy-practices)—to all our users and customers around the world, regardless of their country of origin or location, and GitHub is proud of the level of notice, choice, accountability, security, data integrity, access, and recourse we provide.

GitHub also complies with certain legal frameworks relating to the transfer of data from the European Economic Area, the United Kingdom, and Switzerland (collectively, “EU”) to the United States. When GitHub engages in such transfers, GitHub relies on Standard Contractual Clauses as the legal mechanism to help ensure your rights and protections travel with your personal information. In addition, GitHub is certified to the EU-US and Swiss-US Privacy Shield Frameworks. To learn more about the European Commission’s decisions on international data transfer, see this article on the [European Commission website](https://ec.europa.eu/info/law/law-topic/data-protection/international-dimension-data-protection_en).

### Standard Contractual Clauses

GitHub relies on the European Commission-approved Standard Contractual Clauses (“SCCs”) as a legal mechanism for data transfers from the EU. SCCs are contractual commitments between companies transferring personal data, binding them to protect the privacy and security of such data. GitHub adopted SCCs so that the necessary data flows can be protected when transferred outside the EU to countries which have not been deemed by the European Commission to adequately protect personal data, including protecting data transfers to the United States.

To learn more about SCCs, see this article on the [European Commission website](https://ec.europa.eu/info/law/law-topic/data-protection/international-dimension-data-protection/standard-contractual-clauses-scc_en).

### Datenschutzschild-Framework

GitHub is certified to the EU-US and Swiss-US Privacy Shield Frameworks and the commitments they entail, although GitHub does not rely on the EU-US Privacy Shield Framework as a legal basis for transfers of personal information in light of the judgment of the Court of Justice of the EU in Case C-311/18.

The EU-US and Swiss-US Privacy Shield Frameworks are set forth by the US Department of Commerce regarding the collection, use, and retention of User Personal Information transferred from the European Union, the UK, and Switzerland to the United States. GitHub hat eine Zertifizierung des US-Handelsministeriums erlangt, dass es den Prinzipien des Datenschutzschild entspricht. If our vendors or affiliates process User Personal Information on our behalf in a manner inconsistent with the principles of either Privacy Shield Framework, GitHub remains liable unless we prove we are not responsible for the event giving rise to the damage.

For purposes of our certifications under the Privacy Shield Frameworks, if there is any conflict between the terms in these Global Privacy Practices and the Privacy Shield Principles, the Privacy Shield Principles shall govern. Für weitere Informationen zum Datenschutzschild-Programm und um unsere Zertifizierung einzusehen, besuchen Sie die [Privacy Shield-Website](https://www.privacyshield.gov/).

The Privacy Shield Frameworks are based on seven principles, and GitHub adheres to them in the following ways:

- **Benachrichtigung**
  - Wir informieren Sie, wenn wir Ihre personenbezogenen Daten sammeln.
  - Wir geben Ihnen in unserer [Datenschutzerklärung](/articles/github-privacy-statement/)bekannt, welche Zwecke wir für die Erhebung und Nutzung Ihrer Informationen haben, an wen und unter welchen Beschränkungen wir diese Informationen weitergeben und welchen Zugriff Sie auf Ihre Daten haben.
  - Wir teilen Ihnen mit, dass wir am Datenschutzschild teilnehmen und was das für Sie bedeutet.
  - Wir haben eine {% data variables.contact.contact_privacy %} wo Sie uns mit Fragen zu Ihrer Privatsphäre kontaktieren können.
  - Wir informieren Sie über Ihr Recht, im unwahrscheinlichen Fall einer Streitigkeit ein verbindliches Schiedsverfahren zu beauftragen, das Ihnen kostenlos zur Verfügung gestellt wird.
  - Wir lassen Sie wissen, dass wir der Gerichtsbarkeit der Federal Trade Commission unterliegen.
- **Auswahl**
  - Wir lassen Sie wählen, was mit Ihren Daten geschieht. Bevor wir Ihre Daten für einen anderen Zweck verwenden als den, für den Sie sie uns zur Verfügung gestellt haben, werden wir Sie davon in Kenntnis setzen und Ihr Einverständnis einholen.
  - Wir werden Ihnen angemessene Mechanismen zur Entscheidungsfindung zur Verfügung stellen.
- **Verantwortlichkeit für die Weiterleitung**
  - Wenn wir Ihre Daten an Drittanbieter weitergeben, die sie in unserem Auftrag verarbeiten, senden wir Ihre Daten nur an Dritte, die mit uns vertraglich verpflichtet sind und die Ihre Daten in Übereinstimmung mit unserer Datenschutzerklärung schützen. Wenn wir Ihre Daten im Rahmen des Datenschutzschilds an unsere Anbieter weitergeben, bleiben wir dafür verantwortlich.
  - Wir teilen nur die Datenmenge mit unseren Drittanbietern mit, die für den Abschluss der Transaktion erforderlich ist.
- **Sicherheit**
  - Wir schützen Ihre personenbezogenen Daten mit [allen angemessenen und geeigneten Sicherheitsmaßnahmen](https://github.com/security).
- **Datenintegrität und Zweckbindung**
  - Wir sammeln Ihre Daten nur für die Zwecke, die für die Bereitstellung unserer Dienste für Sie erforderlich sind.
  - Wir sammeln so wenig Informationen über Sie, wie wir können, es sei denn, Sie möchten uns weitere zur Verfügung stellen.
  - Wir ergreifen angemessene Schritte, um sicherzustellen, dass die Daten, die wir über Sie haben, korrekt, aktuell und zuverlässig für den beabsichtigten Gebrauch sind.
- **Zugriff**
  - Sie können jederzeit in Ihrem [Benutzerprofil](https://github.com/settings/profile) auf die von uns über Sie gespeicherten Daten zugreifen. Sie können Ihre Daten dort abrufen, aktualisieren, ändern oder löschen.
- **Rückgriffs, Durchsetzung und der Haftung**
  - Wenn Sie Fragen zu unseren Datenschutzpraktiken haben, können Sie uns über unser {% data variables.contact.contact_privacy %} erreichen und wir werden innerhalb von 45 Tagen antworten.
  - Im unwahrscheinlichen Fall eines Streitfalls, den wir nicht lösen können, haben Sie Zugang zu einem für Sie kostenlosen, verbindlichen Schiedsverfahren. Weitere Informationen finden Sie in unserer [Datenschutzerklärung](/articles/github-privacy-statement/).
  - Wir führen regelmäßige Überprüfungen unserer einschlägigen Datenschutzpraktiken durch, um die Einhaltung der von uns gemachten Zusagen zu überprüfen.
  - Wir verlangen von unseren Mitarbeitern, dass sie unsere Datenschutzversprechen einhalten, und die Verletzung unserer Datenschutzrichtlinien unterliegt Disziplinarmaßnahmen bis hin zur Kündigung des Arbeitsverhältnisses.


#### Streitbeilegungsprozess

As further explained in the [Resolving Complaints](/github/site-policy/github-privacy-statement#resolving-complaints) section of our [Privacy Statement](/github/site-policy/github-privacy-statement), we encourage you to contact us should you have a Privacy Shield-related (or general privacy-related) complaint. For any complaints that cannot be resolved with GitHub directly, we have selected to cooperate with the relevant EU Data Protection Authority, or a panel established by the European data protection authorities, for resolving disputes with EU individuals, and with the Swiss Federal Data Protection and Information Commissioner (FDPIC) for resolving disputes with Swiss individuals. Bitte kontaktieren Sie uns, wenn Sie möchten, dass wir Sie an Ihre Datenschutzbehörde weiterleiten.

Wenn Sie ihren Wohnsitz in einem EU-Mitgliedstaat haben, haben Sie außerdem das Recht, eine Beschwerde bei Ihrer örtlichen Aufsichtsbehörde einzureichen.

#### Unabhängiges Schiedsverfahren

Unter bestimmten begrenzten Umständen können sich in der EU, dem Europäische Wirtschaftsraum (EWR) der Schweiz und Großbritannien ansässige Einzelpersonen als letztes Mittel auf ein verbindliches Datenschutzschild-Schiedsverfahren berufen, wenn alle anderen Formen der Streitbeilegung erfolglos waren sind. Mehr über dieses Lösungsverfahren und seine Verfügbarkeit finden Sie im Kapitel [Datanschutzschild](https://www.privacyshield.gov/article?id=ANNEX-I-introduction). Ein Schiedsverfahren ist nicht obligatorisch; es ist ein Verfahren, das Sie nutzen können, wenn Sie es wünschen.

We are subject to the jurisdiction of the US Federal Trade Commission (FTC).

Weitere Informationen finden Sie in unserer [Datenschutzerklärung](/articles/github-privacy-statement/).
