---
title: GitHub-Nutzungsbedingungen
redirect_from:
  - /tos/
  - /terms/
  - /terms-of-service/
  - /github-terms-of-service-draft/
  - /articles/github-terms-of-service
versions:
  free-pro-team: '*'
---

Vielen Dank für die Nutzung von GitHub! Wir freuen uns, dass Sie hier sind. Bitte lesen Sie diese Nutzungsbedingungen sorgfältig durch, bevor Sie auf GitHub zugreifen oder verwenden. Da es sich um einen so wichtigen Vertrag zwischen uns und unseren Benutzer handelt, haben wir versucht, ihn so klar wie möglich zu formulieren. Für Ihre Bequemlichkeit haben wir diese Bedingungen in einer kurzen unverbindlichen Zusammenfassung dargestellt, gefolgt von den vollständigen rechtlichen Bedingungen.

### Zusammenfassung

| Abschnitt                                                                      | Welche Informationen sind dort enthalten?                                                                                                                                                                                                                                                   |
| ------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [A. Definitionen](#a-definitions)                                              | Einige grundlegende Begriffe, die in einer Weise definiert werden, die Ihnen hilft, diese Vereinbarung zu verstehen. Zur Klarstellung wird auf diesen Abschnitt verwiesen.                                                                                                                  |
| [B. Kontobedingungen](#b-account-terms)                                        | Dies sind die grundlegenden Anforderungen für ein Konto auf GitHub.                                                                                                                                                                                                                         |
| [C. Angemessene Nutzung](#c-acceptable-use)                                    | Dies sind die grundlegenden Regeln, die Sie bei der Verwendung deines GitHub-Kontos beachten müssen.                                                                                                                                                                                        |
| [D. Benutzergenerierte Inhalte](#d-user-generated-content)                     | Die Inhalte, die Sie auf GitHub veröffentlichen, gehören Ihnen. Sie haben jedoch eine gewisse Verantwortung in Bezug darauf, und wir bitten Sie, uns einige Rechte zu gewähren, damit wir Ihnen Dienste anbieten können.                                                                    |
| [E. Private Repositorys](#e-private-repositories)                              | In diesem Abschnitt wird erläutert, wie GitHub mit Inhalten umgeht, die Sie in privaten Repositorys veröffentlichen.                                                                                                                                                                        |
| [F. Copyright & DMCA-Richtlinie](#f-copyright-infringement-and-dmca-policy)    | In diesem Abschnitt wird erläutert, wie GitHub reagieren wird, wenn Sie glauben, dass jemand Ihre Urheberrechte auf GitHub verletzt.                                                                                                                                                        |
| [G. Richtlinien bezüglich geistigem Eigentum](#g-intellectual-property-notice) | Dies beschreibt GitHubs Rechte an der Website und am Dienst.                                                                                                                                                                                                                                |
| [H. API-Bedingungen](#h-api-terms)                                             | Dies sind die Regeln für die Verwendung der GitHub-APIs, unabhängig davon, ob Sie das API für die Entwicklung oder Datenerfassung verwenden.                                                                                                                                                |
| [I. Zusätzliche Produktbedingungen](#i-github-additional-product-terms)        | Wir haben einige spezifische Regeln für die Funktionen und Produkte von GitHub.                                                                                                                                                                                                             |
| [J. Beta-Versionen](#j-beta-previews)                                          | Dies sind einige der zusätzlichen Bedingungen, die für die noch in Entwicklung befindlichen Funktionen von GitHub gelten.                                                                                                                                                                   |
| [K. Ausgaben des gesponserten Entwicklers](#k-payment)                         | Sie sind für die Zahlung verantwortlich. Wir sind für die genaue Abrechnung verantwortlich.                                                                                                                                                                                                 |
| [L. Stornierung und Kündigung](#l-cancellation-and-termination)                | Sie können diesen Vertrag jederzeit kündigen und Ihr Konto schließen.                                                                                                                                                                                                                       |
| [M. Kommunikation mit GitHub](#m-communications-with-github)                   | Wir verwenden ausschließlich E-Mail und andere elektronische Mittel, um mit unseren Benutzern in Kontakt zu bleiben. Wir bieten keinen telefonischen Support.                                                                                                                               |
| [N. Gewährleistungsausschluss](#n-disclaimer-of-warranties)                    | Wir bieten unseren Service so an, wie er ist, und wir geben keine Versprechungen oder Garantien für diesen Service. **Bitte lesen Sie diesen Abschnitt sorgfältig durch; es sollte Ihnen klar sein, was Sie erwartet.**                                                                     |
| [O. Haftungsbeschränkung](#o-limitation-of-liability)                          | Wir sind nicht haftbar für Schäden oder Verluste, die sich aus Ihrer Nutzung oder der Unfähigkeit zur Nutzung des Dienstes oder anderweitig aus dieser Vereinbarung ergeben. **Bitte lesen Sie diesen Abschnitt sorgfältig durch; er schränkt unsere Verpflichtungen Ihnen gegenüber ein.** |
| [P. Freistellung und Schadloshaltung](#p-release-and-indemnification)          | Sie tragen die volle Verantwortung für Ihre Nutzung des Dienstes.                                                                                                                                                                                                                           |
| [Q. Änderungen an diesen Nutzungsbedingungen](#q-changes-to-these-terms)       | Wir können diese Vereinbarung ändern, aber wir werden Sie 30 Tage vorher über Änderungen informieren, die Ihre Rechte beeinträchtigen.                                                                                                                                                      |
| [R. Sonstiges](#r-miscellaneous)                                               | Bitte beachten Sie diesen Abschnitt für rechtliche Einzelheiten einschließlich unserer Rechtswahl.                                                                                                                                                                                          |

### Die GitHub-Nutzungsbedingungen
Datum des Inkrafttretens: 2. April 2020


### A. Definitionen
**Kurzversion:** *Diese Grundbegriffe werden in der gesamten Vereinbarung verwendet, und sie besitzen spezifische Bedeutungen. Sie sollten wissen, was wir meinen, wenn wir jeden der Begriffe verwenden. Es gibt zwar keinen Test darüber, aber es handelt sich trotzdem um nützliche Informationen.*

1. Ein "Konto" stellt Ihre Rechtsbeziehung zu GitHub dar. Ein "Benutzerkonto" stellt die Autorisierung eines einzelnen Benutzers dar, sich bei dem Dienst anzumelden und ihn zu nutzen, und dient als Identität eines Benutzers auf GitHub. „Organisationen“ sind gemeinsame Arbeitsbereiche, die mit einem Unternehmen oder einem oder mehreren Benutzern verbunden sein können und über die mehrere Benutzer gleichzeitig gemeinsam an mehreren Projekten arbeiten können. Ein Benutzerkonto kann Mitglied einer beliebigen Anzahl von Organisationen sein.
2. Die "Vereinbarung" bezieht sich zusammen auf alle Begriffe, Bedingungen und Mitteilungen, die in diesem Dokument enthalten sind oder auf die verwiesen wird (die "Nutzungsbedingungen" oder die "Bedingungen") und alle anderen Betriebsregeln, Richtlinien (einschließlich der GitHub-Datenschutzerklärung, die unter [github.com/site/privacy](https://github.com/site/privacy) verfügbar ist) und Verfahren, die wir von Zeit zu Zeit auf der Website veröffentlichen können. Die meisten unserer Website-Richtlinien sind unter [docs.github.com/categories/site-policy](/categories/site-policy) verfügbar.
3. „Beta-Versionen“ sind Software, Dienste oder Features, die als Alpha, Beta, Vorschauversion, Frühzugriff oder Evaluierung oder Ausdrücke oder Formulierungen mit einer ähnlichen Bedeutung gekennzeichnet sind.
4. „Inhalt(e)“ bezieht sich auf auf der Website vorgestellte oder angezeigte Inhalte, unter anderem Code, Texte, Daten, Artikel, Bilder, Fotografien, Grafiken, Software, Anwendungen, Pakete, Designs, Features und sonstige Materialien, die auf die Website verfügbar sind oder auf andere Weise durch den Dienst verfügbar gemacht werden. "Inhalt(e)" umfasst auch Dienste. „Benutzergenerierte Inhalte" sind Inhalte, die von unseren Benutzer geschrieben oder anderweitig erstellt oder hochgeladen wurden. „Ihre Inhalte" sind Inhalte, die Sie erstellen oder besitzen.
5. „GitHub“, „Wir“ und „Uns“ bezieht sich auf GitHub, Inc. sowie unsere verbundenen Unternehmen, Direktoren, Tochtergesellschaften, Vertragspartner, Lizenzgeber, Beauftragte, Vertreter und Mitarbeiter.
6. Der „Dienst“ bezieht sich auf die von GitHub angebotenen Anwendungen, Software, Produkte und Dienste, einschließlich aller Beta-Vorschauen.
7. „Der Benutzer“, „Sie“ und „Ihr(e)“ bezieht sich auf die Person, das Unternehmen oder die Organisation, die die Website besucht oder den Dienst nutzt; welche(s) auf einen Teil des Kontos zugreift oder ihn nutzt; oder die Nutzung des Kontos bei die Ausübung seiner Funktionen leitet. Ein Benutzer muss mindestens 13 Jahre alt sein. Für Unternehmens- oder Regierungskonten können besondere Bedingungen gelten (siehe [Abschnitt B(5): Zusätzliche Bedingungen](#5-additional-terms)).
8. Die „Website“ bezieht sich die Website von GitHub unter [Github. om](https://github.com/), und alle Inhalte, Dienstleistungen und Produkte, die von GitHub auf oder über die Website bereitgestellt werden. Es bezieht sich auch auf GitHub-eigene Subdomains von github.com, wie [education.github.com](https://education.github.com/) Und [pages.github.com](https://pages.github.com/). Diese Bedingungen regeln auch die Konferenz-Websites von GitHub, wie [githubuniverse.com](https://githubuniverse.com/) und Produktwebsites wie [atom.io](https://atom.io/). Gelegentlich können Websites, die GitHub gehören, unterschiedlichen oder zusätzlichen Nutzungsbedingungen unterliegen. Wenn diese zusätzlichen Bedingungen mit dieser Vereinbarung in Konflikt stehen, gelten die spezifischeren Bedingungen für die entsprechende Seite oder den jeweiligen Dienst.

### B. Kontobedingungen
**Kurzversion:** *Benutzerkonten und Organisationen haben unterschiedliche administrative Kontrollen; Ihr Konto muss von einer Person erstellt werden; Sie müssen mindestens 13 Jahre alt sein; Sie müssen eine gültige E-Mail-Adresse angeben; und Sie dürfen nicht mehr als ein kostenloses Konto haben. Sie allein sind für Ihr Konto und alles, was passiert, während Sie sich bei Ihrem Konto anmelden oder es verwenden, verantwortlich. Sie sind dafür verantwortlich dafür, Ihr Konto sicher zu halten.*

#### 1. Kontrolle über Konten
- Benutzer. Vorbehaltlich dieser Bedingungen behalten Sie die ultimative administrative Kontrolle über Ihr Benutzerkonto und die darin enthaltenen Inhalte.

- Organisationen. Der „Inhaber" einer Organisation, die unter diesen Bedingungen erstellt wurde, hat die ultimative administrative Kontrolle über diese Organisation und die darin befindlichen Inhalte. Innerhalb des Dienstes kann ein Inhaber den Benutzerzugriff auf die Daten und Projekte der Organisation verwalten. Eine Organisation kann mehrere Inhaber haben, aber es muss mindestens ein Benutzerkonto als Inhaber einer Organisation festgelegt sein. Wenn Sie der Inhaber einer Organisation gemäß diesen Bedingungen sind, betrachten wir Sie als verantwortlich für die Aktionen, die in oder über diese Organisation ausgeführt werden.

#### 2. Notwendige Angaben
Sie müssen eine gültige E-Mail-Adresse angeben, um den Anmeldevorgang abzuschließen. Alle anderen angeforderten Informationen, wie z. B. Ihr richtiger Name, sind optional, es sei denn, Sie akzeptieren diese Bedingungen im Namen einer juristischen Person (in diesem Fall benötigen wir mehr Informationen über die juristische Person) oder wenn Sie sich für ein [kostenpflichtiges Konto](#k-payment)entscheiden, in diesem Fall werden zusätzliche Informationen zu Abrechnungszwecken benötigt.

#### 3. Anforderungen an Konten
Wir haben ein paar einfache Regeln für Benutzerkonten auf dem Dienst von GitHub.
- Sie müssen ein Mensch sein, um ein Konto zu erstellen. Konten, die von „Bots" oder durch andere automatisierte Methoden registriert werden, sind nicht zulässig. Wir gestatten jedoch Maschinenkonten:
- Ein „Maschinenkonto“ ist ein Konto, das von einer natürlichen Person registriert wurde, die im Namen des Maschinenkontos den geltenden Bedingungen zustimmt, eine gültige E-Mail-Adresse angibt und für die entsprechenden Aktionen haftet. Ein Maschinenkonto wird ausschließlich zur Ausführung automatisierter Aufgaben genutzt. Die Aktionen eines Maschinenkontos können von mehreren Benutzern gesteuert werden. Die endgültige Haftung für die Maschinenaktionen liegt jedoch bei dem Kontoinhaber. Sie dürfen nicht mehr als ein kostenloses Maschinenkonto zusätzlich zu Ihrem kostenlosen Benutzerkonto führen.
- Eine Person oder juristische Person darf nicht mehr als ein kostenloses Konto führen (wenn Sie sich entscheiden, auch ein Computerkonto zu führen ist das in Ordnung, aber es kann nur zum Betrieb einer Maschine verwendet werden).
- Sie müssen mindestens 13 Jahre alt sein. Wir beobachten zwar mit Begeisterung, wie sich brillante junge Programmierer für das Erlernen des Programmierens begeistern, aber wir müssen die Gesetze der Vereinigten Staaten einhalten. GitHub richtet sich nicht an Kinder unter 13 Jahren, und wir erlauben keine Benutzer unter 13 Jahren in unserem Dienst. Wenn wir von einem Benutzer unter 13 Jahren erfahren, werden wir [das Konto dieses Benutzers sofort kündigen](#l-cancellation-and-termination). Wenn Sie Ihren Wohnsitz in einem anderen Land als den Vereinigten Staaten haben, kann das Mindestalter des betreffenden Landes höher sein. In diesem Fall haftet der Kunde für die Einhaltung der Gesetze des betreffenden Landes.
- Ihr Login darf nur von einer Person verwendet werden, d. h. ein einzelner Login darf nicht von mehreren Personen geteilt werden. Eine kostenpflichtige Organisation kann nur Zugriff auf so viele Benutzerkonten gewähren, wie Ihr Abonnement zulässt.
- Sie dürfen GitHub nicht unter Verstoß gegen die Exportkontroll- oder Sanktionsgesetze der Vereinigten Staaten oder einer anderen anwendbaren Gerichtsbarkeit verwenden. Sie dürfen GitHub nicht verwenden, wenn Sie im Auftrag eines [Specially Designated National (SDN)](https://www.treasury.gov/resource-center/sanctions/SDN-List/Pages/default.aspx) oder für eine Person, die vergleichbaren Sperren oder Verboten durch eine US-Regierungsbehörde unterliegt, arbeiten. government agency.  GitHub kann Personen in bestimmten sanktionierten Ländern oder Gebieten den Zugang zu bestimmten GitHub-Diensten entsprechend US-behördlichen Berechtigungen ermöglichen. government authorizations.  Weitere Informationen enthält unsere [Ausfuhrkontrollrichtlinie](/articles/github-and-export-controls).

#### 4. Benutzerkontosicherheit
Sie sind für die sichere Führung Ihres Kontos verantwortlich, während Sie unseren Dienst nutzen. Wir bieten Tools wie die Zwei-Faktor-Authentifizierung, um Ihnen zu helfen, die Sicherheit Ihres Kontos zu gewährleisten, aber der Inhalt Ihres Kontos und seine Sicherheit liegen bei Ihnen.
- Sie sind für alle Inhalte und Aktivitäten verantwortlich, die unter Ihrem Konto gepostet und ausgeführt werden (auch wenn Inhalte von anderen Personen veröffentlicht werden, die Konten unter Ihrem Konto haben).
- Sie sind für die Aufrechterhaltung der Sicherheit Ihres Kontos und Passworts verantwortlich. GitHub kann und wird nicht für Verluste oder Schäden haftbar gemacht werden, die durch die Nichteinhaltung dieser Sicherheitsverpflichtung entstehen.
- Sie werden umgehend [GitHub benachrichtigen](https://support.github.com/contact) wenn Sie Kenntnis von einer unbefugten Nutzung oder einem unbefugten Zugriff auf unseren Dienst über Ihr Konto erhalten, einschließlich einer unbefugten Nutzung Ihres Passworts oder Kontos.

#### 5. Weitere Bedingungen
In bestimmten Fällen können für Ihre Nutzung von GitHub Bedingungen Dritter gelten. Wenn Sie beispielsweise Mitglied einer Organisation auf GitHub mit eigenen Bedingungen oder Lizenzvereinbarungen sind, können Sie eine Anwendung herunterladen, die in GitHub integriert ist, oder Sie können GitHub zur Authentifizierung bei einem anderen Dienst nutzen. Bitte beachten Sie, dass diese Bedingungen zwar die vollständige Vereinbarung mit Ihnen darstellen, dass jedoch die Bedingungen anderer Parteien deren Beziehungen zu Ihnen regeln.

Wenn Sie eine US-Bundesbehörde sind oder auf andere Weise Teile des GitHub-Dienstes in behördlicher Funktion aufrufen oder nutzen, gilt für Sie der [Nachtrag zu den GitHub-Nutzungsbedingungen für US-Bundesbehörden](/articles/amendment-to-github-terms-of-service-applicable-to-u-s-federal-government-users/), und Sie stimmen den entsprechenden Bedingungen zu.

Wenn Sie bei GitHub Enterprise Cloud anmeldet sind, gilt der [der Enterprise Cloud-Nachtrag ](/articles/github-enterprise-cloud-addendum/) und Sie stimmen seinen Bestimmungen zu.

### C. Angemessene Nutzung
**Kurzversion:** *GitHub hostet die unterschiedlichsten Projekte aus der ganzen Welt, an denen viele Benutzer gemeinsam arbeiten. Diese Zusammenarbeit funktioniert nur, wenn unsere Benutzer in gutem Glauben miteinander arbeiten können. Während Sie den Dienst nutzen, müssen Sie die Bedingungen in diesem Abschnitt einhalten. Dazu gehören auch Einschränkungen hinsichtlich der Inhalte, die Sie veröffentlichen können, Ihres Verhaltens bei der Dienstnutzung und andere Beschränkungen. Kurz gesagt erwarten wir einen freundlichen Umgang miteinander.*

Ihre Nutzung des Dienstes darf keine anwendbaren Gesetze verletzen, unter anderem Urheberrechts- und Markenschutzgesetze, Ausfuhrkontrollgesetze oder Sanktionsgesetze, oder andere Gesetze in Ihrer Rechtsordnung. Sie sind dafür verantwortlich, sicherzustellen, dass Ihre Nutzung des Dienstes den Gesetzen und geltenden Vorschriften entspricht.

Sie erklären sich damit einverstanden, dass Sie unter keinen Umständen gegen unsere [GitHub-Richtlinie für angemessene Nutzung](/articles/github-acceptable-use-policies) und die [GitHub-Community-Richtlinien](/articles/github-community-guidelines) verstoßen werden.

### D. Benutzergenerierte Inhalte
**Kurzversion:** *Sie besitzen die von Ihnen erstellten Inhalte, aber Sie gewähren uns bestimmte Rechte daran, so dass wir die von Ihnen veröffentlichten Inhalte anzeigen und teilen können. Sie haben nach wie vor die Kontrolle über Ihre Inhalte und tragen die Verantwortung für diese. Die Rechte, die Sie uns einräumen, sind auf die Rechte beschränkt, die wir zur Bereitstellung des Dienstes benötigen. Wir haben das Recht, Inhalte zu entfernen oder Konten zu schließen, wenn dies erforderlich ist.*

#### 1. Haftung für benutzergenerierte Inhalte
Sie können im Rahmen der Nutzung des Dienstes benutzergenerierte Inhalte erstellen oder hochladen. Sie sind allein verantwortlich für den Inhalt und für Schäden, die sich aus nutzergenerierten Inhalten ergeben, die Sie veröffentlichen, hochladen, verlinken oder anderweitig über den Dienst zur Verfügung stellen, unabhängig von der Form dieser Inhalte. Wir haften nicht für die Veröffentlichung oder den falschen Gebrauch benutzergenerierter Inhalte.

#### 2. GitHub kann Inhalte entfernen
We do not pre-screen User-Generated Content, but we have the right (though not the obligation) to refuse or remove any User-Generated Content that, in our sole discretion, violates any [GitHub terms or policies](/github/site-policy).

#### 3. Eigentumsrechte an Inhalten, Recht auf Veröffentlichung und Lizenzgewährung
Sie verbleiben Eigentümer Ihrer Inhalte und sind für diese verantwortlich. Wenn Sie etwas veröffentlichen, das Sie nicht selbst erstellt haben oder für das Sie nicht die Rechte besitzen, erklären Sie sich damit einverstanden, dass Sie für alle Inhalte, die Sie veröffentlichen, verantwortlich sind; dass Sie nur Inhalte einreichen, zu deren Veröffentlichung Sie berechtigt sind; und dass Sie alle Lizenzen Dritter in Bezug auf Inhalte, die Sie veröffentlichen vollständig einhalten werden.

Da Sie weiterhin das Eigentum und die Verantwortung für Ihre Inhalte behalten, müssen Sie uns – und anderen GitHub-Benutzern – bestimmte Berechtigungen erteilen, die in den Abschnitten D.4 - D7. Diese Lizenzerteilungen gelten für Ihre Inhalte. Laden Sie Inhalte hoch, für die bereits eine Lizenz besteht, die GitHub die erforderlichen Rechte zur Ausführung des Dienstes gewährt, ist keine weitere Lizenz erforderlich. Sie verstehen, dass Sie keine Zahlung für eines der in den Abschnitten D.4 — D.7 gewährten Rechte erhalten. Die Lizenzen, die Sie uns gewähren, enden, wenn Sie Ihre Inhalte von unseren Servern entfernen, es sei denn er wurde von anderen Benutzern geforkt.

#### 4. Lizenzvergabe an uns
Wir müssen gesetzlich befugt sein, Dinge wie das Hosten Ihrer Inhalte, deren Veröffentlichung und Weitergabe durchzuführen. Sie gewähren uns und unseren Rechtsnachfolgern das Recht, Ihre Inhalte zu speichern, zu analysieren und anzuzeigen und bei Bedarf Nebenkopien anzustellen, um die Website zu erstellen und den Dienst bereitzustellen. Dies schließt das Recht ein, Aktivitäten wie das Kopieren in unsere Datenbank und die Anfertigung von Sicherungskopien durchzuführen, sie Ihnen und anderen Benutzern zu zeigen, sie in einen Suchindex zu übernehmen oder anderweitig auf unseren Servern zu analysieren, sie mit anderen Benutzern zu teilen und sie vorzuführen, falls es sich bei Ihren Inhalten um Musik oder Videos handelt.

Diese Lizenz gewährt GitHub nicht das Recht, Ihre Inhalte zu verkaufen oder auf andere Weise zu verbreiten oder außerhalb unseres bereitgestellten Dienstes zu verwenden.

#### 5. Lizenzgewährung für andere Benutzer
Benutzergenerierte Inhalte, die Sie öffentlich posten, darunter Issues, Kommentare und Beiträge in Repositorys externer Benutzer, können von anderen angezeigt werden. Indem Sie festlegen, dass Ihre Repositorys öffentlich angezeigt werden, erklären Sie sich damit einverstanden, dass andere Ihre Repositorys anzeigen und „forken" können (das bedeutet, dass andere ihre eigenen Kopien von Inhalten aus Ihren Repositorys in von ihnen kontrollierte Repositorys erstellen können).

Konfigurieren Sie Ihre Pages und Repositorys für die öffentliche Anzeige, gewähren Sie allen GitHub-Benutzern eine nicht exklusive, weltweite Lizenz zur Verwendung, Anzeige und Wiedergabe Ihrer Inhalte über den GitHub-Dienst und zur Reproduktion von Ihrer Inhalte ausschließlich auf GitHub, insoweit dies nach den von GitHub bereitgestellten Funktionen zulässig ist (beispielsweise durch Forking). Sie können weitere Rechte gewähren, wenn der Sie [eine Lizenz einführen](/articles/adding-a-license-to-a-repository/#including-an-open-source-license-in-your-repository). Wenn Sie Inhalte hochladen, die Sie nicht selber erstellt haben oder die Ihnen nicht gehören, haften Sie dafür sicherzustellen, dass die von Ihnen hochgeladenen Inhalte nach den Bedingungen lizenziert sind, mit denen diese Rechte GitHub-Benutzern gewährt werden.

#### 6. Beiträge im Rahmen einer Repository-Lizenz
Jedesmal wenn Sie einen Beitrag zu einem Repository mit einem Lizenzhinweis machen, lizenzieren Sie Ihren Beitrag zu denselben Bedingungen und erklären, dass Sie das Recht haben, den entsprechenden Beitrag zu diesen Bedingungen zu lizenzieren. Wenn Sie über eine gesonderte Vereinbarung zur Lizenzierung Ihrer Beiträge nach anderen Bedingungen wie z. B. einer Mitwirkungslizenzvereinbarung verfügen, hat die entsprechende Vereinbarung Vorrang.

Funktioniert das nicht bereits so? Ja. Dies wird weithin als die Norm in der Open-Source-Community akzeptiert; es wird üblicherweise mit der Abkürzung "inbound=outbound" bezeichnet. Wir machen es nur explizit.

#### 7. Urheberpersönlichkeitsrechte
Sie behalten alle Urheberpersönlichkeitsrechte an Ihren Inhalten, die Sie hochladen, veröffentlichen oder an einen Teil des Dienstes senden, die Rechte auf Unantastbarkeit und Namensnennung eingeschlossen. Sie verzichten jedoch auf diese Rechte und stimmen zu, diese uns gegenüber nicht geltend zu machen, um uns die angemessene Ausübung der Rechte nach Abschnitt D.4 zu ermöglichen, wobei dies jedoch ausschließlich zu diesem Zweck gilt.

Soweit diese Vereinbarung durch anwendbares Recht nicht durchsetzbar ist gewähren Sie GitHub die Rechte, die wir benötigen, um Ihren Inhalt ohne Nennung zu nutzen und angemessene Anpassungen an Ihren Inhalten vorzunehmen, wenn dies für die Darstellung der Website und die Bereitstellung der Dienste erforderlich ist.

### E. Private Repositorys
**Kurzversion:** *Sie haben möglicherweise Zugriff auf private Repositorys. Wir behandeln den Inhalt privater Repositorys vertraulich und greifen nur aus Supportgründen, mit Ihrer Zustimmung oder wenn dies aus Sicherheitsgründen erforderlich ist, darauf zu.*

#### 1. Kontrolle privater Repositorys
Einige Konten verfügen möglicherweise über private Repositorys, die es dem Benutzer ermöglichen, den Zugriff auf Inhalte zu steuern.

#### 2. Vertraulichkeit privater Repositorys
GitHub betrachtet den Inhalt privater Repositorys als vertraulich. GitHub schützt die Inhalte privater Repositorys vor unbefugter Nutzung, Unbefugtem Zugriff oder Offenlegung in der gleichen Weise, die wir verwenden würden, um unsere eigenen vertraulichen Informationen ähnlicher Art, und in keinem Fall mit weniger als einem angemessenen Maß an Sorgfalt, zu schützen.

#### 3. Zugriff
GitHub-Mitarbeiter dürfen nur in den folgenden Situationen auf den Inhalt Ihrer privaten Repositorys zugreifen:
- Mit Ihrer Zustimmung und Ihrem Wissen, aus Supportgründen. Wenn GitHub aus Supportgründen auf ein privates Repository zugreift, tun wir dies nur mit der Zustimmung und dem Wissen des Eigentümers.
- Wenn der Zugriff aus Sicherheitsgründen erforderlich ist, einschließlich wenn dies zur Aufrechterhaltung der kontinuierlichen Vertraulichkeit, Integrität, Verfügbarkeit und Belastbarkeit der Systeme und Dienste von GitHub erforderlich ist.

Sie können zusätzlichen Zugriff auf Ihre privaten Repositorys aktivieren. Ein Beispiel:
- Sie können beispielsweise mehrere GitHub-Dienste oder -Features aktivieren, für die zusätzliche Rechte für Ihre Inhalte in privaten Repositorys erforderlich sind. Diese Rechte können je nach Service oder Funktion variieren, aber GitHub wird Ihre privaten Repository-Inhalte weiterhin vertraulich behandeln. Sind für diese Dienste oder Features neben den Rechten, die für die Bereitstellung des GitHub-Dienstes erforderlich sind, zusätzliche Rechte erforderlich, geben wir eine Erläuterung dieser Rechte.

#### 4. Ausnahmen
Haben wir Grund zu der Annahme, dass Inhalte eines privaten Repositorys gegen Gesetze oder diese Bedingungen verstoßen, haben wir das Recht, auf die betreffenden Inhalte zuzugreifen und sie zu prüfen sowie zu entfernen. Darüber hinaus können wir [gesetzlich verpflichtet sein](/github/site-policy/github-privacy-statement#for-legal-disclosure) Inhalte Ihrer privaten Repositorys offenzulegen.

### F. Urheberrechtsverletzungen und DMCA-Richtlinie
Wenn Sie glauben, dass Inhalte auf unserer Website gegen Ihr Urheberrecht verstoßen kontaktieren Sie uns bitte in Übereinstimmung mit unserer [Digital Millennium Copyright Act Policy](/articles/dmca-takedown-policy/). Wenn Sie ein Urheberrechtsinhaber sind und der Meinung sind, dass Inhalte auf GitHub Ihre Rechte verletzen, kontaktieren Sie uns bitte über [unser dafür vorgesehenes DMCA-Formular](https://github.com/contact/dmca) oder per E-Mail unter copyright@github.com. Die Zusendung einer falschen oder leichtfertigen Takedown-Mitteilung kann rechtliche Konsequenzen haben. Bevor Sie eine Takedown-Anfrage senden, müssen Sie rechtliche Verwendungszwecke wie faire Nutzung und lizenzierte Nutzungen in Betracht ziehen.

Wir werden die Konten von Personen, die [Wiederholte Verstöße](/articles/dmca-takedown-policy/#e-repeated-infringement) gegen diese Richtline begehen, entfernen.

### G. Richtlinien bezüglich geistigem Eigentum
**Kurzversion:** *Wir sind Eigentümer des Dienstes und all unserer Inhalte. Damit Sie unsere Inhalte nutzen können, gewähren wir Ihnen bestimmte Rechte daran, Sie dürfen unsere Inhalte jedoch nur so nutzen, wie wir es erlaubt haben.*

#### 1. Rechte von GitHub an Inhalten
GitHub und unsere Lizenzgeber, Anbieter, Agenten bzw. unsere Inhaltsanbieter behalten die Inhaberschaft an allen geistigen Eigentumsrechten jeglicher Art im Zusammenhang mit der Website und dem Dienst. Wir behalten uns alle Rechte vor, die Ihnen im Rahmen dieser Vereinbarung oder per Gesetz nicht ausdrücklich gewährt werden. Das Erscheinungsbild der Website und des Dienstes ist wie folgt urheberrechtlich geschützt: „© GitHub, Inc. Alle Rechte vorbehalten.“ Sie dürfen ohne die ausdrückliche schriftliche Genehmigung durch GitHub keine Teile der HTML-/CSS-, Javascript- oder Grafikdesignelemente oder -konzepte duplizieren, kopieren oder wiederverwenden.

#### 2. Marken und Logos von GitHub
Wenn Sie GitHub Marken verwenden möchten, müssen Sie alle unsere Markenrichtlinien beachten, einschließlich der Richtlinien auf unserer Logos-Seite: https://github.com/logos.

#### 3. Lizenz für GitHub-Richtlinien
Diese Vereinbarung ist unter dieser [Creative Commons Zero-Lizenz](https://creativecommons.org/publicdomain/zero/1.0/) lizenziert. Weitere Informationen finden Sie in unserem [ Websiterichtlinien-Repository](https://github.com/github/site-policy#license).

### H. API-Bedingungen
**Kurzversion:** *Sie stimmen diesen Nutzungsbedingungen sowie diesem Abschnitt H zu, wenn Sie eine der GitHub-APIs (Application Provider Interface) verwenden, einschließlich bei der Verwendung des API über ein Drittanbieterprodukt, das auf GitHub zugreift.*

Missbrauch oder übermäßig häufige Anfragen an GitHub über das API können dazu führen, dass der Zugriff Ihres Kontos auf die API vorübergehend oder dauerhaft gesperrt wird. GitHub wird nach eigenem Ermessen den Missbrauch oder die übermäßige Nutzung des API bestimmen. Wir werden vertretbare Versuche unternehmen, Sie vor der Sperrung per E-Mail zu warnen.

Sie dürfen API-Token nicht weitergeben, um die von GitHub festgelegten Nutzungsbeschränkungen zu überschreiten.

Sie dürfen das API nicht zum Herunterladen von Daten oder Inhalten von GitHub zu Spamming-Zwecken verwenden, auch nicht zum Zwecke des Verkaufs persönlicher Informationen von GitHub-Benutzern, z. B. an Personalvermittler, Headhunter und Jobbörsen.

Die Nutzung des GitHub-API unterliegt diesen Nutzungsbedingungen und [GitHub-Datenschutzerklärung](https://github.com/site/privacy).

GitHub kann abonnementbasierten Zugang zu unserem API für Benutzer anbieten, die einen Zugang mit hohem Datenvolumen oder einen Zugang benötigen, was zum Weiterverkauf des GitHub-Dienstes führen würde.

### I. Zusätzliche Produktbedingungen für GitHub
**Kurzversion:** *Sie müssen bestimmte spezifische Bedingungen für die verschiedenen Funktionen und Produkte von GitHub befolgen und stimmen den ergänzenden Bedingungen zu, wenn Sie dieser Vereinbarung zustimmen.*

Einige Servicefunktionen unterliegen möglicherweise zusätzlichen funktions- oder produktspezifischen Bedingungen, wie sie in den zusätzlichen Produktbedingungen für GitHub festgelegt sind. Durch den Zugriff auf oder die Nutzung der Dienste erklären Sie sich auch mit den [Zusätzlichen Produktbedingungen von GitHub](/github/site-policy/github-additional-product-terms) einverstanden.

### J. Beta-Versionen
**Kurzversion:** *Beta-Vorschauen werden möglicherweise nicht unterstützt oder können sich jederzeit ändern, Sie können erhalten vertrauliche Informationen über Programme erhalten, die vertraulich bleiben müssen, während das Programm privat ist, und wir würden uns über Ihr freuen, um unsere unsere Beta-Vorschauen zu verbessern.*

#### 1. Änderungen vorbehalten

Beta-Versionen werden möglicherweise nicht unterstützt und können jederzeit ohne Vorankündigung geändert werden. Außerdem unterliegen Beta-Versionen nicht denselben Sicherheitsmaßnahmen und Audits wie der Dienst. **Wenn Sie eine Beta-Vorschau verwenden, verwenden Sie sie auf eigenes Risiko.**

#### 2. Vertraulichkeit

Als Benutzer von Pre-Vorschauen erhalten Sie möglicherweise Zugriff auf spezielle Informationen, die dem Rest der Welt nicht zur Verfügung stehen. Aufgrund der sensiblen Natur dieser Informationen ist es uns wichtig, sicherzustellen, dass Sie diese Informationen geheim halten.

** Vertraulichkeitspflichten. **Sie erklären sich damit einverstanden, dass alle nicht-öffentlichen Informationen über Beta-Vorschauen, die wir Ihnen zukommen lassen als vertrauliche Informationen von GitHub (zusammen "Vertrauliche Informationen") betrachtet werden, unabhängig davon, ob sie als solche gekennzeichnet sind oder identifiziert werden. Sie erklären sich damit einverstanden, solche vertraulichen Informationen nur zum ausdrücklichen Zweck der Prüfung und Bewertung der Beta-Vorschauen (der "Zweck") und nicht zu anderen Zwecken zu verwenden. Sie sollten mit der gleichen Sorgfalt vorgehen, wie Sie es mit Ihren eigenen vertraulichen Informationen tun würden, aber ebenso angemessene Vorkehrungen treffen, um eine unbefugte Nutzung, Offenlegung, Veröffentlichung oder Verbreitung unserer vertraulichen Informationen zu verhindern. Sie verpflichten sich, vertrauliche Informationen nicht an Dritte weiterzugeben, zu veröffentlichen oder zu verbreiten, es sei denn, wir verbieten oder beschränken eine solche Offenlegung nicht (zum Beispiel wenn Sie Teil einer GitHub-organisierten Gruppendiskussion über eine private Beta-Vorschaufunktion sind).

**Ausnahmen.** Vertrauliche Informationen enthalten keine Informationen, die: (a) öffentlich zugänglich sind oder ohne Verletzung dieser Vereinbarung durch keine Handlung oder Untätigkeit Ihrerseits öffentlich zugänglich werden (z. B. wenn eine private Beta-Vorschau zu einer öffentlichen Beta-Vorschau wird); (b) Ihnen bekannt sind, bevor wir sie Ihnen offenlegen; (c) unabhängig von Ihnen entwickelt wurden, ohne dass eine Vertraulichkeitsverpflichtung uns oder Dritten gegenüber verletzt wurde; oder (d) mit Genehmigung von GitHub offengelegt wurden. Sie werden nicht gegen die Bedingungen dieser Vereinbarung verstoßen, wenn Sie verpflichtet sind, vertrauliche Informationen gemäß dem Gesetzes offenzulegen, sofern GitHub eine angemessene schriftliche Vorabmitteilung zum Widerspruch erhalten hat, es sei denn, dies ist gesetzlich verboten.

#### 3. Feedback

Wir sind immer bestrebt, Produkte und Dienste zu verbessern, und Ihr Feedback als Benutzer von Beta-Vorschauen wird uns dabei helfen. Wenn Sie entscheiden, uns Ideen, Kenntnisse, Algorithmen, Codebeiträge, Vorschläge, Verbesserungsanfragen, Empfehlungen und jedes sonstige Feedback zu unseren Produkten oder Diensten (zusammenfassend als "Feedback" bezeichnet) zu geben, erklären Sie sich damit einverstanden, dass GitHub eine gebührenfreie, voll bezahlte, weltweite, übertragbare, unterlizenzierbare, unwiderrufliche und unbefristete Lizenz zur Implementierung, Nutzung, Änderung, kommerziellen Verwertung bzw. Einarbeitung des Feedbacks in unsere Produkte, Dienste und Dokumentationen besitzt.

### K. Ausgaben des gesponserten Entwicklers
**Kurzversion:** *Sie sind für alle Gebühren im Zusammenhang mit Ihrer Nutzung von GitHub verantwortlich. Wir sind dafür verantwortlich, Ihnen diese Gebühren klar und genau mitzuteilen und Sie rechtzeitig darüber zu informieren, wenn sich diese Preise ändern. *

#### 1. Preisübersicht
Unsere Preise und Zahlungsbedingungen sind unter [github.com/pricing](https://github.com/pricing) einsehbar. Wenn Sie einem Abonnementpreis zustimmen, bleibt dies Ihr Preis für die Dauer der Zahlungsfrist; Die Preise können sich jedoch am Ende einer Zahlungsfrist ändern.

#### 2. Upgrades, Downgrades und Änderungen
- Wir werden Ihnen die Kosten sofort in Rechnung stellen, wenn Sie vom kostenlosen Plan auf einen kostenpflichtigen Plan wechseln.
- Wenn Sie von einem monatlichen Abrechnungsplan zu einem jährlichen Abrechnungsplan wechseln, stellt GitHub Ihnen am nächsten monatlichen Abrechnungsdatum ein ganzes Jahr in Rechnung.
- Wenn Sie ein Upgrade auf ein höheres Serviceniveau durchführen, werden wir Ihnen den aktualisierten Plan sofort in Rechnung stellen.
- Sie können Ihr Serviceniveau jederzeit ändern, indem Sie [eine Paketoption](https://github.com/pricing) wählen oder Ihre [Abrechnungseinstellungen](https://github.com/settings/billing) aufrufen. Wenn Sie sich für eine Herabstufung Ihres Kontos entscheiden, verlieren Sie möglicherweise den Zugriff auf Inhalte, Funktionen oder die Kapazität Ihres Kontos. Bitte lesen Sie unseren Abschnitt [Auflösung des Kontos](#l-cancellation-and-termination) für Informationen zum Erhalt einer Kopie dieses Inhalts.

#### 3. Abrechnungszeitplan; Keine Rückerstattungen
**Abrechnung basierend auf Plan** für monatliche oder jährliche Zahlungspläne, wir der Dienst wird monatlich bzw. jährlich in Rechnung gestellt und ist nicht rückerstattbar. Es werden keine Rückerstattungen oder Kredite für Teilmonate, Herabstufungen oder ungenutzte Monate mit einem offenen Konto gewährt; jedoch bleibt der Dienst für die Dauer der bezahlten Abrechnungszeit aktiv. Um alle gleich zu behandeln, werden keine Ausnahmen gemacht.

**Nutzungsbasierte Abrechnung** Einige Dienst-Funktionen werden basierend auf Ihrer Nutzung abgerechnet. Eine begrenzte Anzahl dieser Dienst-Funktionen kann für eine begrenzte Zeit ohne zusätzliche Kosten in Ihren Plan aufgenommen werden. Wenn Sie kostenpflichtige Dienst-Funktionen erwerben, die über die in Ihrem Plan enthaltene Menge hinausgehen, zahlen Sie für diese Dienst-Funktionen basierend auf Ihrer tatsächlichen Nutzung im Vormonat. Die monatliche Zahlung für diese Käufe wird in regelmäßigen Abständen im Nachhinein in Rechnung gestellt. Einzelheiten hierzu finden Sie unter den [zusätzlichen Produktbedingungen für GitHub.](/github/site-policy/github-additional-product-terms).

**Invoicing** For invoiced Users, User agrees to pay the fees in full, up front without deduction or setoff of any kind, in U.S. Dollars. Der Benutzer muss die Gebühren innerhalb von dreißig (30) Tagen ab dem Datum der GitHub-Rechnung zahlen. Nach dieser Vereinbarung zahlbare Beträge sind mit Ausnahme von in dieser Vereinbarung festgelegten anderen Bestimmungen nicht erstattungsfähig. Versäumt der Benutzer die fristgemäße Zahlung der Gebühren, behält sich GitHub das Recht vor, neben juristischen oder billigkeitsrechtlichen Maßnahmen (i) für überfällige Beträge Zinsen in Höhe von 1,0 % pro Monat oder zu dem höchsten gesetzlich zulässigen Zinssatz zu erheben, je nachdem, welcher Satz niedriger ist, und alle Aufwendungen für die Einziehung zu erheben und (ii) das betreffende Auftragsformular zu kündigen. Der Benutzer haftet (mit Ausnahme von Steuern, die sich auf das Nettoeinkommen von GitHub beziehen) alleinig für alle Steuern, Gebühren, Abgaben und behördliche Bemessungen, die im Zusammenhang mit dieser Vereinbarung erhoben oder fällig werden.

#### 4. Autorisierung
Durch Ihre Zustimmung zu diesen Bedingungen geben Sie uns die Erlaubnis, Gebühren von der gespeicherten Kreditkarte, dem PayPal-Konto oder anderen für GitHub autorisierten Zahlungsmethoden abzubuchen.

#### 5. Verantwortlich für Zahlungen
Sie sind für alle Gebühren, einschließlich Steuern, verantwortlich, die mit Ihrer Nutzung des Dienstes verbunden sind. Durch die Nutzung des Dienstes erklären Sie sich damit einverstanden, GitHub alle im Zusammenhang mit Ihrer Nutzung des Dienstes entstehenden Gebühren zu zahlen.  Im Falle einer Anfechtung wenden Sie sich bitte an [GitHub Support](https://support.github.com/contact). Sie sind dafür verantwortlich, uns ein gültiges Zahlungsmittel für kostenpflichtige Konten zur Verfügung zu stellen. Für kostenlose Konten müssen keine Zahlungsinformationen angegeben werden.

### L. Stornierung und Kündigung
**Kurzversion:** *Sie können Ihr Konto jederzeit schließen. Wenn Sie dies tun, behandeln wir Ihre Informationen vertrauensvoll.*

#### 1. Auflösung des Kontos
Es liegt in Ihrer Verantwortung, Ihr Konto bei GitHub ordnungsgemäß zu kündigen. Sie können [Ihr Konto jederzeit kündigen](/articles/how-do-i-cancel-my-account/), indem Sie die Einstellungen in der allgemeinen Navigationsleiste oben im Bildschirm aufrufen. Auf der Kontoseite finden Sie einen einfachen Stornierungs-Link, ohne weitere Fragen beantworten zu müssen. Wir können Konten nicht auf Anfrage per E-Mail oder Telefon hin auflösen.

#### 2. Nach der Kündigung
Wir speichern und verwenden Ihre Informationen, soweit dies zur Erfüllung unserer rechtlichen Verpflichtungen, zur Beilegung von Streitigkeiten und zur Durchsetzung der Vereinbarungen von GitHub erforderlich ist. Vorbehaltlich rechtlicher Anforderungen löschen wir jedoch Ihr vollständiges Profil und den Inhalt Ihrer Repositorys innerhalb von 90 Tagen nach Kündigung oder Ablauf (wobei einige Informationen in verschlüsselten Backups verbleiben können). Diese Informationen können nicht wiederhergestellt werden, wenn Ihr Konto aufgelöst wurde.

Wir löschen keine Inhalte, die Sie zu den Repositorys externer Benutzer beigetragen haben oder die von externen Benutzern geforkt wurden.

Auf Anfrage werden wir uns in angemessener Weise bemühen, einem Kontoinhaber nach der Kündigung, Auflösung oder Herabstufung des Kontos eine Kopie Ihres rechtmäßigen, nicht verletzenden Kontoinhalts zur Verfügung zu stellen. Sie müssen diese Anfrage innerhalb von 90 Tagen nach Stornierung, Kündigung oder Herabstufung stellen.

#### 3. GitHub kann Ihr Konto stornieren
GitHub hat das Recht, Ihren Zugriff auf die gesamte oder einen Teil der Website jederzeit mit oder ohne Grund, mit oder ohne Vorankündigung, mit sofortiger Wirkung auszusetzen oder zu beenden. GitHub behält sich das Recht vor, den Dienst an jedermann jederzeit zu verweigern.

#### 4. Fortbestand
Alle Bestimmungen dieser Vereinbarung, die aufgrund ihrer Natur die Kündigung überdauern sollten, bleiben über die Kündigung hinaus bestehen, insbesondere Eigentumsbestimmungen, Gewährleistungsausschlüsse, Haftungsausschlüsse, Entschädigungen und Haftungsbeschränkungen.

### M. Kommunikation mit GitHub
**Kurzversion:** *Wir verwenden E-Mail und andere elektronische Mittel, um mit unseren Benutzern in Kontakt zu bleiben.*

#### 1. Elektronische Kommunikation erforderlich
Für vertragliche Zwecke erklären Sie (1) sich damit einverstanden, Mitteilungen in elektronischer Form über die von ihnen angegebene E-Mail-Adresse oder über den Dienst zu erhalten; und (2) stimmen zu, dass alle von uns elektronisch bereitgestellten Nutzungsbedingungen, Vereinbarungen, Mitteilungen, Bekanntmachungen und andere Informationen alle rechtlichen Anforderungen erfüllen, die diese Mitteilungen erfüllen würden, wenn sie in Papierform vorliegen würden. Dieser Abschnitt hat keinen Einfluss auf Ihre nicht abdingbaren Rechte.

#### 2. Rechtliche Benachrichtigungen an GitHub müssen schriftlich erfolgen
Benachrichtigungen, die per E-Mail oder über das Messaging-System des GitHub-Supports erfolgen, stellen keine rechtliche Benachrichtigung an GitHub oder seine Direktoren, Mitarbeiter, Vertreter und Repräsentanten dar, wenn eine Benachrichtigung an GitHub vertraglich oder gesetzlich oder per Regulierung vorgeschrieben ist. Die rechtliche Benachrichtigung an GitHub muss in schriftlicher Form erfolgen und [dem rechtlichen Vertreter von GitHub zugestellt werden](/articles/guidelines-for-legal-requests-of-user-data/#submitting-requests).

#### 3. Kein telefonischer Support
GitHub bietet nur Support per E-Mail, In-Service-Kommunikation und elektronische Nachrichten. Wir bieten keinen telefonischen Support.

### N. Gewährleistungsausschluss
**Kurzversion:** *Wir bieten unseren Dienst ohne Mängelgewähr an, und wir übernehmen keine Versprechungen oder Garantien für diesen Dienst. Bitte lesen Sie diesen Abschnitt sorgfältig durch; es sollte Ihnen klar sein, was Sie erwartet.*

GitHub stellt die Website und den Dienst „ohne Mängelgewähr“ und „ohne Verfügbarkeitsgewähr“, ohne jegliche Garantie zur Verfügung. Wir schließen ohne Einschränkungen des Vorstehenden sämtliche ausdrücklichen, stillschweigenden oder gesetzlichen Garantien für die Website und den Dienst aus, unter anderem Garantien der Marktgängigkeit, der Eignung für einen bestimmten Zweck und der Nichtverletzung von Rechten sowie Rechts-, Sicherheits- und Genauigkeitsgarantien.

GitHub gibt keine Garantien, dass der Dienst Ihre Anforderungen erfüllt, dass der Dienst unterbrechungsfrei, fristgerecht, sicher oder fehlerfrei bereitgestellt wird, dass die über den Dienst bereitgestellten Informationen genau, verlässlich oder richtig sind, dass alle Mängel oder Fehler behoben werden, dass der Dienst zu einer bestimmten Zeit oder an einem bestimmten Ort verfügbar ist oder dass der Dienst frei von Viren oder sonstigen schädlichen Komponenten ist. Sie allein haften für Verlustrisiken infolge des Herunterladens und/oder der Verwendung von Dateien, Informationen, Inhalten oder sonstigen Materialien Sie über den Dienst erlangen.

### O. Haftungsbeschränkung
**Kurzversion** *Wir sind nicht haftbar für Schäden oder Verluste, die sich aus Ihrer Nutzung oder der Unfähigkeit zur Nutzung des Dienstes oder anderweitig aus dieser Vereinbarung ergeben. Bitte lesen Sie diesen Abschnitt sorgfältig durch; er schränkt unsere Verpflichtungen Ihnen gegenüber ein.*

Sie erklären sich damit einverstanden, dass wir weder Ihnen noch Dritten gegenüber für etwaige entgangene Profite, Nutzungs-, Firmenwert- oder Datenverluste oder für zufällige, indirekte, besondere, Folge- oder exemplarische Schäden jeglicher Art haften, die aus folgenden Gründen entstehen:

- der Nutzung, Offenlegung oder Anzeige Ihrer nutzergenerierten Inhalte;
- Ihrer Nutzung oder der nicht möglichen Nutzung des Dienstes;
- Modifikationen, Preisänderungen, Einstellung oder Unterbrechung des Dienstes;
- durch den Dienst Allgemeinen oder der Software oder den Systemen, die den Dienst bereitstellen;
- dem nicht autorisiertem Zugriff auf oder Änderungen an Ihren Übertragungen oder Daten;
- Äußerungen oder Verhaltensweisen von Dritten auf dem Dienst;
- anderen Benutzerinteraktionen, die Sie im Rahmen der Nutzung des Dienstes durchführen oder empfangen; oder
- anderen Belangen im Zusammenhang mit dem Dienst.

Unsere Haftung ist unabhängig davon beschränkt, ob wir über die Wahrscheinlichkeit solcher Schäden informiert wurden oder nicht, und selbst dann, wenn sich herausstellt, dass ein in diesem Abkommen vorgesehenes Rechtsmittel seinen wesentlichen Zweck verfehlt hat. Wir haften nicht für Ausfälle oder Verzögerungen aufgrund von Angelegenheiten, die außerhalb unserer angemessenen Kontrolle liegen.

### P. Freistellung und Schadloshaltung
**Kurzversion:** *Sie sind für Ihre Nutzung des Dienstes verantwortlich. Sollten Sie einer anderen Person Schaden zufügen oder in eine Streitigkeit mit einer anderen Person geraten, sind wir nicht involviert.*

Wenn Sie eine Streitigkeit mit einem oder mehreren Benutzer haben, entbinden Sie GitHub von allen Ansprüchen, Forderungen und Schäden (tatsächliche und Folgeschäden) jeglicher Art, bekannt und unbekannt, die sich aus oder in irgendeiner Weise im Zusammenhang mit solchen Streitigkeiten ergeben.

Sie erklären sich damit einverstanden, uns in Bezug auf alle Ansprüche, Verbindlichkeiten und Ausgaben, einschließlich Anwaltskosten, die sich aus Ihrer Nutzung der Website und des Dienstes ergeben, zu befreien, zu verteidigen und schadlos zu halten, unter anderem aufgrund Ihrer Verletzung diesen Nutzungsbedingungen, vorausgesetzt, dass GitHub (1) Sie unverzüglich schriftlich über den Anspruch, die Forderung, die Klage oder das Verfahren informiert; (2) Ihnen die alleinige Kontrolle über die Verteidigung und Beilegung des Anspruchs, der Forderung, der Klage oder des Verfahrens gibt (vorausgesetzt, dass Sie keinen Anspruch, keine Forderung, keine Klage oder kein Verfahren beilegen dürfen, solange diese Beilegung GitHub nicht bedingungslos von jeglicher Haftung entbindet); und (3) Ihnen auf Ihre Kosten jede angemessene Unterstützung gewährt.

### Q. Änderungen dieser Bedingungen
**Kurzversion:** *Wir möchten, dass unsere Benutzer über wichtige Änderungen unserer Bedingungen informiert werden, aber einige Änderungen sind nicht so wichtig – wir wollen Sie nicht jedes Mal stören, wenn wir einen Tippfehler korrigieren. Obwohl wir diese Vereinbarung jederzeit ändern können, werden wir die Benutzer über alle Änderungen informieren, die Ihre Rechte beeinträchtigen, und Ihnen Zeit geben, sich darauf einzustellen.*

Wir behalten uns das Recht vor, diese Nutzungsbedingungen jederzeit nach unserem alleinigem Ermessen zu ändern, und aktualisieren diese Vereinbarung im Fall entsprechender Änderungen. Wir informieren unsere Benutzer über wesentliche Änderungen dieser Vereinbarung wie z. B. Preisänderungen mindestens 30 Tage vor Inkrafttreten der Änderung durch Veröffentlichung einer Mitteilung auf unserer Website. Bei geringfügigen Änderungen stellt Ihre fortgesetzte Nutzung der Website die Zustimmung zu den Änderungen dieser Nutzungsbedingungen dar. Alle Änderungen dieser Bedingungen können Sie in unserem Repository [Site Policy](https://github.com/github/site-policy) einsehen.

Wir behalten uns das Recht vor, die Website (oder einen Teil davon) zu gegebener Zeit und ohne Ankündigung vorübergehend oder dauerhaft zu modifizieren oder einzustellen.

### R. Sonstiges

#### 1. Geltendes Recht
Sofern nicht anders bestimmt, unterliegen diese Vereinbarung zwischen Ihnen und GitHub und jeder Zugriff auf oder die Nutzung der Website oder des Dienstes den Bundesgesetzen der Vereinigten Staaten von Amerika und den Gesetzen des US-Bundesstaates Kalifornien, ungeachtet möglicher Gesetzeskonflikte. Sie und GitHub erklären sich damit einverstanden, sich der ausschließlichen Gerichtsbarkeit und dem Gerichtsstand der Gerichte in der Stadt und dem County von San Francisco, Kalifornien, USA, zu unterwerfen.

#### 2. Nichtabtretbarkeit
GitHub kann diese Nutzungsbedingungen und/oder die [GitHub-Datenschutzerklärung](https://github.com/site/privacy) jederzeit mit oder ohne Ihre Zustimmung ganz oder teilweise an eine beliebige Person oder Organisation abtreten oder delegieren, einschließlich der Lizenzgewährung in Abschnitt D.4. Sie dürfen ohne unsere vorherige schriftliche Zustimmung keine Rechte oder Verpflichtungen aus den Nutzungsbedingungen oder der Datenschutzerklärung abtreten oder delegieren, und jede nicht autorisierte Abtretung und Delegation durch Sie ist unwirksam.

#### 3. Abschnittsüberschriften und Zusammenfassungen
In dieser Vereinbarung enthält jeder Abschnitt Überschriften und kurze Zusammenfassungen der folgenden Nutzungsbedingungen. Diese Abschnittsüberschriften und kurzen Zusammenfassungen sind nicht rechtsverbindlich.

#### 4. Salvatorische Klausel, Unverzichtbarkeit und Fortbestand
Wenn ein Teil dieser Vereinbarung für ungültig oder nicht durchsetzbar erklärt wird, wird dieser Teil der Vereinbarung so ausgelegt, dass er der ursprünglichen Absicht der Parteien entspricht. Die anderen Abschnitte behalten weiterhin ihre uneingeschränkte Gültigkeit und Wirksamkeit. Ein Versäumnis von GitHub, eine Bestimmung dieser Vereinbarung durchzusetzen, gilt nicht als Verzicht auf unser Recht, eine solche Bestimmung durchzusetzen. Unsere Rechte aus dieser Vereinbarung bleiben auch nach einer Beendigung dieser Vereinbarung bestehen.

#### 5. Änderungen; vollständige Vereinbarung
Diese Vereinbarung kann nur durch einen schriftlichen Nachtrag geändert werden, der von einem autorisierten Vertreter von GitHub unterzeichnet wurde, oder durch die Veröffentlichung einer überarbeiteten Version von GitHub gemäß [Abschnitt Q. Änderungen dieser Bedingungen](#q-changes-to-these-terms). Diese Nutzungsbedingungen stellen, zusammen mit der GitHub-Datenschutzerklärung die vollständige und ausschließliche Erklärung der Vereinbarung zwischen Ihnen und uns dar. Diese Vereinbarung ersetzt jeden mündlichen oder schriftlichen Entwurf oder jede vorherige Vereinbarung sowie alle anderen Mitteilungen zwischen Ihnen und GitHub in Bezug auf den Gegenstand dieser Bedingungen, einschließlich aller Vertraulichkeits- oder Geheimhaltungsvereinbarungen.

#### 6. Fragen
Fragen zu den Nutzungsbedingungen? [Kontaktieren Sie uns](https://support.github.com/contact).
