---
title: Ergänzende GitHub-Bedingungen für die Microsoft-Volumenlizenzierung
redirect_from:
  - /articles/GitHub-Supplemental-Terms-for-Microsoft-Volume-Licensing/
  - /articles/github-supplemental-terms-for-microsoft-volume-licensing
versions:
  free-pro-team: '*'
---

Datum des Inkrafttretens dieser Fassung: 20. Juli 2020

Die folgenden ergänzenden GitHub-Bedingungen (einschließlich aller anwendbaren Auftragsformular) ergänzen den Microsoft-Volumenlizenzvertrag des Kunden ("**Microsoft-Kundenvertrag**") und regeln zusammen mit dem Microsoft-Kundenvertrag die Nutzung der Produkte durch den Kunden (wie unten definiert). Der Microsoft-Kundenvertrag wird durch diesen Verweis in diese Bedingungen miteinbezogen.  Großgeschriebene Begriffe, die in diesen ergänzenden Bedingungen verwendet, aber nicht definiert sind, haben die Bedeutungen, die ihnen im Microsoft-Kundenvertrag zugewiesen wurden.

Diese ergänzenden Bedingungen gelten für die folgenden Angebote von GitHub, die nachfolgend genauer definiert werden (zusammen die **„Produkte“**"):

-   GitHub Enterprise (bestehend aus GitHub Enterprise Server, welcher Add-On-Software und GitHub Enterprise Cloud umfassen kann) und GitHub One;

-   sämtlicher zugehörige Support

-   alle zugehörigen Dienstleistungen

Zu diesen ergänzenden Bedingungen gehören die folgenden Abschnitte und Anhänge, die jeweils durch Verweis aufgenommen sind:

* ABSCHNITT 1: Lizenzbedingungen für GitHub Enterprise Server

* ABSCHNITT 2: Nutzungsbedingungen für GitHub Enterprise Cloud

* SECTION 3: General Provisions; and

* EXHIBIT A: Definitions.



## ABSCHNITT 1: LIZENZBEDINGUNGEN FÜR GITHUB ENTERPRISE SERVER

Dieser Abschnitt 1 enthält die Bestimmungen für die Nutzung der Software durch den Kunden.

### 1.1 Lizenzgewährung

GitHub gewährt dem Kunden eine nicht exklusive, nicht übertragbare, weltweite, unentgeltliche, zeitlich beschränkte Lizenz zur dokumentationskonformen Installation und Verwendung der Software zu internen Geschäftszwecken des Kunden über die entsprechende Abonnementlaufzeit ausschließlich für die Anzahl an Abonnementlizenzen, die im Auftragsformular des Kunden angegeben ist. Die Software umfasst Komponenten, für die Dritte GitHub eine Lizenz gewähren. Dazu zählt auch Software, für die GitHub den Quellcode der entsprechenden Komponenten verfügbar machen muss. Der Quellcode entsprechender Komponenten wird auf Anfrage bereitgestellt. Unbeschadet des Vorstehenden gestattet diese Lizenz dem Kunden das Herunterladen und Ausführen von Microsoft SQL Server Standard Edition Container-Images für Linux-Dateien ("**SQL Server-Images**"), die nur wie dokumentiert mit der Software verwendet werden dürfen. Das Recht des Kunden, die SQL Server-Images zu verwenden, endet, wenn der Kunde nicht mehr über die Rechte zur Nutzung der Software verfügt und der Kunde die SQL Server-Images deinstallieren muss, wenn sein Nutzungsrecht endet. Die Microsoft Corporation kann SQL Server-Images jederzeit deaktivieren.

### 1.2 Beschränkungen

Sofern gesetzlich oder durch entsprechende Lizenzen von Dritten nicht ausdrücklich gestattet, dürfen der Kunde und seine verbundenen Unternehmen Folgendes nicht tun und Dritten Folgendes nicht gestatten: (i) Unterlizenzierung, Verkauf, Vermietung, Verpachtung, Übertragung, Abtretung oder Weiterverbreitung der Software, (ii) Hosten der Software zugunsten Dritter, (iii) Offenlegung der Software oder Gewährung von Zugriff auf die Software für Dritte mit Ausnahme der nach diesem Abschnitt 1 ausdrücklich zulässigen Fälle, (iv) Hacken oder Ändern des Lizenzschlüssels oder Vermeidung oder Änderung des Lizenzregistrierungsvorgangs, (v) mit Ausnahme von Kundenänderungen Änderungen der Software oder Entwicklung abgeleiteter Werke oder Zusammenführung der Software mit anderer Software, (vi) teilweise oder vollständige Disassemblierung, Dekompilierung, Umgehung von Codeobfuskation, Nachkonstruktion der Software oder Versuche zur Ableitung von Quellcode, (vii) Änderung, Verunklarung oder Löschung von Hinweisen auf Schutzrechte in der Software oder der Dokumentation oder (viii) nach diesen ergänzenden GitHub-Bedingungen nicht ausdrücklich gestattete anderweitige Verwendung oder Vervielfältigung der Software oder der Dokumentation.

### 1.3 Delivery.

GitHub stellt dem Kunden den Lizenzschlüssel auf einer sicheren, passwortgeschützten Website zum Herunterladen zur Verfügung. All deliveries under this Section 1 will be electronic. Zur Vermeidung von Zweifeln wird ausdrücklich darauf hingewiesen, dass der Kunde für die Installation jeglicher Software haftet und zustimmt, dass GitHub nach der Bereitstellung des Lizenzschlüssels keine weiteren Bereitstellungspflichten im Zusammenhang mit der Software entstehen. GitHub stellt Aktualisierungen mit ihrem Verfügbarwerden auf derselben Website zum Herunterladen bereit. Der Kunde muss die Software in gewerblich angemessenen Abständen aktualisieren, mindestens jedoch einmal (1-mal) pro Jahr. Der Kunde haftet für die Vertraulichkeit der Benutzernamen und Passwörter des Kunden.

### 1.4 Verification.

Der Kunde stellt GitHub auf dessen Anforderung umgehend einen per Software generierten Bericht bereit, aus dem hervorgeht, dass der Kunde die Software im Einklang mit diesen ergänzenden GitHub-Bedingungen nutzt. GitHub stellt dem Kunden jede zusätzliche Nutzung mit Wirksamkeit ab dem Datum in Rechnung, an dem die Nutzung zum ersten Mal über die Bestimmungen dieser ergänzenden GitHub-Bedingungen hinaus erfolgt.

### 1.5 Support

GitHub stellt technischen Support für die Software bereit, wie im Microsoft-Kundenvertrag weiter beschrieben. GitHub kann erweiterte Support-Angebote für die Software und Dienste (einschließlich der Premium-, Premium Plus- und Engineering Direct Support-Angebote) in Übereinstimmung mit den [Supportbedingungen](/enterprise/admin/enterprise-support/about-github-premium-support-for-github-enterprise), und zu dem /den in einem Auftragsformular oder Leistungsbeschreibung angegebenen Support-Level, Gebühren und Abonnementlaufzeiten anbieten. Ungeachtet anderslautender Bestimmungen im Microsoft-Kundenvertrag (i) unternimmt GitHub angemessene Anstrengungen zur Korrektur materieller, reproduzierbarer Fehler in der Software, sobald der Kunde einen Fehler meldet, ist jedoch nicht für die Bereitstellung von Support verantwortlich, wenn (a) eine andere Person (außer GitHub) die Software modifiziert; (b) der Kunde sein Betriebssystem oder seine Umgebung in einer Weise ändert, die sich nachteilig auf die Software oder deren Leistung auswirkt; (c) der Kunde die Software auf eine andere Art und Weise verwendet, als dies gemäß dem Microsoft-Kundenvertrag, diesem Abschnitt 1 oder der Dokumentation zulässig ist; oder (d) ein Versehen, eine Fahrlässigkeit oder ein Missbrauch der Software durch den Kunden vorliegt; und (ii) GitHub unterstützt eine bestimmte Version nur für ein (1) Jahr ab dem ursprünglichen Veröffentlichungsdatum oder sechs (6) Monate ab der letzten Aktualisierung der Version, je nachdem, welcher Zeitraum länger ist.

### 1.6 Updates; Releases.

#### 1.6.1 Generally.

GitHub stellt dem Kunden Aktualisierungen und Versionen der Software auf derselben sicheren Website bereit, über die der Kunde die Software und den Lizenzschlüssel heruntergeladen hat.

#### 1.6.2 Supported Releases.

GitHub leistet für eine bestimmte Version nur für ein (1) Jahr ab dem Veröffentlichungsdatum der Version bzw. sechs (6) Monate ab der letzten Aktualisierung der Version Support, je nachdem, welcher Zeitraum länger ist. Benötigt der Kunde Support für ältere Versionen der Software, muss er diesen Support gemäß den Bestimmungen eines einvernehmlich vereinbarten Auftragsformulars bzw. einer einvernehmlich vereinbarten Leistungsbeschreibung bezahlen.

### 1.7. Add-On-Software

Add-On-Software wird pro Benutzer lizenziert. Zur Vermeidung von Zweifeln und sofern in einem Auftragsformular nichts anderes angegeben ist, muss die Anzahl der Abonnementlizenzen, die der Kunde zu einem bestimmten Zeitpunkt für Add-On-Software besitzt, der Anzahl der Abonnementlizenzen entsprechen, die der Kunde für die Produkte gemäß dieser Vereinbarung besitzt. Wenn der Kunde beispielsweise ein Abonnement für Insights erwerben möchte und bereits Abonnementlizenzen für 100 Benutzer für die Produkte besitzt, muss er Abonnementlizenzen für 100 Benutzer für Insights erwerben.

### 1.8 Datenschutzrechtliche Aspekte bei der Nutzung von GitHub Insights und Learning Lab for Enterprise Server

Wenn die geplante Nutzung von GitHub Insights oder Learning Lab for Enterprise Server durch den Kunden die Verarbeitung personenbezogener Daten beinhaltet, ist der Kunde allein dafür verantwortlich, zu entscheiden, ob er eine Analyse der Auswirkungen auf den Datenschutz durchführt oder anderweitig eine formale rechtliche Analyse der geplanten Nutzung durch den Kunden vornimmt. Es liegt im alleinigen Ermessen des Kunden, ob er GitHub Insights oder Learning Lab for Enterprise Server zur Verarbeitung der Daten seiner Mitarbeiter bzw. Benutzer verwendet, und wenn der Kunde dies tut, ist er allein dafür verantwortlich, diese Verarbeitung in Übereinstimmung mit dem geltenden Recht durchzuführen.

### 1.9 Eingeschränkte Softwaregarantie

GitHub garantiert, dass die unmodifizierte Software für neunzig (90) Tage ab dem Datum, an dem sie zum ersten Download zur Verfügung gestellt wird, im Wesentlichen mit ihrer Dokumentation übereinstimmt. GitHub gibt keine Garantie, dass die Nutzung der Software durch den Kunden unterbrechungsfrei oder der Betrieb der Software fehlerfrei verlaufen wird. Diese Garantie gilt nicht, wenn der Kunde die Software auf eine Art und Weise ändert oder verwendet, die nach diesem Abschnitt 1 und der Dokumentation nicht ausdrücklich gestattet ist. Die einzige Verpflichtung von GitHub und das einzige Rechtsmittel des Kunden im Falle eines Verstoßes gegen diese beschränkte Garantie wird im Microsoft-Kundenvertrag festgelegt.

## SECTION 2: GITHUB ENTERPRISE CLOUD TERMS OF SERVICE

Upon creation of a Corporate Account and/or an Organization on the Service by Customer or by GitHub on Customer’s behalf, this Section 2 details terms applicable to Customer’s use of the Service.

### 2.1 Account Terms.

#### 2.1.1 Account Controls.

  **(i) Benutzer.** Der Kunde stimmt zu, dass Benutzer die letzte Verwaltungskontrolle über ihre individuellen Konten und deren Inhalte haben. [Die Standardnutzungsbedingungen von GitHub ](/github/site-policy/github-terms-of-service) regeln die Nutzung des Dienstes durch die Benutzer, außer in Bezug auf die Aktivitäten der Benutzer gemäß diesem Abschnitt 2.

  **(ii) Organisationen.** Der Kunde hat die letzte Verwaltungskontrolle über alle Organisationen, die im Namen des Kunden erstellt werden, und alle benutzergenerierten Inhalte, die in den Repositorys seiner Organisation(en) veröffentlicht werden, wobei hierfür dieser Abschnitt 2 gilt. This Section 2 will govern the use of Customer’s Organization(s).

#### 2.1.2 Account Requirements.

Um ein Konto zu erstellen, muss der Kunde folgende Bedingungen einhalten:

**(i)** Der Kunde darf keine Konten zur Nutzung durch Personen unter 13 Jahren erstellen. Erlangt GitHub Kenntnis von Benutzern unter 13 Jahren, wird das Konto des betreffenden Benutzers unverzüglich aufgelöst. Befinden sich der Kunde oder sein(e) Benutzer in einem anderen Land als den Vereinigten Staaten, kann das Mindestalter des betreffenden Landes höher sein. In diesem Fall haftet der Kunde für die Einhaltung der Gesetze des betreffenden Landes.

**(ii)** Die Anmeldeinformationen eines Benutzers dürfen nicht von mehreren Personen verwendet werden.

**(iii)** Customer must not use the Service (a) in violation of export control or sanctions laws of the United States or any other applicable jurisdiction, (b) if it is located in or ordinarily resident in a country or territory subject to comprehensive sanctions administered by the U.S. Office of Foreign Assets Control (OFAC), or (c) if Customer is or is working on behalf of a [Specially Designated National (SDN)](https://www.treasury.gov/resource-center/sanctions/SDN-List/Pages/default.aspx) or a person subject to similar blocking or denied party prohibitions. For more information, please see [GitHub’s Trade Controls policy](/github/site-policy/github-and-trade-controls).

#### 2.1.3 Account Security.

Der Kunde haftet für Folgendes: (i) sämtliche in seinem Firmenkonto veröffentlichten Inhalte und ausgeführten Aktivitäten, (ii) Gewährleistung der Sicherheit der Anmeldeinformationen für das Konto und (iii) umgehende [Mitteilung an GitHub](https://support.github.com/contact) bei Feststellung der unbefugten Nutzung des oder des unbefugten Zugriffs auf den Dienst über sein Konto.  GitHub will not be liable for any loss or damage from Customer’s failure to comply with this Section 2.1.3.

#### 2.1.4 Additional Terms.

In bestimmten Fällen können für die Nutzung des Dienstes durch den Kunden Bedingungen Dritter gelten. Wenn der Kunde beispielsweise Mitglied einer Organisation mit eigenen Bedingungen oder Lizenzvereinbarungen ist, kann der Kunde eine Anwendung herunterladen, die in den Dienst integriert ist, oder der Kunde kann den Dienst zur Authentifizierung bei einem anderen Dienst nutzen. Während der Microsoft-Kundenvertrag, einschließlich dieser ergänzenden GitHub-Bedingungen, die vollständige Vereinbarung von GitHub mit dem Kunden darstellt, unterliegen die Beziehungen zwischen GitHub und dem Kunden den Bedingungen anderer Parteien.

#### 2.1.5 Bestimmungen für US-Bundesbehörden Federal Government Terms.

If Customer is a U.S. federal government agency or otherwise accessing or using any portion of the Service in a government capacity, the [U.S. Federal Government Amendment](/github/site-policy/amendment-to-github-terms-of-service-applicable-to-us-federal-government-users) applies, and Customer agrees to its provisions.

### 2.2 Compliance with Laws; Acceptable Use; Privacy.

#### 2.2.1 Compliance with Laws and Regulations.

Die Nutzung des Dienstes durch den Kunden darf keine anwendbaren Gesetze verletzen, unter anderem Urheberrechts- und Markenschutzgesetze, Ausfuhrkontrollgesetze und Vorschriften seiner Rechtsordnung.

#### 2.2.2 Acceptable Use.

Customer’s use of the Service must comply with [GitHub's Acceptable Use Policies](/github/site-policy/github-acceptable-use-policies) and [GitHub’s Community Guidelines](/github/site-policy/github-community-guidelines). Der Kunde darf den Dienst in keiner Rechtsordnung für rechtwidrige, obszöne, beleidigende oder betrügerische Inhalte oder Aktivitäten nutzen. Dazu zählen unter anderem die Befürwortung oder Verursachung von Schäden, die Störung oder Verletzung der Integrität oder Sicherheit von Netzwerken oder Systemen, die Umgehung von Filtern, das Senden nicht angeforderter, beleidigender oder betrügerischer Nachrichten oder von Viren oder Schadcode und die Verletzung von Rechten Dritter.

#### 2.2.3 Privacy.
[The GitHub Privacy Statement](/github/site-policy/github-privacy-statement) and the [GitHub Data Protection Addendum](/github/site-policy/github-data-protection-addendum) provide detailed notice of GitHub's privacy and data use practices as well as GitHub's processing and security obligations with respect to Customer Personal Data. Any person, entity, or service collecting data from the Service must comply with the [GitHub Privacy Statement](/github/site-policy/github-privacy-statement), particularly in regards to the collection of Users' Personal Information (as defined in the GitHub Privacy Statement). Erfasst der Kunde personenbezogene Daten von Benutzern von GitHub, verwendet er diese ausschließlich für den Zweck, für den der externe Benutzer dies erlaubt hat. Der Kunde sorgt für den angemessenen Schutz entsprechender personenbezogener Daten und beantwortet Beschwerden, Aufforderungen zur Löschung und Kontaktverbote von GitHub oder externen Benutzern umgehend.

### 2.3 Content Responsibility; Ownership; License Rights.

#### 2.3.1 Responsibility for User-Generated Content.
Kunden können im Rahmen der Nutzung des Dienstes benutzergenerierte Inhalte erstellen oder hochladen. Der Kunde haftet unabhängig von der Form der benutzergenerierten Inhalte alleinig für alle benutzergenerierten Inhalte, die er veröffentlicht, hochlädt, verlinkt oder auf andere Weise über den Dienst verfügbar macht. GitHub haftet nicht für die Veröffentlichung oder den falschen Gebrauch benutzergenerierter Inhalte.

#### 2.3.2 Ownership of Content, Right to Post, and License Grants.

**(i)** Der Kunde behält die Eigentumsrechte an Kundeninhalten, die der Kunde erstellt oder die sein Eigentum sind. Der Kunde erklärt sich einverstanden, dass er (a) für die Kundeninhalte haftet, (b) ausschließlich Kundeninhalte sendet, für die er über das Recht zur Veröffentlichung verfügt (einschließlich Inhalten von Dritten und benutzergenerierter Inhalte), und (c) in vollem Umfang alle Bedingungen für Lizenzen Dritter im Zusammenhang mit Kundeninhalten erfüllt, die der Kunde veröffentlicht.

**(ii)** Customer grants the rights set forth in Sections 2.3.3 through 2.3.6, free of charge and for the purposes identified in those sections until such time as Customer removes Customer Content from GitHub servers, except for Content Customer has posted publicly and that External Users have Forked, in which case the license is perpetual until such time as all Forks of Customer Content have been removed from GitHub servers. Lädt der Kunde Kundeninhalte hoch, für die bereits eine Lizenz besteht, die GitHub die erforderlichen Rechte zur Ausführung des Dienstes gewährt, ist keine weitere Lizenz erforderlich.

#### 2.3.3 License Grant to GitHub.
Der Kunde gewährt GitHub das Recht, Kundeninhalte zu speichern, zu analysieren und anzuzeigen und gelegentlich Kopien zu erstellen, insoweit dies zur Bereitstellung des Dienstes erforderlich ist. Dazu zählt das Recht, Kundeninhalte in die GitHub-Datenbank zu kopieren und Sicherungen zu erstellen, Kundeninhalte dem Kunden und anderen anzuzeigen, denen der Kunde die Inhalte anzeigen möchte, Kundeninhalte für einen Suchindex oder auf andere Weise auf den GitHub-Servern zu analysieren, Kundeninhalte für externe Benutzer freizugeben, für die der Kunde die Inhalte freigeben möchte, und Kundeninhalte wiederzugeben, insoweit es sich um Musik, Videos usw. handelt. Diese Rechte gelten sowohl für öffentliche als auch private Repositorys. Diese Lizenz gewährt GitHub nicht das Recht, Kundeninhalte zu verkaufen oder auf andere Weise zu verbreiten oder außerhalb des Dienstes zu verwenden. Der Kunde gewährt GitHub die nötigen Rechte zur Verwendung von Kundeninhalten ohne Namensnennung und zur Durchführung angemessener Änderungen von Kundeninhalten, insoweit dies für die Bereitstellung des Dienstes erforderlich ist.

#### 2.3.4 License Grant to External Users.
**(i)** Inhalte, die der Kunde öffentlich postet, darunter Issues, Kommentare und Beiträge in Repositorys externer Benutzer, können von anderen angezeigt werden. Indem der Kunde seine Repositorys für die öffentliche Anzeige konfiguriert, stimmt er zu, dass externe Benutzer die Repositorys des Kunden anzeigen und kopieren können.

**(ii)** Konfiguriert der Kunde seine Pages und Repositorys für die öffentliche Anzeige, gewährt der Kunde externen Benutzern eine nicht exklusive, weltweite Lizenz zur Verwendung, Anzeige und Wiedergabe von Kundeninhalten über den Dienst und zur Reproduktion von Kundeninhalten ausschließlich im Dienst, insoweit dies nach den von GitHub bereitgestellten Funktionen zulässig ist (beispielsweise durch Forking). Customer may grant further rights to Customer Content if Customer [adopts a license](/github/building-a-strong-community/adding-a-license-to-a-repository#including-an-open-source-license-in-your-repository). Wenn der Kunde Kundeninhalte hochlädt, die er nicht erstellt hat oder die ihm nicht gehören, haftet der Kunde dafür sicherzustellen, dass die hochgeladenen Kundeninhalte nach den Bedingungen lizenziert sind, mit denen diese Rechte externen Benutzern gewährt werden.

#### 2.3.5 Contributions Under Repository License.
Macht der Kunde Beiträge zu einem Repository mit einem Lizenzhinweis, lizenziert der Kunde seine Beiträge zu denselben Bedingungen und erklärt, dass er das Recht hat, den entsprechenden Beitrag zu diesen Bedingungen zu lizenzieren. Verfügt der Kunde über eine gesonderte Vereinbarung zur Lizenzierung seiner Beiträge nach anderen Bedingungen wie z. B. einer Mitwirkungslizenzvereinbarung, hat die entsprechende Vereinbarung Vorrang.

#### 2.3.6 Moral Rights.
Der Kunde behält alle Urheberpersönlichkeitsrechte an Kundeninhalten, die er hochlädt, veröffentlicht oder an einen Teil des Dienstes sendet, die Rechte auf Unantastbarkeit und Namensnennung eingeschlossen. However, Customer waives these rights and agrees not to assert them against GitHub, solely to enable GitHub to reasonably exercise the rights granted in Section 2.3, but not otherwise.

### 2.4. Private Repositorys

#### 2.4.1 Control.

Der Kunde haftet für die Verwaltung des Zugriffs auf seine privaten Repositorys, darunter Einladungen, die Verwaltungskontrolle von Organisationen und Teams und die Beendigung des Zugriffs.

#### 2.4.2 Confidentiality.

GitHub betrachtet Kundeninhalte in den privaten Repositorys des Kunden als vertrauliche Informationen des Kunden. GitHub schützt und hält die Kundeninhalte privater Repositorys in Übereinstimmung mit der geltenden Vertraulichkeitsbestimmung im Microsoft-Kundenvertrag streng vertraulich.

#### 2.4.3 Access.

GitHub kann ausschließlich in folgenden Fällen auf private Repositorys des Kunden zugreifen: (i) aus Gründen des Supports mit dem Wissen und unter Zustimmung des Kunden oder (ii) wenn der Zugriff aus Sicherheitsgründen erforderlich ist.  Der Kunde kann zusätzlichen Zugriff auf seine privaten Repositorys aktivieren. Beispielsweise kann der Kunde mehrere GitHub-Dienste oder -Features aktivieren, für die zusätzliche Rechte für Kundeninhalte in privaten Repositorys erforderlich sind. Diese Rechte können je nach Dienst oder Feature andere sein. GitHub behandelt Kundeninhalte in den privaten Repositorys des Kunden jedoch weiterhin als vertrauliche Informationen des Kunden. Sind für diese Dienste oder Features neben den Rechten, die für die Dienstbereitstellung erforderlich sind, zusätzliche Rechte erforderlich, gibt GitHub eine Erläuterung dieser Rechte.

#### 2.4.4 Exclusions.

Hat GitHub Grund zu der Annahme, dass Inhalte eines privaten Repositorys gegen Gesetze oder diese ergänzenden GitHub-Bedingungen verstoßen, hat GitHub das Recht, auf die betreffenden Inhalte zuzugreifen und sie zu prüfen sowie zu entfernen. Darüber hinaus kann GitHub gesetzlich verpflichtet sein, Inhalte in privaten Repositorys des Kunden offenzulegen. Sofern GitHub nicht durch gesetzliche Auflagen oder in Reaktion auf eine Sicherheitsbedrohung oder ein sonstiges Sicherheitsrisiko anders gebunden ist, informiert GitHub über entsprechende Maßnahmen.

### 2.5. Urheberrechtsvermerke

#### 2.5.1 GitHub's Rights to Content.

Das Erscheinungsbild des Dienstes ist wie folgt urheberrechtlich geschützt: „© GitHub, Inc. Alle Rechte vorbehalten.“ Der Kunde darf ohne die ausdrückliche schriftliche Genehmigung durch GitHub keine Teile der HTML-/CSS-, Javascript- oder Grafikdesignelemente oder -konzepte duplizieren, kopieren oder wiederverwenden.

#### 2.5.2 Copyright Infringement and DMCA Policy.

Wenn der Kunde Urheberrechtsinhaber ist und der Ansicht ist, dass Inhalte im Dienst gegen die Urheberrechte des Kunden verstoßen, kann er sich nach der [Digital Millenium Copyright Act-Richtlinie](https://github.com/contact/dmca) von GitHub an GitHub wenden, indem er GitHub über das [DMCA-Formular](https://github.com/contact/dmca-notice) oder per E-Mail an copyright@github.com entsprechend informiert.

#### 2.5.3 GitHub Trademarks and Logos.

Wenn der Kunde Marken von GitHub verwenden möchte, muss er sämtliche Markenrichtlinien von GitHub einhalten, die Richtlinien auf der Seite zu [GitHub-Logos und ihrer Nutzung](https://github.com/logos) eingeschlossen.

### 2.6 Suspension.

GitHub hat das Recht, den Zugriff auf den Dienst einschließlich der Entfernung von Inhalten bei Verstoß gegen den Microsoft-Kundenvertrag, einschließlich diesen ergänzenden GitHub-Bedingungen oder zum Schutz der Integrität, Betriebsfähigkeit und Sicherheit des Dienstes mit oder ohne vorherige Mitteilung mit sofortiger Wirkung jederzeit teilweise oder vollständig auszusetzen. Sofern dies nicht gesetzlich oder durch ein gerichtliches Verfahren verboten ist bzw. um eine unmittelbare Schädigung des Dienstes oder Dritter zu verhindern, stellt GitHub in der Regel eine Benachrichtigung in Form eines Banners oder einer E-Mail auf oder vor einer solchen Aussetzung bereit. GitHub nimmt Aussetzungen nach seinem Ermessen und nach Treu und Glauben nach Bedarf vor, um die Integrität, Betriebsfähigkeit und Sicherheit des Dienstes zu erhalten.

### 2.7 Kommunikation mit GitHub

Für vertragliche Zwecke erklärt sich der Kunde (1) damit einverstanden, Mitteilungen in elektronischer Form über die von ihm angegebene E-Mail-Adresse oder über den Dienst zu erhalten; und (2) stimmt zu, dass alle von GitHub elektronisch bereitgestellten Nutzungsbedingungen, Vereinbarungen, Mitteilungen, Bekanntmachungen und andere Informationen alle rechtlichen Anforderungen erfüllen, die diese Mitteilungen erfüllen würden, wenn sie in Papierform vorliegen würden. Dieser Abschnitt hat keinen Einfluss auf die nicht abdingbaren Rechte des Kunden.

### 2.8 Service Level Agreement.

GitHub’s quarterly uptime commitment for the Service is provided in the [Enterprise Service Level Agreement](/github/site-policy/github-enterprise-service-level-agreement). Customer will be entitled to a service credit if GitHub does not meet its service level.

### 2.9 Service Changes.

Die Änderung des Dienstes durch GitHub erfolgt durch Updates und Hinzufügen neuer Funktionen. Subject to Section 2.8, GitHub reserves the right at any time to modify or discontinue, temporarily or permanently, the Service (or any part of it) with or without notice.

### 2.10 Zusätzliche Servicefunktionen

Einige Servicefunktionen unterliegen möglicherweise zusätzlichen Bedingungen, wie sie in den [zusätzlichen Produktbedingungen für GitHub](/github/site-policy/github-additional-product-terms) festgelegt sind. Durch den Zugriff auf oder die Nutzung dieser Funktionen stimmt der Kunde den zusätzlichen Produktbedingungen für GitHub zu.

## ABSCHNITT 3: ALLGEMEINE BESTIMMUNGEN

This Section 3 sets forth the terms and conditions applicable to Customer’s purchase and use of any of the Products.

### 3.1 Laufzeit; Kündigung; Wirksamkeit der Kündigung.

#### 3.1.1 Term.
Die Laufzeit dieser ergänzenden GitbHub-Bedingungen bleiben solange in Kraft, bis sie durch eine der Parteien nach diesem Abschnitt 3.1 beendet werden.

#### 3.1.2. Ordentliche Kündigung; Kontostornierung
Jede Partei kann ein Auftragsformular oder diese ergänzenden GitHub-Bedingungen schriftlich ohne Angabe von Gründen mit einer Frist von dreißig (30) Tagen zum Ende der jeweiligen Abonnementlaufzeit kündigen. Kündigt der Kunde ein Auftragsformular oder eine diese ergänzenden GitHub-Bedingungen, haftet der Kunde für die ordnungsgemäße Auflösung seines Kontos bei GitHub über die Einstellungen in der allgemeinen Navigationsleiste oben im Bildschirm. GitHub kann Konten nicht auf Anfrage per E-Mail oder Telefon hin auflösen.

#### 3.1.3 Termination for Material Breach.
Jede Partei kann diese ergänzenden GitHub-Bedingungen fristlos schriftlich kündigen, wenn die andere Partei eine wesentliche Pflicht nach diese ergänzenden GitHub-Bedingungen verletzt und die Verletzung nicht innerhalb von dreißig (30) Tagen ab dem Mitteilungserhalt nacherfüllt.  GitHub kann diese ergänzenden GitHub-Bedingungen kündigen, wenn das Kundenkonto seit mehr als 90 Tagen gesperrt ist.

#### 3.1.4 Wirksamkeit der Kündigung
Der Kunde kann mit Beendigung dieser ergänzenden GitHub-Bedingungen keine weiteren Auftragsformulare einreichen. Diese ergänzenden GitHub-Bedingungen bleiben jedoch für alle ggf. aktiven Auftragsformulare in Kraft. Wenn ein Auftragsformular beendet wird oder abläuft, gilt für das betreffende Auftragsformular Folgendes: (i) Die Abonnementlaufzeit endet mit sofortiger Wirkung. (ii) Alle Abonnementlizenzen in dem Auftragsformular werden automatisch beendet, und der Kunde ist nicht länger zur Nutzung der Produkte berechtigt. (iii) Schuldet der Kunde vor der Beendigung Gebühren, sind diese mit sofortiger Fälligkeit zahlbar. (iv) Der Kunde muss sämtliche Kopien der Software in seinem Besitz oder unter seiner Kontrolle vernichten und GitHub dies schriftlich bestätigen; (v) jede Partei gibt umgehend sämtliche vertraulichen Informationen der anderen Partei zurück (oder vernichtet diese auf Aufforderung der anderen Partei), insoweit dies für den Dienst zulässig ist. Der Kunde kann unbeschadet der vorhergehenden Bestimmungen innerhalb von neunzig (90) Tagen nach Beendigung oder Ablauf dieser Vereinbarung oder eines Auftragsformulars weiterhin auf die Software zugreifen, um seine Daten zu migrieren, und die Migration der Daten in seinen Repositorys anfordern. Der Kunde darf die Software oder den Dienst in diesem Zeitraum jedoch nicht zu Produktionszwecken nutzen. Alle Bestimmungen, die aufgrund ihrer Art billigerweise gültig bleiben sollten, bleiben nach Beendigung oder Ablauf dieser Vereinbarung oder eines Auftragsformulars gültig.

### 3.2 Feedback
Der Kunde kann GitHub Feedback zu den Produkten geben. Feedback ist freiwillig und stellt keine vertrauliche Kundeninformation dar, auch wenn es als solche bestimmt ist. GitHub ist berechtigt, dieses Feedback in vollem Umfang auszuwerten und zu nutzen, um (i) den Betrieb, die Funktionalität und die Nutzung der bestehenden und zukünftigen Produktangebote von GitHub zu verbessern und diese Angebote zu vermarkten; und (ii) aggregierte Statistiken über die Qualität der Produkte zu veröffentlichen, vorausgesetzt, dass keine Daten in einer solchen Veröffentlichung verwendet werden, mit denen der Kunde, seine Mitarbeiter oder der firmeneigene Softwarecode des Kunden spezifisch identifiziert werden können.

### 3.3 Einhaltung von Gesetzen und Vorschriften
Der Kunde wird bei der Nutzung der Produkte alle anwendbaren Gesetze und Vorschriften einhalten, insbesondere Datenschutz- und Arbeitsgesetze und -vorschriften.

### 3.4 Vorrang
Im Falle eines Widerspruchs zwischen den Ergänzenden Bedingungen einerseits und einem Auftragsformular andererseits gilt das Auftragsformular nur in Bezug auf diesen Auftrag. Im Falle eines Widerspruchs zwischen den Ergänzenden Bedingungen (einschließlich eines Auftragsformular) und dem Microsoft-Kundenvertrag gelten die Ergänzenden Bedingungen nur in Bezug auf den Gegenstand.

## EXHIBIT A: DEFINITIONS

Ein **„aktiver Benutzer“** ist ein Benutzer, der versucht, während eines Ausfalls auf den Dienst zuzugreifen.

**”Add-On-Software"** bezeichnet Advanced Security, Insights, Learning Lab for Enterprise Server und andere zusätzliche Software-Add-On-Produkte, die GitHub von Zeit zu Zeit anbieten kann.

**„Advanced Security“** bezeichnet die Software-Funktion, die es dem Kunden ermöglicht, Sicherheitslücken durch anpassbare und automatisierte semantische Codeanalyse zu identifizieren.

Ein **„verbundenes Unternehmen“** ist ein Unternehmen, das direkt oder indirekt eine Partei kontrolliert, von einer Partei kontrolliert wird oder unter gemeinsamer Kontrolle mit einer Partei steht, wobei „Kontrolle“ über fünfzig Prozent (50 %) der Anteile oder Rechte zur Steuerung der Unternehmensführung bedeutet.

**„Alle Benutzer“** sind zusammenfassend die Benutzer des Kunden und externen Benutzer, die den Dienst nutzen.

**„Connect“** bzw. **„GitHub Connect“** ist ein in der Software enthaltenes Feature, mit dem der Kunde die Software mit dem Dienst verbinden kann. Die Nutzung von GitHub Connect unterliegt den GitHub Connect-Bedingungen, wie sie in den [zusätzlichen Produktbedingungen für GitHub](/github/site-policy/github-additional-product-terms) festgelegt sind.

**„Inhalt(e)“** sind unter anderem Texte, Daten, Artikel, Bilder, Fotografien, Grafiken, Software, Anwendungen, Designs, Features und sonstige Materialien, die über den Dienst vorgestellt, angezeigt oder auf andere Weise verfügbar gemacht werden.

Ein **„Firmenkonto“** ist ein Konto, das ein Benutzer im Namen eines Unternehmens erstellt.

**„Kunde“** bedeutet zusammenfassend das Unternehmen oder die Organisation, die durch Klicken auf „ICH STIMME ZU“ oder eine vergleichbare Schaltfläche oder den Zugriff auf Produkte, mit mit GitHub diese ergänzenden GitHub-Bedingungen abgeschlossen hat, sowie verbundene Unternehmen und Vertreter des Kunden.

**„Kundeninhalte“** sind Inhalte, die der Kunde erstellt oder besitzt oder an denen er die Rechte hält.

**„Kundenänderungen“** sind Änderungen an der Software, die der Kunde ausschließlich zwecks Entwicklung von Fehlerbehebungen, Anpassungen oder zusätzlichen Features von Bibliotheken vornehmen kann, die durch Open-Source-Lizenzen lizenziert sind und ggf. in der Software enthalten oder mit dieser verknüpft sind.

**„Dokumentation“** sind alle Handbücher, Dokumentationen und sonstigen Hilfsmaterialien zu der Software oder dem Dienst, die GitHub dem Kunden zur Verfügung oder bereitstellt.

Das **„Datum des Inkrafttretens“** ist das Datum, an dem der Kunde (i) den vorstehend beschriebenen Geschäftsbedingungen dieser ergänzenden GitHub-Bedingungen zustimmt oder (ii) zum ersten Mal Produkte bestellt, je nachdem, welches Datum früher liegt.

Die **„grundlegenden Dienste“** sind die Dienste, die für die Steuerungsfunktionen der GitHub-Basisversion notwendig sind, unter anderem Funktionen für die Erstellung, das Forking und das Klonen von Repositorys, die Erstellung, den Commit und das Mergen von Branches, die Erstellung, die Prüfung und das Mergen von Pull Requests und Web-, API- und Git-Client-Schnittstellen zu den Basis-Git-Workflows. Beispiele für nicht enthaltene Peripherie-Features und -Dienste sind Webhooks, Gists, Pages und E-Mail-Benachrichtigungen.

Ein **„externer Benutzer“** ist eine natürliche Person ohne die Benutzer des Kunden, die den Dienst besuchen oder nutzen.

**„Gebühren“** sind die Gebühren, die der Kunde an GitHub zahlen muss, um (i) während der jeweiligen Abonnementlaufzeit die Produkte zu nutzen oder (ii) Dienstleistungen zu erhalten, wobei die entsprechenden Gebühren in einem Auftragsformular oder einer Leistungsbeschreibung angegeben sind.

**„Feedback“** sind alle Ideen, Kenntnisse, Algorithmen, Codebeiträge, Vorschläge, Verbesserungsanfragen, Empfehlungen und jedes sonstige Feedback zu Produkten oder Diensten von GitHub.

**„Forking“** ist der Vorgang des Kopierens von Inhalten eines Repositorys in ein anderes Repository.

**„GitHub“** bezeichnet zusammenfassend GitHub, Inc. und seine verbundenen Unternehmen und Vertreter.

**„GitHub-Inhalte“** sind Inhalte, die GitHub erstellt oder besitzt oder an denen es die Rechte hält.

**„GitHub-Insights“** oder **„Insights“** bezeichnet das Software-Feature, das dem Kunden Metriken, Analysen und Empfehlungen in Bezug auf die Nutzung der Software zur Verfügung stellt. GitHub Insights enthält keine früheren Features von GitHub, einschließlich Organization-Insights und Repository-Insights.

**„GitHub One“** bezeichnet das Produktpaket bestehend aus GitHub Enterprise, Advanced Security, Insights, Learning Lab for Enterprise Server und Premium Plus oder Engineering Direct Support.

**„Learning Lab für Enterprise Server**" bezeichnet das Software-Feature, mit der Benutzer mehr über die GitHub-Funktionalität, einschließlich der zugehörigen Dokumentation, erfahren können.

Ein **„Lizenzschlüssel“** ist eine Datendatei, mit der der Zugriffskontrollmechanismus der Software dem Kunden die Installation, den Betrieb und die Nutzung der Software ermöglicht.

Ein **„Maschinenkonto“** ist ein Konto, das von einer natürlichen Person registriert wurde, die im Namen des Maschinenkontos den geltenden Nutzungsbedingungen zustimmt, eine gültige E-Mail-Adresse angibt und für die entsprechenden Aktionen haftet. Maschinenkonten werden ausschließlich zur Ausführung automatisierter Aufgaben genutzt. Die Aktionen eines Maschinenkontos können von mehreren Benutzern gesteuert werden. Die endgültige Haftung für die Maschinenaktionen liegt jedoch bei dem Kontoinhaber.

Ein **„Auftragsformular“** ist eine schriftliche oder elektronische Dokumentation (einschließlich eines Angebots), die die Parteien zur Bestellung der Produkte verwenden.

Eine **„Organisation“** ist ein gemeinsamer Arbeitsbereich, der mit einem Unternehmen oder einem oder mehreren Benutzern verbunden sein kann und über den mehrere Benutzer gleichzeitig gemeinsam an mehreren Projekten arbeiten können. Ein Benutzer kann Mitglied mehrerer Organisationen sein.

Ein **„Ausfall“** ist die Unterbrechung eines grundlegenden Dienstes, die mehr als 50 % der aktiven Benutzer betrifft.

Ein **„privates Repository“** ist ein Repository, über das ein Benutzer den Zugriff auf Inhalte steuern kann.

**„Dienstleistungen“** sind Schulungs-, Beratungs- oder Implementierungsleistungen, die GitHub gemäß einer gemeinsam unterzeichneten Leistungsbeschreibung erbringt. Support zählt nicht zu den Dienstleistungen.

Ein **„öffentliches Repository“** ist ein Repository, dessen Inhalte für alle Benutzer sichtbar sind.

Eine **„Version“** ist eine Softwareversion, die GitHub seinen Kunden einschließlich aller zugehörigen Änderungen der Dokumentation allgemein verfügbar macht und die Verbesserungen, neue Features oder neue Funktionen enthält und im Allgemeinen durch die Änderung der Ziffer rechts von der ersten Dezimalstelle (z. B. von x.x.x in x.y.x) oder links von der ersten Dezimalstelle (z. B. von x.x.x in y.x.x) gekennzeichnet wird.

**„Vertreter“** sind die Mitarbeiter, Beauftragten, unabhängigen Auftragnehmer, Berater und Rechts- und Finanzberater einer Partei.

**„Scraping“** ist die Extrahierung von Daten aus dem Dienst mithilfe automatischer Prozesse wie z. B. Bots oder Webcrawlern und umfasst nicht die Erfassung von Informationen über das GitHub-API.

Der **„Dienst“** ist der gehostete GitHub Enterprise Cloud-Dienst. Der Dienst umfasst Folgendes:  Organisationskonten, SAML Single Sign-On, Zugriffsbereitstellung und sämtliche entsprechende Dokumentation. Diese Liste an Features und Diensten ist nicht erschöpfend und kann regelmäßig aktualisiert werden.

Eine **„Dienstgutschrift“** ist eine Gutschrift in Dollar, die wie unten beschrieben berechnet wird und die GitHub anspruchsberechtigten Konten gutschreiben kann.

**„Software“** ist die lokale GitHub Enterprise Server-Software. Software includes the GitHub Connect feature, any applicable Documentation, any Updates to the Software that GitHub provides to Customer or that it can access under these GitHub Supplemental Terms, and, if included in Customer’s subscription, Add-On Software.

Eine **„Leistungsbeschreibung“** ist eine gemeinsam unterzeichnete Leistungsbeschreibung, die im Detail die Dienstleistungen, die GitHub erbringen wird, sowie alle entsprechenden Gebühren und die entsprechenden Pflichten der Parteien aufführt.

Eine **„Abonnementlizenz“** ist die Lizenz, die den einzelnen Benutzern zwecks Installation, Betrieb und Nutzung der Produkte sowie Zugriff auf diese im Namen des Kunden zugeordnet wird. Der Kunde kann jedem Benutzer nur eine Abonnementlizenz für seine GitHub Enterprise Server-Instanzen und GitHub Enterprise Cloud-Organisationen zuordnen. Jeder Benutzer kann auf die Zahl an Enterprise Server-Instanzen oder Enterprise Cloud-Organisationen zugreifen, die der Kunde zulässt. Um Zweifel auszuschließen, wird jedoch ausdrücklich darauf hingewiesen, dass der Kunde nach Zuordnung einer Abonnementlizenz zu einem Benutzer nicht berechtigt ist, die Abonnementlizenz so zu gabeln, dass ein Benutzer eine Abonnementlizenz für Enterprise Server und ein anderer Benutzer dieselbe Abonnementlizenz für eine andere Instanz von GitHub Enterprise Server oder eine GitHub Enterprise Cloud-Organisation verwenden kann. Abonnementlizenzen werden benutzerabhängig gewährt, und eine gegebene Abonnementlizenz darf nicht durch mehrere Benutzer verwendet werden. Der Kunde kann eine Abonnementlizenz erst neunzig (90) Tage nach der letzten Neuzuordnung derselben Abonnementlizenz einem neuen Benutzer zuordnen, es sei denn, die Neuzuordnung erfolgt aufgrund von (i) dauerhaftem Hardwareausfall oder -verlust, (ii) Beendigung der Beschäftigung oder des Vertrags des Benutzers oder (iii) vorübergehender Neuzuordnung von Abonnementlizenzen zur Abdeckung der Abwesenheit eines Benutzers. Weist der Kunde die Abonnementlizenz eines Benutzers einem anderen Benutzer zu, muss er den Zugriff des bisherigen Benutzers auf die Abonnementlizenz und die Kundenorganisationen sperren.

Die **„Abonnementlaufzeit“** beträgt ein (1) Jahr ab dem entsprechenden Datum des Inkrafttretens eines Auftrags oder wie in einem Auftragsformular anders angegeben.

**„Support“** ist technischer Support für die Software oder den Dienst, den GitHub bereitstellen kann.

Eine **„Aktualisierung“** ist eine Softwareversion, die GitHub seinen Kunden einschließlich aller zugehörigen Änderungen der Dokumentation allgemein zur Verfügung stellt und die Fehlerkorrekturen oder -behebungen enthält und im Allgemeinen durch eine Änderung der Ziffer rechts von der zweiten Dezimalstelle (z. B. von x.x.x in x.x.y) gekennzeichnet wird.

Die **„Verfügbarkeit“** ist der Prozentanteil der Zeit in einem gegebenen Quartal, in dem die grundlegenden Dienste von GitHub nicht durch einen Ausfall unterbrochen werden, der mehr als 50 % der aktiven Benutzer betrifft

Ein **„Benutzer“** ist (i) im Zusammenhang mit der Software eine Einzelperson oder ein Maschinenkonto, die bzw. das die Ausführung der Software initiiert oder mit der Software zwecks Ausführung ihrer Funktionen interagiert oder diese zu diesem Zweck steuert, und (ii) im Zusammenhang mit dem Dienst eine Einzelperson oder ein Maschinenkonto, die bzw. das (a) auf den Dienst zugreift oder den Dienst nutzt, (b) auf einen beliebigen Teil des Kundenkontos zugreift oder einen beliebigen Teil des Kundenkontos nutzt oder (c) die Nutzung des Kundenkontos zwecks Ausführung von Funktionen steuert, wobei dies jeweils im Namen des Kunden erfolgt. Die Anzahl der Benutzer darf die Anzahl der vom Kunden erworbenen Abonnementlizenzen nicht überschreiten.

**„Benutzergenerierte Inhalte“** sind Inhalte, die ein Dritter oder ein externer Benutzer erstellt hat oder besitzt.
