---
title: GitHub-Unterauftragsverarbeiter und -Cookies
redirect_from:
  - /subprocessors/
  - /github-subprocessors/
  - /github-tracking/
  - /github-cookies/
  - /articles/github-subprocessors-and-cookies
versions:
  free-pro-team: '*'
---

Datum des Inkrafttretens: **12. August 2020**

GitHub bietet viel Transparenz darüber, wie wir Ihre Daten verwenden, wie wir Ihre Daten sammeln und mit wem wir Ihre Daten teilen. Zu diesem Zweck stellen wir Ihnen diese Seite zur Verfügung, mit Details zu [unseren Unterauftragsverarbeitern](#github-subprocessors), darüber, wie wir [Cookies](#cookies-on-github) verwenden, und wo und wie wir auf Git Hub [Tracking](#tracking-on-github) durchführen.

### GitHub-Unterauftragsverarbeiter

Wenn wir Ihre Daten an Unterauftragsverarbeiter, wie z. B. unsere Anbieter und Dienstleister, weitergeben, bleiben wir für diese verantwortlich. Wir legen großen Wert darauf, Ihr Vertrauen zu erhalten, wenn wir neue Anbieter hinzuziehen, und wir verlangen von allen Anbietern, dass sie mit uns Datenschutzvereinbarungen abschließen, die deren Verarbeitung von personenbezogenen Benutzerdaten (wie in der [Datenschutzerklärung](/articles/github-privacy-statement/) definiert) einschränken.

| Name des Unterauftragsverarbeiters | Beschreibung der Verarbeitung                         | Ort der Verarbeitung           | Corporate Location             |
| ---------------------------------- | ----------------------------------------------------- | ------------------------------ | ------------------------------ |
| Automattic                         | Hosting-Dienst                                        | Vereinigte Staaten von Amerika | Vereinigte Staaten von Amerika |
| AWS Amazon                         | Daten-Hosting                                         | Vereinigte Staaten von Amerika | Vereinigte Staaten von Amerika |
| Braintree (PayPal)                 | Kreditkarten-Zahlungsabwicklung                       | Vereinigte Staaten von Amerika | Vereinigte Staaten von Amerika |
| Clearbit                           | Marketing-Datenanreicherungsservice                   | Vereinigte Staaten von Amerika | Vereinigte Staaten von Amerika |
| Discourse                          | Community-Forum-Softwareanbieter                      | Vereinigte Staaten von Amerika | Vereinigte Staaten von Amerika |
| DiscoverOrg                        | Marketing-Datenanreicherungsservice                   | Vereinigte Staaten von Amerika | Vereinigte Staaten von Amerika |
| Eloqua                             | Automatisierung von Marketingkampagnen                | Vereinigte Staaten von Amerika | Vereinigte Staaten von Amerika |
| Google Apps                        | Interne Unternehmensinfrastruktur                     | Vereinigte Staaten von Amerika | Vereinigte Staaten von Amerika |
| Google Analytics                   | Website-Analyse und -Performance                      | Vereinigte Staaten von Amerika | Vereinigte Staaten von Amerika |
| LinkedIn Navigator                 | Marketing-Datenanreicherungsservice                   | Vereinigte Staaten von Amerika | Vereinigte Staaten von Amerika |
| Magic Robot                        | Kampagnenberichte (Salesforce Add-on)                 | Vereinigte Staaten von Amerika | Vereinigte Staaten von Amerika |
| MailChimp                          | Kunden-Ticketing-E-Mail Dienstanbieter                | Vereinigte Staaten von Amerika | Vereinigte Staaten von Amerika |
| Mailgun                            | Transaktions-Mail-Dienstanbieter                      | Vereinigte Staaten von Amerika | Vereinigte Staaten von Amerika |
| Microsoft                          | Microsoft Services                                    | Vereinigte Staaten von Amerika | Vereinigte Staaten von Amerika |
| Monday.com                         | Plattform für Teamkollaboration und Projektmanagement | Vereinigte Staaten von Amerika | Israel                         |
| Nexmo                              | SMS-Benachrichtigungsanbieter                         | Vereinigte Staaten von Amerika | Vereinigte Staaten von Amerika |
| Oracle                             | Unternehmens-Finanzsystem                             | Vereinigte Staaten von Amerika | Vereinigte Staaten von Amerika |
| Salesforce.com                     | Customer Relations-Management                         | Vereinigte Staaten von Amerika | Vereinigte Staaten von Amerika |
| Sendgrid                           | Transaktions-Mail-Dienstanbieter                      | Vereinigte Staaten von Amerika | Vereinigte Staaten von Amerika |
| Sentry.io                          | Application monitoring provider                       | Vereinigte Staaten von Amerika | Vereinigte Staaten von Amerika |
| Stripe                             | Zahlungsanbieter                                      | Vereinigte Staaten von Amerika | Vereinigte Staaten von Amerika |
| Twilio                             | SMS-Benachrichtigungsanbieter                         | Vereinigte Staaten von Amerika | Vereinigte Staaten von Amerika |
| Zendesk                            | Kundensupport-Ticketing-System                        | Vereinigte Staaten von Amerika | Vereinigte Staaten von Amerika |
| Zuora                              | Unternehmens-Abrechnungssystem                        | Vereinigte Staaten von Amerika | Vereinigte Staaten von Amerika |

Wenn wir einen neuen Unterauftragsverarbeiter einsetzen, der die personenbezogenen Daten unserer Benutzer verarbeitet, oder einen Unterauftragsverarbeiter entfernen oder die Verwendung eines Unterauftragsverarbeiter ändern, werden wir diese Seite aktualisieren. Wenn Sie Fragen oder Bedenken zu einem neuen Unterauftragsverarbeiter haben, helfen wir Ihnen gerne weiter. Bitte kontaktieren Sie uns über {% data variables.contact.contact_privacy %}.

### Cookies auf GitHub

GitHub verwendet Cookies, um die Interaktion mit unserem Dienst einfach und sinnvoll zu machen. Wir verwenden Cookies (und ähnliche Technologien wie HTML5 localStorage), um Sie eingeloggt zu halten, uns Ihre Präferenzen zu merken, Informationen für die zukünftige Entwicklung von GitHub bereitzustellen und um Ihnen die Produkte und Dienste von GitHub auf Websites Dritter vorzustellen.

Ein Cookie ist ein kleiner Text, der von unseren Webservern auf Ihrem Endgerät gespeichert wird. Er wird beim erneuten Aufruf der Webseite wieder an unsere Server zurückgesendet. Cookies müssen Sie nicht unbedingt auf GitHub identifizieren, da sie eine ID für jeden angemeldeten Benutzer speichern können. Wir verwenden Cookies, um Sie eingeloggt zu halten, Ihre Präferenzen zu speichern und Informationen für die zukünftige Entwicklung von GitHub bereitzustellen. Wir verwenden Cookies aus Sicherheitsgründen, um ein Gerät zu identifizieren. Durch die Nutzung unserer Website erklären Sie sich damit einverstanden, dass wir diese Arten von Cookies auf Ihrem Computer oder Gerät speichern. Wenn Sie die Speicherung von Cookies auf Ihrem Browser oder Gerät deaktivieren, können Sie sich weder anmelden noch die Dienste von GitHub nutzen. In bestimmten Bereichen der Website können wir Cookies auch verwenden, um Sie bzw. Ihr Gerät zu identifizieren, um Ihnen Werbung von GitHub-Produkten und -Diensten auf Websites Dritter anzuzeigen.

GitHub setzt folgende Cookies für unsere Benutzer, aus folgenden Gründen:

| Name des Cookies                     | Grund                                                                                                                                                                            |
| ------------------------------------ | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `user_session`                       | Dieses Cookie wird verwendet, um Sie anzumelden.                                                                                                                                 |
| `logged_in`                          | Dieses Cookie wird verwendet, um uns zu signalisieren, dass der Benutzer bereits angemeldet ist.                                                                                 |
| `dotcom_user`                        | Dieses Cookie wird verwendet, um uns zu signalisieren, dass der Benutzer bereits angemeldet ist.                                                                                 |
| `_gh_sess`                           | Dieses Cookie wird für temporäre Anwendungen und Framework-Status zwischen Seiten verwendet, z. B. in welchem Schritt sich der Benutzer in einem mehrstufigen Formular befindet. |
| `tz`                                 | Mit diesem Cookie kann Ihr Browser uns mitteilen, in welcher Zeitzone Sie sich befinden.                                                                                         |
| `gist_user_session`                  | Dieses Cookie wird von Gist verwendet, wenn es auf einem separaten Host ausgeführt wird.                                                                                         |
| `saml_csrf_token`                    | Dieses Cookie wird von der SAML auth path-Methode gesetzt, um dem Client ein Token zuzuordnen.                                                                                   |
| `saml_return_to`                     | Dieses Cookie wird von der SAML auth path-Methode gesetzt, um den Status während der SAML-Authentifizierungsschleife beizubehalten.                                              |
| `gist_oauth_csrf`                    | Dieses Cookie wird von Gist gesetzt, um sicherzustellen, dass der Benutzer, der den auth-Flow gestartet hat, derselbe Benutzer ist, der ihn abschließt.                          |
| `__Host-user_session_same_site`      | Dieses Cookie wird so gesetzt, dass Browser, die SameSite-Cookies unterstützen, überprüfen können, ob eine Anfrage von GitHub stammt.                                            |
| `__Host-gist_user_session_same_site` | Dieses Cookie wird so gesetzt, dass Browser, die SameSite-Cookies unterstützen, überprüfen können, ob eine Anfrage von GitHub stammt.                                            |
| `_ga`                                | Dieses Cookie wird von Google Analytics verwendet.                                                                                                                               |
| `_gat`                               | Dieses Cookie wird von Google Analytics verwendet.                                                                                                                               |
| `_gid`                               | Dieses Cookie wird von Google Analytics verwendet.                                                                                                                               |
| `_octo`                              | Dieses Cookie wird von Octolytics, unserem internen Analysedienst, verwendet, um eindeutige Benutzer und Kunden zu unterscheiden.                                                |
| `tracker`                            | Dieses Cookie verfolgt die Referenzquelle für die Anmeldeanalyse.                                                                                                                |

Bestimmte Seiten auf unserer Website können andere Cookies von Drittanbietern setzen. Beispielsweise können wir Inhalte, z. B. Videos, von einer anderen Website, die ein Cookie setzt, einbetten. Während wir versuchen, diese Cookies von Drittanbietern zu minimieren, können wir nicht immer kontrollieren, welche Cookies diese Inhalte von Drittanbietern setzen.

### Tracking on GitHub

„[Do Not Track](https://www.eff.org/issues/do-not-track)“ („Nicht verfolgen“, DNT) ist eine Privatsphäreeinstellung, die Sie in Ihrem Browser festlegen können, wenn Sie nicht möchten, dass Online-Dienste, insbesondere Werbenetzwerke, unterschiedlichste Informationen über Ihre Online-Aktivitäten durch Drittanbieter-Verfolgungsdienste sammeln und teilen. GitHub reagiert auf Browser-DNT-Signale und folgt dem [W3C-Standard für das Reagieren auf DNT-Signale](https://www.w3.org/TR/tracking-dnt/). Wenn Sie diese Einstellung in Ihrem Browser setzen wollen, schauen Sie sich die Dokumentation Ihres Browsers an. Es gibt auch gute Anwendungen, die die Online-Verfolgung verhindern. Ein gutes Beispiel dafür ist [Privacy Badger](https://www.eff.org/privacybadger).

Wenn Sie DNT auf einem Browser, der DNT unterstützt, nicht aktiviert haben, können Cookies an bestimmten Stellen unserer Website Ihre Online-Surfaktivitäten auf anderen Online-Diensten nachverfolgen, aber wir gestatten es keinen Dritten, außer unseren Analyse- und Dienstanbietern, die Aktivitäten von GitHub-Benutzern auf GitHub zu verfolgen. Wir verwenden diese Cookies, damit wir Ihnen Produkte und Dienstleistungen von GitHub auf Websites und Diensten Dritter anbieten können. Wir haben auch Vereinbarungen mit verschiedenen Anbietern, wie Analyseanbietern, die uns helfen, die Besucherbewegung auf bestimmten Seiten unserer eigenen Webseite zu verfolgen. Nur unsere Anbieter, die in unserem Namen personenbezogene Daten sammeln, dürfen Daten auf unseren Seiten sammeln, und wir haben Datenschutzvereinbarungen mit jedem Anbieter unterzeichnet, der diese Daten in unserem Namen erhebt. Wir verwenden die Daten, die wir von diesen Anbietern erhalten, um die Interessen unserer Besucher besser nachvollziehen zu können, um die Leistung unserer Website zu erfassen und um unsere Inhalte zu verbessern. Jeder Analyseanbieter wird oben in unserer Unterauftragsverarbeiter-Liste aufgeführt, und Sie können eine Liste jeder Seite sehen, auf der wir diese Art von Daten erfassen.

#### Google Analytics

Wir verwenden Google Analytics als Drittanbieter-Analysedienst, und um unsere Werbekampagnen auf Websites und Diensten Dritter zu verfolgen. Wir verwenden Google Analytics um Informationen darüber zu sammeln, wie unsere Website funktioniert und wie unsere Benutzer im Allgemeinen durch GitHub navigieren und diese Website nutzen. Dies hilft uns, die Nutzung von GitHub durch unsere Benutzer zu bewerten, statistische Berichte über Aktivitäten zu erstellen und unsere Inhalte sowie die Leistung unserer Website zu verbessern. Google stellt weitere Informationen zu seinen eigenen Datenschutzpraktiken zur Verfügung und [bietet ein Browser-Add-On, mit dem die Verfolgung durch Google Analytics deaktiviert werden kann](https://tools.google.com/dlpage/gaoptout).

#### Seiten auf GitHub auf denen Analysen aktiviert werden können

Seiten auf URLs, die eine der folgenden Domains und Pfade (einschließlich Subdomains oder Subpaths) auf unseren Websites enthalten, können analytische oder andere Tracking-Codes aktiviert haben. Wenn Sie verhindern möchten, dass wir Informationen über Ihre Browseraktivitäten auf GitHub sammeln, können Sie einen Tracking-Blocker wie [Privacy Badger](https://www.eff.org/privacybadger) verwenden oder sich von Google Analytics-Tracking abmelden.

- github.com/home (wenn Sie ausgeloggt sind oder keinen Account haben, wird diese Seite angezeigt, wenn Sie zu github.com gehen)
- github.com/about
- github.blog
- github.com/enterprise
- github.com/collections
- github.com/developer-stories
- github.com/events
- github.com/explore
- github.com/features
- github.com/logos
- github.com/nonprofit
- github.com/open-source
- github.com/personal
- github.com/pricing
- github.com/ten
- github.com/trending
- resources.github.com
- de.github.com
- fr.github.com
