---
title: GitHub-Stellungnahme gegen moderne Sklaverei und Kinderarbeit
redirect_from:
  - /articles/github-statement-against-modern-slavery-and-child-labor
versions:
  free-pro-team: '*'
---

*Erklärung 2018*

Nach Angaben der Internationalen Arbeitsorganisation (International Labour Organization (ILO)) [ waren im Jahr 2016 weltweit 40 Millionen Menschen Opfer moderner Sklaverei und 152 Millionen Kinder Opfer von Kinderarbeit](https://www.ilo.org/global/about-the-ilo/newsroom/news/WCMS_574717/lang--en/index.htm). Die [ILO berichtet Folgendes ](https://www.ilo.org/global/topics/forced-labour/lang--en/index.htm):
   - 1 von 4 Opfern der modernen Sklaverei sind Kinder.
   - Von den 24,9 Millionen Menschen, die in Zwangsarbeit gefangen sind, werden 16 Millionen im privaten Sektor wie Hausarbeit, im Baugewerbe oder in der Landwirtschaft ausgebeutet; 4,8 Millionen Menschen sind Opfer sexueller Ausbeutung, und 4 Millionen Menschen werden von staatlichen Behörden zur Zwangsarbeit gezwungen.
   -    Frauen und Mädchen sind unverhältnismäßig stark von Zwangsarbeit betroffen. Sie machen 99 % der Opfer im Bereich der kommerziellen Sexindustrie und 58 % in anderen Sektoren aus.

GitHub verurteilt das Vorhandensein und Fortbestehen moderner Sklaverei und Kinderarbeit und nimmt seine Verantwortung ernst, dafür zu sorgen, dass weder moderne Sklaverei noch Kinderarbeit in seiner Lieferkette oder in irgendeinem Teil seiner Geschäftstätigkeit stattfinden. ("Moderne Sklaverei" bezieht sich in dieser Stellungnahme auf Sklaverei, Zwangs- oder Pflichtarbeit, Menschenhandel, Leibeigenschaft und Arbeiter, die inhaftiert, unter Zwang oder unter Knechtschaft stehen. "Kinderarbeit" bezieht sich auf Arbeit, die von einer Person unter 16 Jahren oder unter 14 Jahren bei leichter Arbeit verrichtet wird, vorausgesetzt, dass diese Arbeit nicht auf Zeiträume beschränkt ist, die die schulische Ausbildung des Kindes beeinträchtigen, und nicht unter Bedingungen erfolgt, die die Gesundheit oder das Wohlbefinden des Kindes beeinträchtigen)

In accordance with the [UK Modern Slavery Act](https://www.legislation.gov.uk/ukpga/2015/30/section/54/enacted), and in alignment with the [ILO 2014 Protocol to its Forced Labour Convention](https://www.ilo.org/dyn/normlex/en/f?p=NORMLEXPUB:12100:0::NO::P12100_ILO_CODE:P029), [ILO Declaration on Fundamental Principles and Rights at Work](https://www.ilo.org/declaration/thedeclaration/textdeclaration/lang--en/index.htm), and [United Nations Sustainable Development Goals target 8.7](https://sustainabledevelopment.un.org/sdg8), this 2018 Statement Against Modern Slavery and Child Labor ("the Statement") describes the steps GitHub has taken to prevent modern slavery and child labor from occurring in its business or supply chain.

### Struktur, Geschäft und Lieferketten von GitHub

GitHub ist eine Software-Entwicklungsplattform mit Hauptsitz in San Francisco und Mitarbeitern und Vertragspartnern, die in zahlreichen Ländern arbeiten.

Alle Mitarbeiter von GitHub und individuelle unabhängige Auftragnehmer arbeiten nach ihrem freien Willen und Engagement. GitHub verfügt über eine weitgehend verteilte Belegschaft und ist bestrebt, seinen Mitarbeitern und Auftragnehmern unabhängig vom Standort wettbewerbsfähige Vergütungen und Vorteile zu bieten. Dies gilt unabhängig davon, ob wir unabhängige Auftragnehmer direkt oder über einen Vermittler einstellen.

GitHub betreibt weder die Fertigung noch die Produktion von Hardware, noch verwendet GitHub Personalvermittlungsagenturen für die Art von Dienstleistungen, die häufig von Wanderarbeitern durchgeführt werden. Die Art des Geschäfts von GitHub unterliegt nicht plötzlichen Änderungen der Arbeitsbelastung oder des Preisdrucks, die häufig die Nachfrage nach Praktiken vorantreibt, die das Risiko von Zwangsarbeit in Lieferketten erhöhen, wie etwa erzwungene Überstunden.

GitHub bietet Kunden auf der ganzen Welt kostenlose und kostenpflichtige Software sowie webbasierte Software als Service an. Zu den Produkten von GitHub gehören:
   - GitHub.com: eine Plattform für web-basierte Kollaboration und Code-Hosting
   - GitHub Enterprise: eine Software für lokale Kollaboration und Code-Hosting
   - Atom: Texteditor
   - Electron: Framework zum Schreiben plattformübergreifender Desktop-Apps
   - GitHub Desktop: Desktop-App für den Zugriff auf GitHub.com und GitHub Enterprise

Die Lieferkette von GitHub besteht aus Waren und Dienstleistungen für unsere Produkte und Operationen, einschließlich Edv-Dienstleistungen, Veranstaltungsplanung, Kauf von Einzelhandels- und Werbeartikeln, Bürobedarf und Leasing von Einrichtungen wie Büroflächen und Rechenzentren.

### Richtlinien in Bezug auf moderne Sklaverei und Kinderarbeit

#### Moderne Sklaverei und Kinderarbeit

**GitHubs Ethikrichtlinie** verbietet die wissentliche Anwendung, Teilnahme, Unterstützung oder Duldung moderner Sklaverei (Sklaverei, Zwangs- oder Pflichtarbeit, Menschenhandel, Leibeigenschaft und Arbeiter, die inhaftiert sind, unter Zwang oder unter Knechtschaft stehen) oder Kinderarbeit in seinen Geschäftstätigkeiten. Jeder GitHub-Mitarbeiter oder Vertragspartner, der gegen dieses Verbot verstößt, unterliegt der Beendigung des Arbeitsverhältnisses oder der Geschäftsbeziehung.

**GitHubs Verhaltensrichtlinien** verbieten gefährliches und illegales Verhalten, einschließlich der wissentlichen Anwendung, Teilnahme, Unterstützung oder Duldung moderner Sklaverei (Sklaverei, Zwangs- oder Pflichtarbeit, Menschenhandel, Leibeigenschaft und Arbeiter, die inhaftiert sind, unter Zwang oder unter Knechtschaft stehen) oder Kinderarbeit.

GitHub befolgt die Gesetze zum Verbot des Menschenhandels und der Kinderarbeit in den Gerichtsbarkeiten, in denen das Unternehmen tätig ist, einschließlich der [U.S. Federal Acquisition Regulation 22.17 zur Bekämpfung des Menschenhandels](https://www.govinfo.gov/content/pkg/CFR-2009-title48-vol1/pdf/CFR-2009-title48-vol1-part22-subpart22-17.pdf). Federal Acquisition Regulation 22.17 on combatting human trafficking</a>.

Darüber hinaus hat GitHub eine Partnerschaft mit dem FairHotel-Programm aufgebaut, was bedeutet, dass GitHub seine Mitarbeiter dazu ermutigt, sich für von FairHotel unterstützte Hotels zu entscheiden, in denen die Arbeiter faire Löhne und angemessene Sozialleistungen erhalten und ein Mitspracherecht am Arbeitsplatz haben. FairHotel-Partner zu sein bedeutet auch, dass GitHub als fairer Arbeitgeber für Hotels tätig ist.

GitHub wird diese Stellungnahme in Zukunft allen Mitarbeitern, Auftragnehmern und Lieferanten, einschließlich Personalvermittlern und Arbeitsagenturen, übermitteln. Darüber hinaus entwickelt GitHub für alle GitHub-Mitarbeiter Schulungen zu moderner Sklaverei und Kinderarbeit. Github [veröffentlicht seine Stellungnahme gegen moderne Sklaverei und Kinderarbeit öffentlich](/articles/github-statement-against-modern-slavery-and-child-labor).

GitHub verfolgt bei der Meldung von Bedenken am Arbeitsplatz eine Nicht-Vergeltungsrichtlinie. Im Einklang mit dieser Erklärung können Mitarbeiter und Auftragnehmer von GitHub über Probleme im Zusammenhang mit moderner Sklaverei und Kinderarbeit berichten, ohne Vergeltungsmaßnahmen befürchten zu müssen.

### Arbeitsgesetze und -praktiken

Die Arbeitspraktiken von GitHub sind

**fair**:
   - GitHub zahlt seinen Mitarbeitern und Auftragnehmern einen fairen Lohn gemäß den geltenden gesetzlichen Löhnen
   - GitHub gewährleistet menschenwürdige Arbeitsbedingungen
   - GitHub verlangt von Arbeitnehmern nicht, dass sie die durch örtliche und nationale Gesetze oder Vorschriften festgelegte maximale tägliche Arbeitszeit überschreiten.
   - GitHub bezahlt seine Mitarbeiter und Auftragnehmer rechtzeitig mit einer Dokumentation (z.B. Gehaltsabrechnung), aus der die Grundlage für die Bezahlung hervorgeht, und führt Mitarbeiteraufzeichnungen in Übereinstimmung mit lokalen und nationalen Gesetzen.

**menschlich und ethisch**:
   - Bei GitHub arbeiten Menschen ausschließlich aus freiem Willen
   - GitHub verbietet Kinderarbeit
   - GitHub übt weder körperliche Gewalt noch Missbrauch aus
   - GitHub toleriert keine Belästigung oder ungesetzliche Diskriminierung seiner Mitarbeiter am Arbeitsplatz

**respektvoll**:
   - GitHub schützt die Rechte seiner Mitarbeiter auf Vereinigungsfreiheit und Tarifverhandlungen in Übereinstimmung mit den gesetzlichen Anforderungen, einschließlich der Veröffentlichung von rechtlichen Hinweisen über Arbeitnehmerrechte nach dem "National Labor Relations Act".
   - GitHub bietet Mitarbeitern Zusatzleistungen auf oder über dem in der Branche erwarteten Niveau
   - GitHub ermutigt Mitarbeiter, Beschwerden am Arbeitsplatz zu melden und toleriert keine Vergeltungsmaßnahmen für die Meldung

### Sorgfaltspflichtige Prozesse in Bezug auf moderne Sklaverei und Kinderarbeit in ihren Geschäftstätigkeiten und Lieferketten

GitHub bewertet sein Geschäft und seine Lieferkette auf Risiken im Zusammenhang mit moderner Sklaverei und Kinderarbeit. GitHub konnte sich auf internes und externes Wissen im Bereich der Menschenrechte stützen und eine funktionsübergreifende Analyse (einschließlich der Bereiche Politik, Recht, Beschaffung, Finanzen und Betrieb sowie insbesondere Personalwesen) durchführen, um festzustellen, wo es in seinem Unternehmen und seiner Lieferkette Dienste für Arbeiter gibt, und um potenzielle Risiken im Zusammenhang mit moderner Sklaverei und Kinderarbeit zu identifizieren. GitHub priorisiert Bereiche die aufgrund ihrer Risiken im Hinblick auf Schweregrad, Ausmaß oder Wahrscheinlichkeit eine größere Sorgfaltspflicht, Überwachung und Verifizierung erfordern. GitHub prüft kontinuierlich, wo Risiken auftreten können und wie man diesen entgegenwirken kann. Darüber hinaus sichert sich GitHub nun auch die Zusicherung seiner Zulieferer, dass ihre Praktiken im Einklang mit dieser Erklärung stehen, unter anderem durch die Einhaltung von Gesetzen im Zusammenhang mit moderner Sklaverei oder Kinderarbeit.

### Orte in GitHubs Geschäfts- und Lieferketten, an denen die Gefahr moderner Sklaverei und Kinderarbeit besteht, und Schritte, die GitHub unternommen hat, um dieses Risiko einzuschätzen und zu bewältigen

GitHub hat bislang keine Zulieferer mit hohem Risiko identifiziert; allerdings treten moderne Sklaverei oder Kinderarbeit mit größerer Wahrscheinlichkeit bei Zulieferern für Dienstleistungen mit manueller Arbeit auf, wie z.B.  Unterstützung bei Veranstaltungen, Bauarbeiten, Gebäudedienstleistungen und Verpflegung. GitHub wird seine bestehenden Lieferanten fortlaufend überprüfen und von denjenigen, die in solchen risikoreicheren Bereichen tätig sind, verlangen, dass sie bestätigen, dass sie Dienstleistungen im Einklang mit dieser Erklärung erbringen.

Obwohl GitHub von keiner tatsächlichen oder angeblichen modernen Sklaverei oder Kinderarbeit in seinem Unternehmen oder seiner Lieferkette weiß und keine glaubwürdige Grundlage für die Annahme hat, dass sie stattfindet, verpflichtet sich GitHub zur Bereitstellung von Abhilfemaßnahmen, falls GitHub selbst direkt moderne Sklaverei oder Kinderarbeit verursachen sollte, und zur Behebung von allgemeineren Verstößen gegen diese Erklärung, die auf Mängel in den Systemen oder Prozessen von GitHub zurückzuführen sind. GitHubs Entschädigung für einzelne Opfer umfasst Protokolle für angemessene Sofortmaßnahmen zur Beseitigung der modernen Sklaverei- und Kinderarbeitspraktiken sowie Mittel für eine vernüftige und angemessene Opferbetreuung, um den erlittenen Schaden auszugleichen.

### Effektive Maßnahmen zur Gewährleistung, dass weder moderne Sklaverei noch Kinderarbeit in den Geschäfts- oder Lieferketten von GitHub vorkommt

GitHub respektiert die Gesetze in Bezug auf moderne Sklaverei und Kinderarbeit und wird dies auch weiterhin tun.

In Zukunft verlangt GitHub nun von seinen Zulieferern, dass sie diese Erklärung sowie Gesetze im Zusammenhang mit moderner Sklaverei und Kinderarbeit einhalten. Zudem fordert GitHub von seinen Zulieferern folgende Verpflichtungen:
   - keine moderne Sklaverei oder Kinderarbeit einzusetzen, daran teilzunehmen, sie zu unterstützen oder zu tolerieren;
   - keine irreführenden oder betrügerischen Rekrutierungs- oder Einstellungspraktiken für Angestellte oder Vertragsarbeiter anzuwenden;
   - keine Gebühren für die Einstellung oder Beschäftigung von Angestellten oder Vertragsarbeitern zu erheben;
   - keinem Mitarbeiter oder Vertragsarbeiter seinen Pass, Führerschein oder andere Ausweisdokumente zu entziehen, zu vernichten, zu verstecken, zu konfiszieren oder ihm anderweitig den Zugang zu diesen Dokumenten zu verweigern;
   - es uns zu ermöglichen, unsere Vereinbarungen mit ihnen wegen Verletzung ihrer Verpflichtungen im Zusammenhang mit moderner Sklaverei oder Kinderarbeit zu kündigen; und
   - alle Arbeiterinnen und Arbeiter, die irgendeiner Form der modernen Sklaverei oder Kinderarbeit ausgesetzt sind, zu entschädigen, wenn dies gesetzlich vorgeschrieben ist.

Darüber hinaus fordert GitHub seine Lieferanten nachdrücklich dazu auf,
   - für ihre Zulieferer Verfahren zur Überprüfung der Sorgfaltspflicht in Bezug auf moderne Sklaverei und Kinderarbeit, einschließlich Risikobewertungen, durchzuführen;
   - Maßnahmen zur Bekämpfung der identifizierten Risiken zu ergreifen; und
   - bei ihren Zulieferern vergleichbare Arbeitsmethoden gegen moderne Sklaverei und Kinderarbeit anzuwenden.

Die Beschaffungsrichtlinien von GitHub für Mitarbeiter, die Einkäufe des Unternehmens tätigen, verweisen jetzt auch auf die Anforderung an Lieferanten, den Microsoft-Verhaltenskodex für Zulieferer oder diese Erklärung zu respektieren.

### Schulungen für GitHub Mitarbeiter über moderne Sklaverei und Menschenhandel

GitHub entwickelt momentan Schulungen zu moderner Sklaverei und Kinderarbeit unter Berücksichtigung der Geschäfts- und Lieferkette von GitHub, die für alle Mitarbeiter obligatorisch sein werden. GitHub wird den Schwerpunkt auf Zulieferern legen, die Dienstleistungen in Bezug auf manuelle Arbeit anbieten, wie Unterstützung bei Veranstaltungen, Bauarbeiten, Gebäudedienstleistungen und Verpflegung, als Bereiche mit größerem Risiko.

**[Diese Stellungnahme](/assets/images/help/site-policy/github-statement-against-modern-slavery-and-child-labor.pdf) wurde vom Vorstand von GitHub verabschiedet.**
