---
title: GitHub-Datenschutzerklärung
redirect_from:
  - /datenschutz/
  - /privacy-policy/
  - /privacy-statement/
  - /github-privacy-policy/
  - /articles/github-privacy-policy/
  - /articles/github-privacy-statement/
versions:
  free-pro-team: '*'
---

Effective date: July 22, 2020

Vielen Dank, dass Sie GitHub Inc. ("GitHub", "wir") Ihren Quellcode, Ihre Projekte und Ihre persönlichen Informationen anvertrauen. Die Speicherung Ihrer persönlichen Daten ist eine große Verantwortung, und wir möchten, dass Sie wissen, wie wir diese handhaben.

Alle großgeschriebenen Begriffe sind in den [GitHub Nutzungsbedingungen](/github/site-policy/github-terms-of-service) definiert, sofern dies hier nicht anders vermerkt wird.


### Die Kurzfassung

We use your personal information as this Privacy Statement describes. No matter where you are, where you live, or what your citizenship is, we provide the same high standard of privacy protection to all our users around the world, regardless of their country of origin or location.

Natürlich enthalten die Kurzfassung und die Zusammenfassung unten nicht alle Informationen, deshalb lesen Sie bitte weiter, um weitere Einzelheiten zu erfahren.

### Zusammenfassung

| Abschnitt                                                                                                                                      | Welche Informationen sind dort enthalten?                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |
| ---------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| [Welche Daten erfasst GitHub](#what-information-github-collects)                                                                               | GitHub erfasst Daten direkt von Ihnen für Ihre Registrierung, Zahlung, Transaktionen und Ihr Benutzerprofil. Wir erfassen von Ihnen außerdem automatisch Ihre Nutzungsinformationen, Cookies und ähnliche Technologien und Geräteinformationen, die erforderlichenfalls Ihrer Zustimmung unterliegen. GitHub kann auch personenbezogene Benutzerinformationen von Dritten erfassen. Wir erfassen von Ihnen nur die minimale Menge an personenbezogenen Daten, die wir benötigen, es sei denn, Sie geben weitere an.                   |
| [Welche Daten erfasst GitHub _nicht_](#what-information-github-does-not-collect)                                                               | Wir erfassen nicht wissentlich Daten von Kindern unter 13 Jahren, und wir erfassen keine [Sensiblen persönlichen Daten](https://gdpr-info.eu/art-9-gdpr/).                                                                                                                                                                                                                                                                                                                                                                            |
| [Wie verwendet GitHub Ihre Informationen](#how-github-uses-your-information)                                                                   | In this section, we describe the ways in which we use your information, including to provide you the Service, to communicate with you, for security and compliance purposes, and to improve our Service. Wir beschreiben außerdem die Rechtsgrundlage, auf der wir Ihre Daten verarbeiten, sofern dies gesetzlich vorgeschrieben ist.                                                                                                                                                                                                 |
| [Weitergabe der von uns erfassten Daten](#how-we-share-the-information-we-collect)                                                             | Wir können Ihre Daten unter einem der folgenden Umstände an Dritte weitergeben: mit Ihrem Einverständnis, an unsere Dienstleistungsanbieter, zu Sicherheitszwecken, zur Erfüllung unserer gesetzlichen Verpflichtungen oder wenn es zu einem Wechsel der Kontrolle oder zum Verkauf von Unternehmenseinheiten oder Geschäftsbereichen kommt. Wir verkaufen Ihre persönlichen Daten nicht, und wir betreiben keine Werbung auf GitHub. Sie können eine Liste der Dienstanbieter einsehen, die auf Ihre Informationen zugreifen können. |
| [Weitere wichtige Informationen](#other-important-information)                                                                                 | Wir stellen zusätzliche Informationen für Repository-Inhalte, öffentliche Informationen und Organisationen auf GitHub bereit.                                                                                                                                                                                                                                                                                                                                                                                                         |
| [Weitere Dienste](#additional-services)                                                                                                        | Wir bieten Informationen zu zusätzlichen Serviceangeboten, einschließlich Anwendungen von Drittanbietern, GitHub Pages und GitHub-Anwendungen.                                                                                                                                                                                                                                                                                                                                                                                        |
| [Wie Sie auf die von uns erfassten Daten zugreifen und diese kontrollieren können](#how-you-can-access-and-control-the-information-we-collect) | Wir bieten Ihnen Möglichkeiten, auf Ihre personenbezogenen Daten zuzugreifen, sie zu ändern oder zu löschen.                                                                                                                                                                                                                                                                                                                                                                                                                          |
| [Unsere Verwendung von Cookies und Tracking](#our-use-of-cookies-and-tracking)                                                                 | Wir verwenden Cookies für die allgemeine Funktionalität unserer Website, und wir verwenden eine kleine Anzahl von Tracking- und Analysediensten auf einigen Teilen unserer Website. Wir bieten eine Seite, die dies sehr transparent macht. Weitere Informationen finden Sie in diesem Abschnitt.                                                                                                                                                                                                                                     |
| [Wie GitHub Ihre Daten schützt](#how-github-secures-your-information)                                                                          | Wir setzen alle erforderlichen Maßnahmen ein, um die Vertraulichkeit, Integrität und Verfügbarkeit Ihrer persönlichen Daten auf GitHub zu schützen und die Ausfallsicherheit unserer Server zu gewährleisten.                                                                                                                                                                                                                                                                                                                         |
| [GitHubs globale Datenschutzpraktiken](#githubs-global-privacy-practices)                                                                      | We provide the same high standard of privacy protection to all our users around the world.                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| [zur Kommunikation mit Ihnen](#how-we-communicate-with-you)                                                                                    | Die Kommunikation mit Ihnen erfolgt per E-Mail. Sie können in Ihren Kontoeinstellungen oder durch Kontaktaufnahme mit uns festlegen, wie wir Sie kontaktieren.                                                                                                                                                                                                                                                                                                                                                                        |
| [Beilegung von Beschwerden](#resolving-complaints)                                                                                             | In the unlikely event that we are unable to resolve a privacy concern quickly and thoroughly, we provide a path of dispute resolution.                                                                                                                                                                                                                                                                                                                                                                                                |
| [Änderungen an unserer Datenschutzerklärung](#changes-to-our-privacy-statement)                                                                | Wir informieren Sie 30 Tage vor Inkrafttreten dieser Änderungen über wesentliche Änderungen dieser Datenschutzerklärung. Sie können Änderungen außerdem in unserem Websiterichtlinien-Repository nachverfolgen.                                                                                                                                                                                                                                                                                                                       |
| [Lizenz](#license)                                                                                                                             | Diese Datenschutzerklärung ist unter der [Creative Commons Zero-Lizenz](https://creativecommons.org/publicdomain/zero/1.0/) lizenziert.                                                                                                                                                                                                                                                                                                                                                                                               |
| [GitHub kontaktieren](#contacting-github)                                                                                                      | Bitte kontaktieren Sie uns, wenn Sie Fragen zu unserer Datenschutzerklärung haben.                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| [Übersetzungen](#translations)                                                                                                                 | Wir haben Links zu einer Reihe von Übersetzungen der Datenschutzerklärung bereitgestellt.                                                                                                                                                                                                                                                                                                                                                                                                                                             |

## GitHub-Datenschutzerklärung

### Welche Daten erfasst GitHub

"**Personenbezogene Benutzerdaten**" sind alle Daten über einen unserer Benutzer, anhand denen dieser allein oder zusammen mit anderen Daten persönlich identifiziert oder die auf andere Weise mit dem Benutzer verknüpft oder in Verbindung gebracht werden können. Daten wie Benutzername und Kennwort, E-Mail-Adresse, ein echter Name, eine IP (Internet Protokoll)-Adresse und ein Foto sind Beispiele für "Personenbezogene Benutzerdaten".

Persönliche Benutzerdaten umfassen keine aggregierten, nicht personenbezogenen Daten, mit denen ein Benutzer nicht identifiziert werden kann oder die nicht auf andere Weise mit dem Benutzer verknüpft oder in Verbindung gebracht werden können. Wir können solche aggregierten, nicht personenbezogenen Daten für Forschungszwecke und für den Betrieb, die Analyse, die Verbesserung und die Optimierung unserer Website und unseres Dienstes verwenden.

#### Daten, die Benutzer direkt an GitHub bereitstellen

##### Registration information
Wir benötigen zum Zeitpunkt der Kontoerstellung bestimmte allgemeine Informationen. Bei der Erstellung Ihres eigenen Benutzernamens und Passworts bitten wir Sie um eine gültige E-Mail-Adresse.

##### Payment information
Wenn Sie sich bei uns bei einem kostenpflichtigen Konto anmelden, Geld über das GitHub-Sponsorenprogramm senden oder eine Anwendung im GitHub Marketplace kaufen, erfassen wir Ihren vollständigen Namen, Ihre Adresse und Kreditkarteninformationen oder PayPal-Informationen. Bitte beachten Sie, dass GitHub Ihre Kreditkarteninformationen oder PayPal-Informationen nicht verarbeitet oder speichert, aber unser Zahlungsabwickler von Drittanbietern dies tut.

Wenn Sie eine Anwendung auf [GitHub Marketplace](https://github.com/marketplace) auflisten und verkaufen, benötigen wir Ihre Bankinformationen. If you raise funds through the [GitHub Sponsors Program](https://github.com/sponsors), we require some [additional information](/github/supporting-the-open-source-community-with-github-sponsors/becoming-a-sponsored-developer#submitting-your-bank-information) through the registration process for you to participate in and receive funds through those services and for compliance purposes.

##### Profile information
Sie können uns weitere Informationen zu Ihrem Kontoprofil übermitteln, z. B. Ihren vollständigen Namen, einen Avatar mit einem Foto, Ihre Biographie, Ihren Standort, Ihr Unternehmen und eine URL zu einer Drittanbieter-Website. Diese Informationen können personenbezogene Benutzerdaten enthalten. Bitte beachten Sie, dass Ihre Profilinformationen für andere Benutzer unseres Dienstes sichtbar sein können.

#### Informationen, die GitHub automatisch aus Ihrer Nutzung des Dienstes sammelt

##### Transactional information
Wenn Sie ein kostenpflichtiges Konto bei uns haben, eine Anwendung verkaufen, die auf [GitHubGitHub Marketplace](https://github.com/marketplace), gelistet ist, oder Geld über das [GitHub-Sponsorenprogramm](https://github.com/sponsors)sammeln, erfassen wir automatisch bestimmte Informationen über Ihre Transaktionen auf dem Dienst, z. B. Datum, Uhrzeit und der in Rechnung gestellte Betrag.

##### Usage information
Wenn Sie auf unseren Dienst oder unsere Website zugreifen, erfassen wir automatisch dieselben grundlegenden Informationen, die die meisten Dienste sammeln, gegebenenfalls vorbehaltlich Ihrer Zustimmung. Dazu gehören Informationen darüber, wie Sie den Dienst verwenden, z. B. die von Ihnen angezeigten Seiten, die Referenz-Website, Ihre IP-Adresse und Sitzungsinformationen sowie Datum und Uhrzeit jeder Anfrage. Dies sind Informationen, die wir von jedem Besucher der Website erfassen, unabhängig davon, ob er ein Konto hat oder nicht. Diese Informationen können personenbezogene Benutzerdaten enthalten.

##### Cookies and similar technologies information
Wie weiter unten beschrieben und gegebenenfalls vorbehaltlich Ihrer Zustimmung sammeln wir automatisch Informationen aus Cookies und ähnlichen Technologien (wie z. B. Cookie-ID und Einstellungen), damit Sie eingeloggt bleiben, um Ihre Präferenzen zu speichern und um Sie und Ihr Gerät zu identifizieren.

##### Device information
Wir erfassen möglicherweise bestimmte Informationen über Ihr Gerät, z. B. die IP-Adresse, Browser- oder Clientanwendungsinformationen, Spracheinstellungen, Betriebssystem- und Anwendungsversion, Gerätetyp und -ID sowie Gerätemodell und Hersteller. Diese Informationen können personenbezogene Benutzerdaten enthalten.

#### Informationen, die wir von Dritten erfassen

GitHub kann personenbezogene Benutzerinformationen von Dritten erfassen. Dies kann z. B. der Fall sein, wenn Sie sich für Schulungen anmelden oder Informationen über GitHub von einem unserer Anbieter, Partner oder verbundenen Unternehmen erhalten. GitHub kauft keine personenbezogenen Benutzerdaten von externen Datenbrokern.

### Welche Daten erfasst GitHub nicht

Wir erfassen keine “**[Sensiblen personenbezogenen Daten](https://gdpr-info.eu/art-9-gdpr/)**”, wie personenbezogene Daten, aus denen die rassische und ethnische Herkunft, politische Meinungen, religiöse oder weltanschauliche Überzeugungen oder die Gewerkschaftszugehörigkeit hervorgehen, oder die Verarbeitung genetischer oder biometrischer Daten zur eindeutigen Identifizierung einer natürlichen Person, Gesundheitsdaten oder Daten zum Sexualleben oder der sexuellen Orientierung einer natürlichen Person. Wenn Sie sensible personenbezogene Daten auf unseren Servern speichern, sind Sie für die Einhaltung der behördlichen Kontrollen in Bezug auf diese Daten verantwortlich.

Kinder unter 13 Jahren können kein Konto auf GitHub besitzen. GitHub sammelt wissentlich keine Informationen von unseren Inhalten oder leitet sie speziell an Kinder unter 13 Jahren weiter. Wenn wir erfahren oder Grund zu der Annahme haben, dass Sie ein Benutzer sind, der unter 13 Jahre alt ist, müssen wir Ihr Konto schließen. Wir wollen Sie nicht davon abhalten, Code zu lernen, aber das sind die Regeln. Bitte beachten Sie unsere [Nutzungsbedingungen](/github/site-policy/github-terms-of-service) mit Informationen zur Kontobeendigung. Verschiedenen Länder können unterschiedliche Mindestaltersgrenzen haben, und wenn Sie das Mindestalter für die Einwilligung zur Datenerfassung in Ihrem Land unterschreiten, dürfen Sie kein Konto auf GitHub besitzen.

Wir erfassen nicht absichtlich persönliche Benutzerdaten, die **in Ihren Repositorys** gespeichert sind, oder sonstige Informationen von Freiform-Eingaben. Alle persönlichen Informationen innerhalb des Repositorys eines Benutzers liegen in der Verantwortung des Repository-Besitzers.

### Wie verwendet GitHub Ihre Informationen

- Wir können Ihre Daten für folgende Zwecke verwenden:
- Wir verwenden Ihre [Registrierungsinformationen](#registration-information), um Ihr Konto zu erstellen und Ihnen den Dienst zur Verfügung zu stellen.
- Wir verwenden Ihre [Zahlungsinformationen](#payment-information), um Ihnen die bezahlten Konto-Dienste, Marketplace-Dienste, das Sponsorenprogramm oder einen anderen von Ihnen angeforderten bezahlten GitHub-Dienst bereitzustellen.
- Wir verwenden Ihre personenbezogenen Daten, insbesondere Ihren Benutzernamen, um Sie auf GitHub zu identifizieren.
- Wir verwenden Ihre [Profilinformationen](#profile-information), um Ihr Kontoprofil auszufüllen und dieses Profil mit anderen Benutzern zu teilen, wenn Sie uns darum bitten.
- Wir verwenden Ihre E-Mail-Adresse, um mit Ihnen zu kommunizieren, sofern Sie zugestimmt haben, **und nur aus den Gründen, denen Sie zugestimmt haben**. Weitere Informationen finden Sie in unserem Abschnitt [E-Mail-Kommunikation](#how-we-communicate-with-you).
- Wir verwenden personenbezogene Benutzerdaten, um Support-Anfragen zu beantworten.
- Wir verwenden personenbezogene Daten und andere Daten, um Empfehlungen für Sie zu geben, z. B. um Projekte vorzuschlagen, denen Sie möglicherweise folgen oder zu denen Sie beitragen möchten. Wir lernen aus Ihrem öffentlichen Verhalten auf GitHub - wie z.B   den Projekten, die Sie mit einem Sternchen versehen - um Ihre Programmier-Interessen zu ermitteln, und Ihnen ähnliche Projekte zu empfehlen. Bei diesen Empfehlungen handelt es sich um automatisierte Entscheidungen, die jedoch keine rechtlichen Auswirkungen auf Ihre Rechte haben.
- Wir können personenbezogene Benutzerdaten verwenden, um Sie zur Teilnahme an Umfragen, Betaprogrammen oder anderen Forschungsprojekten einzuladen, sofern erforderlich, vorbehaltlich Ihrer Zustimmung .
- Wir verwenden [Nutzungsinformationen](#usage-information) und [Geräteinformationen](#device-information), um besser zu verstehen, wie unsere Benutzer GitHub verwenden, und um unsere Website und unseren Service zu verbessern.
- Wir können Ihre personenbezogenen Benutzerdaten verwenden, wenn dies aus Sicherheitsgründen oder zur Untersuchung möglicher Betrugsfälle oder Versuche, GitHub oder unseren Benutzern zu schaden, erforderlich ist.
- Wir können Ihre personenbezogenen Benutzerdaten verwenden, um unseren gesetzlichen Verpflichtungen nachzukommen, unser geistiges Eigentum zu schützen und unsere [Nutzungsbedingungen](/github/site-policy/github-terms-of-service) durchzusetzen.
- Wir beschränken unsere Nutzung Ihrer personenbezogenen Daten auf die in dieser Datenschutzerklärung aufgeführten Zwecke. Wenn wir Ihre personenbezogenen Daten für andere Zwecke verwenden müssen, werden wir zuerst um Ihre Erlaubnis bitten. Unter Ihrem [Benutzerprofil](https://github.com/settings/admin) können Sie jederzeit sehen, welche Informationen wir gespeichert haben, wie wir sie verwenden und welche Berechtigungen Sie uns erteilt haben.

#### Unsere rechtlichen Grundlagen zur Verarbeitung von Daten

Soweit unsere Verarbeitung Ihrer personenbezogenen Daten bestimmten internationalen Gesetzen (einschließlich, aber nicht beschränkt auf die Datenschutz-Grundverordnung (DSGVO) der Europäischen Union) unterliegt, ist GitHub verpflichtet, Sie über die Rechtsgrundlage zu informieren, auf der wir personenbezogene Daten von Benutzern verarbeiten. GitHub verarbeitet personenbezogene Daten von Benutzern auf folgenden Rechtsgrundlagen:

- Vertragserfüllung:
  * Wenn Sie ein GitHub-Konto erstellen, geben Sie Ihre <a href[Registrierungsinformationen](#registration-information) an. Wir benötigen diese Informationen, damit Sie die Nutzungsbedingungen mit uns abschließen können, und wir verarbeiten diese Informationen auf der Grundlage der Erfüllung dieses Vertrags. Wir verarbeiten außerdem Ihren Benutzernamen und Ihre E-Mail-Adresse auf anderen Rechtsgrundlagen, wie unten beschrieben.
  * Wenn Sie ein kostenpflichtiges Konto bei uns haben, erheben und bearbeiten wir zusätzliche [Zahlungsinformationen](#payment-information) auf der Grundlage der Erfüllung dieses Vertrags.
  * Wenn Sie eine auf unserem Marketplace aufgeführte Anwendung kaufen oder verkaufen oder wenn Sie Gelder über das GitHub-Sponsorenprogramm senden oder empfangen, verarbeiten wir [Zahlungsinformationen](#payment-information) und zusätzliche Elemente zur Erfüllung des für diese Dienste geltenden Vertrages.
- Zustimmung:
  * Wir benötigen Ihre Zustimmung zur Verwendung Ihrer persönlichen Benutzerdaten unter den folgenden Umständen: wenn Sie die Informationen in Ihrem [Benutzerprofil](https://github.com/settings/admin) ausfüllen; wenn Sie sich entscheiden, an einer GitHub-Schulung, einem Forschungsprojekt, einem Betaprogramm oder einer Umfrage teilzunehmen; und für Marketingzwecke, falls zutreffend. Alle diese personenbezogenen Benutzerinformationen sind freiwillig, und Sie haben jederzeit die Möglichkeit, auf diese zuzugreifen, sie zu ändern und zu löschen. Sie können Ihre E-Mail-Adresse zwar nicht vollständig löschen, können diese jedoch privat machen. Sie können Ihre Einwilligung jederzeit widerrufen.
- Berechtigte Interessen:
  * Normalerweise dient die übrige Verarbeitung personenbezogener Benutzerdaten, die wir durchführen, der Wahrung unserer berechtigten Interessen, z. B. aus Gründen der Einhaltung gesetzlicher Vorschriften, aus Sicherheitsgründen oder zur Aufrechterhaltung der kontinuierlichen Vertraulichkeit, Integrität, Verfügbarkeit und Belastbarkeit der Systeme, der Website und des Dienstes von GitHub.
- Wenn Sie die Löschung der von uns verarbeiteten Daten auf Grundlage der Zustimmung beantragen oder unserer Verarbeitung personenbezogener Daten widersprechen möchten, benutzen Sie bitte unser [Kontaktformular](https://support.github.com/contact/privacy).

### Weitergabe der von uns erfassten Daten

Wir können Ihre personenbezogenen Benutzerdaten unter einem der folgenden Umstände an Dritte weitergeben:

#### Mit Ihrer Zustimmung
Wir geben Ihre personenbezogenen Benutzerdaten weiter, wenn Sie damit einverstanden sind, nachdem wir Sie darüber informiert haben, welche Informationen mit wem und warum geteilt werden. Wenn Sie beispielsweise eine Anwendung kaufen, die auf unserem Marketplace aufgeführt ist, geben wir Ihren Benutzernamen weiter, damit der Anwendungsentwickler Ihnen Dienste zur Verfügung stellen kann. Zusätzlich können Sie uns durch Ihre Aktivität auf GitHub anweisen, Ihre persönlichen Benutzerdaten weiterzugeben. Wenn Sie beispielsweise einer Organisation beitreten, geben Sie Ihre Bereitschaft an, dem Eigentümer der Organisation die Möglichkeit zu geben, Ihre Aktivität im Zugriffsprotokoll der Organisation anzuzeigen.

#### Mit Dienstanbietern
Wir geben personenbezogene Benutzerdaten an eine begrenzte Anzahl von Dienstanbieter weiter, die diese Benutzerdaten in unserem Namen verarbeiten, um unseren Dienst bereitzustellen oder zu verbessern, und die Datenschutzbeschränkungen zugestimmt haben, die denen in unserer Datenschutzerklärung ähneln, indem sie Datenschutzvereinbarungen unterzeichnet oder ähnliche Verpflichtungen eingegangen haben. Unsere Dienstanbieter übernehmen die Zahlungsabwicklung, die Ausstellung von Tickets für die Kundenbetreuung, die Netzwerkdatenübertragung, Sicherheits- und andere ähnliche Dienstleistungen. Während GitHub alle personenbezogenen Benutzerdaten in den Vereinigten Staaten verarbeitet, können unsere Dienstanbieter Daten auch außerhalb der Vereinigten Staaten oder der Europäischen Union verarbeiten. Wenn Sie wissen möchten, wer unsere Dienstleister sind, besuchen Sie bitte unsere Seite unter [ Unterauftragsverarbeiter ](/github/site-policy/github-subprocessors-and-cookies).

#### Zu Sicherheitszwecken
If you are a member of an Organization, GitHub may share your username, [Usage Information](#usage-information), and [Device Information](#device-information) associated with that Organization with an owner and/or administrator of the Organization, to the extent that such information is provided only to investigate or respond to a security incident that affects or compromises the security of that particular Organization.

#### Zur rechtlichen Offenlegung
GitHub strebt Transparenz bei der Einhaltung gesetzlicher und rechtlicher Verpflichtungen an. Sofern wir nicht durch gesetzliche Bestimmungen oder Gerichtsbeschlüsse oder unter seltenen, dringenden Umständen daran gehindert werden, bemühen wir uns in angemessener Weise, die Benutzer über jede rechtlich erzwungene oder erforderliche Offenlegung ihrer Informationen zu informieren. GitHub kann personenbezogene Daten oder andere Informationen, die wir über Sie sammeln, an Strafverfolgungsbehörden weitergeben, wenn dies als Reaktion auf eine gültige Vorladung, einen Gerichtsbeschluss, einen Durchsuchungsbefehl, eine ähnliche Regierungsanordnung erforderlich ist oder wenn wir in gutem Glauben glauben sind, dass die Offenlegung notwendig ist, um unseren rechtlichen Verpflichtungen nachzukommen, um unser Eigentum oder unsere Rechte oder die rechte Dritter oder der Öffentlichkeit zu schützen.

Weitere Informationen über unsere Offenlegung als Reaktion auf gesetzliche Anfragen finden Sie in unseren [Richtlinien für rechtliche Fragen zu Benutzerdaten](/github/site-policy/guidelines-for-legal-requests-of-user-data).

#### Kontrollwechsel oder Verkauf
Wir können personenbezogene Benutzerdaten weitergeben, wenn wir an einer Fusion, einem Verkauf oder Erwerb von Unternehmen oder Geschäftseinheiten beteiligt sind. Wenn eine solche Änderung des Eigentumsverhältnisses eintritt, werden wir sicherstellen, dass dies unter Wahrung der Vertraulichkeit der personenbezogenen Benutzerdaten geschieht, und wir werden Sie auf unserer Website oder per E-Mail benachrichtigen, bevor Sie Ihre persönlichen Benutzerinformationen übermitteln. Die Organisation, die personenbezogene Benutzerdaten erhält, muss alle Verpflichtungen einhalten, die wir in unserer Datenschutzerklärung oder unseren Nutzungsbedingungen gemacht haben.

#### Aggregierte, nicht personenbezogene Informationen
Wir teilen bestimmte aggregierte, nicht-personenbezogene Informationen mit anderen darüber, wie unsere Benutzer gemeinsam GitHub nutzen oder wie unsere Benutzer auf andere Angebote wie unsere Konferenzen oder Veranstaltungen reagieren. Zum Beispiel [können wir Statistiken über die Open-Source-Aktivität auf GitHub erstellen](https://octoverse.github.com/).

Wir verkaufen Ihre personenbezogenen Benutzerinformationen **nicht** gegen eine finanzielle oder andere Gegenleistung.

Bitte beachten Sie: Der California Consumer Privacy Act of 2018 ("CCPA") verpflichtet Unternehmen, in ihren Datenschutzrichtlinien anzugeben, ob sie personenbezogene Daten gegen eine finanzielle oder sonstige Gegenleistung offenlegen. While CCPA only covers California residents, we voluntarily extend its core rights for people to control their data to _all_ of our users, not just those who live in California. Weitere Informationen über den CCPA und wie wir diesen umsetzen, finden Sie [hier](/github/site-policy/githubs-notice-about-the-california-consumer-privacy-act).

### Weitere wichtige Informationen

#### Repository-Inhalt

Personal von GitHub [haben keinen Zugang zu privaten Repositorys](/github/site-policy/github-terms-of-service#e-private-repositories), es sei denn, dies ist aus Sicherheitsgründen, zur Unterstützung des Repository-Eigentümers bei einer Supportanfrage, zur Aufrechterhaltung der Integrität des Dienstes oder zur Erfüllung unserer rechtlichen Verpflichtungen erforderlich. However, while we do not generally search for content in your repositories, we may scan our servers and content to detect certain tokens or security signatures, known active malware, or other content known to violate our Terms, such as violent extremist or terrorist content or child exploitation imagery based on algorithmic fingerprinting techniques. Unsere Nutzungsbedingungen enthalten [weitere Details](/github/site-policy/github-terms-of-service#e-private-repositories).

Wenn Ihr Repository öffentlich ist, kann jeder seinen Inhalt anzeigen. Wenn Sie private, vertrauliche oder [Sensible personenbezogene Daten](https://gdpr-info.eu/art-9-gdpr/), wie z.B. E-Mail-Adressen oder Passwörter, in Ihr öffentliches Repository eingeben, können diese Informationen von Suchmaschinen indexiert oder von Dritten verwendet werden.

Weitere Informationen finden Sie unter [Personenbezogene Benutzerdaten in öffentlichen Repositorys](/github/site-policy/github-privacy-statement#public-information-on-github).

#### Öffentliche Informationen auf GitHub

Viele GitHub-Dienste und -Funktionen sind öffentlich zugänglich. Wenn Ihre Inhalte öffentlich zugänglich sind, können Dritte auf diese in Übereinstimmung mit unseren Nutzungsbedingungen zugreifen und diese verwenden, z. B. indem Sie Ihr Profil oder Ihre Repositorys anzeigen oder Daten über unser API abrufen. Wir verkaufen diese Inhalte nicht; sie gehören Ihnen. Wir gestatten es jedoch Dritten, wie z.B. Forschungsorganisationen oder Archiven, öffentlich zugängliche GitHub-Informationen zu sammeln. Es ist bekannt, dass andere Dritte, wie z.B. Datenbroker, ebenfalls mittels Scraping auf GitHub zurückgreifen und Daten sammeln.

Ihre personenbezogenen Benutzerdaten in Verbindung mit Ihren Inhalten könnten von Dritten im Rahmen dieser Erfassungen von GitHub-Daten gesammelt werden. Wenn Sie nicht möchten, dass Ihre personenbezogenen Benutzerdaten in den GitHub-Datensammlungen von Dritten erscheinen, machen Sie Ihre personenbezogenen Benutzerdaten bitte nicht öffentlich zugänglich und stellen Sie sicher, dass [Ihre E-Mail-Adresse in Ihrem Benutzerprofil](https://github.com/settings/emails) und in Ihren [Git Commit-Einstellungen als privat konfiguriert ist](/github/setting-up-and-managing-your-github-user-account/setting-your-commit-email-address). Wir setzen derzeit standardmäßig die E-Mail-Adresse der Benutzer auf privat, aber alte GitHub-Benutzer müssen möglicherweise ihre Einstellungen aktualisieren.

Wenn Sie GitHub-Daten zusammenstellen möchten, müssen Sie unsere Nutzungsbedingungen in Bezug auf [Scraping](/github/site-policy/github-acceptable-use-policies#5-scraping-and-api-usage-restrictions) und [Datenschutz](/github/site-policy/github-acceptable-use-policies#6-privacy) erfüllen, und Sie dürfen alle öffentlich zugänglichen personenbezogenen Daten, die Sie sammeln, nur für den Zweck verwenden, für den unser Benutzer dies autorisiert hat. Wenn z. B. ein GitHub-Benutzer eine E-Mail-Adresse zum Zwecke der Identifizierung und Zuordnung öffentlich zugänglich gemacht hat, dürfen Sie Sie diese E-Mail-Adresse nicht für kommerzielle Werbung verwenden. Wir erwarten von Ihnen, dass Sie einen angemessenen Schutz aller personenbezogenen Daten von Benutzern, die Sie von dem Dienst erfasst haben garantieren, und Beschwerden, Aufforderungen zur Löschung und Kontaktverbote von uns oder anderen Benutzern umgehend beantworten.

Ebenso können Projekte auf GitHub öffentlich zugängliche personenbezogene Benutzerdaten enthalten, die im Rahmen des kollaborativen Prozesses erfasst werden. Wenn Sie eine Beschwerde über persönliche Benutzerdaten auf GitHub haben, lesen Sie bitte unseren Abschnitt [Beilegung von Beschwerden](/github/site-policy/github-privacy-statement#resolving-complaints).


#### Organisationen

Sie können durch Ihre Aktionen auf GitHub angeben, dass Sie bereit sind, Ihre personenbezogenen Benutzerdaten zu teilen. Wenn Sie an einer Organisation mitarbeiten oder Mitglied einer Organisation werden, erhalten die Kontoinhaber möglicherweise Ihre personenbezogenen Benutzerdaten. Wenn Sie eine Einladung zu einer Organisation annehmen, werden Sie über die Arten von Informationen informiert, die Besitzer möglicherweise einsehen können (weitere Informationen finden Sie unter [Informationen zur Organisationsmitgliedschaft](/github/setting-up-and-managing-your-github-user-account/about-organization-membership)). Wenn Sie eine Einladung zu einer Organisation mit [verifizierter Domäne](/github/setting-up-and-managing-organizations-and-teams/verifying-your-organizations-domain) annehmen, dann können die Eigentümer dieser Organisation Ihre vollständige(n) E-Mail-Adresse(en) innerhalb der verifizierten Domänen dieser Organisation sehen.

Please note, GitHub may share your username, [Usage Information](#usage-information), and [Device Information](#device-information) with the owner(s) of the Organization you are a member of, to the extent that your User Personal Information is provided only to investigate or respond to a security incident that affects or compromises the security of that particular Organization.

Wenn Sie an einem Konto mitarbeiten oder Mitglied eines Kontos werden, das den [Unternehmensnutzungsbedingungen](/github/site-policy/github-corporate-terms-of-service) und einem Datenschutz-Nachtrag (Data Protection Addendum, DPA) zu dieser Datenschutzerklärung zugestimmt hat, dann ist dieses DPA im Falle von Konflikten zwischen dieser Datenschutzerklärung und dem DPA in Bezug auf Ihre Aktivität im Konto maßgebend.

Bitte wenden Sie sich an die Kontoinhaber, um weitere Informationen darüber zu erhalten, wie Ihre personenbezogenen Benutzerdaten in deren Organisation verarbeitet werden können und wie Sie auf die im Konto gespeicherten personenbezogenen Benutzerinformationen zugreifen, sie aktualisieren, ändern oder löschen können.

### Weitere Dienste

#### Anwendungen Dritter

Sie haben die Möglichkeit, Ihrem Konto Drittanbieter-Anwendungen, die als "Entwicklerprodukte" bezeichnet werden, hinzuzufügen bzw. diese zu aktivieren. Diese Entwicklerprodukte sind für Ihre Nutzung von GitHub nicht erforderlich. Wir geben Ihre personenbezogenen Benutzerdaten an Dritte weiter, wenn Sie uns darum bitten, z. B. durch den Kauf eines Entwicklerprodukts über den Marketplace; Sie sind jedoch für Ihre Nutzung des Entwicklerprodukts von Drittanbietern sowie für die Menge der personenbezogenen Benutzerinformationen, die Sie mit diesem Produkt teilen möchten, selber verantwortlich. Sie können unsere [API-Dokumentation](/v3/users/) einsehen um zu erfahren, welche Informationen bereitgestellt werden, wenn Sie sich mit Ihrem GitHub-Profil bei einem Entwicklerprodukt authentifizieren.

#### GitHub Pages

Wenn Sie eine GitHub Pages-Website erstellen, liegt es in Ihrer Verantwortung, eine Datenschutzerklärung zu veröffentlichen, in der genau beschrieben wird, wie Sie personenbezogene Daten und andere Besucherinformationen sammeln, verwenden und weitergeben und wie Sie die geltenden Datenschutzgesetze, -regeln und -vorschriften einhalten. Bitte beachten Sie, dass GitHub personenbezogene Daten von Besuchern Ihrer GitHub-Seiten-Website, einschließlich Protokolle von IP-Adressen, sammeln kann, um den gesetzlichen Verpflichtungen nachzukommen und die Sicherheit und Integrität der Website und des Dienstes aufrechtzuerhalten.

#### GitHub-Anwendungen

You can also add applications from GitHub, such as our Desktop app, our Atom application, or other application and account features, to your Account. Diese Anwendungen haben jeweils ihre eigenen Bedingungen und können verschiedene Arten von personenbezogenen Daten des Benutzers sammeln; alle GitHub-Anwendungen unterliegen jedoch dieser Datenschutzerklärung, und wir erfassen die erforderliche Menge an personenbezogenen Benutzerdaten und verwenden sie nur für den Zweck, für den Sie sie uns zur Verfügung gestellt haben.

### Wie Sie auf die von uns erfassten Daten zugreifen und diese kontrollieren können

Wenn Sie bereits GitHub-Benutzer sind, können Sie auf Ihre grundlegenden Benutzerprofilinformationen zugreifen und diese aktualisieren, ändern oder löschen, indem Sie [Ihr Benutzerprofil bearbeiten](https://github.com/settings/profile) oder den [GitHub-Support](https://support.github.com/contact) oder [GitHub Premium-Support](https://enterprise.githubsupport.com/hc/en-us) kontaktieren. Sie können die Informationen, die wir über Sie erfassen, kontrollieren, indem Sie einschränken, welche Informationen sich in Ihrem Profil befinden, indem Sie Ihre Informationen auf dem neuesten Stand halten oder indem Sie sich an den [GitHub-Support](https://support.github.com/contact) oder [GitHub Premium-Support](https://enterprise.githubsupport.com/hc/en-us) wenden.

Wenn GitHub Informationen über Sie verarbeitet, z. B. Informationen, die[ GitHub von Dritten erhält](#information-we-collect-from-third-parties), und Sie kein Konto haben, dann können Sie, vorbehaltlich des anwendbaren Rechts, auf Ihre personenbezogenen Daten zugreifen und diese aktualisieren, ändern, löschen oder deren Verarbeitung widersprechen, indem Sie sich den [GitHub-Support](https://support.github.com/contact) Oder [GitHub Premium-Support](https://enterprise.githubsupport.com/hc/en-us) kontaktieren.

#### Datenportabilität

Als GitHub-Benutzer können Sie Ihre Daten jederzeit mitnehmen. Sie können [Ihre Repositorys auf Ihren Desktop klonen](/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop) oder unsere [ Datenportabilitäts-Tools](https://developer.github.com/changes/2018-05-24-user-migration-api/) verwenden um Daten, die wir über Sie gespeichert haben, herunterzuladen.

#### Datenaufbewahrung und -löschung

Im Allgemeinen speichert GitHub personenbezogene Benutzerdaten so lange, wie Ihr Konto aktiv ist oder wie dies erforderlich ist, um Ihnen Dienste bereitzustellen.

Wenn Sie Ihr Konto kündigen oder Ihre personenbezogenen Daten löschen möchten, können Sie dies in Ihrem [Benutzerprofil](https://github.com/settings/admin) tun. Wir speichern und verwenden Ihre Daten, soweit dies zur Erfüllung unserer rechtlichen Verpflichtungen, zur Beilegung von Streitigkeiten und zur Durchsetzung unserer Vereinbarungen erforderlich ist. Vorbehaltlich rechtlicher Anforderungen löschen wir jedoch Ihr vollständiges Profil (im Rahmen des Zumutbaren) innerhalb von 90 Tagen nach Ihrer Anfrage. Sie können den [GitHub-Support](https://support.github.com/contact) oder [GitHub Premium-Support](https://enterprise.githubsupport.com/hc/en-us) kontaktieren, um innerhalb von 30 Tagen die Löschung der von uns verarbeiteten Daten anzufordern.

Bestimmte Daten, wie zum Beispiel Beiträge zu den Repositorys anderer Benutzer und Kommentare zu den Themen anderer Benutzer, verbleiben auch nach dem Löschen eines Kontos. Wir werden jedoch Ihre personenbezogenen Benutzerdaten, wie Ihren Benutzernamen und Ihre E-Mail-Adresse, aus dem Autorenfeld von Themen, Pull Request und Kommentaren löschen oder de-identifizieren und diese mit einem [Ghost-Benutzer](https://github.com/ghost) verknüpfen.

Die von Ihnen angegebene E-Mail-Adresse [über Ihre Git-Commit-Einstellungen](/github/setting-up-and-managing-your-github-user-account/setting-your-commit-email-address) bleiben jedoch immer mit Ihren Commits im Git-System verknüpft. Wenn Sie Ihre E-Mail-Adresse privat machen möchten, sollten Sie auch Ihre Git-Commit-Einstellungen aktualisieren. Wir sind nicht in der Lage, Daten im Git-Commit-Verlauf zu ändern oder zu löschen – die Git-Software wurde entwickelt, um einen Datensatz zu führen – aber wir ermöglichen es Ihnen, zu steuern, welche Informationen Sie in diesen Datensatz aufgenommen haben.

### Unsere Verwendung von Cookies und Tracking

#### Cookies

GitHub verwendet Cookies, um die Interaktion mit unserem Dienst einfach und sinnvoll zu machen. Cookies sind kleine Textdateien, die oft von Websites auf Computer-Festplatten oder mobilen Geräten von Besuchern gespeichert werden. Wir verwenden Cookies (und ähnliche Technologien wie HTML5 localStorage), um Sie eingeloggt zu halten, Ihre Präferenzen zu speichern und Informationen für die zukünftige Entwicklung von GitHub bereitzustellen. Wir verwenden Cookies aus Sicherheitsgründen, um ein Gerät zu identifizieren. Durch die Nutzung unserer Website erklären Sie sich damit einverstanden, dass wir diese Arten von Cookies auf Ihrem Computer oder Gerät speichern. Wenn Sie die Speicherung von Cookies auf Ihrem Browser oder Gerät deaktivieren, können Sie sich weder anmelden noch die Dienste von GitHub nutzen.

Auf unserer Webseite [Cookies und Tracking](/github/site-policy/github-subprocessors-and-cookies) beschreiben wir die von uns gesetzten Cookies, die Voraussetzungen für diese Cookies und die unterschiedlichen Arten von Cookies (temporär oder permanent). Die Website enthält außerdem eine Liste unserer externen Analyse- und Dienstanbieter sowie genaue Angaben darüber, welche Teile unserer Website von diesen Anbietern erfasst werden dürfen.

#### Tracking und Analyse

Wir verwenden eine Reihe von externen Analyse- und Dienstanbietern, um uns bei der Bewertung der Verwendung von GitHub durch unsere Benutzer zu unterstützen, statistische Berichte über Aktivitäten zusammenzustellen und unsere Inhalte und die Website-Leistung zu verbessern. Wir verwenden diese externen Analyseanbieter nur in bestimmten Bereichen unserer Website und alle von ihnen haben mit uns Datenschutzvereinbarungen unterzeichnet, die die Art der personenbezogenen Daten, die sie sammeln können, und den Zweck, für den sie die Informationen verarbeiten können, einschränken. Darüber hinaus verwenden wir unsere eigene interne Analysesoftware zur Bereitstellung von Funktionen und zur Verbesserung unserer Inhalte und Leistungen.

Einige Browser verfügen über integrierte "Do Not Track"-Funktionen (DNT), die ein Signal an die von Ihnen besuchten Websites senden können, um zu signalisieren, dass Sie nicht getracked werden möchten. GitHub reagiert auf Browser-DNT-Signale und folgt dem [W3C-Standard für das Reagieren auf DNT-Signale](https://www.w3.org/TR/tracking-dnt/). Wenn Sie DNT auf einem Browser, der DNT unterstützt, nicht aktiviert haben, können Cookies an bestimmten Stellen unserer Website Ihre Online-Surfaktivitäten auf anderen Online-Diensten nachverfolgen, aber wir gestatten es keinen Dritten, außer unseren Analyse- und Dienstanbietern, die Aktivitäten von GitHub-Benutzern auf GitHub zu verfolgen.

### Wie GitHub Ihre Daten schützt

GitHub ergreift alle notwendigen Maßnahmen, um Benutzerdaten vor unbefugtem Zugriff, Änderung oder Zerstörung zu schützen sowie die Richtigkeit der Daten zu wahren und die angemessene Verwendung der Benutzerinformationen zu gewährleisten.

GitHub implementiert ein schriftliches Sicherheitsinformationsprogramm. Unser Programm:
- entspricht branchenweit anerkannten Rahmenwerken;
- umfasst Sicherheitsvorkehrungen, die in angemessener Weise die Vertraulichkeit, Integrität, Verfügbarkeit und Ausfallsicherheit der Daten unserer Benutzer schützen sollen;
- entspricht der Art, Größe und Komplexität des Geschäftsbetriebs von GitHub;
- umfasst Prozesse zur Reaktion auf Vorfälle und Benachrichtigung bei Datenschutzverletzungen; und
- erfüllt die geltenden Sicherheitsgesetze und -vorschriften in den geografischen Regionen, in denen GitHub tätig ist.

Im Falle einer Datenschutzverletzung, die sich auf Ihre personenbezogenen Daten auswirkt, werden wir unverzüglich handeln, um die Auswirkungen einer Verletzung zu mildern und betroffene Benutzer unverzüglich zu benachrichtigen.

Die Übertragung von Daten auf GitHub erfolgt verschlüsselt mit SSH, HTTPS (TLS), und Git-Repository-Inhalte werden im Ruhezustand verschlüsselt. Wir verwalten unsere eigenen Cages und Racks in erstklassigen Rechenzentren mit einem Höchstmaß an physischer und Netzwerksicherheit, und wenn Daten bei einem Drittanbieter gespeichert werden, werden sie verschlüsselt.

Keine Übertragungsmethode oder Methode der elektronischen Speicherung ist 100% sicher. Daher können wir ihre absolute Sicherheit nicht garantieren. Weitere Informationen finden Sie in unserer [Sicherheitshinweise](https://github.com/security).

### GitHubs globale Datenschutzpraktiken

GitHub, Inc. and, for those in the European Economic Area, the United Kingdom, and Switzerland, GitHub B.V. are the controllers responsible for the processing of your personal information in connection with the Service, except (a) with respect to personal information that was added to a repository by its contributors, in which case the owner of that repository is the controller and GitHub is the processor (or, if the owner acts as a processor, GitHub will be the subprocessor); or (b) when you and GitHub have entered into a separate agreement that covers data privacy (such as a Data Processing Agreement).

Our addresses are:

- GitHub, Inc., 88 Colin P. Kelly Jr. Street, San Francisco, CA 94107.
- GitHub B.V., Vijzelstraat 68-72, 1017 HL Amsterdam, The Netherlands.

We store and process the information that we collect in the United States in accordance with this Privacy Statement, though our service providers may store and process data outside the United States. Wir verstehen jedoch, dass unsere Nutzer aus verschiedenen Ländern und Regionen kommen, in denen unterschiedliche Anforderungen an den Datenschutz gestellt werden, und wir versuchen, diesen Bedürfnissen auch dann gerecht zu werden, wenn die Vereinigten Staaten nicht die gleichen Rahmenbedingungen für den Datenschutz besitzen wie andere Länder.

We provide the same high standard of privacy protection—as described in this Privacy Statement—to all our users around the world, regardless of their country of origin or location, and we are proud of the levels of notice, choice, accountability, security, data integrity, access, and recourse we provide. Wir bemühen uns intensiv um die Einhaltung der geltenden Datenschutzgesetze, wo immer wir geschäftlich tätig sind, und arbeiten hierbei als Teil eines funktionsübergreifenden Teams, das unsere Bemühungen um die Einhaltung des Datenschutzes überwacht, mit unserem Datenschutzbeauftragten zusammen. Wenn unsere Anbieter oder verbundenen Unternehmen Zugriff auf personenbezogene Benutzerdaten haben, müssen sie außerdem Vereinbarungen unterzeichnen, die sie zur Einhaltung unserer Datenschutzrichtlinien und der geltenden Datenschutzgesetze verpflichten.

Insbesondere:

 - GitHub bietet klare Methoden der eindeutigen, informierten, spezifischen und freiwillig erteilten Einverständniserklärung zum Zeitpunkt der Datenerfassung, wenn wir Ihre persönlichen Benutzerdaten auf der Grundlage der Einverständniserklärung erfassen.
 - Wir erfassen nur die minimale Menge an personenbezogenen Benutzerdaten, die wir benötigen, es sei denn, Sie geben weitere an. Wir empfehlen Ihnen, uns nur so viele Daten zur Verfügung zu stellen, wie Sie uns auch tatsächlich mitteilen möchten.
 - Wir bieten Ihnen einfache Methoden für den Zugriff, die Änderung oder das Löschen der von uns erfassten personenbezogenen Benutzerdaten, soweit gesetzlich zulässig.
 - Wir bieten unseren Benutzern Benachrichtigungen, Wahlmöglichkeiten, Verantwortlichkeit, Sicherheit und Zugang zu ihren personenbezogenen Benutzerdaten, und wir beschränken den Zweck der Verarbeitung dieser Daten. Wir bieten unseren Benutzern auch eine Methode des Rückgriffs und der Durchsetzung.

#### Grenzüberschreitende Datenübertragungen

GitHub processes personal information both inside and outside of the United States and relies on Standard Contractual Clauses as the legally provided mechanism to lawfully transfer data from the European Economic Area, the United Kingdom, and Switzerland to the United States. In addition, GitHub is certified to the EU-US and Swiss-US Privacy Shield Frameworks. To learn more about our cross-border data transfers, see our [Global Privacy Practices](/github/site-policy/global-privacy-practices).

### zur Kommunikation mit Ihnen

Wir verwenden Ihre E-Mail-Adresse, um mit Ihnen zu kommunizieren, sofern Sie zugestimmt haben, **und nur aus den Gründen, denen Sie zugestimmt haben**. Wenn Sie sich beispielsweise mit einer Anfrage an unser Support-Team wenden, antworten wir Ihnen per E-Mail. Sie haben viel Kontrolle darüber, wie Ihre E-Mail-Adresse auf und über GitHub verwendet und geteilt wird. Sie können Ihre Kommunikationseinstellungen in Ihrem [Benutzerprofil](https://github.com/settings/emails) verwalten.

Das Git-Versionskontrollsystem ordnet die E-Mail-Adresse eines Benutzers vielen Aktionen zu, z. B. Commit-Mitteilung. Wir sind können nicht viele Aspekte des Git-Systems ändern. Wenn Sie möchten, dass Ihre E-Mail-Adresse privat bleibt, auch wenn Sie öffentliche Repositorys kommentieren, [können Sie eine private E-Mail-Adresse in Ihrem Benutzerprofil](https://github.com/settings/emails) erstellen. You should also [update your local Git configuration to use your private email address](/github/setting-up-and-managing-your-github-user-account/setting-your-commit-email-address). Dies ändert nichts an der Art und Weise, wie wir Sie kontaktieren, aber es wird sich auf die Art und Weise auswirken, wie Sie für andere sichtbar sind. Wir setzen derzeit standardmäßig die E-Mail-Adresse der Benutzer auf privat, aber alte GitHub-Benutzer müssen möglicherweise ihre Einstellungen aktualisieren. Please see more about email addresses in commit messages [here](/github/setting-up-and-managing-your-github-user-account/setting-your-commit-email-address).

Je nach Ihren [E-Mail-Einstellungen](https://github.com/settings/emails), sendet GitHub gelegentlich Benachrichtigungs-E-Mails über Änderungen in einem Repository, das Sie gerade ansehen, über neue Funktionen, Feedbackanfragen, wichtige Richtlinienänderungen oder um Kundensupport anzubieten. Wir senden auch Marketing-E-Mails, basierend auf Ihren Entscheidungen und in Übereinstimmung mit den geltenden Gesetzen und Vorschriften. Am Ende jeder Marketing-E-Mail, die wir Ihnen senden, befindet sich ein Link zum Abbestellen des Abonnements. Bitte beachten Sie, dass Sie den Erhalt wichtiger Mitteilungen von uns, wie z. B. E-Mails von unserem Support-Team oder System-E-Mails, nicht abbestellen können, aber Sie können Ihre Benachrichtigungseinstellungen in Ihrem Profil so konfigurieren, dass Sie andere Mitteilungen deaktivieren.

Unsere E-Mails können ein Pixel-Tag enthalten, ein kleines, klares Bild, das uns mitteilen kann, ob Sie eine E-Mail geöffnet haben und wie Ihre IP-Adresse lautet. Wir verwenden diesen Pixel-Tag, um unsere E-Mail für Sie effektiver zu gestalten und um sicherzustellen, dass wir Ihnen keine unerwünschten E-Mails senden.

### Beilegung von Beschwerden

Wenn Sie Bedenken hinsichtlich der Art und Weise haben, wie GitHub mit Ihren personenbezogenen Benutzerdaten umgeht, teilen Sie uns dies bitte umgehend mit. Wir wollen helfen. Sie können uns kontaktieren, indem Sie das [Datenschutz-Kontaktformular](https://support.github.com/contact/privacy) ausfüllen. Sie können uns auch direkt eine E-Mail an privacy@github.com mit der Betreffzeile "Privacy Concerns" senden. Wir werden umgehend antworten – spätestens innerhalb von 45 Tagen.

Sie können sich auch direkt an unseren Datenschutzbeauftragten wenden.

| Unser Hauptsitz in den USA     | Unser EU-Büro      |
| ------------------------------ | ------------------ |
| GitHub Data Protection Officer | GitHub BV          |
| 88 Colin P. Kelly Jr. St.      | Vijzelstraat 68-72 |
| San Francisco, CA 94107        | 1017 HL Amsterdam  |
| Vereinigte Staaten von Amerika | Niederlande        |
| privacy@github.com             | privacy@github.com |

#### Streitbeilegungsprozess

Im unwahrscheinlichen Fall, dass es zu einem Streit zwischen Ihnen und GitHub über den Umgang mit Ihren personenbezogenen Benutzerdaten kommt, werden wir unser Bestes tun, um diesen beizulegen. Additionally, if you are a resident of an EU member state, you have the right to file a complaint with your local supervisory authority, and you might have more [options](/github/site-policy/global-privacy-practices#dispute-resolution-process).

### Änderungen an unserer Datenschutzerklärung

GitHub kann unsere Datenschutzerklärung von Zeit zu Zeit ändern, wobei die meisten Änderungen eher geringfügig sein dürften. Wir werden die Benutzer über unsere Website mindestens 30 Tage vor Inkrafttreten der Änderung über wesentliche Änderungen dieser Datenschutzerklärung informieren, indem wir eine Benachrichtigung auf unserer Homepage veröffentlichen oder E-Mails an die primäre E-Mail-Adresse versenden, die in Ihrem GitHub-Konto angegeben ist. Wir werden auch unser [Websiterichtlinien-Repository](https://github.com/github/site-policy/) aktualisieren, das alle Änderungen an dieser Richtlinie nachverfolgt. Für Änderungen an dieser Datenschutzerklärung, die keine wesentlichen Änderungen sind oder ihre Rechte nicht beeinträchtigen, empfehlen wir Benutzern, regelmäßig unser Websiterichtlinien-Repository zu besuchen.

### Lizenz

Diese Datenschutzerklärung ist unter dieser [Creative Commons Zero-Lizenz](https://creativecommons.org/publicdomain/zero/1.0/) lizenziert. Weitere Informationen finden Sie in unserem [ Websiterichtlinien-Repository](https://github.com/github/site-policy#license).

### GitHub kontaktieren
Fragen zur Datenschutzerklärung oder zu den Datenschutzpraktiken von GitHub sollten an unser [Kontaktformular zum Datenschutz](https://support.github.com/contact/privacy) gerichtet werden.

### Übersetzungen

Im Folgenden finden Sie Übersetzungen dieses Dokuments in andere Sprachen. Im Falle von Konflikten, Unsicherheiten oder offensichtlichen Unstimmigkeiten zwischen diesen Versionen und der englischen Version(en) dieses Dokuments, ist die englische Version die maßgebende Version.

#### Französisch
Cliquez ici pour obtenir la version française: [Déclaration de confidentialité de GitHub](/assets/images/help/site-policy/github-privacy-statement(12.20.19)(FR).pdf)

#### Andere Übersetzungen

For translations of this statement into other languages, please visit [https://docs.github.com/](/) and select a language from the drop-down menu under “English.”
