---
title: Community-Richtlinien von GitHub
redirect_from:
  - /community-guidelines/
  - /articles/github-community-guidelines
versions:
  free-pro-team: '*'
---

Millionen von Entwicklern hosten Millionen von Projekten auf GitHub – sowohl Open als auch Closed Source – und wir fühlen uns geehrt, jeden Tag eine Rolle bei der Ermöglichung der Zusammenarbeit in der Community zu spielen. Wir alle zusammen haben die großartige Gelegenheit und die Verantwortung, diese Community zu einer Gemeinde zu machen, auf die wir stolz sein können.

Die weltweiten GitHub-Benutzer verfügen über völlig unterschiedliche Perspektiven, Ideen und Erfahrungen und umfassen sowohl Personen, die letzte Woche ihr erstes "Hello World"-Projekt ins Leben gerufen haben, als auch die bekanntesten Software-Entwickler der Welt. Wir sind bestrebt, GitHub zu einem einladenden Umfeld für all die verschiedenen Stimmen und Perspektiven in unserer Community zu machen und gleichzeitig einen Raum zu bieten, in dem sich Personen frei äußern können.

Wir sind darauf angewiesen, dass unsere Community-Mitglieder Erwartungen kommunizieren, ihre Projekte [moderieren ](#what-if-something-or-someone-offends-you)und {% data variables.contact.report_abuse %} oder {% data variables.contact.report_content %}. Wir durchsuchen nicht aktiv die Inhalte, um sie zu moderieren. Wir hoffen, Ihnen durch die Darstellung unserer Erwartungen an unsere Community verständlich zu machen, wie Sie am besten auf GitHub mitwirken können und welche Art von Handlungen oder Inhalten möglicherweise gegen unsere [Nutzungsbedingungen](#legal-notices) verstoßen. Wir werden allen Meldungen über Missbrauch nachgehen und können öffentliche Inhalte auf unserer Website moderieren, bei denen wir feststellen, dass sie gegen unsere Nutzungsbedingungen verstoßen.

### Eine starke Community aufbauen

Der Hauptzweck der GitHub-Community ist die Zusammenarbeit bei Softwareprojekten. Wir wollen die Zusammenarbeit zwischen den Menschen verbessern. Die Website wird zwar von uns betrieben, doch diese Community wird von uns allen *gemeinsam* aufgebaut, und wir brauchen Ihre Hilfe, um das Beste aus ihr zu machen.

* **Seien Sie offen und aufgeschlossen.** - Andere Mitwirkende der Community haben vielleicht nicht den gleichen Erfahrungsstand oder Hintergrund wie Sie, aber das bedeutet nicht, dass sie keine guten Ideen beisteuern können. Wir bitten Sie, neue Mitwirkende und solche, die gerade am Anfang stehen, willkommen zu heißen.

* **Zeigen Sie sich gegenseitig Respekt.** Nichts sabotiert ein gesundes Gespräch so sehr wie Unhöflichkeit. Verhalten Sie sich anständig und professionell und posten Sie nichts, was eine vernünftige Person als anstößig, beleidigend oder hasserfüllt auffassen könnte. Schikanieren und belästigen Sie niemanden. Behandeln Sie sich gegenseitig bei allen Interaktionen mit Würde und Rücksicht.

  Es kann sein, dass Sie eine Antwort geben wollen, in der Sie eine andere Meinung haben. Das ist in Ordnung. Aber denken Sie daran, Kritik an Ideen zu üben, nicht an Personen. Vermeiden Sie Beschimpfungen, persönliche Angriffe, Reaktionen auf den Tonfall eines Beitrags statt auf seinen eigentlichen Inhalt und kurzsichtige Reaktionen. Schlagen Sie stattdessen begründete Gegenargumente vor, die die Unterhaltung verbessern.

* **Kommunizieren Sie mit Einfühlungsvermögen.** - Unstimmigkeiten oder Meinungsverschiedenheiten gehören zum täglichen Leben. Teil einer Community zu sein, bedeutet, mit vielen unterschiedlichen Menschen mit unterschiedlichen Hintergründen und Perspektiven zu interagieren, von denen viele vielleicht nicht unbedingt Ihren eigenen entsprechen. Wenn Sie einer Person nicht zustimmen, versuchen Sie, ihre Gefühle nachzuvollziehen und zu erläutern, bevor Sie sich darüber auslassen. Dies schafft eine respektvolle und freundliche Atmosphäre, in der Personen sich sicher fühlen, Fragen zu stellen, an Diskussionen teilzunehmen und Beiträge zu leisten.

* **Seien Sie klar und bleiben Sie beim Thema** - Die Leute verwenden GitHub, um Ihre Arbeit zu erledigen und produktiver zu sein. Kommentare außerhalb des Themas lenken von der Arbeit und der Produktivität ab (manchmal willkommen, aber normalerweise nicht). Bleiben Sie beim Thema und tragen Sie zu positiven und produktiven Diskussionen bei.

   Zudem kann die Kommunikation mit Fremden im Internet schwierig sein. Es ist schwierig, den Umgangston richtig zu übermitteln oder zu interpretieren, und Sarkasmus wird häufig missverstanden. Versuchen Sie, eine klare Sprache zu verwenden, und denken Sie darüber nach, wie Ihr Beitrag von der anderen Person aufgenommen wird.

### Was tun, wenn etwas oder jemand Sie beleidigt?

Wir verlassen uns darauf, dass die Community uns mitteilt, wann ein Problem angegangen werden muss. Wir überwachen die Website nicht aktiv auf anstößige Inhalte. Wenn Sie auf etwas oder jemanden auf der Website stoßen, das bzw. den Sie anstößig finden, sind hier einige Tools, die GitHub bietet, um Ihnen zu helfen, sofort Maßnahmen zu ergreifen:

* **Erwartungen mitteilen** - Wenn Sie sich in einer Community engagieren, die keine eigenen, gemeinschaftsspezifischen Richtlinien festgelegt hat, fordern Sie sie auf, dies entweder in der README- oder [CONTRIBUTING-Datei](/articles/setting-guidelines-for-repository-contributors/) oder in [einem speziellen Verhaltenskodex](/articles/adding-a-code-of-conduct-to-your-project/) zu tun, indem Sie ein Pull-Request einreichen.

* **Kommentare moderieren** - Wenn Sie [Schreibzugriff-Berechtigungen](/articles/repository-permission-levels-for-an-organization/) für ein Repository haben, können Sie alle Kommentare zu Commits, Pull Requests und Issues bearbeiten, löschen oder ausblenden. Jede Person mit Lesezugriff auf ein Repository kann den Änderungsverlauf eines Kommentars anzeigen. Die Verfasser der Kommentare und Personen mit Schreibzugriff auf ein Repository können auch sensible Informationen aus dem Änderungsverlauf eines Kommentars löschen. Weitere Informationen finden Sie unter "[Änderungen an einem Kommentar verfolgen](/articles/tracking-changes-in-a-comment)" und "[Störende Kommentare verwalten](/articles/managing-disruptive-comments)."

* **Unterhaltungen sperren** - Wenn eine Diskussion in einem Issue oder Pull-Request außer Kontrolle gerät können Sie[die Unterhaltung sperren ](/articles/locking-conversations/).

* **Benutzer blockieren** - Falls Ihnen ein Benutzer auffällt, der anhaltend schlechtes Verhalten zeigt, können Sie [den Benutzer über Ihr persönliches Konto blockieren](/articles/blocking-a-user-from-your-personal-account/) oder [den Benutzer über Ihre Organisation blockieren](/articles/blocking-a-user-from-your-organization/).

Selbstverständlich können Sie uns jederzeit kontaktieren, um {% data variables.contact.report_abuse %}, wenn Sie mehr Hilfe bei der Bewältigung einer Situation benötigen.

### Was ist nicht erlaubt?

Wir setzen uns für die Aufrechterhaltung einer Community ein, in der es den Benutzer freisteht, sich auszudrücken und die Ideen des anderen in Frage zu stellen, sowohl technisch als auch anderweitig. Solche Diskussionen fördern jedoch keinen fruchtbaren Dialog, wenn Ideen zum Schweigen gebracht werden, weil Community-Mitglieder niedergeschrien werden oder Angst haben, sich zu äußern. Das bedeutet, dass Sie jederzeit respektvoll und höflich sein und andere nicht auf der Grundlage ihrer Identität angreifen sollten. Wir tolerieren kein Verhalten, das Grenzen in den folgenden Bereichen überschreitet:

* **Gewaltandrohungen** - Sie dürfen nicht mit Gewalt gegen andere drohen oder die Website nutzen, um Akte realer Gewalt oder Terrorismus zu organisieren, zu fördern oder anzustiften. Denken Sie sorgfältig über Ihre Wortwahl, von Ihnen gepostete Bilder sowie auch über die Software, die Sie verfassen, nach und wie diese von anderen interpretiert werden können. Selbst wenn Sie etwas als Scherz gemeint haben, wird es möglicherweise nicht auf diese Weise aufgenommen. Wenn Sie glauben, dass jemand anderes die Inhalte, die Sie posten, als Bedrohung oder als Förderung von Gewalt oder Terrorismus interpretieren *könnte*, hören Sie auf. Veröffentlichen Sie sie nicht auf GitHub. In außergewöhnlichen Fällen können wir Gewaltandrohungen an die Strafverfolgungsbehörden melden, wenn wir der Meinung sind, dass ein echtes Risiko körperlicher Schäden oder eine Bedrohung der öffentlichen Sicherheit besteht.

* **Hassreden und Diskriminierung.** - Obwohl es nicht verboten ist, Themen wie Alter, Körpergröße, ethnische Zugehörigkeit, Geschlechtsidentität und Ausdruck, Erfahrungsgrad, Nationalität, persönliches Aussehen, Rasse, Religion oder sexuelle Identität und Orientierung anzusprechen, tolerieren wir keine Sprache, die eine Person oder eine Gruppe von Menschen auf der Grundlage dessen angreift, wer sie sind. Machen Sie sich einfach bewusst, dass diese (und andere) heikle Themen, wenn sie auf aggressive oder beleidigende Weise angegangen werden, dazu führen können, dass sich andere unwillkommen oder gar unsicher fühlen. Obwohl es immer das Potenzial für Missverständnisse gibt, erwarten wir von unseren Community-Mitgliedern, dass sie respektvoll und zivil bleiben, wenn sie sensible Themen diskutieren.

* **Mobbing und Belästigung** - Wir tolerieren kein Mobbing und keine Belästigung. Dazu gehört jede Form der Belästigung oder Einschüchterung, die auf eine bestimmte Person oder Personengruppe abzielt. Wenn Ihre Handlungen unerwünscht sind und Sie diese dennoch fortsetzen, ist die Wahrscheinlichkeit groß, dass Sie auf Mobbing oder Belästigung ausgerichtet sind.

* **Impersonifizierung** - Sie dürfen nicht versuchen, andere bezüglich Ihrer Identität zu täuschen, indem Sie einen Avatar einer anderen Person kopieren, Inhalte unter deren E-Mail-Adresse posten, absichtlich einen täuschend ähnlichen Benutzernamen verwenden oder sich anderweitig als jemand anderes ausgeben. Impersonifizierung ist eine Form der Belästigung.

* **Doxxing und Eingriff in die Privatsphäre ** - Posten Sie keine persönlichen Daten anderer Personen, z. B. Telefonnummern, private E-Mail-Adressen, physische Adressen, Kreditkartennummern, Sozialversicherungs-/Nationale Identitätsnummern oder Kennwörter. Je nach Kontext, z. B. bei Einschüchterung oder Belästigung, können wir andere Informationen, wie Fotos oder Videos, die ohne Zustimmung des Betreffenden aufgenommen oder verbreitet wurden, als Eingriff in die Privatsphäre betrachten, insbesondere wenn dieses Material ein Sicherheitsrisiko für das Thema darstellt.

* **Sexuell obszöne Inhalte** - Posten Sie keine pornographischen Inhalte. Das bedeutet nicht, dass Nacktheit oder jeder Kodex und Inhalt im Zusammenhang mit Sexualität verboten ist. Wir erkennen an, dass Sexualität ein Teil des Lebens ist und nicht-pornografische sexuelle Inhalte ein Teil Ihres Projekts sein können oder zu pädagogischen oder künstlerischen Zwecken präsentiert werden können. Wir erlauben keine obszönen sexuellen Inhalte oder Inhalte, die die Ausbeutung oder Sexualisierung von Minderjährigen beinhalten können.

* **Gewalttätige Inhalte** - Posten Sie keine gewalttätigen Bilder, Texte oder andere Inhalte ohne angemessenen Kontext oder Warnungen. Obwohl es oft in Ordnung ist, gewalttätige Inhalte in Videospiele, Nachrichtenberichte und Beschreibungen historischer Ereignisse aufzunehmen, erlauben wir keine gewalttätigen Inhalte, die wahllos gepostet werden oder die in einer Weise gepostet werden, dass es für andere Benutzer schwierig ist, sie zu vermeiden (z. B. einen Profil-Avatar oder einen Issue-Kommentar). Eine klare Warnung oder ein Haftungsausschluss in anderen Kontexten hilft Benutzern, eine fundierte Entscheidung darüber zu treffen, ob sie sich mit solchen Inhalten beschäftigen möchten oder nicht.

* **Irreführung und Fehlinformationen** - Sie dürfen keine Inhalte posten, die ein verzerrtes Bild der Realität vermitteln, unabhängig davon, ob es sich um ungenaue oder falsche (Fehlinformationen) oder absichtlich täuschende (Irreführung) Inhalte handelt, weil solche Inhalte der Öffentlichkeit Schaden zufügen oder faire und gleiche Chancen für alle zur Teilnahme am öffentlichen Leben beeinträchtigen könnten. Zum Beispiel lassen wir keine Inhalte zu, die das Wohlergehen von Personengruppen gefährden oder ihre Fähigkeit einschränken, an einer freien und offenen Gesellschaft teilzunehmen. Wir ermutigen zur aktiven Teilnahme am Austausch von Ideen, Perspektiven und Erfahrungen und sind möglicherweise nicht in der Lage, persönliche Berichte oder Feststellungen anzufechten. Wir erlauben in der Regel Parodie und Satire, die mit unseren akzeptablen Nutzungsrichtlinien übereinstimmen, und wir halten den Kontext für wichtig, wie Informationen empfangen und verstanden werden; Daher kann es angemessen sein, Ihre Absichten durch Haftungsausschluss oder andere Mittel sowie die Quelle(n) Ihrer Informationen zu klären.

* **Active malware or exploits** - Being part of a community includes not taking advantage of other members of the community. We do not allow anyone to use our platform for exploit delivery, such as using GitHub as a means to deliver malicious executables, or as attack infrastructure, for example by organizing denial of service attacks or managing command and control servers. Beachten Sie jedoch, dass wir die Veröffentlichung von Quellcode, der zur Entwicklung von Malware oder Exploits verwendet werden könnte, nicht verbieten, da die Veröffentlichung und Verbreitung eines solchen Quellcodes einen lehrreichen Wert hat und für die Sicherheits-Community einen klaren Nutzen darstellt.


### Was passiert, wenn jemand die Regeln verletzt?

Es gibt eine Reihe von Maßnahmen, die wir ergreifen können, wenn ein Benutzer unangemessenes Verhalten oder unangemessene Inhalte meldet. Es hängt in der Regel von den genauen Umständen eines bestimmten Falles ab. Wir sind uns darüber im Klaren, dass Personen manchmal aus verschiedenen Gründen unangemessene Dinge sagen oder tun. Vielleicht war ihnen nicht bewusst, wie ihre Worte aufgenommen werden würden. Oder vielleicht haben sie sich einfach von ihren Emotionen leiten lassen. Natürlich gibt es manchmal Leute, die nur Spam verbreiten oder Ärger verursachen wollen.

Jeder Fall erfordert einen anderen Ansatz, und wir versuchen, unsere Antwort auf die Bedürfnisse der gemeldeten Situation anzupassen. Wir werden jeden Missbrauchsbericht von Fall zu Fall überprüfen. Bei jedem Fall wird ein Team aus Vertretern verschiedener Bereiche den Inhalt und die umliegenden Fakten untersuchen und gegebenenfalls reagieren, wobei wir uns bei unserer Entscheidung an den vorliegenden Richtlinien orientieren.

Maßnahmen, die wir als Reaktion auf eine Missbrauchsmeldung ergreifen können, umfassen unter anderem:

* Inhaltsentfernung
* Blockieren von Inhalten
* Kontosperrung
* Kündigung des Kontos

### Rechtliche Hinweise

Wir möchten diese Community-Richtlinien der Öffentlichkeit zur Nutzung, Wiederverwendung, Anpassung oder zum sonstigem Gebrauch durch jedermann, unter den Bedingungen von [CC0-1.0](https://creativecommons.org/publicdomain/zero/1.0/), zur Verfügung stellen.

Dies sind nur Richtlinie; sie ändern nicht unsere [Nutzungsbedingungen](/articles/github-terms-of-service/) und sind nicht als vollständige Liste gedacht. GitHub behält sich unter den [Nutzungsbedingungen](/articles/github-terms-of-service/#c-acceptable-use) die uneingeschränkte Befugnis vor, Inhalte zu entfernen oder Konten für Aktivitäten zu schließen, die gegen unsere Richtlinien zur akzeptablen Nutzung verstoßen. Diese Richtlinien beschreiben, wann wir diese Befugnis ausüben werden.
