---
title: Verhaltenskodex für das GitHub-Community-Forum
redirect_from:
  - /articles/github-community-forum-code-of-conduct
versions:
  free-pro-team: '*'
---

### Übersicht und Zweck

Millionen von Entwicklern hosten Millionen von Projekten auf GitHub – sowohl Open als auch Closed Source – und wir fühlen uns geehrt, jeden Tag eine Rolle bei der Ermöglichung der Zusammenarbeit in der Entwicklercommunity zu spielen. Wir alle zusammen haben die großartige Gelegenheit und die Verantwortung, diese Community zu einer Gemeinde zu machen, auf die wir stolz sein können.

Das GitHub Community Forum soll ein Ort für weitere Zusammenarbeit, Unterstützung und Brainstorming sein. Es handelt sich hier um einen gesitteten Ort, um mit anderen Benutzern in Kontakt zu treten, neue Fähigkeiten zu erlernen, Feedback und Ideen auszutauschen und um all die Unterstützung zu finden, die Sie für Ihre GitHub-Projekte benötigen. Durch Ihre Teilnahme an dieser Community stimmen Sie den gleichen [Nutzungsbedingungen](/Artikel/github-Dienstbedingungen/) zu, die für GitHub.com gelten, sowie diesem Community-spezifischen Verhaltenskodex.

Mit diesem Verhaltenskodex möchten wir Ihnen verdeutlichen, wie Sie am besten im GitHub Community Forum mitwirken können, was Sie von Moderatoren erwarten können und welche Art von Aktionen oder Inhalten zu einer vorübergehenden oder dauerhaften Suspendierung von der Teilnahme an der Community führen können. Wir werden allen Meldungen über Missbrauch nachgehen und können öffentliche Inhalte innerhalb der Community moderieren, bei denen wir feststellen, dass sie entweder gegen die GitHub-Nutzungsbedingungen oder diesen Verhaltenskodex verstoßen.

Die weltweiten GitHub-Benutzer verfügen über völlig unterschiedliche Perspektiven, Ideen und Erfahrungen und umfassen sowohl Personen, die letzte Woche ihr erstes "Hello World"-Projekt ins Leben gerufen haben, als auch die bekanntesten Software-Entwickler der Welt. Wir sind bestrebt, GitHub und das GitHub Community Forum zu einem einladenden Umfeld für all die verschiedenen Stimmen und Perspektiven hier zu machen und gleichzeitig einen Raum zu bieten, in dem sich Personen frei äußern können.

### Versprechen

Im Interesse der Förderung eines offenen und einladenden Umfeldes wollen wir uns als Teilnehmer und Betreuer verpflichten, die Teilnahme am Git Hub Community Forum zu einer belästigungsfreien Erfahrung zu machen – unabhängig von Alter, Körpergröße, Behinderung, ethnischer Zuordnung, geschlechtlicher Identität und Ausdruck, Erfahrungsstufe, Nationalität, persönlicher Erscheinung, Rasse, Religion oder sexueller Identität oder Orientierung.

### Normen

Behandeln Sie das GitHub Community Forum mit Respekt. Wir sind eine gemeinsame Ressource – ein Ort zum Austausch von Fähigkeiten, Wissen und Interessen durch laufende Gespräche.

Die folgenden Regeln sind keine exakten Vorschriften, sondern lediglich Hilfsmittel für das menschliche Urteilsvermögen in unserer Community. Diese Richtlinien sollen dafür sorgen, dass dies ein ordentlicher, übersichtlicher Ort für einen zivilisierten öffentlichen Diskurs bleibt.

#### *Best Practices für die Schaffung einer starken Community*

- Seien Sie höflich und rücksichtsvoll.
  - **Seien Sie offen und aufgeschlossen.** Andere Mitglieder der Community haben vielleicht nicht den gleichen Erfahrungsstand oder Hintergrund wie Sie, aber das bedeutet nicht, dass sie keine guten Ideen beisteuern können. Wir bitten Sie, neue Mitglieder und solche, die gerade am Anfang stehen, willkommen zu heißen.
  - **Zeigen Sie sich gegenseitig Respekt.** Nichts sabotiert ein gesundes Gespräch so sehr wie Unhöflichkeit. Verhalten Sie sich anständig und professionell und posten Sie nichts, was eine vernünftige Person als anstößig, beleidigend oder hasserfüllt auffassen könnte. Schikanieren und belästigen Sie niemanden. Behandeln Sie sich gegenseitig bei allen Interaktionen mit Würde und Rücksicht.

    Es kann sein, dass Sie eine Antwort geben wollen, in der Sie eine andere Meinung haben. Das ist in Ordnung. Aber denken Sie daran, Kritik an Ideen zu üben, nicht an Personen. Vermeiden Sie Beschimpfungen, persönliche Angriffe, Reaktionen auf den Tonfall eines Beitrags statt auf seinen eigentlichen Inhalt und kurzsichtige Reaktionen. Schlagen Sie stattdessen begründete Gegenargumente vor, die die Unterhaltung verbessern.
  - **Kommunizieren Sie mit Einfühlungsvermögen.** Unstimmigkeiten oder Meinungsverschiedenheiten gehören zum täglichen Leben. Teil einer Community zu sein, bedeutet, mit vielen unterschiedlichen Menschen mit unterschiedlichen Hintergründen und Perspektiven zu interagieren, von denen viele vielleicht nicht unbedingt Ihren eigenen entsprechen. Wenn Sie einer Person nicht zustimmen, versuchen Sie, ihre Gefühle nachzuvollziehen und zu erläutern, bevor Sie sich darüber auslassen. Dies schafft eine respektvolle und freundliche Atmosphäre, in der Personen sich sicher fühlen, Fragen zu stellen, an Diskussionen teilzunehmen und Beiträge zu leisten.
- Leisten Sie einen positiven und konstruktiven Beitrag.
  - **Tragen Sie dazu bei, die Diskussion zu verbessern.** Unterstützen Sie uns dabei, dass dies eine großartige Plattform für Diskussionen wird und versuchen Sie immer, einen Beitrag zur Verbesserung der Diskussion zu leisten, auch wenn er noch so klein ist. Wenn Sie nicht sicher sind, ob Ihr Post einen nützlichen Beitrag zum Gespräch leistet, überlegen Sie sich, was Sie sagen wollen, und versuchen Sie es später noch einmal.

    Die hier diskutierten Themen sind uns wichtig, und wir möchten, dass Sie so handeln, als ob sie auch für Sie wichtig wären. Seien Sie respektvoll gegenüber den Themen und den Gesprächspartnern, auch wenn Sie mit einigen Äußerungen nicht einverstanden sind.
  - **Seien Sie klar und bleiben Sie beim Thema.** Die Kommunikation mit Fremden im Internet kann schwierig sein. Es ist schwierig, den Umgangston richtig zu übermitteln oder zu interpretieren, und Sarkasmus wird häufig missverstanden. Versuchen Sie, eine klare Sprache zu verwenden, und denken Sie darüber nach, wie Ihr Beitrag von der anderen Person aufgenommen wird.

    Dies gilt auch für das Teilen von Links. Alle im Gemeinschaftsforum geteilten Links sollten mit der Absicht geteilt werden, relevante und angemessene Informationen bereitzustellen. Links sollten nicht gepostet werden, um Traffic oder die Aufmerksamkeit auf eine Website zu lenken. Links sollte stets eine vollständige Erläuterung des Inhalts und des Zwecks des Links beigefügt werden. Das Posten von Links, insbesondere unerwünschter Links, ohne relevanten und wertvollen Kontext kann als Werbung oder als noch böswilligere Zwecke bezeichnet werden.

    Darüber hinaus dient das GitHub-Gemeinschaftsforum der Zusammenarbeit, dem Austausch von Ideen und der gegenseitigen Hilfe bei der Umsetzung von Projekten. Kommentare außerhalb des Themas lenken von der Arbeit und der Produktivität ab (manchmal willkommen, aber normalerweise nicht). Bleiben Sie beim Thema und tragen Sie zu positiven und produktiven Diskussionen bei.
  - **Bewusster Austausch.** Wenn Sie andere bitten, Ihnen Feedback zu geben oder an einem Projekt mitzuarbeiten, teilen Sie nur wertvolle und relevante Ressourcen, um einen Kontext zu schaffen. Veröffentlichen Sie keine Links, die dem Thema keinen Mehrwert verleihen, und posten Sie keine unerwünschten Links zu Ihren eigenen Projekten oder Websites in den Threads anderer Benutzer.

    Geben Sie außerdem keine vertraulichen Informationen weiter. Dazu gehört auch Ihre eigene E-Mail-Adresse. Wir erlauben die Weitergabe solcher Informationen in diesem Gemeinschaftsforum nicht, da dies zu Sicherheits- und Datenschutzrisiken für den Poster wie auch für andere Benutzer führen kann. Wenn Sie andere Forumsmitglieder einladen möchten, an einem Projekt oder mit Ihnen zusammenzuarbeiten, geben Sie einen Link zu dem Repository, in dem das Projekt, an dem Sie arbeiten, vorhanden ist, an. Indem Sie den Link zu Ihrem Projektrepository teilen - mit einigen Informationen über Ihr Projekt und bezüglich der Art von Hilfe oder Feedback Sie suchen - können Sie andere einladen, mit Ihnen über Probleme oder Pull-Requests zusammenzuarbeiten, ohne Ihre privaten Informationen teilen zu müssen. Sie können auch andere als externe Mitarbeiter in Ihrem Projektrepository hinzufügen, um ihnen spezielle Berechtigungen zu erteilen, um Sie bei der Entwicklung Ihres Projekts zu unterstützen.
  - **Halten Sie Ordnung.** Machen Sie sich die Mühe, die Dinge an der richtigen Stelle zu posten, damit wir mehr Zeit mit Diskussionen und weniger Zeit mit dem Aufräumen verbringen können. Das heißt:
    - Starten Sie kein Thema in der falschen Kategorie.
    - Veröffentlichen Sie dieselbe Information nicht in mehreren Themen.
    - Veröffentlichen Sie keine inhaltsleeren Antworten.
    - "Bumpen" Sie keine Posts, es sei denn, Sie möchten neue und relevante Informationen weitergeben.
    - Ändern Sie ein Thema nicht, indem Sie es im Verlauf der Diskussion ändern.

    Anstatt "+1" oder "stimme zu" zu schreiben, verwenden Sie die Kudos-Schaltfläche. Anstatt ein bestehendes Thema in eine radikal andere Richtung zu lenken, sollten Sie ein neues Thema eröffnen.

- Seien Sie glaubwürdig.
  - **Seien Sie immer ehrlich.** Teilen Sie nicht wissentlich falsche Informationen oder führen Sie andere Mitglieder des GitHub Community Forums absichtlich in die Irre. Wenn Sie die Antwort auf die Frage einer Person nicht kennen, aber dennoch helfen wollen, können Sie versuchen, bei der Recherche zu helfen oder Ressourcen zu finden. Unsere GitHub-Mitarbeiter sind ebenfalls in der Community aktiv. Wenn Sie sich also bei einer Antwort nicht sicher sind, kann Ihnen wahrscheinlich ein Moderator helfen.

#### *Was ist nicht erlaubt*

- **Gewaltandrohungen.** Sie dürfen nicht mit Gewalt gegen andere drohen oder die Website nutzen, um Akte realer Gewalt oder Terrorismus zu organisieren, zu fördern oder anzustiften. Denken Sie sorgfältig über Ihre Wortwahl, von Ihnen gepostete Bilder sowie auch über die Software, die Sie verfassen, nach und wie diese von anderen interpretiert werden können. Selbst wenn Sie etwas als Scherz gemeint haben, wird es möglicherweise nicht auf diese Weise aufgenommen. Wenn Sie glauben, dass jemand anderes die Inhalte, die Sie posten, als Bedrohung oder als Förderung von Gewalt oder Terrorismus interpretieren könnte, hören Sie auf. Posten Sie es nicht. In außergewöhnlichen Fällen können wir Gewaltandrohungen an die Strafverfolgungsbehörden melden, wenn wir der Meinung sind, dass ein echtes Risiko körperlicher Schäden oder eine Bedrohung der öffentlichen Sicherheit besteht.

- **Hassreden und Diskriminierung.** Obwohl es nicht verboten ist, Themen wie Alter, Körpergröße, Fähigkeitem, ethnische Zugehörigkeit, Geschlechtsidentität und Ausdruck, Erfahrungsgrad, Nationalität, persönliches Aussehen, Rasse, Religion oder sexuelle Identität und Orientierung anzusprechen, tolerieren wir keine Sprache, die eine Person oder eine Gruppe von Menschen auf der Grundlage dessen angreift, wer sie sind. Bedenken Sie einfach, dass die Diskussion über diese oder andere heikle Themen dazu führen kann, dass sich andere unerwünscht oder vielleicht sogar unsicher fühlen, wenn sie in aggressiver oder beleidigender Weise angesprochen werden. Wir erwarten von unseren Community-Mitgliedern, dass sie bei der Behandlung sensibler Themen respektvoll sind.

- **Mobbing und Belästigung.** Wir tolerieren kein Mobbing und keine Belästigung. Dazu gehört jede Form der Belästigung oder Einschüchterung, die auf eine bestimmte Person oder Personengruppe abzielt. Wenn Ihre Handlungen unerwünscht sind und Sie diese dennoch fortsetzen, ist die Wahrscheinlichkeit groß, dass Sie auf Mobbing oder Belästigung ausgerichtet sind.

- **Impersonifizierung.** Sie dürfen sich nicht als eine andere Person ausgeben, indem Sie deren Avatar kopieren, Inhalte unter deren E-Mail-Adresse posten, absichtlich einen täuschend ähnlichen Benutzernamen verwenden oder sich anderweitig als jemand anderes ausgeben. Impersonifizierung ist eine Form der Belästigung.

- **Doxxing und Eingriff in die Privatsphäre.** Posten Sie keine persönlichen Daten anderer Personen, z. B. Telefonnummern, private E-Mail-Adressen, physische Adressen, Kreditkartennummern, Sozialversicherungs-/Nationale Identitätsnummern oder Kennwörter. Je nach Kontext, z. B. bei Einschüchterung oder Belästigung, können wir andere Informationen, wie Fotos oder Videos, die ohne Zustimmung des Betreffenden aufgenommen oder verbreitet wurden, als Eingriff in die Privatsphäre betrachten, insbesondere wenn dieses Material ein Sicherheitsrisiko für das Thema darstellt.

- **Lüsterner/sexuell expliziter Inhalt.** Veröffentlichen Sie prinzipiell keine Pornographie. Dies bedeutet nicht, dass alle Arten von Nacktheit oder sexuellen Inhalten verboten sind. Wir erkennen an, dass Sexualität ein Teil des Lebens ist und nicht-pornografische sexuelle Inhalte ein Teil Ihres Projekts sein können oder zu pädagogischen oder künstlerischen Zwecken präsentiert werden können. Wenden Sie sich bei Fragen oder Bedenken zu etwas, das Sie posten möchten, an [ und fragen Sie bitte vorher nach](https://support.github.com/contact).

- **Spam.** Respektieren Sie das GitHub Community Forum. Veröffentlichen Sie keine Werbung, verlinken Sie nicht auf Spam-Websites oder schädigen Sie die Community auf andere Weise. Diese Community ist für GitHub-Benutzer gedacht, um Projekte zu diskutieren, zu lernen und Ideen miteinander zu teilen - nicht für Werbung oder andere Spam-ähnliche Inhalte. Inhalte, die wir für Spam halten, werden entfernt.

- **Urheberrechtlich geschützter oder illegaler Inhalt.** Posten Sie nur Ihre eigenen Inhalte. Sie sind ganz alleine dafür verantwortlich, was Sie posten. Wenn Sie etwas posten, das Sie nicht selbst erstellt haben, müssen Sie das Recht haben, es zu posten. Sie dürfen keine illegalen Inhalte, einschließlich urheber- und markenrechtswidriger Inhalte, Links zu illegalen Inhalten oder Methoden zur Umgehung des Gesetzes veröffentlichen.

- **Aktive Malware oder Exploits.** Die Zugehörigkeit zu dieser Gemeinschaft umfasst das Verbot, andere Mitglieder der Gemeinschaft auszunutzen. Es ist untersagt, unsere Plattform für die Bereitstellung von Exploits (z.B. Nutzung der Community als Mittel zur Bereitstellung von schädigenden ausführbaren Dateien) oder als Angriffsinfrastruktur (z.B. Organisation von Denial-of-Service-Angriffen oder Verwaltung von Befehls- und Kontroll-Servern) zu nutzen. Beachten Sie jedoch, dass wir die Veröffentlichung von Quellcode, der zur Entwicklung von Malware oder Exploits verwendet werden könnte, nicht verbieten, da die Veröffentlichung und Verbreitung eines solchen Quellcodes einen lehrreichen Wert hat und für die Sicherheits-Community einen klaren Nutzen darstellt.

- **Personen unter 13 Jahren.** Personen unter 13 Jahren verfügen möglicherweise nicht über ein Konto auf dem GitHub Community Forum (oder GitHub selbst). GitHub sammelt wissentlich keine Informationen von unseren Inhalten oder leitet sie speziell an Kinder unter 13 Jahren weiter. Wenn wir erfahren oder Grund zu der Annahme haben, dass Sie ein Benutzer sind, der unter 13 Jahre alt ist, müssen wir leider sowohl Ihre GitHub Community Forum- als auch GitHub.com- Konten schließen. Wir wollen Sie nicht davon abhalten, Code zu lernen, aber das sind die Regeln. Bitte beachten Sie unsere [Nutzungsbedingungen](/articles/github-terms-of-service/) mit Informationen zur Kontobeendigung.

- **Anderes Verhalten, das in einem professionellen Umfeld als unangemessen angesehen werden könnte.** Das GitHub Community Forum ist ein professionelles Umfeld und sollte als solches behandelt werden.

### Durchsetzung

#### *Was Mitglieder des GitHub Community Forums tun können*

- **Wenn ein Problem auftritt, melden Sie es.** Moderatoren haben besondere Befugnisse; sie sind für diese Community verantwortlich. Aber das sind Sie auch. Mit Ihrer Hilfe können die Moderatoren nicht nur Hausmeister oder Polizisten sein, sondern wirkliche Unterstützer der Community.

  Wenn Sie schlechtes Verhalten sehen, dann antworten Sie nicht darauf. Dies fördert lediglich das schlechte Verhalten durch dessen Anerkennung, verbraucht Ihre Energie und verschwendet jedermanns Zeit. Melden Sie es einfach über "Unangemessenen Inhalt melden" im Optionsmenü. Wenn genügend Meldungen eingehen, werden Maßnahmen ergriffen, entweder automatisch oder durch Intervention des Moderators.

#### Unsere Verantwortungen

Es gibt eine Reihe von Maßnahmen, die wir als Reaktion auf unangemessenes Verhalten oder unangemessene Inhalte ergreifen können. Es hängt in der Regel von den genauen Umständen eines bestimmten Falles ab. Wir sind uns darüber im Klaren, dass Personen manchmal aus verschiedenen Gründen unangemessene Dinge sagen oder tun. Vielleicht war ihnen nicht bewusst, wie ihre Worte aufgenommen werden würden. Oder vielleicht haben sie sich einfach von ihren Emotionen leiten lassen. Natürlich gibt es manchmal Leute, die nur Spam verbreiten oder Ärger verursachen wollen.

Jeder Fall erfordert einen anderen Ansatz, und wir versuchen, unsere Antwort auf die Bedürfnisse der jeweiligen Situation anzupassen. Wir überprüfen jede Situation von Fall zu Fall. Bei jedem Fall wird ein Team aus Vertretern verschiedener Bereiche den Inhalt und die umliegenden Fakten untersuchen und gegebenenfalls reagieren, wobei wir uns bei unserer Entscheidung an dem vorliegenden Verhaltenskodex orientieren.

Maßnahmen, die wir als Reaktion auf ein Flag oder eine Missbrauchsmeldung ergreifen können, umfassen unter anderem:
  - Inhaltsentfernung
  - Blockieren von Inhalten
  - Sperrung von Community-Forum-Konten
  - Kündigung von Community-Forum-Konten

Community-Forum-Moderatoren, welche den Verhaltenskodex nicht befolgen, oder nicht nach bestem Wissen und Glauben für dessen Einhaltung sorgen, können sich vorübergehenden oder dauerhaften Auswirkungen gegenübersehen, die durch andere Mitglieder der Projektleitung des Community Forums bestimmt wurden.

### Kontaktaufnahme mit GitHub-Mitarbeitern

If, for any reason, you want to contact GitHub Staff, the Community Managers, Administrators, or Moderators of this forum privately, you can use our [Support contact form](https://support.github.com/contact?tags=community-support). Contacting any member of GitHub Staff via channels other than the forum itself or the Support contact form is strongly discouraged and may be considered a violation of our prohibition against harassment.

Bemühen wir uns gemeinsam darum, das Forum zu einem sicheren und respektvollen Ort zu machen, an dem sich alle Besucher wohl fühlen und an dem sie sich beteiligen können.

### Rechtliche Hinweise

Ja, Juristenjargon ist langweilig, aber wir müssen uns - und damit auch Sie und Ihre Daten - vor feindseligen Leuten schützen. Wir haben [Nutzungsbedingungen](/articles/github-terms-of-service/) und eine[Datenschutzerklärung](/articles/github-privacy-statement/) die Ihr (und unser) Verhalten und Ihre Rechte im Zusammenhang mit Inhalten, Privatsphäre und Gesetzen, erläutern. Um diesen Service nutzen zu können, müssen Sie sich an unsere [Nutzungsbedingungen](/articles/github-terms-of-service/) und die [Datenschutzerklärung](/articles/github-privacy-statement/) halten.

Dieser Verhaltenskodex ändert nichts an unseren [Nutzungsbedingungen](/articles/github-terms-of-service/) und ist nicht als vollständige Liste gedacht. GitHub behält sich im Rahmen der [Nutzungsbedingungen ](/articles/github-terms-of-service/) die volle Diskretion vor, Inhalte zu entfernen oder Konten für Aktivitäten zu schließen, die "ungesetzlich, beleidigend, bedrohlich, verleumderisch, diffamierend, pornographisch, obszön oder anderweitig anstößig sind oder das geistige Eigentum einer Partei oder diese Nutzungsbedingungen verletzen". Dieser Verhaltenskodex beschreibt, wann wir diese Diskretion ausüben werden.
