---
title: Anti-Korruptionserklärung von GitHub
redirect_from:
  - /articles/github-anti-bribery-statement
versions:
  free-pro-team: '*'
---

GitHub hält an seinem Engagement für ethische Geschäftspraktiken fest, unter anderem durch das Verbot von Bestechung und Korruption. Wie [Transparency International](https://www.transparency.org/what-is-corruption#costs-of-corruption) führt Korruption zu erheblichen negativen Folgen, darunter:
- **politische**, da sie ein wesentliches Hindernis für Demokratie und Rechtsstaatlichkeit darstellt
- **wirtschaftliche**, durch die Ausbeutung des Volksvermögens
- **soziale**, da das Vertrauen der Menschen in die politische Gesellschaft, Institutionen und Entscheidungsträger untergraben wird
- **umweltpolitische**, denn sie begünstigt die Nichteinhaltung von Umweltgesetzen und -vorschriften.

Nach Angaben der [Weltbank](https://www.worldbank.org/en/topic/governance/brief/anti-corruption) zahlten Unternehmen und Einzelpersonen im Jahr 2017 schätzungsweise 1,5 Billionen US-Dollar an Bestechungsgeldern.

### GitHub-Richtlinien zum Verbot von Korruption

GitHub macht das Engagement zur Bekämpfung von Korruption durch eine Reihe von Unternehmensrichtlinien deutlich. Als Teil der Microsoft-Familie ist GitHub auch der Anti-Korruptions-Richtlinie von Microsoft verpflichtet, die zusätzlich zu den hier beschriebenen Richtlinien für alle GitHub-Mitarbeiter und -Auftragnehmer gilt.

Die **Ethikrichtlinie** von GitHub untersagt es Mitarbeitern und Auftragnehmern, sich an Bestechung oder Korruption zu beteiligen oder zu solchen Handlungen beizutragen, und legt Bestimmungen zur Protokollführung fest:
> Es ist Ihnen untersagt, Zahlungen in irgendeiner anderen Form von Wert zu leisten, anzubieten, zu versprechen, zu akzeptieren oder zu autorisieren — auch nicht an Personen in Macht- oder Autoritätsposition, wie z. B. Regierungsbeamte oder bei kommerziellen Transaktionen—, um Geschäfte zu erlangen oder aufrechtzuerhalten oder um andere unzulässige Vorteile für GitHub oder Microsoft zu erzielen. Es ist Ihnen ebenfalls untersagt, Bestechungsgelder, Schmiergelder oder andere unzulässige Barzahlungen zu verlangen oder entgegenzunehmen. ... [GitHub-Mitarbeiter] sind verpflichtet, genaue und faire Aufzeichnungen über alle Transaktionen zu führen, die im Auftrag von GitHub getätigt werden – z. B. durch die Aufbewahrung von Quittungen und die Bereitstellung genauer Beschreibungen Ihrer Ausgaben – oder jede andere Transaktion, die die Veräußerung oder Übertragung von GitHub-Assets beinhaltet. Such actions are required by the U.S. Foreign Corrupt Practices Act, the U.K. Bribery Act of 2010, and anti-bribery laws of other jurisdictions in which GitHub does business and are also simply the right thing to do.

Die Ethikrichtlinie von GitHub beschäftigt sich detailliert mit bestimmten Sachverhalten, darunter Geschenke, Reisen und Unterhaltungsangebote; die Begünstigung von Zahlungen; wohltätige Spenden; berufliche Stellenangebote; und die Zusammenarbeit mit Repräsentanten, sowie mit der Frage, wer als Regierungsbeamter gilt.

Die Verhaltensrichtlinien von GitHub verbieten:
> Die Bestechung von Regierungsbeamten oder anderen Personen, um sich einen unlauteren Vorteil zu verschaffen, sowie die Annahme von Bestechungsgeldern jeglicher Art.

Die **Richtlinien zu Geschenken und Unterhaltung** von GitHub erklärt, dass Bestechung im Zusammenhang mit Reisen oder Unterhaltung nicht erlaubt ist, und nennt Beispiele, um unzulässiges Verhalten zu veranschaulichen. Die Richtlinie beschreibt angemessene und unsachgemäße Geschenke, Reise- und Unterhaltungskosten; Unternehmensprozesse für die Schenkung durch GitHub-Direktoren, leitende Angestellte, Mitarbeiter und Agenten sowie Bestimmungen für die Protokollierung, Strafen; und die Meldung von Verstößen. Es enthält klare finanzielle Schwellenwerte für Geschenke sowie jährliche Beschränkungen, mit begrenzten Ausnahmen für Geschenke, die vom zuständigen Management genehmigt wurden. Die Bestimmungen sind für Mitarbeiter und Auftragnehmer von GitHub leicht zugänglich und klar formuliert.

### Schulung unserer Mitarbeiter

GitHub-Mitarbeiter sind verpflichtet, an Schulungen zu Korruption, einschließlich Bestechung, teilzunehmen. Darüber hinaus bieten wir zusätzliche Schulungen für besonders relevante Personen und Teams an, wie z. B. unser Vertriebsteam. The training explains relevant elements of the U.S. Die Schulung erläutert relevante Elemente des U.S. Foreign Corrupt Practices Act und des U.K. Bribery Act von 2010. Bribery Act of 2010. Ein Beispiel,
- Definition und strukturelle Auswirkungen von Korruption
- eingschlossene Personen, darunter
   - Beamte oder andere Personen in einer Machtposition
   - Dritte Parteien
- die Art der betroffenen Aktivitäten, einschließlich
   - Bargeld, Geschenke, Reisen und Unterhaltung
   - Schmiergelder
   - karitative Spenden und Sponsoring
- zu welchem Zweck, einschließlich
   - Absicht
   - unzulässiger Nutzen oder Einflussnahme
- Sorgfaltspflicht und Warnsignale (rote Flaggen)
- Bestimmungen zur Protokollführung

Darüber hinaus behandelt die Schulung die internen Richtlinien von GitHub im Zusammenhang mit Korruptionsbekämpfung und Bestechung, einschließlich unserer Nichtvergeltungs- (Whistleblower-) Politik.

While the U.S. FCPA is focused on interactions with government officials, the U.K. Bribery Act is broader and extends to bribing anyone, regardless of whether they are a government official. Beide Gesetze können auf die Aktionen von GitHub in anderen Teilen der Welt angewendet werden. Die Richtlinien von GitHub verbieten die Bestechung von jedermann, unabhängig davon, wo auf der Welt er sich befindet.

### Einbindung unserer Partner
- Die standardmäßigen**Wiederverkaufsvereinbarungen mit Channel-Partnern** von GitHub enthalten verbindliche Antikorruptionsklauseln. GitHub wird in Zukunft von unseren Channel-Partnern verlangen, dass sie sich zur Einhaltung dieser Anti-Korruptions-Erklärung verpflichten.
- Zukünftig erfordern die **Lieferantenverträge** von GitHub eine Verpflichtung zur Einhaltung des Microsoft-Verhaltenskodex für Lieferanten oder dieser Anti-Korruptionserklärung.
