---
title: Zusätzliche Produktbedingungen für GitHub
versions:
  free-pro-team: '*'
---

Wenn Sie ein Konto erstellen, erhalten Sie Zugriff auf viele verschiedene Features und Produkte, die alle Teil des Dienstes sind. Da viele dieser Features und Produkte unterschiedliche Funktionen bieten, erfordern sie möglicherweise zusätzliche Geschäftsbedingungen, die für dieses Feature oder dieses Produkt spezifisch sind. Im Folgenden finden Sie eine Liste dieser Features und Produkte mit den jeweiligen zusätzlichen Regeln, die für diese Teile des Dienstes gelten.

Ihre Nutzung von GitHub unterliegt den für Sie geltenden Bedingungen (die "Vereinbarung") sowie den folgenden zusätzlichen Produktbedingungen von GitHub (die "zusätzlichen Bedingungen"). Durch Ihre Zustimmung zur Vereinbarung und Verwendung zusätzlicher Produkte und Features erklären Sie sich auch mit diesen zusätzlichen Bedingungen einverstanden. Jeder Verstoß gegen die zusätzlichen Bedingungen ist ein Verstoß gegen die Vereinbarung. Für in Großbuchstaben gesetzte Begriffe, die nicht in den Zusatzbegriffen definiert werden, gilt die ihnen in der Vereinbarung zugewiesene Bedeutung.

### 1. Marktplatz

Wenn Sie ein Entwickler-Produkt über GitHub Marketplace auflisten, müssen Sie der [ GitHub Marketplace-Entwicklervereinbarung](/github/site-policy/github-marketplace-developer-agreement)zustimmen, bevor Sie das Projekt zur Auflistung einreichen.

Wenn Sie Entwicklerprodukte über den GitHub Marketplace erwerben, unterliegt dieser Kauf den [Nutzungsbedingungen für GitHub Marketplace](/github/site-policy/github-marketplace-terms-of-service). Ihre Nutzung des GitHub-Marktplatzes wird durch diese Vereinbarung sowie durch die [Nutzungsbedingungen für GitHub Marketplace](/github/site-policy/github-marketplace-terms-of-service) geregelt.

### 2. Integration von Drittsystemen

#### a. Anwendungserstellung
Wenn Sie eine Drittanbieteranwendung oder ein anderes Entwicklerprodukt erstellen, das persönliche Benutzerinformationen oder benutzergenerierte Inhalte sammelt und über das GitHub-API, den OAuth-Mechanismus oder auf andere Weise in den Dienst integriert wird ("Entwicklerprodukt"), und diese(s) anderen Benutzern zur Verfügung stellen, müssen Sie die folgenden Anforderungen erfüllen:
- Sie sind verpflichtet, diese Vereinbarung und die Datenschutzerklärung von GitHub einzuhalten.
- Sofern nicht anderweitig, wie z. B. gesetzlich oder im Rahmen einer Lizenz, gestattet, müssen Sie Ihre Nutzung personenbezogener Daten von Benutzern oder benutzergenerierter Inhalte auf den Zweck beschränken, für den der Benutzer die Erfassung gestattet hat.
- Sie müssen alle vertretbaren und für die Risiken angemessenen Sicherheitsmaßnahmen ergreifen, unter anderem gegen versehentliche oder unrechtmäßige Vernichtung, versehentlichen Verlust, Veränderung, unbefugte Offenlegung und unbefugten Zugriff, die durch die Verarbeitung personenbezogener Daten von Benutzern oder benutzergenerierter Inhalte entstehen.
- Sie dürfen nicht vorgeben, personenbezogene Daten von Benutzern oder benutzergenerierte Inhalte im Namen von GitHub zu erfassen, und müssen Benutzer ausreichend über Ihre Datenschutzverfahren informieren, beispielsweise durch Veröffentlichung einer Datenschutzrichtlinie.
- Sie müssen Benutzern ein Verfahren zum Löschen personenbezogener Daten von Benutzern oder benutzergenerierter Inhalte bereitstellen, die Sie über GitHub erfasst haben, sobald diese nicht länger für die konkreten, beschränkten Zwecke benötigt werden, für die der Benutzer die Erfassung gestattet hat, es sei denn, die Aufbewahrung wird gesetzlich verlangt oder anderweitig wie beispielsweise durch eine Lizenz gestattet.

#### b. Verwendung von Drittanbieteranwendungen
Sie können für die Nutzung, den Zugriff und die Offenlegung der Inhalte in Ihren Repositorys, einschließlich Ihrer privaten Repositorys, eine Entwicklerproduktautorisierung gewähren. Einige Entwicklerprodukte sind über [GitHub Marketplace](https://github.com/marketplace) verfügbar. Bestimmte Entwicklerprodukte lassen sich für die Ausführung automatisierter Aufgaben verwenden, und in vielen Fällen können mehrere Benutzer die Aktionen eines Entwicklerprodukts steuern. Wenn Sie jedoch über Ihr Konto ein Entwicklerprodukt erwerben und/oder einrichten oder Inhaber eines Kontos mit integriertem Entwicklerprodukt sind, haften Sie für die Aktionen des Entwicklerprodukts, die in Ihrem oder über Ihr Konto ausgeführt werden. Bitte beachten Sie unsere [Datenschutzerklärung](/github/site-policy/github-privacy-statement#third-party-applications) weitere Informationen darüber, wie wir Daten mit Entwicklerprodukten teilen.

**GitHub gibt keinerlei Garantien im Zusammenhang mit Entwicklerprodukten und haftet nicht für die Weitergabe an Dritte, denen Sie den Zugriff auf Kundeninhalte gestatten. Ihre Nutzung von Drittanbieteranwendungen erfolgt auf Ihr alleiniges Risiko.**

### 3. Git LFS-Unterstützung

Wenn Sie Git Large File Storage ("Git LFS") auf Ihrem Account aktivieren, können Sie große Dateien abrufen, modifizieren und pushen, so wie Sie es von jeder anderen durch Git verwalteten Datei erwarten würden. Ihr Konto verfügt über eine bestimmte Menge an Bandbreite und Speicherplatz für die Verwendung mit Git LFS, die Sie in der [Git LFS-Dokumentation](/github/managing-large-files/about-storage-and-bandwidth-usage) nachlesen können. Die Git LFS Bandbreite und Speichernutzung werden in Ihren [Kontoeinstellungen](https://github.com/settings/billing) angezeigt. Wenn Sie Git LFS über Ihre zugewiesene Bandbreite und Ihren Speicherplatz hinaus verwenden möchten, können Sie [Zusätzliche Datenpakete kaufen](/github/setting-up-and-managing-billing-and-payments-on-github/upgrading-git-large-file-storage).

### 4. Pages

Jedes GitHub-Konto umfasst Zugriff auf den [statischen GitHub Pages Hosting-Dienst](/github/working-with-github-pages/about-github-pages). Dieser Hosting-Dienst dient zum Hosten statischer Webseiten für alle Benutzer, in erster Linie aber als Schaufenster für persönliche und organisatorische Projekte. Auf Pages sind bestimmte Monetarisierungsaktivitäten wie Spendenschaltflächen oder Crowdfunding-Links zulässig.

GitHub Pages unterliegen Bandbreiten- und Nutzungsbeschränkungen und sind für bestimmte Zwecke mit hoher Bandbreite oder sonstige verbotene Zwecke nicht geeignet. Die [GitHub Pages-Richtlinien](/github/working-with-github-pages/about-github-pages) enthalten weitere Informationen zu diesem Thema. GitHub behält sich das Recht vor, jederzeit ohne Haftung beliebige GitHub-Subdomains zurückzufordern.

### 5. Actions und Pakete

#### a. Verwendung von Actions
GitHub Actions ermöglicht es Ihnen, benutzerdefinierte Softwareentwicklungs-Lebenszyklus-Workflows direkt in Ihrem GitHub Repository zu erstellen. Jedes Konto umfasst die mitgelieferten Berechnungs- und Speichermengen für die Verwendung mit Actions, je nach Ihrem Kontenplan, entsprechend der [Actions-Dokumentation](/github/automating-your-workflow-with-github-actions/about-github-actions#about-github-actions). Ihre Nutzungsberechnung für Actions wird unter [your Account settings (Ihre Kontoeinstellungen)](https://github.com/settings/billing) angezeigt, und Sie werden per E-Mail benachrichtigt, bevor Sie das Limit Ihrer inbegriffenen Menge erreichen. Wenn Sie Actions über die in Ihrem Paket enthaltenen Datenmengen hinaus verwenden möchten, können Sie [enable overages (Überschreitungen aktivieren)](/github/setting-up-and-managing-billing-and-payments-on-github/about-billing-for-github-actions) aktivieren.

Die Nutzungsberechnung für enthaltene und bezahlte Mengen wird in Minuten anhand der Art von Aktionen berechnet, die Sie ausführen (z.B. Linux, Windows, macOS). Die Minuten, die für den Auftrag oder die Aufgabe jeder Aktion verwendet werden, werden auf die nächste Minute aufgerundet. Bei inbegriffenen Mengen und abhängig von der Art der Aktion kann ein Multiplikator auf die Zeit angewandt werden, die für die Ausführung jedes Auftrags oder jeder Aufgabe benötigt wird, bevor auf die nächste Minute aufgerundet wird. Zusätzliche Minuten werden zum [angegebenen Preis pro Minute ](https://github.com/features/actions) basierend auf der Art der von Ihnen ausgeführten Aktionen berechnet. Actions und Packages teilen sich Speicher, und Ihre Speichernutzung wird in Ihren [Kontoeinstellungen](https://github.com/settings/billing) angezeigt. Weitere Informationen zur Nutzungsberechnung der mitgelieferten Speichermengen finden Sie in der [Actions-Dokumentation](/github/automating-your-workflow-with-github-actions/about-github-actions#about-github-actions).

Actions und jegliche Elemente des Action-Dienstes dürfen nicht unter Missachtung der Vereinbarung, der [Richtlinie für die zulässige Verwendung](/github/site-policy/github-acceptable-use-policies), oder der GitHub-Actions [Diensteinschränkungen](/github/automating-your-workflow-with-github-actions/about-github-actions#usage-limits) verwendet werden. Actions sollte außerdem nicht für Folgendes verwendet werden:
- cryptomining;
- die Nutzung unserer Server, um Dienste, Geräte, Daten, Konten oder Netzwerke zu stören oder zu versuchen, diese zu stören, oder um unbefugten Zugang zu erlangen oder dies zu versuchen (es sei denn, dies wurde im Rahmen des [GitHub Bug Bounty-Programms](https://bounty.github.com) genehmigt)
- the provision of a stand-alone or integrated application or service offering Actions or any elements of Actions for commercial purposes;
- any activity that places a burden on our servers, where that burden is disproportionate to the benefits provided to users (for example, don't use Actions as a content delivery network or as part of a serverless application, but a low benefit Action could be ok if it’s also low burden); or
- jegliche weiteren Aktivitäten ohne Bezug zu Produktion, Tests, Bereitstellung oder Veröffentlichung des Software-Projekts, das mit dem Repository verknüpft ist, in dem GitHub Actions verwendet werden.

Um Verstöße gegen diese Einschränkungen und Missbrauch von GitHub Actions zu verhindern, kann GitHub Ihre Verwendung von GitHub Actions überwachen. Der Missbrauch von GitHub Actions kann zur Kündigung von Aufträgen oder zu Beschränkungen Ihrer Möglichkeiten bei der Nutzung von GitHub Actions führen.

#### b. Verwendung von Packages
GitHub Packages kann zum Herunterladen, Veröffentlichen und Verwalten von Content-Paketen verwendet werden. Jeder Kontoplan umfasst die mitgelieferten Bandbreiten- und Speichermengen für die Verwendung mit Packages, entsprechend der [Packages-Dokumentation](/github/managing-packages-with-github-package-registry/about-github-package-registry). Der Speicherplatz für Actions und Packages wird von den beiden Dienst-Funktionen gemeinsam genutzt. Die Speicher- und Bandbreitennutzung wird unter [Kontoeinstellungen](https://github.com/settings/billing) angezeigt, und Sie werden per E-Mail benachrichtigt, bevor Sie das Limit Ihrer inbegriffenen Menge erreichen. Wenn Sie Packages über die in Ihrem Paket enthaltenen Bandbreiten- und Speichermengen hinaus verwenden möchten, können Sie [Überschreitungen aktivieren](/github/setting-up-and-managing-billing-and-payments-on-github/about-billing-for-github-packages) aktivieren.

Die Bandbreitennutzung wird auf der Grundlage der Datenmenge berechnet, die über Packages aus Ihren Repositorys übertragen wird, jedoch zählen Package-Transfers über Actions nicht zu Ihren inkludierten oder bezahlten Mengen. Die Bandbreitennutzung von Packages wird durch die [Akzeptablen Nutzungsrichtlinien](/github/site-policy/github-acceptable-use-policies#7-excessive-bandwidth-use) begrenzt und die enthaltenen Bandbreitenmengen sind abhängig von Ihrem [Kontoplan](https://github.com/pricing).

Der Speicherplatz für Actions und Packages wird von den beiden Dienst-Funktionen gemeinsam genutzt. Die Speichernutzung wird im Laufe des Monats als gewichteter Durchschnitt berechnet und nicht jeden Monat zurückgesetzt. Die inbegriffenen Speichermengen für öffentliche und private Repositorys sind unterschiedlich, und die inbegriffenen Mengen für private Repositorys hängen von Ihrem [Kontoplan](https://github.com/pricing) ab.

#### c. Zahlung und Abrechnung für Actions und Packages
Die Abrechnung für Actions und Packages erfolgt auf Basis der Nutzung. Zusätzliche Mengen von Actions oder Packages können nicht separat erworben werden.  Als Kunde mit monatlicher Rechnungsstellung müssen Sie eine Zahlungsart hinterlegt haben, mit der Sie für zusätzliche Mengen dieser Servicefunktionen zahlen können. Die Abrechnung erfolgt auf monatlicher, fortlaufender Basis auf der Grundlage Ihres Verbrauchs im Vormonat, es sei denn, die Abrechnung erfolgt per Rechnung. Rechnungskunden müssen die Gebühren innerhalb von dreißig (30) Tagen ab dem Datum der GitHub-Rechnung zahlen. Für Kunden, die für Service-Feature-Überschreitungen im Voraus bezahlen, werden nicht verwendete Prepaid-Minuten nicht auf den nächsten Abrechnungszeitraum übertragen und nicht zurückerstattet.

Sie können ein monatliches Ausgabelimit Ihren [Kontoeinstellungen](https://github.com/settings/billing/cost_management) festlegen. Sie werden im Voraus per E-Mail benachrichtigt, wenn Sie die Grenze Ihrer enthaltenen Mengen und die angegebene Ausgabengrenze Ihrer bezahlten Zusatzmengen erreichen.

### 6. Learning Lab

**Registrierung.** Um die Registrierung im, Learning Lab for Organisationen abzuschließen, erklären Sie sich damit einverstanden, eine separate Organisation für Learning Lab-Zwecke zu erstellen, und Sie ermächtigen uns, dieser Organisation in Ihrem Namen Learning Lab-Kursmaterialien hinzuzufügen.

**Learning Lab-Kursmaterialien.** Alle von GitHub bereitgestellten Kursmaterialien sind alleiniges Eigentum von GitHub, wobei GitHub Ihnen jedoch eine weltweite, nicht exklusive, nicht übertragbare, kostenlose Lizenz mit begrenzter Laufzeit zum Kopieren, Verwalten, Nutzen und Ausführen der entsprechenden Kursmaterialien ausschließlich für Ihre internen geschäftlichen Zwecke im Zusammenhang mit der Nutzung von Learning Lab gewährt. Die Gewährung dieser Lizenz kann zusätzlichen Open-Source-Lizenzvereinbarungen unterliegen, die ggf. zusammen mit dem Quellcode bereitstellt werden.  Die von Ihnen erstellten Kursmaterialien gehören ausschließlich Ihnen, Sie gewähren GitHub jedoch eine weltweite, nicht exklusive, unbefristete, nicht übertragbare, gebührenfreie Lizenz zum Kopieren, Verwalten, Nutzen, Hosten und Ausführen (sofern zutreffend) solcher Kursmaterialien, auf dem Dienst. Ihre Nutzung von GitHub-Kursmaterialien und Ihre Erstellung und Speicherung eigener Kursmaterialien stellen kein Miteigentum am jeweiligen geistigen Eigentum einer der Parteien durch die andere Partei dar.

**Datenschutz.** Learning Lab kann persönliche Daten erfassen. Sie können in Ihren Profileinstellungen von GitHub.com festlegen, welche Informationen Learning Lab erfasst. Wenn Learning Lab personenbezogene Daten im Auftrag von GitHub erfasst, verarbeitet GitHub diese Informationen in Übereinstimmung mit der [GitHub-Datenschutzerklärung](/github/site-policy/github-privacy-statement). Wenn Sie sich über Learning Lab für einen privaten Kurs anmelden oder einen privaten Kurs absolvieren, kann GitHub Ihre Registrierungsinformationen und den Kursfortschritt bis zum Abschluss mit den Organisationsadministratoren teilen. Dazu gehören individuelle Daten wie Ihr GitHub-Benutzername, das Anfangsdatum des Kurses und das Enddatum des Kurses. Kursabschlussdaten können auch in aggregierter Form dargestellt werden, um Verbesserungen des Kursinhalts zu unterstützen.

### 7. Connect

Für den Zugriff auf GitHub Connect muss der Kunde über mindestens ein (1) Konto auf GitHub.com und eine (1) lizenzierte Instanz der Software verfügen. GitHub Connect kann für die Ausführung automatisierter Aufgaben genutzt werden. Darüber hinaus können mit GitHub Connect bestimmte Aktionen von mehreren Benutzern gesteuert werden. Der Kunde haftet für Aktionen, die in seinen oder über seine Konten ausgeführt werden. GitHub kann zwecks Bereitstellung und Verbesserung des Features Informationen über die Nutzung von GitHub Connect durch den Kunden erfassen. Der Kunde gestattet es GitHub mit seiner Nutzung von GitHub Connect, geschützte Daten des GitHub Enterprise Server-Kontos des Kunden zu erfassen, darunter Daten in privaten Repositorys und personenbezogene Daten von Benutzern (gemäß Definition in der GitHub-Datenschutzerklärung). Des Weiteren gestattet der Kunde die Übermittlung identifizierender Instanzinformationen an GitHub über GitHub Connect, wobei für diese Informationen die GitHub-Datenschutzerklärung gilt.

### 8. Sponsorenprogramm

In order to become a Sponsored Developer, you must agree to the [GitHub Sponsors Program Additional Terms](/github/site-policy/github-sponsors-additional-terms).

### 9. GitHub Advanced Security

Mit GitHub Advanced Security können Sie Sicherheitslücken durch anpassbare und automatisierte semantische Codeanalyse identifizieren. GitHub Advanced Security ist pro Benutzer lizenziert. Wenn Sie GitHub Advanced Security als Teil von GitHub Enterprise Cloud verwenden, erfordern viele Funktionen von GitHub Advanced Security, einschließlich des automatisierten Code-Scannens privater Repositorys, auch die Verwendung von GitHub Actions. Die Abrechnung für die Nutzung von GitHub Actions erfolgt nutzungsbasiert und unterliegt den [GitHub Actions-Bedingungen](/github/site-policy/github-additional-product-terms#c-payment-and-billing-for-actions-and-packages).

### 10. Dependabot Preview

Ihre Nutzung von Dependabot Preview wird durch eine separate [Nutzungsbedingung](https://dependabot.com/terms) und [Datenschutzerklärung](https://dependabot.com/privacy) geregelt.

### 11. Spectrum

Your use of Spectrum is governed by the GitHub [Terms of Service](/github/site-policy/github-terms-of-service) and [Privacy Statement](/github/site-policy/github-privacy-statement).

### 12. Advisory Database

#### a. Lizenzvergabe an uns

We need the legal right to submit your contributions to the GitHub Advisory Database into public domain datasets such as the [National Vulnerability Database](https://nvd.nist.gov/) and to license the GitHub Advisory Database under open terms for use by security researchers, the open source community, industry, and the public. You agree to release your contributions to the GitHub Advisory Database under the [Creative Commons Zero license](https://creativecommons.org/publicdomain/zero/1.0/).

#### b. Lizenz für das GitHub Advisory Database

The GitHub Advisory Database is licensed under the [Creative Commons Attribution 4.0 license](https://creativecommons.org/licenses/by/4.0/). The attribution term may be fulfilled by linking to the GitHub Advisory Database at <https://github.com/advisories> or to individual GitHub Advisory Database records used, prefixed by <https://github.com/advisories>.

